
PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for doctors
-- ----------------------------
DROP TABLE IF EXISTS "doctors";
CREATE TABLE "doctors" (
"iddoctor"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"namedoctor"  varchar(10),
"day1"  varchar(10),
"day2"  varchar(10),
"day3"  varchar(10),
"day4"  varchar(10),
"day5"  varchar(10),
"speciality_idspeciality"  bigint NOT NULL,
"node_order"  bigint,
"treatments_idtreatments"  bigint,
"login"  varchar(32),
FOREIGN KEY ("login") REFERENCES "sec_users" ("login"),
FOREIGN KEY ("treatments_idtreatments") REFERENCES "treatments" ("idtreatments"),
FOREIGN KEY ("speciality_idspeciality") REFERENCES "speciality" ("idspeciality")
)

;

-- ----------------------------
-- Records of doctors
-- ----------------------------
INSERT INTO "doctors" VALUES (1, 'Megan', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 3, 100, 1, 'megan');
INSERT INTO "doctors" VALUES (2, 'Mary', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 2, 101, 1, 'mary');
INSERT INTO "doctors" VALUES (3, 'Joane', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 5, 102, 1, 'joane');
INSERT INTO "doctors" VALUES (4, 'Paul', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 1, 103, 2, 'paul');

-- ----------------------------
-- Table structure for event
-- ----------------------------
DROP TABLE IF EXISTS "event";
CREATE TABLE "event" (
"idevent"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"title"  varchar(300),
"descr"  text,
"start_date"  date,
"start_time"  time,
"end_date"  date,
"end_time"  time,
"recurr"  varchar(1),
"period"  varchar(1),
"categ"  bigint,
"id_api"  varchar(255),
"id_event_google"  varchar(255),
"recur_info"  varchar(255),
"event_color"  varchar(255),
"creator"  varchar(255),
"reminder"  varchar(255),
"doctor_iddoctor"  bigint NOT NULL,
"patients_idpatient"  bigint,
"event_period"  bigint,
"idevent_status"  bigint,
"idevent_priority"  bigint,
FOREIGN KEY ("doctor_iddoctor") REFERENCES "doctors" ("iddoctor"),
FOREIGN KEY ("event_period") REFERENCES "event" ("idevent"),
FOREIGN KEY ("idevent_priority") REFERENCES "event_priority" ("idevent_priority"),
FOREIGN KEY ("idevent_status") REFERENCES "event_status" ("idevent_status"),
FOREIGN KEY ("patients_idpatient") REFERENCES "patients" ("idpatient")
)

;

-- ----------------------------
-- Records of event
-- ----------------------------
INSERT INTO "event" VALUES ('4469', 'Francisco Chang', ' ', '2018-02-21', '08:00:00', '2018-02-21', '10:00:00', 'N', 'D', '4', '', null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '1', '13', null, '8', '1');
INSERT INTO "event" VALUES ('4472', 'Francisco Chang', ' ', '2018-02-21', '08:15:00', '2018-02-21', '08:30:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '13', '4469', '8', '1');
INSERT INTO "event" VALUES ('4475', 'Francisco Chang', ' ', '2018-02-21', '08:30:00', '2018-02-21', '08:45:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '13', '4469', '9', '2');
INSERT INTO "event" VALUES ('4478', 'Francisco Chang', ' ', '2018-02-21', '08:45:00', '2018-02-21', '09:00:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '13', '4469', '9', '1');
INSERT INTO "event" VALUES ('4481', 'Francisco Chang', ' ', '2018-02-21', '09:00:00', '2018-02-21', '09:15:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '13', '4469', '9', '1');
INSERT INTO "event" VALUES ('4484', 'Francisco Chang', ' ', '2018-02-21', '09:15:00', '2018-02-21', '09:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '13', '4469', '8', '1');
INSERT INTO "event" VALUES ('4487', 'Francisco Chang', ' ', '2018-02-21', '09:30:00', '2018-02-21', '09:45:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '13', '4469', '8', '1');
INSERT INTO "event" VALUES ('4490', 'Francisco Chang', ' ', '2018-02-21', '09:45:00', '2018-02-21', '10:00:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '13', '4469', '8', '1');
INSERT INTO "event" VALUES ('4574', '7 - Frederique Citeaux', '', '2018-02-21', '10:00:00', '2018-02-21', '10:15:00', 'N', 'D', '2', '', '', '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', '', '', '1', '7', null, '8', '1');
INSERT INTO "event" VALUES ('4846', '6 - Hanna Moos', ' ', '2018-02-26', '08:00:00', '2018-02-26', '08:15:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4848', '17 - Sven Ottlieb', ' ', '2018-02-26', '08:15:00', '2018-02-26', '08:30:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '17', null, '8', '1');
INSERT INTO "event" VALUES ('4850', '23 - Martine Rance', ' ', '2018-02-26', '08:30:00', '2018-02-26', '08:45:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '23', null, '8', '1');
INSERT INTO "event" VALUES ('4852', '30 - Rita Muller', ' ', '2018-02-26', '08:45:00', '2018-02-26', '09:00:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4854', '14 - Yang Wang', ' ', '2018-02-26', '09:00:00', '2018-02-26', '09:15:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('4856', '8 - Martin Sommer', ' ', '2018-02-26', '09:15:00', '2018-02-26', '09:30:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '8', null, '9', '1');
INSERT INTO "event" VALUES ('4858', '9 - Laurence Lebihan', ' ', '2018-02-26', '09:30:00', '2018-02-26', '09:45:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '9', null, '8', '1');
INSERT INTO "event" VALUES ('4860', '4 - Thomas Hardy', ' ', '2018-02-26', '09:45:00', '2018-02-26', '10:00:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '4', null, '8', '2');
INSERT INTO "event" VALUES ('4862', '25 - Peter Franken', ' ', '2018-02-26', '10:00:00', '2018-02-26', '10:15:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '25', null, '8', '1');
INSERT INTO "event" VALUES ('4864', '27 - Paolo Accorti', ' ', '2018-02-26', '10:15:00', '2018-02-26', '10:30:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '27', null, '8', '1');
INSERT INTO "event" VALUES ('4866', '5 - Christina Berglund', ' ', '2018-02-26', '10:30:00', '2018-02-26', '10:45:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '5', null, '9', '2');
INSERT INTO "event" VALUES ('4868', '3 - Antonio Moreno', ' ', '2018-02-26', '10:45:00', '2018-02-26', '11:00:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '3', null, '8', '1');
INSERT INTO "event" VALUES ('4870', '6 - Hanna Moos', ' ', '2018-02-26', '11:00:00', '2018-02-26', '11:15:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4872', '29 - Paul Henriot', ' ', '2018-02-26', '11:15:00', '2018-02-26', '11:30:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '29', null, '8', '1');
INSERT INTO "event" VALUES ('4874', '14 - Yang Wang', ' ', '2018-02-26', '11:30:00', '2018-02-26', '11:45:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('4876', '3 - Antonio Moreno', ' ', '2018-02-26', '11:45:00', '2018-02-26', '12:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '3', null, '8', '2');
INSERT INTO "event" VALUES ('4878', '20 - Roland Mendel', ' ', '2018-02-26', '12:00:00', '2018-02-26', '12:15:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '20', null, '8', '1');
INSERT INTO "event" VALUES ('4880', '23 - Martine Rance', ' ', '2018-02-26', '12:15:00', '2018-02-26', '12:30:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '23', null, '9', '1');
INSERT INTO "event" VALUES ('4882', '13 - Francisco Chang', ' ', '2018-02-26', '12:30:00', '2018-02-26', '12:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '13', null, '8', '1');
INSERT INTO "event" VALUES ('4884', '25 - Peter Franken', ' ', '2018-02-26', '12:45:00', '2018-02-26', '13:00:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '25', null, '8', '1');
INSERT INTO "event" VALUES ('4886', '11 - Victoria Ashworth', ' ', '2018-02-26', '13:00:00', '2018-02-26', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '11', null, '8', '1');
INSERT INTO "event" VALUES ('4888', '6 - Hanna Moos', ' ', '2018-02-26', '13:15:00', '2018-02-26', '13:30:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4890', '20 - Roland Mendel', ' ', '2018-02-26', '13:30:00', '2018-02-26', '13:45:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '20', null, '8', '1');
INSERT INTO "event" VALUES ('4892', '17 - Sven Ottlieb', ' ', '2018-02-26', '13:45:00', '2018-02-26', '14:00:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '17', null, '8', '1');
INSERT INTO "event" VALUES ('4894', '28 - Mary Saveley', ' ', '2018-02-26', '14:00:00', '2018-02-26', '14:15:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '28', null, '8', '1');
INSERT INTO "event" VALUES ('4896', '12 - Patricio Simpson', ' ', '2018-02-26', '14:15:00', '2018-02-26', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '12', null, '8', '1');
INSERT INTO "event" VALUES ('4898', '26 - Carine Schmitt', ' ', '2018-02-26', '14:30:00', '2018-02-26', '14:45:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '26', null, '8', '1');
INSERT INTO "event" VALUES ('4900', '3 - Antonio Moreno', ' ', '2018-02-26', '14:45:00', '2018-02-26', '15:00:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '3', null, '8', '1');
INSERT INTO "event" VALUES ('4902', '23 - Martine Rance', ' ', '2018-02-26', '15:00:00', '2018-02-26', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '23', null, '8', '1');
INSERT INTO "event" VALUES ('4904', '29 - Paul Henriot', ' ', '2018-02-26', '15:15:00', '2018-02-26', '15:30:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '29', null, '8', '1');
INSERT INTO "event" VALUES ('4906', '14 - Yang Wang', ' ', '2018-02-26', '15:30:00', '2018-02-26', '15:45:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('4908', '30 - Rita Muller', ' ', '2018-02-26', '15:45:00', '2018-02-26', '16:00:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4910', '20 - Roland Mendel', ' ', '2018-02-26', '16:00:00', '2018-02-26', '16:15:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '20', null, '8', '1');
INSERT INTO "event" VALUES ('4912', '16 - Elizabeth Brown', ' ', '2018-02-26', '16:15:00', '2018-02-26', '16:30:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '16', null, '8', '1');
INSERT INTO "event" VALUES ('4914', '12 - Patricio Simpson', ' ', '2018-02-26', '16:30:00', '2018-02-26', '16:45:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '12', null, '8', '2');
INSERT INTO "event" VALUES ('4916', '5 - Christina Berglund', ' ', '2018-02-26', '16:45:00', '2018-02-26', '17:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '5', null, '8', '1');
INSERT INTO "event" VALUES ('4918', '7 - Frederique Citeaux', ' ', '2018-02-26', '17:00:00', '2018-02-26', '17:15:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '7', null, '8', '1');
INSERT INTO "event" VALUES ('4920', '10 - Elizabeth Lincoln', ' ', '2018-02-26', '17:15:00', '2018-02-26', '17:30:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '10', null, '8', '1');
INSERT INTO "event" VALUES ('4922', '3 - Antonio Moreno', ' ', '2018-02-26', '17:30:00', '2018-02-26', '17:45:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '3', null, '8', '1');
INSERT INTO "event" VALUES ('4924', '28 - Mary Saveley', ' ', '2018-02-26', '17:45:00', '2018-02-26', '18:00:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '28', null, '8', '1');
INSERT INTO "event" VALUES ('4926', '26 - Carine Schmitt', ' ', '2018-02-26', '18:00:00', '2018-02-26', '18:15:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '26', null, '8', '1');
INSERT INTO "event" VALUES ('4928', '9 - Laurence Lebihan', ' ', '2018-02-28', '08:00:00', '2018-02-28', '08:15:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '9', null, '8', '1');
INSERT INTO "event" VALUES ('4929', '15 - Pedro Afonso', ' ', '2018-02-28', '08:15:00', '2018-02-28', '08:30:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '15', null, '8', '1');
INSERT INTO "event" VALUES ('4930', '19 - Ann Devon', ' ', '2018-02-28', '08:30:00', '2018-02-28', '08:45:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '1', '19', null, '8', '3');
INSERT INTO "event" VALUES ('4931', '19 - Ann Devon', ' ', '2018-02-28', '08:45:00', '2018-02-28', '09:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '19', null, '8', '1');
INSERT INTO "event" VALUES ('4932', '29 - Paul Henriot', ' ', '2018-02-28', '09:00:00', '2018-02-28', '09:15:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '29', null, '8', '2');
INSERT INTO "event" VALUES ('4933', '28 - Mary Saveley', ' ', '2018-02-28', '09:15:00', '2018-02-28', '09:30:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '28', null, '9', '1');
INSERT INTO "event" VALUES ('4934', '14 - Yang Wang', ' ', '2018-02-28', '09:30:00', '2018-02-28', '09:45:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('4935', '8 - Martin Sommer', ' ', '2018-02-28', '09:45:00', '2018-02-28', '10:00:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '8', null, '9', '1');
INSERT INTO "event" VALUES ('4936', '14 - Yang Wang', ' ', '2018-02-28', '10:00:00', '2018-02-28', '10:15:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '14', null, '9', '1');
INSERT INTO "event" VALUES ('4937', '25 - Peter Franken', ' ', '2018-02-28', '10:15:00', '2018-02-28', '10:30:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '25', null, '8', '1');
INSERT INTO "event" VALUES ('4938', '19 - Ann Devon', ' ', '2018-02-28', '10:30:00', '2018-02-28', '10:45:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '19', null, '8', '1');
INSERT INTO "event" VALUES ('4939', '11 - Victoria Ashworth', ' ', '2018-02-28', '10:45:00', '2018-02-28', '11:00:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '11', null, '8', '1');
INSERT INTO "event" VALUES ('4940', '26 - Carine Schmitt', ' ', '2018-02-28', '11:00:00', '2018-02-28', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '8', '1');
INSERT INTO "event" VALUES ('4941', '10 - Elizabeth Lincoln', ' ', '2018-02-28', '11:15:00', '2018-02-28', '11:30:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '10', null, '8', '1');
INSERT INTO "event" VALUES ('4942', '18 - Janine Labrune', ' ', '2018-02-28', '11:30:00', '2018-02-28', '11:45:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '18', null, '8', '1');
INSERT INTO "event" VALUES ('4943', '11 - Victoria Ashworth', ' ', '2018-02-28', '14:00:00', '2018-02-28', '14:15:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '11', null, '8', '1');
INSERT INTO "event" VALUES ('4944', '17 - Sven Ottlieb', ' ', '2018-02-28', '14:15:00', '2018-02-28', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '17', null, '8', '2');
INSERT INTO "event" VALUES ('4945', '26 - Carine Schmitt', ' ', '2018-02-28', '14:30:00', '2018-02-28', '14:45:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '26', null, '8', '1');
INSERT INTO "event" VALUES ('4946', '1 - Liu Wong', ' ', '2018-02-28', '14:45:00', '2018-02-28', '15:00:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '1', null, '9', '1');
INSERT INTO "event" VALUES ('4947', '29 - Paul Henriot', ' ', '2018-02-28', '15:00:00', '2018-02-28', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '29', null, '8', '1');
INSERT INTO "event" VALUES ('4948', '2 - Ana Trujillo', ' ', '2018-02-28', '15:15:00', '2018-02-28', '15:30:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '2', null, '8', '1');
INSERT INTO "event" VALUES ('4949', '13 - Francisco Chang', ' ', '2018-02-28', '15:30:00', '2018-02-28', '15:45:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '13', null, '9', '1');
INSERT INTO "event" VALUES ('4950', '11 - Victoria Ashworth', ' ', '2018-02-28', '15:45:00', '2018-02-28', '16:00:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '11', null, '8', '1');
INSERT INTO "event" VALUES ('4951', '7 - Frederique Citeaux', ' ', '2018-02-28', '16:00:00', '2018-02-28', '16:15:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '7', null, '8', '1');
INSERT INTO "event" VALUES ('4952', '22 - Diego Roel', ' ', '2018-02-28', '16:15:00', '2018-02-28', '16:30:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '22', null, '8', '1');
INSERT INTO "event" VALUES ('4953', '29 - Paul Henriot', ' ', '2018-02-28', '16:30:00', '2018-02-28', '16:45:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '29', null, '8', '1');
INSERT INTO "event" VALUES ('4954', '30 - Rita Muller', ' ', '2018-02-28', '16:45:00', '2018-02-28', '17:00:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4955', '1 - Liu Wong', ' ', '2018-02-28', '17:00:00', '2018-02-28', '17:15:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '1', null, '9', '1');
INSERT INTO "event" VALUES ('4956', '20 - Roland Mendel', ' ', '2018-02-28', '17:15:00', '2018-02-28', '17:30:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '20', null, '8', '1');
INSERT INTO "event" VALUES ('4957', '30 - Rita Muller', ' ', '2018-02-28', '17:30:00', '2018-02-28', '17:45:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4958', '2 - Ana Trujillo', ' ', '2018-02-22', '14:00:00', '2018-02-22', '14:15:00', 'N', 'D', '7', null, null, null, null, null, null, '2', '2', null, '8', '1');
INSERT INTO "event" VALUES ('4959', '9 - Laurence Lebihan', ' ', '2018-03-01', '14:00:00', '2018-03-01', '14:15:00', 'N', 'D', '3', null, null, null, null, null, null, '2', '9', null, '8', '1');
INSERT INTO "event" VALUES ('4960', '30 - Rita Muller', ' ', '2018-02-22', '15:00:00', '2018-02-22', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '2', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4961', '3 - Antonio Moreno', ' ', '2018-03-01', '15:00:00', '2018-03-01', '15:15:00', 'N', 'D', '7', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '2', '3', null, '8', '1');
INSERT INTO "event" VALUES ('4962', '1 - Liu Wong', ' ', '2018-02-22', '16:00:00', '2018-02-22', '16:15:00', 'N', 'D', '7', null, null, null, null, null, null, '2', '1', null, '8', '3');
INSERT INTO "event" VALUES ('4963', '6 - Hanna Moos', ' ', '2018-03-01', '16:00:00', '2018-03-01', '16:15:00', 'N', 'D', '5', null, null, null, null, null, null, '2', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4964', '24 - Maria Larsson', ' ', '2018-02-22', '17:00:00', '2018-02-22', '17:15:00', 'N', 'D', '6', null, null, null, null, null, null, '2', '24', null, '8', '1');
INSERT INTO "event" VALUES ('4965', '16 - Elizabeth Brown', ' ', '2018-03-01', '17:00:00', '2018-03-01', '17:15:00', 'N', 'D', '4', null, null, null, null, null, null, '2', '16', null, '8', '1');
INSERT INTO "event" VALUES ('4966', '4 - Thomas Hardy', ' ', '2018-02-22', '18:00:00', '2018-02-22', '18:15:00', 'N', 'D', '3', null, null, null, null, null, null, '2', '4', null, '8', '1');
INSERT INTO "event" VALUES ('4967', '2 - Ana Trujillo', ' ', '2018-03-01', '18:00:00', '2018-03-01', '18:15:00', 'N', 'D', '3', null, null, null, null, null, null, '2', '2', null, '8', '1');
INSERT INTO "event" VALUES ('4968', '22 - Diego Roel', ' ', '2018-02-27', '09:00:00', '2018-02-27', '09:15:00', 'N', 'D', '5', null, null, null, null, null, null, '2', '22', null, '8', '1');
INSERT INTO "event" VALUES ('4970', '5 - Christina Berglund', ' ', '2018-02-27', '10:00:00', '2018-02-27', '10:15:00', 'N', 'D', '6', null, null, null, null, null, null, '2', '5', null, '8', '1');
INSERT INTO "event" VALUES ('4972', '16 - Elizabeth Brown', ' ', '2018-02-27', '11:00:00', '2018-02-27', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '16', null, '8', '3');
INSERT INTO "event" VALUES ('4974', '28 - Mary Saveley', ' ', '2018-02-23', '08:00:00', '2018-02-23', '08:15:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '28', null, '8', '1');
INSERT INTO "event" VALUES ('4975', '21 - Aria Cruz', ' ', '2018-03-02', '08:00:00', '2018-03-02', '08:15:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '21', null, '8', '1');
INSERT INTO "event" VALUES ('4976', '3 - Antonio Moreno', ' ', '2018-02-23', '08:15:00', '2018-02-23', '08:30:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '3', null, '8', '1');
INSERT INTO "event" VALUES ('4977', '9 - Laurence Lebihan', ' ', '2018-03-02', '08:15:00', '2018-03-02', '08:30:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '9', null, '8', '1');
INSERT INTO "event" VALUES ('4978', '6 - Hanna Moos', ' ', '2018-02-23', '08:30:00', '2018-02-23', '08:45:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4979', '28 - Mary Saveley', ' ', '2018-03-02', '08:30:00', '2018-03-02', '08:45:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '28', null, '9', '1');
INSERT INTO "event" VALUES ('4980', '16 - Elizabeth Brown', ' ', '2018-02-23', '08:45:00', '2018-02-23', '09:00:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '16', null, '8', '1');
INSERT INTO "event" VALUES ('4981', '27 - Paolo Accorti', ' ', '2018-03-02', '08:45:00', '2018-03-02', '09:00:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '27', null, '8', '1');
INSERT INTO "event" VALUES ('4982', '7 - Frederique Citeaux', ' ', '2018-02-23', '09:00:00', '2018-02-23', '09:15:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '7', null, '8', '1');
INSERT INTO "event" VALUES ('4983', '28 - Mary Saveley', ' ', '2018-03-02', '09:00:00', '2018-03-02', '09:15:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '28', null, '8', '1');
INSERT INTO "event" VALUES ('4984', '21 - Aria Cruz', ' ', '2018-02-23', '09:15:00', '2018-02-23', '09:30:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '21', null, '8', '1');
INSERT INTO "event" VALUES ('4985', '20 - Roland Mendel', ' ', '2018-03-02', '09:15:00', '2018-03-02', '09:30:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '20', null, '8', '1');
INSERT INTO "event" VALUES ('4986', '9 - Laurence Lebihan', ' ', '2018-02-23', '09:30:00', '2018-02-23', '09:45:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '9', null, '8', '1');
INSERT INTO "event" VALUES ('4987', '21 - Aria Cruz', ' ', '2018-03-02', '09:30:00', '2018-03-02', '09:45:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '21', null, '8', '1');
INSERT INTO "event" VALUES ('4988', '5 - Christina Berglund', ' ', '2018-02-23', '09:45:00', '2018-02-23', '10:00:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '5', null, '8', '1');
INSERT INTO "event" VALUES ('4989', '5 - Christina Berglund', ' ', '2018-03-02', '09:45:00', '2018-03-02', '10:00:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '5', null, '8', '1');
INSERT INTO "event" VALUES ('4990', '5 - Christina Berglund', ' ', '2018-02-23', '10:00:00', '2018-02-23', '10:15:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '5', null, '8', '1');
INSERT INTO "event" VALUES ('4991', '6 - Hanna Moos', ' ', '2018-03-02', '10:00:00', '2018-03-02', '10:15:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '6', null, '8', '1');
INSERT INTO "event" VALUES ('4992', '13 - Francisco Chang', ' ', '2018-02-23', '10:15:00', '2018-02-23', '10:30:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '13', null, '8', '1');
INSERT INTO "event" VALUES ('4993', '7 - Frederique Citeaux', ' ', '2018-03-02', '10:15:00', '2018-03-02', '10:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '7', null, '8', '1');
INSERT INTO "event" VALUES ('4994', '10 - Elizabeth Lincoln', ' ', '2018-02-23', '10:30:00', '2018-02-23', '10:45:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '10', null, '8', '1');
INSERT INTO "event" VALUES ('4995', '2 - Ana Trujillo', ' ', '2018-03-02', '10:30:00', '2018-03-02', '10:45:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '2', null, '8', '1');
INSERT INTO "event" VALUES ('4996', '16 - Elizabeth Brown', ' ', '2018-02-23', '10:45:00', '2018-02-23', '11:00:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '16', null, '8', '1');
INSERT INTO "event" VALUES ('4997', '30 - Rita Muller', ' ', '2018-03-02', '10:45:00', '2018-03-02', '11:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '30', null, '8', '1');
INSERT INTO "event" VALUES ('4998', '23 - Martine Rance', ' ', '2018-02-23', '11:00:00', '2018-02-23', '11:15:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '23', null, '8', '1');
INSERT INTO "event" VALUES ('4999', '15 - Pedro Afonso', ' ', '2018-03-02', '11:00:00', '2018-03-02', '11:15:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '15', null, '9', '1');
INSERT INTO "event" VALUES ('5000', '10 - Elizabeth Lincoln', ' ', '2018-02-23', '11:15:00', '2018-02-23', '11:30:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5001', '18 - Janine Labrune', ' ', '2018-03-02', '11:15:00', '2018-03-02', '11:30:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5002', '25 - Peter Franken', ' ', '2018-02-23', '11:30:00', '2018-02-23', '11:45:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5003', '16 - Elizabeth Brown', ' ', '2018-03-02', '11:30:00', '2018-03-02', '11:45:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5004', '25 - Peter Franken', ' ', '2018-02-23', '14:00:00', '2018-02-23', '14:15:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '25', null, '9', '1');
INSERT INTO "event" VALUES ('5005', '21 - Aria Cruz', ' ', '2018-03-02', '14:00:00', '2018-03-02', '14:15:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '21', null, '9', '1');
INSERT INTO "event" VALUES ('5006', '11 - Victoria Ashworth', ' ', '2018-02-23', '14:15:00', '2018-02-23', '14:30:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '11', null, '9', '1');
INSERT INTO "event" VALUES ('5007', '25 - Peter Franken', ' ', '2018-03-02', '14:15:00', '2018-03-02', '14:30:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '25', null, '9', '1');
INSERT INTO "event" VALUES ('5008', '20 - Roland Mendel', ' ', '2018-02-23', '14:30:00', '2018-02-23', '14:45:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '20', null, '9', '1');
INSERT INTO "event" VALUES ('5009', '30 - Rita Muller', ' ', '2018-03-02', '14:30:00', '2018-03-02', '14:45:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5010', '17 - Sven Ottlieb', ' ', '2018-02-23', '14:45:00', '2018-02-23', '15:00:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5011', '16 - Elizabeth Brown', ' ', '2018-03-02', '14:45:00', '2018-03-02', '15:00:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5012', '13 - Francisco Chang', ' ', '2018-02-23', '15:00:00', '2018-02-23', '15:15:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5013', '20 - Roland Mendel', ' ', '2018-03-02', '15:00:00', '2018-03-02', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5014', '12 - Patricio Simpson', ' ', '2018-02-23', '15:15:00', '2018-02-23', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '12', null, '8', '1');
INSERT INTO "event" VALUES ('5015', '14 - Yang Wang', ' ', '2018-03-02', '15:15:00', '2018-03-02', '15:30:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5016', '2 - Ana Trujillo', ' ', '2018-02-23', '15:30:00', '2018-02-23', '15:45:00', 'N', 'D', '7', null, null, null, null, null, null, '3', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5017', '17 - Sven Ottlieb', ' ', '2018-03-02', '15:30:00', '2018-03-02', '15:45:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5018', '19 - Ann Devon', ' ', '2018-02-23', '15:45:00', '2018-02-23', '16:00:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5019', '30 - Rita Muller', ' ', '2018-03-02', '15:45:00', '2018-03-02', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5020', '19 - Ann Devon', ' ', '2018-02-23', '16:00:00', '2018-02-23', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5021', '3 - Antonio Moreno', ' ', '2018-03-02', '16:00:00', '2018-03-02', '16:15:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '3', null, '8', '1');
INSERT INTO "event" VALUES ('5022', '26 - Carine Schmitt', ' ', '2018-02-23', '16:15:00', '2018-02-23', '16:30:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5023', '15 - Pedro Afonso', ' ', '2018-03-02', '16:15:00', '2018-03-02', '16:30:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '15', null, '8', '1');
INSERT INTO "event" VALUES ('5024', '25 - Peter Franken', ' ', '2018-02-23', '16:30:00', '2018-02-23', '16:45:00', 'N', 'D', '6', null, null, null, null, null, null, '3', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5025', '22 - Diego Roel', ' ', '2018-03-02', '16:30:00', '2018-03-02', '16:45:00', 'N', 'D', '4', null, null, null, null, null, null, '3', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5026', '15 - Pedro Afonso', ' ', '2018-02-23', '16:45:00', '2018-02-23', '17:00:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '15', null, '9', '1');
INSERT INTO "event" VALUES ('5027', '22 - Diego Roel', ' ', '2018-03-02', '16:45:00', '2018-03-02', '17:00:00', 'N', 'D', '5', null, null, null, null, null, null, '3', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5028', '1 - Liu Wong', ' ', '2018-02-23', '17:00:00', '2018-02-23', '17:15:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '1', null, '9', '1');
INSERT INTO "event" VALUES ('5029', '29 - Paul Henriot', ' ', '2018-03-02', '17:00:00', '2018-03-02', '17:15:00', 'N', 'D', '2', null, null, null, null, null, null, '3', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5030', '17 - Sven Ottlieb', ' ', '2018-02-23', '17:15:00', '2018-02-23', '17:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5031', '10 - Elizabeth Lincoln', ' ', '2018-03-02', '17:15:00', '2018-03-02', '17:30:00', 'N', 'D', '8', null, null, null, null, null, null, '3', '10', null, '9', '1');
INSERT INTO "event" VALUES ('5032', '6 - Hanna Moos', ' ', '2018-02-23', '17:30:00', '2018-02-23', '17:45:00', 'N', 'D', '3', null, null, null, null, null, null, '3', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5033', '22 - Diego Roel', ' ', '2018-03-02', '17:30:00', '2018-03-02', '17:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5034', '4 - Thomas Hardy', ' ', '2018-02-26', '08:00:00', '2018-02-26', '08:15:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '4', null, '9', '1');
INSERT INTO "event" VALUES ('5036', '13 - Francisco Chang', ' ', '2018-02-26', '08:15:00', '2018-02-26', '08:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '13', null, '9', '1');
INSERT INTO "event" VALUES ('5038', '23 - Martine Rance', ' ', '2018-02-26', '08:30:00', '2018-02-26', '08:45:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5040', '7 - Frederique Citeaux', ' ', '2018-02-26', '08:45:00', '2018-02-26', '09:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '7', null, '9', '1');
INSERT INTO "event" VALUES ('5042', '10 - Elizabeth Lincoln', ' ', '2018-02-26', '09:00:00', '2018-02-26', '09:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5044', '18 - Janine Labrune', ' ', '2018-02-26', '09:15:00', '2018-02-26', '09:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5046', '18 - Janine Labrune', ' ', '2018-02-26', '09:30:00', '2018-02-26', '09:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5048', '1 - Liu Wong', ' ', '2018-02-26', '09:45:00', '2018-02-26', '10:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5050', '10 - Elizabeth Lincoln', ' ', '2018-02-26', '10:00:00', '2018-02-26', '10:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5052', '7 - Frederique Citeaux', ' ', '2018-02-26', '10:15:00', '2018-02-26', '10:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5054', '3 - Antonio Moreno', ' ', '2018-02-26', '10:30:00', '2018-02-26', '10:45:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '3', null, '8', '1');
INSERT INTO "event" VALUES ('5056', '25 - Peter Franken', ' ', '2018-02-26', '10:45:00', '2018-02-26', '11:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5058', '2 - Ana Trujillo', ' ', '2018-02-26', '11:00:00', '2018-02-26', '11:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5060', '30 - Rita Muller', ' ', '2018-02-26', '11:15:00', '2018-02-26', '11:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5062', '25 - Peter Franken', ' ', '2018-02-26', '11:30:00', '2018-02-26', '11:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5064', '25 - Peter Franken', ' ', '2018-02-26', '11:45:00', '2018-02-26', '12:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5066', '4 - Thomas Hardy', ' ', '2018-02-26', '13:00:00', '2018-02-26', '13:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5068', '30 - Rita Muller', ' ', '2018-02-26', '13:15:00', '2018-02-26', '13:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5070', '2 - Ana Trujillo', ' ', '2018-02-26', '13:30:00', '2018-02-26', '13:45:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '2', null, '8', '3');
INSERT INTO "event" VALUES ('5072', '6 - Hanna Moos', ' ', '2018-02-26', '13:45:00', '2018-02-26', '14:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5074', '14 - Yang Wang', ' ', '2018-02-26', '14:00:00', '2018-02-26', '14:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5076', '22 - Diego Roel', ' ', '2018-02-26', '14:15:00', '2018-02-26', '14:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '22', null, '9', '1');
INSERT INTO "event" VALUES ('5078', '22 - Diego Roel', ' ', '2018-02-26', '14:30:00', '2018-02-26', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5080', '6 - Hanna Moos', ' ', '2018-02-26', '14:45:00', '2018-02-26', '15:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5082', '10 - Elizabeth Lincoln', ' ', '2018-02-26', '15:00:00', '2018-02-26', '15:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5084', '1 - Liu Wong', ' ', '2018-02-26', '15:15:00', '2018-02-26', '15:30:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5086', '29 - Paul Henriot', ' ', '2018-02-26', '15:30:00', '2018-02-26', '15:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5088', '18 - Janine Labrune', ' ', '2018-02-26', '15:45:00', '2018-02-26', '16:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5090', '9 - Laurence Lebihan', ' ', '2018-02-26', '16:00:00', '2018-02-26', '16:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5092', '4 - Thomas Hardy', ' ', '2018-02-26', '16:15:00', '2018-02-26', '16:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5094', '2 - Ana Trujillo', ' ', '2018-02-22', '08:00:00', '2018-02-22', '08:15:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '2', null, '8', '3');
INSERT INTO "event" VALUES ('5095', '24 - Maria Larsson', ' ', '2018-03-01', '08:00:00', '2018-03-01', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5096', '29 - Paul Henriot', ' ', '2018-02-22', '08:15:00', '2018-02-22', '08:30:00', 'N', 'D', '3', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5097', '21 - Aria Cruz', ' ', '2018-03-01', '08:15:00', '2018-03-01', '08:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5098', '21 - Aria Cruz', ' ', '2018-02-22', '08:30:00', '2018-02-22', '08:45:00', 'N', 'D', '3', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5099', '6 - Hanna Moos', ' ', '2018-03-01', '08:30:00', '2018-03-01', '08:45:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5100', '29 - Paul Henriot', ' ', '2018-02-22', '08:45:00', '2018-02-22', '09:00:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '29', null, '8', '3');
INSERT INTO "event" VALUES ('5101', '16 - Elizabeth Brown', ' ', '2018-03-01', '08:45:00', '2018-03-01', '09:00:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5102', '13 - Francisco Chang', ' ', '2018-02-22', '09:00:00', '2018-02-22', '09:15:00', 'N', 'D', '3', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5103', '17 - Sven Ottlieb', ' ', '2018-03-01', '09:00:00', '2018-03-01', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5104', '9 - Laurence Lebihan', ' ', '2018-02-22', '09:15:00', '2018-02-22', '09:30:00', 'N', 'D', '3', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5105', '26 - Carine Schmitt', ' ', '2018-03-01', '09:15:00', '2018-03-01', '09:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5106', '15 - Pedro Afonso', ' ', '2018-02-22', '09:30:00', '2018-02-22', '09:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '15', null, '8', '1');
INSERT INTO "event" VALUES ('5107', '10 - Elizabeth Lincoln', ' ', '2018-03-01', '09:30:00', '2018-03-01', '09:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5108', '14 - Yang Wang', ' ', '2018-02-22', '09:45:00', '2018-02-22', '10:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5109', '9 - Laurence Lebihan', ' ', '2018-03-01', '09:45:00', '2018-03-01', '10:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5110', '26 - Carine Schmitt', ' ', '2018-02-22', '10:00:00', '2018-02-22', '10:15:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5111', '25 - Peter Franken', ' ', '2018-03-01', '10:00:00', '2018-03-01', '10:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5112', '17 - Sven Ottlieb', ' ', '2018-02-22', '10:15:00', '2018-02-22', '10:30:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5113', '4 - Thomas Hardy', ' ', '2018-03-01', '10:15:00', '2018-03-01', '10:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5114', '7 - Frederique Citeaux', ' ', '2018-02-22', '10:30:00', '2018-02-22', '10:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5115', '6 - Hanna Moos', ' ', '2018-03-01', '10:30:00', '2018-03-01', '10:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5116', '29 - Paul Henriot', ' ', '2018-02-22', '10:45:00', '2018-02-22', '11:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5117', '19 - Ann Devon', ' ', '2018-03-01', '10:45:00', '2018-03-01', '11:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5118', '18 - Janine Labrune', ' ', '2018-02-22', '11:00:00', '2018-02-22', '11:15:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '18', null, '8', '2');
INSERT INTO "event" VALUES ('5119', '20 - Roland Mendel', ' ', '2018-03-01', '11:00:00', '2018-03-01', '11:15:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '20', null, '9', '1');
INSERT INTO "event" VALUES ('5120', '17 - Sven Ottlieb', ' ', '2018-02-22', '11:15:00', '2018-02-22', '11:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5121', '24 - Maria Larsson', ' ', '2018-03-01', '11:15:00', '2018-03-01', '11:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5122', '4 - Thomas Hardy', ' ', '2018-02-22', '11:30:00', '2018-02-22', '11:45:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5123', '15 - Pedro Afonso', ' ', '2018-03-01', '11:30:00', '2018-03-01', '11:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '15', null, '8', '1');
INSERT INTO "event" VALUES ('5124', '1 - Liu Wong', ' ', '2018-02-22', '11:45:00', '2018-02-22', '12:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5125', '5 - Christina Berglund', ' ', '2018-03-01', '11:45:00', '2018-03-01', '12:00:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5126', '26 - Carine Schmitt', ' ', '2018-02-22', '12:00:00', '2018-02-22', '12:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5127', '19 - Ann Devon', ' ', '2018-03-01', '12:00:00', '2018-03-01', '12:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5128', '26 - Carine Schmitt', ' ', '2018-02-22', '12:15:00', '2018-02-22', '12:30:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5129', '29 - Paul Henriot', ' ', '2018-03-01', '12:15:00', '2018-03-01', '12:30:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5130', '6 - Hanna Moos', ' ', '2018-02-22', '12:30:00', '2018-02-22', '12:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '6', null, '9', '1');
INSERT INTO "event" VALUES ('5131', '10 - Elizabeth Lincoln', ' ', '2018-03-01', '12:30:00', '2018-03-01', '12:45:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '10', null, '8', '1');
INSERT INTO "event" VALUES ('5132', '25 - Peter Franken', ' ', '2018-02-22', '12:45:00', '2018-02-22', '13:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5133', '6 - Hanna Moos', ' ', '2018-03-01', '12:45:00', '2018-03-01', '13:00:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '6', null, '8', '2');
INSERT INTO "event" VALUES ('5134', '5 - Christina Berglund', ' ', '2018-02-22', '13:00:00', '2018-02-22', '13:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5135', '30 - Rita Muller', ' ', '2018-03-01', '13:00:00', '2018-03-01', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5136', '24 - Maria Larsson', ' ', '2018-02-22', '13:15:00', '2018-02-22', '13:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5137', '22 - Diego Roel', ' ', '2018-03-01', '13:15:00', '2018-03-01', '13:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5138', '20 - Roland Mendel', ' ', '2018-02-22', '13:30:00', '2018-02-22', '13:45:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5139', '22 - Diego Roel', ' ', '2018-03-01', '13:30:00', '2018-03-01', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5140', '9 - Laurence Lebihan', ' ', '2018-02-22', '13:45:00', '2018-02-22', '14:00:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5141', '9 - Laurence Lebihan', ' ', '2018-03-01', '13:45:00', '2018-03-01', '14:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '9', null, '9', '1');
INSERT INTO "event" VALUES ('5142', '7 - Frederique Citeaux', ' ', '2018-02-22', '14:00:00', '2018-02-22', '14:15:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5143', '5 - Christina Berglund', ' ', '2018-03-01', '14:00:00', '2018-03-01', '14:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5144', '17 - Sven Ottlieb', ' ', '2018-02-22', '14:15:00', '2018-02-22', '14:30:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5145', '9 - Laurence Lebihan', ' ', '2018-03-01', '14:15:00', '2018-03-01', '14:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5146', '8 - Martin Sommer', ' ', '2018-02-22', '14:30:00', '2018-02-22', '14:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '8', null, '9', '1');
INSERT INTO "event" VALUES ('5147', '25 - Peter Franken', ' ', '2018-03-01', '14:30:00', '2018-03-01', '14:45:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5148', '30 - Rita Muller', ' ', '2018-02-22', '14:45:00', '2018-02-22', '15:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5149', '7 - Frederique Citeaux', ' ', '2018-03-01', '14:45:00', '2018-03-01', '15:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5150', '14 - Yang Wang', ' ', '2018-02-22', '15:00:00', '2018-02-22', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5151', '4 - Thomas Hardy', ' ', '2018-03-01', '15:00:00', '2018-03-01', '15:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5152', '20 - Roland Mendel', ' ', '2018-02-22', '15:15:00', '2018-02-22', '15:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5153', '19 - Ann Devon', ' ', '2018-03-01', '15:15:00', '2018-03-01', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5154', '2 - Ana Trujillo', ' ', '2018-02-22', '15:30:00', '2018-02-22', '15:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5155', '16 - Elizabeth Brown', ' ', '2018-03-01', '15:30:00', '2018-03-01', '15:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5156', '4 - Thomas Hardy', ' ', '2018-02-22', '15:45:00', '2018-02-22', '16:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '4', null, '9', '1');
INSERT INTO "event" VALUES ('5157', '24 - Maria Larsson', ' ', '2018-03-01', '15:45:00', '2018-03-01', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5158', '1 - Liu Wong', ' ', '2018-02-22', '16:00:00', '2018-02-22', '16:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5159', '5 - Christina Berglund', ' ', '2018-03-01', '16:00:00', '2018-03-01', '16:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5160', '4 - Thomas Hardy', ' ', '2018-02-22', '16:15:00', '2018-02-22', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5161', '21 - Aria Cruz', ' ', '2018-03-01', '16:15:00', '2018-03-01', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5162', '22 - Diego Roel', ' ', '2018-02-27', '08:00:00', '2018-02-27', '08:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5164', '26 - Carine Schmitt', ' ', '2018-02-27', '08:15:00', '2018-02-27', '08:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '26', null, '9', '1');
INSERT INTO "event" VALUES ('5166', '21 - Aria Cruz', ' ', '2018-02-27', '08:30:00', '2018-02-27', '08:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '21', null, '9', '1');
INSERT INTO "event" VALUES ('5168', '7 - Frederique Citeaux', ' ', '2018-02-27', '08:45:00', '2018-02-27', '09:00:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '7', null, '8', '3');
INSERT INTO "event" VALUES ('5170', '25 - Peter Franken', ' ', '2018-02-27', '09:00:00', '2018-02-27', '09:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5172', '21 - Aria Cruz', ' ', '2018-02-27', '09:15:00', '2018-02-27', '09:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5174', '5 - Christina Berglund', ' ', '2018-02-27', '09:30:00', '2018-02-27', '09:45:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5176', '30 - Rita Muller', ' ', '2018-02-27', '09:45:00', '2018-02-27', '10:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5178', '13 - Francisco Chang', ' ', '2018-02-27', '10:00:00', '2018-02-27', '10:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5180', '24 - Maria Larsson', ' ', '2018-02-27', '10:15:00', '2018-02-27', '10:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5182', '1 - Liu Wong', ' ', '2018-02-27', '10:30:00', '2018-02-27', '10:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '1', null, '9', '1');
INSERT INTO "event" VALUES ('5184', '5 - Christina Berglund', ' ', '2018-02-27', '10:45:00', '2018-02-27', '11:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5186', '9 - Laurence Lebihan', ' ', '2018-02-27', '11:00:00', '2018-02-27', '11:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5188', '25 - Peter Franken', ' ', '2018-02-27', '11:15:00', '2018-02-27', '11:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5190', '16 - Elizabeth Brown', ' ', '2018-02-27', '11:30:00', '2018-02-27', '11:45:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5192', '23 - Martine Rance', ' ', '2018-02-27', '11:45:00', '2018-02-27', '12:00:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5194', '2 - Ana Trujillo', ' ', '2018-02-27', '12:00:00', '2018-02-27', '12:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5196', '10 - Elizabeth Lincoln', ' ', '2018-02-27', '12:15:00', '2018-02-27', '12:30:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '10', null, '8', '3');
INSERT INTO "event" VALUES ('5198', '21 - Aria Cruz', ' ', '2018-02-27', '12:30:00', '2018-02-27', '12:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5200', '20 - Roland Mendel', ' ', '2018-02-27', '12:45:00', '2018-02-27', '13:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5202', '17 - Sven Ottlieb', ' ', '2018-02-27', '13:00:00', '2018-02-27', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5204', '29 - Paul Henriot', ' ', '2018-02-27', '13:15:00', '2018-02-27', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5206', '6 - Hanna Moos', ' ', '2018-02-27', '13:30:00', '2018-02-27', '13:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '6', null, '9', '1');
INSERT INTO "event" VALUES ('5208', '5 - Christina Berglund', ' ', '2018-02-27', '13:45:00', '2018-02-27', '14:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5210', '7 - Frederique Citeaux', ' ', '2018-02-27', '14:00:00', '2018-02-27', '14:15:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5212', '5 - Christina Berglund', ' ', '2018-02-27', '14:15:00', '2018-02-27', '14:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5214', '1 - Liu Wong', ' ', '2018-02-27', '14:30:00', '2018-02-27', '14:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5216', '23 - Martine Rance', ' ', '2018-02-27', '14:45:00', '2018-02-27', '15:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5218', '23 - Martine Rance', ' ', '2018-02-27', '15:00:00', '2018-02-27', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5220', '12 - Patricio Simpson', ' ', '2018-02-27', '15:15:00', '2018-02-27', '15:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '12', null, '9', '1');
INSERT INTO "event" VALUES ('5222', '14 - Yang Wang', ' ', '2018-02-27', '15:30:00', '2018-02-27', '15:45:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5224', '7 - Frederique Citeaux', ' ', '2018-02-27', '15:45:00', '2018-02-27', '16:00:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '7', null, '8', '1');
INSERT INTO "event" VALUES ('5226', '18 - Janine Labrune', ' ', '2018-02-27', '16:00:00', '2018-02-27', '16:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5228', '11 - Victoria Ashworth', ' ', '2018-02-27', '16:15:00', '2018-02-27', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5230', '26 - Carine Schmitt', ' ', '2018-02-28', '08:00:00', '2018-02-28', '08:15:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '26', null, '9', '1');
INSERT INTO "event" VALUES ('5231', '3 - Antonio Moreno', ' ', '2018-02-28', '08:15:00', '2018-02-28', '08:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '8', '1');
INSERT INTO "event" VALUES ('5232', '13 - Francisco Chang', ' ', '2018-02-28', '08:30:00', '2018-02-28', '08:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '13', null, '9', '1');
INSERT INTO "event" VALUES ('5233', '11 - Victoria Ashworth', ' ', '2018-02-28', '08:45:00', '2018-02-28', '09:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5234', '2 - Ana Trujillo', ' ', '2018-02-28', '09:00:00', '2018-02-28', '09:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5235', '26 - Carine Schmitt', ' ', '2018-02-28', '09:15:00', '2018-02-28', '09:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5236', '11 - Victoria Ashworth', ' ', '2018-02-28', '09:30:00', '2018-02-28', '09:45:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '11', null, '8', '2');
INSERT INTO "event" VALUES ('5237', '1 - Liu Wong', ' ', '2018-02-28', '09:45:00', '2018-02-28', '10:00:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5238', '1 - Liu Wong', ' ', '2018-02-28', '10:00:00', '2018-02-28', '10:15:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5239', '18 - Janine Labrune', ' ', '2018-02-28', '10:15:00', '2018-02-28', '10:30:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5240', '18 - Janine Labrune', ' ', '2018-02-28', '10:30:00', '2018-02-28', '10:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5241', '21 - Aria Cruz', ' ', '2018-02-28', '10:45:00', '2018-02-28', '11:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5242', '28 - Mary Saveley', ' ', '2018-02-28', '11:00:00', '2018-02-28', '11:15:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '28', null, '8', '1');
INSERT INTO "event" VALUES ('5243', '6 - Hanna Moos', ' ', '2018-02-28', '11:15:00', '2018-02-28', '11:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5244', '18 - Janine Labrune', ' ', '2018-02-28', '11:30:00', '2018-02-28', '11:45:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5245', '26 - Carine Schmitt', ' ', '2018-02-28', '11:45:00', '2018-02-28', '12:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5246', '9 - Laurence Lebihan', ' ', '2018-02-28', '12:00:00', '2018-02-28', '12:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '9', null, '8', '1');
INSERT INTO "event" VALUES ('5247', '24 - Maria Larsson', ' ', '2018-02-28', '12:15:00', '2018-02-28', '12:30:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5248', '18 - Janine Labrune', ' ', '2018-02-28', '12:30:00', '2018-02-28', '12:45:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '18', null, '8', '1');
INSERT INTO "event" VALUES ('5249', '12 - Patricio Simpson', ' ', '2018-02-28', '12:45:00', '2018-02-28', '13:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '12', null, '9', '1');
INSERT INTO "event" VALUES ('5250', '27 - Paolo Accorti', ' ', '2018-02-28', '13:00:00', '2018-02-28', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '8', '1');
INSERT INTO "event" VALUES ('5251', '24 - Maria Larsson', ' ', '2018-02-28', '13:15:00', '2018-02-28', '13:30:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5252', '2 - Ana Trujillo', ' ', '2018-02-28', '13:30:00', '2018-02-28', '13:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5253', '25 - Peter Franken', ' ', '2018-02-28', '13:45:00', '2018-02-28', '14:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5254', '3 - Antonio Moreno', ' ', '2018-02-28', '14:00:00', '2018-02-28', '14:15:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '3', null, '9', '1');
INSERT INTO "event" VALUES ('5255', '21 - Aria Cruz', ' ', '2018-02-28', '14:15:00', '2018-02-28', '14:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5256', '12 - Patricio Simpson', ' ', '2018-02-28', '14:30:00', '2018-02-28', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '12', null, '8', '1');
INSERT INTO "event" VALUES ('5257', '3 - Antonio Moreno', ' ', '2018-02-28', '14:45:00', '2018-02-28', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '3', null, '8', '1');
INSERT INTO "event" VALUES ('5258', '12 - Patricio Simpson', ' ', '2018-02-28', '15:00:00', '2018-02-28', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '12', null, '8', '1');
INSERT INTO "event" VALUES ('5259', '16 - Elizabeth Brown', ' ', '2018-02-28', '15:15:00', '2018-02-28', '15:30:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5260', '1 - Liu Wong', ' ', '2018-02-28', '15:30:00', '2018-02-28', '15:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '1', null, '9', '1');
INSERT INTO "event" VALUES ('5261', '4 - Thomas Hardy', ' ', '2018-02-28', '15:45:00', '2018-02-28', '16:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5262', '5 - Christina Berglund', ' ', '2018-02-28', '16:00:00', '2018-02-28', '16:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5263', '27 - Paolo Accorti', ' ', '2018-02-28', '16:15:00', '2018-02-28', '16:30:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '27', null, '8', '1');
INSERT INTO "event" VALUES ('5298', '13 - Francisco Chang', ' ', '2018-03-05', '08:00:00', '2018-03-05', '08:15:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5300', '3 - Antonio Moreno', ' ', '2018-03-05', '08:15:00', '2018-03-05', '08:30:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '3', null, '8', '1');
INSERT INTO "event" VALUES ('5302', '4 - Thomas Hardy', ' ', '2018-03-05', '08:30:00', '2018-03-05', '08:45:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5304', '14 - Yang Wang', ' ', '2018-03-05', '08:45:00', '2018-03-05', '09:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5306', '15 - Pedro Afonso', ' ', '2018-03-05', '09:00:00', '2018-03-05', '09:15:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '15', null, '8', '1');
INSERT INTO "event" VALUES ('5308', '20 - Roland Mendel', ' ', '2018-03-05', '09:15:00', '2018-03-05', '09:30:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '20', null, '9', '2');
INSERT INTO "event" VALUES ('5310', '27 - Paolo Accorti', ' ', '2018-03-05', '09:30:00', '2018-03-05', '09:45:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '27', null, '8', '1');
INSERT INTO "event" VALUES ('5312', '11 - Victoria Ashworth', ' ', '2018-03-05', '09:45:00', '2018-03-05', '10:00:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5314', '16 - Elizabeth Brown', ' ', '2018-03-05', '10:00:00', '2018-03-05', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '16', null, '8', '3');
INSERT INTO "event" VALUES ('5316', '27 - Paolo Accorti', ' ', '2018-03-05', '10:15:00', '2018-03-05', '10:30:00', 'N', 'D', '8', null, null, null, null, null, null, '1', '27', null, '9', '1');
INSERT INTO "event" VALUES ('5318', '13 - Francisco Chang', ' ', '2018-03-05', '10:30:00', '2018-03-05', '10:45:00', 'N', 'D', '2', null, null, null, null, null, null, '1', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5320', '2 - Ana Trujillo', ' ', '2018-03-05', '10:45:00', '2018-03-05', '11:00:00', 'N', 'D', '3', null, null, null, null, null, null, '1', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5322', '16 - Elizabeth Brown', ' ', '2018-03-05', '11:00:00', '2018-03-05', '11:15:00', 'N', 'D', '6', null, null, null, null, null, null, '1', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5324', '14 - Yang Wang', ' ', '2018-03-05', '11:15:00', '2018-03-05', '11:30:00', 'N', 'D', '4', null, null, null, null, null, null, '1', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5326', '2 - Ana Trujillo', ' ', '2018-03-05', '11:30:00', '2018-03-05', '11:45:00', 'N', 'D', '5', null, null, null, null, null, null, '1', '2', null, '8', '1');
INSERT INTO "event" VALUES ('5328', '15 - Pedro Afonso', ' ', '2018-03-05', '11:45:00', '2018-03-05', '12:00:00', 'N', 'D', '7', null, null, null, null, null, null, '1', '15', null, '8', '1');
INSERT INTO "event" VALUES ('5330', '4 - Thomas Hardy', ' ', '2018-03-05', '12:00:00', '2018-03-05', '12:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5374', '19 - Ann Devon', ' ', '2018-03-06', '08:00:00', '2018-03-06', '08:15:00', 'N', 'D', '2', null, null, null, null, null, null, '2', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5376', '29 - Paul Henriot', ' ', '2018-03-06', '09:00:00', '2018-03-06', '09:15:00', 'N', 'D', '6', null, null, null, null, null, null, '2', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5378', '1 - Liu Wong', ' ', '2018-03-06', '10:00:00', '2018-03-06', '10:15:00', 'N', 'D', '4', null, null, null, null, null, null, '2', '1', null, '8', '1');
INSERT INTO "event" VALUES ('5380', '13 - Francisco Chang', ' ', '2018-03-06', '11:00:00', '2018-03-06', '11:15:00', 'N', 'D', '6', null, null, null, null, null, null, '2', '13', null, '8', '1');
INSERT INTO "event" VALUES ('5382', '22 - Diego Roel', ' ', '2018-03-06', '13:00:00', '2018-03-06', '13:15:00', 'N', 'D', '7', null, null, null, null, null, null, '2', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5384', '14 - Yang Wang', ' ', '2018-03-06', '14:00:00', '2018-03-06', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '14', null, '8', '1');
INSERT INTO "event" VALUES ('5386', '12 - Patricio Simpson', ' ', '2018-03-06', '15:00:00', '2018-03-06', '15:15:00', 'N', 'D', '7', null, null, null, null, null, null, '2', '12', null, '8', '1');
INSERT INTO "event" VALUES ('5388', '26 - Carine Schmitt', ' ', '2018-03-06', '16:00:00', '2018-03-06', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5390', '8 - Martin Sommer', ' ', '2018-03-06', '17:00:00', '2018-03-06', '17:15:00', 'N', 'D', '6', null, null, null, null, null, null, '2', '8', null, '8', '1');
INSERT INTO "event" VALUES ('5494', '19 - Ann Devon', ' ', '2018-03-05', '08:00:00', '2018-03-05', '08:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '19', null, '8', '1');
INSERT INTO "event" VALUES ('5496', '28 - Mary Saveley', ' ', '2018-03-05', '08:15:00', '2018-03-05', '08:30:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '28', null, '8', '3');
INSERT INTO "event" VALUES ('5498', '10 - Elizabeth Lincoln', ' ', '2018-03-05', '08:30:00', '2018-03-05', '08:45:00', 'N', 'D', '1', null, null, '{\"repeat\":\"1\",\"repeatin\":\"\",\"endon\":\"N\",\"endafter\":\"\",\"endin\":\"\"}', '', null, null, '4', '10', null, '8', '3');
INSERT INTO "event" VALUES ('5500', '23 - Martine Rance', ' ', '2018-03-05', '08:45:00', '2018-03-05', '09:00:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5502', '24 - Maria Larsson', ' ', '2018-03-05', '09:00:00', '2018-03-05', '09:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '24', null, '8', '1');
INSERT INTO "event" VALUES ('5504', '30 - Rita Muller', ' ', '2018-03-05', '09:15:00', '2018-03-05', '09:30:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5506', '6 - Hanna Moos', ' ', '2018-03-05', '09:30:00', '2018-03-05', '09:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '6', null, '8', '1');
INSERT INTO "event" VALUES ('5508', '30 - Rita Muller', ' ', '2018-03-05', '09:45:00', '2018-03-05', '10:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '30', null, '8', '1');
INSERT INTO "event" VALUES ('5510', '5 - Christina Berglund', ' ', '2018-03-05', '10:00:00', '2018-03-05', '10:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5512', '11 - Victoria Ashworth', ' ', '2018-03-05', '10:15:00', '2018-03-05', '10:30:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5514', '5 - Christina Berglund', ' ', '2018-03-05', '10:30:00', '2018-03-05', '10:45:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '5', null, '8', '1');
INSERT INTO "event" VALUES ('5516', '12 - Patricio Simpson', ' ', '2018-03-05', '10:45:00', '2018-03-05', '11:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '12', null, '9', '1');
INSERT INTO "event" VALUES ('5518', '8 - Martin Sommer', ' ', '2018-03-05', '11:00:00', '2018-03-05', '11:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '8', null, '8', '1');
INSERT INTO "event" VALUES ('5520', '21 - Aria Cruz', ' ', '2018-03-05', '11:15:00', '2018-03-05', '11:30:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5522', '24 - Maria Larsson', ' ', '2018-03-05', '11:30:00', '2018-03-05', '11:45:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '24', null, '9', '1');
INSERT INTO "event" VALUES ('5524', '21 - Aria Cruz', ' ', '2018-03-05', '11:45:00', '2018-03-05', '12:00:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '21', null, '8', '1');
INSERT INTO "event" VALUES ('5546', '26 - Carine Schmitt', ' ', '2018-03-06', '12:00:00', '2018-03-06', '12:15:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '26', null, '8', '1');
INSERT INTO "event" VALUES ('5548', '20 - Roland Mendel', ' ', '2018-03-06', '12:15:00', '2018-03-06', '12:30:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5550', '25 - Peter Franken', ' ', '2018-03-06', '12:30:00', '2018-03-06', '12:45:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '25', null, '8', '1');
INSERT INTO "event" VALUES ('5552', '17 - Sven Ottlieb', ' ', '2018-03-06', '12:45:00', '2018-03-06', '13:00:00', 'N', 'D', '4', null, null, null, null, null, null, '4', '17', null, '8', '1');
INSERT INTO "event" VALUES ('5554', '8 - Martin Sommer', ' ', '2018-03-06', '13:00:00', '2018-03-06', '13:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '8', null, '8', '1');
INSERT INTO "event" VALUES ('5556', '16 - Elizabeth Brown', ' ', '2018-03-06', '13:15:00', '2018-03-06', '13:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '16', null, '8', '1');
INSERT INTO "event" VALUES ('5558', '22 - Diego Roel', ' ', '2018-03-06', '13:30:00', '2018-03-06', '13:45:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5560', '11 - Victoria Ashworth', ' ', '2018-03-06', '13:45:00', '2018-03-06', '14:00:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '11', null, '9', '1');
INSERT INTO "event" VALUES ('5562', '11 - Victoria Ashworth', ' ', '2018-03-06', '14:00:00', '2018-03-06', '14:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5564', '12 - Patricio Simpson', ' ', '2018-03-06', '14:15:00', '2018-03-06', '14:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '12', null, '9', '1');
INSERT INTO "event" VALUES ('5566', '22 - Diego Roel', ' ', '2018-03-06', '14:30:00', '2018-03-06', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '4', '22', null, '8', '1');
INSERT INTO "event" VALUES ('5568', '20 - Roland Mendel', ' ', '2018-03-06', '14:45:00', '2018-03-06', '15:00:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '20', null, '8', '1');
INSERT INTO "event" VALUES ('5570', '4 - Thomas Hardy', ' ', '2018-03-06', '15:00:00', '2018-03-06', '15:15:00', 'N', 'D', '3', null, null, null, null, null, null, '4', '4', null, '8', '1');
INSERT INTO "event" VALUES ('5572', '18 - Janine Labrune', ' ', '2018-03-06', '15:15:00', '2018-03-06', '15:30:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '18', null, '8', '2');
INSERT INTO "event" VALUES ('5574', '11 - Victoria Ashworth', ' ', '2018-03-06', '15:30:00', '2018-03-06', '15:45:00', 'N', 'D', '6', null, null, null, null, null, null, '4', '11', null, '8', '1');
INSERT INTO "event" VALUES ('5576', '23 - Martine Rance', ' ', '2018-03-06', '15:45:00', '2018-03-06', '16:00:00', 'N', 'D', '5', null, null, null, null, null, null, '4', '23', null, '8', '1');
INSERT INTO "event" VALUES ('5578', '29 - Paul Henriot', ' ', '2018-03-06', '16:00:00', '2018-03-06', '16:15:00', 'N', 'D', '7', null, null, null, null, null, null, '4', '29', null, '8', '1');
INSERT INTO "event" VALUES ('5580', '22 - Diego Roel', ' ', '2018-03-06', '16:15:00', '2018-03-06', '16:30:00', 'N', 'D', '8', null, null, null, null, null, null, '4', '22', null, '9', '1');
INSERT INTO "event" VALUES ('6017', '26 - Carine Schmitt', ' ', '2018-03-09', '08:00:00', '2018-03-09', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6019', '30 - Rita Muller', ' ', '2018-03-09', '08:15:00', '2018-03-09', '08:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6021', '21 - Aria Cruz', ' ', '2018-03-09', '08:30:00', '2018-03-09', '08:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '21', null, '4', '1');
INSERT INTO "event" VALUES ('6023', '30 - Rita Muller', ' ', '2018-03-09', '08:45:00', '2018-03-09', '09:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6025', '25 - Peter Franken', ' ', '2018-03-09', '09:00:00', '2018-03-09', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '25', null, '4', '1');
INSERT INTO "event" VALUES ('6027', '1 - Liu Wong', ' ', '2018-03-09', '09:15:00', '2018-03-09', '09:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '1', null, '4', '1');
INSERT INTO "event" VALUES ('6029', '9 - Laurence Lebihan', ' ', '2018-03-09', '09:30:00', '2018-03-09', '09:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '9', null, '4', '1');
INSERT INTO "event" VALUES ('6031', '2 - Ana Trujillo', ' ', '2018-03-09', '09:45:00', '2018-03-09', '10:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6033', '26 - Carine Schmitt', ' ', '2018-03-09', '10:00:00', '2018-03-09', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6035', '17 - Sven Ottlieb', ' ', '2018-03-09', '10:15:00', '2018-03-09', '10:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '17', null, '4', '1');
INSERT INTO "event" VALUES ('6037', '28 - Mary Saveley', ' ', '2018-03-09', '10:30:00', '2018-03-09', '10:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6039', '25 - Peter Franken', ' ', '2018-03-09', '10:45:00', '2018-03-09', '11:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '25', null, '4', '1');
INSERT INTO "event" VALUES ('6041', '7 - Frederique Citeaux', ' ', '2018-03-09', '11:00:00', '2018-03-09', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '7', null, '4', '1');
INSERT INTO "event" VALUES ('6043', '8 - Martin Sommer', ' ', '2018-03-09', '11:15:00', '2018-03-09', '11:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '8', null, '4', '1');
INSERT INTO "event" VALUES ('6045', '4 - Thomas Hardy', ' ', '2018-03-09', '11:30:00', '2018-03-09', '11:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6047', '11 - Victoria Ashworth', ' ', '2018-03-09', '11:45:00', '2018-03-09', '12:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '11', null, '4', '1');
INSERT INTO "event" VALUES ('6049', '20 - Roland Mendel', ' ', '2018-03-09', '12:00:00', '2018-03-09', '12:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6085', '28 - Mary Saveley', ' ', '2018-03-07', '14:00:00', '2018-03-07', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6087', '4 - Thomas Hardy', ' ', '2018-03-07', '14:15:00', '2018-03-07', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6089', '30 - Rita Muller', ' ', '2018-03-07', '14:30:00', '2018-03-07', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6091', '2 - Ana Trujillo', ' ', '2018-03-07', '14:45:00', '2018-03-07', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6093', '15 - Pedro Afonso', ' ', '2018-03-07', '15:00:00', '2018-03-07', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6095', '2 - Ana Trujillo', ' ', '2018-03-07', '15:15:00', '2018-03-07', '15:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6097', '19 - Ann Devon', ' ', '2018-03-07', '15:30:00', '2018-03-07', '15:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6099', '15 - Pedro Afonso', ' ', '2018-03-07', '15:45:00', '2018-03-07', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6101', '10 - Elizabeth Lincoln', ' ', '2018-03-07', '16:00:00', '2018-03-07', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6103', '12 - Patricio Simpson', ' ', '2018-03-07', '16:15:00', '2018-03-07', '16:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6105', '29 - Paul Henriot', ' ', '2018-03-07', '16:30:00', '2018-03-07', '16:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '29', null, '4', '1');
INSERT INTO "event" VALUES ('6107', '20 - Roland Mendel', ' ', '2018-03-07', '16:45:00', '2018-03-07', '17:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6109', '16 - Elizabeth Brown', ' ', '2018-03-07', '17:00:00', '2018-03-07', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '16', null, '4', '1');
INSERT INTO "event" VALUES ('6111', '10 - Elizabeth Lincoln', ' ', '2018-03-07', '17:15:00', '2018-03-07', '17:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6113', '20 - Roland Mendel', ' ', '2018-03-07', '17:30:00', '2018-03-07', '17:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6115', '26 - Carine Schmitt', ' ', '2018-03-08', '13:00:00', '2018-03-08', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6117', '12 - Patricio Simpson', ' ', '2018-03-08', '14:00:00', '2018-03-08', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6119', '9 - Laurence Lebihan', ' ', '2018-03-08', '15:00:00', '2018-03-08', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '9', null, '4', '1');
INSERT INTO "event" VALUES ('6121', '19 - Ann Devon', ' ', '2018-03-08', '16:00:00', '2018-03-08', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6123', '14 - Yang Wang', ' ', '2018-03-08', '17:00:00', '2018-03-08', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6125', '24 - Maria Larsson', ' ', '2018-03-08', '18:00:00', '2018-03-08', '18:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '24', null, '4', '1');
INSERT INTO "event" VALUES ('6145', '14 - Yang Wang', ' ', '2018-03-09', '08:00:00', '2018-03-09', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6147', '2 - Ana Trujillo', ' ', '2018-03-09', '08:15:00', '2018-03-09', '08:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6149', '2 - Ana Trujillo', ' ', '2018-03-09', '08:30:00', '2018-03-09', '08:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6151', '3 - Antonio Moreno', ' ', '2018-03-09', '08:45:00', '2018-03-09', '09:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '3', null, '4', '1');
INSERT INTO "event" VALUES ('6153', '28 - Mary Saveley', ' ', '2018-03-09', '09:00:00', '2018-03-09', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6155', '14 - Yang Wang', ' ', '2018-03-09', '09:15:00', '2018-03-09', '09:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6157', '9 - Laurence Lebihan', ' ', '2018-03-09', '09:30:00', '2018-03-09', '09:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '9', null, '4', '1');
INSERT INTO "event" VALUES ('6159', '13 - Francisco Chang', ' ', '2018-03-09', '09:45:00', '2018-03-09', '10:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '13', null, '4', '1');
INSERT INTO "event" VALUES ('6161', '19 - Ann Devon', ' ', '2018-03-09', '10:00:00', '2018-03-09', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6163', '13 - Francisco Chang', ' ', '2018-03-09', '10:15:00', '2018-03-09', '10:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '13', null, '4', '1');
INSERT INTO "event" VALUES ('6165', '16 - Elizabeth Brown', ' ', '2018-03-09', '10:30:00', '2018-03-09', '10:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '16', null, '4', '1');
INSERT INTO "event" VALUES ('6167', '19 - Ann Devon', ' ', '2018-03-09', '10:45:00', '2018-03-09', '11:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6169', '28 - Mary Saveley', ' ', '2018-03-09', '11:00:00', '2018-03-09', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6171', '17 - Sven Ottlieb', ' ', '2018-03-09', '11:15:00', '2018-03-09', '11:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '4', '1');
INSERT INTO "event" VALUES ('6173', '19 - Ann Devon', ' ', '2018-03-09', '11:30:00', '2018-03-09', '11:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6175', '7 - Frederique Citeaux', ' ', '2018-03-09', '14:00:00', '2018-03-09', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '7', null, '4', '1');
INSERT INTO "event" VALUES ('6177', '21 - Aria Cruz', ' ', '2018-03-09', '14:15:00', '2018-03-09', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '21', null, '4', '1');
INSERT INTO "event" VALUES ('6179', '29 - Paul Henriot', ' ', '2018-03-09', '14:30:00', '2018-03-09', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '29', null, '4', '1');
INSERT INTO "event" VALUES ('6181', '22 - Diego Roel', ' ', '2018-03-09', '14:45:00', '2018-03-09', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '22', null, '4', '1');
INSERT INTO "event" VALUES ('6183', '10 - Elizabeth Lincoln', ' ', '2018-03-09', '15:00:00', '2018-03-09', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6185', '18 - Janine Labrune', ' ', '2018-03-09', '15:15:00', '2018-03-09', '15:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '18', null, '4', '1');
INSERT INTO "event" VALUES ('6187', '22 - Diego Roel', ' ', '2018-03-09', '15:30:00', '2018-03-09', '15:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '22', null, '4', '1');
INSERT INTO "event" VALUES ('6189', '18 - Janine Labrune', ' ', '2018-03-09', '15:45:00', '2018-03-09', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '18', null, '4', '1');
INSERT INTO "event" VALUES ('6191', '20 - Roland Mendel', ' ', '2018-03-09', '16:00:00', '2018-03-09', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6193', '23 - Martine Rance', ' ', '2018-03-09', '16:15:00', '2018-03-09', '16:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '23', null, '4', '1');
INSERT INTO "event" VALUES ('6195', '15 - Pedro Afonso', ' ', '2018-03-09', '16:30:00', '2018-03-09', '16:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6197', '28 - Mary Saveley', ' ', '2018-03-09', '16:45:00', '2018-03-09', '17:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6199', '17 - Sven Ottlieb', ' ', '2018-03-09', '17:00:00', '2018-03-09', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '4', '1');
INSERT INTO "event" VALUES ('6201', '17 - Sven Ottlieb', ' ', '2018-03-09', '17:15:00', '2018-03-09', '17:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '4', '1');
INSERT INTO "event" VALUES ('6203', '10 - Elizabeth Lincoln', ' ', '2018-03-09', '17:30:00', '2018-03-09', '17:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6205', '5 - Christina Berglund', ' ', '2018-03-09', '08:00:00', '2018-03-09', '08:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '5', null, '4', '1');
INSERT INTO "event" VALUES ('6207', '29 - Paul Henriot', ' ', '2018-03-09', '08:15:00', '2018-03-09', '08:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '29', null, '4', '1');
INSERT INTO "event" VALUES ('6209', '18 - Janine Labrune', ' ', '2018-03-09', '08:30:00', '2018-03-09', '08:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '18', null, '4', '1');
INSERT INTO "event" VALUES ('6211', '20 - Roland Mendel', ' ', '2018-03-09', '08:45:00', '2018-03-09', '09:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6213', '27 - Paolo Accorti', ' ', '2018-03-09', '09:00:00', '2018-03-09', '09:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '4', '1');
INSERT INTO "event" VALUES ('6215', '20 - Roland Mendel', ' ', '2018-03-09', '09:15:00', '2018-03-09', '09:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6217', '12 - Patricio Simpson', ' ', '2018-03-09', '09:30:00', '2018-03-09', '09:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6219', '4 - Thomas Hardy', ' ', '2018-03-09', '09:45:00', '2018-03-09', '10:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6221', '28 - Mary Saveley', ' ', '2018-03-09', '10:00:00', '2018-03-09', '10:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6223', '22 - Diego Roel', ' ', '2018-03-09', '10:15:00', '2018-03-09', '10:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '22', null, '4', '1');
INSERT INTO "event" VALUES ('6225', '28 - Mary Saveley', ' ', '2018-03-09', '10:30:00', '2018-03-09', '10:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6227', '2 - Ana Trujillo', ' ', '2018-03-09', '10:45:00', '2018-03-09', '11:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6229', '2 - Ana Trujillo', ' ', '2018-03-09', '11:00:00', '2018-03-09', '11:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6231', '27 - Paolo Accorti', ' ', '2018-03-09', '11:15:00', '2018-03-09', '11:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '4', '1');
INSERT INTO "event" VALUES ('6233', '15 - Pedro Afonso', ' ', '2018-03-09', '11:30:00', '2018-03-09', '11:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6235', '13 - Francisco Chang', ' ', '2018-03-09', '11:45:00', '2018-03-09', '12:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '13', null, '4', '1');
INSERT INTO "event" VALUES ('6237', '7 - Frederique Citeaux', ' ', '2018-03-09', '12:00:00', '2018-03-09', '12:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '7', null, '4', '1');
INSERT INTO "event" VALUES ('6239', '7 - Frederique Citeaux', ' ', '2018-03-09', '12:15:00', '2018-03-09', '12:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '7', null, '4', '1');
INSERT INTO "event" VALUES ('6241', '14 - Yang Wang', ' ', '2018-03-09', '12:30:00', '2018-03-09', '12:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6243', '14 - Yang Wang', ' ', '2018-03-09', '12:45:00', '2018-03-09', '13:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6245', '20 - Roland Mendel', ' ', '2018-03-09', '13:00:00', '2018-03-09', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6279', '2 - Ana Trujillo', ' ', '2018-03-08', '14:00:00', '2018-03-08', '14:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6281', '21 - Aria Cruz', ' ', '2018-03-08', '14:15:00', '2018-03-08', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '21', null, '4', '1');
INSERT INTO "event" VALUES ('6283', '14 - Yang Wang', ' ', '2018-03-08', '14:30:00', '2018-03-08', '14:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6285', '2 - Ana Trujillo', ' ', '2018-03-08', '14:45:00', '2018-03-08', '15:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6287', '2 - Ana Trujillo', ' ', '2018-03-08', '15:00:00', '2018-03-08', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6289', '4 - Thomas Hardy', ' ', '2018-03-08', '15:15:00', '2018-03-08', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6291', '19 - Ann Devon', ' ', '2018-03-08', '15:30:00', '2018-03-08', '15:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6293', '27 - Paolo Accorti', ' ', '2018-03-08', '15:45:00', '2018-03-08', '16:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '4', '1');
INSERT INTO "event" VALUES ('6295', '3 - Antonio Moreno', ' ', '2018-03-08', '16:00:00', '2018-03-08', '16:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '4', '1');
INSERT INTO "event" VALUES ('6297', '18 - Janine Labrune', ' ', '2018-03-08', '16:15:00', '2018-03-08', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '18', null, '4', '1');
INSERT INTO "event" VALUES ('6335', '18 - Janine Labrune', ' ', '2018-03-07', '08:00:00', '2018-03-07', '08:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '18', null, '4', '1');
INSERT INTO "event" VALUES ('6337', '12 - Patricio Simpson', ' ', '2018-03-07', '08:15:00', '2018-03-07', '08:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6339', '29 - Paul Henriot', ' ', '2018-03-07', '08:30:00', '2018-03-07', '08:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '29', null, '4', '1');
INSERT INTO "event" VALUES ('6341', '20 - Roland Mendel', ' ', '2018-03-07', '08:45:00', '2018-03-07', '09:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6343', '1 - Liu Wong', ' ', '2018-03-07', '09:00:00', '2018-03-07', '09:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '1', null, '4', '1');
INSERT INTO "event" VALUES ('6345', '16 - Elizabeth Brown', ' ', '2018-03-07', '09:15:00', '2018-03-07', '09:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '16', null, '4', '1');
INSERT INTO "event" VALUES ('6347', '11 - Victoria Ashworth', ' ', '2018-03-07', '09:30:00', '2018-03-07', '09:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '11', null, '4', '1');
INSERT INTO "event" VALUES ('6349', '26 - Carine Schmitt', ' ', '2018-03-07', '09:45:00', '2018-03-07', '10:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6351', '30 - Rita Muller', ' ', '2018-03-07', '10:00:00', '2018-03-07', '10:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6353', '9 - Laurence Lebihan', ' ', '2018-03-07', '10:15:00', '2018-03-07', '10:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '9', null, '4', '1');
INSERT INTO "event" VALUES ('6355', '25 - Peter Franken', ' ', '2018-03-07', '10:30:00', '2018-03-07', '10:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '4', '1');
INSERT INTO "event" VALUES ('6357', '16 - Elizabeth Brown', ' ', '2018-03-07', '10:45:00', '2018-03-07', '11:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '16', null, '4', '1');
INSERT INTO "event" VALUES ('6359', '17 - Sven Ottlieb', ' ', '2018-03-07', '11:00:00', '2018-03-07', '11:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '17', null, '4', '1');
INSERT INTO "event" VALUES ('6361', '19 - Ann Devon', ' ', '2018-03-07', '11:15:00', '2018-03-07', '11:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6363', '24 - Maria Larsson', ' ', '2018-03-07', '11:30:00', '2018-03-07', '11:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '24', null, '4', '1');
INSERT INTO "event" VALUES ('6365', '19 - Ann Devon', ' ', '2018-03-07', '11:45:00', '2018-03-07', '12:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '19', null, '4', '1');
INSERT INTO "event" VALUES ('6367', '25 - Peter Franken', ' ', '2018-03-07', '12:00:00', '2018-03-07', '12:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '4', '1');
INSERT INTO "event" VALUES ('6859', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '12:00:00', '2018-03-12', '12:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6860', '2 - Ana Trujillo', ' ', '2018-03-12', '12:15:00', '2018-03-12', '12:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6861', '4 - Thomas Hardy', ' ', '2018-03-12', '12:30:00', '2018-03-12', '12:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6862', '20 - Roland Mendel', ' ', '2018-03-12', '12:45:00', '2018-03-12', '13:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '20', null, '4', '1');
INSERT INTO "event" VALUES ('6863', '12 - Patricio Simpson', ' ', '2018-03-12', '13:00:00', '2018-03-12', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6864', '3 - Antonio Moreno', ' ', '2018-03-12', '13:15:00', '2018-03-12', '13:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '4', '1');
INSERT INTO "event" VALUES ('6865', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '13:30:00', '2018-03-12', '13:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6866', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '13:45:00', '2018-03-12', '14:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6867', '7 - Frederique Citeaux', ' ', '2018-03-12', '14:00:00', '2018-03-12', '14:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '7', null, '4', '1');
INSERT INTO "event" VALUES ('6868', '2 - Ana Trujillo', ' ', '2018-03-12', '14:15:00', '2018-03-12', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '2', null, '4', '1');
INSERT INTO "event" VALUES ('6869', '24 - Maria Larsson', ' ', '2018-03-12', '14:30:00', '2018-03-12', '14:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '24', null, '4', '1');
INSERT INTO "event" VALUES ('6870', '24 - Maria Larsson', ' ', '2018-03-12', '14:45:00', '2018-03-12', '15:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '24', null, '4', '1');
INSERT INTO "event" VALUES ('6871', '11 - Victoria Ashworth', ' ', '2018-03-12', '15:00:00', '2018-03-12', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '11', null, '4', '1');
INSERT INTO "event" VALUES ('6872', '14 - Yang Wang', ' ', '2018-03-12', '15:15:00', '2018-03-12', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6873', '30 - Rita Muller', ' ', '2018-03-12', '15:30:00', '2018-03-12', '15:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6874', '15 - Pedro Afonso', ' ', '2018-03-12', '15:45:00', '2018-03-12', '16:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6875', '27 - Paolo Accorti', ' ', '2018-03-12', '16:00:00', '2018-03-12', '16:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '4', '1');
INSERT INTO "event" VALUES ('6876', '12 - Patricio Simpson', ' ', '2018-03-12', '16:15:00', '2018-03-12', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6877', '26 - Carine Schmitt', ' ', '2018-03-12', '08:00:00', '2018-03-12', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6878', '4 - Thomas Hardy', ' ', '2018-03-12', '09:00:00', '2018-03-12', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6879', '14 - Yang Wang', ' ', '2018-03-12', '10:00:00', '2018-03-12', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '14', null, '4', '1');
INSERT INTO "event" VALUES ('6880', '12 - Patricio Simpson', ' ', '2018-03-12', '11:00:00', '2018-03-12', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '12', null, '4', '1');
INSERT INTO "event" VALUES ('6881', '29 - Paul Henriot', ' ', '2018-03-12', '13:00:00', '2018-03-12', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '29', null, '4', '1');
INSERT INTO "event" VALUES ('6882', '6 - Hanna Moos', ' ', '2018-03-12', '14:00:00', '2018-03-12', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '6', null, '4', '1');
INSERT INTO "event" VALUES ('6883', '25 - Peter Franken', ' ', '2018-03-12', '15:00:00', '2018-03-12', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '25', null, '4', '1');
INSERT INTO "event" VALUES ('6884', '6 - Hanna Moos', ' ', '2018-03-12', '16:00:00', '2018-03-12', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '6', null, '4', '1');
INSERT INTO "event" VALUES ('6885', '28 - Mary Saveley', ' ', '2018-03-12', '17:00:00', '2018-03-12', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6886', '28 - Mary Saveley', ' ', '2018-03-12', '13:00:00', '2018-03-12', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '28', null, '4', '1');
INSERT INTO "event" VALUES ('6887', '27 - Paolo Accorti', ' ', '2018-03-12', '13:15:00', '2018-03-12', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '27', null, '4', '1');
INSERT INTO "event" VALUES ('6888', '4 - Thomas Hardy', ' ', '2018-03-12', '13:30:00', '2018-03-12', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '4', null, '4', '1');
INSERT INTO "event" VALUES ('6889', '15 - Pedro Afonso', ' ', '2018-03-12', '13:45:00', '2018-03-12', '14:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '15', null, '4', '1');
INSERT INTO "event" VALUES ('6890', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '14:00:00', '2018-03-12', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6891', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '14:15:00', '2018-03-12', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6892', '10 - Elizabeth Lincoln', ' ', '2018-03-12', '14:30:00', '2018-03-12', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('6893', '30 - Rita Muller', ' ', '2018-03-12', '14:45:00', '2018-03-12', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '30', null, '4', '1');
INSERT INTO "event" VALUES ('6894', '13 - Francisco Chang', ' ', '2018-03-12', '15:00:00', '2018-03-12', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '13', null, '4', '1');
INSERT INTO "event" VALUES ('6895', '6 - Hanna Moos', ' ', '2018-03-12', '15:15:00', '2018-03-12', '15:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '6', null, '4', '1');
INSERT INTO "event" VALUES ('6896', '26 - Carine Schmitt', ' ', '2018-03-12', '15:30:00', '2018-03-12', '15:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('6897', '5 - Christina Berglund', ' ', '2018-03-12', '15:45:00', '2018-03-12', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '5', null, '4', '1');
INSERT INTO "event" VALUES ('6898', '26 - Carine Schmitt', ' ', '2018-03-12', '16:00:00', '2018-03-12', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('7397', '1 - Liu Wong', ' ', '2018-03-13', '12:00:00', '2018-03-13', '12:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '1', null, '4', '1');
INSERT INTO "event" VALUES ('7398', '8 - Martin Sommer', ' ', '2018-03-13', '12:15:00', '2018-03-13', '12:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '8', null, '4', '1');
INSERT INTO "event" VALUES ('7399', '17 - Sven Ottlieb', ' ', '2018-03-13', '12:30:00', '2018-03-13', '12:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '17', null, '4', '1');
INSERT INTO "event" VALUES ('7400', '25 - Peter Franken', ' ', '2018-03-13', '12:45:00', '2018-03-13', '13:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '4', '1');
INSERT INTO "event" VALUES ('7401', '8 - Martin Sommer', ' ', '2018-03-13', '13:00:00', '2018-03-13', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '8', null, '4', '1');
INSERT INTO "event" VALUES ('7402', '3 - Antonio Moreno', ' ', '2018-03-13', '13:15:00', '2018-03-13', '13:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '4', '1');
INSERT INTO "event" VALUES ('7403', '23 - Martine Rance', ' ', '2018-03-13', '13:30:00', '2018-03-13', '13:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '23', null, '4', '1');
INSERT INTO "event" VALUES ('7404', '7 - Frederique Citeaux', ' ', '2018-03-13', '13:45:00', '2018-03-13', '14:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '7', null, '4', '1');
INSERT INTO "event" VALUES ('7405', '29 - Paul Henriot', ' ', '2018-03-13', '14:00:00', '2018-03-13', '14:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '29', null, '4', '1');
INSERT INTO "event" VALUES ('7406', '7 - Frederique Citeaux', ' ', '2018-03-13', '14:15:00', '2018-03-13', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '7', null, '4', '1');
INSERT INTO "event" VALUES ('7407', '23 - Martine Rance', ' ', '2018-03-13', '14:30:00', '2018-03-13', '14:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '23', null, '4', '1');
INSERT INTO "event" VALUES ('7408', '24 - Maria Larsson', ' ', '2018-03-13', '14:45:00', '2018-03-13', '15:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '24', null, '4', '1');
INSERT INTO "event" VALUES ('7409', '10 - Elizabeth Lincoln', ' ', '2018-03-13', '15:00:00', '2018-03-13', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '10', null, '4', '1');
INSERT INTO "event" VALUES ('7410', '23 - Martine Rance', ' ', '2018-03-13', '15:15:00', '2018-03-13', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '23', null, '4', '1');
INSERT INTO "event" VALUES ('7411', '15 - Pedro Afonso', ' ', '2018-03-13', '15:30:00', '2018-03-13', '15:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '15', null, '4', '1');
INSERT INTO "event" VALUES ('7412', '10 - Elizabeth Lincoln', ' ', '2018-03-13', '15:45:00', '2018-03-13', '16:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '10', null, '4', '1');
INSERT INTO "event" VALUES ('7413', '27 - Paolo Accorti', ' ', '2018-03-13', '16:00:00', '2018-03-13', '16:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '27', null, '4', '1');
INSERT INTO "event" VALUES ('7414', '14 - Yang Wang', ' ', '2018-03-13', '16:15:00', '2018-03-13', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '14', null, '4', '1');
INSERT INTO "event" VALUES ('7415', '29 - Paul Henriot', ' ', '2018-03-13', '08:00:00', '2018-03-13', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '29', null, '4', '1');
INSERT INTO "event" VALUES ('7416', '11 - Victoria Ashworth', ' ', '2018-03-13', '09:00:00', '2018-03-13', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '11', null, '4', '1');
INSERT INTO "event" VALUES ('7417', '8 - Martin Sommer', ' ', '2018-03-13', '10:00:00', '2018-03-13', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '8', null, '4', '1');
INSERT INTO "event" VALUES ('7418', '6 - Hanna Moos', ' ', '2018-03-13', '11:00:00', '2018-03-13', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '6', null, '4', '1');
INSERT INTO "event" VALUES ('7419', '23 - Martine Rance', ' ', '2018-03-13', '13:00:00', '2018-03-13', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '23', null, '4', '1');
INSERT INTO "event" VALUES ('7420', '24 - Maria Larsson', ' ', '2018-03-13', '14:00:00', '2018-03-13', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '24', null, '4', '1');
INSERT INTO "event" VALUES ('7421', '15 - Pedro Afonso', ' ', '2018-03-13', '15:00:00', '2018-03-13', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '15', null, '4', '1');
INSERT INTO "event" VALUES ('7422', '17 - Sven Ottlieb', ' ', '2018-03-13', '16:00:00', '2018-03-13', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '17', null, '4', '1');
INSERT INTO "event" VALUES ('7423', '18 - Janine Labrune', ' ', '2018-03-13', '17:00:00', '2018-03-13', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '18', null, '4', '1');
INSERT INTO "event" VALUES ('7424', '22 - Diego Roel', ' ', '2018-03-13', '13:00:00', '2018-03-13', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '22', null, '4', '1');
INSERT INTO "event" VALUES ('7425', '7 - Frederique Citeaux', ' ', '2018-03-13', '13:15:00', '2018-03-13', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '7', null, '4', '1');
INSERT INTO "event" VALUES ('7426', '26 - Carine Schmitt', ' ', '2018-03-13', '13:30:00', '2018-03-13', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('7427', '11 - Victoria Ashworth', ' ', '2018-03-13', '13:45:00', '2018-03-13', '14:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '11', null, '4', '1');
INSERT INTO "event" VALUES ('7428', '23 - Martine Rance', ' ', '2018-03-13', '14:00:00', '2018-03-13', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '23', null, '4', '1');
INSERT INTO "event" VALUES ('7429', '15 - Pedro Afonso', ' ', '2018-03-13', '14:15:00', '2018-03-13', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '15', null, '4', '1');
INSERT INTO "event" VALUES ('7430', '17 - Sven Ottlieb', ' ', '2018-03-13', '14:30:00', '2018-03-13', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '17', null, '4', '1');
INSERT INTO "event" VALUES ('7431', '26 - Carine Schmitt', ' ', '2018-03-13', '14:45:00', '2018-03-13', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '26', null, '4', '1');
INSERT INTO "event" VALUES ('7432', '13 - Francisco Chang', ' ', '2018-03-13', '15:00:00', '2018-03-13', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '13', null, '4', '1');
INSERT INTO "event" VALUES ('7433', '29 - Paul Henriot', ' ', '2018-03-13', '15:15:00', '2018-03-13', '15:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '29', null, '4', '1');
INSERT INTO "event" VALUES ('7434', '21 - Aria Cruz', ' ', '2018-03-13', '15:30:00', '2018-03-13', '15:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '21', null, '4', '1');
INSERT INTO "event" VALUES ('7435', '13 - Francisco Chang', ' ', '2018-03-13', '15:45:00', '2018-03-13', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '13', null, '4', '1');
INSERT INTO "event" VALUES ('7436', '4 - Thomas Hardy', ' ', '2018-03-13', '16:00:00', '2018-03-13', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '4', null, '4', '1');
INSERT INTO "event" VALUES ('7437', '24 - Maria Larsson', ' ', '2018-03-13', '12:00:00', '2018-03-13', '12:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '24', null, '4', '1');
INSERT INTO "event" VALUES ('7438', '21 - Aria Cruz', ' ', '2018-03-13', '12:15:00', '2018-03-13', '12:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '21', null, '4', '1');
INSERT INTO "event" VALUES ('7439', '12 - Patricio Simpson', ' ', '2018-03-13', '12:30:00', '2018-03-13', '12:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '12', null, '4', '1');
INSERT INTO "event" VALUES ('7440', '11 - Victoria Ashworth', ' ', '2018-03-13', '12:45:00', '2018-03-13', '13:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '11', null, '4', '1');
INSERT INTO "event" VALUES ('7441', '19 - Ann Devon', ' ', '2018-03-13', '13:00:00', '2018-03-13', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '19', null, '4', '1');
INSERT INTO "event" VALUES ('7442', '8 - Martin Sommer', ' ', '2018-03-13', '13:15:00', '2018-03-13', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '8', null, '4', '1');
INSERT INTO "event" VALUES ('7443', '21 - Aria Cruz', ' ', '2018-03-13', '13:30:00', '2018-03-13', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '21', null, '4', '1');
INSERT INTO "event" VALUES ('7444', '13 - Francisco Chang', ' ', '2018-03-13', '13:45:00', '2018-03-13', '14:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '13', null, '4', '1');
INSERT INTO "event" VALUES ('7445', '2 - Ana Trujillo', ' ', '2018-03-13', '14:00:00', '2018-03-13', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '2', null, '4', '1');
INSERT INTO "event" VALUES ('7446', '9 - Laurence Lebihan', ' ', '2018-03-13', '14:15:00', '2018-03-13', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '9', null, '4', '1');
INSERT INTO "event" VALUES ('7447', '20 - Roland Mendel', ' ', '2018-03-13', '14:30:00', '2018-03-13', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '20', null, '4', '1');
INSERT INTO "event" VALUES ('7448', '16 - Elizabeth Brown', ' ', '2018-03-13', '14:45:00', '2018-03-13', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '16', null, '4', '1');
INSERT INTO "event" VALUES ('7449', '29 - Paul Henriot', ' ', '2018-03-13', '15:00:00', '2018-03-13', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '29', null, '4', '1');
INSERT INTO "event" VALUES ('12729', '1 - Liu Wong', ' ', '2018-03-14', '12:00:00', '2018-03-14', '12:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '1', null, '4', '1');
INSERT INTO "event" VALUES ('12730', '25 - Peter Franken', ' ', '2018-03-14', '12:15:00', '2018-03-14', '12:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '4', '1');
INSERT INTO "event" VALUES ('12731', '3 - Antonio Moreno', ' ', '2018-03-14', '12:30:00', '2018-03-14', '12:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '4', '1');
INSERT INTO "event" VALUES ('12732', '28 - Mary Saveley', ' ', '2018-03-14', '12:45:00', '2018-03-14', '13:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '28', null, '4', '1');
INSERT INTO "event" VALUES ('12733', '6 - Hanna Moos', ' ', '2018-03-14', '13:00:00', '2018-03-14', '13:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '6', null, '4', '1');
INSERT INTO "event" VALUES ('12734', '29 - Paul Henriot', ' ', '2018-03-14', '13:15:00', '2018-03-14', '13:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '29', null, '4', '1');
INSERT INTO "event" VALUES ('12735', '8 - Martin Sommer', ' ', '2018-03-14', '13:30:00', '2018-03-14', '13:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '8', null, '4', '1');
INSERT INTO "event" VALUES ('12736', '3 - Antonio Moreno', ' ', '2018-03-14', '13:45:00', '2018-03-14', '14:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '3', null, '4', '1');
INSERT INTO "event" VALUES ('12737', '16 - Elizabeth Brown', ' ', '2018-03-14', '14:00:00', '2018-03-14', '14:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '16', null, '4', '1');
INSERT INTO "event" VALUES ('12738', '23 - Martine Rance', ' ', '2018-03-14', '14:15:00', '2018-03-14', '14:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '23', null, '4', '1');
INSERT INTO "event" VALUES ('12739', '11 - Victoria Ashworth', ' ', '2018-03-14', '14:30:00', '2018-03-14', '14:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '11', null, '4', '1');
INSERT INTO "event" VALUES ('12740', '25 - Peter Franken', ' ', '2018-03-14', '14:45:00', '2018-03-14', '15:00:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '25', null, '4', '1');
INSERT INTO "event" VALUES ('12741', '28 - Mary Saveley', ' ', '2018-03-14', '15:00:00', '2018-03-14', '15:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '28', null, '4', '1');
INSERT INTO "event" VALUES ('12742', '30 - Rita Muller', ' ', '2018-03-14', '15:15:00', '2018-03-14', '15:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '30', null, '4', '1');
INSERT INTO "event" VALUES ('12743', '11 - Victoria Ashworth', ' ', '2018-03-14', '15:30:00', '2018-03-14', '15:45:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '11', null, '4', '1');
INSERT INTO "event" VALUES ('12744', 'Available', ' ', '2018-03-14', '15:45:00', '2018-03-14', '16:00:00', 'N', 'D', '9', null, null, null, null, null, null, '4', null, null, '4', '1');
INSERT INTO "event" VALUES ('12745', '5 - Christina Berglund', ' ', '2018-03-14', '16:00:00', '2018-03-14', '16:15:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '5', null, '4', '1');
INSERT INTO "event" VALUES ('12746', '9 - Laurence Lebihan', ' ', '2018-03-14', '16:15:00', '2018-03-14', '16:30:00', 'N', 'D', '2', null, null, null, null, null, null, '4', '9', null, '4', '1');
INSERT INTO "event" VALUES ('12747', '21 - Aria Cruz', ' ', '2018-03-14', '08:00:00', '2018-03-14', '08:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '21', null, '4', '1');
INSERT INTO "event" VALUES ('12748', '10 - Elizabeth Lincoln', ' ', '2018-03-14', '09:00:00', '2018-03-14', '09:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '10', null, '4', '1');
INSERT INTO "event" VALUES ('12749', '9 - Laurence Lebihan', ' ', '2018-03-14', '10:00:00', '2018-03-14', '10:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '9', null, '4', '1');
INSERT INTO "event" VALUES ('12750', '24 - Maria Larsson', ' ', '2018-03-14', '11:00:00', '2018-03-14', '11:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '24', null, '4', '1');
INSERT INTO "event" VALUES ('12751', '9 - Laurence Lebihan', ' ', '2018-03-14', '13:00:00', '2018-03-14', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '9', null, '4', '1');
INSERT INTO "event" VALUES ('12752', '10 - Elizabeth Lincoln', ' ', '2018-03-14', '14:00:00', '2018-03-14', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '10', null, '4', '1');
INSERT INTO "event" VALUES ('12753', '23 - Martine Rance', ' ', '2018-03-14', '15:00:00', '2018-03-14', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '23', null, '4', '1');
INSERT INTO "event" VALUES ('12754', 'Available', ' ', '2018-03-14', '16:00:00', '2018-03-14', '16:15:00', 'N', 'D', '9', null, null, null, null, null, null, '2', null, null, '4', '1');
INSERT INTO "event" VALUES ('12755', '2 - Ana Trujillo', ' ', '2018-03-14', '17:00:00', '2018-03-14', '17:15:00', 'N', 'D', '1', null, null, null, null, null, null, '2', '2', null, '4', '1');
INSERT INTO "event" VALUES ('12756', 'Available', ' ', '2018-03-14', '13:00:00', '2018-03-14', '13:15:00', 'N', 'D', '9', null, null, null, null, null, null, '1', null, null, '4', '1');
INSERT INTO "event" VALUES ('12757', '6 - Hanna Moos', ' ', '2018-03-14', '13:15:00', '2018-03-14', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '6', null, '4', '1');
INSERT INTO "event" VALUES ('12758', '15 - Pedro Afonso', ' ', '2018-03-14', '13:30:00', '2018-03-14', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '15', null, '4', '1');
INSERT INTO "event" VALUES ('12759', '19 - Ann Devon', ' ', '2018-03-14', '13:45:00', '2018-03-14', '14:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '19', null, '4', '1');
INSERT INTO "event" VALUES ('12760', '29 - Paul Henriot', ' ', '2018-03-14', '14:00:00', '2018-03-14', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '29', null, '4', '1');
INSERT INTO "event" VALUES ('12761', '2 - Ana Trujillo', ' ', '2018-03-14', '14:15:00', '2018-03-14', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '2', null, '4', '1');
INSERT INTO "event" VALUES ('12762', '9 - Laurence Lebihan', ' ', '2018-03-14', '14:30:00', '2018-03-14', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '9', null, '4', '1');
INSERT INTO "event" VALUES ('12763', '6 - Hanna Moos', ' ', '2018-03-14', '14:45:00', '2018-03-14', '15:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '6', null, '4', '1');
INSERT INTO "event" VALUES ('12764', '12 - Patricio Simpson', ' ', '2018-03-14', '15:00:00', '2018-03-14', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '12', null, '4', '1');
INSERT INTO "event" VALUES ('12765', '10 - Elizabeth Lincoln', ' ', '2018-03-14', '15:15:00', '2018-03-14', '15:30:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '10', null, '4', '1');
INSERT INTO "event" VALUES ('12766', '14 - Yang Wang', ' ', '2018-03-14', '15:30:00', '2018-03-14', '15:45:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '14', null, '4', '1');
INSERT INTO "event" VALUES ('12767', '20 - Roland Mendel', ' ', '2018-03-14', '15:45:00', '2018-03-14', '16:00:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '20', null, '4', '1');
INSERT INTO "event" VALUES ('12768', '21 - Aria Cruz', ' ', '2018-03-14', '16:00:00', '2018-03-14', '16:15:00', 'N', 'D', '1', null, null, null, null, null, null, '1', '21', null, '4', '1');
INSERT INTO "event" VALUES ('12769', '17 - Sven Ottlieb', ' ', '2018-03-14', '12:00:00', '2018-03-14', '12:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '4', '1');
INSERT INTO "event" VALUES ('12770', '29 - Paul Henriot', ' ', '2018-03-14', '12:15:00', '2018-03-14', '12:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '29', null, '4', '1');
INSERT INTO "event" VALUES ('12771', '16 - Elizabeth Brown', ' ', '2018-03-14', '12:30:00', '2018-03-14', '12:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '16', null, '4', '1');
INSERT INTO "event" VALUES ('12772', '30 - Rita Muller', ' ', '2018-03-14', '12:45:00', '2018-03-14', '13:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '30', null, '4', '1');
INSERT INTO "event" VALUES ('12773', '28 - Mary Saveley', ' ', '2018-03-14', '13:00:00', '2018-03-14', '13:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '28', null, '4', '1');
INSERT INTO "event" VALUES ('12774', '17 - Sven Ottlieb', ' ', '2018-03-14', '13:15:00', '2018-03-14', '13:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '17', null, '4', '1');
INSERT INTO "event" VALUES ('12775', '27 - Paolo Accorti', ' ', '2018-03-14', '13:30:00', '2018-03-14', '13:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '27', null, '4', '1');
INSERT INTO "event" VALUES ('12776', '26 - Carine Schmitt', ' ', '2018-03-14', '13:45:00', '2018-03-14', '14:00:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '26', null, '4', '1');
INSERT INTO "event" VALUES ('12777', '30 - Rita Muller', ' ', '2018-03-14', '14:00:00', '2018-03-14', '14:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '30', null, '4', '1');
INSERT INTO "event" VALUES ('12778', '2 - Ana Trujillo', ' ', '2018-03-14', '14:15:00', '2018-03-14', '14:30:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '2', null, '4', '1');
INSERT INTO "event" VALUES ('12779', '5 - Christina Berglund', ' ', '2018-03-14', '14:30:00', '2018-03-14', '14:45:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '5', null, '4', '1');
INSERT INTO "event" VALUES ('12780', 'Available', ' ', '2018-03-14', '14:45:00', '2018-03-14', '15:00:00', 'N', 'D', '9', null, null, null, null, null, null, '3', null, null, '4', '1');
INSERT INTO "event" VALUES ('12781', '15 - Pedro Afonso', ' ', '2018-03-14', '15:00:00', '2018-03-14', '15:15:00', 'N', 'D', '1', null, null, null, null, null, null, '3', '15', null, '4', '1');

-- ----------------------------
-- Table structure for event_history
-- ----------------------------
DROP TABLE IF EXISTS "event_history";
CREATE TABLE "event_history" (
"idevent_history"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"idevent"  bigint NOT NULL,
"idevent_status"  bigint NOT NULL,
"date_event"  date NOT NULL,
"time_event"  time NOT NULL,
"login"  varchar(32) NOT NULL,
FOREIGN KEY ("idevent") REFERENCES "event" ("idevent"),
FOREIGN KEY ("idevent_status") REFERENCES "event_status" ("idevent_status"),
FOREIGN KEY ("login") REFERENCES "sec_users" ("login")
)

;

-- ----------------------------
-- Records of event_history
-- ----------------------------
INSERT INTO "event_history" VALUES (1, 5265, 2, '2018-02-23', '09:52:02', 'admin');
INSERT INTO "event_history" VALUES (2, 5650, 2, '2018-02-26', '08:39:22', 'megan');
INSERT INTO "event_history" VALUES (3, 5650, 3, '2018-02-26', '08:45:37', 'megan');
INSERT INTO "event_history" VALUES (4, 5650, 4, '2018-02-26', '08:50:35', 'nurse');
INSERT INTO "event_history" VALUES (5, 5650, 5, '2018-02-26', '09:10:41', 'nurse');
INSERT INTO "event_history" VALUES (6, 5650, 8, '2018-02-26', '09:30:58', 'megan');
INSERT INTO "event_history" VALUES (7, 5495, 2, '2018-02-19', '08:50:35', 'paul');
INSERT INTO "event_history" VALUES (8, 5495, 3, '2018-02-19', '09:10:41', 'paul');
INSERT INTO "event_history" VALUES (9, 5495, 8, '2018-02-19', '09:30:58', 'paul');
INSERT INTO "event_history" VALUES (10, 5726, 2, '2018-02-27', '08:22:47', 'paul');
INSERT INTO "event_history" VALUES (11, 5726, 3, '2018-02-27', '08:22:57', 'paul');
INSERT INTO "event_history" VALUES (12, 5898, 3, '2018-02-27', '09:03:32', 'paul');
INSERT INTO "event_history" VALUES (13, 5898, 4, '2018-02-27', '09:05:12', 'paul');
INSERT INTO "event_history" VALUES (14, 5726, 4, '2018-02-27', '09:58:10', 'joane');
INSERT INTO "event_history" VALUES (15, 5898, 5, '2018-02-27', '11:02:35', 'nurse');
INSERT INTO "event_history" VALUES (16, 5898, 6, '2018-02-27', '11:02:48', 'nurse');
INSERT INTO "event_history" VALUES (17, 5726, 5, '2018-02-27', '11:03:16', 'nurse');
INSERT INTO "event_history" VALUES (18, 5726, 6, '2018-02-27', '11:03:20', 'nurse');
INSERT INTO "event_history" VALUES (19, 5898, 7, '2018-02-27', '11:09:39', 'paul');
INSERT INTO "event_history" VALUES (20, 5898, 8, '2018-02-27', '11:09:47', 'paul');
INSERT INTO "event_history" VALUES (21, 5902, 3, '2018-02-27', '11:17:40', 'paul');
INSERT INTO "event_history" VALUES (22, 5094, 2, '2018-02-01', '08:11:00', 'admin');
INSERT INTO "event_history" VALUES (23, 5096, 2, '2018-02-01', '08:11:33', 'admin');
INSERT INTO "event_history" VALUES (24, 5094, 3, '2018-02-01', '08:12:28', 'admin');
INSERT INTO "event_history" VALUES (25, 5098, 2, '2018-02-01', '08:12:34', 'admin');
INSERT INTO "event_history" VALUES (26, 5100, 2, '2018-02-01', '08:12:47', 'admin');
INSERT INTO "event_history" VALUES (27, 5104, 2, '2018-02-01', '08:14:11', 'admin');
INSERT INTO "event_history" VALUES (28, 5098, 3, '2018-02-01', '08:14:20', 'admin');
INSERT INTO "event_history" VALUES (29, 5096, 3, '2018-02-01', '08:14:29', 'admin');
INSERT INTO "event_history" VALUES (30, 5094, 8, '2018-02-01', '08:56:04', 'admin');
INSERT INTO "event_history" VALUES (31, 5096, 4, '2018-02-01', '08:56:11', 'admin');
INSERT INTO "event_history" VALUES (32, 5098, 4, '2018-02-01', '08:56:19', 'admin');
INSERT INTO "event_history" VALUES (33, 5104, 3, '2018-02-01', '08:56:25', 'admin');
INSERT INTO "event_history" VALUES (34, 5100, 3, '2018-02-01', '08:56:32', 'admin');
INSERT INTO "event_history" VALUES (35, 5102, 2, '2018-02-01', '08:56:55', 'admin');
INSERT INTO "event_history" VALUES (36, 5096, 5, '2018-02-01', '09:01:17', 'admin');
INSERT INTO "event_history" VALUES (37, 5096, 6, '2018-02-01', '09:03:26', 'admin');
INSERT INTO "event_history" VALUES (38, 5098, 5, '2018-02-01', '09:07:37', 'admin');
INSERT INTO "event_history" VALUES (39, 5100, 3, '2018-02-01', '09:15:51', 'admin');
INSERT INTO "event_history" VALUES (40, 5094, 8, '2018-02-01', '09:24:59', 'admin');
INSERT INTO "event_history" VALUES (41, 5100, 8, '2018-02-01', '09:28:19', 'admin');
INSERT INTO "event_history" VALUES (42, 5102, 3, '2018-02-01', '09:32:19', 'admin');
INSERT INTO "event_history" VALUES (43, 5096, 7, '2018-02-01', '09:35:32', 'admin');
INSERT INTO "event_history" VALUES (44, 5104, 8, '2018-02-01', '09:39:32', 'admin');
INSERT INTO "event_history" VALUES (45, 5098, 6, '2018-02-01', '09:41:32', 'admin');
INSERT INTO "event_history" VALUES (46, 5096, 8, '2018-02-01', '09:45:32', 'admin');
INSERT INTO "event_history" VALUES (47, 5098, 7, '2018-02-01', '09:50:47', 'admin');
INSERT INTO "event_history" VALUES (48, 5495, 4, '2018-02-28', '10:01:11', 'receptionist');
INSERT INTO "event_history" VALUES (49, 5547, 4, '2018-02-28', '10:01:21', 'receptionist');
INSERT INTO "event_history" VALUES (50, 5455, 4, '2018-02-28', '10:01:47', 'receptionist');
INSERT INTO "event_history" VALUES (51, 5453, 4, '2018-02-28', '10:01:56', 'receptionist');
INSERT INTO "event_history" VALUES (52, 5496, 8, '2018-02-28', '10:02:05', 'receptionist');
INSERT INTO "event_history" VALUES (53, 5498, 8, '2018-02-28', '10:02:25', 'receptionist');
INSERT INTO "event_history" VALUES (54, 5496, 8, '2018-02-28', '10:02:31', 'receptionist');
INSERT INTO "event_history" VALUES (55, 5168, 8, '2018-02-28', '10:02:59', 'receptionist');
INSERT INTO "event_history" VALUES (56, 5196, 8, '2018-02-28', '10:03:19', 'receptionist');
INSERT INTO "event_history" VALUES (57, 5133, 8, '2018-02-28', '10:03:26', 'receptionist');
INSERT INTO "event_history" VALUES (58, 5100, 8, '2018-02-28', '10:05:36', 'receptionist');
INSERT INTO "event_history" VALUES (59, 5118, 8, '2018-02-28', '10:05:41', 'receptionist');
INSERT INTO "event_history" VALUES (60, 5094, 8, '2018-02-28', '10:05:53', 'receptionist');
INSERT INTO "event_history" VALUES (61, 5070, 8, '2018-02-28', '10:06:06', 'receptionist');
INSERT INTO "event_history" VALUES (62, 5236, 8, '2018-02-28', '10:06:23', 'receptionist');
INSERT INTO "event_history" VALUES (63, 5301, 4, '2018-02-28', '10:48:59', 'admin');
INSERT INTO "event_history" VALUES (64, 5315, 4, '2018-02-28', '10:49:27', 'admin');
INSERT INTO "event_history" VALUES (65, 5273, 4, '2018-02-28', '10:49:35', 'admin');
INSERT INTO "event_history" VALUES (66, 5321, 4, '2018-02-28', '10:49:49', 'admin');
INSERT INTO "event_history" VALUES (67, 4930, 8, '2018-02-28', '10:50:03', 'admin');
INSERT INTO "event_history" VALUES (68, 5902, 8, '2018-02-28', '10:54:33', 'admin');
INSERT INTO "event_history" VALUES (69, 5902, 8, '2018-02-28', '10:55:43', 'paul');

-- ----------------------------
-- Table structure for event_priority
-- ----------------------------
DROP TABLE IF EXISTS "event_priority";
CREATE TABLE "event_priority" (
"idevent_priority"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"event_priority_desc"  varchar(50) NOT NULL,
"event_priority_desc_pt"  varchar(50) NOT NULL,
"event_priority_desc_es"  varchar(50) NOT NULL
)

;

-- ----------------------------
-- Records of event_priority
-- ----------------------------
INSERT INTO "event_priority" VALUES (1, 'LOW', 'BAIXA', 'BAJA');
INSERT INTO "event_priority" VALUES (2, 'HIGH', 'ALTA', 'ALTA');
INSERT INTO "event_priority" VALUES (3, 'CRITICAL', 'CRÍTICA', 'CRÍTICA');


-- ----------------------------
-- Table structure for event_status
-- ----------------------------
DROP TABLE IF EXISTS "event_status";
CREATE TABLE "event_status" (
"idevent_status"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"event_status_descr"  varchar(50) NOT NULL,
"event_status_descr_pt"  varchar(50) NOT NULL,
"event_status_descr_es"  varchar(50) NOT NULL
)

;

-- ----------------------------
-- Records of event_status
-- ----------------------------
INSERT INTO "event_status" VALUES (1, 'SCHEDULED', 'AGENDADO', 'PROGRAMADO');
INSERT INTO "event_status" VALUES (2, 'SCREENING', 'TRIAGEM', 'CLASIFICACIÓN');
INSERT INTO "event_status" VALUES (3, 'IN ATTENDANCE', 'EM ATENDIMENTO', 'EN LA ASISTENCIA');
INSERT INTO "event_status" VALUES (4, 'WAITING MEDICATION', 'AGUARDANDO MEDICAÇÃO', 'ESPERANDO MEDICINA');
INSERT INTO "event_status" VALUES (5, 'UNDER OBSERVATION', 'EM OBSERVAÇÃO', 'EN LA OBSERVACIÓN');
INSERT INTO "event_status" VALUES (6, 'WAITING REASSESSMENT', 'AGUARDANDO REAVALIAÇÃO', 'ESPERA DE REEVALUACIÓN');
INSERT INTO "event_status" VALUES (7, 'IN REASSESSMENT', 'EM REAVALIAÇÃO', 'EN LA REEVALUACIÓN');
INSERT INTO "event_status" VALUES (8, 'DISCHARGED', 'DESCARREGADA', 'DESCARGADO');
INSERT INTO "event_status" VALUES (9, 'CANCELED', 'CANCELADO', 'CANCELADO');

-- ----------------------------
-- Table structure for medical_history
-- ----------------------------
DROP TABLE IF EXISTS "medical_history";
CREATE TABLE "medical_history" (
"idhistory"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"event_idevent"  bigint,
"history_datetime"  datetime,
"patients_idpatient"  bigint,
"doctor_iddoctor"  bigint,
"complaints"  text,
"diagnosis"  varchar(250),
"prescription"  text,
"tonursery"  varchar(1) DEFAULT 'N',
"nursery_datetime"  datetime,
"nurses_idnurse"  bigint,
FOREIGN KEY ("event_idevent") REFERENCES "event" ("idevent"),
FOREIGN KEY ("patients_idpatient") REFERENCES "patients" ("idpatient"),
FOREIGN KEY ("doctor_iddoctor") REFERENCES "doctors" ("iddoctor"),
FOREIGN KEY ("nurses_idnurse") REFERENCES "nurses" ("idnurse")
)

;

-- ----------------------------
-- Records of medical_history
-- ----------------------------
INSERT INTO "medical_history" VALUES ('1', '5048', '2018-03-02 15:44:00', '1', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('2', '5231', '2018-02-26 16:01:00', '3', '1', 'Headache, Fever', 'COLD FLU', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('3', '5180', '2018-02-26 16:09:00', '24', '1', 'HEADACHE', 'COLD', 'Dipyrone', 'N', null, null);
INSERT INTO "medical_history" VALUES ('5', '4955', '2018-02-28 09:25:00', '1', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('6', '5246', '2018-02-28 10:24:00', '9', '4', 'Headache, Fever', 'COLD', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('7', '4945', '2018-02-28 11:05:00', '26', '4', 'HEADACHE', 'COLD', 'Dipyrone', 'N', null, null);
INSERT INTO "medical_history" VALUES ('10', '5257', '2018-02-28 11:14:00', '3', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', '2018-02-28 11:20:00', null);
INSERT INTO "medical_history" VALUES ('11', '5257', '2018-02-28 11:40:00', '3', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X 4h/7d', 'N', null, null);
INSERT INTO "medical_history" VALUES ('12', '4929', '2018-02-28 11:54:00', '15', '1', 'HEADACHE', 'COLD', 'Dipyrone', 'N', null, null);
INSERT INTO "medical_history" VALUES ('14', '4961', '2018-03-01 08:20:00', '3', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('15', '4977', '2018-03-02 09:10:00', '9', '3', 'Headache, Fever', 'COLD', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('18', '4993', '2018-03-02 11:03:00', '7', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('19', '5149', '2018-03-02 12:03:00', '7', '3', 'Headache, Fever', 'COLD FLU', 'MEDICINE', 'N', null, null);
INSERT INTO "medical_history" VALUES ('28', '6859', '2018-03-12 12:00:00', '10', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('29', '6860', '2018-03-12 12:15:00', '2', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('30', '6861', '2018-03-12 12:30:00', '4', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('31', '6862', '2018-03-12 12:45:00', '20', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('32', '6863', '2018-03-12 13:00:00', '12', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('33', '6864', '2018-03-12 13:15:00', '3', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('34', '6865', '2018-03-12 13:30:00', '10', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('35', '6866', '2018-03-12 13:45:00', '10', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('36', '6867', '2018-03-12 14:00:00', '7', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('37', '6868', '2018-03-12 14:15:00', '2', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('38', '6869', '2018-03-12 14:30:00', '24', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('39', '6870', '2018-03-12 14:45:00', '24', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('40', '6871', '2018-03-12 15:00:00', '11', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('41', '6872', '2018-03-12 15:15:00', '14', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('42', '6873', '2018-03-12 15:30:00', '30', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('43', '6874', '2018-03-12 15:45:00', '15', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('44', '6875', '2018-03-12 16:00:00', '27', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('45', '6876', '2018-03-12 16:15:00', '12', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('46', '6877', '2018-03-12 08:00:00', '26', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('47', '6878', '2018-03-12 09:00:00', '4', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('48', '6879', '2018-03-12 10:00:00', '14', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('49', '6880', '2018-03-12 11:00:00', '12', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('50', '6881', '2018-03-12 13:00:00', '29', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('51', '6882', '2018-03-12 14:00:00', '6', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('52', '6883', '2018-03-12 15:00:00', '25', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('53', '6884', '2018-03-12 16:00:00', '6', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('54', '6885', '2018-03-12 17:00:00', '28', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('55', '6886', '2018-03-12 13:00:00', '28', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('56', '6887', '2018-03-12 13:15:00', '27', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('57', '6888', '2018-03-12 13:30:00', '4', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('58', '6889', '2018-03-12 13:45:00', '15', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('59', '6890', '2018-03-12 14:00:00', '10', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('60', '6891', '2018-03-12 14:15:00', '10', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('61', '6892', '2018-03-12 14:30:00', '10', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('62', '6893', '2018-03-12 14:45:00', '30', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('63', '6894', '2018-03-12 15:00:00', '13', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('64', '6895', '2018-03-12 15:15:00', '6', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('65', '6896', '2018-03-12 15:30:00', '26', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('66', '6897', '2018-03-12 15:45:00', '5', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('67', '6898', '2018-03-12 16:00:00', '26', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('121', '7397', '2018-03-13 12:00:00', '1', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('122', '7398', '2018-03-13 12:15:00', '8', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('123', '7399', '2018-03-13 12:30:00', '17', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('124', '7400', '2018-03-13 12:45:00', '25', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('125', '7401', '2018-03-13 13:00:00', '8', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('126', '7402', '2018-03-13 13:15:00', '3', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('127', '7403', '2018-03-13 13:30:00', '23', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('128', '7404', '2018-03-13 13:45:00', '7', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('129', '7405', '2018-03-13 14:00:00', '29', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('130', '7406', '2018-03-13 14:15:00', '7', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('131', '7407', '2018-03-13 14:30:00', '23', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('132', '7408', '2018-03-13 14:45:00', '24', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('133', '7409', '2018-03-13 15:00:00', '10', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('134', '7410', '2018-03-13 15:15:00', '23', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('135', '7411', '2018-03-13 15:30:00', '15', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('136', '7412', '2018-03-13 15:45:00', '10', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('137', '7413', '2018-03-13 16:00:00', '27', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('138', '7414', '2018-03-13 16:15:00', '14', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('139', '7415', '2018-03-13 08:00:00', '29', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('140', '7416', '2018-03-13 09:00:00', '11', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('141', '7417', '2018-03-13 10:00:00', '8', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('142', '7418', '2018-03-13 11:00:00', '6', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('143', '7419', '2018-03-13 13:00:00', '23', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('144', '7420', '2018-03-13 14:00:00', '24', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('145', '7421', '2018-03-13 15:00:00', '15', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('146', '7422', '2018-03-13 16:00:00', '17', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('147', '7423', '2018-03-13 17:00:00', '18', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('148', '7424', '2018-03-13 13:00:00', '22', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('149', '7425', '2018-03-13 13:15:00', '7', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('150', '7426', '2018-03-13 13:30:00', '26', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('151', '7427', '2018-03-13 13:45:00', '11', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('152', '7428', '2018-03-13 14:00:00', '23', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('153', '7429', '2018-03-13 14:15:00', '15', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('154', '7430', '2018-03-13 14:30:00', '17', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('155', '7431', '2018-03-13 14:45:00', '26', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('156', '7432', '2018-03-13 15:00:00', '13', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('157', '7433', '2018-03-13 15:15:00', '29', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('158', '7434', '2018-03-13 15:30:00', '21', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('159', '7435', '2018-03-13 15:45:00', '13', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('160', '7436', '2018-03-13 16:00:00', '4', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('161', '7437', '2018-03-13 12:00:00', '24', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('162', '7438', '2018-03-13 12:15:00', '21', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('163', '7439', '2018-03-13 12:30:00', '12', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('164', '7440', '2018-03-13 12:45:00', '11', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('165', '7441', '2018-03-13 13:00:00', '19', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('166', '7442', '2018-03-13 13:15:00', '8', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('167', '7443', '2018-03-13 13:30:00', '21', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('168', '7444', '2018-03-13 13:45:00', '13', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('169', '7445', '2018-03-13 14:00:00', '2', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('170', '7446', '2018-03-13 14:15:00', '9', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('171', '7447', '2018-03-13 14:30:00', '20', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('172', '7448', '2018-03-13 14:45:00', '16', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('173', '7449', '2018-03-13 15:00:00', '29', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('229', '12729', '2018-03-14 12:00:00', '1', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('230', '12730', '2018-03-14 12:15:00', '25', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('231', '12731', '2018-03-14 12:30:00', '3', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('232', '12732', '2018-03-14 12:45:00', '28', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('233', '12733', '2018-03-14 13:00:00', '6', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('234', '12734', '2018-03-14 13:15:00', '29', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('235', '12735', '2018-03-14 13:30:00', '8', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('236', '12736', '2018-03-14 13:45:00', '3', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('237', '12737', '2018-03-14 14:00:00', '16', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('238', '12738', '2018-03-14 14:15:00', '23', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('239', '12739', '2018-03-14 14:30:00', '11', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('240', '12740', '2018-03-14 14:45:00', '25', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('241', '12741', '2018-03-14 15:00:00', '28', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('242', '12742', '2018-03-14 15:15:00', '30', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('243', '12743', '2018-03-14 15:30:00', '11', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('244', '12745', '2018-03-14 16:00:00', '5', '4', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('245', '12746', '2018-03-14 16:15:00', '9', '4', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('246', '12747', '2018-03-14 08:00:00', '21', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('247', '12748', '2018-03-14 09:00:00', '10', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('248', '12749', '2018-03-14 10:00:00', '9', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('249', '12750', '2018-03-14 11:00:00', '24', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('250', '12751', '2018-03-14 13:00:00', '9', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('251', '12752', '2018-03-14 14:00:00', '10', '2', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('252', '12753', '2018-03-14 15:00:00', '23', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('253', '12755', '2018-03-14 17:00:00', '2', '2', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('254', '12757', '2018-03-14 13:15:00', '6', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('255', '12758', '2018-03-14 13:30:00', '15', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('256', '12759', '2018-03-14 13:45:00', '19', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('257', '12760', '2018-03-14 14:00:00', '29', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('258', '12761', '2018-03-14 14:15:00', '2', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('259', '12762', '2018-03-14 14:30:00', '9', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('260', '12763', '2018-03-14 14:45:00', '6', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('261', '12764', '2018-03-14 15:00:00', '12', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('262', '12765', '2018-03-14 15:15:00', '10', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('263', '12766', '2018-03-14 15:30:00', '14', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('264', '12767', '2018-03-14 15:45:00', '20', '1', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('265', '12768', '2018-03-14 16:00:00', '21', '1', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('266', '12769', '2018-03-14 12:00:00', '17', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('267', '12770', '2018-03-14 12:15:00', '29', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('268', '12771', '2018-03-14 12:30:00', '16', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('269', '12772', '2018-03-14 12:45:00', '30', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('270', '12773', '2018-03-14 13:00:00', '28', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('271', '12774', '2018-03-14 13:15:00', '17', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('272', '12775', '2018-03-14 13:30:00', '27', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('273', '12776', '2018-03-14 13:45:00', '26', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('274', '12777', '2018-03-14 14:00:00', '30', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('275', '12778', '2018-03-14 14:15:00', '2', '3', 'Stomachache, Vomit', 'DIARHEA', 'MEDICINE X', 'Y', null, null);
INSERT INTO "medical_history" VALUES ('276', '12779', '2018-03-14 14:30:00', '5', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);
INSERT INTO "medical_history" VALUES ('277', '12781', '2018-03-14 15:00:00', '15', '3', 'HEADACHE', 'COLD', 'MEDICINE YY', 'N', null, null);

-- ----------------------------
-- Table structure for menu
-- ----------------------------
DROP TABLE IF EXISTS "menu";
CREATE TABLE "menu" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"parent"  bigint,
"description"  varchar(100),
"description_pt_br"  varchar(100),
"description_es"  varchar(100),
"link"  varchar(100),
"link_params"  varchar(100),
"node_order"  bigint,
"profile"  bigint,
"is_active"  varchar(1)
)

;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO "menu" VALUES (1, null, 'Settings', 'Configurações', 'Ajustes', '', null, 4, 10, 'Y');
INSERT INTO "menu" VALUES (2, 1, 'Treatments', 'Tipos de Atendimento', 'Tipos de Servicio', 'form_treatments', null, 1, 10, 'Y');
INSERT INTO "menu" VALUES (3, 1, 'Specialities', 'Especialidades', 'Especialidades', 'form_speciality', null, 2, 10, 'Y');
INSERT INTO "menu" VALUES (4, 1, 'Available Time', 'Horários de Atendimento', 'Horarios de atención', 'form_timesappointments', null, 3, 10, 'Y');
INSERT INTO "menu" VALUES (5, null, 'Cadasters', 'Cadastros', 'Entradas', '', null, 3, 10, 'Y');
INSERT INTO "menu" VALUES (6, 5, 'Doctors', 'Médicos', 'Médicos', 'grid_doctors', null, 2, 10, 'Y');
INSERT INTO "menu" VALUES (9, 11, 'Events Generator', 'Gerador de Eventos', 'Generador de eventos', 'generate_events', null, 1, 10, 'Y');
INSERT INTO "menu" VALUES (11, null, 'Schedule', 'Agendas', 'Agendas', '', null, 2, 5, 'Y');
INSERT INTO "menu" VALUES (12, 1, 'Menu Links', 'Configurar Menu', 'Configurar menú', 'form_menu', null, 4, 10, 'Y');
INSERT INTO "menu" VALUES (14, null, 'Security', 'Segurança', 'Seguridad', '', null, 5, 5, 'Y');
INSERT INTO "menu" VALUES (15, 14, 'Change Password', 'Mudar Senha', 'Cambiar contraseña', 'app_change_pswd', null, 1, 5, 'Y');
INSERT INTO "menu" VALUES (16, 14, 'Users', 'Usuários', 'Usuarios', 'app_grid_sec_users', null, 2, 10, 'Y');
INSERT INTO "menu" VALUES (17, null, 'Schedule of the day', 'Agenda do dia', 'Agenda del día', 'grid_agenda', null, 1, 5, 'Y');
INSERT INTO "menu" VALUES (19, 5, 'Patients', 'Pacientes', 'Pacientes', 'grid_patients', null, 1, 10, 'Y');
INSERT INTO "menu" VALUES (22, 14, 'Applications', 'Aplicações', 'Aplicaciones', 'app_grid_sec_apps', null, 3, 10, 'Y');
INSERT INTO "menu" VALUES (23, 14, 'Groups', 'Grupos', 'Grupos', 'app_grid_sec_groups', null, 4, 10, 'Y');
INSERT INTO "menu" VALUES (24, 14, 'Users x Groups', 'Usuários x Grupos', 'Usuarios x Grupos', 'app_grid_sec_users_groups', null, 5, 10, 'Y');
INSERT INTO "menu" VALUES (25, 14, 'Apps x Groups', 'Aplicações x Grupos', 'Aplicaciones x Grupos', 'app_search_sec_groups', null, 6, 10, 'Y');
INSERT INTO "menu" VALUES (26, 14, 'Sync Apps', 'Sincronizar Apps', 'Sincronizar Apps', 'app_sync_apps', null, 7, 10, 'Y');
INSERT INTO "menu" VALUES (28, 5, 'Nurses', 'Enfermeiras/os', 'Enfermeras/os', 'grid_nurses', null, 3, 10, 'Y');
INSERT INTO "menu" VALUES (29, null, 'Nursery Events', 'Eventos Enfermaria', 'Eventos Enfermería', 'grid_nursery_events', null, 1, 10, 'Y');

-- ----------------------------
-- Table structure for nurses
-- ----------------------------
DROP TABLE IF EXISTS "nurses";
CREATE TABLE "nurses" (
"idnurse"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"namenurse"  varchar(100) NOT NULL,
"login"  varchar(32)
)

;

-- ----------------------------
-- Records of nurses
-- ----------------------------
INSERT INTO "nurses" VALUES (1, 'Jill', 'nurse');

-- ----------------------------
-- Table structure for patients
-- ----------------------------
DROP TABLE IF EXISTS "patients";
CREATE TABLE "patients" (
"idpatient"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"patient_name"  varchar(150) NOT NULL,
"patient_birthdate"  date,
"patient_gender"  varchar(1),
"patient_blood"  varchar(3),
"patient_phone"  varchar(20),
"patient_email"  varchar(100),
"patient_address"  varchar(250)
)

;

-- ----------------------------
-- Records of patients
-- ----------------------------
INSERT INTO "patients" VALUES (1, 'Liu Wong', '1979-01-07', 'M', 'A-', '0055554729', 'liu_wong@scriptcase.net', 'Obere Str. 57');
INSERT INTO "patients" VALUES (2, 'Ana Trujillo', '1989-07-27', 'F', 'A+', '(505) 555-5939', 'ana_trujillo@scriptcase.net', 'Avda. de la Constitucion, 2222');
INSERT INTO "patients" VALUES (3, 'Antonio Moreno', '1966-02-10', 'M', 'B+', '0522-556721', 'antonio_moreno@scriptcase.net', 'Mataderos,  2312');
INSERT INTO "patients" VALUES (4, 'Thomas Hardy', '1977-03-04', 'M', 'B-', '(21) 555-3412', 'thomas_hardy@scriptcase.net', '120 Hanover Sq.');
INSERT INTO "patients" VALUES (5, 'Christina Berglund', '1994-10-10', 'F', 'AB+', '0897-034214', 'christina_berglund@scriptcase.net', 'Berguvsvegen');
INSERT INTO "patients" VALUES (6, 'Hanna Moos', '1976-01-22', 'F', 'AB-', '(91) 745 6200', 'hanna_moos@scriptcase.net', 'Forsterstr. 57');
INSERT INTO "patients" VALUES (7, 'Frederique Citeaux', '1975-05-11', 'M', 'O-', '07-98 92 35', 'frederique_citeaux@scriptcase.net', '24 Place Kleber');
INSERT INTO "patients" VALUES (8, 'Martin Sommer', '1988-03-07', 'M', 'O+', '(208) 555-8097', 'martin_sommer@scriptcase.net', 'C/ Araquil, 67');
INSERT INTO "patients" VALUES (9, 'Laurence Lebihan', '1988-11-11', 'M', 'B+', '(171) 555-1717', 'laurence_lebihan@scriptcase.net', '12, rue des Bouchers');
INSERT INTO "patients" VALUES (10, 'Elizabeth Lincoln', '1999-05-16', 'F', 'O+', '3112 34 56', 'elizabeth_lincoln@scriptcase.net', '23 Tsawwassen Beach Road');
INSERT INTO "patients" VALUES (11, 'Victoria Ashworth', '1975-01-08', 'F', 'O+', '(1) 47.55.60.10', 'victoria_ashworth@scriptcase.net', 'Winter Park, FL 32792, USA');
INSERT INTO "patients" VALUES (12, 'Patricio Simpson', '1997-07-12', 'M', 'O-', '(307) 555-4680', 'patricio_simpson@scriptcase.net', 'Cerrito, 333');
INSERT INTO "patients" VALUES (13, 'Francisco Chang', '1977-04-17', 'M', 'B-', '(071) 23 67 22 20', 'francisco_chang@scriptcase.net', 'Sierras de Granada 9993');
INSERT INTO "patients" VALUES (14, 'Yang Wang', '1978-11-07', 'M', 'B-', '(503) 555-3612', 'yang_wang@scriptcase.net', 'Hauptstr. 29');
INSERT INTO "patients" VALUES (15, 'Pedro Afonso', '1973-11-07', 'M', 'O-', '(406) 555-5834', 'pedro_afonso@scriptcase.net', 'Av. dos Lusadas, 23');
INSERT INTO "patients" VALUES (16, 'Elizabeth Brown', '1996-08-29', 'F', 'A+', '0251-031259', 'elizabeth_brown@scriptcase.net', 'Berkeley Gardens 12 Brewery');
INSERT INTO "patients" VALUES (17, 'Sven Ottlieb', '1975-06-16', 'M', 'A+', '(5) 555-2933', 'sven_ottlieb@scriptcase.net', 'Walserweg 21');
INSERT INTO "patients" VALUES (18, 'Janine Labrune', '1993-08-22', 'F', 'A-', '(11) 555-2167', 'janine_labrune@scriptcase.net', '67, rue des Cinquante Otages');
INSERT INTO "patients" VALUES (19, 'Ann Devon', '1973-11-25', 'F', 'B+', '(206) 555-8257', 'ann_devon@scriptcase.net', '35 King George');
INSERT INTO "patients" VALUES (20, 'Roland Mendel', '1977-12-15', 'M', 'B+', '86 21 3243', 'roland_mendel@scriptcase.net', 'Kirchgasse 6');
INSERT INTO "patients" VALUES (21, 'Aria Cruz', '1985-04-04', 'F', 'B+', '78.32.54.86', 'aria_cruz@scriptcase.net', 'Rua Ores, 92');
INSERT INTO "patients" VALUES (22, 'Diego Roel', '1977-07-17', 'M', 'O+', '26.47.15.10', 'diego_roel@scriptcase.net', 'C/ Moralzarzal, 86');
INSERT INTO "patients" VALUES (23, 'Martine Rance', '1975-10-25', 'F', 'O-', '0711-020361', 'martine_rance@scriptcase.net', '184, chausse de Tournai');
INSERT INTO "patients" VALUES (24, 'Maria Larsson', '1973-10-10', 'F', 'A+', '981-443655', 'maria_larsson@scriptcase.net', 'Ekergatan 24');
INSERT INTO "patients" VALUES (25, 'Peter Franken', '1976-09-02', 'M', 'O+', '(14) 555-8122', 'peter_franken@scriptcase.net', 'Berliner Platz 43');
INSERT INTO "patients" VALUES (26, 'Carine Schmitt', '1977-09-14', 'F', 'O-', '(206) 555-4112', 'carine_schmitt@scriptcase.net', '54, rue Royale');
INSERT INTO "patients" VALUES (27, 'Paolo Accorti', '1984-12-20', 'M', 'O-', '90-224 8858', 'paolo_accorti@scriptcase.net', 'Via Monte Bianco 34');
INSERT INTO "patients" VALUES (28, 'Mary Saveley', '1989-01-26', 'F', 'AB+', '0711-020361', 'mary_saveley@scriptcase.net', 'Adenauerallee 900');
INSERT INTO "patients" VALUES (29, 'Paul Henriot', '1982-10-23', 'M', 'A+', '981-443655', 'paul_henriot@scriptcase.net', 'Torikatu 38');
INSERT INTO "patients" VALUES (30, 'Rita Muller', '1990-08-08', 'F', 'B-', '(14) 555-8122', 'rita_muller@scriptcase.net', 'Rua do Mercado, 12');

-- ----------------------------
-- Table structure for sec_apps
-- ----------------------------
DROP TABLE IF EXISTS "sec_apps";
CREATE TABLE "sec_apps" (
"app_name"  varchar(128) NOT NULL,
"app_type"  varchar(255),
"description"  varchar(255),
PRIMARY KEY ("app_name" ASC)
)

;

-- ----------------------------
-- Records of sec_apps
-- ----------------------------
INSERT INTO "sec_apps" VALUES ('app_change_pswd', 'contr', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_form_add_users', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_form_edit_users', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_form_sec_apps', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_form_sec_groups', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_form_sec_groups_apps', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_grid_sec_apps', 'cons', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_grid_sec_groups', 'cons', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_grid_sec_users', 'cons', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_grid_sec_users_groups', 'form', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_Login', 'contr', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_retrieve_pswd', 'contr', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_search_sec_groups', 'filter', 'Security Application');
INSERT INTO "sec_apps" VALUES ('app_sync_apps', 'contr', 'Security Application');
INSERT INTO "sec_apps" VALUES ('blank_start', 'blank', '');
INSERT INTO "sec_apps" VALUES ('blank_upd_evt_status', 'blank', '');
INSERT INTO "sec_apps" VALUES ('calendar_event', 'calendar', '');
INSERT INTO "sec_apps" VALUES ('chart_event_category', 'cons', null);
INSERT INTO "sec_apps" VALUES ('chart_event_date', 'cons', null);
INSERT INTO "sec_apps" VALUES ('chart_event_doctors', 'cons', null);
INSERT INTO "sec_apps" VALUES ('chart_medical_history', 'cons', null);
INSERT INTO "sec_apps" VALUES ('dashboard', 'container', null);
INSERT INTO "sec_apps" VALUES ('form_doctors', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_event_change_status', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_medical_history', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_medical_history_inline', '', null);
INSERT INTO "sec_apps" VALUES ('form_menu', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_nurses', 'form', null);
INSERT INTO "sec_apps" VALUES ('form_patients', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_speciality', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_timesappointments', 'form', '');
INSERT INTO "sec_apps" VALUES ('form_treatments', 'form', '');
INSERT INTO "sec_apps" VALUES ('generate_events', 'contr', '');
INSERT INTO "sec_apps" VALUES ('grid_agenda', 'cons', '');
INSERT INTO "sec_apps" VALUES ('grid_doctors', 'cons', '');
INSERT INTO "sec_apps" VALUES ('grid_events_patiente', 'cons', '');
INSERT INTO "sec_apps" VALUES ('grid_medical_history', 'cons', '');
INSERT INTO "sec_apps" VALUES ('grid_nursery_events', 'cons', null);
INSERT INTO "sec_apps" VALUES ('grid_nurses', 'cons', null);
INSERT INTO "sec_apps" VALUES ('grid_patients', 'cons', '');
INSERT INTO "sec_apps" VALUES ('login', 'contr', null);
INSERT INTO "sec_apps" VALUES ('menu', 'menutree', '');

-- ----------------------------
-- Table structure for sec_groups
-- ----------------------------
DROP TABLE IF EXISTS "sec_groups";
CREATE TABLE "sec_groups" (
"group_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"description"  varchar(255)
)

;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------
INSERT INTO "sec_groups" VALUES (1, 'Administrator');
INSERT INTO "sec_groups" VALUES (2, 'Doctor');
INSERT INTO "sec_groups" VALUES (3, 'Nurse');
INSERT INTO "sec_groups" VALUES (4, 'Attendant');

-- ----------------------------
-- Table structure for sec_groups_apps
-- ----------------------------
DROP TABLE IF EXISTS "sec_groups_apps";
CREATE TABLE "sec_groups_apps" (
"group_id"  INTEGER NOT NULL,
"app_name"  varchar(128) NOT NULL,
"priv_access"  varchar(1),
"priv_insert"  varchar(1),
"priv_delete"  varchar(1),
"priv_update"  varchar(1),
"priv_export"  varchar(1),
"priv_print"  varchar(1),
PRIMARY KEY ("group_id" ASC, "app_name" ASC),
FOREIGN KEY ("group_id") REFERENCES "sec_groups" ("group_id"),
FOREIGN KEY ("app_name") REFERENCES "sec_apps" ("app_name")
)

;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_form_add_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_grid_sec_apps', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_grid_sec_groups', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_grid_sec_users', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_grid_sec_users_groups', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_Login', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_retrieve_pswd', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_search_sec_groups', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'app_sync_apps', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'blank_start', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'blank_upd_evt_status', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'calendar_event', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'chart_event_category', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'chart_event_date', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'chart_event_doctors', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'chart_medical_history', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'dashboard', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_doctors', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_event_change_status', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_medical_history', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_medical_history_inline', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_menu', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_nurses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_patients', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_speciality', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_timesappointments', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'form_treatments', 'Y', 'Y', 'Y', 'Y', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'generate_events', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_agenda', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_doctors', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_events_patiente', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_medical_history', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_nursery_events', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_nurses', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'grid_patients', 'Y', 'N', 'N', 'N', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('1', 'login', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('1', 'menu', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_form_add_users', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_form_edit_users', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_form_sec_apps', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_form_sec_groups', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_form_sec_groups_apps', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_grid_sec_apps', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_grid_sec_groups', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_grid_sec_users', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_grid_sec_users_groups', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_Login', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_retrieve_pswd', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_search_sec_groups', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'app_sync_apps', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO "sec_groups_apps" VALUES ('2', 'blank_start', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'blank_upd_evt_status', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'calendar_event', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'chart_event_category', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'chart_event_date', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'chart_event_doctors', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'chart_medical_history', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'dashboard', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_doctors', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_event_change_status', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_medical_history', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_medical_history_inline', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_menu', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_nurses', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_patients', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_speciality', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_timesappointments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'form_treatments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'generate_events', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_agenda', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_doctors', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_events_patiente', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_medical_history', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_nursery_events', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_nurses', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('2', 'grid_patients', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('2', 'login', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('2', 'menu', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_change_pswd', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_form_add_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_form_edit_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_form_sec_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_form_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_form_sec_groups_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_grid_sec_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_grid_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_grid_sec_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_grid_sec_users_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_Login', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_retrieve_pswd', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_search_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'app_sync_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'blank_start', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'blank_upd_evt_status', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'calendar_event', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'chart_event_category', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'chart_event_date', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'chart_event_doctors', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'chart_medical_history', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'dashboard', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_doctors', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_event_change_status', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_medical_history', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_medical_history_inline', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_menu', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_nurses', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_patients', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_speciality', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_timesappointments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'form_treatments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'generate_events', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_agenda', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_doctors', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_events_patiente', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_medical_history', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_nursery_events', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_nurses', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'grid_patients', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('3', 'login', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('3', 'menu', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_change_pswd', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_form_add_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_form_edit_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_form_sec_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_form_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_form_sec_groups_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_grid_sec_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_grid_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_grid_sec_users', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_grid_sec_users_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_Login', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_retrieve_pswd', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_search_sec_groups', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'app_sync_apps', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'blank_start', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'blank_upd_evt_status', 'Y', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'calendar_event', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'chart_event_category', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'chart_event_date', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'chart_event_doctors', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'chart_medical_history', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'dashboard', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_doctors', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_event_change_status', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_medical_history', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_medical_history_inline', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_menu', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_nurses', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_patients', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_speciality', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_timesappointments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'form_treatments', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'generate_events', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_agenda', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_doctors', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_events_patiente', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_medical_history', '', '', '', '', '', '');
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_nursery_events', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_nurses', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'grid_patients', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "sec_groups_apps" VALUES ('4', 'login', null, null, null, null, null, null);
INSERT INTO "sec_groups_apps" VALUES ('4', 'menu', 'Y', '', '', '', '', '');

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
DROP TABLE IF EXISTS "sec_users";
CREATE TABLE "sec_users" (
"login"  varchar(32) NOT NULL,
"pswd"  varchar(32),
"usrname"  varchar(64),
"email"  varchar(64),
"usractive"  varchar(1),
"activation_code"  varchar(32),
"priv_admin"  varchar(1) DEFAULT 'Y',
"usrperfil"  bigint,
PRIMARY KEY ("login" ASC)
)

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO "sec_users" VALUES ('admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Admin', 'admin@admin.com', 'Y', '', 'Y', 10);
INSERT INTO "sec_users" VALUES ('joane', '81dc9bdb52d04dc20036dbd8313ed055', 'Joane', 'joane@scriptcase.net', 'Y', '', 'Y', 0);
INSERT INTO "sec_users" VALUES ('mary', '81dc9bdb52d04dc20036dbd8313ed055', 'Mary', 'mary@scriptcase.net', 'Y', '', 'Y', 0);
INSERT INTO "sec_users" VALUES ('megan', '81dc9bdb52d04dc20036dbd8313ed055', 'Megan ', 'megan@scriptcase.net', 'Y', '', 'Y', 0);
INSERT INTO "sec_users" VALUES ('nurse', '81dc9bdb52d04dc20036dbd8313ed055', 'Jill', 'jill@scriptcase.net', 'Y', '', 'Y', 0);
INSERT INTO "sec_users" VALUES ('paul', '81dc9bdb52d04dc20036dbd8313ed055', 'Paul', 'paul@scriptcase.net', 'Y', '', 'Y', 0);
INSERT INTO "sec_users" VALUES ('receptionist', '81dc9bdb52d04dc20036dbd8313ed055', 'Receptionist', 'receptionist@scriptcase.net', 'Y', '', 'Y', 0);

-- ----------------------------
-- Table structure for sec_users_groups
-- ----------------------------
DROP TABLE IF EXISTS "sec_users_groups";
CREATE TABLE "sec_users_groups" (
"login"  varchar(32) NOT NULL,
"group_id"  bigint NOT NULL,
PRIMARY KEY ("login" ASC, "group_id" ASC),
FOREIGN KEY ("login") REFERENCES "sec_users" ("login"),
FOREIGN KEY ("group_id") REFERENCES "sec_groups" ("group_id")
)

;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------
INSERT INTO "sec_users_groups" VALUES ('admin', 1);
INSERT INTO "sec_users_groups" VALUES ('joane', 2);
INSERT INTO "sec_users_groups" VALUES ('mary', 2);
INSERT INTO "sec_users_groups" VALUES ('megan', 2);
INSERT INTO "sec_users_groups" VALUES ('nurse', 3);
INSERT INTO "sec_users_groups" VALUES ('paul', 2);
INSERT INTO "sec_users_groups" VALUES ('receptionist', 4);

-- ----------------------------
-- Table structure for speciality
-- ----------------------------
DROP TABLE IF EXISTS "speciality";
CREATE TABLE "speciality" (
"idspeciality"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"speciality_desc"  varchar(45),
"speciality_desc_pt"  varchar(45),
"speciality_desc_es"  varchar(45)
)

;

-- ----------------------------
-- Records of speciality
-- ----------------------------
INSERT INTO "speciality" VALUES (1, 'Work medicine', 'Medicina do trabalho', 'Medicina laboral');
INSERT INTO "speciality" VALUES (2, 'General clinic', 'Clínica geral', 'Clínica general');
INSERT INTO "speciality" VALUES (3, 'Gynecology', 'Ginecologia', 'Ginecología');
INSERT INTO "speciality" VALUES (4, 'Pediatrics', 'Pediatria', 'Pediatría');
INSERT INTO "speciality" VALUES (5, 'Dermatology', 'Dermatologia', 'Dermatología');
INSERT INTO "speciality" VALUES (6, 'Gastroenterology', 'Gastroenterologia', 'Gastroenterología');

-- ----------------------------
-- Table structure for times_doctor
-- ----------------------------
DROP TABLE IF EXISTS "times_doctor";
CREATE TABLE "times_doctor" (
"doctor_iddoctor"  bigint NOT NULL,
"docday"  varchar(10) NOT NULL,
"doctime"  time NOT NULL,
PRIMARY KEY ("doctor_iddoctor" ASC, "docday" ASC, "doctime" ASC),
FOREIGN KEY ("doctor_iddoctor") REFERENCES "doctors" ("iddoctor")
)

;

-- ----------------------------
-- Records of times_doctor
-- ----------------------------
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Friday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Monday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Thursday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Tuesday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '16:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '16:30:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '16:45:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '17:00:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '17:15:00');
INSERT INTO "times_doctor" VALUES ('1', 'Wednesday', '17:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Friday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Monday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '17:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Thursday', '18:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Tuesday', '17:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('2', 'Wednesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '16:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '16:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '16:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '17:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '17:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Friday', '17:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Monday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Thursday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Tuesday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('3', 'Wednesday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Friday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Monday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Thursday', '16:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '12:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '12:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '12:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '12:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '13:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '13:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '13:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '13:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '14:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '14:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '14:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '14:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '15:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '15:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '15:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '15:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '16:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Tuesday', '16:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '08:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '08:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '08:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '08:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '09:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '09:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '09:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '09:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '10:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '10:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '10:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '10:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '11:00:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '11:15:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '11:30:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '11:45:00');
INSERT INTO "times_doctor" VALUES ('4', 'Wednesday', '12:00:00');

-- ----------------------------
-- Table structure for timesappointments
-- ----------------------------
DROP TABLE IF EXISTS "timesappointments";
CREATE TABLE "timesappointments" (
"idtimesappointments"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"times"  time
)

;

-- ----------------------------
-- Records of timesappointments
-- ----------------------------
INSERT INTO "timesappointments" VALUES (1, '08:00:00');
INSERT INTO "timesappointments" VALUES (4, '08:15:00');
INSERT INTO "timesappointments" VALUES (7, '08:30:00');
INSERT INTO "timesappointments" VALUES (10, '08:45:00');
INSERT INTO "timesappointments" VALUES (13, '09:00:00');
INSERT INTO "timesappointments" VALUES (16, '09:15:00');
INSERT INTO "timesappointments" VALUES (19, '09:30:00');
INSERT INTO "timesappointments" VALUES (22, '09:45:00');
INSERT INTO "timesappointments" VALUES (25, '10:00:00');
INSERT INTO "timesappointments" VALUES (28, '10:15:00');
INSERT INTO "timesappointments" VALUES (31, '10:30:00');
INSERT INTO "timesappointments" VALUES (34, '10:45:00');
INSERT INTO "timesappointments" VALUES (37, '11:00:00');
INSERT INTO "timesappointments" VALUES (40, '11:15:00');
INSERT INTO "timesappointments" VALUES (43, '11:30:00');
INSERT INTO "timesappointments" VALUES (46, '11:45:00');
INSERT INTO "timesappointments" VALUES (49, '12:00:00');
INSERT INTO "timesappointments" VALUES (52, '12:15:00');
INSERT INTO "timesappointments" VALUES (55, '12:30:00');
INSERT INTO "timesappointments" VALUES (58, '12:45:00');
INSERT INTO "timesappointments" VALUES (61, '13:00:00');
INSERT INTO "timesappointments" VALUES (64, '13:15:00');
INSERT INTO "timesappointments" VALUES (67, '13:30:00');
INSERT INTO "timesappointments" VALUES (70, '13:45:00');
INSERT INTO "timesappointments" VALUES (73, '14:00:00');
INSERT INTO "timesappointments" VALUES (76, '14:15:00');
INSERT INTO "timesappointments" VALUES (79, '14:30:00');
INSERT INTO "timesappointments" VALUES (82, '14:45:00');
INSERT INTO "timesappointments" VALUES (85, '15:00:00');
INSERT INTO "timesappointments" VALUES (88, '15:15:00');
INSERT INTO "timesappointments" VALUES (91, '15:30:00');
INSERT INTO "timesappointments" VALUES (94, '15:45:00');
INSERT INTO "timesappointments" VALUES (97, '16:00:00');
INSERT INTO "timesappointments" VALUES (100, '16:15:00');
INSERT INTO "timesappointments" VALUES (103, '16:30:00');
INSERT INTO "timesappointments" VALUES (106, '16:45:00');
INSERT INTO "timesappointments" VALUES (109, '17:00:00');
INSERT INTO "timesappointments" VALUES (112, '17:15:00');
INSERT INTO "timesappointments" VALUES (115, '17:30:00');
INSERT INTO "timesappointments" VALUES (118, '17:45:00');
INSERT INTO "timesappointments" VALUES (121, '18:00:00');

-- ----------------------------
-- Table structure for treatments
-- ----------------------------
DROP TABLE IF EXISTS "treatments";
CREATE TABLE "treatments" (
"idtreatments"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"treatments_descr"  varchar(45),
"treatments_descr_pt"  varchar(45),
"treatments_descr_es"  varchar(45),
"treatments_color"  varchar(15)
)

;

-- ----------------------------
-- Records of treatments
-- ----------------------------
INSERT INTO "treatments" VALUES (1, 'Medical appointment', 'Consulta médica', 'Cita médica', '#9a9cff');
INSERT INTO "treatments" VALUES (2, 'Work medicine exam', 'Exame de medicina do trabalho', 'Examen de medicina del trabajo', '#fbd75b');
INSERT INTO "treatments" VALUES (3, 'Admission exam', 'Exame de admissão', 'Examen de admisión', '#7ae7bf');
INSERT INTO "treatments" VALUES (4, 'Dismissal exam', 'Exame demissional', 'Examen de despido', '#ff887c');
INSERT INTO "treatments" VALUES (5, 'Periodic', 'Periódico', 'Periódico', '#46d6db');
INSERT INTO "treatments" VALUES (6, 'Functional change', 'Alteração funcional', 'Cambio funcional', '#dbadff');
INSERT INTO "treatments" VALUES (7, 'Back to work', 'Volta ao trabalho', 'Regreso al trabajo', '#51b749');
INSERT INTO "treatments" VALUES (8, 'Scheduled Canceled', 'Consulta cancelada', 'Cita cancelada', '#dc2127');
INSERT INTO "treatments" VALUES (9, 'Available', 'Disponível', 'Disponible', '#ABEB9E');

-- ----------------------------
-- Indexes structure for table doctors
-- ----------------------------
CREATE INDEX "fk_doctor"
ON "doctors" ("treatments_idtreatments" ASC);
CREATE INDEX "fk_doctor_speciality_idx"
ON "doctors" ("speciality_idspeciality" ASC);
CREATE INDEX "login"
ON "doctors" ("login" ASC);

-- ----------------------------
-- Indexes structure for table event
-- ----------------------------
CREATE INDEX "fk_event_doctor1_idx"
ON "event" ("doctor_iddoctor" ASC);
CREATE INDEX "fk_event_event1_idx"
ON "event" ("event_period" ASC);
CREATE INDEX "fk_event_event_prioriry1"
ON "event" ("idevent_priority" ASC);
CREATE INDEX "fk_event_event_status1"
ON "event" ("idevent_status" ASC);
CREATE INDEX "fk_event_patient1"
ON "event" ("patients_idpatient" ASC);

-- ----------------------------
-- Indexes structure for table event_history
-- ----------------------------
CREATE INDEX "idevent"
ON "event_history" ("idevent" ASC);
CREATE INDEX "idevent_status"
ON "event_history" ("idevent_status" ASC);
CREATE INDEX "login1"
ON "event_history" ("login" ASC);

-- ----------------------------
-- Indexes structure for table medical_history
-- ----------------------------
CREATE INDEX "doctor_iddoctor"
ON "medical_history" ("doctor_iddoctor" ASC);
CREATE INDEX "event_idevent"
ON "medical_history" ("event_idevent" ASC);
CREATE INDEX "nurses_idnurse"
ON "medical_history" ("nurses_idnurse" ASC);
CREATE INDEX "patients_idpatient"
ON "medical_history" ("patients_idpatient" ASC);

-- ----------------------------
-- Indexes structure for table sec_groups
-- ----------------------------
CREATE UNIQUE INDEX "description"
ON "sec_groups" ("description" ASC);

-- ----------------------------
-- Indexes structure for table sec_groups_apps
-- ----------------------------
CREATE INDEX "sec_groups_apps_ibfk_2"
ON "sec_groups_apps" ("app_name" ASC);

-- ----------------------------
-- Indexes structure for table sec_users_groups
-- ----------------------------
CREATE INDEX "sec_users_groups_ibfk_2"
ON "sec_users_groups" ("group_id" ASC);

-- ----------------------------
-- Indexes structure for table times_doctor
-- ----------------------------
CREATE INDEX "fk_times_doctor_doctor1_idx"
ON "times_doctor" ("doctor_iddoctor" ASC);