PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for assessments
-- ----------------------------
CREATE TABLE assessments (
idassessments  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
assessments_descr  VARCHAR(45),
max_points  INTEGER,
assessments_comments  TEXT,
extra_credits  INTEGER DEFAULT 0
);

-- ----------------------------
-- Records of assessments
-- ----------------------------
INSERT INTO assessments VALUES (1, 'Test X', 60, null, 0);
INSERT INTO assessments VALUES (2, 'Test Y', 40, null, 0);
INSERT INTO assessments VALUES (3, 'Test Z', 100, null, 0);
INSERT INTO assessments VALUES (4, 'Test W', 100, null, 1);
INSERT INTO assessments VALUES (5, 'Final Exam', 100, null, 0);
INSERT INTO assessments VALUES (6, 'Quiz', 100, null, 0);
INSERT INTO assessments VALUES (7, 'Homework Project', 100, null, 0);


-- ----------------------------
-- Table structure for attendance
-- ----------------------------
CREATE TABLE attendance (
idattendance  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
idattendance_types  INTEGER NOT NULL,
idstudents  INTEGER NOT NULL,
idclasses  INTEGER NOT NULL,
attendance_date  DATE
);

-- ----------------------------
-- Records of attendance
-- ----------------------------
INSERT INTO attendance VALUES (1, 1, 1, 1, '2016-06-10');
INSERT INTO attendance VALUES (2, 1, 2, 1, '2016-06-10');
INSERT INTO attendance VALUES (3, 3, 3, 1, '2016-06-10');
INSERT INTO attendance VALUES (4, 1, 4, 1, '2016-06-10');
INSERT INTO attendance VALUES (5, 1, 1, 1, '2016-06-13');
INSERT INTO attendance VALUES (6, 1, 2, 1, '2016-06-13');
INSERT INTO attendance VALUES (7, 1, 3, 1, '2016-06-13');
INSERT INTO attendance VALUES (8, 1, 4, 1, '2016-06-13');
INSERT INTO attendance VALUES (13, 1, 2, 2, '2016-06-14');
INSERT INTO attendance VALUES (14, 2, 4, 2, '2016-06-14');
INSERT INTO attendance VALUES (17, 3, 2, 4, '2016-06-14');
INSERT INTO attendance VALUES (18, 1, 4, 4, '2016-06-14');
INSERT INTO attendance VALUES (25, 1, 2, 3, '2016-06-14');
INSERT INTO attendance VALUES (26, 1, 3, 3, '2016-06-14');
INSERT INTO attendance VALUES (27, 1, 1, 1, '2016-06-14');
INSERT INTO attendance VALUES (28, 1, 2, 1, '2016-06-14');
INSERT INTO attendance VALUES (29, 2, 3, 1, '2016-06-14');
INSERT INTO attendance VALUES (30, 3, 4, 1, '2016-06-14');
INSERT INTO attendance VALUES (31, 1, 1, 1, '2016-06-15');
INSERT INTO attendance VALUES (32, 1, 2, 1, '2016-06-15');
INSERT INTO attendance VALUES (33, 1, 3, 1, '2016-06-15');
INSERT INTO attendance VALUES (34, 3, 4, 1, '2016-06-15');
INSERT INTO attendance VALUES (35, 3, 2, 2, '2016-06-22');
INSERT INTO attendance VALUES (36, 1, 4, 2, '2016-06-22');
INSERT INTO attendance VALUES (37, 2, 1, 1, '2016-06-22');
INSERT INTO attendance VALUES (38, 3, 2, 1, '2016-06-22');
INSERT INTO attendance VALUES (39, 1, 3, 1, '2016-06-22');
INSERT INTO attendance VALUES (40, 1, 4, 1, '2016-06-22');
INSERT INTO attendance VALUES (41, 1, 2, 3, '2016-06-22');
INSERT INTO attendance VALUES (42, 3, 3, 3, '2016-06-22');
INSERT INTO attendance VALUES (43, 2, 2, 4, '2016-06-22');
INSERT INTO attendance VALUES (44, 1, 4, 4, '2016-06-22');
INSERT INTO attendance VALUES (47, 1, 1, 1, '2016-06-28');
INSERT INTO attendance VALUES (48, 1, 2, 1, '2016-06-28');
INSERT INTO attendance VALUES (49, 1, 3, 1, '2016-06-28');
INSERT INTO attendance VALUES (50, 1, 4, 1, '2016-06-28');
INSERT INTO attendance VALUES (51, 1, 2, 4, '2016-06-28');
INSERT INTO attendance VALUES (52, 1, 4, 4, '2016-06-28');
INSERT INTO attendance VALUES (55, 1, 2, 3, '2016-06-28');
INSERT INTO attendance VALUES (56, 1, 3, 3, '2016-06-28');
INSERT INTO attendance VALUES (57, 1, 2, 2, '2016-06-28');
INSERT INTO attendance VALUES (58, 1, 4, 2, '2016-06-28');
INSERT INTO attendance VALUES (59, 1, 5, 2, '2016-06-28');
INSERT INTO attendance VALUES (60, 1, 1, 5, '2016-06-30');
INSERT INTO attendance VALUES (61, 2, 2, 5, '2016-06-30');
INSERT INTO attendance VALUES (62, 1, 3, 5, '2016-06-30');
INSERT INTO attendance VALUES (63, 1, 4, 5, '2016-06-30');
INSERT INTO attendance VALUES (64, 3, 5, 5, '2016-06-30');
INSERT INTO attendance VALUES (65, 1, 6, 5, '2016-06-30');
INSERT INTO attendance VALUES (66, 1, 1, 5, '2016-07-05');
INSERT INTO attendance VALUES (67, 3, 2, 5, '2016-07-05');
INSERT INTO attendance VALUES (68, 3, 3, 5, '2016-07-05');
INSERT INTO attendance VALUES (69, 1, 4, 5, '2016-07-05');
INSERT INTO attendance VALUES (70, 1, 5, 5, '2016-07-05');
INSERT INTO attendance VALUES (71, 3, 6, 5, '2016-07-05');
INSERT INTO attendance VALUES (72, 1, 2, 4, '2016-07-08');
INSERT INTO attendance VALUES (73, 1, 4, 4, '2016-07-08');
INSERT INTO attendance VALUES (74, 1, 5, 4, '2016-07-08');
INSERT INTO attendance VALUES (75, 1, 2, 3, '2016-07-14');
INSERT INTO attendance VALUES (76, 3, 3, 3, '2016-07-14');
INSERT INTO attendance VALUES (77, 1, 3, 7, '2016-07-19');
INSERT INTO attendance VALUES (78, 1, 4, 7, '2016-07-19');
INSERT INTO attendance VALUES (79, 1, 5, 7, '2016-07-19');
INSERT INTO attendance VALUES (80, 1, 1, 10, '2016-07-19');
INSERT INTO attendance VALUES (81, 3, 2, 10, '2016-07-19');
INSERT INTO attendance VALUES (82, 1, 3, 10, '2016-07-19');
INSERT INTO attendance VALUES (83, 1, 6, 10, '2016-07-19');


-- ----------------------------
-- Table structure for attendance_types
-- ----------------------------
DROP TABLE attendance_types;
CREATE TABLE attendance_types (
idattendance_types  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
attendance_types_descr  VARCHAR(45)
)

;

-- ----------------------------
-- Records of attendance_types
-- ----------------------------

INSERT INTO attendance_types VALUES (1, 'Present');
INSERT INTO attendance_types VALUES (2, 'Tardy');
INSERT INTO attendance_types VALUES (3, 'Absent');


-- ----------------------------
-- Table structure for classes
-- ----------------------------
DROP TABLE classes;
CREATE TABLE classes (
idclasses  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
idcourses  INTEGER NOT NULL,
idteachers  INTEGER NOT NULL,
class_name  VARCHAR(60) NOT NULL DEFAULT '',
idterm_structure  INTEGER,
startdate  DATE,
enddate  DATE,
starttime  TIME,
endtime  TIME
)

;

-- ----------------------------
-- Records of classes
-- ----------------------------

INSERT INTO classes VALUES (1, 1, 1, 'Math Summer', 4, '2016-06-01', '2016-07-31', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (2, 1, 2, 'Algebra 1', 1, '2016-08-01', '2016-08-31', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (3, 1, 2, 'Algebra 2', 4, '2016-09-01', '2016-09-30', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (4, 2, 1, 'Music History', 1, '2016-01-04', '2016-12-23', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (5, 3, 2, 'English Beginners', 1, '2016-08-01', '2016-12-30', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (6, 3, 2, 'Grammar 1', 1, '2016-07-01', '2016-12-30', '13:00:00', '17:00:00');
INSERT INTO classes VALUES (7, 4, 3, 'Nuclear Chemistry', 7, '2016-07-01', '2016-12-30', '08:00:00', '11:00:00');
INSERT INTO classes VALUES (8, 2, 1, 'Music Beginners', 7, '2016-10-03', '2016-11-30', '10:00:00', '11:00:00');
INSERT INTO classes VALUES (9, 3, 2, 'English Intermediate', 8, '2016-07-01', '2016-12-30', '08:00:00', '12:00:00');
INSERT INTO classes VALUES (10, 4, 3, 'Biochemistry', 8, '2016-02-01', '2016-06-30', '13:00:00', '15:00:00');


-- ----------------------------
-- Table structure for classes_x_assessments
-- ----------------------------
DROP TABLE classes_x_assessments;
CREATE TABLE classes_x_assessments (
idclasses  INTEGER NOT NULL,
idassessments  INTEGER NOT NULL,
date_assessments  DATE,
weight  INTEGER,
PRIMARY KEY (idclasses ASC, idassessments ASC)
)

;

-- ----------------------------
-- Records of classes_x_assessments
-- ----------------------------

INSERT INTO classes_x_assessments VALUES (1, 1, '2016-05-13', 0);
INSERT INTO classes_x_assessments VALUES (1, 2, '2016-05-30', 0);
INSERT INTO classes_x_assessments VALUES (1, 3, '2016-06-15', 0);
INSERT INTO classes_x_assessments VALUES (2, 1, '2016-06-02', 0);
INSERT INTO classes_x_assessments VALUES (2, 5, '2016-12-15', 0);
INSERT INTO classes_x_assessments VALUES (2, 6, '2016-06-30', 0);
INSERT INTO classes_x_assessments VALUES (2, 7, '2016-11-30', 0);
INSERT INTO classes_x_assessments VALUES (3, 1, '2016-09-15', 0);
INSERT INTO classes_x_assessments VALUES (3, 2, '2016-09-30', 0);
INSERT INTO classes_x_assessments VALUES (3, 3, '2016-07-24', 0);
INSERT INTO classes_x_assessments VALUES (4, 6, '2016-06-30', 0);
INSERT INTO classes_x_assessments VALUES (4, 7, '2016-12-23', 0);
INSERT INTO classes_x_assessments VALUES (5, 1, '2016-09-30', 1);
INSERT INTO classes_x_assessments VALUES (5, 2, '2016-11-10', 1);
INSERT INTO classes_x_assessments VALUES (5, 3, '2016-12-30', 1);
INSERT INTO classes_x_assessments VALUES (6, 1, '2016-09-30', 0);
INSERT INTO classes_x_assessments VALUES (6, 2, '2016-12-23', 0);
INSERT INTO classes_x_assessments VALUES (7, 5, '2016-12-30', 0);
INSERT INTO classes_x_assessments VALUES (8, 5, null, null);
INSERT INTO classes_x_assessments VALUES (9, 1, '2016-09-30', 0);
INSERT INTO classes_x_assessments VALUES (9, 2, '2016-12-30', 0);
INSERT INTO classes_x_assessments VALUES (10, 1, '2016-03-29', 0);
INSERT INTO classes_x_assessments VALUES (10, 2, '2016-05-29', 0);
INSERT INTO classes_x_assessments VALUES (10, 4, '2016-06-30', 0);


-- ----------------------------
-- Table structure for courses
-- ----------------------------
DROP TABLE courses;
CREATE TABLE courses (
idcourses  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
idgrade_levels  INTEGER NOT NULL,
course_name  VARCHAR(60) NOT NULL DEFAULT '',
course_descr  TEXT
)

;

-- ----------------------------
-- Records of courses
-- ----------------------------

INSERT INTO courses VALUES (1, 17, 'Math', null);
INSERT INTO courses VALUES (2, 16, 'Music', null);
INSERT INTO courses VALUES (3, 15, 'English', null);
INSERT INTO courses VALUES (4, 15, 'Chemistry', null);


-- ----------------------------
-- Table structure for grade_levels
-- ----------------------------
DROP TABLE grade_levels;
CREATE TABLE grade_levels (
idgrade_levels  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
grade_levels_descr  VARCHAR(45)
)

;

-- ----------------------------
-- Records of grade_levels
-- ----------------------------

INSERT INTO grade_levels VALUES (1, 'Pre-kindergarten');
INSERT INTO grade_levels VALUES (2, 'Kindergarten');
INSERT INTO grade_levels VALUES (3, '1st grade');
INSERT INTO grade_levels VALUES (4, '2nd grade');
INSERT INTO grade_levels VALUES (5, '3rd grade');
INSERT INTO grade_levels VALUES (6, '4th grade');
INSERT INTO grade_levels VALUES (7, '5th grade');
INSERT INTO grade_levels VALUES (8, '6th grade');
INSERT INTO grade_levels VALUES (9, '7th grade');
INSERT INTO grade_levels VALUES (10, '8th grade');
INSERT INTO grade_levels VALUES (11, '9th grade');
INSERT INTO grade_levels VALUES (12, '10th grade');
INSERT INTO grade_levels VALUES (13, '11th grade');
INSERT INTO grade_levels VALUES (14, '12th grade');
INSERT INTO grade_levels VALUES (15, 'College');
INSERT INTO grade_levels VALUES (16, 'Occupational');
INSERT INTO grade_levels VALUES (17, 'Other');


-- ----------------------------
-- Table structure for grade_scales
-- ----------------------------
DROP TABLE grade_scales;
CREATE TABLE grade_scales (
letter_grade  VARCHAR(2) NOT NULL DEFAULT '',
minimum  DECIMAL(5,2),
maximum  DECIMAL(5,2),
PRIMARY KEY (letter_grade ASC)
)

;

-- ----------------------------
-- Records of grade_scales
-- ----------------------------

INSERT INTO grade_scales VALUES ('A', 93, 96.99);
INSERT INTO grade_scales VALUES ('A+', 97, 100);
INSERT INTO grade_scales VALUES ('A-', 90, 92.99);
INSERT INTO grade_scales VALUES ('B', 83, 86.99);
INSERT INTO grade_scales VALUES ('B+', 87, 89.99);
INSERT INTO grade_scales VALUES ('B-', 80, 82.99);
INSERT INTO grade_scales VALUES ('C', 73, 76.99);
INSERT INTO grade_scales VALUES ('C+', 77, 79.99);
INSERT INTO grade_scales VALUES ('C-', 70, 72.99);
INSERT INTO grade_scales VALUES ('D', 63, 66.99);
INSERT INTO grade_scales VALUES ('D+', 67, 69.99);
INSERT INTO grade_scales VALUES ('D-', 60, 62.99);
INSERT INTO grade_scales VALUES ('F', 0, 59.99);


-- ----------------------------
-- Table structure for gradebook
-- ----------------------------
DROP TABLE gradebook;
CREATE TABLE gradebook (
idstudents  INTEGER NOT NULL,
idclasses  INTEGER NOT NULL,
idassessments  INTEGER NOT NULL,
grade  DECIMAL(5,2),
letter_grade  VARCHAR(2),
comments  TEXT,
published  INTEGER DEFAULT 0,
PRIMARY KEY (idstudents ASC, idclasses ASC, idassessments ASC)
)

;

-- ----------------------------
-- Records of gradebook
-- ----------------------------

INSERT INTO gradebook VALUES (1, 1, 1, 22, 'F', null, 1);
INSERT INTO gradebook VALUES (1, 1, 2, 20, 'F', null, 1);
INSERT INTO gradebook VALUES (1, 1, 3, 60, 'D-', null, 0);
INSERT INTO gradebook VALUES (1, 5, 1, 45, 'C', null, 0);
INSERT INTO gradebook VALUES (1, 5, 2, 32, 'B-', null, 0);
INSERT INTO gradebook VALUES (1, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (1, 5, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (1, 6, 1, 55, 'A-', null, 0);
INSERT INTO gradebook VALUES (1, 6, 2, null, 'F', null, 0);
INSERT INTO gradebook VALUES (1, 10, 1, 55, 'A-', null, 0);
INSERT INTO gradebook VALUES (1, 10, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (1, 10, 4, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 1, 1, 60, 'A+', null, 1);
INSERT INTO gradebook VALUES (2, 1, 2, 22, 'F', null, 1);
INSERT INTO gradebook VALUES (2, 1, 3, 85, 'B', null, 0);
INSERT INTO gradebook VALUES (2, 2, 1, 60, 'A+', null, 0);
INSERT INTO gradebook VALUES (2, 2, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 2, 6, 77, 'C+', null, 0);
INSERT INTO gradebook VALUES (2, 2, 7, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 3, 1, 45, 'C', null, 0);
INSERT INTO gradebook VALUES (2, 3, 2, 20, 'F', null, 0);
INSERT INTO gradebook VALUES (2, 3, 3, 88, 'B+', null, 0);
INSERT INTO gradebook VALUES (2, 4, 6, 75, 'C', null, 0);
INSERT INTO gradebook VALUES (2, 4, 7, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 5, 1, 56, 'A', null, 0);
INSERT INTO gradebook VALUES (2, 5, 2, 30, 'C', null, 0);
INSERT INTO gradebook VALUES (2, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 5, 5, null, 'F', null, 0);
INSERT INTO gradebook VALUES (2, 6, 1, 50, 'B', null, 0);
INSERT INTO gradebook VALUES (2, 6, 2, null, 'F', null, 0);
INSERT INTO gradebook VALUES (2, 8, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 10, 1, 60, 'A+', null, 0);
INSERT INTO gradebook VALUES (2, 10, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (2, 10, 4, null, null, null, 0);
INSERT INTO gradebook VALUES (3, 1, 1, 12, 'F', null, 1);
INSERT INTO gradebook VALUES (3, 1, 2, 40, 'A+', null, 1);
INSERT INTO gradebook VALUES (3, 1, 3, 67, 'D+', null, 0);
INSERT INTO gradebook VALUES (3, 3, 1, 45, 'C', null, 0);
INSERT INTO gradebook VALUES (3, 3, 2, 25, 'D-', null, 0);
INSERT INTO gradebook VALUES (3, 3, 3, 65, 'D', null, 0);
INSERT INTO gradebook VALUES (3, 5, 1, 32, 'F', null, 0);
INSERT INTO gradebook VALUES (3, 5, 2, 25, 'D-', null, 0);
INSERT INTO gradebook VALUES (3, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (3, 5, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (3, 7, 5, 70, 'C-', null, 0);
INSERT INTO gradebook VALUES (3, 10, 1, 45, 'C', null, 0);
INSERT INTO gradebook VALUES (3, 10, 2, null, 'F', null, 0);
INSERT INTO gradebook VALUES (3, 10, 4, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 1, 1, 50, 'B', null, 1);
INSERT INTO gradebook VALUES (4, 1, 2, 25, 'D-', null, 1);
INSERT INTO gradebook VALUES (4, 1, 3, 90, 'A-', null, 0);
INSERT INTO gradebook VALUES (4, 2, 1, 60, 'A+', null, 0);
INSERT INTO gradebook VALUES (4, 2, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 2, 6, 45, 'F', null, 0);
INSERT INTO gradebook VALUES (4, 2, 7, null, 'F', null, 0);
INSERT INTO gradebook VALUES (4, 4, 6, 63, 'D', null, 0);
INSERT INTO gradebook VALUES (4, 4, 7, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 5, 1, 56, 'A', null, 0);
INSERT INTO gradebook VALUES (4, 5, 2, 25, 'D-', null, 0);
INSERT INTO gradebook VALUES (4, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 5, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 7, 5, 60, 'D-', null, 0);
INSERT INTO gradebook VALUES (4, 9, 1, null, null, null, 0);
INSERT INTO gradebook VALUES (4, 9, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 2, 1, 42, 'C-', null, 0);
INSERT INTO gradebook VALUES (5, 2, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 2, 6, 65, 'D', null, 0);
INSERT INTO gradebook VALUES (5, 2, 7, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 3, 1, 30, 'F', null, 0);
INSERT INTO gradebook VALUES (5, 3, 2, null, 'F', null, 0);
INSERT INTO gradebook VALUES (5, 3, 3, 70, 'C-', null, 0);
INSERT INTO gradebook VALUES (5, 4, 6, 88, 'B+', null, 0);
INSERT INTO gradebook VALUES (5, 4, 7, null, 'F', null, 0);
INSERT INTO gradebook VALUES (5, 5, 1, 43, 'C-', null, 0);
INSERT INTO gradebook VALUES (5, 5, 2, 35, 'B+', null, 0);
INSERT INTO gradebook VALUES (5, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 5, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 7, 5, 80, 'B-', null, 0);
INSERT INTO gradebook VALUES (5, 9, 1, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 9, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 10, 1, 45, 'C', null, 0);
INSERT INTO gradebook VALUES (5, 10, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (5, 10, 4, null, null, null, 0);
INSERT INTO gradebook VALUES (6, 5, 1, 40, 'D', null, 0);
INSERT INTO gradebook VALUES (6, 5, 2, 20, 'F', null, 0);
INSERT INTO gradebook VALUES (6, 5, 3, null, null, null, 0);
INSERT INTO gradebook VALUES (6, 5, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (6, 8, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (6, 10, 1, 41, 'D+', null, 0);
INSERT INTO gradebook VALUES (6, 10, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (6, 10, 4, null, null, null, 0);
INSERT INTO gradebook VALUES (7, 3, 1, 55, 'A-', null, 0);
INSERT INTO gradebook VALUES (7, 3, 2, null, 'F', null, 0);
INSERT INTO gradebook VALUES (7, 3, 3, 45, 'F', null, 0);
INSERT INTO gradebook VALUES (7, 8, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (8, 3, 1, 38, 'D', null, 0);
INSERT INTO gradebook VALUES (8, 3, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (8, 3, 3, 85, 'B', null, 0);
INSERT INTO gradebook VALUES (8, 9, 1, null, null, null, 0);
INSERT INTO gradebook VALUES (8, 9, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (10, 8, 5, null, null, null, 0);
INSERT INTO gradebook VALUES (10, 9, 1, null, null, null, 0);
INSERT INTO gradebook VALUES (10, 9, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (10, 10, 1, 35, 'F', null, 0);
INSERT INTO gradebook VALUES (10, 10, 2, null, null, null, 0);
INSERT INTO gradebook VALUES (10, 10, 4, null, null, null, 0);


-- ----------------------------
-- Table structure for gradebook_aux
-- ----------------------------
DROP TABLE gradebook_aux;
CREATE TABLE gradebook_aux (
idstudents  INTEGER NOT NULL,
idclasses  INTEGER NOT NULL,
fld_1_id  INTEGER,
fld_1_name  VARCHAR(45),
fld_1_grade  DECIMAL(5,2),
fld_1_max  DECIMAL(5,2),
fld_1_letter_grade  VARCHAR(2),
fld_2_id  INTEGER,
fld_2_name  VARCHAR(45),
fld_2_grade  DECIMAL(5,2),
fld_2_max  DECIMAL(5,2),
fld_2_letter_grade  VARCHAR(2),
fld_3_id  INTEGER,
fld_3_name  VARCHAR(45),
fld_3_grade  DECIMAL(5,2),
fld_3_max  DECIMAL(5,2),
fld_3_letter_grade  VARCHAR(2),
fld_4_id  INTEGER,
fld_4_name  VARCHAR(45),
fld_4_grade  DECIMAL(5,2),
fld_4_max  DECIMAL(5,2),
fld_4_letter_grade  VARCHAR(2),
fld_5_id  INTEGER,
fld_5_name  VARCHAR(45),
fld_5_grade  DECIMAL(5,2),
fld_5_max  DECIMAL(5,2),
fld_5_letter_grade  VARCHAR(2),
fld_6_id  INTEGER,
fld_6_name  VARCHAR(45),
fld_6_grade  DECIMAL(5,2),
fld_6_max  DECIMAL(5,2),
fld_6_letter_grade  VARCHAR(2),
fld_7_id  INTEGER,
fld_7_name  VARCHAR(45),
fld_7_grade  DECIMAL(5,2),
fld_7_max  DECIMAL(5,2),
fld_7_letter_grade  VARCHAR(2),
fld_8_id  INTEGER,
fld_8_name  VARCHAR(45),
fld_8_grade  DECIMAL(5,2),
fld_8_max  DECIMAL(5,2),
fld_8_letter_grade  VARCHAR(2),
fld_9_id  INTEGER,
fld_9_name  VARCHAR(45),
fld_9_grade  DECIMAL(5,2),
fld_9_max  DECIMAL(5,2),
fld_9_letter_grade  VARCHAR(2),
fld_10_id  INTEGER,
fld_10_name  VARCHAR(45),
fld_10_grade  DECIMAL(5,2),
fld_10_max  DECIMAL(5,2),
fld_10_letter_grade  VARCHAR(2),
fld_11_id  INTEGER,
fld_11_name  VARCHAR(45),
fld_11_grade  DECIMAL(5,2),
fld_11_max  DECIMAL(5,2),
fld_11_letter_grade  VARCHAR(2),
fld_12_id  INTEGER,
fld_12_name  VARCHAR(45),
fld_12_grade  DECIMAL(5,2),
fld_12_max  DECIMAL(5,2),
fld_12_letter_grade  VARCHAR(2),
PRIMARY KEY (idstudents ASC, idclasses ASC)
)

;

-- ----------------------------
-- Records of gradebook_aux
-- ----------------------------

INSERT INTO gradebook_aux VALUES (1, 1, 1, 'Test X', 22, 60, 'F', 2, 'Test Y', 20, 40, 'F', 3, 'Test Z', 60, 100, 'D-', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (1, 5, 1, 'Test X', 45, 60, 'C', 2, 'Test Y', 32, 40, 'B-', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (1, 6, 1, 'Test X', null, 60, null, 2, 'Test Y', null, 40, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (1, 10, 1, 'Test X', 55, 60, 'A-', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 1, 1, 'Test X', 60, 60, 'A+', 2, 'Test Y', 12, 40, 'F', 3, 'Test Z', 85, 100, 'B', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 2, 1, 'Test X', 60, 60, 'A+', 6, 'Quiz', 77, 100, 'C+', 7, 'Homework Project', null, 100, null, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 3, 3, 'Test Z', 88, 100, 'B+', 1, 'Test X', 45, 60, 'C', 2, 'Test Y', 20, 40, 'F', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 4, 6, 'Quiz', 75, 100, 'C', 7, 'Homework Project', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 5, 1, 'Test X', 56, 60, 'A', 2, 'Test Y', 30, 40, 'C', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 6, 1, 'Test X', null, 60, null, 2, 'Test Y', null, 40, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 8, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (2, 10, 1, 'Test X', 60, 60, 'A+', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (3, 1, 1, 'Test X', 12, 60, 'F', 2, 'Test Y', 40, 40, 'A+', 3, 'Test Z', 67, 100, 'D+', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (3, 3, 3, 'Test Z', 65, 100, 'D', 1, 'Test X', 45, 60, 'C', 2, 'Test Y', 25, 40, 'D-', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (3, 5, 1, 'Test X', 32, 60, 'F', 2, 'Test Y', 25, 40, 'D-', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (3, 7, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (3, 10, 1, 'Test X', 45, 60, 'C', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (4, 1, 1, 'Test X', 50, 60, 'B', 2, 'Test Y', 25, 40, 'D-', 3, 'Test Z', 90, 100, 'A-', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (4, 2, 1, 'Test X', 60, 60, 'A+', 6, 'Quiz', 45, 100, 'F', 7, 'Homework Project', null, 100, 'F', 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (4, 4, 6, 'Quiz', 63, 100, 'D', 7, 'Homework Project', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (4, 5, 1, 'Test X', 56, 60, 'A', 2, 'Test Y', 25, 40, 'D-', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (4, 7, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 2, 1, 'Test X', 42, 60, 'C-', 6, 'Quiz', 65, 100, 'D', 7, 'Homework Project', null, 100, null, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 3, 3, 'Test Z', null, 100, null, 1, 'Test X', null, 60, null, 2, 'Test Y', null, 40, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 4, 6, 'Quiz', 88, 100, 'B+', 7, 'Homework Project', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 5, 1, 'Test X', 43, 60, 'C-', 2, 'Test Y', 35, 40, 'B+', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 7, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (5, 10, 1, 'Test X', 45, 60, 'C', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (6, 5, 1, 'Test X', 40, 60, 'D', 2, 'Test Y', 20, 40, 'F', 3, 'Test Z', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (6, 8, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (6, 10, 1, 'Test X', 41, 60, 'D+', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (7, 3, 3, 'Test Z', null, 100, null, 1, 'Test X', null, 60, null, 2, 'Test Y', null, 40, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (7, 8, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (8, 3, 3, 'Test Z', null, 100, null, 1, 'Test X', null, 60, null, 2, 'Test Y', null, 40, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (10, 8, 5, 'Final Exam', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO gradebook_aux VALUES (10, 10, 1, 'Test X', 35, 60, 'F', 2, 'Test Y', null, 40, null, 4, 'Test W', null, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);


-- ----------------------------
-- Table structure for parents
-- ----------------------------
DROP TABLE parents;
CREATE TABLE parents (
idparents  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
name  VARCHAR(100),
email  VARCHAR(45),
phone  VARCHAR(45),
login  VARCHAR(255),
photo  BINARY
)

;

-- ----------------------------
-- Records of parents
-- ----------------------------

INSERT INTO parents VALUES (1, 'Homer Dad', null, null, 'homer', null);
INSERT INTO parents VALUES (2, 'Paul Grantt', null, null, 'parent', null);


-- ----------------------------
-- Table structure for parents_x_students
-- ----------------------------
DROP TABLE parents_x_students;
CREATE TABLE parents_x_students (
idparents  INTEGER NOT NULL,
idstudents  INTEGER NOT NULL,
PRIMARY KEY (idparents ASC, idstudents ASC)
)

;

-- ----------------------------
-- Records of parents_x_students
-- ----------------------------

INSERT INTO parents_x_students VALUES (1, 1);
INSERT INTO parents_x_students VALUES (1, 3);
INSERT INTO parents_x_students VALUES (2, 2);
INSERT INTO parents_x_students VALUES (2, 5);


-- ----------------------------
-- Table structure for sec_apps
-- ----------------------------
DROP TABLE sec_apps;
CREATE TABLE sec_apps (
app_name  VARCHAR(128) NOT NULL DEFAULT '',
app_type  VARCHAR(255),
description  VARCHAR(255),
PRIMARY KEY (app_name ASC)
)

;

-- ----------------------------
-- Records of sec_apps
-- ----------------------------

INSERT INTO sec_apps VALUES ('dashboard_charts', 'container', null);
INSERT INTO sec_apps VALUES ('dashboard_chart_attendance', 'cons', null);
INSERT INTO sec_apps VALUES ('dashboard_chart_gradebook', 'cons', null);
INSERT INTO sec_apps VALUES ('dashboard_class_summary', 'cons', null);
INSERT INTO sec_apps VALUES ('dashboard_redir', 'blank', null);
INSERT INTO sec_apps VALUES ('dashboard_summary', 'container', null);
INSERT INTO sec_apps VALUES ('form_assessments', 'form', null);
INSERT INTO sec_apps VALUES ('form_assessments_classes', 'form', null);
INSERT INTO sec_apps VALUES ('form_assessments_classes_inline', 'form', null);
INSERT INTO sec_apps VALUES ('form_attendance', 'form', null);
INSERT INTO sec_apps VALUES ('form_attendance_types', 'form', null);
INSERT INTO sec_apps VALUES ('form_classes', 'form', null);
INSERT INTO sec_apps VALUES ('form_classes_assessments', 'form', null);
INSERT INTO sec_apps VALUES ('form_classes_assessments_inline', 'form', null);
INSERT INTO sec_apps VALUES ('form_courses', 'form', null);
INSERT INTO sec_apps VALUES ('form_gradebook_edit', 'form', null);
INSERT INTO sec_apps VALUES ('form_grade_levels', 'form', null);
INSERT INTO sec_apps VALUES ('form_grade_scales', 'form', null);
INSERT INTO sec_apps VALUES ('form_parents', 'form', null);
INSERT INTO sec_apps VALUES ('form_students', 'form', null);
INSERT INTO sec_apps VALUES ('form_teachers', 'form', null);
INSERT INTO sec_apps VALUES ('form_term_structure', 'form', null);
INSERT INTO sec_apps VALUES ('grid_assessments', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_attendance', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_attendance_students', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_attendance_summary', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_classes', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_classes_in_progress', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_classes_x_assessments', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_coming_classes', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_courses', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_gradebook_students', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_parents', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_parents_x_students', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_students', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_students_x_classes', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_teachers', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_teachers_view', 'cons', null);
INSERT INTO sec_apps VALUES ('grid_term_structure', 'cons', null);
INSERT INTO sec_apps VALUES ('login', 'contr', null);
INSERT INTO sec_apps VALUES ('menu', 'menu', null);
INSERT INTO sec_apps VALUES ('sec_change_pswd', 'contr', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_form_add_users', 'form', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_form_edit_users', 'form', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_form_sec_apps', 'form', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_form_sec_groups', 'form', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_form_sec_groups_apps', 'form', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_grid_sec_apps', 'cons', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_grid_sec_groups', 'cons', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_grid_sec_users', 'cons', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_retrieve_pswd', 'contr', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_search_sec_groups', 'filter', 'Security Application');
INSERT INTO sec_apps VALUES ('sec_sync_apps', 'contr', 'Security Application');
INSERT INTO sec_apps VALUES ('treemenu', 'menutree', null);


-- ----------------------------
-- Table structure for sec_groups
-- ----------------------------
DROP TABLE sec_groups;
CREATE TABLE sec_groups (
group_id  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
description  VARCHAR(255),
UNIQUE (description ASC)
)

;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------

INSERT INTO sec_groups VALUES (1, 'Administrador');
INSERT INTO sec_groups VALUES (2, 'Teachers');
INSERT INTO sec_groups VALUES (3, 'Students');
INSERT INTO sec_groups VALUES (4, 'Parents');


-- ----------------------------
-- Table structure for sec_groups_apps
-- ----------------------------
DROP TABLE sec_groups_apps;
CREATE TABLE sec_groups_apps (
group_id  INTEGER NOT NULL,
app_name  VARCHAR(128) NOT NULL DEFAULT '',
priv_access  VARCHAR(1),
priv_insert  VARCHAR(1),
priv_delete  VARCHAR(1),
priv_update  VARCHAR(1),
priv_export  VARCHAR(1),
priv_print  VARCHAR(1),
PRIMARY KEY (group_id ASC, app_name ASC)
)

;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------

INSERT INTO sec_groups_apps VALUES (1, 'dashboard_charts', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO sec_groups_apps VALUES (1, 'dashboard_chart_attendance', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'dashboard_chart_gradebook', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'dashboard_class_summary', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'dashboard_redir', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'dashboard_summary', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'form_assessments', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_assessments_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_assessments_classes_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_attendance', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_attendance_types', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_classes_assessments', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_classes_assessments_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_gradebook_edit', 'Y', null, null, 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_grade_levels', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_grade_scales', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_parents', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_students', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_teachers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'form_term_structure', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_assessments', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_attendance', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_attendance_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_attendance_summary', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_classes_in_progress', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_classes_x_assessments', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_coming_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_courses', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_gradebook_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_parents', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_parents_x_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_students_x_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_teachers', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_teachers_view', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'grid_term_structure', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'login', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'menu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'sec_change_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'sec_form_add_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_grid_sec_apps', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_grid_sec_groups', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_grid_sec_users', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (1, 'sec_retrieve_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'sec_search_sec_groups', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (1, 'sec_sync_apps', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO sec_groups_apps VALUES (1, 'treemenu', 'Y', 'N', 'N', 'N', 'N', 'N');
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_charts', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_chart_attendance', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_chart_gradebook', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_class_summary', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_redir', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'dashboard_summary', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_assessments', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_assessments_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_assessments_classes_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_attendance', 'Y', 'Y', null, 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_attendance_types', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_classes_assessments', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_classes_assessments_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_gradebook_edit', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_grade_levels', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_grade_scales', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_parents', 'Y', null, null, 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_students', 'Y', 'Y', null, 'Y', 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'form_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'form_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'grid_assessments', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_attendance', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_attendance_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_attendance_summary', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_classes_in_progress', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_classes_x_assessments', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_coming_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'grid_gradebook_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_parents', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_parents_x_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_students_x_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'grid_teachers_view', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (2, 'grid_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'login', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'menu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_change_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_form_add_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_form_edit_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_form_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_form_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_form_sec_groups_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_grid_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_grid_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_grid_sec_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_retrieve_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_search_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'sec_sync_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (2, 'treemenu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_charts', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_chart_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_chart_gradebook', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_class_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_redir', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'dashboard_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_assessments_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_assessments_classes_inline', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_attendance_types', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_classes_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_classes_assessments_inline', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_gradebook_edit', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_grade_levels', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_grade_scales', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_parents', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_students', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'form_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_attendance_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_attendance_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_classes_in_progress', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_classes_x_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_coming_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_gradebook_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_parents', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_parents_x_students', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_students', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_students_x_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'grid_teachers_view', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (3, 'grid_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'login', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'menu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_change_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_form_add_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_form_edit_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_form_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_form_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_form_sec_groups_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_grid_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_grid_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_grid_sec_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_retrieve_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_search_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'sec_sync_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (3, 'treemenu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_charts', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_chart_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_chart_gradebook', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_class_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_redir', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'dashboard_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_assessments_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_assessments_classes_inline', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_attendance_types', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_classes_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_classes_assessments_inline', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_gradebook_edit', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_grade_levels', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_grade_scales', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_parents', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_students', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'form_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_attendance', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_attendance_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (4, 'grid_attendance_summary', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_classes_in_progress', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_classes_x_assessments', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_coming_classes', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_courses', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_gradebook_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (4, 'grid_parents', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_parents_x_students', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (4, 'grid_students', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_students_x_classes', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (4, 'grid_teachers', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'grid_teachers_view', 'Y', null, null, null, 'Y', 'Y');
INSERT INTO sec_groups_apps VALUES (4, 'grid_term_structure', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'login', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'menu', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_change_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_form_add_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_form_edit_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_form_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_form_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_form_sec_groups_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_grid_sec_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_grid_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_grid_sec_users', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_retrieve_pswd', 'Y', null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_search_sec_groups', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'sec_sync_apps', null, null, null, null, null, null);
INSERT INTO sec_groups_apps VALUES (4, 'treemenu', 'Y', null, null, null, null, null);


-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
DROP TABLE sec_users;
CREATE TABLE sec_users (
login  VARCHAR(255) NOT NULL DEFAULT '',
pswd  VARCHAR(32) NOT NULL DEFAULT '',
name  VARCHAR(64),
email  VARCHAR(64),
is_active  VARCHAR(1),
activation_code  VARCHAR(32),
priv_admin  VARCHAR(1),
PRIMARY KEY (login ASC)
)

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------

INSERT INTO sec_users VALUES ('adele', '81dc9bdb52d04dc20036dbd8313ed055', 'Adele Paulene', 'adele@paulene', 'Y', null, null);
INSERT INTO sec_users VALUES ('admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Admin', 'admin@admin.com', 'Y', null, 'Y');
INSERT INTO sec_users VALUES ('alicia', 'e94ef563867e9c9df3fcc999bdb045f5', 'Alicia Goldsmith', 'alicia@alicia.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('allan', 'b993e4526238d62f6b1b90e605532ff8', 'Allan Wake', 'allan@wake.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('anthon', '81dc9bdb52d04dc20036dbd8313ed055', 'Anthon Feldman', 'anthon@feldman.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('benjamin', '81dc9bdb52d04dc20036dbd8313ed055', 'Benjamin Arlie', 'ben@arlie.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('billy', '89c246298be2b6113fb10ba80f3c6956', 'Billy Grantt', 'billy@billy.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('homer', 'dfa8327f5bfa4c672a04f9b38e348a70', 'Homer Dad', 'homer@dad.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('john', '527bd5b5d689e2c32ae974c6229ff785', 'John Scott', 'john@john.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('parent', '81dc9bdb52d04dc20036dbd8313ed055', 'Paul Grantt', 'paul@grantt.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('paul', '6c63212ab48e8401eaf6b59b95d816a9', 'Paul Simmons', 'paul@simmons.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('piers', '81dc9bdb52d04dc20036dbd8313ed055', 'Piers Raymond', 'piers@ramond.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('prissy', '81dc9bdb52d04dc20036dbd8313ed055', 'Prissy Alisha', 'prissy@alisha.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('ruth', '81ea66d57d6b827ef722f4f20f8a669c', 'Ruth Schroeber', 'ruth@ruth.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('student', '81dc9bdb52d04dc20036dbd8313ed055', 'Philiph Grantt', null, 'Y', null, null);
INSERT INTO sec_users VALUES ('syd', '81dc9bdb52d04dc20036dbd8313ed055', 'Syd Grayson', 'syd@grayson.com', 'Y', null, null);
INSERT INTO sec_users VALUES ('teacher', '81dc9bdb52d04dc20036dbd8313ed055', 'John Scott', 'teacher@teacher.com', 'Y', null, null);


-- ----------------------------
-- Table structure for sec_users_groups
-- ----------------------------
DROP TABLE sec_users_groups;
CREATE TABLE sec_users_groups (
login  VARCHAR(255) NOT NULL DEFAULT '',
group_id  INTEGER NOT NULL,
PRIMARY KEY (login ASC, group_id ASC)
)

;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------

INSERT INTO sec_users_groups VALUES ('adele', 3);
INSERT INTO sec_users_groups VALUES ('admin', 1);
INSERT INTO sec_users_groups VALUES ('alicia', 3);
INSERT INTO sec_users_groups VALUES ('allan', 3);
INSERT INTO sec_users_groups VALUES ('anthon', 3);
INSERT INTO sec_users_groups VALUES ('benjamin', 3);
INSERT INTO sec_users_groups VALUES ('billy', 3);
INSERT INTO sec_users_groups VALUES ('homer', 4);
INSERT INTO sec_users_groups VALUES ('john', 2);
INSERT INTO sec_users_groups VALUES ('parent', 4);
INSERT INTO sec_users_groups VALUES ('paul', 2);
INSERT INTO sec_users_groups VALUES ('piers', 3);
INSERT INTO sec_users_groups VALUES ('prissy', 3);
INSERT INTO sec_users_groups VALUES ('ruth', 3);
INSERT INTO sec_users_groups VALUES ('student', 3);
INSERT INTO sec_users_groups VALUES ('syd', 3);
INSERT INTO sec_users_groups VALUES ('teacher', 2);

-- ----------------------------
-- Table structure for students
-- ----------------------------
DROP TABLE students;
CREATE TABLE students (
idstudents  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
firstname  VARCHAR(45),
lastname  VARCHAR(45),
address  VARCHAR(255),
city  VARCHAR(45),
state  VARCHAR(45),
postalcode  VARCHAR(45),
email  VARCHAR(45),
login  VARCHAR(255),
photo  BINARY
)

;

-- ----------------------------
-- Records of students
-- ----------------------------

INSERT INTO students VALUES (1, 'Allan', 'Wake', null, null, null, null, null, 'allan', null);
INSERT INTO students VALUES (2, 'Billy', 'Grantt', null, null, null, null, null, 'billy', null);
INSERT INTO students VALUES (3, 'Alicia', 'Goldsmith', null, null, null, null, null, 'alicia', null);
INSERT INTO students VALUES (4, 'Ruth', 'Schroeber', null, null, null, null, null, 'ruth', null);
INSERT INTO students VALUES (5, 'Philiph', 'Grantt', null, null, null, null, 'phill@grantt.com', 'student', null);
INSERT INTO students VALUES (6, 'Anthon', 'Feldman', null, null, null, null, 'anthon@feldman.com', 'anthon', null);
INSERT INTO students VALUES (7, 'Benjamin', 'Arlie', null, null, null, null, 'ben@arlie.com', 'benjamin', null);
INSERT INTO students VALUES (8, 'Prissy', 'Alisha', null, null, null, null, 'prissy@alisha.com', 'prissy', null);
INSERT INTO students VALUES (9, 'Adele', 'Paulene', null, null, null, null, 'adele@paulene', 'adele', null);
INSERT INTO students VALUES (10, 'Syd', 'Grayson', null, null, null, null, 'syd@grayson.com', 'syd', null);


-- ----------------------------
-- Table structure for students_x_classes
-- ----------------------------
DROP TABLE students_x_classes;
CREATE TABLE students_x_classes (
idstudents  INTEGER NOT NULL,
idclasses  INTEGER NOT NULL,
final_grade  DECIMAL(5,2),
letter_grade  VARCHAR(2),
PRIMARY KEY (idstudents ASC, idclasses ASC)
)

;

-- ----------------------------
-- Records of students_x_classes
-- ----------------------------

INSERT INTO students_x_classes VALUES (1, 1, 48.89, 'F');
INSERT INTO students_x_classes VALUES (1, 5, 77.5, 'C+');
INSERT INTO students_x_classes VALUES (1, 6, 91.67, 'A-');
INSERT INTO students_x_classes VALUES (1, 10, 91.67, 'A-');
INSERT INTO students_x_classes VALUES (2, 1, 80, 'B-');
INSERT INTO students_x_classes VALUES (2, 2, 88.5, 'B+');
INSERT INTO students_x_classes VALUES (2, 3, 71, 'C-');
INSERT INTO students_x_classes VALUES (2, 4, 75, 'C');
INSERT INTO students_x_classes VALUES (2, 5, 84.17, 'B');
INSERT INTO students_x_classes VALUES (2, 6, 83.33, 'B');
INSERT INTO students_x_classes VALUES (2, 8, null, null);
INSERT INTO students_x_classes VALUES (2, 10, 100, 'A+');
INSERT INTO students_x_classes VALUES (3, 1, 62.33, 'D-');
INSERT INTO students_x_classes VALUES (3, 3, 67.5, 'D+');
INSERT INTO students_x_classes VALUES (3, 5, 57.92, 'F');
INSERT INTO students_x_classes VALUES (3, 7, 70, 'C-');
INSERT INTO students_x_classes VALUES (3, 10, 75, 'C');
INSERT INTO students_x_classes VALUES (4, 1, 78.61, 'C+');
INSERT INTO students_x_classes VALUES (4, 2, 72.5, 'C-');
INSERT INTO students_x_classes VALUES (4, 4, 63, 'D');
INSERT INTO students_x_classes VALUES (4, 5, 77.92, 'C+');
INSERT INTO students_x_classes VALUES (4, 7, 60, 'D-');
INSERT INTO students_x_classes VALUES (4, 9, null, null);
INSERT INTO students_x_classes VALUES (5, 2, 67.5, 'D+');
INSERT INTO students_x_classes VALUES (5, 3, 60, 'D-');
INSERT INTO students_x_classes VALUES (5, 4, 88, 'B+');
INSERT INTO students_x_classes VALUES (5, 5, 79.58, 'C+');
INSERT INTO students_x_classes VALUES (5, 7, 80, 'B-');
INSERT INTO students_x_classes VALUES (5, 9, null, null);
INSERT INTO students_x_classes VALUES (5, 10, 75, 'C');
INSERT INTO students_x_classes VALUES (6, 5, 58.33, 'F');
INSERT INTO students_x_classes VALUES (6, 8, null, null);
INSERT INTO students_x_classes VALUES (6, 10, 68.33, 'D+');
INSERT INTO students_x_classes VALUES (7, 3, 68.33, 'D+');
INSERT INTO students_x_classes VALUES (7, 8, null, null);
INSERT INTO students_x_classes VALUES (8, 3, 74.17, 'C');
INSERT INTO students_x_classes VALUES (8, 9, null, null);
INSERT INTO students_x_classes VALUES (10, 8, null, null);
INSERT INTO students_x_classes VALUES (10, 9, null, null);
INSERT INTO students_x_classes VALUES (10, 10, 58.33, 'F');


-- ----------------------------
-- Table structure for teachers
-- ----------------------------
DROP TABLE teachers;
CREATE TABLE teachers (
idteachers  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
firstname  TEXT(45) NOT NULL,
lastname  TEXT(45) NOT NULL,
address  TEXT(255),
city  TEXT(45),
state  TEXT(45),
postalcode  TEXT(45),
email  TEXT(45),
login  TEXT(255),
photo  BLOB,
profile  TEXT
)

;

-- ----------------------------
-- Records of teachers
-- ----------------------------

INSERT INTO teachers VALUES (1, 'John', 'Scott', 'Kennedy Avenue', 'Olinda', 'PE', null, 'instructor@scriptcase.net', 'teacher', X'FFD8FFE000104A46494600010100000100010000FFFE003E43524541544F523A2067642D6A7065672076312E3020287573696E6720494A47204A50454720763632292C2064656661756C74207175616C6974790AFFDB004300080606070605080707070909080A0C140D0C0B0B0C1912130F141D1A1F1E1D1A1C1C20242E2720222C231C1C2837292C30313434341F27393D38323C2E333432FFDB0043010909090C0B0C180D0D1832211C213232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232FFC000110801C2012B03012200021101031101FFC4001F0000010501010101010100000000000000000102030405060708090A0BFFC400B5100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FAFFC4001F0100030101010101010101010000000000000102030405060708090A0BFFC400B51100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A35363738393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3F4F5F6F7F8F9FAFFDA000C03010002110311003F00D002A50B48A2A402B13426B68C3B91839C1200AE751D1A3BA9270C115C9E0F279E95B178E63B2918123E5ED556CE18974F2D3421B69EA064E2A93B0E28AF6F76915A6F6B53E4839C838CFB1EE6AB3C705E46F223053D3C9763953ED525EDACD784952EA71F2A95E0FE359D1593492BBCE1C32E3BF4AAB858647309656B520AA91B72C7A11D3F0A9E2B7630C40B6497F9B03D29F069FE5EA4EE41642005607A0AD4FB118951C7186E9F5ACE52469089812D8FDA67690C6AA88093919C006A9C36E2E2566640B1824291DEBAB36845949B7A9CE7DFFCE6B22E6D0C16C88A854E392054739A72198D6E266C8628B18FAE6ABC96F1B132C45B03A0EE4D5FB9B356558E38D883F7CD486D0616245D8060631C915372940CA8ED0CD90ED8239200E956459A4B1EC58F6A7D3AD74569A7450A05DA31D0F153B5BA0F948E9D3DAB2954358D231EDAC638E12367B1E291ED507404735A320DBF4A81CEE4E9C8ACEF7355045292255402AA380075AB5313B78C9F6AA52E76F269A1328CC4139E954E5603A01CD5B9BE638154E64E9ED568CA427551834CDB9EF528185A6336071544D8AD20E4D66DD1C363915A32676E6B3AE4F1551224664DD48EB55D947A55A933CE39CD57393D6BA118C910E29B8A94A73E949C063FD6AEE64D11514E2B4D22992D0BF748AF60F06EA0B7FA12AE3F7B17079ED5E3E2BBDF86D76175192D1980122F19F5A4C691E824153C714E12301D6AC490E0915098E905861727BD31B3EB526CA4D94C2C42699B6A72949E59F4A093654735205A4515201589A14F54FF00907C8077E2B56D34C7B8D0A3643B4AFA1EB59FA801F626040C123AD759609E56931A05EAB49B3482BA393B8BD9629121584B228E095CE7DB3DAA0974B96E27334419494E55BBE7D6BB382C2108728B9CE72054AD67186DC146318C628BB2D2D4E46C34A5802305EF8207402B55B4E531367054F2056A2C08AC70A391DE9254200ACD9AA4613D96D2401F291D0553BCB2127EEF6F039FAD6F38EB807154E623706E87159B763548E66E6C8AC8BE5B1E7A8ED5243A6A87DE4743D4F35A328CBE40CFE14A9903F0E6A5BB96A362009B5F1E951CCA31C0F6AB2D83DBAD41374C639150CD119CF1966E9C5579D42FDD3DAAF30205579546D3EB480CC9982AD67CB20E9D6B427C725AB32765008F7AB4672284ADB5BEB55E4F997AD4D28CE29AA99539AB466C8771518A6311B2AC3AAAAE3BD52949EDD2A8965794F159F70739ABF20E0F359F32F2782455C4CD94DB201AAE7156A4CAA9E955C8CF6AD6266C8B3CF149D4F5A715A694AB3362374C63F1A691C734EE7BD260D3258D1D6B77C3B72DA76AB05CF6079AC453835A49C40B210460F6A18E2B43E85D26D5F5830A4006641D4F415D1DF785749D36D1A4BDD48C6E1739E00FCAB83F0A7894695A2C13C80EF09C6783585ADF8B2E75CD6A333CA443B86541ED584EB28DCDE9619CDA5DCEA9A28C9251B72F63EB4DF256AC280634284152A318A4DB5AA775739E4ACDA2B796076A4D83D2A72299B6999975454A05354548A2B3342B6A1197B1700E31CD757A7BEED3ADCFAA035CE5C2EFB691319DC315B3A4C87FB32DC1EA13153235A46C4614738E6925F4FCE990B1201ED4E9718EB4AFA1A25A95B9CE71C545339E99E29D249F2F6354E4909624D64D9AA43257C03CF4AA930CAD4EF55DDB3C1ACDBB9BC515244E6A02DB7393D6ACCC7DEA84AE7938C9A92C7B311F966ABC8F96393D78A6F99BFB9C81511524E49A4324EA3D87AD52B83B41C1E6AE28F971DAA9DD2820E3F3A103322E1F04E7F3ACE94A919357E75F9B04D566455073F5AB466D19CC32D8A5E830054ED19EA0537CB201ABB99D8AB22963D2AA4884B100568390A2AA4879E2A8968A132EDEB54A44249AD1B8048CE2AA3292A0E3EB4D19B45096218C62A031F2062AF48096E955E5E381D6B48B336556419A6328E6A709C535938E956988AA45347DE229EC39FE74C3F7AAD19B139CD6B6913832859230E14E466B26B634A508A58F534A6EC870D59D55D6A7235B819DAB8FBA3B561ADC39BADD9EF4B7136405F5A6941C151C8AE492E87753934F9BB1EABE1BBD371A7A44E7E751C7D2B688AE13C35A8248D10E8C8704577C4034F093938B8CB7446610829A9C366404537153114DDB5D679A59152814C515281599A0B8ABBA5386B52B9FBAC47EB5540A974C3E5DDCB1FF000B7CC2A27B1AD27A9B08DDBD2925918F6A631216A369081593674C50C91B00D55760BC714F9242324771549E600F359B66CA23D9F3C9A89BA83EF49BB2B4879C54B65D88DD41CF06A8CC0E0F4AD06C8E95425460C727A9A45233DC6D618E87AD01B24F3C53DD4B01EC6848C8CE7BF6A0622CB81556700E7279356CC27181CFBD37EC85989619A108C39E225D69AD00C118EF5B86CC12091CE31503DB2E3D69F30AC61B464E3038A8648481935AF2418C91802A9CD1E78A772394C6993923DEA068893D335A325BF7351F938EFC55A919B465CC800E47154A450A0E2B66780727AE6A8CD07154999B463B0619AAE5727A568CD1E0118AA6CB935A23368876F6C5214F6A9C2E2823238A6419D226189C5562BC9AD29A3C8AA5246573ED5AC592D10E39AD5B53B22CD6601C8ABCAC445814A611D09E49F904F27357607F317358E8DBDB9EA2B4ED2601718AC668EDA50D2E68D95DB595E24A3A03C8AF5FB0B84BBB08678D815651CD78DAC664E4D77FE03BB67B39ED9892233F2E6AA968CC310BDD3AC614DC54A4537F0ADCE1275A900E6A351532D6668380A6AB186FE193F84FCAC6A4149326E88E3AF5149ABA1C5D99B0D829C77AAD22E6A4B5904B6EA7DA9581CE00AE7923BA25274273556555C8AD178CEECE78A82484F27159B36467E09352053C1A97CA24D3D2262703BD49772A153839FC2AAC91E49C8AD66B723A8E2A9CA9F3F0290D3288881DDE948200586071DAAE6C00138E69C91F4A00805B679C523C4076AD1D980318A86543B49EF4019BE5718AAB711EC03078CD68B8C1C66A94C477EDD2914919B2C64F418CD5478368C1EA6B42591429E6B32EEE951739154AE4B6915A7555E2AA1E9DAAA5F6A8AA725BBF02B3CDECF29F97A75CE2B654D9CF2A8AE6ABA81D79CD55B83180483C556CDC30396AAEF1372589CF6A7CA4B915EE5C3138E9548E335666460715014C5558CDDC637B53464D498A4C7B55221913AEEE2ABC918E9D6AE6290A02B549936325E32BC11D3A55DB401C8A65C47C8A2C9B6B11E9572D5091A6F631B45B80C35678730C981D735B114995EB59D344AF7C00F5CD628EA84ED1B1A96B2130E48ED5DA7C3C75325DA9EB9AE0DE7F2E3D8BD6BB3F876AEB793139E579A71D246753DE8B67A115A662A634CAE8380912A602A24A945648D078152014C515201C53025B3251D933EE2ADED20E7BD548CE1C1ABA3248AC66ACCEBA52BA10C64FCC47351BA0C71D6ADAA93926A3745CD64D1B2653112B76A96387927D2A5C05040A4F302FBD497A91CCBB508AC991732122B5656DC2B324C897DB352CB8A2330D3E28FE7029C0F7E4D3449B5C1E948A27913078AAB2C8A0807A9A9A693F779ACBBB901C1DD8C75A4D8D223BC9954673CD615F6A491FF10F7F6AABAB6A2C182A93C1AE52FAF1DD88C9EB9EB5AC217DCCEA54B688D2BFD7B6EED9C81EBDEB9FB8D4E7B96C163CF40299E5C9375381EF5622821B7F9988CF726BA528C76391B94B71B6B62D290F2039EB835B09651A28AA4BA8C60623467F751FD6A19B58973B55141233F338A96A4CA8F244D391117E82A95C3AF6AC89759B924F111FA3555FED69CC9878811FEC9A15360EA45EC684A773135095EF4F46F3977007F1A0839C52B08836E69A17E6356C4631D2A268F0D4D09A2023069D818A9193A714840DB4D12539E3DC4D40AA236C81D6ACC84E7355D8E4D5A21976293E5354EDE669351FC714F8E4DBD7A54F651C4B217E33D6A76B949962E6DC2DC820F15E89E0088149E4FC2B854026624F26BBEF87EDFBABA4EC1A887C4151BE4B1D9114CC54A453715B1C609532D42953AD668D078A95698A29EB4C07806AFDBFCE83DAA88E9576C8F2C2A66AE8D294AD2B1698855AAD2377A4BCBA5840CF4AC7BAD72DE353F32F1EF5CF2D763B636EA68B4D8351348001CD72F3F884C8708A31EE714D8F54693EFE5081DEA1C19A29C4E91EE14719AAACC19B3E9CD6647712349F39E0F435753207AE7BD46A689A250C43638C8E94C99F1DF914104FE1DEA194E55B3F9D2634473DE88E2E466B1EFAEC329E7031EB4DBD9D81393C5737A85FB00CB4D2B849D8AFA8C8A2466DDC562B6D672719E6993DD3CD2EDCD2860178EC2BA22AC7249DD915C5C08106396ECBEB4C8629A79224D8D35CC87E48906714B141BDDE793EEA0241FC2BB7F87BA5292D7D2006594FCA7D17D2B68D9194D3B1CA6ABE1DD42CEEACADAEEE56379C6E2883EE8FF1AE4F50B5FB25ECB6FBE46647C027D2BE89F13F86EDF54B35957E5BC8D4F9521EC6BC5B58F0F6AD6F758B888339FF009685B20FE35A29A4AC6167239FD36CFED372C849E14B66AE0B131B9C64E0F5ADBD3F4D1651316F9A5938623B0F4A65D8545DABD4FB544A66D1A7D486D2062BCFE9570DB1382338A96D5095518E315A7E5011F239AC6523651D0C8F276839C64D412C7CF15A0E8327155DD7DA926268A4EB55E4E3BD5A907AD5594719AB466CA8E6A0239A95FBE6A33835A2331A79207AD5D82DC80306A9942578ADDF0C6913EB73B411CCA8C3D686AE34EC2C588D303258F6AF50F0669AF65A4F992AED9253B88A8745F025BD84826BB7F3A41C81D8575810228551803A0A7085B533A95149590D2299521A6E2ACC06A54CBD6A08EA75ACD1A12AD482A35A91698120E953C0E63624771500A78A1ABA1A767733B525B89C920923D0560DD6957130000283B658D76AB1AB2671556E914293DAB9AED1DD652470874368C9DD72A3D70B50986DED47EF2F1988F60315635AD59525686D809241D4F403EB5C8882EF57B8912DA37BB317323E71127F8D5C79A4297240E9A2D7B4D83319BB4E3D4F4AD4B6F10D8CB854BA85CFA0615E4F2437F35A5C5CC4F1431C47A019CD64ADEDD9DCDE6A4CAA7BA8C554A86972635F5B1F41DBDC4737461CFBD5A7B3F31095FC6BCB34496F2DE286656758DC03B3767F115E95A1DFBCC0452F24F435CD2563A632E65732352D3CAA920571BAA5A9CB715EBB7B62B240C76FE95C06B56AAA586CC0A5B329FBC8F3C78CACB8EE69A43170BCF26B4E78079E78E73DAA27871286C719AD798E6E5D4B77D62F0E805A14264200C7A926B6B48D4753B0B58628A2821E323773D69B05CF9F64A8DD5586334B2C2F708583E3AF029A917646D4DE28D55A22ACD6FE9951CD7337D713DD4A1E690B631C1A6BDB5C293F3127EB51182561862724F269DC5C8BA22BDC4E01C46096FEF5534B579A5DCC0935B3169E9905864FEB5A115A22E0002A5C914A0CCEB5B42304822AC5C46C06383EF5A2B101C62AB5CA1078078E3159F35D97CBA19BE571923F1AA93AED3920D6A30CF07159F71F30C7A55459324654C0F6AA73631D79ABF28CB106A84E393CD6D139A4517EA6A3C53DC75E6900E2B44664B060B8FE55D0782AE3EC7E2455271B8E2B9D84ED715AC9FE8BA9DADD2F00906A893DF410541F514DA874F944F610C9EAA2AC115462C8C8A6E2A434CA6491254EB55E3E95616B134245EB52AD307414F5AA02414F5A62F51520A604B19C82BEB58BE229258EC24111C3118AD81C73516A16DF69B7E0024FAD63523D4E9A13E878DEAB2491DB43A65B12659BE7BA91472013CF35EBFE1FF0F59D8787A2B5B68808DE2E4FF7B23939AC4B4D063B796425433CBFEB1B1FA56A58EAD71A0C4B6BB04D6CBC26EE187B67BD119A5A17529397A9E73E24F045F787ECEEDADC34B14AF9385C8DA7B570B65A3CF3CC63F21A28F77CCCC31C57BDEA7E2DFB421892D467A649CD71B753A9667DAA5CF524703F0AA9D4BE889A749F531E38EEE6F2A0B78FCA0980AEC3D2BB9D1E2C4D01C6D63C11EF5CB5B34B35C8727A0000F41FE35DD68D10678CE3BD73CF53AE29451D24907FA2818ED5C16BF69F3BF15E9332FF00A327D2B8DD76355C8C64914AA46D6268BBE87975DDA1F35BB5573103C356B6A40876EDCF4AA08A187352996E3A8D87E5618CF1E9576DE46078F9BB62B3998C2D8ED56A19470D91F853B9362E1605739E7A60D43B58BF4E4F156E3DB2E1481D2A6F23E5E0E4FA9A398BB329A4593C9E6ACC69C0C0E054BE5851CA8A91402A0E7AD26C646011DB9F4A89972E58D5B08323079A8E4456E9C6074A919932AE0E075ACC9D30D5B171B779C1EB5917271903A55C4CE665DC0C74ACE9B9AD098E73542615BC4E59149979269B8007BD4AFD3151E38AD0C868243035B6712E9B1B7F121AC42315B1A7B7996B247D703354B613DCF6AF09F9975E1FB77EBF2D6B32321C15350FC37D2DAEFC0F04F1C9FBD39DBF81E86A74D66037F269D7A861BA43828DDFDC7A8AB5B18B4AE474DC55FB8B3C2EF8B953548820E314C968A887A5584AAE95612B12D132D48B512D4AB54048BD45482A35EB520A0078E95345F32906A11D2A588E1C5125789507695C4F240C9C553BA837738CE07191D2B58A647150BA820F15CBB1DEB538EBDB52B9E3BE702B0E5B56790923FF00AD5DBDD401C9E3158B7300C951C735373648CDB1B51E6AA85E73CD76DA65B08D10E306B1B4AB12650C4715D2C4A148146E4C997DC93001ED5CDEB316F8C9C5746A0B45591AA26606AA9EA88A7A48F2FD6A2D921AC0563BF00D755AF42492707DAB9394157635944DAA68C9580619EF50B9F28706A313F418E791514CCFB7776AA33B9AD6575B80CE338C56D5BB6F5CF7AE32D2F00976E715D458DC065A4D17195CD30011D8D20C31C6338A6A900851C9A1815E9526A3B6E09F6A818819200F9B9269ED2E17F0AA9349F2E01E739A112CA772EABB8AFDD358D3C846735A974DF2E3BD62DC93927A56B1473CD946438155A523AD4D23726ABB1C83C56C8E76577E4D46DC54CC38A8980EF5666C61E7AD5FD2A4C4C533C1159EC7153D83EDBB53571133E86F825A879BA05D5896E6098E07B1E6BA5F1BF851759B4FB65A7EEF51B71BA371C6E1FDD35E4FF07757FB1F89EEAD19B0B3AE40F715F41860E98EA0D38BE86325A9E3FE1EF180B8DD61740A5CC4763A375045747BA36E78E6B85F893A69F0F78AE3D62DD76C539C4B8F5F5ABD6BAE892D637CF519AD16BA82356335616AB466ACA5738D132D4AB512F4A957B5340483AD482A31520A603C74A78A60E94F1D29816D0E52A37CE33490B7634E9064715CB51599DD4A57899F382D59A6D8CB363DEB5A4539E94EB7B7C49B88ED59A47473590FB7B75821E9CD3E36FDE669D260F1D2A046F9CFA53642573522058FB555BD8328E1876E2ADD9F2EA4F42293505CB1C5696BC6E669DA763CE35580BEE18C0AE175088C7B89E0D7A6EA71625231C1EF5C4EB56677BF1F4AE78E8CEB9EA8E3959C5CAAFF007AB7BFB34C968A00E4F53590B6ECB7A848FBA6BB3B4D8D6CA0F0D8C5692764654E37380BDB392CE5DC07435ADA4DE975033D7DEB4F58B25901278AE4E32D65A88507E56AA8FBC8897B8CEFA19405079F4A9F76E047B5635ACE5D0107902B42197E4058F38A871B1BA95C25257209E2AA3B600E79AB139DC093CE791541E4C75F5EB42426C86E1B3C9AC8BA20035A33BE7A1E41ACBB83F29FA55C51848CE908DD5131E0E289186298A370AD923060C46DE7AD42E3B9A99F8E2A090F5AA443227E6881B64CA41EF484D46ADFBC06AD12CEAFC1F7E6CFC5B6B286E0BE0D7D4D67781E18CE7A815F1F6973ECD52D9C7044839AFA634FD4B6D85BB67AA8A96ECC86AE8BDE36D0E2D73469637504EDCA9F435E0AD2DE58335A956FDD12B5F44477AB7311527A8AE2B50F0CDBCFA84D2ED1F3366AD4AC4343232302ACA1AA91F6AB49D2B31A2C254A3B54286A514D012AD48B518E829EB4C0957A5385301A70A6048A7073563875E0D56A7C6E54D4548732B9A52A9CAC718E957814F2411C5445B15CBB1DC9DC47191EF55FEE9F7A999B20D36DE3F36EA34F56E696E5EC8DB8231143113D71CD57BB7566E6AE5C0DB1F1DAB22E4B13C56D51DB439E9AE677663EA8AA54E3EB5C5EAABB81C8AEBF559F6C654F15C66A5376CE6B95EE76C57BA73CF1012E4F24D6ADBC89144A58D65BCAA1C966181552E355815CC68C5DFD16B4B3667CCA268EA7768D900E462B90B96DF7087BE6B5E6D42DA28CF9CA19BB2839AA102B5DCC6678F62FF0AFF535A423632A8EE6CE9CC7CB03A9AD2C31C106A859A81F28AD209F2FD6A65B970D88CCD9015AA9DC1C0241AB13018359B2B326429CE7B1A10E4CAD34ACA4E2A94EE08C0239AB52625048FC4565CCC55CE79C56891849904C307DA917014D3656CE28078073C568640F827E955E4FD2AC363155A5E869A2590BB60544AD83934E3CF5A8CF5AD112CB760C4DEC3CFF0018AF758AFD96CAD541E428AF0FD12133EA90281FC59AF601F2AC6BFDD02B2990D9D5DA6A2635524D5E3781CEECF5AE416E4EE500D6BC72E635E7B524C82388D5B435462356E3354522D29A954D4086A6534D08981E2A406A15A9053025069E0D4429E0D302414BDE999A7034D08911FB50DD79A6669E3918358D5875474D1A967CAC61C0A585FC9B847F43430A8E41C035CFB1D69DCD29EF507FAC95401EA6A8C9A95BB2908E8D8EBCD48B6914CA1A4891F8FE25CD433E9F6ED1B27D9D029F4502AF5647BA8C1D564F3E33B6B8ABF0CA5B35DCDDD86D6C2E703DEB12E6D36124E091EA2B2E5D4D94F4B1E737715D5D48D1DBA10A3EF39FE94CB7D1DA00377DEF7AEE8DBA23160A06EC74AA77762300EDC75AD632B2B194A3ADCE54E9E85B7119C54EB10006D5E05693DBE3D8F4AAC46323BFAD5005B100F231571A6DAA707F1ACD7700641E73D2A279BAAE79C706A6C1CD62C4D72BCFA7233EB59E643CE4E714C9A504607AE6A30FB86334EC4390C958A48AE0900F5AA778BCEE1D0D5F9543C38F4E6A8CCDBE1F75E2A912CCE63CD3C7418A89C76342B55A32B9231CF155653C91DAA666E2AAB1CE4D521318D519EB8A79E4D354177000EB562675DE07D3BCEBD33B0C84AF4271F356478534E165A52B1186719ADA2BDEB093BB336C895B120AD88E51E5AF3DAB1790F57164F94734845F8DAADC66A8446AE466B4045C535329AAC878A9D4D00C9C1A905420D3D4D50130A70351034F068025CD2834C06941AA40494E06A3CD3A861B1275A475F9681C9A57FF005671D6B9671B33B69CF99176200463E94D908E9512C9FBA073D4542F265BA530B6A57B940E0E2B07528C2A6EC5740E09ACDBDB632C6428A891A451CA440F998CE467F3AB72C1E6C4BC738C1A73583C722B75E4718E95AA96E91C04C98C75A9346717756CC1FE959D7501FA035D0EAD796B1657782DE82B9ABCD522C10AA48A69B0714529E26CF1D075AAAF8519638F7A8EEB55701804C67A560DC4F7976E5630EC0752BD056B1836632B21FA9EA2A9F244D97A9B448AE657DF3B9C1E718A820D394E5D8723AEEE6B5AC1C60F6EC2B4694558C95DBBB2D32E323D7A5664CA118815AA0E339EF59B7632CC45668A9232661C9A881E7029F21DA483510E79AD0C4590F155C9F4A99FA5438AA8898C6CE2B5FC35A6B6A1A9C63194539359382EE1457A8F83347167642675F9DF9A26EC89674B1C42289635180062875C0A9F6D4728E2B020A9B7A9A61930715330C2D5363F31AA423650E0D5B8DAA9E0EEAB70AD58CB684E2A75CD471A702ACAA53B05C55A78348168A7610F069E0D459A5068193EEA766A1073D2ACC36EF29E07154800649F5AB50DA3C84646055EB5D382804F5AD058D231D2A92114E2B1541C8C9AAB79008DB72F43D6AFCF72B183DAB0EFAF739C1A25052562A12717700C55707B5308DC720D4514C265EBC8AC9D5AE2FA28D9AD080E83201E86B8E49A7667745A92B9BEB19DB8AA57932448413CFA573106B3E2697646F6F1856E0BA751F5CD596D3F516CCA7748705B86E69729A47562C9A8A872186DF7ACBD77549974EC42D8DDD5B3556F9AE973FE8B213EE71596AD7F22B2BDB8319E304934729D4A8CB731D652F9072CFEB9AA571847FBA598E46057450786AEEEC79C57CB8C1C7CBDAB6AD7C2CB6EB89A3F980CE4F7AD3442F65AFBCCE120D06E2F8AC97036C3D0286C64FA134975676FA68FF470C84F0549CD7757CA96AA0040BB41DC07F10ED5C0EB370249B6A9CF38AA8B32AB08C519D2CBF29C0C13D714FB3620605547C9703D2AD5BF06891C7D4D1761C7D2A85D363E9533BF19AA7312EDEB5290DB28C8A08CD403F4ABCE800E476AA2DC66ACC98C639351B1DAA4F7A7F5A48A17BBBA486304927156B620D8F0B690FA8EA084A931A9C9AF5FB78162851146001591E18D1934DD3D06DF9D8735D1471D6327764498C098155E51F355F75016A938E4D488AB20E2B3A56C48C2B4A41C573D777812EA45CF43571423AF29F355D813A542179ABB02F15AA417278D3A5590B814D8D6A7DBC55244DC85862986A7285B802A58AC1E43C8E28B0D14BA9C0A9E2B6773D2B5E0D315719157A3B5441D2851199B6DA7700915AD0DAAC78E29C02AF4A1EE028AB48098BAA0AA1757A101E6AB5D5F100806B0AEEF49279CD302D5CDF16CF359924BBBBD5779C9CD3118B1A6909B2DC12149011F8D5A982BFCC07154D38A9926D87693C1ACAB52E65746B46AF2BB32DC08A790BC81F9D4F09CB8040193CFD076A811F007352175CE49AE48CADA1DB6EA25D470CC5C794849076FE1DEAA3DADBAC9B02285209C63E9569B38F91C639EB587A85C4B131248E0119CD5B66F07D131D6722A0BA8C8C2331C67BD2DCDF04B342CD92463358173A918D8107A1CD666A3A9B3208D01DA07535373576BDD943C45A9133B056CA9ED5C74BB99CC87AD6E4B6ED3C9B9DB3F4A85AC406FBB54A5639EAC9CB631A280B10C7F5AB4A814E48ABAD6A54671F8546623D7B52B98F2D8AE471C8A87CBDD273D055B64E3AD30011A9CF5A1325A28DC0001ACB989CE2B46E0FC8589E6B380DEE49AD226536452128981D4D773E05F0E17617B709EEA0D73DE1FD1A4D6B5555553E529F98D7B4D8D8A59DB2448B80A314A72E843D87A4400000E953AA6053923F6A9766056666CA931C2E2A9B8AB5391BB155E4E17340146E1F621CD79BEA3A891A84E33FC55DEEA12ED824627A035E477D317BD99B3D5AB7A6AE4C8FA05012D57A14C0A8A1819986056B5B591206455A421B1465B18157A2B366FBD56E0B4080715715556AAC348AB1592AE38AB8B12A8ED41718A8DA4A76192B385E94C32FBD40D2542D2D302779F1DEA8CF75C75A6CB2F1D6B3A697DE801B733E73CD65CAC09249A9E67ACEB994283400349CE054D07359D13967AD4B7E40AB44B2C2F4A64BD2A4ED51C8700D310B6B75F379521FA1AB2C586476AC598F71C1AD1D36F52ED0C4E7F7A9C11EB5C788A56F791D987AB7F758C9C49B7E566159779673C8BB8BEEFAD748611F5A05B291B48AE43B13B1C37D8240E4B6304FA5452E9819497CE47AD76D2E9E839DBC567CF66A41E29A637A9C57D81B24A8E299F65600EE5AEAA6B6445385CEDAA13C4ABF7B8CD3B8B94E726846395FA567CC806715BB7407DD03A77AC2B9C2B1C76A1132562A3B73CF154E77E08F4A9A797A7D6A84D28DA715A2462D95277DC76D11DB3CF2A5BC43324871C53E24C9DE4715DF7817C32D34A751B98F03F801156DD918BD753A2F0AF87E3D1F4E41B3F7AC32C6BA109CF4AB0220A30053963ACC8646A944985426A7DB8AAB76D8422824CD73B9C9A82E4FC953915567F4A6239ED725F2B4C99BDABCA1CEE724F735E97E2C9847A64833D6BCD2BA692D0967D6B058AAE0E2AFA46A9D29A5C0A4DF57619396E2985EA22F4C320CD30272FC546CF50996A367CD003DE4AACF25248F5599E801D2CBC55099FDE96E27DA3AD664D77918CD3B05C75C4E141E6B1E79F7BE07AD177704E6A9C44B38A6901A96C99E6B5A1C28159F698C0AD01C2F1544B26DC00A8643BB34A32686C05E9408A332E01AE6EF2FA6D36F45CC2D82A7A7AD7477522AA1CF5AE47560D28623A526AEAC38BB3B9E89A5DF2EA56515C852BBD4120D6A2015CDFC27BF82F6CEE348BA019A16CA67AED35D8EA5A6C9A7B97505E13D0FA7D6BCF9D271D51DB4ABA968F7284FD3DAB22E4ED279AD5924574245645CB2B6E38E9589D2999AD2637038FAD65DD4818918E6ADDE30C83D077AC99E5CAB67AFB50877285CCDB1987A560DDCA724D68DE96C7278AC79B2E315A4519CD942772540EFED55E385A66C0FC6AD9837363927D00CD741E1FF0BEA1AADD24696EF1439F99D8638AD2E91CED5F717C2FE187D5EF13287C843C9F535EC36BA7C7656CB0C6A02A8C7156748D0E0D22C561894020726ACC895367D4894AFB19E539A0273565938A40B4892065C0ACBBB3CD6BCA3E5AC6BB3F35022B119AAF3A652AD85CAD31D32A6826C79AF8DE43E5C717A9AE23C935D9F8DFE5BF8D3F1AE56BB69AF74867D52D2F349E7551F3BDE93CEF7A63B978CB9A697F7AA9E752F9B405C9CB1A89E5C530CA3155A4947AD004AF2E7BD5696E3683CD4524B8EF546798906980DBAB9DC6B3A472454AF963D6ABCFF2AF15483A946690B3E2A5B75CE2ABB0CB55CB65C6298D9A96CBC0ABA3355EDC6055A519C504017DA2A096E060F3524C005ACA95C97C0A1201939699B1DAB3AFE01E4115AB95518EF54AE86E89A9B0463F82EFDB4AF1ADB386C24A7637E35F4780B3C03700CAC3906BE5D5260D6E0907056407F5AFA63479BCFD2E09339CA8AC3AD86CC9D47C345B74962E149EB1B74FC0D71DA9586A36BB8496728F70B91F98AF56A4201EA05652A117AA36857947467844EAEEE43237031822B365B5BA926DB15BC8CC7801549AFA14DBC24E4C484FFBA2B3F54BBB2D2ED5EE27F2E35519C900566E8F2EAD9AAC4B7A24784BF84358B84F32683ECF1FF7A538C7E15AD61E04D365B75692FBCE7FE2DA702ABF8975FD63C5370D069F13C5679C6EC60B55CF0B6977BA52EE9959DBB035C72C4534EC99BFB3A9257B1BB63E12D2AC23DCB0A281D59BAD39BC4FA5691208A128C01C12B58BAFAEBFA91F2E261141FDD19E6B8DBED03548972622D8EE0D38D683D999BA525BA3D9ACB5FB0D4D034332E7D2ADB80464608F5AF0BB5B8B8B28F6B6F8C8EE78AD4F0EF8D35F9F571676D09BA841C3123EE8FAD6FCDA5D99FB37D0F5965F4A6EDA417318850CE444E4720D3810C37290C3D450A4A5B10E2D6E579FA5635CAE5AB6A7E45654EBF31A622B22F6A193029E060D3DD46CA0968F23F1C37FC4E547A2D7318AE8BC68777881C7A0AC0C57753F8519CB73E85337BD384A0F7AAA4D2648ABB08BBBC1EF4EDE31D6A9072290C87D695809E497DEA0697DEA376AAF24B8EF45809259B154A49739E69B2CF906A9BC94EC31F2CA55322B35AF4B3ED353CB2FCB8CD645C643EE14C66AA61C822B42D97A561595C72158D7436A5594114036694230B52B30515147C2E6A0B89B1C03412477170CFF002AD40884727AD0BCB54D8C0E6842207155E752455B619A8A403666819C85FA18EF51BFDAAFA0BC1F379DA05B9FF6057816ACC3ED0BF5AF70F00C9BFC3F07FBB584B4994F63ADA28A6BB88D0B31C01C9356495B50BE874FB47B899C2AA8EF5C1DE5ADC789EE04D74596D41CA459E0FB9AA97FE2083C53E25974E563F64B53EBC3B7FF005ABA4891AD620106E402BC9C5547525CAB647A987A4A9C79DEECAB0E956F691858E35007B536450BD062AEF9CB3700F355AE0601AE0A94D25A1D90949BF78CAB9723359535C3138EA2B46E8E722B35E31D6B8AED1D2E3A15E5B0B6BC89BCE418C53FC373E93A33C96B12AABBB6775646B7A9FD92D9954F35CCDBDC3C80DC313BBB577E19C9EB7382B24B43D0B5FB9597FE5A0DBD7AD7390F8B2EECAE563B77F3221D43563DBC3A96A8F87958467DEBA9D27C2D0478693E63EF5E8429D9DCE594EEB53A1D335C8F54401A368DF1DEA79E3607247145BD94502808A07E156D54E307915B24CE7691967AD38FDD356A7B5C9DCBC1AA726E8D0EE18A9158F1CF16B06F10DC7B71589815ABE216F375DBA73FDEACDD95E843E1462F73DDC9A617C54067A69933564DC9F7E6937D421B8A5278EB40C73C831546793DE9F2C9826A94D2668023924F7AAB24B81D69269719AA32CE282922479723AD56725AA36973DE85624D01D091170411D456C69D7A2360AE6B3A24C8A91622CE36D3449D49B90E9F21A876EEEB55AD97646013CD59071CD2621CA9835215C8E69139EB4F3D28191300055494EE18156CA96A8650235EBCD02396D5E10AE0F7CD7B3FC3B39F0F43F4AF1CD5F3273D857B07C376DDE1D87E958D4F8917D0ED2B93F1AEAED6D646CEDDB134C3048EC2BA6BAB84B5B6799C801466BCE6E049AADD4974F9393F2FB0AC31152CB956ECD28C2EEECE6F49D28E9B706750486E4D7636BA83220E770F4AAB1DB1D85196A34468A4287A76AE29C6DA9EA519A9AE466D130DCAEE8CEC92B3AE6FDADDFCBB95C0ECFD8D42C5872AC41F51546E3525C982F172878DD5CB513B687542166589995FE652083DEB3E794229C9C551BB9E4D3419ADDFCDB7FEEF522B99D4FC44B731B792E41F4F4AE3F62E4F43694D456A55F12DDA4B30456AAD66432AA0E9DEB212569EF3739279EF5B56716D7E057A787A6A2AC7955A57773AED202841C0AEA6D48DB5CAE920E00AEA6D06315D71DCE5917D2ACA2F150A2D5A8C715A19B18D183DAB98F11EAC9A547BA44CA9E2BAD61815E69F1064DDB23F5A1AB82679B6A332DD5FCD320C076C8AAF834F62031A4C0AEC8EC62CF5B04F7A78348801A71503BD51085DF486434D34D3D2818C95F239AA134839AB7370B59174FB73414882E241CF359EF264F5A2794F3CD55DE734144E07353C43E6A82324F4AD182138CB500C9E04DDF4ABC802E05560DB471562DC6E6C9A082E292066A557DD5193C52038A7611716403029C5F8AA8AF8A7F9993498136FAA970C4F1533385155A67DC3834D018DAAF109C57A9FC2C943F86D39E84D795EA4A5A26CD74FF0F7C4F069DA6359BB0126F38158D576D4B8ABE87A078A2F1A5DB6309396FBD8A4B0D34476A015E715269F6CB7927DAA4E598E6B704402E00AE58D372973B3573E55CA8C27B203B553BCD3CB465947CC2BA57881150BC6A14E4553A69AB0E155C5DD1C58042E08E6B17568B72935D66A16E125254706B06FA21B4E79AF3E6B95D8F6E94D4E37479A6A9A8DCD93B2C6E769EAA6B94BAB94B990BA1F2E5EA47635D97896D76B9602BCF2FC1590E3835B53827A9C95E4D334F4D9CBDD049386FE75D958A06C579EE9D7199955CFCC0F06BBBD2E7C85CD370B48E794AF13B3D261E95D140318AC8D18068C1ADE8D39AA8231932CC6338AB4838A8635AB2A38ADD1936324E14D795F8E1B7EA017B006BD527E2335E49E2F7DDAA38F45347504704E0173F5A368A187CC69983EB5D88C8F571263BD06527BD562E680F576251603B1EF4E0C475A6C58239A95B6ED348114EEA6005615D3E49AD5BB3C9E6B1EE10E4D22D1424CE6A300B300073533AD323C2CA09A0A356CAD3E50CC39AB123E0ED514E85B74231C54647CD4C9B9344B919AB4BF28E2A08F815283408B48C0AD3B701CD5656DB4EDE49F6A62253264D383F151EE18E94DDD4AC171EEFBA9A738A319E695CE168199B7EBFBB6CD731693B5BEAAA41C0DD5D4DD0FDD9CD7253291A8A9E9CD67515D1517A9F42F84F5017161173CE05758BC8CD799F826665B5419ED5E8F6EFB9056107A0E6B51EC3BD559BA1AB6FD2A9CC78AA96C11326F13CC4615CEDC0C8653D45750FF00331159177A54EF3168F015BAE6B82B2BEA7A585A8A2ECCF3CF115A6F818E2BC9F5688A4CD9AFA1753F08B5CDB306BA604FF76BC9FC41E0F7B699B2CCC3D6B0A5888C1D99D15A3ED15E270111292020F20D75FA55E1DA87358575A3089598310455AD2D5E289779CE6BB94A3357479F24E3A33D73C3B781D00CD75F11C8AF2DF0E5E7972004D7A3D95C074073DA9256666CD78CF15614F154E37CD59435A2326171C426BC6BC4F213AB5C7B0AF63B83FB96FA5788789A5FF89CDD0F4A6B704730D906A23273523BF7AA649C9C62BACCCF5012E7AD383826ABA839A9429CF15A1372F467E5EB4D91F00F34C4040E69929E290CA93966CF35425381CD5D90E05519CEEA4C68ACC41E2A165DBCD4AEA4544CC71CD22CD4B1977458CD4C460D6669F36D936E6B509A640F427153A1AA82400D4C8C4F34C098E73D69CA69B9C8A767028131F9E2914F349D6940A622527029ADC0CD264914D6381D690CAD738D849AE52F4EDBE461EB5D3DC9241CF4AE5F54F96407D0D44B62D1EBDE0BE6D236F6AF45B56C28AF2AF87F781ED1149E457A8DAB640AE586F62E65E7FBB54273C1ABD27DCACE9CE4D554D11302B01CD3E50440714D1D6A593980FD2B924AF167547492320C8E490CD9AC4D62C23B9898951D2B51DB0C6A8EA770B6F63248DD40E3EB5E33D743D8A6ADA9E25E2C8841782D21E598F38EC2B2E2B844992DC1FBA304D753AEE9C6D6DE5D4AE799A5FBA3D2B82557494CAC7E62735EAE1ADCB6EC79F885697A9DD694DB240735E81A55CFEEC0CD79669379BB6F35DD691763039AE9B1C6CEF20932A2AE46D9AC5B39F728E6B52271C73548CD92DD36216FA5786F8A4E35A9FDCD7B65DBFEE4F3DABC4BC5831AC39F53551F885D0E6E62141AA45F9AB971D6A89EB5D664CF4EDE41AB0928EF5501CD483A55925C13034D660C6AB63D0D38038A077125DBC8AA5281CD589C1CD51949152CA44321C0AACCD9A7C8735031C0A45DC2393CA98115B6921923045736EC41CD6CE9D2EF8C0A64B2EA444B66ADA2803AD46AD85A5DDCD31161703AD05B0302A3561DE9D904F14C072935286E2A1E052124D022567FEED31B2464D20E05359B3C5202BDC3EE15CF6A801535BB30AC5D417E5352CA46FF0080B50F2A71193DEBDC74D93CC8D4FB57CDDE19B830EA88338CB57D11A0B6FB443ED5CB6B48D1FC26E487E4ACC98F26B4663F21ACB90F34540A622D3D8FEEC8A8D69E795C5733D8D91CF4ED89980F5AC8BD6179A84369D517E77ABF78C60BB747EE720D61C371E5BDFDEB1E9F2AD78CAEA6D33DD8D9C53473DE30C5F5CF94A311C4303EB5C05E58ED2DC577927EF7733F249CD645D5986DC715E9517CAAC71D68733B9C7D848D04E6335D9E937982B935C86A509B5BB120040CF35A9A7DC60A9CD762D4F3A6ACCF51D36EB701CD7410499039AE074ABBCE39AEBACA7DCA39A664CD3B87CC47E95E39E2F18D509F7AF5A9A4CC67E95E4FE2F1FF0013027DEAA1F113D0E4A727273D2AAE4D58B93C9E3155327D6BACC8F470F834F59483CD573D69CA79AB116C499A7E4E2ABAF5CD4FD45022390F73546735724CE0E6A94CB8EF52CB452938355DDB153CBF5AACE691444ED56F4D9B63EDAA6D4B0BEC941142133A857E29C1F155607DF18352E40AA116158934FDF55D326A7550053112AF239A7679A676E29A2801ECC7A0A6E7D69770C5577739A0049585645F1C822B4DC822B3AEB041E2A58CCBD3098B568F9EAC2BE92F0D9FF897447FD915F332B795A846FE8D5F487852712693091FDD15CD2D245FD93A395B2B59B275ABCE72B54A4FBD5132A0354D296C0A66714C91F02B07A1BC4C4F11466483CD41F3A7A570D35C63432B9C33CA73F9D7A0DCB070CA4704579A6B63ECD2F93D17CC240AF3EA24EAD8F4E836A99087A4700A9E39355D5F26A4F30E315B245B30B5AB112C2C71CE2B02C6564F91BEF29C576D3C6244231D4571BA843F64D4320615F8AE9A52E870E221D51D3E97778239AED34DBAC80335E656171B48AEC74ABBE9CD6F63899D9B49988D79978BC66E89AEFE39B7455C0F8BBFD767DEAA1B90CE26E89DDC1AA7BBDC55ABCE09C56793CD74999E8ECF86A7A39A8643F3734A8DCD684A2F466A6CE055689BDEA62411408246E2A8CE7DEACC848AA3331EE29148AB31C8355B06A691BAD572D5250C6EB429E7A5216F6A0350235EC27CAEDAD054279AC3B3976CA056FA1C80455013463153A80466A14E99A46971D29887C8E0533CC3DAA2793348AC4D2192962DC531B81D68DD8A61607DE9888DCB37B0AA771C022AD31C0EB54A7900078A91987784ACC187635EEBF0F350173A3443392062BC2AF417C915E87F0BF5531B1B666EFC56155753447B69395AA92F5A9D1F7460FB55699BAD6521C772267AAD2C94E77EB54E56AE791D312BCEFD6B85F17C3854997B1E6BB698F15CCF88A31358C9EC2BCBACF971099E9D057A2CE3E39338CD4C5B35990BE1B04D5D0D915DB625327CD616BF6A1EDCB81F32F20D6D03C0AA979FBD8994FA5545D99151292B1CC5A4DC29CD751A5DCE08E6B9020C170F1F6CE456C69D718239AED8EA8F2E4ACCF44B5B8DD175ED5C978B3919F7AD8B0B8CA0E6B1FC4BF3424FA538AD4CDEC7077A72E456792735A17AA77E7159D9E7A574907A5BF351A9C1A198EDA8B7568417A370454CAC6A8C4F56812578A007B1CE6A9DC6715639EF504A3268634507C639AAEEBE95625E09CD5573E950318C6806999F5A5EF4809A36DAE0D7416D28310E735CEAF15A7A7CE07CA6AD01B21CEDEB51339349BC7AD349C9A64A1DDA95588A8998E38A1777E141448CC0D33773D6949A8DBAF340825618E2A8BA939CD597607A540FC0E6A58D19B7280038EB577C1D7C6D35B419C0271552E9B39C552D2E6F23588DB3FC42B3A8B42A2F53EA2B09BCDB346CF6A6CED59DE1EB912E9911CFF0D5CB86AE77B171DCACEFC9AAF23539DB9AAF2BD60D1D09904AD587AD11F62907A8AD691F2D585ACC9B80887A735E4E257EF8F5B0DFC138073B6E187A1AB31499E2A9DD1FF48639EAC6A485F18C1E6BD05B1CF7D4D0DD85A8A5E57A522C991CD0E41142DCA6733AAC252412014DB39B6B0AD1BF8B7A30C56144C6390A9EC6BA69BE879F5E36773B5D3EE7E51CD47AD37996CC7DAB3B4F9F0073566FA4DF6CDF4ADD2D4E6E871B7472793DAB3D9806357AF080C3E959AC72C78ADC84CF483F72A35EB451568864A956D3A5145310A7A540FF007A8A28634529BA9AA8FD28A2A0A20A4EF451480956ADDA7FAD14515680D71DA97B514532509DA9E3EED14503105325A28A09213D0557968A29148A373F70D6443FF2128FFDE145159CF62A3B9F44F848FF00C4AE1FF76B62E28A2B959A2DCA2FD6AACDD28A2B266E8A6FD6B9ED44FEFE7FF728A2BCAC47F1CF5B0FFC1382B8FF00594F87B514577AD8E6EA5A5E829DEBF4A28A48B285CF4AE76E3FE3EFF0A28ADE9EE71E236346C4F35A371FEA1BE94515D48E3E87237FFC3F4ACD3D68A2B7333FFFD9', X'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');
INSERT INTO teachers VALUES (2, 'Paul', 'Simmons', null, 'Recife', 'PE', null, 'paul@simmons.com', 'paul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
INSERT INTO teachers VALUES (3, 'Piers', 'Raymond', null, null, null, null, 'piers@ramond.com', 'piers', X'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', '<p><span>I am a professional scientific researcher and technical writer with a PhD in</span><span>chemistry</span><span> and almost 10 years of experience in academic and industrial sectors. I have published several peer reviewed articles in internationally renowned scientific journals as well as countless technical reports and papers in my every day working environment.</span></p>');


-- ----------------------------
-- Table structure for term_structure
-- ----------------------------
DROP TABLE term_structure;
CREATE TABLE term_structure (
idterm_structure  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
term_structure_desc  VARCHAR(100)
)

;

-- ----------------------------
-- Records of term_structure
-- ----------------------------

INSERT INTO term_structure VALUES (1, 'Two Semesters');
INSERT INTO term_structure VALUES (2, 'Two Semesters subdivided by Quarters');
INSERT INTO term_structure VALUES (3, 'Two Semesters subdivided by Quarters and Final Exams');
INSERT INTO term_structure VALUES (4, 'Three Trimesters');
INSERT INTO term_structure VALUES (5, 'Four Quarters');
INSERT INTO term_structure VALUES (6, 'Final Year Grade subdivided by Quarters');
INSERT INTO term_structure VALUES (7, 'Final Exam');
INSERT INTO term_structure VALUES (8, 'Two Quarters');


-- ----------------------------
-- Table structure for term_structure_x_assessments
-- ----------------------------
DROP TABLE term_structure_x_assessments;
CREATE TABLE term_structure_x_assessments (
idterm_structure  INTEGER NOT NULL,
idassessments  INTEGER NOT NULL,
PRIMARY KEY (idterm_structure ASC, idassessments ASC)
)

;

-- ----------------------------
-- Records of term_structure_x_assessments
-- ----------------------------

INSERT INTO term_structure_x_assessments VALUES (1, 6);
INSERT INTO term_structure_x_assessments VALUES (1, 7);
INSERT INTO term_structure_x_assessments VALUES (7, 5);
INSERT INTO term_structure_x_assessments VALUES (8, 1);
INSERT INTO term_structure_x_assessments VALUES (8, 2);


-- ----------------------------
-- Auto increment value for assessments
-- ----------------------------

-- ----------------------------
-- Indexes structure for table attendance
-- ----------------------------
CREATE INDEX fk_attendance_attendance_types
ON attendance (idattendance_types ASC);
CREATE INDEX fk_attendance_classes1_idx
ON attendance (idclasses ASC);
CREATE INDEX fk_attendance_students1_idx
ON attendance (idstudents ASC);

-- ----------------------------
-- Indexes structure for table classes
-- ----------------------------
CREATE INDEX fk_classes_courses1_idx
ON classes (idcourses ASC);
CREATE INDEX fk_classes_teachers1_idx
ON classes (idteachers ASC);
CREATE INDEX fk_classes_term_structure1_idx
ON classes (idterm_structure ASC);



-- ----------------------------
-- Indexes structure for table classes_x_assessments
-- ----------------------------
CREATE INDEX fk_classes_has_assessments_assessments1_idx
ON classes_x_assessments (idassessments ASC);
CREATE INDEX fk_classes_has_assessments_classes1_idx
ON classes_x_assessments (idclasses ASC);

-- ----------------------------
-- Indexes structure for table courses
-- ----------------------------
CREATE INDEX fk_courses_grade_levels1_idx
ON courses (idgrade_levels ASC);


-- ----------------------------
-- Indexes structure for table gradebook
-- ----------------------------
CREATE INDEX fk_gradingbook_assessments1_id
ON gradebook (idassessments ASC);
CREATE INDEX fk_gradingbook_classes1_idx
ON gradebook (idclasses ASC);
CREATE INDEX fk_gradingbook_grading_scales1
ON gradebook (letter_grade ASC);
CREATE INDEX fk_students_has_classes_x_asse
ON gradebook (idstudents ASC);

-- ----------------------------
-- Indexes structure for table gradebook_aux
-- ----------------------------
CREATE INDEX fk_gradebook_aux_classes1_idx
ON gradebook_aux (idclasses ASC);
CREATE INDEX fk_gradebook_aux_students1_idx
ON gradebook_aux (idstudents ASC);

-- ----------------------------
-- Indexes structure for table parents
-- ----------------------------
CREATE INDEX login
ON parents (login ASC);


-- ----------------------------
-- Indexes structure for table parents_x_students
-- ----------------------------
CREATE INDEX fk_parents_has_students_parents1_idx
ON parents_x_students (idparents ASC);
CREATE INDEX fk_parents_has_students_students1_idx
ON parents_x_students (idstudents ASC);

-- ----------------------------
-- Indexes structure for table sec_groups_apps
-- ----------------------------
CREATE INDEX fk_sec_groups_apps_idx_1
ON sec_groups_apps (app_name ASC);

-- ----------------------------
-- Indexes structure for table sec_users_groups
-- ----------------------------
CREATE INDEX fk_sec_users_groups_idx_1
ON sec_users_groups (group_id ASC);

-- ----------------------------
-- Indexes structure for table students
-- ----------------------------
CREATE INDEX login2
ON students (login ASC);


-- ----------------------------
-- Indexes structure for table students_x_classes
-- ----------------------------
CREATE INDEX fk_students_has_classes_classes1_idx
ON students_x_classes (idclasses ASC);
CREATE INDEX fk_students_has_classes_students_idx
ON students_x_classes (idstudents ASC);
CREATE INDEX fk_students_x_classes_grade_scales1_idx
ON students_x_classes (letter_grade ASC);



-- ----------------------------
-- Indexes structure for table term_structure_x_assessments
-- ----------------------------
CREATE INDEX fk_term_structure_has_assessments_assessments1_idx
ON term_structure_x_assessments (idassessments ASC);
CREATE INDEX fk_term_structure_has_assessments_term_structure1_idx
ON term_structure_x_assessments (idterm_structure ASC);
