
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `accessLevel`
-- ----------------------------

create table `accesslevel` (
  `accesslevelid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  primary key (`accesslevelid`)
) engine=innodb auto_increment=2 default charset=utf8;

-- ----------------------------
-- Records of accessLevel
-- ----------------------------
INSERT INTO `accesslevel` VALUES ('1', 'Administrators');


-- ----------------------------
-- Table structure for `applications`
-- ----------------------------

create table `applications` (
  `applicationid` varchar(255) not null,
  `description` varchar(255) default null,
  primary key (`applicationid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of applications
-- ----------------------------
INSERT INTO `applications` VALUES ('blank', 'blank');
INSERT INTO `applications` VALUES ('blank_add_cart', 'blank_add_cart');
INSERT INTO `applications` VALUES ('blank_bg', 'blank_bg');
INSERT INTO `applications` VALUES ('container', 'container');
INSERT INTO `applications` VALUES ('control_change_passwd', 'control_change_passwd');
INSERT INTO `applications` VALUES ('control_change_passwd_customer', 'control_change_passwd_customer');
INSERT INTO `applications` VALUES ('control_change_passwd_customer_customer', 'control_change_passwd_customer_customer');
INSERT INTO `applications` VALUES ('form_accesslevel', 'form_accesslevel');
INSERT INTO `applications` VALUES ('form_address', 'form_address');
INSERT INTO `applications` VALUES ('form_address_customer', 'form_address_customer');
INSERT INTO `applications` VALUES ('form_cardtype', 'form_cardtype');
INSERT INTO `applications` VALUES ('form_cart', 'form_cart');
INSERT INTO `applications` VALUES ('form_category', 'form_category');
INSERT INTO `applications` VALUES ('form_country', 'form_country');
INSERT INTO `applications` VALUES ('form_creditcards', 'form_creditcards');
INSERT INTO `applications` VALUES ('form_creditcards_customer', 'form_creditcards_customer');
INSERT INTO `applications` VALUES ('form_customers', 'form_customers');
INSERT INTO `applications` VALUES ('form_customers_customer', 'form_customers_customer');
INSERT INTO `applications` VALUES ('form_customers_new_customer', 'form_customers_new_customer');
INSERT INTO `applications` VALUES ('form_department', 'form_department');
INSERT INTO `applications` VALUES ('form_measure', 'form_measure');
INSERT INTO `applications` VALUES ('form_orderitens', 'form_orderitens');
INSERT INTO `applications` VALUES ('form_orders', 'form_orders');
INSERT INTO `applications` VALUES ('form_orderstatus', 'form_orderstatus');
INSERT INTO `applications` VALUES ('form_producthome', 'form_producthome');
INSERT INTO `applications` VALUES ('form_products', 'form_products');
INSERT INTO `applications` VALUES ('form_products_dependent', 'form_products_dependent');
INSERT INTO `applications` VALUES ('form_shipping', 'form_shipping');
INSERT INTO `applications` VALUES ('form_shippingrates', 'form_shippingrates');
INSERT INTO `applications` VALUES ('form_shippingrates_detail', 'form_shippingrates_detail');
INSERT INTO `applications` VALUES ('form_state', 'form_state');
INSERT INTO `applications` VALUES ('form_state_by_country', 'form_state_by_country');
INSERT INTO `applications` VALUES ('form_subcategory', 'form_subcategory');
INSERT INTO `applications` VALUES ('form_subcategory_dependent', 'form_subcategory_dependent');
INSERT INTO `applications` VALUES ('form_systemuser', 'form_systemuser');
INSERT INTO `applications` VALUES ('grid_accesslevel', 'grid_accesslevel');
INSERT INTO `applications` VALUES ('grid_address', 'grid_address');
INSERT INTO `applications` VALUES ('grid_address_customer', 'grid_address_customer');
INSERT INTO `applications` VALUES ('grid_category', 'grid_category');
INSERT INTO `applications` VALUES ('grid_country', 'grid_country');
INSERT INTO `applications` VALUES ('grid_creditcards', 'grid_creditcards');
INSERT INTO `applications` VALUES ('grid_creditcards_customer', 'grid_creditcards_customer');
INSERT INTO `applications` VALUES ('grid_customers', 'grid_customers');
INSERT INTO `applications` VALUES ('grid_customers_customer', 'grid_customers_customer');
INSERT INTO `applications` VALUES ('grid_orderitens', 'grid_orderitens');
INSERT INTO `applications` VALUES ('grid_orderitens_customers', 'grid_orderitens_customers');
INSERT INTO `applications` VALUES ('grid_orders', 'grid_orders');
INSERT INTO `applications` VALUES ('grid_orders_customer', 'grid_orders_customer');
INSERT INTO `applications` VALUES ('grid_orders_success', 'grid_orders_success');
INSERT INTO `applications` VALUES ('grid_products', 'grid_products');
INSERT INTO `applications` VALUES ('grid_products_dependent', 'grid_products_dependent');
INSERT INTO `applications` VALUES ('grid_products_destaq', 'grid_products_destaq');
INSERT INTO `applications` VALUES ('grid_products_list_cat', 'grid_products_list_cat');
INSERT INTO `applications` VALUES ('grid_products_list_cat_search', 'grid_products_list_cat_search');
INSERT INTO `applications` VALUES ('grid_products_list_subcat', 'grid_products_list_subcat');
INSERT INTO `applications` VALUES ('grid_product_detail', 'grid_product_detail');
INSERT INTO `applications` VALUES ('grid_shippingrates', 'grid_shippingrates');
INSERT INTO `applications` VALUES ('grid_state', 'grid_state');
INSERT INTO `applications` VALUES ('grid_subcategory', 'grid_subcategory');
INSERT INTO `applications` VALUES ('grid_subcategory_dependent', 'grid_subcategory_dependent');
INSERT INTO `applications` VALUES ('grid_systemuser', 'grid_systemuser');
INSERT INTO `applications` VALUES ('index', 'index');
INSERT INTO `applications` VALUES ('login', 'login');
INSERT INTO `applications` VALUES ('login_customer', 'login_customer');
INSERT INTO `applications` VALUES ('loja', 'loja');
INSERT INTO `applications` VALUES ('menu', 'menu');
INSERT INTO `applications` VALUES ('menu_customer', 'menu_customer');
INSERT INTO `applications` VALUES ('treemenu_home', 'treemenu_home');

-- ----------------------------
-- Table structure for `accesslevel_x_applications`
-- ----------------------------

create table `accesslevel_x_applications` (
  `accesslevelid` int(11) not null,
  `applicationid` varchar(255) not null,
  primary key (`accesslevelid`,`applicationid`),
  key `applicationid` (`applicationid`),
  constraint `accesslevel_x_applications_ibfk_1` foreign key (`applicationid`) references `applications` (`applicationid`),
  constraint `accesslevel_x_applications_ibfk_2` foreign key (`accesslevelid`) references `accesslevel` (`accesslevelid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of accesslevel_x_applications
-- ----------------------------
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'blank');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'blank_add_cart');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'blank_bg');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'container');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'control_change_passwd');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'control_change_passwd_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'control_change_passwd_customer_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_accesslevel');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_address');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_address_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_cardtype');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_cart');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_category');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_country');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_creditcards');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_creditcards_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_customers');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_customers_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_customers_new_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_department');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_measure');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_orderitens');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_orders');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_orderstatus');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_producthome');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_products');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_products_dependent');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_shipping');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_shippingrates');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_shippingrates_detail');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_state');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_state_by_country');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_subcategory');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_subcategory_dependent');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'form_systemuser');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_accesslevel');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_address');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_address_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_category');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_country');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_creditcards');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_creditcards_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_customers');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_customers_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_orderitens');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_orderitens_customers');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_orders');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_orders_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_orders_success');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products_dependent');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products_destaq');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products_list_cat');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products_list_cat_search');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_products_list_subcat');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_product_detail');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_shippingrates');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_state');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_subcategory');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_subcategory_dependent');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'grid_systemuser');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'index');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'login');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'loja');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'menu');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'menu_customer');
INSERT INTO `accesslevel_x_applications` VALUES ('1', 'treemenu_home');

-- ----------------------------
-- Table structure for `address`
-- ----------------------------

create table `address` (
  `addressid` int(11) not null auto_increment,
  `customersid` int(11) not null default '0',
  `description` varchar(255) default null,
  `address1` varchar(255) default null,
  `address2` varchar(255) default null,
  `city` varchar(255) default null,
  `states` varchar(255) default null,
  `country` char(2) default null,
  `postalcode` varchar(255) default null,
  `phone1` varchar(255) default null,
  `phone2` varchar(255) default null,
  primary key (`addressid`),
  key `fk_customersid` (`customersid`),
  key `fk_stateid` (`states`),
  key `fk_country` (`country`),
  constraint `address_ibfk_1` foreign key (`customersid`) references `customers` (`customersid`),
  constraint `address_ibfk_2` foreign key (`states`) references `states` (`stateid`),
  constraint `address_ibfk_3` foreign key (`country`) references `country` (`countrycode`)
) engine=innodb auto_increment=12 default charset=utf8;

-- ----------------------------
-- Records of address
-- ----------------------------
INSERT INTO `address` VALUES ('1', '1', 'Home', 'fifth avenue', '555', 'Bronx', 'NY', 'US', '555', '555-55-55', '');
INSERT INTO `address` VALUES ('2', '2', 'Work', '201 Varick Street', '', 'Houston St Station', 'NY', 'US', '10014-4811', '330-5606', '');
INSERT INTO `address` VALUES ('3', '4', 'home', 'xxx street', '', 'New York', 'NY', 'US', '5555555555555', '555555555555555', '');
INSERT INTO `address` VALUES ('4', '5', 'home', 'st. Londres, 331', '', 'Downville', 'DE', 'US', '50741350', '55819194828025', '');
INSERT INTO `address` VALUES ('5', '9', 'Home', '9 July', '', 'New york', 'NY', 'US', '555', '555-5555', '');
INSERT INTO `address` VALUES ('6', '10', 'Home', 'Boba Street', '', 'Sitka', 'AK', 'US', '555', '555-5555', '');
INSERT INTO `address` VALUES ('7', '11', 'Home', 'Boba Street', '', 'Sitka', 'AK', 'US', '555', '555-5555', '');
INSERT INTO `address` VALUES ('8', '12', 'Home', 'Boba Street', '', 'Sitka', 'ID', 'US', '555', '555-5555', '');
INSERT INTO `address` VALUES ('9', '13', 'Home', 'Boba Street', '', 'Sitka', 'KS', 'US', '555', '555-5555', '');
INSERT INTO `address` VALUES ('10', '14', 'Home', 'Boba Street', '', 'Sitka', 'IA', 'US', '555', '555-5555', '');

-- ----------------------------
-- Table structure for `cardtype`
-- ----------------------------

create table `cardtype` (
  `cardtypeid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  primary key (`cardtypeid`)
) engine=innodb auto_increment=6 default charset=utf8;

-- ----------------------------
-- Records of cardtype
-- ----------------------------
INSERT INTO `cardtype` VALUES ('1', 'MasterCard');
INSERT INTO `cardtype` VALUES ('2', 'Diners');
INSERT INTO `cardtype` VALUES ('3', 'American Express');
INSERT INTO `cardtype` VALUES ('4', 'Visa Platinum');
INSERT INTO `cardtype` VALUES ('5', 'Visa');

-- ----------------------------
-- Table structure for `cart`
-- ----------------------------

create table `cart` (
  `cartid` int(11) not null auto_increment,
  `session_id` varchar(32) default null,
  `productid` int(11) default null,
  `quantity` int(11) default null,
  primary key (`cartid`),
  key `fk_productid` (`productid`),
  constraint `cart_ibfk_1` foreign key (`productid`) references `products` (`productid`)
) engine=innodb auto_increment=38 default charset=utf8;

-- ----------------------------
-- Records of cart
-- ----------------------------
INSERT INTO `cart` VALUES ('1', '522cd0dec88d93e8aec744cc35b2c618', '1', '5');
INSERT INTO `cart` VALUES ('2', '522cd0dec88d93e8aec744cc35b2c618', '11', '1');
INSERT INTO `cart` VALUES ('3', '43b1ed746726df3766d17bc54030894b', '36', '4');
INSERT INTO `cart` VALUES ('4', '43b1ed746726df3766d17bc54030894b', '32', '1');
INSERT INTO `cart` VALUES ('5', 'f5c31df02a97dff7b961ff3cbcb94eb1', '2', '1');
INSERT INTO `cart` VALUES ('6', 'f5c31df02a97dff7b961ff3cbcb94eb1', '31', '1');
INSERT INTO `cart` VALUES ('7', '522cd0dec88d93e8aec744cc35b2c618', '14', '1');
INSERT INTO `cart` VALUES ('8', '522cd0dec88d93e8aec744cc35b2c618', '4', '1');
INSERT INTO `cart` VALUES ('9', 'fa4393da7b68a3ae314134ec5d86920a', '18', '1');
INSERT INTO `cart` VALUES ('10', 'fa4393da7b68a3ae314134ec5d86920a', '1', '1');
INSERT INTO `cart` VALUES ('11', 'fa4393da7b68a3ae314134ec5d86920a', '4', '1');
INSERT INTO `cart` VALUES ('12', '92a52dbc89ff749af951213481cee430', '94', '3');
INSERT INTO `cart` VALUES ('13', '92a52dbc89ff749af951213481cee430', '212', '4');
INSERT INTO `cart` VALUES ('14', 'cd2b5f960e136a3218e20d304b012899', '126', '1');
INSERT INTO `cart` VALUES ('15', 'cd2b5f960e136a3218e20d304b012899', '150', '1');
INSERT INTO `cart` VALUES ('16', 'cd2b5f960e136a3218e20d304b012899', '197', '5');
INSERT INTO `cart` VALUES ('17', '4998492885272a62d06b3d1472d775ab', '29', '1');
INSERT INTO `cart` VALUES ('18', '3f15d48a3f2695dc878b0c735531f906', '248', '1');
INSERT INTO `cart` VALUES ('19', '3f15d48a3f2695dc878b0c735531f906', '109', '3');
INSERT INTO `cart` VALUES ('20', '3f15d48a3f2695dc878b0c735531f906', '215', '1');
INSERT INTO `cart` VALUES ('21', '4998492885272a62d06b3d1472d775ab', '86', '1');
INSERT INTO `cart` VALUES ('22', '3f15d48a3f2695dc878b0c735531f906', '168', '1');
INSERT INTO `cart` VALUES ('23', '3f15d48a3f2695dc878b0c735531f906', '253', '1');
INSERT INTO `cart` VALUES ('24', '4998492885272a62d06b3d1472d775ab', '53', '1');
INSERT INTO `cart` VALUES ('27', 'd2462618e55825170acc16ceb229db32', '16', '1');
INSERT INTO `cart` VALUES ('28', '66fcb4fa0c171a11f22e586147fd8b91', '198', '1');
INSERT INTO `cart` VALUES ('29', '38f2efab03aa07cd524e422c779a969c', '33', '1');
INSERT INTO `cart` VALUES ('30', '9302752b668ce35938ddde0fbb63d602', '29', '1');
INSERT INTO `cart` VALUES ('31', '85fed06abf75ed4689d3f121ecaaaf8b', '160', '12');
INSERT INTO `cart` VALUES ('32', '496b6c94bbc8cc683c8adab73b8f91be', '210', '1');
INSERT INTO `cart` VALUES ('33', '496b6c94bbc8cc683c8adab73b8f91be', '36', '1');
INSERT INTO `cart` VALUES ('34', 'ucrckct2dpng02dl5l1a9bp4p2', '104', '1');
INSERT INTO `cart` VALUES ('35', 'ucrckct2dpng02dl5l1a9bp4p2', '171', '1');
INSERT INTO `cart` VALUES ('36', 'ucrckct2dpng02dl5l1a9bp4p2', '232', '1');
INSERT INTO `cart` VALUES ('37', 'ucrckct2dpng02dl5l1a9bp4p2', '244', '1');

-- ----------------------------
-- Table structure for `category`
-- ----------------------------

create table `category` (
  `categoryid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  `list_order` int(11) default '0',
  primary key (`categoryid`)
) engine=innodb auto_increment=8 default charset=utf8;

-- ----------------------------
-- Records of category
-- ----------------------------
INSERT INTO `category` VALUES ('1', 'TV & VIDEO', '1');
INSERT INTO `category` VALUES ('2', 'AUDIO', '2');
INSERT INTO `category` VALUES ('3', 'CAR & GPS', '3');
INSERT INTO `category` VALUES ('4', 'CAMERAS & CAMCORDES', '4');
INSERT INTO `category` VALUES ('5', 'COMPUTERS', '5');
INSERT INTO `category` VALUES ('6', 'PHONES', '6');
INSERT INTO `category` VALUES ('7', 'VIDEO GAMES', '7');

-- ----------------------------
-- Table structure for `country`
-- ----------------------------

create table `country` (
  `countrycode` char(2) not null,
  `name` varchar(255) default null,
  `tax` char(1) default null,
  `taxpercent` decimal(10,2) default null,
  primary key (`countrycode`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of country
-- ----------------------------
INSERT INTO `country` VALUES ('US', 'United States', 'Y', '0.00');

-- ----------------------------
-- Table structure for `creditcards`
-- ----------------------------

create table `creditcards` (
  `creditcardsid` int(11) not null auto_increment,
  `cardtypeid` int(11) not null default '0',
  `customersid` int(11) not null default '0',
  `expirationdate` date default null,
  `cardnumber` varchar(255) default null,
  `cardholder` varchar(255) default null,
  `securitycode` varchar(10) default null,
  `address1` varchar(255) default null,
  `address2` varchar(255) default null,
  `city` varchar(255) default null,
  `states` varchar(255) default null,
  `country` varchar(255) default null,
  `postalcode` varchar(255) default null,
  primary key (`creditcardsid`),
  key `fk_cardtypeid` (`cardtypeid`),
  key `fk_customerid` (`customersid`),
  constraint `creditcards_ibfk_1` foreign key (`cardtypeid`) references `cardtype` (`cardtypeid`),
  constraint `creditcards_ibfk_2` foreign key (`customersid`) references `customers` (`customersid`)
) engine=innodb auto_increment=5 default charset=utf8;

-- ----------------------------
-- Records of creditcards
-- ----------------------------
INSERT INTO `creditcards` VALUES ('1', '3', '1', '2014-12-01', '5555555555555555', 'Michael T W Lewis', '325', 'fifth avenue', '', 'Bronx', 'NY', 'US', '555');
INSERT INTO `creditcards` VALUES ('2', '4', '2', '2010-12-01', '1111111111111111', 'Richard G Better', '234', '201 Varick Street', '', 'New York', 'NY', 'US', '10014-4811');
INSERT INTO `creditcards` VALUES ('3', '1', '5', '1988-11-01', '0011111111111111', 'William Joseph',  '325', 'fifth avenue', '', 'Bronx', 'NY', 'US', '555');

-- ----------------------------
-- Table structure for `customers`
-- ----------------------------

create table `customers` (
  `customersid` int(11) not null auto_increment,
  `name` varchar(255) default null,
  `email` varchar(255) default null,
  `passwd` varchar(255) default null,
  primary key (`customersid`)
) engine=innodb auto_increment=18 default charset=utf8;

-- ----------------------------
-- Records of customers
-- ----------------------------
INSERT INTO `customers` VALUES ('1', 'Michael Lewis', 'michael@lewis.com', '0acf4539a14b3aa27deeb4cbdf6e989f');
INSERT INTO `customers` VALUES ('2', 'Richard Better', 'richard@better.com', '6ae199a93c381bf6d5de27491139d3f9');
INSERT INTO `customers` VALUES ('4', 'Alex Bentham', 'alex@bentham.com', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('5', 'Scott Sanders', 'scott@sanders.com', '698dc19d489c4e4db73e28a713eab07b');
INSERT INTO `customers` VALUES ('6', 'Ralf', 'ralf@fontoura.com', '3cca634013591eb51173fb6207572e37');
INSERT INTO `customers` VALUES ('7', 'Katie Mackenzie', 'katie@mackenzie.com', '8a52072cee5d17cc7bf85d6ca431fffa');
INSERT INTO `customers` VALUES ('8', 'Rambo', 'rambo@rambo.net', '59931dbc55de73dc815ac4a0170e5443');
INSERT INTO `customers` VALUES ('9', 'Peter Block', 'peter', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('10', 'July Boba', 'july', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('11', 'Pamela Lohan', 'pamela', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('12', 'Michael Bay', 'michael', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('13', 'Marcus Black', 'marcus', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('14', 'July Boba', 'boba', 'd41d8cd98f00b204e9800998ecf8427e');
INSERT INTO `customers` VALUES ('15', 'Mathew Boyle', 'mathew', 'd41d8cd98f00b204e9800998ecf8427e');

-- ----------------------------
-- Table structure for `department`
-- ----------------------------

create table `department` (
  `departmentid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  primary key (`departmentid`)
) engine=innodb auto_increment=4 default charset=utf8;

-- ----------------------------
-- Records of department
-- ----------------------------
INSERT INTO `department` VALUES ('1', 'TI Management');
INSERT INTO `department` VALUES ('2', 'HR');
INSERT INTO `department` VALUES ('3', 'Commercial');

-- ----------------------------
-- Table structure for `emailTemplates`
-- ----------------------------

create table `emailtemplates` (
  `emailtemplatesid` int(11) not null,
  `status` int(11) not null,
  `body` text,
  primary key (`emailtemplatesid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of emailTemplates
-- ----------------------------

-- ----------------------------
-- Table structure for `measure`
-- ----------------------------

create table `measure` (
  `measureid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  primary key (`measureid`)
) engine=innodb auto_increment=7 default charset=utf8;

-- ----------------------------
-- Records of measure
-- ----------------------------
INSERT INTO `measure` VALUES ('1', 'Ounce');
INSERT INTO `measure` VALUES ('2', 'Pound');
INSERT INTO `measure` VALUES ('3', 'Ton');
INSERT INTO `measure` VALUES ('4', 'Gram');
INSERT INTO `measure` VALUES ('5', 'kilogram');
INSERT INTO `measure` VALUES ('6', 'Unit.');

-- ----------------------------
-- Table structure for `orderitens`
-- ----------------------------

create table `orderitens` (
  `orderid` int(11) not null,
  `productid` int(11) not null,
  `quantity` int(11) default null,
  `unitprice` decimal(10,2) default null,
  `total` decimal(10,2) default null,
  primary key (`orderid`,`productid`),
  key `productid` (`productid`),
  constraint `orderitens_ibfk_1` foreign key (`productid`) references `products` (`productid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of orderitens
-- ----------------------------
INSERT INTO `orderitens` VALUES ('1', '98', '10', '359.00', '3590.00');
INSERT INTO `orderitens` VALUES ('1', '147', '2', '249.00', '498.00');
INSERT INTO `orderitens` VALUES ('1', '178', '1', '1799.00', '1799.00');
INSERT INTO `orderitens` VALUES ('2', '47', '5', '3149.00', '15745.00');
INSERT INTO `orderitens` VALUES ('2', '98', '2', '359.00', '718.00');
INSERT INTO `orderitens` VALUES ('2', '104', '1', '179.00', '179.00');
INSERT INTO `orderitens` VALUES ('3', '163', '2', '89.00', '178.00');
INSERT INTO `orderitens` VALUES ('4', '121', '3', '449.00', '1347.00');
INSERT INTO `orderitens` VALUES ('4', '219', '1', '379.00', '379.00');
INSERT INTO `orderitens` VALUES ('4', '232', '2', '624.00', '1248.00');
INSERT INTO `orderitens` VALUES ('4', '257', '2', '199.00', '398.00');
INSERT INTO `orderitens` VALUES ('5', '43', '1', '3149.00', '3149.00');
INSERT INTO `orderitens` VALUES ('5', '94', '1', '99.99', '99.99');
INSERT INTO `orderitens` VALUES ('5', '150', '1', '249.00', '249.00');
INSERT INTO `orderitens` VALUES ('9', '51', '1', '3149.00', '3149.00');
INSERT INTO `orderitens` VALUES ('9', '113', '1', '899.00', '899.00');
INSERT INTO `orderitens` VALUES ('10', '215', '1', '379.00', '379.00');
INSERT INTO `orderitens` VALUES ('11', '59', '1', '749.00', '749.00');
INSERT INTO `orderitens` VALUES ('11', '85', '1', '199.00', '199.00');
INSERT INTO `orderitens` VALUES ('12', '126', '1', '169.00', '169.00');
INSERT INTO `orderitens` VALUES ('13', '187', '1', '2499.00', '2499.00');
INSERT INTO `orderitens` VALUES ('14', '251', '1', '349.00', '349.00');
INSERT INTO `orderitens` VALUES ('15', '200', '1', '29.00', '29.00');
INSERT INTO `orderitens` VALUES ('16', '259', '1', '199.00', '199.00');
INSERT INTO `orderitens` VALUES ('17', '148', '1', '249.00', '249.00');
INSERT INTO `orderitens` VALUES ('17', '254', '1', '199.00', '199.00');
INSERT INTO `orderitens` VALUES ('18', '202', '1', '29.00', '29.00');
INSERT INTO `orderitens` VALUES ('19', '26', '1', '1499.00', '1499.00');
INSERT INTO `orderitens` VALUES ('19', '42', '1', '699.00', '699.00');
INSERT INTO `orderitens` VALUES ('20', '27', '1', '1499.00', '1499.00');
INSERT INTO `orderitens` VALUES ('21', '34', '1', '699.00', '699.00');
INSERT INTO `orderitens` VALUES ('21', '43', '1', '3149.00', '3149.00');

-- ----------------------------
-- Table structure for `orders`
-- ----------------------------

create table `orders` (
  `orderid` int(11) not null auto_increment,
  `customerid` int(11) not null default '0',
  `status` int(11) not null,
  `order_date` datetime default null,
  `total` decimal(10,2) default null,
  primary key (`orderid`),
  key `fk_customerid` (`customerid`),
  key `fk_status` (`status`),
  constraint `orders_ibfk_1` foreign key (`customerid`) references `customers` (`customersid`),
  constraint `orders_ibfk_2` foreign key (`status`) references `orderstatus` (`statusid`)
) engine=innodb auto_increment=22 default charset=utf8;

-- ----------------------------
-- Records of orders
-- ----------------------------
INSERT INTO `orders` VALUES ('1', '1', '1', '2010-05-06 17:27:51', '5887.00');
INSERT INTO `orders` VALUES ('2', '1', '1', '2010-05-11 14:58:18', '16642.00');
INSERT INTO `orders` VALUES ('3', '1', '4', '2010-05-17 16:29:34', '178.00');
INSERT INTO `orders` VALUES ('4', '2', '2', '2010-05-17 16:30:59', '3372.00');
INSERT INTO `orders` VALUES ('5', '4', '2', '2010-05-18 15:37:20', '3497.99');
INSERT INTO `orders` VALUES ('6', '4', '5', '2010-05-18 16:17:41', '0.00');
INSERT INTO `orders` VALUES ('7', '7', '1', '2010-05-19 09:47:40', '0.00');
INSERT INTO `orders` VALUES ('8', '7', '1', '2010-05-19 09:48:21', '0.00');
INSERT INTO `orders` VALUES ('9', '7', '1', '2010-05-19 10:01:53', '4048.00');
INSERT INTO `orders` VALUES ('10', '7', '1', '2010-05-19 11:01:44', '379.00');
INSERT INTO `orders` VALUES ('11', '8', '1', '2010-05-19 17:05:52', '948.00');
INSERT INTO `orders` VALUES ('12', '8', '1', '2010-05-19 17:06:41', '169.00');
INSERT INTO `orders` VALUES ('13', '8', '1', '2010-05-19 17:11:12', '2499.00');
INSERT INTO `orders` VALUES ('14', '1', '1', '2010-05-20 10:52:23', '349.00');
INSERT INTO `orders` VALUES ('15', '1', '1', '2010-05-20 10:55:05', '29.00');
INSERT INTO `orders` VALUES ('16', '10', '1', '2010-05-20 11:19:53', '199.00');
INSERT INTO `orders` VALUES ('17', '1', '1', '2010-05-20 11:56:37', '448.00');
INSERT INTO `orders` VALUES ('18', '1', '1', '2010-05-20 11:58:02', '29.00');
INSERT INTO `orders` VALUES ('19', '1', '1', '2010-07-07 14:41:55', '2198.00');
INSERT INTO `orders` VALUES ('20', '1', '1', '2010-07-07 14:42:13', '1499.00');
INSERT INTO `orders` VALUES ('21', '1', '1', '2010-07-07 14:42:32', '3848.00');

-- ----------------------------
-- Table structure for `orderStatus`
-- ----------------------------

create table `orderstatus` (
  `statusid` int(11) not null auto_increment,
  `description` varchar(255) default null,
  primary key (`statusid`)
) engine=innodb auto_increment=6 default charset=utf8;

-- ----------------------------
-- Records of orderStatus
-- ----------------------------
INSERT INTO `orderstatus` VALUES ('1', 'PLACED');
INSERT INTO `orderstatus` VALUES ('2', 'AUTHORIZED');
INSERT INTO `orderstatus` VALUES ('3', 'SHIPPED');
INSERT INTO `orderstatus` VALUES ('4', 'FINALIZED');
INSERT INTO `orderstatus` VALUES ('5', 'CANCELED');

-- ----------------------------
-- Table structure for `productHome`
-- ----------------------------

create table `producthome` (
  `producthomeid` int(11) not null auto_increment,
  `picture` longblob not null,
  `list_order` int(11) default null,
  `description` text,
  primary key (`producthomeid`)
) engine=innodb auto_increment=7 default charset=utf8;

-- ----------------------------
-- Records of productHome
-- ----------------------------
INSERT INTO `producthome` VALUES ('1', 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, '1', 'Good cost x performance');
INSERT INTO `producthome` VALUES ('2', 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, '2', 'APPLE iBook G4');
INSERT INTO `producthome` VALUES ('3', 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, '3', 'FreeAgent drives give you the fastest data transfer rates available and a sleek, stand-out design.');
INSERT INTO `producthome` VALUES ('4', 0xFFD8FFE000104A46494600010200006400640000FFEC00114475636B7900010004000000640000FFEE000E41646F62650064C000000001FFDB008400010101010101010101010101010101010101010101010101010101010101010101010101010101010101010202020202020202020202030303030303030303030101010101010102010102020201020203030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303FFC000110800B4030703011100021101031101FFC400CB0001000103050101000000000000000000000105060702030408090A0B01010100030101010101000000000000000001020304050607080910000005020305050506040304040A0B00010203040500061113072131611208F041512214718191A109B1C1D1E1F1153223160A42521762242618A233252792C2D24353344666479772826393B344546445B51A11000201020403050604050303050100000001021103213112044161055171B113068191A1223207F0D12314C1E1423308F15215729217628324442526FFDA000C03010002110311003F00FBF8A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140280500A0140685544D14D459538112488751439B61489A65131CE61EE02940446AA4E4D4638C9B236A29CA5824826A115211448E55133940E4390C0621CA60C4A6298A22062886E10A34E2E92C1A09A92AAC532D197BB11889B691EB1405A9D0E678A94044EDD458F8206C03F888990989C0031E538086D0C07BEC6C657F6D2BB1FEE5705DB4CFF9771C1B8DF476FB98DA97D0D62FB2B97F3EF2E190926D1F1CB4928729D049105482430082E2700C922660C40738C60001DDB71DD5C96ACCEEDD5657D4DD3BBB7DC75DDBD0B569DE6FE54BDFD9EF2D5B36E4565C1D347C728BC4D451CA421B0146CAA82264CA1FFED8E6C03FD8128770D77750D9C6C69B96FF00B6D51F7AFCFC4E1E9FBC7B8D56EE3FD44EABB9FE5E0726E5BAD1843A0D5102AEF0EA2475C9BCA835E7298FCF8087F3964F102063B0079876618E1B3D8CB729CE585BA3A737F92E3EE33DE6FA3B66A11C6E36ABC97E6F87BCBBC8722A42289980C450A5390C1B8C438018A60E02035C0D34E8F3477A69AAAC99B6470828AAC826AA6759B8262BA653018E9668185305003F804E0411001DB85570928A934D45E5CE84538B938A6B52CF957237AB132140280500A0140280500A0140280500A014031A0140280500A01402806340280500A0140280500A0140280500A0140280500A018D00A0140280500A0140280500A0140280500A02CA62EDC9F516E962772B99937B2EC174DDA196505AA0E9E4E6A4A2EDCA2DC4C2924E1D24C502A8728018E54530308810B8017AD00A0140280500A0140280500A0140280500A0140280500A0140310A0140280500A0140280500A0140280500A0140280500A028923704744BB6CD5FA8743D52663A4B8939900129C0824504A2272088886DC3970DE215D3676B76FDB73B4ABA5E2B89CD777566C5C50BAE9A960F81B171BC4BFA6E4DCA2AA6AA4AB33264552394E99CAE4C56F894E5112980736B2DA5B97EF210926A4A597763FC0C777723FB39CE2D38B8F0E787F13125BF74BD83382788B98F31B151A9CDFC188ED51B1C71CA3F7887F09BBC31DA1EEEEB656F72AB95DEDFCFB4F076BBDB9B67A73B5D9F976149977E6949278FC79801C2E63265361CC444B811021B0110C48914A0386CC42B7D8B4ACD98DAEC5F1E3F1346E2EF9F7A577B5FC387C0D2ACA3E5A3D08B51731D9B654CB2490FF0084C60C00A26DE242626128770987DC566DC6EBBC97EA3546FF001F8C092BF72569586FF4E2EA97E3E1DE6D307CE239DA2F5A29C8BA061310DBCA202025310E5FF110E511010F01ACAEDA8DD83B771562C96AECECDC5720E9246CAEBAAE565175D432AB2C7328A2871C4C7398711111ED856518C611518AA4518CA529C9CE4EB26F12F30BD9E2108CE31A1452748A2282CF4C20225448631512B72EDC0E08E002636EC36063B43CF7D3ADCB732BD73183754B9F1AFB781E87FC95C8EDA366DE134A8DF2E14F6712A5A74E4C67F28928731CEE1BA4E0E63984C63991584A6398C22226308B9DA23B76D69EAD05E54249609D3DEBF91BBA4CDF9B34DE2D57DCFF00997EC85CB131CB26D54700BBC51522256ADB055429D4394819A20209A200260C40C206C3700D7996B677EEC5CD2A5B4AB57FC3B4F52EEF2C5A928375B8DD28B1F7F615EAE53A8500A0140280500A014071F9FBB1F9EC1EC35721C073FE7DB754C3801CFB7B7C3E741C073F6F8F8775390027E3F677ECA01CF86DF1F9EDDD4CC999199C7B61ECAA52733F01F0EDB2A788199DBE5B7BA990CCF9C4FA8BFF0070BD9BD0B753339D374274FEFB549F5A0D6DF46E6BC1FEA1C75AD0A370CCC0AD723F8260CE220AF2986DFB0C5BD8B0151DB749778E1DB8C1BA2D5B377920239456074F59FF0075DC32E7224A74810455951211222BD4A2CC79CEA0814BCE2E7424C2926023898471E52808D08E6A9817CDB5FDD45A7772165146DD26BD4128D9E716F90EAEBE4681A4D68C8B61FBEBF8D4074A0AB1E3236EB55E45915501215C189DC014A530260A935F232DDB7FDCBBA4721CDFD45D34DD11A52E26135BBAC9A7F7181112E2639D52CBB0B3CE91C8401102886D1D98E35029A3215ADFDC9FD255CAF6EB8F2E8575249B8B3A6E36DD965D8A7A21211CA4BC85B10774A8DA3DEADACD1C67648D6D70A0D1C9B2C996FD25D1C07244C6B52EA8993D9FF70374A2E831FF0044BAA9272F28AA62DB3A2AAA4907798EB175D81310206DC00711C300011C0045524DF32F985FAF174433D744E5A0C62F5FCD316D41DAD3D3C526932AF108A6F780CFAB0CCDD1E327DFA8594523A0C8F146E041391A4833536E6980829905AFD683A275B24177DACD1FEA04C0815DE885FE7555CB21943F2B76316F5C6099082238903605019210FAA9748AAA2DDCA92FAB0D1BBA441C20B39D05D62022889F004D40046CE58F81CC2001B31C44280B92DFFA96F495734B32858CBAB51C8EDF3849BA4E24F4075E61A15B9951C05690B925B4E19DBB14CD0262755772E924522144C63000501DB7D32D54D38D67B1ADFD4ED25BE6D5D48D3DBA9074E2DDBCECB9B8FB8ADC97230907711249B4948C5DC3533A89988F70C9E21CC0B3478DD5416291648E428712FBE7FB7E74CC770E7EDEC1EEA8009FE7DBEFAA32C073F1EDD868398E7EDEEFCE99F70AF0199F87E1F6D0A39FEFA1073F7F6FC68390E7EDEDC37615070239FB7DF59149E7FB31EDE035084F3FEBE3423EC007F0D9F7FDFBC6808CCDFF006FB2942BF88E7EFEEFC869DE073FC7BFF4F6D00CCC38E3877F8621B3C68073F763DBBF8D0731CFDFDB6777CA9C070199BBBFB06CEFA0A0E7C3ECE3F2DB4CC0E7DBBFB6FA6013C285891E70FF00536EE1C7FF006134EB78FF00EF06A97E3405F799DBECA01CFC7B7B71A0780E7C776FA72190CCE3DB66D0A01CFC68073FCF8F1DBE3E14C6980A768CCF9F80F6F0A30B98CCC3B7B3B82838F31CFDF8878E3DFF000F68D06439F76EF97CFE14E6398E7DC1DBC71A731E24E677ECDB876EFA725982333DC1B0681B1CFC7C70F877D3901CF8ED0DC03E3F8D3C40E7E3DD419013F6EDDF506439FB6CC3D9540CCF9FB3DD8EDA0E439FF21EDB2800A9EDDE1F3A60009FE7FAD4039EA8279FE2387E9F3A7806473FD9B78D061C073EDDFF00876C2999473FE7DDDE23BFDB42789399F1F7D3C01199F3DBDB6E140C73ECED8FDD4039FBE996006677F0EDBA8073F87DDDB6509C8667CC7B7C2A14667DF87BBF1AA1F32DE35D90893C5D83975E91CB75052395CA674C8610C303956003A3C87288080898A380EEAEB5B1DCBB4AEC23AA0D570FCB3397F7DB78DC76A72D334F8FE658FA86E107210EE1B2E8B84CC0F499882A9AA5D82D0E5003266300FF0010D7A7D2232879909A69E1834D769E5F56709F973834D7CD963D863C23D729A0AB523854AD97E5159029CD92A0A6629C863A7B486314C40101C31D95EBBB707253696B593E2792AE4D45C137A1E6B87B8E381C3ECFCAB230AD409FDFC2AD0B5E239F7863DB75288711CE1FA5281139801DBB7754A13320140C3877863B77D56BDE539083D70D4CA19B2EAA07553322A191398863A46310C64C4C41037218C40C43BF0AC256E13494D2693AE3DA6519CEDB6E0DA6D530C0E5C30829311451C30348B20308EEE5F529F30F8EC0C6B5EE30DBDC6B3D0FC0D9B74DEE21CE6BC4CEAF2E783618838926FCE01865A26170A80EEC048801CC4111F1C2BE5EDECF737B1841D3B5E1E27D3DCDE6DAD7D73555D98F857E25458BF4641AA0F1103822E0B98982A5021C49CC205309404700394310E0215AAEDB959B8EDCA9A9666EB7715DB6AE46BA5E472F3376DEEED8D6B363199ECDDDDEDEEDDB71AA41CFC7E7B31A9DE3C473FBFB6C1A770A8E7E3DBDF4E3CC31CFC787778530070B338F776F75380CB3199BA808CCEEA62399399ECA0199E34A823338D07227338FB7EDD94E18863337F8EC1C3BBBE83223330F96FC78FC36D33C850FCA63EA87AD56F6A075E3D4DDC4BCD99E12635FB5ACD169E6AB24A040405F12B116B8E53041249B375A1D76E290658893984543286E750F0D2F33CEB91BFD36913277116DF88756FB691521D37AE241EA2A9E5136CE1FA31CD88EA21568EDFB92024991311E4130863BC68439F675F361358062C66272DC6B3AF01DC8396CF9EA675D2349C93F956CDCA02DDE996518FEE2521B9943E0252600528D0191FF00D41D3266A9014BA2C34DC8105721579E896AE5BA62621DBAA555CBE23944C0043018A54044C5110D9FC4501A6D755B2DE01D2EADC70116F65EE4BBE65160FA7E3D9C88A47BAA65A34F50D939116CA1FD0346C45140CB00E4261894850A0325FF005047BB6A65509F8E1362739DB85D0C9C11C0881C08521027132B932A51200017626630984040821409D314628B7F50108B9ED4076BAB73AEBC85FEFE3E41CC748F2FAA5AD988B660537726B49494299D98641A2E54DE1955924C04C098EDC045D523B0F0171DC131085988AB92F74925157ECD42389B9F60BAAF615FAF1EED920534A148E79E458AA42AC82A28993C04A0222189125392464285D41D5266262A7A97A908958A674C154AF1BA0C420B60003826659CA48A01CEB00014A61288930EF1C764526E8CD5E6CFB4BB6CBBAB52B57B5C7A7ED1CB9B53B52AE1B32FCD412475CD6B4C5EF2CAC4DC1100A02CED84BB041E9CEFA2CCD9136724729D33A60207012E35D7B6B56A575466AB1319DF9A8B753EFD7E8D10EC20BE9F7A6A8C45BEDAD68191D59EAE676D5828F4DBA114C2C89BEAFF005DE46C0242B466D99326504A58CE238EC9045221126A62143110130E8DCC610BD28C308ACBDC755A6E56D4A58B3D47CCEDEFFBEB472367766054EDF7500CCF7F60F6D00CCF60EDDF40466078F1F1EC142E6795FF0051BFAA4E9FF41A481B29ADAAF351F5A6F4B724EE280B5C1E230F6D5B50C98BD8C88B96F69958C55FF6E92B89A9D045A3329D75536CE0CA2AD801032C2269C94789E05CE7F70C75BE72CCAF056974CC4749A6F0F110E1A79A86FD322E924E8F1ECA4DD2BACEC96051FAF90889F1484079CE09F2E0501AF753FDBC6AB33D423FD777A7C23A49A21A8677A5FD8A09155DA1D3F6A926475751909335C2A47A6EA65B18F0455116E28730088154360A2A5E5388E1B5BC9DC8D5A453247EBC9A320D5E2F13743537215470D8F21A1FAAE3FCAC4F90D976A8CAB62FAA3817CDCAE04004A3BB700EF84B52A9D1EBCFEBFDD5AB6BBEE86B635A1D3BBFB35A4D386B6BBF9DD2BD586B2F211498811174F9036B5C70A6B2C20260004130E510C004368EB949A9511B5AA3A16DFF00FE80BAE3FE6F258BD2E0890826028E9AEAC14D8EDD83FF007EF854D6C943790FEE03EB8440017D3AE9900700111269EEA5F2EDC07666F50091F01C7FCA14D6C1CA2FD7FBADC11C7FD3BE99853EEC34E75384DE038893A83128EDF0EEA6B6286953EBFBD711B3F234EBA61030140C802DA6BAAE203B000F9A62750405FE2C70C3BB8D35BE4286C87D7FBAE4D9CD60F4B251E528880E9A6ADEC112808E1875023B31DDC29E63E4286E07D7FBADFC07FE03E96BFF00961AC061F8975FC4A35B22EAAA465E0DBFB857A9845A372BFD16D1070F48824578E1A32D4462D57745217D42CD99AD78C82CD1BAAA8089133AEB9885100150E21CC3416DCA7F70AF57CED712C1E8FF004F908822BF215495B5F54EE71974956ED0C1E9BD06A55B258C72D1C67144871720B14482029E020603916E7F708F568DA4FD45D1A61D38DC70A99C84344DBB6BEA9D992CE57070889E3C93B31A9F79356CE956E5509CFF00B6AD96A98A244D7E414CE07D11F451D7669575B9633FB92C76EF2D9BA6DD3344AF0B0E5DE347B2704A3D29F21741EB30226FD97A84556E7CC45B3A41748735B91255AAAE00EEC6671EDF1A0199C7B61EDDD4E00B163CFF00F797760F8D8BA77F29FD4FDDEDC680BEB338F6FCA9CC8607D51D4ABB21EF8D3DD2EB082D265765FECAEB9A4A76FB2C9BA828F8AB3D38917CD1942C43F8790B8A79F1A64874DB91E362A4DD0555398400028513B7FEA06996916A15EDA9C8594FAE0B49A4A39B7FFA34B38D21AE8C6398A76D365E3A61C3D91879399BA1D8B116C476ECA019672AA613894ACC166B1D7BBAC3A72D43D4F99818261A95A6286A145DD76AA2B3C7302CAEFB11F3F6E664558AEBD62D1B20C916CED33916C4E839298A710101102D3B9FAA99E87E9E0BA86CADA885B565BBBB86DD94B19C2CF4D171F73582C25EE0BF9650515C1F8C131B42DC7726D14CDC14457685153158A2205DA96AEEA65F778A76269C1F4E2DD9686D36B22FFB9E42FB633F36322ADF28BC51A475AB6F424F5BAE86362863CC0F1FACF15045472825922637308177C66A3DF8CF5274E34DAF18BB51193B9EC1BFEE6B89D5BABCABA648495A73F6DC6460422D21E99608E928F9DCE548E1232A9298100E20511301646AE750772E9EBCD756F190D04F4BA57A4F66DFF0E67C0FC4D2327724DDCB18ED949FA778880B2412854CC9E565A9CC73731843000037D9F50938EEC7D2B9A56062D85D770EB44268B6A45BEBA8ED54ED7B848FE5E2AE708E12384D60105E308E980AC2A0199B948C703736340CE6C36A1EB36AA8CE5C1A4E4D33B7AC18C9F9AB76DE96BF23AE9B8E4EFB5ADB92750F3334CD0B7A72D96F6CC01A6192CD9A1D41905D62A2654C9A653148215F799EAD2797539B7A356BDA3E1E2AE9CB5D399656FC83994842B845D2E81178C7AF1A3178A337AD9322E42AA91154814CB3E262888D075F2DFD46D70D5861237AE94B6D2E84B002526636CE2DFAC6EB949BBF1AC1BF5E295B87D6404CC535B3E1A52459AC0CC146926E0EDC0AB1C84E6020C05FDA77A9371DD37EEA6D9970C345C3AB6147E99AC09C7B95DF2A123795AAACDCD3270F94CB41EA3192090A282A9A28E6261CC62E23B00B16535235B663533562D0D3A8CD31711BA60D2CD7046B769AE5692D70B8BA2DC566C59252F1CF4F1B17CAAB63A245946AA109CE5318A20034065FD38D488ED47D34B5B5318B1791F1F735B8DAE108D7000BBD640AA0651CB2C520295D1D059339087294015000300063800186F4BB5135CF54E0ACFD4E850D1D4F4F2EE7CC9E85ABC9752F77C4DA8BCA15B3D517BC5B4B2F02EEEB8B60554CAB0FDA11441D26280AE5C04F4064675D40692B2BAFFA31CDDE9A73413C95AA75821AE252DD42E85CE4452B69CDE49449ECF6B7099C28097A251F91C82C3962403F9680A25CDD466974785DF01117FDAE4BEADD8CBF0462E59BCFB86711296340494DCAAF72A112C15916D071C946A8A2AA9301729A2A91A99554BCB4056A7B5D74EECA636F7F585CA992566EDB6B72834B6EDEBB2E6502214453CFB8548E8086979688B645C18C09BB7C92097944A63F310E0006C4EF515A3D6F0C483CBBFD78CDDBECEEC6016BDBF745E83FD2F22262B1B89F7F48424EFED308ECC43026E5DE4227121B03794D8017F4ADF56DC3D9121A8AE64487B4A3AD77378AB28D8A2B115B7DB451E645EB54C790EB6747939D32EC31C4400368D0184ADBBA3A96B9E220EF96F07A4D15033C11F2E869CCA7F5505E4D6DA9014DC220F2F94248D6FA5730C62A0A19AFECDE9D35C728CE3609E839990348F50E4F50A3EF97926CD8B152D6D58D49B01995803802388DB2AE67906C1EBAF50B2C6F5CE9BB603ADCA254F9C4794A50D94075F9CEBF6B230B7B55753CD6FE9CCA69CE95EA3EA15AF2D02D95B8632F9796C58574BA847D2EC249DBC796EAF2E58F43D48363A48A6E0C432653A6225A03B92ABD70E62947910541676BC79DCC5A6F8CB376AAB855B8AAC88F0C44D470820754C5050408272171C0A2218501D768AD42D60B6F54B4F6C0D4636994FA5A8CC2EB724269F46DCD1729669AD989FDD42465C67A7A64B356E3D54BE80AEC1BC7083D5912F20F3F283882E788D55B99FEBC4C693C8DA0582828FD3C5AF48D9C7526C9F3FB80C4BAD2B79270D9B473C70947451D2139808E40AECC7DE521430306458909A95ADB7DDDBAA1116739D1C8A8DB0751252C668D2E86576BBB824538D83B7668D28A962E79B37C95027C12F2A45003246A02A2F75DA7A2AD7EA29DC843451AECD1DBA5F415B70C80BB4D1B81B4EC140CB6992D219AE4CA956B81DDC49355C523900C74CC2994B881680DB8BD7B9B9BB4BA747F1F0F141766B1DD2CE06E3865BD5A8DA09BDBF0B3F27A9CE23C137445C1481756E2CDD0CE3A8053A84CC29B030501DA0CDEDDB855E006671E18FE1EEA8381199C7F5A02733C47F4A7019E46C95E37308815744C21B040AA9044071C04040044778565A269568E863AE0F8AAAE661DD406D933093B286057CD88261F159B8E49FE0965D7D0F49BBAB6EE0F38BF83C7F33C0EAB6B4EE14F84A3F1587850B179FB761AF56A7994439BB7C695141CE3E352A2887352A2839EA12839F8D5A8A21CFF009D0510E7A54510E7FCE95141CFDBB0852BDA286EA243B859240818A8B28449300EF3A86290BFF486B194D422E6FE94AA651839494566D9D93445064D906E072269374134482730170224404CA3B4403716BE364E5726E6F19375F79F61150B5050AA51492F7606F91C1142F326A1142EEE6218A62E203808621886358B528BA358992929631A346BCCA95452333D9404E650119BB37F6FD2811399C7F1F855C414FCDE3DBD9ECA806671FB3DFF003A019BDDDB10F10EEA62066F8F61A77146600F78FE5DD4C483343C787BE83C466F88FDFB29E00667E7DB7D016B5F17846D85655E17CCC984B1165DAD705D92A6286262C65B912F261F98A01888981AB3388070A64323F1AAD6BBAA2EE7BAE76E77D2B082EAEAB9EE8440C3725BF24E41DBC76B484830192B6E2E3D51272F28003F401703A6025579879461A0C6B1718A9D35219FBE76AC3C899215084566926B02B24D88D5A48336711231ECD6CD2A4449D2D90ABA3B6328250514102980BC2FE46DD4F52661EDB9715893D6C454CDAB1B0EFE26D06F070F71C7D836C5AB6CB7B863E3E6ED8B5DD449AEB6F6C8BF724711293BE676919CA443E69D6029A470DDC5E685C6B840AD1494CC1CB3C89E5B30B9ADA3968D074D9BBC5AD73474815C643A1C904484282FB71294A00073D9596D6E1996A78A4A0D28A6C95BB0E936B86F7D3D8455C92DC6F1B1844A5DEBC6B6CC4AE94911A08A8A28F1BA8E153E628B0AA3CE2076B1D74E33B73494EDD8D34F7A7A9C834A3E5A7D568FFA9CD2B879E8C8D8242E2BA66D840D87A63D43AC790688C3AEAED4DC2AF56225C8218605A031EE85C2CD9A1B5497B199AA0DAFA89978176F4CCED76AC1FC15CAB3B9993828B6F70DAD3374366ECCF20E90174D1E1E479500302C34064F80D263D9F61B18C9CB8A29D5D4EE59ACBB3460AD96CFD8271B6DCDC3493FB79E4A5BEF59C9A8FDB11AA8605108E7CA9D61513382AB141654B3319FD2521269708A088A0DEF8218898FFBB04AEBB9CA828B26E0EE0C93594736EA8982AB01845314DB18A5D9964207306C87D468334F4BCE27597553A5AE5D4ECCDB2ADBEE8B22126F9EBB82791EA2EED26AAAACA475375E982677FE9573E5B66EC24DFBA1104918974272E3D76A5A669F135DCFA19FA657D3BE2D4B7FA06E8A629C984EFD0E94BA7F5A556324281DD4D3ED2CB59FCDBD5513014C92CFA5DD2CB1C040040E71D815C971B95C72E6CF46DAA422B91DC6056B036319BF2EDC28C8337C47B07BE9DC0668F8D00CDEEF0EEA207E7C9F5A0D4C3DD5F536EA65168B28BB0B52474C2C66463BD3BB444F6FE8FD96E65916E908148C526772BF7843225E6007053A8220750C018B924E829C56679BEC6E56F94926B29B7232CF88E2025513391520F7729CAA9C0C1DE06101DE3535AE649454D5278A2E46D70313A60902A4121804A621B01298071C40C51D860DA21B766034D6B99846CDA8AA462922BE84BB257013AE51363CC0222026010E7003008EE3001C701F011F1A6B46C492C8AB369169CA40F509E006318004436184C22260F0111DA353545F02E25512906A23B5C22203B0404E50C76E2389469AA1D80A8A720D000001C2180800000285C386018E014D50EC06F15EB601D8648C1FE62992C07C768ED1F0A6A8760370F22DC004A2A220186025139376FC04007010E14D50EC06C16410DA19E880006C0039400030C3606218053543B01C63BF6FB7F9C8E23FED971C38EDABAE20E0ACFD1C04335310DFB140C366FEFEEA6B5CC94298BBE69CB89974B9F90C9881840C39661130931DB890C238886EDB592755505BD273A09B55729C00B828A644C03688A5CA4281310DE402872806EC030AA0F69FE82DA9EA40F5E4D2DD59439DB6A86886A0DA49A4441012164E1DD5B37E305945C53172926DA3EC39327214E04319C944C022041003ED7B33E3F752BEE0BE04E6FB3E3F0A02C760A07FA91758F70D91A7DF29ED4DFC680BDF343C7EFA5183AF1AF2BE97BF4A02035734CAE8BD2D87077524D2E382B2AE3BC1ADA72AD4CDDBA5EA9C596DDE5D96F3D904DCFF00BBB86C9721F2CC531C86020180EAAB1B3B536EFF00D974D2D6FF0051E1748E6B5993BEACF9FD4C81B86E07B6C58BA696CC2CD358E9E6B75386D2A485B9B55451342C7CAB849DA8C9A28A19314C47980AEDEF626AA5AF1DD5359EF0933A8E86AFE9039BE22676DAB15DC5C71B5022E3D4B2E62DA4E2E257996E5B82761118A709265501579E9D531482629C4580323EA2E843425ADAD7A891059E92BA2ECE9E6ECB69858CD9AB8768A7783FD3F082939A898A441470B5D172C5C0444689134416106825C4E2B0948F01DC53AF46FA3B20C2C983D63D25D485676DBB0AD846DFBE2DBB0B509F3C2ACB43B5338808BBA34DDAB8B82226184826A01D9BCF4E910E3CC023CE7C03C0B6AD06DA8DA7CE741753B51626FF00B8E2A12DBD5EB2E75C29132776EA0DAD6E5D375444CE9BC95E51302DE527655D256D40A2DA48E8A0AB868B0973C0C7050680A4EA8C55CFAA56E755B7F5B366DE7FB3DD3A5563D81633090B567A36E7BCDE5B92770CB4B4A455A320C1ADCA8C681E79245BE7352A8E4487394A052ED02ECD6CD3DBCA335BF4B2E1B2E064A66C9BEF56B4E2E4D43462983B789DAD75D862E23DADE0EC8D1154AC6327AD67DE99F385391222918DCC73F31C398391AED974CB4D6C577A13A9F17ACD0ADEDAB9E7D7B3AF4D2C87D4F709DED6E4A5C92D70400B2B934999BC92889845094F48FA39D2880194440D8A84380807899FBA7446F263A2F6435D403DC67BB48DA58650F773D7D21720915B825D68CFDDDDC92EE6415725885100C1638A842E05360218033C8187748AFB5741EC563A3B7ED97A8EACDD84BC9C25ACFAD3D3EBB6F387D41B78249D3BB7A4A0A6ADA887F0ECDF9E31DA293B6D20BB351BB829854E5298041E208B72FE7363EB3EB4DC57369DEAEA0CAFC8CD1F9087341696DED78B722B1B642894C473A92B4A166628AFE21EBD06EB14AB180152980047011A778C0D884D2E4F53F5875BAE6B887562DAB3EE988D21563983593BCB4E23EED8E7163A812F1936D102C4483B711E638357AD84E9AED0EA2882A043098B4076FD8328EB6A09AC4C0C5A2CE2E0A2D263110D1E9910410651CD4A8B28E66906044C844922A640DC1B29C31079FD2B1D64CCCFC0CDE8369C6AF6966B7495F56C48CFB31B2F502C4B5DAC4A97047BABDD7D4849CA48E97CB452F6EFAA1016CABA5DDB9324080A9CE18BC016CDAF61B18FB6DCE91EA9C8753DFBF217A4A8A96ADA305272D60DD692F7CB9BA61AED83B859598FA05B45B951445EBB17B2A8386AEC8B029818B41DE6646B695C0968A75A8C0B6ACCA737795D5D432F00CCB08F492B74B696B3FD1C02F0EDC1A83B9C4249730A4CCC882A558E2254C4476501602D6ECA595A82F2E1BD25F5E2D1B72F0D30D266B0735A4F0B2D368B695B3EDC5E2A62CFBB62E1AD1BB2762A49278E7D53231D045AA9EA5C144C0A10F40521C4043E97326CF3489F7537A69780D851D1F0AD1EE933BBF61F520AC1F4F4ADB90B73C712D39865133D1EEE6D66A39CB43AACDA2E5C794798D407726E5B62E6D50D0095B36E74D8C1DED7B6951E1E7116E2608B87BBE66D7049EA69F20B9506363E756306051388A25C004476D016559BAF4B37B7ADCB62E4D34D5667A9ECDAC740CCDA4CB4F6E5791A9C9332251CF6659DF29C796C15ED151CA465937A127B5B880E5E67F2E80B33487508BA70AEA8DB773587AC247D23AF9AC13CC1DC5E8EEA44DC2BD86B86F991771126D6722ADB7514BB07AD4E0A91522A2414C40D8E038D01C7D29D068CB88FA9CFF5191D403473FEA0756E79AD892F3D7244589391E6BF1FC95BD38E2D22AAC984F46BDC537489950599BB1291412A80051A03B0AEACB4212E392D462DCDAA52EBB14656542CA6D76483FB71E1BF6A7288C6C6DA2AA88C7ACA881F99A2227294AEB90D8808634075EE29C405D7AEB625DBA3F63DED6A3F70F6E37DAEB714CD8577E9EC64A410DBAF9AC75BD72A374C641B6B9EE80BA9566AB516C9BB55A15054F9A54C4C070E656BFAB94FF9B5FDCBFA3353FF0064FF004B3FD34FEA3FF4C6FAFE9AFEA6FF00503F74C7FA87F63FD9FF0064F40399FB8E77A2E5FF00CE530063BD6F8DD3DBD4B7441E9F68CDC913D4438BC5B276CDF49E91CE5B722C27232E245126A2ADAB0942230CB5A4935686700A1E4D4F54DC4896418C6CB281746A5D8F76BAEA52D34A1A0655D69FEA81B4F27F50E69BB170E60A2E5B4125EE1BBA1C936ED34CEDD92B70B85E25AB722A25F5066E6C39B907903C4DAD2EB1EEC65D495DED25EDF9665A7DA60E3516E3D3C9970C5CB7829696D7993B66EA974E11E28911A3C1B7176F2CD5549131FD28BAC3C9CFCA21C4EEEE6F1F8F6E34033430EDBB7D07119BC7D9F1FBA83BC66F87EBBF1F95071A1866F88DF45240F922E0DE479943601E523A2619E0221880668081F68ED1137857D1F4BBFE6D9F2E5F5C3C387BB2F71F39D536FE55EF362BE49F8FF3CFDE5959A22000223807763B0310EE01DD8D7A6D25DE79989199C76FC6AD0B896F35BB611EDC52B6A365DD9A6E15A347B22DD48A9641A26DDF14876C6425D7629C3BD50C538732682EAA89EE394A38D6B528B9BB69BD4B93E3CF23276E6A0A6D7CAF9AF0CCB8732B3D263896FCBDDF6EC0C94043CC4BB46127743B5D8DBEC9731C169576D889AABB76A052180CA249AA511C44360D6129C2125193A4A5973328DBB938B924DA8E7C8B8054D9BFECC2B3A1862333B6FDBB69443119814D25199FAFD94A131199C694431199DB7D5A768C7D80151010101C3010C043787B376D0C2A38AE25C51C86A92CF5CA2D500E759C2A5488038E1CC7100C4C21B8A5DE23DC158DC946DC1CE5F4A5533B7095C9AB71FA9BA1D888F6E947326CC50D846C91480386D31B68A8A1B0D80650E2261E235F1F76ECAF5D77259B7F8F71F5D66DC6CDB8DB86497E3DECE5E6EFDBDB67C6B59B09CD0C7111FCA99F78E4337676DF8D0BC866FC3D83B29E24199DB8761A788F129B9DC7B6CFBE8066F1F8FB28066F1F7ECF1A019BC68066F1A0273767DFB3C2808CEE3EFF0097CE98819BC71F8508759FAD18DBF2E0E8F7AA981D2C8B7B39A9339D3A6B4C3D870B1A8A6E6525EED93D39B919404644B65D3550712EFE4974D2689A853267707201C04A235634AD1E41E4CFC8C350A0649ADCF2F1774C6DCCC6E5B664E46D69F8ABFA2AE387BB60AE0B79D111B82DD9782BB58B3B8E05EC2CA9C515D938145568A249E29180E0A07469B7D86AA1662854B90A6591C5137F284543363153E6F214C1EAD64D4E62987C820A14C53E02510300547183E0633C23559944C5404CABC92EBBB7ABAEF1574F948F6F1A2650EF0EE1AB706A866269326A554D92502E5131C0850C6A688F61A75CBB4E635166507AA195372A0924A18C754561504E64910002193C443010D98E1BC70F16984716B0239CE9866572194895D0290544531288F267260040E444C96F3954E513A389476798476EDDB524A125F22C4C35DD3B17A36DEDF52605255BB475EA0C8141116AD8E8886618E72817D21443300C60C0A241363CA021B043184293D53FA0CE1396AF9F23D28B42C1909D6AD636061DF484D836700B3483807AD313AE6315911760948940AAA49A83FCE0051410C4404A3E60CAE4ACAC91D29C658456251BA96FA7DCFF0049D6C69F5FD79DD378117D4E63775876FC15E971434E43C24B2D6DDD77F49DB56EC65C52569352ACB3D9F7EF1CBB9A9B59D2CA730028AA8A1525396535FD264ADB7F57D274989A7F1CE11C0CD5990C0DD5114D5B3FA7274814898115668939EE2BB1D9D359E18C5F28A86F3ECDA05C36DA6DB55CCD17A14FA7033CF49B61CCFF00AE5A9D116B9D58BB95B689DE4102E21E1A5AD211192B3670215E4831D36D13242C845A9778B36C66EE2E3860700A72941DA862B471E8C55B4B523923AA7734CBE867EA7D03151D6DC1C3DBB0EDC8CE26022A3E162DAA61826D63A2D9A4C18B7206E0222D90294380579ACF5A94544557378EFA701C866E23BFB6FDB4190CEE3540CEEDEDFC2A019DC7F0A03F2EDEA8B525A6A5F5A7D525E0C9759F47DC5D47F537783270E5D9DF98F6D1756AEF696C1CABAA188350B7C5AFA74C3CA822044CBE5216B92ECDA9602A61706A990842FA95398A00530E61B11306C1111C711308856BF325C854E410874CD891730176603983EF01DBE234F325C854E726EDC104395C0F808E60FBF11C69E64B90A9BFFB93D4C710727C0031FF00AC36EDFB36F8D3CC972153584B3C1F30AE388EF1130E3B3606DE60DD4F325C854D6130FC3738D9C5410FFC6A7992E42A066A43FF00D41BDC629BE62388D3CC9721527F7C92DDEA94C3C398BFF954F325C8547EF9241B9D281FFD62FF00E553CC972151FBDBDFF139363C54C3E403853CC972150332F44BB1C9BFFBD361BFBF01A7992E42A718D2CE8E3CA2E0D8FF00981436D1D9BB6856E8C9B8D4A4A4FD4070DC1472731016E6389D430EF32000510130F947987671ACAAFB583D1CFA6C6A07FA5BF50DE942E555A2AB0FFAE50FA7C29A00528269EB33293D226AE0301012A2D92D4E1514EECA4B0DC15B638C487E8859DB7B71F7D6410CDE3E1DBDF40594C54FFBC6BA87C6CAB03FFEF752BEDC683B8BD7378F1A1798CDE3DBEFA02737F0C3F5A84233BB6EAA388CDE3EEEEDBF7ECA019BF3F8850B9B19DEDDBBBDDF685098122AF1A0233BDFDBDD403378F6FBA8066F1FD003F0A027378EEF663F8500CDE215032337B63DB6D51C46776ED8D33033B8E234033BEEDFDB6503CC66FE1FA507119BBF6D0219A18EC1C3F0A623219DDB670FB28066F6F0F67B6806771EEF1FB28398CDEC14A002AF1F861B7F0ABE2419D877FC3ECEFA8519BDBE63403378F7F8E3F3A019B87DBF77B2838939BC7F5FCE81919DC7B77D00CDEFC7BFDE141E24E6F1A02CEBA272662012599A6D4CCD5C1332AA24A9D6457DBE53882C54F91400F28F2EF0C3C31F4763B7DBEE6B1B8E5E6AC695546BDC79BBFDCEE76C94ADA8F94F8D1D53F7E4CC692572CACB24083D7043A20A02A0915BA04029CA0600381CA9E680814E21FC5B406BDBB1B3B3B796AB49A95299BFF43C5BDBDBFB88E9B8D69CF245139C3F3AEAA339AA39C3C6988ABA9E6AEAB31B91CDE5D55DBF62AD71BC7C36969BCEB08B899498907693D7372DB539702D14DCAEDC2EDCEB34CF50516E0528242242100B816BC5BEAE3BBB885AD4DE98BA26DF14DD0F6AC4A0ADD89DDD296A926DD3B1A5536E713BF2F2535D24C1A6B0D996FDCB1BA3A8DBEE97B36EE55514E3615B36B809FB4C7988FF00F6A70E599BD69D88A8A90AA14CA90404C4A4BCEB9E6CA976309285307C16382E1DB41176ADF951ADB94E2E75C576E18F6F654B54F67CA3F83D1BB96F1D2FBB6260A1B51AED697034B5C9A98AA8A5AEE2361148B9E8F857528EEEFB75A4BBD41C09794C91C4C41300908A913AD7E549C6D4EE5B92829BAD3565851D2B5553679B152B90B738B9382A574E757555A51D0F545A9D306ADC122AA9A4082209A6B8280B10809940845816115734A5D8603089B1DFB71AF755688F09BC799BFCE157126A1CE1E34C45711CF4C42633029886CA35C371C45AD0737714E3C2338AB761652E0965C71399AC4C3B455F48BBC92732AA11BB644C61E50111C30DE34AB5DC72EF77FB6E9DB4BDBDDDC9436D62D4EE4DF642117293A67824CEADE9E756CC6EEBE2CDB4AE8D3D9CD3E8ED56813DC9A3F73CA4CC44C46DEF1E444AE4CC9E04466236DDC3E98E07162A2EE0E413108A188A2A8914C549E543F3CE89F72AD752EAFB5E9BD43657B6563A8D9F3765767384E37E34AE97A2AAD5CA3AF96E526B08C9A94A2A5DC76522E63DC11DB4501270981808714D3544BCE5121B02AA45080225110C70C76D4BB6E37A1E5DC5583E74F03F50B77AE5A9F996DD26B8D13F1C0BD62AF0B8DF3B419A20CDCA8A9B0C556E62948400F3A8714144B94842ED11C3D98EC0AF3371D3F676ADBB92D518A5C1FC3147A7B7EA1BDBB715A8E9949F6AF8E1432B02A380018404D806220180638062200223800F706235E071C323DEE18939BC7B7CB0A8519BC6818CDE3DBF0A019BDD8ECEDB680A66761DFE1BF661F950119DC7DBDB75078939C03DF86EEDE23403378E3EDE3420CEEEE142E4467063863F7F7FC437D0733AEBAB3D5968668C18AD2F1BD991E69438113B7A08A33532022BAEDCE776933E66D16922B3650A73BB5502818825DA6C0A207E6EBF56EBFAE1B0BAF3D6CBE2D8BB751E22D0D789B4B5AECB096D4076E6E58642F3291D5E36B489A16553FD99A5BD7E3674944B01E52A30031E54C8A651D6003A00D7AD0EA022C864223A8ED7B8B6EA2674546D19AD9A98C1A9D139048744ED9A5D28A064944C44A6209794C41128808088513A6281892E2D5F93BBE4A4A66EF943DE52D2CF57929594BB926775CA494939390EEA49F3FB8909272EE49D9C84159750C655502179CC3CA5C32D72269450DBDEB0EDCEA2A4B76C8315445C20A91C69E582EC0E8B96EA375884052D970A916324A9813513E55535303A6721CA539728CA4E547911C55302C5247C7A8AB95CD7C69FDBC0A1445A45C94A2AC1FA2CCB8988D976C9CCA0FD110FF08899739B614A5DA015B4C68CA63C88B90B22F193162CAE56681904C925077809507D9A88394C491EFA614944C40C1CA5055AA62730605C4C25C709AD5169666328B71A1BEDA16F24D7E5269FDFE706CA20A9C508CBAD4004575C13289C51835B2DA89D72A2539C0B9BE502984E7011C21170559648D5E561999634F35D61B4A26D75EF2B72E95DE4794EA3A81535018D932E054080E4A64129AD2CBC9312AED4BB123B651400571300079832DC5E52B4D47331769D307567B47D35FD56A722ED06D2164E8AF5008DBB9C76A9BB69AC1F4BE7AEDD48311289D4861D6BFA794B5DA655D36389488A0A8E60F947103186BCCA39E0D9B2CC5C3EA2C7EBD3ADABABEA0760F4ED65CBD9DA81136DE884ADDB76FACBD6E9D3D2EA0CFDDD7E469A2DD92E04F47B4674934B58C559F0312CD28D4A36201EA8AC9BCF5ABAE044793646D4A2EA764AF45DBD2B33CE2534D9CA04303035DED170210843B9B805C72A443828622498C7478A8262E2018ABDFB4AA07F2CDB22F4BA3399AD676EFA0FD5FE997A46EA4B4FF5E3AA9D18D5CD688BB1AF1B2A5EDD46CAD5F67684041121A58D229BD9ED3D7361B9B9759E7A2AE44E35FC6C092E4B7E1DEBB6A0D9F15666B2C91F779D862CC55A5196A6B23F48BD28FA967447AD5A936DE8D69FF50168C86AEDDCFA6632DCD3392466A02F29690B76D8797A4D3565113316C4EE4EC2D68F70F4C6218C99D06EA99331F2CF84D517DE6F4D3CB33BCB9DC47EDEDBEA948CDFC71C47761EFA019DC7B77E3F0A6606771F67E14059DA8B7D4669BE9F5F7A893423FB3D8366DCF7A4B080E03FB6DAD08FA71F0E3DDFEEAC0D4AF1C81F93EE9283D7D1970DD534B9D695776ABA5DEB97A739882BBD5D23BD72A3970A2AAA893A7189D5158E6E750444C261C46B8269CA4DAC502FB5584E604315251405B054AA2666CB94E5570508720B730A424314D89701DC218EDAC74CBB1839ADE0AE55F94BE95C880FF8B284A3B47C0B80534CBB182A25B3EE711F2904A3BFF9A450443663B700C37D34CBB18395FD0F781CA0244414DE3894A6028E1B3600EEC3756E84569C5625360F655EC906D8D39803FC64288E3DFF00C1C2B2D31EC40E02B6EDDE9079E2DD0807F95B1B11DC3BC036D34C7B1029CA45DC49888A916F03C43D1AC27DDDF814429A63D881C63A52A9062A47B92861FC2AA464B0EFDA3902A863C47E55A6717AB05810E30BA705DA666A143FD9050E1FF8476FCDF1EFAC74CBB18368F2664C3014964CA1FE2131C03FFC0C0071A699763071BF7A20ECF507C4310E513E001EC3191C69A65D8C1A026713639E387802A9183BB708A422357E7595462149ACB22C7E711E44955733013153E544E21CFE52A3CDCC4010F0C03BC29F3F3189996E7D4C91D1BD4EB5F515A94C0EAC97BA43AE30C2072B339DEE9BDEB0D3CA2293A2188083B1756BB650AA0081884388E215D169BA2D45E07EA644729AA991549429D350A551350860311421C00C4390C5110314E5101010D835D04A9B99DC7B6DFC283916631570D42BA07FF732C40DFE139A8DF8D0179E76DDA3DBD9E034033B8F6E3BE838119B8F6F86CE351D10F119DC6AF8932C09CEF0F6FDB4EF2E3C467710E3DB8850506771EDDDB683BC0ADC7E7F1F9D1019DB03B6CC7DF4C80CEE3876D941871CC8CEFC30F6FB0680905BB61C31A6208CEFC76F6F0A0273BBF1EC1B7E14E010CEFBF1F0FCA99019BDBD9DFDDE38D39819A1E23F1DF4033BC47B6DE140C677CC7E7F7E34C40CEE3B3C68519DC7B711C684F119DDDDDDBBA83C46771F0EFF0067E34033B8F0EDF1A04337F1EDEDA07F119D8F1EDC31A019BC7B6DDDF1A0233B8F877F7F0A661939DC7F5FBE806776F885388EFC88CEE3E1D83DF40337B6CF1A0E7C467800088880000088888EC000DE2223B836539223A67C0B6A5EE4802B75DA3B5C8ECAA9048A376A19E6300F8285104487208621898040402BBB6DB3DE39AB96D38B4EB5787C33F81C3B9DDECE3176AE49493592C7F91860E72739F284D95CE6CBE7C00E24E611289C0A225E6E5DF86CC6BE9D39516AFAA98F79F34F4D5E9AE9E7D868E7FBEAD58C073F6FB77FB295255168DB16359965AD2EE6D5B722A09CCF3BF5D32E18362A6E245CF32A703BA5879955089A8BA862931E4218E61000130E3AE16ADDBABB7149B78D389B2E5E9DD495C6DA4B0E45DDCFF3AD9535D50E7EDF0A54B5439E9526039E95180E7A54551D26D61EBE344349A5DE5B482D2F7F5C6C0EAB7906768A6C968C8C78909C8A337F36F9E3567EA12509CAA15B03A32461129C00C0250C5CD2C0FC97D51F79BD21E9ADD4B6107777BBF836A51B2A2E1092AFCB2B92928D53C1A86B69E0E8D345E3A0FD62691EBF3D340DBEEA4ADDBBC89ACBA76A5D08B5692120DDBA67597710AE19BB78C6548DD04C54513228570990A6399202144D554D3C8F53D1BF747D2FEB4BAF67B295CB1D5126FC9BC946524955BB6E2E519D162D27A92AB71A2A9E776BAD9FA95691F53AF2BBECD944AFFB635265AE886D7290B9114ACFBB34D2E0E58F8ED335A21D3A53F7A178DCC568942B5440A922AA845012441515B5BAFB4FC3FD61D2BAFF004C7D43AAF53DA5C5D6B6FBF9DE875095D4AC5EDADCF963B5706FE7D4BE456211A28B929698EA72ECB41F48AED9DF7A347B698DC313605893B6D6AA0CEDE7A80F2E4938074DD57B26AE91D8F680346495B910B4C289AD2AE56154CECB9439C75123A66B4C56743EFB67F6CAE5AEB1D29F4F85FB7D17677AD6F3CCBFB995D9DB69CA6F65B7B1A62AD41CDA95E94AAE6B4BD4E51717E91F3F1F9FB02B6559FBC5517EDA73509169A80E8CB22F5730828E4E909D104CA3FCB45332627394A23B4D894004778EC0AF23A8EDF77B89270A3B4B8571EF753D6E9DB8DA584D4EAAEBE2D614ECC3E264C6EF9B3B4F31B3849C27B3CC8A85503C431E511028F01DB5E14EDDCB72D334D3E67B90B96EE2D5069AE46FE7878FC78563CCCC6771FB299E00677BFF000A0F019C1F2F75053DC52B3B8D0548CFE3BBB0D112833F0EFF007ECA149CEE3419771D32EA6BADFD2FE9E236F4836AEA2EFDD6F81B3646E6B67449ADCF0D6DDC176C8FEC927256CC29A66714460EDC25CEFD811A24EDF2A93740CB155544A881940C5C92EF189F351AA7F5A2EA3F549490617AF4D3D716955BEE84487B46C5E9DEF891856E822E9370DC0F795AF1CEDDDC62E330515561912B17056BCE46E9956202BADCE45A1D4A9FEB7747E6D3944AF3B27AC5B6FF0073CF34B2EFF42756ECD9050CEF9BD41D4BC22DC43DC118758EA8889D17691CE630971F30E2D72079FBA9F697D18B50A06EF8B772CDB42B50AEC6CE546FA90F67F52A3AF483B94EB1DEA371CBC0EA05F53515771D47A6107E93C6AA2EEDB2AA91259BAE64DCA2D520780CFF0046B537F71904A024F4D6E48B6EF9DA51F2B1DAD5A2E9A528C9158C820F508E3EA1B991680E52211614D5CC51B1961454C4D81CA73A2AB78036D1D16D775174506D643B94CE5534F9A0656DABA00DCE729714FF00A767A49457940D88F2266C0368E000221845DD9E29AA10E67FA19D4C90C712E806B4BB4503AA999D46696DF128CD5021F0CC32D1F0CA27C862ECD8A01471DB8EE1DF4B905AA422B1C71455ED7D3ED744A6A2EDD93D37D57B45ACCCA346479195D1ABF6619C515C38224A3E5A092B4A524D66CD88226508C515DC8100453456380247E98494A3DACB2547C8EFA447D3DB52CEF5D8DDFAD1A08C6300B8A0BC5598E2E47CF143AA5176D17633695A40C0ACCD984266B839C5104C87299739C0BA15D9AB94352AB746678D57E95B52F562C7D13B346FDE975935D06B69C5AB6C4C4268EC359F2B72B45D9C12057F38F6DF9E4DD494D833842282750E63662E610314C2260DB2B8E4A9258196945A169745BAD5A673B653FB42E7E9EEF7888E94B46E8B8DADF5037246B07573463B609DC50858919FBCE22F5B40D171E8A6CDECB20D957BFCC33868C793314D7A2DCDD1A238E1866774AF8D33B6752B5266F53E4EC4D24B3EE5BA8D16CBF6FD1BD31B274B2C98D3B58C656EB58B8AB5AD34918D4969670B19774BAABAAF9DAAE964C982454D22E99251A68543071BAD52A6993D1556D176C2DE736AC9C6CCCAA6672CA3A5A35C433855814FCABCB1D19E3B4518C38AE00655DB8149AA6914575542913150BD50A4A3A5E463A255AC9E08EAC6AF5D569696BC5EDC7446576DDEE8873C6DA96C2ED1EACF1810C02BCFBD9C75CF1B0F00D4E514C1C015605CC1CC802A41E7AD538C75608CAAD6475CEC39D4ACF20752DAA926C242F22359C43A77D308C6A2B94F26A37928F79AB8C62A4C1C368BD3BB372D48F60FE40AA3E9A9F54EA31104E29D9C344B095381926E4E8F23D07FA0B4DCA5DFF59FE8F2E3B85CFEEF2ABBDEA0DF28E1438A8568BB8E94B5C0EE172B8762770F1E2ABBA1298C061314A6C310214002C3EA36694B23F4D4CEC370FBFB7756EE6C778CEE3EDDF404670EEC766EDFEEFBA98540CEEDB29883CF6FAB1EA835D25FA6A75BD78BA76A31329D38EA55991AF11301166B3DA9B04BE9A5B6E123080E0A23705DCD4C5E201525903F3B5D17B3DA5F360EA4DB7FCE6ECD5B4EDFB5241E148050FDCE5E31DC8C8A0550819829B228A5CC5DC060F65698DB7A70C8A79BFAC5A6DAFDA07080EDCEA2DD2C2D36B2C486883C05E57145A099E48B2120D5049B337E8A688913686010280626C47BEB2D0C54EBB135AF5A53D84D65D5D0C04DFC1AA17BA601B471002966400B80ECA6862A7249AE3AE03FFC69D63FFE67EA11837F71939F29469A25C8036B9EB710C1C9AD3ABC510C39B1D54D412A81E1FCB19C309767C6B3514963990DE2EBD6B806D26B8EB0FB4354B50C071EFDD361B86AD1760358EBE6BB0FFF001CB5887DBAADA898FC0672945D80D3FEBFEBB17CA1AE3AC380786A7EA01F7EDFE219BC46945D80DD4BA82D7A0E6C35CB57C0003609B53EF20DFC1696329BFC47E58560E0DBC3229AC3A87D7B0E6FFBF4D585443B94D419F705DDFE75A48C737BF76EA9A18A9B07EA235E8E0206D65D46539476E65DB24E8476E3E64D678720F75343153B03A58DBABCD5AB5D4B9ECFD429F938D4A5E4E017524662233537EC1A43BEE53A2ED35554CC64A6498623B4B80EE10A6862A64C4B49BADDE6E63DEA2998D81C48691B539439800D8606817386C37F9CDEEDD4D0F90A9902CEE9E7AB4BCDFB687BDB50D36569B878CD49B51AB880F5EA3366BE7A8D9AB98CB79174433D2FF28E05379C9E51D94D0F90A9DAFEAD6D016705689DBA6A0A05B6E46254000CC54E46C56C044942A88A0062289B9F3944800221B71DE3147E6D2C1FA43F42FA82A6A87453D236A2AF20A49BCBD3A68D0EB8E49FACAA8AB8712F2BA696D3A9833B5151154CF0928758AB73F9C150301B680D6E21DA9CEEEC7E7B03BF750702CE62B7FC7D728F8D9F637CA6750B67FD2A14BC33B8E1BBE54C2843AB9AF73844350B44602575066B4FAD39F575186E19088BB8D6695C9E26DD8E770C93B96CE4120291F9B0214C3E613894368D33058967EBDBFB5827EDA69321AB0C1F6A0C8DBFA3D755C972C4DBCD2E18189B66266AEF75357C28D15652307664DBF347924506CEDC3E50E9908558D88940BC47AA404A2DA80D82EE56EF0D528CD2A91B52D6BA6127D1FDD66AD192BC21A5606E43A71B17311522C99108067011E289CE7CECACA3008732AA9EBAEA149DC9256640690B073775AF0D0F2F78C0CC6A84243B86233CA3E563995BAB21053085CAA8C6342ACA2E6164D12515044CB7394C200726475E6E711BBA46D8D2D77715B3A6E7519DFF0024ADD91D152ED2623E259CD5C70D6941FED92085D4F2DB62F4A55CCA3D8F496705324819510C680D5FEBC5C3714FCEC169769C96F92C35A3635EA84C3FBCD95A91521117DC749C944B74C578796904A51CA11C22DC80DCEDD4F3E72CDB9499A07217D739994B12C7D42B2AD0807F6EDDD02138F5FDF5A8D1DA76D604C292672C49D75A0EE03C8C80280B144C54D36C00809B370305016559DAB3FEA86AA68A5D10EA49C640DCBA57ABCBBDB7D59105DA1266DCBCAD2B7DD677A35CD1B2631EFDABA4DB3A28081D13F393941410A50192751AE2998ED5AE9E225849BD671770DCDA82DA7983770A24D659BC7E985CB26C507E894408E536922D935D3036205548060DA14E20B5751752656C6D5E93903AF20FEDAB63A63D4DD43776BA4F8CD9949CADAB73DACB20B894C45904A40CC0CB374D714CE2991636C10C4043915BB735B6E279705871B7869C9ECD87D5068E8F654C7F56319F746936B06A5C7FB2DC91ACA2DAB48376FA19B2CAB5322F5E915324299B914102D01C3D7FBF3502CE7FA309589184920B93551A41CDA269861145956E6B6AE278D6D95547B1B2190DA58ED4EE4CEC9CA66E6605260605BCA189C87BAD17B38939D87B434AC2E77F62C642AFA8899EF665124899E97846F7029695A8A8C1C82777CCC7C738209CC718D6A265532E6818C604C389982CEBC61EFAB56DEBC6DF5945A16E58865331CA2E9822B8367C8156224E51E63822E501309152623C8A144311C31A030D591337A97A82D53B72E4BB0D3D0CCAC5B0A660231BC7043C6C2252D377B24A2246647AF81DC819362405DE1CC0A2FCA50E5210842142A639D53B3A4E2AE0B06C9B1F54B57C97B5FD73957151D6A1CD3F8EB7ACAB7944A56F39F711A2A26828924C85362D5250C5228E9E26501D8214076375575113D2FB02E0BED689713A4814E3CE312D5CA2CDC3D17F2CC22889A0E572288A6A14EF80C1CC1CA6E5C310C710031CB8D74B82DD929889D40D3AFE947A5B02EDD41B4C8D6EE6970A571B2B29BB5713B04F1C378864842DC2CD27E81CE9A467EDB2D4131573F2E0341A2DAD77B8641FE9B2B7669BA9685ABAB0541BD9F3E377319C78498796FB9B96362EE1876514DD0891988E62B0B43A4F1D18C72015522261102C63C0B3617AA1BB2560B4E2EB368B48256DEAA3E25BD682A8DF502E2657BA1CB1957F1CDA4231562C99B0807C94338107C6782E132A622768022429DDC0CD3A69A97217ABABD20AE2B64B68DDD604EB384B8219B4D96E48D31652123EE187918C9C2C64319E357F192443094ED505523944A62EE11032AE76EFCE808CEC3BE838139DC7DF40B1233B8ECA019DC7EFA019DC7B614E609CEF76DEFDBF3DD41E2467F1A0273BEEED8500CEC3BFB63C3D9501B6A1935933A4A90AA2672890E438018872183012980760808566A4E32D517492319454A2E32558B4629B8ADC523C4EF18F328C44798E98889946B8F8F79D0F036F0EFF0011FA2D8F508DEA5ABD85EEDE0FF9FE391F3FBDE9F2B15BB671B5C7B63FCBF0CB3F307757A75479741983E34AA03307C7E7DBC69543119834AA20CC1DDECF7D4AA281507C7B7855AA03307C69540B3A6F526C0B6A45287B8EFBB36025D7E4C88B9BB9E122A456CC4C564F298BE7C83A539D220983028E250110D8152A8F2B77D77A1F4FDC2DAEFF0079B4B1BA7942E5EB7093AAAE1194937863964615EB02FC9DB13A70D46B9AD574BB6953C7C444339560A18AAC737B96762A09D48B77489CAA37588C648E082C98F3A6B9D331440400424A548E199F25F747AC6F3A37A0B7FD43A74A51DCBB708467178C55DB90B6E49AC53D337A64B152716BB4F3ABE9E7A57A27A9F17A98D6FF00B6A1EEBBB18AD16468C264CA9FD15B2F1BAE9A8FA29B9154448E4D244122CE53C5543F920532799E7C20A38D4FC2FEC77A6FD25EA2DBF50B7D6F6F6B73D4A0E1A6372BF2DA9269CA0AAA8F5AA4A6BE68FCB471D58F5ABA8BD3957A5FD7F334D3FB88524E3158ABD6CD74D9F26E666DB2395D45DA454B944CA284771EE1B18080B81BD532324A1C0734C5AC65F2CB03E07D77D065F6EFD6BE5744BF48DB70BF61A9273B556DC613CFE68B4E9ABEBB6E327F5347B83A652760F523A7BA4FAB9705AB0131311ED94948C07ED13900B5AEC4942475C258E2B9038A666F2D158A273979C0124550C0C04306D4D3553FAF3D3D7FA2FAF7A1F4CF53EFB6D62EEEA11D70D5152F26F27A6EE9AD729C3E56D5708C962933B09983DFECEDEEACAA8FB719834A97C4A846B0772AE01BB52F80A8A9B624893773A86001D9E001B4477569BFB9B5B7B7AEE7B17166EDBEDEEEE2E68B7ED7C1198E22359C337C96E1CCA980A2BB838066AC70F663C89808F94A1B031F1C447E5F73BABBBA9EA9E11E0B82FC7E303EA36DB5B7B585218B79BE2CAB67F1EC1DE35CCB91BC9CFF00978D0A056A20467EC1F75098D0A4E7F1F97EB428CEEEC7E7B28398CEF0EDF88D06033B8ECF6501F0EFFDC5F10838EAF4EE5D356EE417D2CB0DCA20E5149C14A5454976E02522C07217059BE3BB7D6A9453B8AA0F9B262E646371347494A460872081E3649F479C048260298A766BA2629F94C20238E260D83886CACF44417AB2D52D588D02844EAAEA84798980A6565A897834297976EC2A3324206001E158CA292AA29767FCC57528AC5494438EA135B5C42CA3077152D0B23AA97B48C5C8C5C8375193E62E98BA9C5D151ABA68B9C87261818A380ECAD60EA83CD22B25C6C2DAD0E989D715731BA32098E2B0F2A87CB62F5A1855579BCC7E6C76E26E600101C669B8D08DD154A540F4D724F5417721A511068A32AA1D0CBBD992CE1FB322A009BA141EE57A13806022539C4700D9E6C2BB2D4636A1A9E08CE0AAE8B32E93F4EF66A2E90422F495F22E4A6C0556B7CB0447CE3CDC89AEA4D91AA627386188E0238E01BF0AF2373D4E0EE792B89D9E4A51C7332669FE9F495957442CC398ED604E0E3E41BCBBCB15D6B15D10B6EDC4DD9A80435ACEA7EC29587948760FCD8662CD645B3B14F12914C4DCA3DFB5BDA9519AA76F0FFD2771875AAD68A64278FD32D6D8E5506B9C2162FD427ABB8213B121945163B27739755E8822C563010A08729CC651B139BFCC1B2516FB8E7716BB8A0B0EA8B4F95290562F5C50AA289898821D645A3A864210C20514976BABFD38DDA63077018CB14E21800984300AC7CBE64A975B3EA1B4ADC1C56777C756ED55394A5C5D58BF4F6D42C085103826A8CF74DB00A3F208970301CC5E601DBCC1E51D96E349215A626936B1E993950403A82D7E87CFC53E5B93A0FE882E2214541E5051C3AB3AE4D3C72EB283601CB96729044A03C86310DA66B1AF68F362CB4E2354345E41CDD91EEFA93D4F904AE472D5C292111F4F8D0887B8E199C2289A8A35B12EC97D7BBCDBD96E5E2CD400EB7ED6BA25218C396022072F4D954543194D495118075CAF3E927F624ECCD0DD2DD6E89BA6664238D736A36AC5F1654B4ADF8ED8B751595B8E763C91D393CE3F760322749B44C946453450E0246A0421886C67F5334B3AA13CAB876ECCF5F3959EC8BC4401DBA59539C4C83345160C9AA0989B25A3364C1B22DD245129124D04124CA50224994BCB38FF004994733D77FEDF4300FD5EBA361379812475F552F36DE4556E97B59C8A1898E3CBCE51C300C030ACE1F51B99FA6A6771ADC067E3DFF8D0833BF3A0433B8FB3DDC29C01E0FF00F7215FADEDBFA5AEA359AA2B94EB59B56342B4E989F10C046275221F57A590380860649CDB7A58F9239440404871AC25F494F905E8A218C6D29B9E795218C69FBF645631CC1CC711690ED63D520987698A0A2072E1E0235A949D3078030DF5F363BEBBAC3B46DA856645DFC95FFF00BE2E9889BCCD60ADC956A26390A0202047738DC03C04C1DF56AFB583CB9374D57D90471892AA05318A0A7273E614A61214E2631444C2700C444778D6D8FD2438E5E9CAF9CCE52C190C61531373A241014CA544A3CB897000015C31E3590396C3442F4F4E246316521517D22D05506281D531E2A45D463A03AFC82A1FFDE9A1C3688F8566A8D695F502B24D0CBFC703033136380E02C12100F77277D456659D5D08D37DA7313D0ABF84004D1BCD8E3B98A203DFDDC9B2B09C945D313356E4E3C4853422FCC444B127C38B14BB837FF063BEB4D652C554D52B727C5D0A7BAD28BD2DD6AF24642DE564D9229B747D2B68D8E55D8B894788C6364504CEC24563383BC708F27F2B10CCD9BEB6C6BA71CCC926951E65050D0EBEEFA74FE6E2EC8978D6857DE8D2672510DE24390ECD2324E32928C870326907F10FA72626011F308F30E452AA874A5A8A6294810641C0A5050E250129C403CDC98976863407ABBF4F6D3592B334E3512D29C6056CF59EA68DC09A071317998DC1645AD1A45397F8704DE5BAA18BE06DA1B680EF538B51A14CA00B648084C0A512817037280063888623B43BEB2851CA82B4C4DE8D8A4DB904A9B5207F300C20099300314C3CA6C700F3806E1A5E6A0AB90AEAC3C0C19D57C4A4AD8D6DAEE40D8293B250C9A9DC43CBC0C83C4C54361FF582E224C051DE0A2841DF8572C2E294AA61252513EC03FB7EF5113BEFE947D3590CF41D49590EF5734FA513F542E8CC3FA7358AFBFE9E6589B016E816CB7B18AA08E00545B2A9909E402D754A95C322AC51ECE67F1FC7F2AC7999712D264B617DDC83E3695941F099BFFC3DB4E7C4176E7F1FB387B699640C417DE9EAB796A1694DCCE51837D6FD8E37C9A6A3661333959E9AE4826B1B182C19A8C5D327066CEDBF3A99CA23C85C049CC6D801CCB7F5834B5CDDAFF4F6E8B6E16CA9C91D39527D042CBBD99942D49F81B9583169271D9E945CB84349B45A21AACC9C15A2A44CE9090E504CE61A02DF26975D52C4B01D9ED0D2AD391B5B58E1AFE790565B876B24B5BD1768DCD0674DD49A16AC1212D719E4274A242FA46CDC8DCA219A260C0C07075C34AEE8D4B92966E969CE91DC09BC8908EB53502666E72DEBE6C47076852A8F543465B526E2608C249551D3249BBE685E6F2A801B4C67006C33D30D5CB261AF8B1ACC7D6A5C705A8CA3A907379DDB312AC6E2B52726EDE8D82BA64DC4236849642F02BF72C4D20D4A67AC8C470B19254728A530931CCBFF004B34A9D69ADD574BC41EB4736D3DB0B476C9B7480AB83CB913D3387B8E21CAF2C91DAA6D5207494A20290A6B2C27129F9C09817980C236E74FD7C5A29E962AE6034C752D7B434C0BA7EEA22EC96934206D89C25C4F2646F4B6C5C5A135FB91DEB57656CE48668C9D091B2409AC0531F002F5D22D12BBAC294D307F35216AAE5B32DBD6488974E0D4934D255DEA26A3B7BC61CD0ED5DC7240462D239214D72AAA94E8AB81099C5FE65077993F552CEB8EE379615DD65B98825E1A6F71BD9C8B63702AE9B41CDB098B7E52DB9C8678F19347EEA396771F262645D1105F25420629881844A0614D48B56FA93B675C7557501ADB96FBB43A71D48B0ADCB52DA9A7F7291A47BE8D7F3D332B313CFA0ADC070F5EBB8B6A445145A8268A29888984E635017358F6CEA1DE4EB46E76F68FB4E02D9D34884E6A11BDBF7049DC32575CDC8DA27B7631F3F4DEDB9009DBAC23A2655C2A640AABC3A8E8C50E7CB262603216B1DA972DD6CAC493B45388773BA7FA8D077E36899C9073111F368C745CF42BC8B3CB348E975A31655A4F9D4496F4CB14144C00C5C047002CC4ED9D64B5676F29EB2636C274AEAA25053738D26AE799688D817D35B6A3ADD947B1AE11B52414BDADE5091C8AA44D4245AC2748DE52154C08065CD34B39AE9AD8168D88C9E28FD0B5A098C403F54994A3D59BA41EA9E8A3CEB037076E8C75013E73026060281870C680C5F6EDAFABACB5B6E5BFE523B4E496B5CB09076AAA461765CCE6E069156C3EB99F464926C1C58ECE397909034E90ABB71764490021848AA9B3102F0B52CA976BA917F6A55D6E635DC9CCA51F6A596DA39674E13B7B4FA240AF41AAAABA68C85397B8AE070B3C7C4215548B968108A9C098D01697558AAA6D02BFC10E415B2EDACA0544C098A81785BFC80A09404C09F300736002386EA02CFBF6D8BFEE4657A6A16A2C7DAD6F2765E8D6AA5BB6A405B13F23738BB7D75C32279FB8A4655FDBB6C0B640CCA01BA2D5A15058439D439D401028081A34E2D9D43BE213409CDE11F69C1597A6D0F6CDDF14683B824E7666ED9A4AC6560ADB55DB4776E41A16D348D6338BAEE532B97C655C01085114C04F40552DED17BAA274E3A72B39C485BE792D20BDE0EE5B91745DC9198BD63190378C5AE941AAA4526E1CBB3B8B851310AE126C41214E22601028181994ACDB3A56DDD41D61BB1EB98F563B50A6ED0928745AAAE4EF5B210163425B2F09289AAD104115547F1AA1D2049458051128984A61128077994F3F8E3DFB7C7D9BA990E633BBF1FC7B6DA72033BBF1F6F1A019FB31C7E7DBBE9C40CF0EDDDF2A019E1E3F0A72033FBB1EDBBECA019FC78FCE8067F7E3F0A21C867F1DC1DBBE85E2715EBF51AB655645B2AED421712A088940E6E2388E38077F2818DC06B65AB71B9714252515DAFF001E345CCD57A72B7073845CDAE0BF1F9F718825AE191933988E141491298706898188994407FF003851F3287010DE6C701DC015F51B6D9D8DBAADBC65DB9BF6767B0F99DCEEF71B86E33C21FED597F3F6945CE1F9575511C94633B8FCE944283387C47B70DF4A214633BB7B70A510A3CC66F1EDF75288947C48CE1EDE34D28B467417AF2EA2EE3D1FB4602D2B15F291376DFA1282ACEB61007D016F46FA549DAB1C7307FBB49CAAEF41245C1713A0449539048A824A1709E0A88FC4BEF4FAE77FE94E9763A5F479BB5D537BAEB717D56ED434A938F64E6E5A632CE2949AA4B4C974A23FA0BBD6F3D158ED5F8ABE51B82F6B96053BD52B41560A2E7946724D824D2644B94D28BA8E2E574DCFCC2555B9486727C939C82515071D0DC6BC4FC92C7D94EB1D5BD236FD53B6DE2BFD5F71616E158716F5C66B5A8F9BADB775A75A38A5ADE86D51C8A6F48FACC590348F4C1AB2F1E48E996A7B55ED58623E5D517567DC8F84C9C7378B51705859369291121534B9048DE472552810056E745E3A5E4737DB0F55ABF29FDBBF534A573D3FD462ECDBD4DD6C5D9610506EBA54E54495291BBA24A8B5D78D25D12F551A6B7B08E9B11DC89015728445F566DE0C6D55C582C262883EF5535112D10B1DB72E7A402A222611226AAD862334493C0C771F67FEE4FA7FABFF00FCFA95C8D5A86E2C5F8D97A5FF00BB55C84E0E9F52C635C23291C8D78E9B63B42F42D19DD48B89B5C7ADD7D5F912BB755BBF76F05844328B985669AA6E5E091D4B828ABC48EFDD9D3027A8F4C426C0E756CA3A638E665EB4FB7F63D19E8D8EF3AFDF8DFF0057EF77B069A94A5A61184DDC49CA929E328BB936A9ABCB4BB65E80FD3CA3A522FA708D5A448AA684CDD9734B43955E60E68B159AC76626536D2A4AC847383170D8601E60DF8D6505F2E27EDDF62F6BBADBFA0ADDCBE9A85DDCDE9DBAFF00B2B18D572728C9FC4EF1E7567447EC7464E6F1A50519BED9FB868A9566AB9D054BB8C99B01DBBCA6FF00098A386D01C407BEB09DAB7723A6E2AC4CEDCEE5A96BB6DA9194EDDB85F4A104AE999C00803FEFC98011050407F84C53880E66CFF0730788057CEEFB69676CEB6E6AAFFA5E7FE9DF4F69F45B1DDDEDC46976197F52C9FE3957D85D39FDBDA3C3BEBCE3D019FC7861F1F1A019FC682833F8FCFEFF000A07F128F9FC78FDFEEC28067EDD83F9FB78500CFE3D87C77D00CFE3D877F7E3407C627F7173302753F6B3812FFEBDA1D692E2388FF86EABF1B008F77FF90C3DDEDAD537495514F98F2201CA5100F3080EDDA38F9BC0766C0A464DBA306F8A0514C404BE6D9B70E21DDBAB6355C190D60520170F28E0536E201443128E3E60001F9D4D1105C16C44A5253A911648ABA0C5359D0B750D826E4C82E87A348C26E62E19E250DD88E3E38534C162D601AAAA1D928ED35BE2EAB7549BB5A25391624973C0A8E1471191E8B65928C6528B2BC92120CCA568BA2F93298C9F20131372E0215C5D4F713B56BF4DD2276F4E8DBB97293C4A64F68E6ADDAC87A71B1D75A49658ED138F19D847D96268D69261FCB8F99021976E497649280738F2AAE09CBB6BCEE99B5DB6EAEAB97956E1B3A8CDDA9E9B784598E27A76EBB49F9A32E5B651817A09C39818BD74564FD5F50E16411532117CB2A63BAFDBDE140C9080945B94DB31111FA986D6CC1522A8798EF5C783645B47B9F51AE7B12C7B72DD6133746A45C56CDA16EC37AF418AD293B754EA167433260EE55D358962BCDCD1DC722AE1445BA64C83A8A2643A87ADCADC53F95559CDB9BF72169C93A33D0099FA04FD55E296322CFA7EB36E15D458AD8836C750FA1C810EF04ECDA2CD902DCB7FC02EB095EBF2619D92601C482980A7CCA61085CD6D4A1F2F79AE3BEB1E5A7297CFDC58F2FF0044FF00AB0DB86FF7FE893515D267287296DFD47E9E6F4500FE72F2896D2D62B83CA732620413E59B984367752F6CEFEA5714942CFC7DD9FE46FB5BED9EE62F6D1AF9EF2663194FA5E7D49A18CA24F7A14EA6CCB6D4C058E984ACF822B73721480F2D834AA607150703988B728104442B9F712D95A86329397FD2CD71DCED2CDCD17D571A1D3FBE340B5AB41EF5636DEBC68AEA8E8C5C93516A5C30909AB3A7972589292D0E8BCF4A5958C2DCD131E130D0AF482061404C299CA0223BEB3DB6E369761A635F35E583553A27B68CDFEE76F3FD15C0EBF5CE91919F6E54CFE451D1C54028EC308156380A9DE71E63EF1F000DC50C32BD08A5A96648A4DE25B526994C42989CC06220E04071E61C733FDA110DBBAB825F51B5452C51EBC7F6FCAC56DF578E91122A293815DAEBE10C7328A9148E2A5D33EAEA84513290C0558CA0865881F980014110DA00208FD453F4BECFE3C3B78856F3119FC6A146786DDB8FEBEDDB41C067F10EDF650779F2D3FDD457FB765D3674AFA6871117173750339A8644C861031DA69D698DCB6A39C481B0E926E3579031B1C400402B5CF24547865D26459227A75B24E291B9A5DC5C738A889761C1ECE4BA482C3B3CC2A22520808EF0C2B52545440A7EA7C384C4C419C40A2AC4B1900294400404645781209F0C3F88E6861111DE2215416837B055589CA644300E50C760618061800086C00C2B743E9215D6BA55EA144489B701388A4980872E3FCD5713006CD8039418F8E1C2B205BBA4FA4CBDC96E44BD41A90C4945AE39A5145122E5A294DDCB2F2E9898E25C1413A4F4076F8D5827AEBC095C5A3381744ADC8F4080BB42BD70389814CC511C70C4A2514481CA4280860186F0DBDF5CBD4BA8476D0A23B6CDA4F1791C98FD0B62E94318EC1241111131444C630894DE60021C4BCC2218FBAB836BBBFDCDA5793AD4972E797270A645CA8E81C2081413895551103009CE476A06F1DB894DC9B03C2BD8B51AA3925752C3030EEAAE8C230D171D94D8489297969C9D121123114454FF00522D0298F987C5503089760E38E1806E00ACA4A8E844EAAA6513E8D894E62E4E77298E052984142A4438E3CA40362052880EE0AC4A71D4D22101314502604028140C051E50E500294A021B0037070A02B96259C6B5E6EE41CB2A612B156E09794A01CC68F7972115308814313188FD30C7C0850EE0A03212D1F9E63F2837228712826A395088B2289D7308FA976B11568C54103794A74CC262E02020034B2D3BDA7F1C4D775B8C2A8E23162B14C74F2551154EFC515115982C528B75D16CB8284411E6689284301998B9027AA326B8A00704CC04D7D59A85A72598D93F32746626EBAAC0776AE8CDD652DCB62DC8EAD892B1EEF42534F6F585BE2D9CA09E8D4CE42CDC42F20C94902325942AC9B570A22253010E3CC0628793B1BBE64537CCF43736941E07B45FDAB37FB573D20F517A46AAC0698D39EA409737A73661574ED8D41D28D3E6100B3844EA28092AB4A58128538940A432A99C70E6E611F6F827F8CCE08647D4367EEE1F87CAA1996AB35B0BE2E1378DAB6687C25EFBF6F8D070C4BAB3F8F86E1DD4033F8E3FA5053B3219FBB6F1EFEEFD6806771A770E633FB7EB41DE33FF002A62067F1ED8D330867F1F9EE1A0F019E1F3EDE1BB1A70A019FC7B785380349CE9AA43A4A948AA6A10C451350A074D421C04A721C860129C8628E02020202141524AA948502140A521400A5294394A52806005294360000060186E0A0273F8F6F1DF4A2033FC3F2FBBC68067F1F7D00CFEEC77FC3D8342939E3E3C7B6DDF421B4A9915D3322BA69AC91F0E749521544CDCA60300188703147030008710A0A9A8EA114219350A53A672988A10C00621CA6010310C51010314C022020218085098F005508994844CA521085290842140A4214A1814A52860052940030000D94453567F1F9F87C31A0273F6EF0F7FE23EDA0233F7088FE21F0A0273F8F77BFE7B2808CFE3C68067EFDBE3C2990E233F8F1EFA019FC71FB366DFB28067ECDFF685388273F7EDF9D4E408CFE2354139E186FC3C7B050119E23DBEEA512058B76BA88E51219229E50C01CA744408748B80606726003028021B8A389B0DC201B47DAE971DD3754E9B6E7C7BBF3CBBCF1BA9BDAA54A5771CB0A7798F736BDCA1E1D24337B7E94A0A32736941F3119BDBF3A506275DFA9ED7279A09A62ADE91515173530EA618C0C5B1957CAB46A574FDBBD5C1E288B72FAA92234233131DBA6A206390447349CBB649E9553E0BEE37AC2F7A23D38FABEDAD5BBBBA95D8DA84672718EA9293D4D2559E9D35714E2DAC752A18BBA31EA72435D6DC9D85BD1CB336A25B2F167AE7D234498212B6D493931E3DEB66A872A45344B850592C050D8995039CC6515318641EACF33E6FED27DC3DC7AD7617F69D5A50FF009EDB4DC9E94A2A7666FE5924B0F91FE9CA9C3436DCA4D98FBEA1BA2F3B7F5A16DEA25ACC5C4A48D80124DA7231920A387AE6DC9533458641BA2890EB2C108EDA73A84286C41C28A0E0098D4B9174A9E27DF6F47EFBADF4ADBF5EE9B095CBFB1D6AE4229B93B53D2F524AADF9728D5A5FD3294B289D23D1AEB4B5AB4F2C667A516A42445D8E535556366B87D1B292B391647EA9D408C64C235CA3FBC822E5631DA11429CC909B9041448A448B82934A87E3BE93FBB9EAEE85D1A1E99E9966D6EAE26E361CA139DC86A6FE48C60D79946DB8269B55A7CD14A2B0EEB669C5F9A4576DAF217A49816FCBCE01B6A7CA03532083F829B98B8A704CD5C7A43810922DD78D2AE7512226891750C9A7CC09098634D6799F29EB0F4FF5BF4AF54DB5EEB173FF00DADDD85BC9D28A56EE4EEDCC1E9FEB4E1A9B494549B8C6BA6A7D0D3F5AECB9F4D0EB5B52C9DAD7ACDDA083C8795559357A8445C0F231272D8CE58C83474DD66A9BD3811521D130E589B00036186FA55733FBBAF7FCA751F4F3974FBAB6DD5EF6D54ADCDC5495BBB2826AB194649C54B09271CAB854F2FACBE8E75CB5C6F04EF9EA7AE59260C11382478D56498BCB9A49AA0A98C5611ADA341583B561D4504C23C852A81CC2254004F981AD41B7591FCE5D23ED37ACFD65D55759FB8DB8B90B09D3439C657A714FE982856DD9B6DD7255CE9055D47ADB0D17156F4446C141B16F170D0EC5AC6C5C7342024D993064891BB56A8261FC29A28A6050DB8ECDBB6B6511FD41B4DA6DF61B6B7B1D9C236F696A118423154518C55125C92454B37776FD2943A3119B4A0A32AF0AE6308F483289194407002184C3969A9DC759300C544F1E3807780D72EEE37DD97FB6749FC5AE4F83FC60756D1D88DE5FB95587C13E6B8FE3333124BA7964C912657280A797865F20862514F97CBCA21BB0EEAF949296A7AABAAB8D73AF33EA63A68B4534D30A1AF3F8FB3877D43219FC77FE587777500CFE3DBB8683B867EDF0F963F9D0538146CFE221DD404E7F1A6608CFEFC7E7C31DBB6990273F8FB3BBB6EA7803E413FB8B635C8EBE69ACA8B75C8CDF684C2B445D991501AAEF232FED4351D3749C18B94A386884A226508511310ABA626000314479EF47534333E5E88DC48403098300C7BBC4D87DA35943EA29BC44CBB36F9BD9EDF76EADC424C826203CDB004A2511001C701010D980ECC71A02B56D3F0889349D1D31CA129D15140C44C09A9E728EDC43C8B9087C70C7CB585C4DC1A46708EA950CAB2042C9C7A29B150174D1281D0148133A6711CC0581C10C2501399BAAA104C2388872944440A500E7DFED652DBD781B7673D1B8A1B11D312C894C8A9292CD0AA6050283D729A7CC43B658CAA8247C513AC63B04479CD8984C8A7888F2170F37A6C256A55791D7D456A954AEBD7AACBABEA661DAB30B19349217332B0BEE5221EAB20A0E1EB870A220899EAA24E5C3032838615EEF9DCCF2F4A3459DAA909A45AB9A3DA8A83545E1B4C756F49F50A47D2A2889908DB0350EDABADD336628259A555DB3863A04CBE5362A794C511E60DB65EEAEDC56F671F3370DE11AD2BED15D8DB4E7D427E5ED526DCA95A61D87E87939ADDD305B373DCAD4252F263276D5E1743333887D06EA616898B99879DB9239FA2DAE1B3A03F645E222DD32782276A706EE8309020148A88AFF00A86D7ED9FAD3ABF4EB5B9D9ECE2E576DA947F5AD26EAD28D2329A93AB924B0CDA59B3F00F507DECFB71E9DEB32D8EF3A828B8CE9476E7CEB92797BCAA29AF1A2C46E8C78EB25C501248C722D859DDB69F531A7AE976D1B24F1772A914BAFD24AB655566A8957112B838010AAA664882601D3D37ED67DCA95AFDCD9D879DB45FD50B96A6BE12699E84BEF9FDAABD6D7ECFA8C1EE9E5584E3E2ABF02AE3D4A749E24CA2F59D6544482313959329AFB68C2CA26DF3454F50E985EC73B8F52AE228679D9000108AA471170431E9FF8EBD776AF37B9E95BA797D166775258AAB76E2D2A532AD72746A95EBBDF773EDC5EB49BDED957DF6CD2AFBDACFE396781F2B7FDCA5715A77A6B0F43B72D8BA8517A9F6DBBD13D716AD2F582B8602EB889318ED49B45172D539BB6B2225C291AB2F91CA9A6009090C5C0079ABE2FACEDBAB74BDFC369BCD9CEC424DD75C5C24B0E316ABF8A6699F7DE9BEA3B1EB5B096EFA75E8DCB1C9D5674ED3E4F2E81009F20A7E4E570B89B1C4DCC394A61B4C238603B6BCFBFF49F451CCB75C6D500A22602894C0204E5E63018798C401300E1986D823BC0076579B716A6D1BB81EBC7F6FAB751CFD5C3A5D58A521BF6C84D7B7EE944D1388260B682EA5C62243ADFC251017801C71F1AB0FA81FA50E7F1F1DD856E31E033F6EFEDDFEDA147A80DD8FB36E34A760233F8F8FE785061C0F8B1FEE9CBF7F74D72E93B4E4A221FD09A39AA77D2A0071C0E6D51BC6D6846BCC9E386201A38B90070DA554C1B8442B54F8151D5BD28821B7B42B4AE2008298B7B06DC154821CA22A398C41EABCC180638ACE0C6F7E3BEB5A69E40B2276395772055D058A4728E09FF0035BA4EC862622A10A291241B381294CA08E0201B444437E35BA296921CC69112E428954958FE6C7110180780389BCC1FC53823B0070DF5982F78B8D914013707988C44A8AA9AAA2A686708072001B6028E268E90082842E1B3609C7C4680BF3A7EB695474474A953A00A2CF34D2D27EF7048A403BD95848B935C04A8995487296786297CC2380770ECADDE643CA71FEA48D2EDCDDCD557A4BE14678C83A15D3104CB20A2620505005BB56E395C80400FFAAE6487CA1B301AF8BDD5C77377A2E55C6B933E9A1653D9D7FAA86376DAA132E2F49EB2DB45B5F4D176A424EB7952A0B84A24A5C570DEF144629428433C666328D2C3C63D6032EBA8EDC2C551A95104D73FD7ECACED96DE3A63148F96BDE72B8D36D993236E0BB557CE51F4A9AA83024803D3A51C512B81816AD9C4A03539992662FAD7A819AA220005299CE25D84C6BB9282CA8686A6F3A98EB59D19BFE8072FE49CB64978F96B35F9564D9B531C1567A9366F3AE668472D164902388E78AE025287A710FF0008ED35078BA1D16EAA2919022236E05C8E9C293B1C638AF86592DB4132996DCEB24465B106FEA79F2C370130C36615A27A163433AB34A9057019C080CA314C04471514B74EAE3FFD2CB9904C70C70D81B2B4369BAAC8D91C51B49400A4A9DCBD934641E9082D8846CD0639023331B34E266E2B2FFEF0550C2251139870DA186E0D326F5191BCD1928D974DDA6BAAD9627F2DB396AB19A3C2220A9398E8B84448B375C85FF11440711C71DB5AA3B87093D2AAFB4351B94B59B9162D94BB1BA347F51F5FF51F57B4A2C2BAE03512FAB121BA7C95B22F09CD5EBCDBB0988981B61DA57F7F59C5A47BAAFE8C62A2ED621B41BA629C724CDD3B986A45DD8C679CBA95773A6F2D50AF13E86FFA41F4FE9CFACC6EE09574D7F87F3320F58D0779DE1A3979B4B9E0E699AF74E83C9C8C6A97359B69D865955A3E11DBC071091565208317105EAE11122120E4A0F1F285054E220701AFA577766ED295B8422F923E4ECF519F51B7FB96A956D53BB02BBFDABB7FA51BAE7D61E9E89CEA1F503493482FB445612956496D2BBC2FA8396FE586FCE0D686653E1894A64430DF5C493D4FB0DF0EC3ED433F0EFF006FCB670C2B3332D968B7FC673E38FF00ECC5A21F095BDB66DEFF0035182E7CFE3DBE1C680E0494DC642B171273124C22635A1331D3F927883062D530C039DC3B74A24DD1262201898C014053ADEBCAD6BB5B28F6D5B9A02E6648A808AAEEDF998E9A6A92A3CDFCB51C473872926A0F28EC1101D94073662E089B7E39C4BCE49348A8B6995EA9FBE5C8D9AA1EA1749B239AB282529339CAC421711DA630077D06654F3F8F1DFE142778CF1F1DBD83850B82386EA5E3D8A8CD17AF99B35645D0328F49D3A41051F3C14955C19B222A7219CB9C844E7CB2731B908238600382A080998E3489A2024191A59366491522C1DB71912305563B74DE9D90282E4ACD47099880A097904E51280E2021421C56D73C0BC7831CCE7221D481547E89D8B69366BBD2AD12AA284A2466A92C65C148D59CA6470512E289D4281F9444006178956CF0F1F707BFC38D51C0A6C9DC11508466A4BC9348E24849C7C33151E2E440AEE5655C15A46C7A02710051DBE7272A69103CC730800053982A59FC7C77FE540D139FDD8F7F60A0233FC31F8D066715DCB308FF004DEBDF34640F5DA2C1983B728B6F56F9CF3FA762D8563933DDAFC83C8913139F01C0070A03979FC76D0780F51C760D2818CFDDB7EDA832233FF4EDECAA09CFE3DB76EA019FBF6FDB4F11519FC6880CFF0060F7500CFE3DFDFF008F1A019FB37E3BE8067ECDFBBDB4033F7EDEFF001FBE8FB4219FC7EDEFA228F501E3F3F761ECA139919FB77FDD4E009CF1F1FC786FA0E233F6EFF9F777539836D550CA26721543A46314C00A93944C41306C3140C062898BC406AC6494936AA970FC626324DC5D1D1D335C3DE63F7D6CBE031D56EE48F44C22736688A4B98C61C44444E632661C476889831AF7AC755B0D28DC8B87762BF3F81E15FE977EAE5096BAF6E0FF0022D139C5339D338001C86121B01010031470306251101C043786CAF5E3492528BC1A3C992716D3FA93346755A12ACC0575F51B66589AAECF4C6F54D7B51B485A4EAE8637C4F3A631F6B3D51AA8615225B3A3AE61F5056EDD713195148C0B26548A438AA989B1AA4E8F03E1BAA7AFBA4745F53C3D37D614B6B6EE6D5DE8EE2ECA31B3271CE09B79D14AAE4E3F325149EA8B7B360754FA35A9F7CB8D3FB2AE35E5669160EDFA0E548C78C22E4CAC0E4078DE29CC826D9678E904CE2AE054B90E890EA10C62944689C5BA2661D0BEE57A4BD49D6A5D0BA3EE257778A12926E128C27A5AD4A0E4939492F9B054714E49B48C1FAE9D255D5AF1AC2D67EE3D4B7AD34B19C4B1F4B6FA419D2B132218B7938F806666C4876A84891B91C2920E0577198A658A4A26993963855E781F1FEB4FB59D53D6DEAB8EFBA87519C3D350B51D36963384F29C6D469E5C54D2527767AA757A5C6518AA79B8A05DBD1AF521CC4072ED2B62539D2130E4A777D852E2201898001B8A8FE30C253080188DA41110DA646B5E3091FCF525D57ED27DC0AAD528EDAE557057F6D3F85650C1E6A1763DB03DFCB6EE788BB6DF86B9E05E26FE167E359CB463B4F72ECDF2045D1318B8E292A053E0721B0310E025300080856FCF15C4FEE5E9FBFDAF54D8D9EA5B1929ECEFDB8CE125C632555DCF1C5669D53C51D78D7DD50B6BA6D8426A2C6E92B39E909E915629FCD42B685835107EB373B863FD432E9B0712876F2264942828092A5039394C2063A607C25F2AA9F05EB9F5174FFB7BB25EA0DBF4B85FBF7EE384AE5B56EDB5269B8F9B35173A4E8D27492AAA369B8D7CF7D34D29D53EB1F5691D60D5460AC5E9E11D343AEA9DBACC58C8C34618EAB0B4ACF6AE44CBBA8C515112397606121731638A87703CA3828B9BABC8FC27D39E97F537DDAF542F55FA9A0ED741528B6DA718CEDC318D8B09E3283784E792ACDEA771D1FB50550A4294A5294A528014A428014A529400A052806C0000DDE015BA87F5F512C1609139D4D28B5273B75282A467052806751A15656E3A1DF4910164B2934044C00B28A06F28E06002139D4C407C402B8B71BDB1B6968955DCEC4BF8BC0EDDBEC6FEE56B8D15BED6FF00862FC0C8710C948B405033C51C947CC5218A52A4908E226048044E70030EFF003618EDC36D781BADCC7713D6A0A2FE2FBCF7F69B796DA1A1CDC97C3D9C7E255F3F66FDFF007572771D4467EDDF86CDDF67C31A0273F8F6DBF8D062467F763DBF1C295A63C4146CFC3BC7E54A8273F8F8F6F1A0F02017DDB78D1F3033FBB7076FC69E20F96DFEE2D662BCAE81BB0C0B9D6ADE6D414DFE56D2F10B9CA18ECDA2E8B5A2EB6A714B2750BB0F93A02F2818A25E6E401E52FF009844D863DC38544E98A29A93C4E1872017C0DBF0EFFB842B38C9B7460DDC91EF128F0C003D9DDE35B486E909880E21B036601B07C3BB0C6A3A531C8A9CA38C7336C087210C911458891FF8C845962A66C079B690A702EF0F8D2E5CB9761A3FA0B2A47E7B785C36C136E25314C5011C4369844DB843B8446B45BB2A0F2C0D9E75C9C1ABCEB320C9A7CBE436D0C302944C003B431D806C3756ED11349C73B341529905114954DD00A0B24A260A03922FFCB3B6310C5302E67007E4290DB0E610288800E21B6CF976EE29CDE949D6A69DC5BBD7AD3B5663AE72C29CB8FC0FA3FE95355351FABDE9F6DB1B2E617BA75A743EC785B1F5D34D255EC448C9DCB635A3091D6969F75356DB2BE1E3946E0849AB1A021EDDBB1DA264DDB2B863C241D90E94B24B36FEF5FF001ABEE77A3B676DF47F5BDA50DA5C952DDE729AF9AAE5A26EB8B949CA505549A72828AD2B5FF9A5FE5AFD81FB87EA5F595ADD7DAB82B8A6BF52D2708D1D12AA6F3E78375556F1A2CB1256975673097EDCA6986A1BC6CB4C389F51E59BA4647025935D75E4547695D3A71661DE9A21774A19C2C649CAAD10551F5074724A961FD7363D65F613A55D9EEEC6FA13BCADAB6A33BB71C71A249C273941CDBA2D6D39C9BA6A6E4EBFC9DD6BEC3FF939D06DDBDAEFBA66E6E4352D72845609E6EB155A4734B8AE3855DD5A28AEA2DD6A5FB65F565D34EBF02D622F746A46986ACDD16B5CEF5BDD4CAD4872B9B334D1ECACE92E69A732331788CB8922791B337DFB89545CAD5716E81FF9E2E7AA3ACF54EB37A3E8C96D36FD3657230518CACDB8E994A319DCF2F541371828B95C69CA16EDD2345A94BF64DF7DA1E95E9FF4C6D2F7558F52DFFA8AEC5BB8E36373FA3258A8BD3169D5E0BB59E7A7D63518A3DB1D073D81B6242CAB6A523FAE896B46D79489716FB9636F3DEA36DD7EC8C7887E9367045C5ACAA1CC6224895200CBE4363CE1FC87F7CD6EBA5FADAE74CEA1B8B5B8DDA56D4E56DA71F33C9B6E6EB1C93C1A4DE4EBC4FEF1FF0019BA5EF76DE848EFF796EF5AB17ABE5C2E294651519358A97CD8F347CE2DD42634D18C5DE470B61B830C53503D82180D7E333936BE6C4FE8D492C8A12C413073886225209C0443BC81CC0386E10C4B5C934A95E2647AC9F41151E37FAB9748C56EE17411583A8123F45250E9A2EDA1BA6AD5C70920E522881154C8FD34952F300E072147BAB087D4567E933EA38876DFDFC2B7188CFE3BBF1A5712F219FEFE34C00CFDBBFF004DF4199F9FDFF719DECBDCBF521BAD83A21011D3CD0BD19D3B6A09E69563473825E9A96ABBE50D8AABFB8EA7289944BFC209877E35A67F5151CB5F57615EDA36C8DBC662305FD2B069B276D9C91C95749B44B36C2DC152888B3729AA9189CA180F96B5C62A39031905E047CB1142AC2728E2200A08F3077094C061DA6208618F7E18D7443E921586974948072F380001B701766D1AC8175B3B9887E5C795C14C2A18CDC48801143108D8E9E69DE914404C53220254F0E5363B76E34059763E9FDDF1708C2109D5A7502D1B43B44635810B236EA4D3D0A00093068D9B90C0449AB16844D147606292651AD76A0E775AE0637AE285B4F895695D2BBE1A3832C8F565AE0A99C082AA664FDB19C41394AA1B1E629CC51504C261DBB71C6BC6DDECA9BAAF33DFDA6E15CDB7B0DA6562DC2478BCA13A9ED6B65703C64A45C8CBA570C5B77EF219A279B1B1EE5C10E56878564E5670A90A01FCA5D754C50039CE61F5AD4BCB828627937E29DD6D50BB0AC750DA979DBF58DD47952391429116779C3A98A2B1CCA249249A6C9548CD4A530720623894004DE6C6B6F9DDE69D1DC59921A5DA8774BD41DDCFD5E750F7047FEE312E9F5B33AFAD47D0726CA265D9489E3E48864135D66720D513A6B10E4129C8A18A202511C77C67F226D98B8D1D0ED512F2400DFEEE7410444C274C880A2522606F3094856E54D14C082610E52000130C00300AD339BE398A2256BC00DCA5F5440C407CC27F3088888E2223B71C69175552E45B8E2EC06C27151D66179C0D8996112F36C0036026C004BBB1AD53FA8A5317D434C48629960C04C053A82751CE594DCB8985BA0722C7C030D988E3856CDA4AC39BB52A6A2B6B6E96E2793C884EF0B25B4BA12A7BC0519145122A59B4AC83AB20D9628081504249C4A2522504C0C21862500DB86CC06B9EFECF6CF729AA1B7F77D6B770FD6727D3B8E74A17D1F532C44A1AE16D2F7095D59E85BD2EA484B2EDC21DB26C9D40092495791E2BAE91CA9B449D268A0631C143A25C03F9B8565721A6FB847E9471C96DE2E9B5A793C3BF89D75FEDC6BD4F6A7D496D489660CD526A174FFAC1A7CF923BA283E66C5B92C5D4B4162B612F388957D346C88863800287357635A629712C7067E8139FC71ED8E015ADA3616DB55BFE2F9C1DFF00F0DDA81F093BCBEF1A02E4CFE3F8ECA03AFB7B20D2E8D74D37B5AE3493776CC5D9B785F11F12ED305A365AEF8D95B721D8AAE9B2A02DDE2F05172AE1C200603651D4E7C3102880150D4B729594A4038B1A360ADFBCB532EFB734ED4BA0910D54518315909A995649CB320208CBB98C8F8E75E9135C4480BAA5E6C49CC5103096B35C17642DB9A95A63745C8A5E881ACCB3EF884B8DE45C4C44CA491F51E2A0E4A1A51BC0B38D87749A2BA68AAD9649B207E550E4500E250308193D7B83526F795D517F6ADE89D9D1BA6D38E6D685872DBF0B2EDEE49989B762AE0917574BA946CE64138C72E26136C9271CAB3548910C71398E2180625BF686A36A4EAADD51E9C05C917665BAE34C34CAFD9068ADB8DE7A448FEE4713A329151CE5CB96A9A6D5CFEDF9675D62AC7211328A64218E630017F750B98DF4F93BBDBA6655EE9ADD36AEA2B7214BCC266F6DCC3734E1040004C0552DA74F4A386D103086CC71A030F84F3589D6373ADEE9D1C96E48DD179E8FB974439956E480B66CC6132D9C9804C098812F9B2A552298B8140CE4A53088EDA038560CBCFDAACF4EC544A3D297BAF4835875625DDAF18C5C4A12E39F9983BAD102C8B86E67C8A2884E826B20062A6B649330A6120600544DA99AB311A75A6571CB5D05989AD604ACC691CD2D7B0117AEED46AEED879734CCBB160578B2B72CFBF60D0A5CA3A69326EBA8272A42927C87028133755F7283050F74A57848C1C76B7E813FB66E7BD2CC6B65CCBD51EDE5973310E99C7358E8A7BFB6AAD115525916E90891C094E0225030815095D62D549B52F0B86CD25F8A1ADFBAA7616D7B421F4C1B4E59F70B4B5A594895D29FBAD46CBCC15FCD2CC56113B272D9363CE428915310C267882BD23A9D76A17D4D34BC2FFB83495B2774B2616745BED376727625C16FB8463C19AD257A388A7864E4E51CAEA26A80494795A2B81390F8081819B964EA4DD8FAF28E8DBFB50A76CABA1EDCF2CC474CA734DD9B1B4E49822F9E84730B5AF552288E249DB98C45355273FBAAC2B984401BED0000323EB9AFCDFE8F6DDDAEBA7C3EF0FDDF0FB69C015FD5CBAC2DF828A4DBDE13168CA4C4E368F8CFE9AB55BDE773CEAA0D5E38561A0A0DD30946E0E55491CC33951BA892044C79F0E601A321D724757B56CF11734410F789CB6C6A45BB0B37760E9F44BAD4786B1A7ED12CF848BAB0A2D0730AB48B69359048574DAA852335415334E7012945A95073AD133E8AD4B72D5D48B86FD5EEBB8AF0F5776C1E9A3256F9B6A1AD189B7D5756FAF661A323D816E03C94E247176EA3524D26AA622D8E2053199E60DD36A5EB3A51D6FC324E6423646575A216CB86BB2FEB11285733D694C5913F34AB894B65A8C72067F11351C64CC7662CC8E011261940A1E80EDA5BE8CBC743B2653D38171CBA04501ECD7EDADA1C1F9CCBA874CE11ACCEA376A092272A7814C38F2F30ED11A0F02B39DC7D9DB0A019FE03F861F6EDA171F60CFE3D8284F119FC7B7CEA8273F8FE753C4119FBB6FC3D9B7E34033FC7B760A019FC698044E7F1ED8D071A0F51F1F6FC3E740467F1DDECA019F877F60EEA019FC7776FB29C816C5C53A2CD1F4881C41CAE4F31C37A288E202203B70514DC1DE01B766CAF53A76CFCE9F9D35FA717976BFC97E389E5F51DDF931F26DFF7659F25F9B31D6776FBEBE868F3E07CE9B4BBD49AA0B395CFC88B74545D63F298DC89244328A1F948531CDCA4288E000223DD568CC2E4E36E0EE4F084536DF6258B3C0DBC6ECBCBAC2D4EB8D671714540B1B7ADDBA26EC3B7271EA2C5A158468353A36EC598E74D056E59F29135175543E06148C613024910A5D38C99FC35D5BA9F57FBB5EA4DC4A7B8B562C6DF6F7AE6DAD5C928C74C34D2D4324EF5DC1CA4DE346EAA3149763B493563A26D2FB4EC5BB4B6D3F26A6B76683A9449A34B867AE0899C4C8AB07EB964A49CB28149AB91150E911050B8B7397993E61101A9C5779FA0FA57D51F66BD35D2F65D57F6F35EA38C14A6A31BB76EC2E2AC64F5CDC6D28BC5C545AF91AAC6A7A07A3FD4069C6B8B191756349BA3BA873A259687966468F97604746581A38510CC59BAED9CE41B95445554A021CA6129B656717A8FDE3D25EB9F4F7AD6CDCBBD12E4DDDB34D76E71D37235AE96D629A747471935C1D1E074DFEA2AC74DA46D6B7A45E5C510C754A05CA69C3C226717133376D49AE047ED9D366A539D93566B07AB6EE1D72238A6BA4908A8B0856335DB99F917F901B7F4EDFE99637177716A1EA5B124ADDBCEE5CB337F345A8D74C62FE78CA748E138C5EA9D0EA3E8935EA9B556CC67A51A6D2F330FA711F28E9CBA9C32C780868E17AE1370E58AD72B74424DE3545D98EB8B0682B28275CE63A62510E5C529354591F95FA36CFDCDF5474887A63D3B76F59F4F5BBB272B9576ADC3534DC5DE4B5C929565E55BD4EB26DC5AA53DB88F8017B67C3DB97F7ED17B3A6F1D1094E397D0ADC6326A562FD32E1286887CA48A292A322D4AE09898D96B140E5E510000DDA5D28CFECBB1D39DEE936BA7F5CF2B7B7636E0AE395B5A2E4E147AFCB93924F5A5358BA4B154C297610E44C854D32948990A521084281484214000A5294A0005294A180006E0A519EA24A2B4A49456489CEE3DBECDB4A32939DEFF008528C0CE0FC7E1BA9460676FA51819DDBB70A5182BB053A68D71C87308B45C401528623966DC558A01DE1B8D86F0F605706FB67FB8B7AA34F363973E5F8E277EC776F6D734CBFB5278FE7F8E064F071CC002020202188086D0101DA02038E02035F32D530E27D3AA3C5644E7EDDFF9FDF8D41DC467E1B71EFDBEFE34CFB8A33F8F60A13C467878F77BA988C4A28AFF00770EDBE8067F1A044E7F1F9FE74C821EA38FE9B3E541E27CD47F70EB305E1FA797D86202CF53DB88809B6E4AF622B86C1EE15F1F7D73DDFEE47DA0F91F30900479836F9807780FF170C376342929970C7FCA38FE9BFBAB287D40DC10028621B042B710DD4F987000C3137E18FB6B19FD2CCA11727440C4388E00431C711F2249A8A9CF863E4226911554C638861E521CDB76008EC15A8D5779874F7E76EDD9791496CE5172613B772CD728184BFEEEE41D00985248C4C552A4801935B34E64D43268E71481C840E55047AA7674C350EA35DBF50858E0CA8260261310E4E5397688618621F757394DE02180404BCC510D80629C4A600C30C31298070101DBE215A6FD3CBF995555154D5BF9DDEF2153EBD3AA9CA9CF22F4D39D42BE7492F7B7B51B4D2E698B22F9B5DF9DF405D36D4939829A8B70ECAE1BBE335958D51BBC408FDB3D5D37000612AC92C72285390E621BEA361EAE9F408C76BD46DB96C2E2A517665C381E075FF4DECFA86D76DD5BA64DBEB1B59D78E15966F83AF33EB8FA56D71BB3A88E9474FB5AFF00D35B7EE7B918ACAD917444C1415C5270AD5487757344B0B9ADCD39B2DEC44369C19A5C96EBB6972C63261FD3EA28E226523DAC6A72CE5823C3EA5DC743B2D75CE9DB89D9ED5295CE3C9C9579D6BC3DBFDE5F64F75B1EB30DAED7D6B761B7F3EC3D17159B3715C76B4A71B929C2724DC69A5A75952E393AA8945EA02F9D4746CDF5FA4DA5760456A55B12CD9D35B7AF852EFD2C8DB9E225BF6A899B8B49F10B0C944DCAD52401D313BB725609E4888171555053F2FDDFA8AD5CDE2B76F7972DB955EA8DC9C7872978BEE3FA5B69D13A5F49E93BCDC7A36CEC779D47792B7156EED9B1F2A84F1759C68AB16D60AAF0D4DD153CCBFAD02E2FAC5FA7A3F24BFEFE92F697580419C23C7CE825D56FAB7A769A2275649DAAF95459A1CE4484C9278729B1DBFCB43EA7A35DB9D47656BAA4AFCB73E636B536E4F074CDB67F017F9096F6FB2FBADD4B67636B6F6F6B4596A16D4630849C1395143E5C5D723E666644569E724126252B95B00C47FF00467EF0101AF667F49F889C432622A264E4C4A7508988081C4A2550C043737208180A203B440404036D735C5583453D88FEDFDB59793FAA6E82CF1CF949DAB69EB84D144702A6ECCB6935D56C19240B86618A896E94CC2611DBCB5843EA2B3F44DCFE3EFADC62C8CFEFEDFAD38178509F51C7DDDFB7F5A6629891EA38EFFCF60D0627C9D7F716F41F75DE97269D759DA410A7B8A5DB5B9FE98EB0D8F0C8B62DC93ECA0567B3D64DE76D3349A20EAE39762C5DBE8E986E0E5590562DAB0333445364E80DCD7D35492C81F24919735EB63B29488B3AED938040EEDBA6BDBEED845CBC4A2FD07FE91DC90DAF7433E68E764266AAAB48F3B5C958A29992E628852D3F971C4A7B2362DB5F4E4FD8219D5DFF0054BD696F702D18CCD38C617A78B5902B493C82FAD6AD5BCAF47774AA09A0B0090A717EE73403300E2060C3AE1A7D8465EC10FF004C129C89B1FA9CF53C70362222BE82E9B2618898711CA53A1A308063BB1EEAD539525445454DBDBBF4E151428B6FAA47506D8E27C482EF4474753E430601CDCAEBA3368B947CA1BD32ECDD88602386A7F8A82E16BA79F4FC543065F564D54686294A514DEE8CE83A5CA5294008504D4E921131400A018794366ED95B60DAF9960CC65152C2589B8EF4F7A166CC5F3B6BF56ED4C72766CDC39FDBDBE8EF4FCD9D3932482CE1BB666EA4BA6A87883AF32E198326853A8439DD1C4A50E52A82649293D52C599C65282A45B48C90D3A128A9E6AB3C80EBF20E7D449A337E6460F583A56983245709115445218FE875CAAE0E0DCE01CE9F3737718C1808EB9535642ADE25B313D1699C483A6FFF003AF26C05AAA74C17777374FC05F28ED0211DF420DD5000DDFC0501C310C4B80D618760AB2E927471129BB6D1AF3EA2D06C641CA275908D93BBBA5D6CECED4875C8E5F803CE8A5B3AF4AD8C52F30A69A8BF2F3F29797F989EE8FD262CB522748FA49B82318BF6BF58E7D1AABC8C68E968AB8B46BA406D2516F1C209ACEE264D46D68376612716E4E76EE325CA8902A91B90C24C06AD13CC1CF77A2DD2719429C3EB2B16D702244E44F47FA4172894C9A444CE6298201E14C650E51318730DE611DC3B0283863A17D293D31884FACFDBAA8ECC01C68B747840DD86D03C2A387FE097EFA9440E421D2F74B4F535043EB37609471C0E571A5BD1536583FCBCA459CB2553010FFECC803BF686D1C74414B524B51AAEFCFF0024F18AE06E1FA3CE979402A6B7D66F4B00141050825D3AE894B8006CFE701648004FB3663B6AD156BC4CD6E2F2B7E4A93F2BB381D0CFA89E97692694591A3109A3FD6B2BD552B7EDD17D31BDA3ECF3681C740C6B2808BB58F6A22FED5D0D8E7535FBA4B5C536A02049A55FA6E8AD316ED8A3CA60DE9C74D649397C4D70B6A31A452513D8FF00EDD1FA775E961DD57AF5BFAD56DBCB524548096D2FD10B1EE88F335BAD8B1B8958499BC75326E25D208BCB55E3F60DD1878A417C1F1D9B8925554D145D239DADB72756671547567D6BE7ECD83FAECAC566665BCD96FF008AE6871DF6F5B21F091BBB67CEAF363C0B87D471EDBFE54F01C8B16F7B1E26F808672E1FCB41CF5B4F9491B6AE8B7DCA0D2720DCB8481BBD23651D367AC9CB0936C194E9AB94166EE13C3989CC5218A05AABE92A32CC1E25755F77CDCF2CB3A88918D9C76F21631C5B12900ED57B15276CC641424642473D45653F9A73B65BD4943955E64FC94071DC68B42CC45DD2DEEBB9EE8BA272F0690B1B2F753D34133964622DF952CCC543C4B48C836905191E93EE6514291A09D63AA731CC23C9C8073AE2D2867352D70C9465DF76DA6DAF449BA37BC4DBCB43031B941B3124595C1959587937F08FD78A488D965E3D66AA2A910B88F3801E8302E4B7EC3B76D79F733F0A574CCCBDA96CD9884595544625841DA4691FD9D1628FA7F5645489C99C87328BA851210980144044CC0A5CF34C195C10D2D032441563A6E31FC43F48A2002A32926AAB376994440C5013A0B183708623BA84C0C4AFF42ECA91D256BA34BBDB88B6DB439554E5117EC8B721DC8CB2F32EDDACF8F18762A389272ED72B8116B81D35CE00002206002EE97D3FB7E62623A6955641A2D15675C3643368C556A9324E1AE508C2BC38A4B335D6F58D891490206050132809B9887D98014F90D2FB7642C4B52C317B36D5BD8E85B616A5C0CDE3742E48690B55812322669BBB233F407920660722A066C2DD52AAA1452E53600E239F03821A5A3208B50BAEFF00BDAEE74CAE9B3AEC6ABC89EDB60DDA3EB26494938B68D2321ADD8F8E6ED1F383803E3153F52E40A5FE69794B801C773A4A54E4E79DDB3A817D59517754A399CB8ADFB71C40031772EF4C43C94946BD96809498B7DD4A2C4CC72664E5203A82262F21844680D53DA4E5B95E3D4666FEBE1F5A1273084E4858CE57B7D6855DD36914E551629C8AB006B95B4111E2099BD1A6F4A4002F280813CA0AF600DB4A0A32D04F276FFBE2EC88B5E653B86DCB72E05EDF599B1994115D166F1D49B38065704B7EDC0E9416C572ED42904404DCE218D52174DFB6531D408E8960F2627605683B8A32E98B94B7558C4645ACAC491C959A8032F1530C8E9145D18C25320388806DC310185659CF748977DFB7BC75AA3A8CF2E08294465ED8B8E40D64ACFADC73E824E2A45262D5AD98C62DE339B8E943A4E92788390302698932F0373B98A1A5BE8E923959C9288D48D468EB92E09A8CB824EE2091B7DD3A76FA3211382237731EEADB5219D44AED5229CCD146E64525084044124C844C019B41A1F0256A9BA4EE7BB12BD92B91EDE05D4645C43A373FEFF2316842BE399BA70E5B78D10EA25A24D8EC0597A7140801873F9E83BCAF27A6893A2DBCADC979DE174C8DBB7AB3BED9C8CA2F04DF9A518C34942211E58F8A816118CE13D34A2A7145BA492A65B030AA3B4040CA99E3DB0D9E341E033F8F6DDF1A0E233FBB1FC47671A0A768CFE3BFB7CA839919FC7686FF00BE809CFE3DBC37F753981EA077E34C0603D46EDBDFB301F8FC2830A8F501E203EFA30467F1EFF1DBE3403D46CDFDBC6809CFC3B7B4683319FDF8F6EF0A0201C71E3B36FE9850032C53060602983C0C0021F010AA9B58ACC8E92549628B26E772D13145AA28372AC239CB2A44932A8526D2909CC5281BCE3888FB03C6BDDE951BD2D57672968C926DD2BC5F823C3EA92B50D36ADC62A6F16D255E48B38E622843114294E439048721C00C4390C025314C5101298A60DE03B042BD83C674927192AC5E143CADBEFE9D922FAEA7EFEC1BD61236D7907AE1DA1133ACE43D6C1A2E1515023DA2CC88E92936CD40E2548CA0A070214A53731B138EB76FB323F97FAE7F8F5B9BFD5277FA16F2CDBE99726E4A17633D569375D11714D4E2B28B7A5D289D5D6462ABB7A65B0F412F4B511D659C95B8F4D2F1809A64A5D96FB5710AF6D9BC98A60F1128C6A079C3BE68A3702268F37FD69D639CC42950314D1C34BC723E5BAB7DB5E87E84EB3B587AC2FDDDC7A737962E47CFB49DB959DC456A5F22F35CA2D5146BF5393934941A75EFA775BB34AEA8DDB75B34DC92D78BB49E423C7AA14C9A4EA42525629DC730102899151C95BC6A8B9CA06365014B8FF194456D3AD781DDFE3EF4EDEDCF53EEFAA59525D32D6D256E52782729CE12847B1BA41C9AABA5176A3BEF7BF4AFA4BA89A9C9EA75D71CEDF3DFDBDA357F024700DA1265EB01E4692B2E540A47AE9749994880A60A9125089140E5300080E6E1C4FDD7AD7DAEF4B7A83D4ABD4BD52DCEE5EF2E3195A4F4DBB928E119CE94949A8D234D4A2D25A93C6BD868D631B0CC1A45C447B38B8C62895BB28E8F6C8B264D1027F0A2D9AB72268A299711C0A5280567468FD076DB7DBECEC476BB4B70B5B6B6A918422A318AEC495125C91CECDF0FB69466EAB19A15311563343F4A518AB19A1E34C4558CDEDB37528C5581542AE22ACE630769377682ABA69AC801C01522A42A84E43794C6E5300873131C4388568DC5BB972CCA16E4D4E9834E9F8A9BF6D7236EF465712942B8D5570FE59995123209814502244010C432C84206021B30E528060215F2539CE4DA9B6DF36FF89F57185B8AF91452E4BF23773FBBC38E23DFF3AC0CC67F6FB2800B80F1EDB683F8939FEFEDF6D072233F8D0146CFE3F3F96FA019FDD8D00CFE3F3A019FC7EEFD680F9E0FEE062A4B583A00AE38AC9BAD550E511294A2DC4BA6C53A818F98CA91632600528ED29CC23FC35CD7E2DCE2A3F5621D7DA7C7FAA401398C73E040130886C0FF001000603BF101ACA366EB75AE04C7B4D655403FDA2877ECC7C0300D95D30B4BB7E627CDDA6D99C936EF00D9BF607C77EFAC9EDEE3C9F80A4BB4DB17780E25DC1DC1BFC3663EDACECD9F2EE6BDD63668F0E6F2319BBB18D6DBF9AA68309DF94EC923A09AAEC8A37228F5C26D9A94CB144802B385040A88089B61B12880E1818A38182746B78CECEFB1BB6A69B7DB16F2FF00B4D36E3776BBEBB76CE144A9DF43B8D7DDDB666A9DB11C65EC0928DBA22EC2BB6D5846F1B78E8FDEC47328A5E56C4D69FCEA17B3E9E8FD4CB4AC6B2D9C9DE8D57B5593391894453B7C5AA8745EBE230DDEABDC5B97A92F5EE86B47A7AE461E545629351F9F1CDD65CFDE71DF9EEF731B5BBBCEBB9ACAAE9EEF81D4F480C62E700188538266029C4BCC603E660050FE22264CAC794D8A9E60111C2B936E94A3FA999DF6253946B366E94313618F8EEDFBAA5C53AD2DE123729C1CB450DDE548B89943609800F389B9790098081C5429907455522971E64C5331542E251D82235E8D886E2F5D8CEF35292CAA9196D95AB2A5612FD29B5A91F5D5F4C2B2DF696742D184988D56426E46DF77A8D72C7210E9DC28C339D61D66B2EE2D3B89928E04649438BDD32D345DE882C8F2B25D45925801432421F947F91D6B7CBED6EFFA96C14A5D62DAB7E5E8557FDC8D7E559E0BB1AED3FA6BEC6DC8F50F5674CE831BAADEC232BADEA9E9A46566EC7093C53D528D1A716B34EA8ED9BBD7996878C7FF00B2B9859B996CE635936B57FEDAB5A4E441713BA90409FD1ECDBBBE6048B814368908414C851E6CB37F9D9B3F537DC6DC46DC7772BF14B0A384960F3C525E35EC3FACFAB7A2FA36D14EDC2EC649A6D357ADBA3597D4E58BE1F2B583AF03C3CFADFCFBDB934EFE9D572C82B36B3C7F65F56483EFEA19095939568F90D40D1E59D3274F259133D29924DCA21959CB36E42A790AAC9A64507FBFBEC95EBD6BD291D96E6771CE2AA9494AB56DB78B3F833EF0C3711F524A56EDDA8ED9BA562E392492C13FC7C4F97639CAADD2E368F21DCB900DA3BC1058D86FE15FAFCE5C0FC8CAB6501D60294E728E3FC440C32C3011139CC0189514C3115040044080220023B0792EC9A4E85E07D4AFF6D06892721AA5D446BE4BDB2E8ED2CAB2EC7D3BB0EE85DB8846273176BFB91E5F11912ECC960E6599C1DAB0E67A52285CB4645150E9F2B943931B0DC9B6C667D85E7FE3BFEFAE9033F8F7FCA82A3D47B3ECA019FC43F2DBC680EB1F58566B6BF3A7CBF99AA25239808EFEAD60E0CD48EC5B2F01CCE9D1C087310530522C5CA6650A38908A08E0600128EBBA93B6F903E36F5A6D0877D2EF86621232504AAABCAACB4530941F2088266017A82C3894A3B3C00700AE2526B2075E02C4B0C134D252C3B19704CA0528A9675BFB0A01E529482C3028103600077057542785781481B26C128E01A7F63861B0396D4812007B0023F00A49D5D41ABFA134F152814FA7F6388862381AD481100DA23DEC3663501B7FE9FD80511FFBBEB2CE03B8A16C410143D85F42001B77D6E87D2435869BE9EB841CB73D816736151BBF4B353B5E0845033E6846A558862B1290A6002079150310F8062185640C3BFF002DE437F2DC6AA02C60300A80F3437A70151BE6289AC29AEB2DA70F95306526B08AEA2C7500A42AA71032A352881ABFE5B5B1B04CFAA2AF3AB97C80B68874D2988A8A11C8A3CE92BA5263A79CA20A9C483B8A818370528BB01BE5E9A9B8A664DBEAAAE92621E44D3D16E98DB00AC264558F4C56FF004B114D351C9913184E38ADCC40128EC0AA0CDA8E99E9A11B3743FD38B09C0B66ED5B15E2D665B80BBA06E826815DA9CB10DC807725202820990A907360400272D0195F4EFA5679AB4E6498E9474BAF3559DC1A2D9C4CB5D39D1756F73C315D95D0C71E652B5AD09A5E3C930A22A950CECA038B45443663406570FA706BB1036FD3EF58B90C00252FFCA7DEC5394300102983FA154F3171DA223888F86E003789F4E0D75120103A01D60210A536C3F4AD7B10C55C4C2244F1FE830100394407DF50D52FA8E627F4CED7758A005E80F54CAA7281F2CFD305D4D8BDDCE065DD5A49A63E6DBB481863DFBC462760B4F3A2FBEBA7692B427EF6D005F4597BCDCC9B6B6DCCCDA507694ECB2F04990F36CD66692EC2E68E64C91956E7367B248AE334801CE4121CDCB3BB2537146F845B89F539A236B7F42695D976D988AA6E1AC3A0E9EA6E164D75927B22267EE103288908988363B8CA281710294801CC6C3987A63971A97919573F8FCEB221416EB7FC4D2E38EF81B703E12174FE344115ECFE3F778D0005FBF8F6DF4033F8F6F6D0119FC6809CFE3DD4E2067F1F0FC6980F119FDD8D07119E3DBB6CC2A023D471F9FE55413EA38F6FBF6D00CFFCFDBE3E34E207A8E3DBE541DC47A8E21404E78F8F6F8507219FDF8FCE8067F1EDB447BE808CFE38FE3F850139FC6808CFF01A0273F8850988CFE3F3EDB36D0A33F8FEB41DE467F1FD7F0AA09CFEFC7E7ECEEA83BC67ECC711EDF3A0E4467F1F80D0139FB77FB36F6DB4033F8FCE8067EFDA1F1E34033FBB1FBC77529C46433F8EFF007FD94047A8E34033F8EFEDF0A0273FF0DFE1405BCE219074BAAE1772B98EA984C205CB28143714A1894C3CA528601ECAF4ED752B966DAB56E31D2971AFBF3E279D73A6C2EDC95CB93955F77F3C8B6E65B358F59245B9D5318C98A8A0AA621B0013729000089A787F08FB6BD5D86E2F6EADCAE5C4924E8A95F6E6DF23C8DFD8B5B59C6DDB726DAABAF7D164B9330DEAFDB974DE1A7D3F0D63DCD23695DC640AEEDE998E7EE23CC5926472AE93176E1B0E61184990A64151C0D960A66014C24001EE716D60F13E37D5DD37AAF57F4FEE367D13737369D5B4EAB5721270F9E38A8C9AC74CFE979D2BAA8DAA1E7B45F42BA9F7A95ECDEAF6A98AF3A68E7658A43F7096BB5F7AF3A0A8B22CC4D4C093D33349E729962372391513C40A721B6861E5C9E6CFE7EDAFD8CF53F5A53DEFABBAA6ADF7972D0B5DCBF2D547A7CCB97328A951C9414EAAB49267697A3B95553D2A52CC91B4FF00A4EE1D3CB8252D4B8924A2C5833989264B729A608E884C892905532022ED4050E71591E71C087482AC13A761FA87D9FDCCE3E967D1B71B4FDA750E9FB89D8BC9434C6E4E2FFB9A96139B4B4DC756F546B846513B619C1E3B3E7F0ACE8CFD5AA33829462AC8CE0EFA518AB27383C7EFA518AB19C1B76FE34A31519A1DF4A3E04D43343C43E35285AB35A6AA7984CC11CBE62E6728801B9310E6E511010C79770EDDB527AD45E8FAA987F02C5AD4B57D35C7BB897A0DBCC443C8E1C863B844C89C3DBB132ECAF9F5D5F70BEA8C3E3F99EFBE9561AAC652A77AFC8AF34C5B37490154CA8245E429CF801B90047940431C3CA5D81C02BCFBD73CDB8EE529A9D7F1DF99E8D9B6ED5B56DBAA4B067233F8E3DBC76D6A360F51F778F6C6807A8E3ECA0CD0CFE3F3FBA8D019FDF8FCF650145CFD9BC47B7DE141C47A8E3DBBE851EA38F6C38508057E23DBC680F243EB616C45DC9D0ADE326E5BE1316B5D76849DBD2E9B745D3A847CFA4CB0CE5D209AE4512141762FCE8B8010C45B9CFCA2536060E7DCEA56EB1FA93239685567E7F37DDC9ACD6ACE7A48AB0E36F882731ED9FB09D8B8C9A8F17865975DAA88A08319DBA8E7282AD141031D04C4C60C0003661D3B3DA6EEFC3E54CC3F72BF1FE8590FF57B5521D24D7B93A77D4B856260C48F8F1373B76AE83FF488AB236732485201C071030E21DF59CFA5EFD5CA24C79EBB4A49FA8F8766DC1D5C168DF51082A2052AE78E40ECF78008A6AB872D9530A7BC4053DBBB12EF0CE7B7DDDAC64997F709BA71FC722A2DFA90D3E58E521DE4C31102809C1DC1BC508A0E20555429631794FF0075298E504CC554444C3E60E501C34495FBBFA32AD1B58FB49E7C5AABCA864642FF008B15D64FD6B822C915B08A2B309449429DC3521D10037A567919C621CE02750A6001F2ED02857B17F6572EC6FDCB4BFF009118C54FDAA88E59EFA1E4C2F7FBDB5EE2E26F7AC4105240CFE35132A25322459560CCCA2C890C0D95448E1D262540A4C451C0C029E5872E0018572EDBA7CB69B45D3F718DDB7569BE3AB1307BB82BD3B1C214F897BB19B68F1044ED1541E9144416228CDCB7725E648A93450AA9D33AE532A52903130A9CC380ED1C44079EE47CA744765A9A9C702AE9BC04C4A7511539479BCE60530288944000441B951DA2386D503DE3B06353943547EA46AD3285DF31E46FBD924104080B0A3CCB0086510A0B19528EC128A6550E26012EF0C30C37ECAB0B9B9B79236E2DD515FB17527506CA76B3EB0B50B506C37EE8A9A0A3DB2EF6BB2D29070520289B7170AC0CEC438760D857318B98A1B971110011D83BBF79766B45E82B96B8C64934FD8CE985CDFB8E8D95E959DCF092746BDA9A3D3CE9B3557AEED6181BA26ADFFA87F54364FF00483D64C1163727505AAF73B05F3E15FCB08961EECD4D68C966C53C7822291505CA605797947100AF3F73D35F54FD3B566CC23FF4C7F2109757DA5CF3779BA95C9D716DE3871AD6B5EC3CD4EA23A85D76D6ABB9273AFBAD9A81AD9376336B86D6B6A6750AE6909D5E2A1CB713C4E510834A44448CDA4CCA47A6E57210CAAEA0953150E62244E5EBDB74FDF74DB2ED5CB96FCA79A4A29FC05EB36B732FDE394A538E58BEECAB4C8E8DC70194B93055404C4CA3F540C088AE054CCC9D009CA990E431D4200E24DB8730062060C4A3AA7F51ACEDBF49FD28EB6F5A5ABB09A55A23674CCD9D6978025FB78B36C8BBB57486DC9F7D22923785E93ABB986631F0AC19443F72911455BCBCA28C0CDA319BD765CA5B99C2AF4BC8A7E8E3D2FF004E7A69D24E88D8FA11A50C9D216BD991A549C4B4AB8F5B715DB7039C159EBC2E9911293D74F5C0FF00996500854DB354F2DAB4490668376E96E8A505A56489C399D80CFE3C3F2F655180CFED8F6DF41C467F780EDEDDD4EFC80F51BB6F6FC6A038CF088BF66ED8B92F3B778D9768E09FE741CA464562E3B7F8933887BEAB07C70755761BAB0EFCBAED97C450CE6DE9995895565999991DD8B17476E57C0D8E650C9A2F93202C9798E5326A1440C628808F9D2549B5C0DB14B4E474655764030940E2070C312F36001B3600063E15B2DF1460F3A1C71584C3889C36F889B1E1F2AEA8A5A4C414F88E3CE5F70FCFC7656545D80E626A6EC440D863B436887B06A83920B14C200730987600730E20180F306003BB01DB405D71B7BDCB111A7898F9F76CA29633A4D466911998A29C8A642482219A5E73A4FC850058A6D8A00014C02000145171C5E5275C79666B77D465A12AB2BCA6A9EA338594557BDA6945175398CB7A96D9A0A18AF9982E2730F367E5DC2E8FCDFC5CCA2838E273639CF756B735504939E54E140AE4A5828FC0E1495EF78CE3245A4B5D53324CD3395749BBD726511228075554F900AA0A65140CB9C082001CB88E1586971F95E666AB4C732D822E0052100A44C8000502907CA001B0A018EE0000DDB82853D9AFA3F75476E6875D7AEBA6B2710DA5EE4D708ED235EC06AF5D0B34E7A6B4BAE2BA5CCF5931CA36E65A62F49AB46FC76FEDB8A50C8124E4A2148F2AE9BA92609AFEF7A6BA26CBABF5156BA8DD76B6EE4956B44AA9E3279A8D68A4D27A5372748A725F2BEBDEA77FA07405D4F6D595DD2DE959B6B8538B7C171C962D23D7E7FF0052BB1239F3F89908DB7D9BB8C4E41B3B6C9B3D4D3C9A12F0790D8F0AAC7BCB4E196661FB902E8731D4070244C015FE673807F4BECFFC7AD96FEC4676B712FDB4A89CB541513CDD537F4ACFB5FD2B1C3F8D6FFF00969D4769B996C3FE3EF4E516D5541B2D398FAA4D92D5539896246CDB02A8D9CA8F19B2B845BA2A260B11F26F19CECDC10FAE6ED5BA6444A55DC10E6F3E0531B94366FF00FC6FDA6D364AE59DFDBFDB45BA6AB91727ED8D70EFC7D870DAFF002FBAC6DBA8FECE3D0F7F7F7171FC9A6CB715DB5AB2F0B3BEA02AEA4C0455E5674274CDFD10AC8C6455C52B755F139073164BA9C76ED2670B705B3E8A41C96E4769C73C593668395D75134D25084E57241AF9AFFC5BE87D8DA9DBEA3BDDE4AF413695B765A9D12748CA51A275745AE50ABAE344DAFBFF00FCD3F70775085FD86CF6D6B69769A95F8CD4E2DE593F7D3DDDB87F516E59DEA4BA9BD04B7EE68B89609591A5D6ADC1745B76FC149B6868497D40597D507E83E8F98545EA057FA6C95A6D9D8BBE537AE3F29930129110FC03D53D3FA574EF515FD97469DCBBD3ADCA9195CA6A74AA956987D49D1A54A50FE9AF43EFFAC751F4C6DF7BD7636E1D4E69B928574E2EAA95C726B89E9782C01861B0030C003661C3757947D4B273F8FCFB6141E051105BFE22941C77C2C007C1F5CA3FF8D4056FD46EDBFA6FE3DF41DC5B6B5E11ADEEC6166AC5764949383909F62B0A45060BB58A78C593E6E45F3733D72269148FC9C98658E3CD88614050A23556D49A4AFC59939720969CC8CA46DC675D122604562105977ABB41058E0E1A145B2C994E224C5448E18000634C4158B6AF16F742093A69153AC1A2F0D0336D5D4AB02346EF1B5C2D167A8376CA91C2E555F3049200769FFE64CA10311C7650536EFD458FB3DF5BF18B43DC33B27731A4C914C2DD62D9F393FECED9176F8EA95D3E62521136EB0183011C701A83C0E4435F0A4B9E3D352D2BCA18CFDD48B50199896EDD36611CC9B3C074FD56D20F136AD1FF00A8C96C611115164CE5C00000440D77A5F71F64308E7D20C65E4C65A6D8DBD1EC611AA2F1FB993922B83354888B874CD312A9E9CC18F3EF10A036AD5D4387BB1CCA4620D6621A7213D29E52DFB8A3CD192ED5B3E29CCC5F151CC5DBBA62EF28E0455055420188251103061405C469AE5994A1FD0499B3631793FDD4AD71864F21D366BFB7AAFB33C926B7A8CC4D2E4F32499CD8F970102A42BF10F776E35422876D5D5157642B2B821173B98B7FEA7D2ACA20B3639FD2BA70C96C515C84589CAE1B9C368062018EE10A80AEE7F1EFA0233FBB1AB982416E3F66FF00C2A3608CFC7BFD9F6EFA641A273F8FE3F6500CFDDB7F5A019FE03B31A023D471F11EDB77D078139FC7B77F7E38D3881EA38FBBBFE7E14033F88ECA107A8FC38D0B419E1E34C40CFDBBFE3C38D0319FC7B6FA731500BF1FB87E741CF88F51C7D9F2A0F119FC7BC3D9403D471F8F1A0A0CFE3F0FD68067ECDFDBBE8067F6C78F1A601E233F0F0F953304E7E3DFF3EEF6D016ABD8D76FDEACB9D449148440A4E61139F90850280810B88606C0476886FAF6B6FBFB1B6DBC6DA5294F37C155F37F91E2EE3617F73B895C9351B7C2B8BA7E3994A946494715B815532A757379844008500265E1CA5DA218F3F788D76ECB773DE395528C634E79D7F191C5BDD9C768A346DCA55F853F32919C15E851F69E78CD0E1DF4A019A1D86A50A3343DBDBEEAB403382946067076EC34A019C1EDA51819C14A0379B09167282471102AAB269984A218814E70288808808620035AAF4A56ECCEE47EA8C5BF72A9B2CC2372EC6DCB08CA497BDD0B81681503116EE53387F95529883ECE72F3808FB82BCBB7D5E0FF00BB06BB9A7F0C0F52E7489AFECCD3EFC3E38FF02E668B2C56C8117C0154D32A67DA06C4481CBCD8808E3CC05C7DF5E35F76E57A4EDFD0DD561DBF91ECD8538D98C6E7D6924FD87273F8F61AD46DE233FBF1F0A0EF19FC7E3F2A019FC7DBC7D9BF6500CFFC37D0119FBB6F6EEFB683028F9FC7B7861C29E0388CF00EFA78019FE1B2808CFE3DBF11A03A61D7FDA2DB537A59D4BD365A05EDC0BDE6C1AB0669B1978484560DD307A84C36BB177F3CC6559923EDC771E92EB948D1CB8549FCB453CD390C5EDE9FB78EE7770B32FA5BC7D86BBDFDA67C84C9FD3ED48C41C46DE5A8F7CA51E847B66F1EEACAB5A024D378A91DB97E633A6974DC50E9A7085178B8A4529F1555314E2A27CA5686FBCDB6CA3B78D2D512F61E6E9661577D15C63031D3B635DEEB860209CBCB3DA12D5BA0063009795D3FB27511C2DCA701E5C53455131870C301110EDF224FE6950BA5AC5E4539974C1AB505230E665D406953B8D6922D165DBCA476B8409C199574CCE901889DB61C453B178DF9923219C2DD7038A6A2844CC639796FECBCC58242ABB0B4AF5FA6CCFDC91B251B647539A553683D15E419B59BD3DD28D397282E52BA3326ED1F41EA3DDF2D1CCD92AE8ED9470466BA8B247CC5DAA8250C3CA9746BB29EA846B24F22A71AE2B02253A04EB26E37AA49A44E98143BF9DD3C93997DA5CE356A526DB12CE51A3C142DE6EF9947DBCE91926270FDC5279288B97640501B24900810DDB6BA7F5385CBD38D95AF71A75BAAC74FD3DC6995ADBAB71853F4E0DD17657F9943BCFA7DD74D21928436B4686AB2D04D66272422A56D28BB8E4A7DF1DA593210D14C6E8808C1BC0B0D06F6E09D2AEBAA128D451680A6594CE0A9107A7FE2771BADDC6FEFACAE6EABB3B11CF38DBF325752F9E54ABEE3A0129D3CE832AF1634B3FBF6C99B7EF8CE811919B518C70B87EEB39E3460CAEAD1B8976D1B375C41344AAC99D4147CE650D80F370750E816252FD289D36B72E382EC39905D2FC3AAB14D6E75153502CCA2B0A4BC75E5A6734F8A994C001FF659757F4F85215A3D405885150A63E225FF00647CE5D12EDB8B7933B23B8775A52FA59451D27D526B192D2CCF5D6E0791510F1D033713C8CF20ABE6ED229291FF00D5157175C4A8E1655414B24AE151484827CC139144D2F077BB7DE5A95212C0EB82D2B02FDD2975735C765C1CA495E17015E3A66BAAE94523ED055038924241A105332F64AAA10A622250C0C388806FC471AD0A1795A729BAB36CBE6819F2DDBD35A6CA2B90B2B579E5BA8BA54ABB86CCE3E4E31078A90BC853BC46D1BDAD066E0E527F088B41C07B8368D688B70758B699C9736D6AEE13ABF6B304DE8FAEF072A3C9B9886780BAAE9DBB5195BD2C83C74A3831D67AE8CE9F5F533CEECD898FCEAA0B088ECD98F30687660EF2BEEAEE2E6FC0DD6A2ACDBF2ADE1065ABA5D6ADCFA917D30B16CB8873755E5763F6B6B5B700CCAD96772D72493E423E3211909DDC795D3F9755E112CA214F89CE0400C470ADEDD716647E921F4ECE8A2C9E83BA6FB5F4AA11BB779A85368B3BBB5C2F50915669C5E5AA7231AD493EAB3975E2201652CFB74E4FDB6050F42CC528C6E9AAB2467CBBC5D7996233C0EF767F1DBE341CC7A8EDF0A059939FC7C3BC3652A07A8E234C011EA38FE61F1E141DC33FE01DBDC14453E737EAC1A6EBDBFAA8A5D8CD102B1D4187692C928714F2892CC116B072CD1B264290C07760C9BA8A1CE06C855E02A53627129786F46972BDA8D91781E0ABC722D9EBE48FB0C9996206600738191399330976638089479443BB0AB6F8983FA99C22CC22A00620513600023806F28006FC31C76575C3E931374B24908F2954290FE06286018EEC070E3590398949193DEA14C186F0D81E3B83605012596298711397111C476F87DBB280E404B20041159421522A9873814E7031325439DBA628193709480948632789B904B80EFA8E7E66DEE359DB9457FDCE86DFD050D52FA8B8DC31B918326932FAD5B959C7BE51F1DABF7B6FCD348F70AC2BF7ED661A73FA576729183F8A7245CD8882493631CD820A0576EEFA54BA54B77297FF00515B6FFF007157F89CB73A86D2D7614E23D2139715014310390EA1C0A073A89F91431F0490290FCE51C4A52014A3B03100011E473D7F376A3285E85F8F9B6FE966E0CB1444BFCC010E23F0DF50CCE40CA223CC0754A5FE5179440701C4AA8285C36FF85528183C0C003BEB7A94768A1BBBF75DA82754EB439373D2F6BD562EC7507AB6DFED7F933D68E893AC0EA76F4D66D31D219DBBDEEAC5B12669717896A2442978BEB76DE8F8872F9C4EC95DA53C2DF8EED28170D53445034DA89A2ABB4516FC860499B8FD2B63EBBF5159E972B5D226FC875AC95555BAD64E9855D71966F8B27A77D09F6E175050B9D22DEE2F3C2BE5464F2E155C382C9761EDD5C8E27E1665CB58FB9AD48B6C7630EE518F97B15BC94D46339E8386B8508A9472CDDB660EE5E0BF73F4CBB94504135D748CA9534F9F90BFCC5EB4FF00262F7A67AD5FF4C6FB73D4E5BBB346F43AC7E64A545DD5A1FDBBE88FB3DF6A373E97B1D47A97A73670DDDD734A6AD42324E13942B8D5C7569AA8E344E9A9B4D966B2B665EFCD67B5224DAF53AD646E33A76D3ED3B88B7A398C52C322F45A9EEA058E4FEA58E419C40E7919B57E8B5907ED8AA1C00C55447E5FD37F7EB7FD7BA92B3663BF9C652A629BFE25F59FA1BEDEF40E837B772E83D33442DB7153B715293A618D2B87174C163C8E4749AE7FD4BD4FD78EA05C35016D7D5E52AE6D85D4719ABB583949378E2223072942A6278BB359C3B637327801532894404C70AFDB6DEF2F7509CB7B7E1385C92584B06BBCFE35DC2B119B8EDA0A1653C12492F72C17723BF19F877FC7B00D6FC4E7273F6EFEC1F753802908ADFF006F490E3BE22103E0F2E0EEDBE34055F3FB7B77D0183B59E592B497D3FD4B58045BD9F7339632C38F294206EE89770EEF9CF80F214B2C5607C47CA062008EEA130304CEB190B56160ED5309D095D75D3EB7ADB92CB03014F78B9BC5A2F752E710E63247521F515FA82636053919EDDA034299B628F388EA5EAEB2B554896EEDA5BBA468C6A3369BE5E21B2044AEF22C4F4EC5741C14C2D93C0A2530798031C4028114ABD1A5DD277C68AB391B89B405C665751CCA4D5A51ED9641148904D4E44DB33BA9BCDA022B3628114150871C44449CA38080155926D3111A91A34CA52E794B9D6557D4854F2124D21A3D6325FD32C725A99B4046C4B05136E7298C53192153138E261D983207335C5691330D390893B22C9FFAB5670B13C911751895D72CA6499DA6D5449C1DB81F0E602180C21B8429CC160EA6DA53A9C53DBB2EA9F457B9AE0B8B4B2D64CF6AA0F20D941DBECEFB6AE08DA3955DF3D915DFAEEE55659472A1C040C252908529768778B9E1632D1BAE761EDF23A651E5E9E7545F8A4A48C8BF5147EBCDDBE655E2AEA45DBB74ABA39B111398E26C4447BC6A8386CAD5B7E183A7E958F626464EEF41181BB240CEDE387971C3CAE9BC9BC78C265C3870AACF9BFAA6A999229C47D3F2172B900A001016345C73381D11B117B7DBC646AD775F6CA02F77CF6464E3D8B88446E1BA51459CDBF8F50EF236356956ED59B83A4041122A2438814C61A02AD7359D2F6BC64B350796A5B511373FA4E916D6D3E989827ED8F4D7D35416B89A20F516C30E69364E41313205291551B94E2026011A03B7B6E40C35A71A588826EAB56455D672622EF9FC8AEABA70603B85D67924E9DBB5955CE1CC6131C7136DEFA0E057BD46FEFEDF1A01EA07B776CF6F1A0E1CC7A8E3876FCA807A8E3FA86FA635033E8067F1EDF7D0833FF1EDE150A33C3C43C7B7BEA81EA3B71A50219E1E23F1F7E1BA8067EDDFC03B05320F98CFDFECEDF6D00CFEEC7B7878D39819E1E3F01FB37D31F60A8CFD9BF6FB7DDF2A01EA3F2F6F850AC0B80F1EDE1F3A1067F1ED87DA34180CFF00D7D98500CFE3EEC7DF4033C3C787BC7BE800381F1C7B7DB4CC139FC7E7F6FB38D022852CD977EB372A6252A6421F98E61C0A1CC62EC02FF118440BC03C442BD3D86EED6D6DCDCF19B6A8972A9E66FB6B7773721A29A52756F99C4731ADDAB07070132AB814A6CD30F2817954273810851C0A025C77E23C6BA2C751BD7F7708BA46D36F05DCE957FE869BFD3ED58DA4A4AB2B8966FBD568BBBBD96D904EA1CA9A6531D430E052943111C7D9DD5ED4E6A11739B4A0B89E2C632B925082AC9F020C614CE621FCA72984A601EE3147010D9880E0348CB5454A38C5AAA1252849C24BE64E869CDE3C3EEFBEB2C4C6A3303C7B7EB5311519A1E3FAFD95710D9B862A85488B1886048E23C8A6189444A22025C7B8710DC38635AD5C8CAE3B69AF3166BBCCDC2E282B8D3D12C99538745176B2C45CBCC42A0386D12894E639794C025101C7001E15C5D4771736F6E32B6E9372F853FD0EDE9F62DDFB92575560A3F1A9CD522544174966A7CD21154CE243881552814E51D83B087C00BFEC8D72C7AA42EDA95BBCB4C9C5AAAC562BDEBE2754FA6CED5D8CECBD51524E9C563F1F817567F1F11EDF0AF0FB8F6E8057E388ECA7813C4678F8FC701F6EED9428CFE3F8F60A73033F8D0327D471A0233FC07B788500CFDBBF6FE3C7DB4E03C0A2E7F87DD54139FEEEFE1EDA8067F1C3B6FA019FC78E1D8680B12F6D39B0F519B22DAF3B7194C8373A476AE45476C24DA19132C2919A4BC5B96328D453F50A6196B170054E01B0E6C73B776E5A96BB6DA92E288D570663F75D396953A3915042F841549A919A429EABEA92AD8ADD332A7210D16F6F07710BF299511C546E7C440A23FC04E5EF8F56EA10CAE3A7349983B56FB0C7129D1B69ECA0984F775E64FF0078CE4C1785D1E973112CA5531666733DA532920AB730A807E632E2BF310BFCCE5E629BA21D7BA845D64E2D735F9331762DB54C8C63727D3FACA95497246CA5962B99250ADDDDD5A5A949384953147914546C4BCB4C416201BF88A5CA130620062E38876DBF53EE60D6AB716B936BF335BDAAE0D988253E9AB1EB9CC0789D2B9A00CB12398F77A8560980E998A6299266E5F6A7FA4129CA060C1C29E6001DF8183B5FAAE1386895A924FB1A7F918FED5F0661C9AFA5D3622AB2A7D364D42828B26D4D63EAC425C0B19B9960123959B5F7A6BA73E91DA85294E704DE2C6218362A712808EEB5EA2D834B5CAEC65FF4A7E0CD73DA4DAE0D9441E80AF1B6973961075FACE629094C57714A5992CCC45444A610458E9F6AE8CE2840594E4394CC5329D62E61804800A5762F5174ED3AA1765AFB1C5AFE5F139A5B2BBD9567124BA6DD5FB6E3A457FF0055356DE22C5B9967D117369DEADBC41D3522447398815FDA1A85694C3C3A6602188AAE21BD31129B100E88F5ED9DC4A5AE2611DADC59A699D33D7EFA54F557D47C433BCB4E6D3D1E897A99A3D9CB0DF7165D15BB251BC1B49264932B52CCB774A9A42B7602E5E1CAE5FC81E2DCBE2265324ABB6862A8E3CCEA1EA4DBBB6ECD9AB976AA53DE7659DB4A2D49E679F331F46AFA96A39CD12E9A8B28DD74DEC68AF05AC9A0252354558F70D11748233BA9F6F9CEC0A20428220091C0397C81CBE5F8FDCEFAF5EC5667745533CCEC95ADFDB85D5E587675B71903AEDD3A5C32BFB343BB9B6B301A8D67A10D3D20D4CFEE6808B978CB46FA567A1A0A6DE2CDD9C8AAD592F26D9222CA3462738A05E2D57AB4AFC8CD955A6859B73FD10BEA2F6EA8449A5AFA317DF30094CE2C5D5E38354C30C3131B512DDD37746110DD8203591898B1F7D0EFEA2D73AA464F346EDE884C4C24FDCA4757F4BD66A914D8F32A258DB8A59F0A7CB8F9410318D8E1E5C79800F7C3E951F46AB47A089A93D6AD51B8207543A8A9461210705310ED1CA96C6975B129804B465A2FA61A32959299B83CFEB24CED591C1AABE8CA999321D65C0F7373C7C7DDF6500CFEDF8D00CFD9BC70F6D31033F8FEBF88D321EC19FF0097B3ECDD44067F1F763C37F777D0005F8F6F9D3C460759FAB1D048FEA3747EE0B2045B35B9526EABEB4259741150594B2629282CCEB1F2D74184CA680377394AA226218398C240314D8CA2A4B1CCB9647C4175836FDFDD2D3DB859EA9591765AF36D1329D164FA1B94EED15A750812CB428A0B24C26E17F7A5D1401E3176EDA18AB104A5122841369D34E00E8121D519D9E2456D99F5884F2E6A51720B14E60FE239144D37041E73E23B0D800F7170E50ECB5675413A9AA4DEA2B2C7AA007A554E16DDC68911011115622439940001D841334C444076056DFDBF3FC7B8C6AFB595182EA75B4D3F4E2E3ED4BD9D49AAAB76E84534819076F1F3974FDAB666DE39041378EDE3C726328064136C65488173B2C4B81C752DA4DDC72ABD2353CAA6C4A75476B424D961A5DCBA6AF8ED219FAC9B74179116E94FC3C7CF3441D9A3917AD994A20CE49323D642722D1EECAA3659345645448995C87971C4D91C8A87FCD96949D2391C4EA8B115E768B33796B4DBC41CA61CE9991549FB69913266131B10C30F30E3B446B8E3722ADB8ACA4EAF9D1E15EE24A35C7817D42F5F3353D2CDAD58EBCA7E4DE9C2EB5A359483A9B6A7594B8AD8771375B66AE6E07AC123AD73D951E68F72D1B9957536D8A9C6268B95566CD95F4617AFEF3CCFDC4A53F369AEAEBAB4FD35EDA70386ED8B6DE315465A6E7AABB71BB83375DBCFB77045CE459AFF0049CEB606EAA0714166A2D3F6F21A3CADD5209320E522A8F2F228529C0C50DB2DBC62F4D323AAC4ADDAB6A1149246CBEEA9EDE64626631B8705BCE98A10338A0140439831FF007211C36EEEEAC7C98F6336F9D0E4519C75750AB72A6D984DF394CAE0AAD07289144E4480C548C99E384404436E03BF7F7D68DC59B77E1E4DE4A76964998369BAAC8EF1F4E5D574B92D4567F4EB50EEBB096987ADE32E66918B3D855A4968122CE1B1644AB46023250F83AE4324B73A58888086D10ADD62EDDDB5AF276F270B5D8B236D8DC5EDADCF376F270B9DAB03B851FD76EBBBD9D6EEAECEA2F508ED1FBF07B723B88FE9D7136EC5D2CE14915DBA8E62D822F1D3874022751458C730EF1C6BE537FE94F4DF51DECF7FBED96DEEEF26FE69CA29C9F7B3E96D7ACFD556F6D1DADBDFEE63B682A462A6D4525924B2543B89A1BAADAE3D505CF15A79A65AB3D4A5D76C3E4A410BF139FB9A65B5A2AC43E559355D95C30D6ABE46DA563D48A70415024DE188E575F904114F984FB767E9EE89D3E4A7B2DAD9B525FED8D0E7DF7A9FD41D4D25D43777EF24A8B54AB8761F489A59A7B01A4D64435956F2602DA39129DF3F326523998955134CAFA55E602222B393240521798C082044D12082699003DA6DC9D6556CF0AADBE6643CFDC1887B7EEC3DA350788CFEEEFA029692DFF6D480E3FF00F17101DFDCEE7071FF00A54152A99FDF8FBB8507238126CA2E698B88C998E612D18E8130751F26D1BBF62E4A92A45932B868ED355BAC09AC914E5E628E0728086D00A0AD590ED845483860EDFC6C7BE7714B9DD453A78CDBB9711CE544F28EE182EB247559AE7487944E9894C25D8238501B89368F41EBC91419334642453688BF7C93645378F92620B0314DE3A21017729B3072A6514E6302607372E1CC38812B368F72ED93F72C99AEFA37D47EDCF566C8AAE987AC4810760C9C1D332CD7D522502299662F394301C4365010B368F72ED9C83862CD77D1BEA7F6E7AB3641576C3D62408BBF46E4E432CD7D52250229C862F39761B10A0F10F1AB090F4A0FD9337DE85E2320CBD63545CFA4906DCDE9DF35CF21FD3BC6FCE3C8A93039711C0431A7301F356124891BC9326720DC8E1B3B4D07CD9174891D325C8E59BA224BA6A10AE1AB948AA267C00C43940C5101001A0365CC7443D70A3B79171AEDD2B1AE61D572E98B570E14887A74D47916A2CAA4754F1AED544A655011149431404C51C02838500C7440962C83151A2583310F0A4164D7961CE9B53B14CF16029611E723250C89452E4C1230903CA2214A0290859D66B63CE1DBDAB6F243736DB840B10C3926FCEA28212898A0247C07516398C0A0180C73098711111A0C123622EC5B1211B2ACA26CFB663DAAEE59BD5D06D0B1C422EF23970731EE960C81CD5E3DC941440E389913873104076D3C017867FDE3F86CA70033F8F6DFE14E4067F1D9DB6FBE8067F1FCE818F51C76F7FDBB76D330017E3DBBB750770CFF00F6BE7DF86FEEA6218CFF00B767CF1A000BF8D0780CFE3ECFBA810CFE3876EFF6D00CF1EC3DB7D060057E3DFF009778D4033F8D5CC0CFD9BFDDF75388F000BEDDFDB1EFA019FC7DDDBC442809CFFCF7D0548CFDFB7BBC7BF68500CFF77E1F3A0C867F1D9EDE3C7DB414A815FB76E34033F8F1E3C68380171F2E3DBBE890C467FBFB6FF7D01B4B9F390591C70CC48E980EDC0A2628800FB0A235B2CCFCABB1B9FED927F135DEB7E6DB95BFF7268E3B36E8322609E06504303AC6FE33700FF2976EE0F7E35BB73BBBBBA97CF84382E1FCDF3F034EDB696F6D1F9719F17C7F9228722D8EAC880241FF00AC9414C7FC24128F2282610C700010C47DB5EAECB77086CF55C7F43A737C553C3D8795BDDACE7BC51B4BEB55EEA67FC1FB4E7398F4818E5225C554B150A6D80654F860701E07286C0EEC02B92C7519FEEFCCBAE96E5853825C3DDC7DA75DFD8416D745B5FA91C6BC5BE3EFFE08A743200AAA2E140C53471E501DC657B8043C081B7DB8577753DD3B56FC983FD4967C97F3CBDE7174DDB79B71DD9AAC23F17FCBF2224990A0A02A8008A2A18039436E51CC218176FF0080C23B3E1E14D8EFD5D879775D2E4567DA971EF5C7DE37DB195A9EBB2BF4E4F2EC6F877767B8B9532A656C46C6281932A65218A2002530800622003DE26DB8D7873BF395F77936A6E55EE3DB8D8B71B2AC492704A8FF001DE71D9B6232517326713155E4E528ED3100A27C4BCDFE20F36C1ADDB9DE4F750846696A8D7DB5A70E191A76DB386DA73707F2CA945D99FBCA867EFF00D2B8F03B3BC67F1F6FBFBA8067F1C3F3C280678F76CF7F6DF4C071C467F1EFA0C067F1EDF1A0E04E7E3B31EDB70DF4C8119FC70D9B3E5EDA6207A81DD8FCF6FE14E63C0A3E7FC3BFBBEFEFA019FF009FE74EF272233C7C7DD8FC7E03432E04E7E3B31F77E54261519FB37FB3E140B019FC7E3C787B028067ECC31EDB76D00CFEEEDF0F1A002BF1EDC68BE008CFC370E3E1DB7D0139E3E3DB6FE34033F8D3043319E3E23DBC68398CFE3B7EC0EEC3650548CFFCAA8273F8E3EF1FCEA7813319FDBB77D0B80CFEDDD87CE950467F1F67E1418549CEE387DDD86830233F8D077805FD83EFED8518273FB760F0A66390CF1F1EEA60067F1A0E433FB7DB41C8EBE755BA2B17D49F4E3AC7A1F2AC21A4CBA8762CC43C636B888A1E0C2E54122C95A4EE50114D5581947DD0C59AEA0A6531C0A9E25011C0294E011F2676FF00D243ADCB29DCF16CEE952CC6ACA69D9177685DB6BFD3FF00595B8B86A911AA4F616435CDF6A05C56C347044414162C556CD4E63098E980889436C2EB8474A44A22B85FA607D43C4C399D2F68908F308E26E9DBE93EA80EDFE2E52D948264C77F281000BB80470E61CFF70FB0517239897D317EA2091CCAB7E9D74922DCFA391669C84174FBF4BF819966D65583888785879EB798C3CA41CA0B17CE05378D4C92A928A267037324021B61BAA61C0C343AB6B89D3F9AFEDF2EB2A66524671CD81A9AACF4A1D57BFBA3AD42E9A5F23FBB91B11045CC9B72EA4C62A0C8F9600292267003FC5800888069BF38DC8FCB999C704933022BFDBE7F54E298899745ED0028BD1033E2EAFE979CC241389865178E0B8C9962241C3D311CAE431B609530FE6572C6CC7CB49BC7B0CF0A53899B597F6F475731EE63A5FF00A2B5551B8592EC5CFAB8ABB3A770648CA20082E2E1B3175A8C55CAC51591314A1EB8EA14AA9B94D81842B7589F94CD528A791DA657E933D63BD5DCC93FE956C37726F575DCBE5DC4369C20A3C5DCAA75965564633A998F8FCF50E71138A6890A73E261C444447A67B96E555535F935C7238C6FA47F55C02073F481609CE01B30696D904BC0A56DD4EA8890007FCA3BB7EDAC7F70FF001FEA4F2176B28921F46AEA7EE873188C9F4A49C3C63576AACA36B36E1D3CB58249D394D04C5DCCC8C9EBF4F4A1A399B7699446ED4AD95055532B9872E09D62EE278BCCCD41C551647D5974E7D2068968E685E97699BAD1BD2D3C85A76645C5CCA8BD916BC9ACACCB940AEA7F3E49DB29075239B26BAA0655459532A00022636C1AD2E5575E06C4A86683685E859804A6D17D26314C243081B4E6CF103193FF00AB3080C3E0224EE1EEAC7BCB9190A121E0ADA8F4E22DC8589B7E291131908B848E67131E898E2027324C98228374C4D86D1028634E60ABE7D0119DF7500CFE341E253925BFED77A38EF8E8C0F83998D83F1A7782A59FDB67B3E34033C7B87ECC37539819FC7F4F01A019FDB7FBA99019FC7C71DBC77D0770CFE3D8682833F8D0119FB37876DA34033F8F6FB368D07019FDB653BC6433F8FDDECDD41C09CFE34033F8D00CFF000DB8D3BC0CFE3F87CA81E033FC47B6DA0233F8FBFBFF000DF40482FDB1EDBE9CC71233F76DF67CBE34EF1DE4E771FBA8067F1ED8FE54CFB8ABE233F8EFC786EA133233F66FED8D054905F8EFA07D833FC7E23F7D00CFE3BBB0F7D30033A8067FE7F7505002FC77D00CFD9F6EDC7850119FDF404E7F808D38819FC7C70DFDF4A82DE6F79DACE8CE48DAE6B7DC9992A8A0ECADE6A3953345DC3A4993645C826E0C282AE1EAE444853602654E040C4C2014C015B6EFD0749E735708B84B3164B310548B2798DD65105D3E74CC62F3A0BA4621C31C4A72880ED01A06686F24D5E1153B474DDD11270E5A2A76EBA6B95276D1651B3B6CA19231CA470D5C2664D420E0621CA25300080D01A8645B02CA36172803845B91D2ADC56202C93654CB269B8512136611050E828053880144486001D83418B3520F91728A4E5BAC9386EBA49AE82E82845515515480A24B22A90C6228928988094C0220203880E14153773BC47B7E34A8AF0233FBC38EDF0ED850139FDBF1A034114210041300207318D807F98C22630ECC779871ACA5294DD66DB744BDCA8BE06318C6DAD30544DF8E7F1356771FD4370FB710AC4CB3E633FF001C7C46809CEE3DBF2A0EF19FB778E1D868067F6EDE14033FBF1EDC29C8119FC682833F8F8806DD9404E7F1FC3D9E34033F8E3BFB78D0778CFF000EDDD4033FB77531051F3F8F6F8ECA149CFE3F3EDB7E542119DC787E3540CEE3BBBFE1B2A0C09CEE3BEA0233FB7BF6EEAA0677E7C2809CFE3DFE23EDA132233FF4A85273B8E1DBBB67761540CFFB437540467F1DDF96357BC778CFDFB7B7BB65311E233B8F7FBBB0D00CEEDEDFC069E03B867F1C3F5A3033B8D2A3019DC7F2EFA0273BB7BEA0233BEEABC07119FC7F3EFD814E606776FCF7D3C47019FC77500CFC077E3BF1DB80D00CEEDE2234033F8EFF00678FDB4033B776FC280676EA0F119DC7B77D00CEE3EDA62002FC78634033F8FBBD94033F8FB386DA0E24E7F1EFF77CF0A02057E34033B8D0015F8F6DBE340B019FE1B07B7DB4033F8F6D9EFA602833F8EDF0AA067EC0DBBFEDFD6A66C0CEE3DB86DA0E66D1794ABA8E00C613AC920818310E40220770720814031E611706C768EC00C3881BA0B71D9DB777500CEE340C0AFC7B87EEF951019DC7750788CF0F70D3163C49CEE3FAF7775071233BF0FB7EDA6606771EDECA3033F8F86146067EEE03BEA0633BBB1FBAAF12139DC70F7FCF0DF42F2233F8EEFCB753C40CFE380F6F6D00CFE3FA7C28067F1EDF2A064E7F1D9DDB47C3E541C0676DF6ECF67BF650119FBB6D39044E771DFDBD94E208CFE3E1B71C77D05067F601F7FD940C02FC7B63C38D00CEDDB7DBC3E54033F88F6FB76500CEE385062C9CEE3D86AF11419E3E3E1DB7D4CC71233F8FE94F026433B8ECEDF655F12F88CE1F1F1EDE1500CED9EFA600B3F503F707364DD08461573BD5619E908935D8E954C5137A945AF2881BD4ACDB9CA9F2881B9C430101C0680B0EED9EB2A4EDC64DEDD7906E9DB67763FA34637D31DCC7C296FF00B3CA76C62A00278E43D4022028299622727F0E298F2814287B845CB8233B9AEB756CC3248DE0F635DB7916F02590936FA8974B17443BC12913767868B68D04ADC40C5383831D422986C0397614AC8A3774AB1947CAB0865EEAD433DAED9A8815A4DCA05DD326974E5DC1BF99EBD821CA76AD8B826A242A2B89CC412A6F0057E6D39871A81718C4CAB48CE4D3880F53EAA28D27EA1319BBCF9489F2C830F4E25F3626F3E38EE0C36818C994FDC89424034427A1EDB4E374FEC2716EAD3776B8B719AE63C23655EBE18C4ADE934EE648CE8A2D9648EB9328A52814843A80A180BA25262E749A4BCA27703E335535224ADB7493B944A12220EDD41D3A3A6B0CB3685937D182BBD6E8353393155CA497102E508E6942BC0C99A7EF9FAF08E41FCCC5CD8A12CFD268EA2A6D4B8934197F2966EC1CCD2B1F1879078CB3848638A5CDC80503889C0C34147C0BE33B8D3BF3033FBBF5DDDFBE81E633B8FDBBBEDA6206776EDF8D2BC40CF1F1DDFAD3B87319FE3DB6F75077139FBFEE1EFF008FDF4046777E3DBF5A0E433BDFF9500CFEF01A6409CEDFF7EFF6500CEE3DB8503233B0DC3C7DFBF7D06633B8FCF67C6A5701E25273B0EFFB6AF8019C3E3BB60D30198CEE3C680676CDFF00887DD540CEDBDDC3C37FC2A50219DDD8FCEA019D543633B8FDB4EF1CC6771EDBFDF4A7BC833B8D0A80ADC700EDBA8419DC7E5F2E38D0A33B8F61DB40056F1F1F7F10F0A2033B8D07119DF676DBEEA0233B8EEA149CEE3B36F6F86EA131F68CEE3EFA78019DF678D00CEE3F7D0119DC7ECAA5273B8FCFC284E23383C7754188CEEEC7ECA64C7319DC70E3F2A0A8CEEEC7E7EDF1D9403383C7EFFC28C6633B8D5E038F319FDDDBF5A9CD0CD8CEE23B3F2F9D0BE23387C47F1EC34198CEE3F761C684F019DDBBBBFEDA019DB77F863E34A8C86771EC341519DC7DD8ECDBF7D06233B1F7D0B80CEDFDB753C48056E387DDDD4033BE38F6DB4CFB86233BBF1EDF754E406771EDF780D5033B8FC30FD37D00CEF6506433B8F6FC468C0CEDFB7E7E3F6E14033BBF1FC7B0D00CFC3788D00CEE3BF8FCF6EFA70033BF5EDBA806771EEF7500CEEFC7DDECA71180CEE3F6D00CFE3D87DF4033B1EFEEEFD9EFF851819DBF6FB03B0E14033B8FB2800ADC7F4A8970098CEEE11EDB7E1540CEE3B403C7ECA019DC7E1F31A11E28670F8EEF0F0C3753228CEF976DFB2838139FC78EFC7EFC37D0508CEEDF0DB4033E99F7819DDD8E3DBBBE14EE19778CEE3FA500CED9C3B711DB4196433B8FCF871DB4033B8FCE84A7119C3E3428CEFCC38F8ECD94086761DB7D0100B63876EF11A0349052209CC421082A089D41214A5150E3FE2388062636DDE388D003993539330843F21C14273940FC8A17F81427300F29CB8EC10DA14A035E771EDF10A10676EDBDB7D0A6838A6A188274C87326613A6650A530A67FF310443129B0EF0DB406A154A60129800C530094C03808180404040C038E2021B3C36D390E4426722652913295321430290805294A18E3814A500000DBDD4C788781AB3B8FE7DB1A019DDD8FD9F1EEF0A019DDBF1DB4033B7EDC7DFD836539819DC7B63F6D00CEFBE9DC3119DDB6777CF1A0C46771F0C2A019FC7B6DAA0815B8FC3ECA7304E753C00CE0F706EFC298819DDBBB7D00CEEFF0A788381E7E3BE8523CFF008E3F7517222F88F3E01871F8FE14EE1C479FF1F9EEC38D30185479F11F76FF006F7E355827CFC77054F10C8F3E1C3BF76EFC29C40F3F1DFC71FD698D4BC079FE7FAFCFE54F12780F3EDDFF003A110F3FBB676F653C4A079B0EEEC1B70E1850BC790F3FBF8F8E03548C79FBBC7BFDDBEA2E6079B11EDD82A780E3CC79F0F7776EAC90C2A3CDB7DDE3E01BEA01E7E3F3F1FB6830A903CFEEEFC71E1BAA8F127CFDDEFDFDB754C3D83BF227CFEEE3F9EDC29E2079FEDDFF009D02A91E7EDEDDB85098711E7F7E1EFC3BF0E142E23CFB77FBF1C70FC6809F3E1F6E1EC0F7E14C0101CDB30FCB7ECC698F1188F3ECDF87778F7507780E6E18FBF76341DC3CF86CF75071E63CF8F6F1EEE18D30A0EF1FCCC7EDF67BEAE03C491E7DBEEC37FCB8D427711E7DBBF7F1A149F3F76186DF0C3BFEFA778F123CFB7D815470C079BBBDDE1DFEEA9DE31F60F3E03E1B71F653B883CFDB7F0E3570281E7E3DFE3BEA21C479F0DBDBC37D38E03B879F0D9F3F75071C731E7EEDDB7C70DDB70E14F10B9D490E7ED85061ED23CD88FBB1C7DF47F02603CF8F7F77DBC68543CF8F1C7BA9E057CB21E7F7F7E18E38ECC69E041E6DBF7F86CDF8D1D4603F99DBB618E3540F3F7F8F7F87BF654EE1C711E7F7F6F0A043CFC7E7E3DFDD853C401E7FB7EDE1B29C4635C331E7C7B7DDC29C0701E6ED8FBA9881E7C7E3E3F2E1540F377E1DB0F7638502E44F9F11EDE1F7540039FBBC7EEA7797C48F3E3C31EEC7EEE350848736CDDEFED8D51DE479F8F77B3B63465EE27CFDFC3DBDDEFA7031EE1E7D9BBDFED0C28FE25F11E7E3F3FBF65011E7EDF9F7E1BE8111E7F977E38F7FDF570F68F0A93E7EDE1B7C385443C079FF001F6603BA9DE113E7EDF75021E7C3676DD8F1C69DE111E6E18F7EEF0D94EE2711E7EDBF0FB688A3F99F8FB3BA9C02E43CFDFC37FCBDF4E23F1F8FC64039B1FB3C377C31AAC603CFF86FF1FC2A7805427CFB71F7F6F6D0770F3F1FBFBBE54E20D3E6F76DFCE8091E6EFF000F7FBE9DC172ED1E7C3BB1EFDF4EF293E7E1BF6FB71A100E66DEDE3E1B69DD9023CD87C70F67DB4600F3603EFF008D00F3F1EC1F8500F3E03EDDB4C0623CDEFC3BFF003A78027CFDBE5C298108F37776DA387CE9C0A8073F77DF8503CC9F3FD9E3BF0A712901CFB7DBDD8D3023F880E7D9861BFE5DFEFF00BAAF7E600F3FBBE75114FFD9, '4', 'Vibrant, professional color is now within your reach. The compact CLP-315  printer can fit comfortably on a corner of your home office desk or bookcase.');
INSERT INTO `producthome` VALUES ('5', 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, '5', 'Lenovo IdeaPad U Series- thin, light, travel-ready, energy-efficient and feature-rich laptops. Surprisingly affordable with just the right mix of style.');
INSERT INTO `producthome` VALUES ('6', 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, '6', 'A wireless mouse built for at-home and on-the-road comfort. Say good-bye to the touchpad.');

-- ----------------------------
-- Table structure for `products`
-- ----------------------------

create table `products` (
  `productid` int(11) not null auto_increment,
  `shippingid` int(11) not null,
  `measure` int(11) not null,
  `categoryid` int(11) not null,
  `subcategoryid` int(11) not null default '0',
  `name` varchar(255) default null,
  `description` text not null,
  `picture` blob,
  `price` decimal(10,2) default null,
  `taxable` char(1) default null,
  `onhandquantity` int(11) default null,
  `prod_active` char(1) default null,
  `overview` text,
  `specifications` text,
  `acessories` text,
  primary key (`productid`),
  key `fk_shippingid` (`shippingid`),
  key `fk_categoryid` (`categoryid`),
  key `fk_subcategoryid` (`subcategoryid`),
  constraint `products_ibfk_1` foreign key (`shippingid`) references `shipping` (`shippingid`),
  constraint `products_ibfk_2` foreign key (`categoryid`) references `category` (`categoryid`),
  constraint `products_ibfk_3` foreign key (`subcategoryid`) references `subcategory` (`subcategoryid`)
) engine=innodb auto_increment=260 default charset=utf8;

-- ----------------------------
-- Records of products
-- ----------------------------
INSERT INTO `products` VALUES ('1', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 0x2A6E6D2A2F396A2F34414151536B5A4A52674142416741415A41426B4141442F374141525248566A61336B414151414541414141504141412F2B3441446B466B62324A6C414754414141414141662F624149514142675145424155454267554642676B474251594A437767474267674C44416F4B43776F4B4442414D4441774D44417751444134504541384F44424D54464251544578776247787363487838664878386648783866487745484277634E44413059454241594768555246526F66487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838662F3841414551674168414247417745524141495241514D5241662F45414B4941414149444151454241414141414141414141414141415547417751484167454141514542415145424151414141414141414141414141414141514944424155514141494241774943426751484351774C415141414141454341784545425141534951597851574569457764524D6853306359476863694F3146354643596F4A6A6378556C4E724653306A4E44684A536B4669596E4B4D485234614B444A4851316C6155494F424542415141424241454442414D414141414141414141414145524D55454341794652595A484245775155384F45532F396F4144414D42414149524178454150774275353738782B614D546B31564C783353356B76436B616B784C476C76657932794B4E68466537454B6B3965742B496862587A6735707278755A422F785A5034576D5A364C6849766D2F7A4F7841467A4A556B41665379394A2F4730795946707564764D474759525353305A33534B4D69346C4B764A49575646566C4A4271593234394862706D4745583976756679626342366D364F323270637964397848346851643731777039553866756A544D4D46334F2B65664E4F4D743936792B4E4B7A3749674C696259314F6B676739464E4D7841412F2F41456A7A71656D4A663654632F77414C567944504A2F6E6C7A726D382F426A743474566B6A6D6B4D717A54536B654443306737736A46545572546A704D556178596561755675664C4C4A353871426B4C4578784B314F4264356B6833552B4636367875724C764E39397558737531736E3961334F7456494559336C744C7577677569306C5A6C3355464B644A486F374E5A56592F736D67346870666B2F774257677657664B4975456B64386C4A424E336C43534F31585562545464364F3865424F6738752B536A62774E635235524A33526C41534E3238516B393271315563464858364E4D6A4F6559384A4E64354A676A53474744364E4F6A702B2F505236644D67582F4147586E5545392F674B39482B7A5449492B5642727A74612F774454337675736D747A564B3244427368386B2B59314237776E74796636644672473667766E49314D6E6A2F6E35583631754E61756951417843584679747662525342476454336E5971696851575A6D4972774371547746665278316C566E4A51515731766254323254572F452B3453434B4F346A45544B66564C544967593049504455464B306A764C32376A744C64367A536B686438676A515542596C6E6368564155456B6B366F693539744C2F414A5778596D6D756B6C6E6E3377786D4677364C4D4B64304D47334D56423347716A737270675A6A674D58665A6A494C5A5133456B6664334F34447976786459315649314F35336553525655564854556B4145366F367A754D756354664C4237596271463933687A4C756A4E597057686B5234797A625753534E67654A48515153446F477A796F616E5046723277586F2F716B757454564B31666C2B76325138303866356532393968316A6451767A6E616D5478337A3872396133477431495672433561474F435651724E48526C567875576F39495054724370627A4A7A5843716A4C464645684C4C4642476B53626A774C4549425530464B6E51515765567573666552587471797063516B6D4E6D524A4647355370716A686C5955593949314D344372356938375A6E6D4F3969747236654F614B7864354B78775177316E6D432B497A474645334769714F506271354D46617A7662697A6E38614172754B6C485352466B6A6447395A4852777973703942486230366F39764C3634764A306B6D3244596F6A69696952596F3430424A436F69414B6F715365306B6B3864413865565837635766356D38397A6D317161705772387676384134506330742B5774766659645933554838366D706C7365505132562B74726A57376F6B4C6E4C74764665584D46744B437974464B775866346457534E6E5562747230717939536B6E6F484857465775594D6262324E6E424D69474E355A5A45436D566E71696F72416C486A69644456753064566167365741703555692F586D61624A3231735A34735A595831784C4B592F45686A595773686A38536F4B674D77707831352F7741692B50662B6E62706E6E2B656F46356B5A376D446D48796A35657A4F637874766A4A726E4D585073615774714C534B5333396D6A496C55443177373775397248564D646E6A547A746A30644F323534652F6A366B506B2F4334624B746C6630704C4C474C4F7961347452465042626C35677741566E7541557054587377386A766D72423454473265466E78736B7A793330557A336B63317862584F786F335655437461674B415153654F6D4164387178546E69792F4D586E756332745455725663424449504A6A6D636B6344506241482B66516A574E3142504F34307A4F5038416E5A5836327564627145574F5147425165497030617856526D52525861415067314254752B652B5A634E6258324A772B536C7372504A52624D7248455150465167674B53525564316A576C4F42316D384A6457707A734273787A6C7A4E6E4D5A6A63626C4D6C4C65593745522B446A6264794E6B4B414251463267566F6F4171654E4F47727836354C6D484C6E6144454B656B4468784664625A656F46335641484569704767304879722F6269302F4D5876756332724E55624C68616659547A43333561412F31324C57464B486E6B66313359664F796E3174633636374D6B376C2B664652354F7A664C727678716B2B3072736154687462623345654A6D47366C514847724F764B69766D446D2B554C305739316855564A6B332B324E48614E5A4B554371454777797971783362754B714F4641613676326A4C4F4D54644A466E7253397557436F6B36797973774C4B414431716F4A4948594E6276534C6E4E392F593548497733466D49646F6845622B7A7049696A617A6256597A6653534D716B4465355A694B5650445364496E3541792B4477334D4C587562746F37717A4E70635178704C6152583670504B6C49705462544D6B62374734385470656B58504D584C3870357A4B525A4C6C2B33577843787732307470466152574D626C454A656351516C6B516C6A51393437757A6278665A463379734E4F6437552F6B4C33334F625843616A614D4B6A6659507A424855622F46675873723762454E59556D656562667232793747796E3174633636624A4764713330612F42723648543135347967646C5A5356574564666562344230613763656C59733450483871584F50755030746679324E2B476462554B6A504777614965457A625561675757752F6A78586F303564664B587846655A58466373323967736D4F7937583134435045684D4478436832385157464F4865303439664B337A41453850572F7444304A3368384F70657277484879742F62533250354339397A6D3138614D746F776A7439696E4D585A63322F763857734B5350504E7631375A396A355436327564644C7045685A73635669704D4E6233556B717463534D597A6243594C4C75366D3245554347744B6C7461342F6E632B4E2F784A346B3178342B66564D2B6359763045737479447978615A2B2F77415A4E6C424931744E4448446578764739764C464C475A444B475233707332304B6A63612B6A5865666E396E74384E35517235645965566F42613330453374524357796D3432794F354171705461327A695341575056702B2F326533775A52342F6B4C41333176346B4E39476B685A31437A5843526F646A4D76423237315345336570304D76703450332B7A322B444C74504C33427957346C5449322F694E4D59566A4E7A74725130334269673677656B55376549476E372F5A3766426C6374764B76427A597934766A6E4D66444A6247354457623366307A47324C4475446141776B32315430366676396E743847533535566D764F4E71335257327654542B5A793638735A625468534235466377792B6D6142763639456459556965647065546D47414247576B6D53323768546370796C77775A54316A6A727064496B5A706351546C4E71715458703146557A61794A336475337371426F6A345179673158676653474666336451636D4755394E44385930483367796464443859304833674F656F6664476761764C5974427A5A62794D724D504175316F67337456725752527748773673473134644439674F66536F33623446374B2B325261777046383535503777576C54304A66552B504A334F756D7A4A4E784761746365737A54343231794B796C516A33595937436C61374E76373764337548334E5256544E33583659794B54574F506774415545613264694732634354756F7733566F654A506F31424A61387253534C7575623243334E4B2B476F615A7830634473376C667874427A633872756968726539686E2F42594E4531665233716A3564465359584A5359745874376A43324E36524A346E69333852646C4E556F41775046614965372B4554364E45635832566A624669786A787468456148646552526E3267316B442B73335251446277366964426238757A546D753150354F3539326B31594E6F773166734435675035534433794C57465A2F7743642F7744332B7A375576612F2B537564644C70475370687879724A444A2B6E487534797151725A2B794257366E386263476F50584B6B636654724B754C715041766B4C524D49626772746C39733866674F6B374E6E5874325542336666563671614B6E7435676A474E2B6E30644A2B344E427A6454497361787233614367576848443439455357647879366C6E4B4D7448637A584B6A2F6B6F34583252314F376476593170783239412F77424F69707236546B49343655324B58363554756D415346544142762B6B44314F366E682B715231394F677265586E3755327635713539326B31596A614D4D5038414D2F77445067393869316857656564726633697465794F372B7372725853374D6C486C717774373634755575464C777851463971747449597569626765774D65476F6F374659346533746E61315155494F365370636B727770754E6576564538484B4F6176556D7573505A5435464C5462375762614E7057586457685A5642626A744E4F476D4449666463765A6872654C4954326B6B4F506E4F32336E6341427A3368774664772F69323652316167726D78747A43545054616C647A48674251304A726F422B6473597253473061453057635034677153616F77703868314658764C333971626638414D335075306D7245625268782F6C2F7A337A345066497459566E486E5764334D634148556C33395A5857756C325A685035616E614C494D6C53504769644B447232306B7038657A555566754C7949524E47414172413948626F4B384762796B6865306775707261336E4B2B3152515350474843567075436C6477465453756774706E736C4169576373306B6C6B6C44426175785A45366543676D673964756A306E51584C6134747055496456334E55734B634B6B6B6E6870674C334F736943397462565477676833454144675A5475342F696854714B37387666326E68506F68757664354E5749326A442F2F414A2B7A782F4367393769316857626563524C637878396E74672F396A633636585A6D454A476B696B57574E746B6B62426B59644959476F4F6F6F735A52647847654155326973384136597A36523655505565726F506146764857366253386931464F6E554864314845304354524C51455672516730507072783048735678466157777672332B4948385246576A334444373166775033373941364F6E567959445938427A546D37733351737058653875344C5A706D587734785065727667553139565854764B6155322F467246374F4D33584174793169627A446338793479384B47357331753470476962664778574277536A3047346176446C4F556C685A68723249482B58764F2F444237334671436C35312B552B54544C746B72466D6B73414A584735537A42705A6E6E595658713353476E4457736F787038426B535346695A6A364E72443930615A564163526C494A566B534E3470453471366E61523866445449753239396C59435046744937674131616F654D6E3466435A42386D6D55537A5A724B4D434C6648573174576C474B7954734B656A78336B582F6430554A754C4C4B33633754584A65655A75444F37626A5164412B447330513134766D667A4474376131747261355068327470505978686B615174446355486636647A784B6F574A6A36696967346134337034573577312F71694F4C734F664C7838516B74724A65525957316B73735A46345378424970463230643147352B727034363378347A6A625A756C725A7366794C6E59664A584B59646F2F316A63724736523036316E535138507864556248662B78657A74375A7338436E6533307038756757302B7A336564767375377239585155722F374C7550744873746576316441457550735971642F732F78553046582F414153722F49664A6F4C3170396A6452346673396533626F4744482F41476363505A765A613958713642687450304A51657A65423262647567766433623162666B30482F32513D3D, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('2', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('3', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 0x2A6E6D2A2F396A2F34414151536B5A4A52674142416741415A41426B4141442F374141525248566A61336B414151414541414141504141412F2B3441446B466B62324A6C414754414141414141662F624149514142675145424155454267554642676B474251594A437767474267674C44416F4B43776F4B4442414D4441774D44417751444134504541384F44424D54464251544578776247787363487838664878386648783866487745484277634E44413059454241594768555246526F66487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838662F3841414551674168414247417745524141495241514D5241662F45414B4941414149444151454241414141414141414141414141415547417751484167454141514542415145424151414141414141414141414141414141514944424155514141494241774943426751484351774C415141414141454341784545425141534951597851574569457764524D6853306359476863694F3146354643596F4A6A6378556C4E724653306A4E44684A536B4669596E4B4D485234614B444A4851316C6155494F424542415141424241454442414D414141414141414141414145524D55454341794652595A484245775155384F45532F396F4144414D42414149524178454150774275353738782B614D546B31564C783353356B76436B616B784C476C76657932794B4E68466537454B6B3965742B496862587A6735707278755A422F785A5034576D5A364C6849766D2F7A4F7841467A4A556B41665379394A2F4730795946707564764D474759525353305A33534B4D69346C4B764A49575646566C4A4271593234394862706D4745583976756679626342366D364F323270637964397848346851643731777039553866756A544D4D46334F2B65664E4F4D743936792B4E4B7A3749674C696259314F6B676739464E4D7841412F2F41456A7A71656D4A663654632F77414C567944504A2F6E6C7A726D382F426A743474566B6A6D6B4D717A54536B654443306737736A46545572546A704D556178596561755675664C4C4A353871426B4C4578784B314F4264356B6833552B4636367875724C764E39397558737531736E3961334F7456494559336C744C7577677569306C5A6C3355464B644A486F374E5A56592F736D67346870666B2F774257677657664B4975456B64386C4A424E336C43534F31585562545464364F3865424F6738752B536A62774E635235524A33526C41534E3238516B393271315563464858364E4D6A4F6559384A4E64354A676A53474744364E4F6A702B2F505236644D67582F4147586E5545392F674B39482B7A5449492B5642727A74612F774454337675736D747A564B3244427368386B2B59314237776E74796636644672473667766E49314D6E6A2F6E35583631754E61756951417843584679747662525342476454336E5971696851575A6D4972774371547746665278316C566E4A51515731766254323254572F452B3453434B4F346A45544B66564C544967593049504455464B306A764C32376A744C64367A536B686438676A515542596C6E6368564155456B6B366F693539744C2F414A5778596D6D756B6C6E6E3377786D4677364C4D4B64304D47334D56423347716A737270675A6A674D58665A6A494C5A5133456B6664334F34447976786459315649314F35336553525655564854556B4145366F367A754D756354664C4237596271463933687A4C756A4E597057686B5234797A625753534E67654A48515153446F477A796F616E5046723277586F2F716B757454564B31666C2B76325138303866356532393968316A6451767A6E616D5478337A3872396133477431495672433561474F435651724E48526C567875576F39495054724370627A4A7A5843716A4C464645684C4C4642476B53626A774C4549425530464B6E51515765567573666552587471797063516B6D4E6D524A4647355370716A686C5955593949314D344372356938375A6E6D4F3969747236654F614B7864354B78775177316E6D432B497A474645334769714F506271354D46617A7662697A6E38614172754B6C485352466B6A6447395A4852777973703942486230366F39764C3634764A306B6D3244596F6A69696952596F3430424A436F69414B6F715365306B6B3864413865565837635766356D38397A6D317161705772387676384134506330742B5774766659645933554838366D706C7365505132562B74726A57376F6B4C6E4C74764665584D46744B437974464B775866346457534E6E5562747230717939536B6E6F484857465775594D6262324E6E424D69474E355A5A45436D566E71696F72416C486A69644456753064566167365741703555692F586D61624A3231735A34735A595831784C4B592F45686A595773686A38536F4B674D77707831352F7741692B50662B6E62706E6E2B656F46356B5A376D446D48796A35657A4F637874766A4A726E4D585073615774714C534B5333396D6A496C55443177373775397248564D646E6A547A746A30644F323534652F6A366B506B2F4334624B746C6630704C4C474C4F7961347452465042626C35677741566E7541557054587377386A766D72423454473265466E78736B7A793330557A336B63317862584F786F335655437461674B415153654F6D4164387178546E69792F4D586E756332745455725663424449504A6A6D636B6344506241482B66516A574E3142504F34307A4F5038416E5A5836327564627145574F5147425165497030617856526D52525861415067314254752B652B5A634E6258324A772B536C7372504A52624D7248455150465167674B53525564316A576C4F42316D384A6457707A734273787A6C7A4E6E4D5A6A63626C4D6C4C65593745522B446A6264794E6B4B414251463267566F6F4171654E4F47727836354C6D484C6E6144454B656B4468784664625A656F46335641484569704767304879722F6269302F4D5876756332724E55624C68616659547A43333561412F31324C57464B486E6B66313359664F796E3174633636374D6B376C2B664652354F7A664C727678716B2B3072736154687462623345654A6D47366C514847724F764B69766D446D2B554C305739316855564A6B332B324E48614E5A4B554371454777797971783362754B714F4641613676326A4C4F4D54644A466E7253397557436F6B36797973774C4B414431716F4A4948594E6276534C6E4E392F593548497733466D49646F6845622B7A7049696A617A6256597A6653534D716B4465355A694B5650445364496E3541792B4477334D4C587562746F37717A4E70635178704C6152583670504B6C49705462544D6B62374734385470656B58504D584C3870357A4B525A4C6C2B33577843787732307470466152574D626C454A656351516C6B516C6A51393437757A6278665A463379734E4F6437552F6B4C33334F625843616A614D4B6A6659507A424855622F46675873723762454E59556D656562667232793747796E3174633636624A4764713330612F42723648543135347967646C5A5356574564666562344230613763656C59733450483871584F50755030746679324E2B476462554B6A504777614965457A625561675757752F6A78586F303564664B587846655A58466373323967736D4F7937583134435045684D4478436832385157464F4865303439664B337A41453850572F7444304A3368384F70657277484879742F62533250354339397A6D3138614D746F776A7439696E4D585A63322F763857734B5350504E7631375A396A355436327564644C7045685A73635669704D4E6233556B717463534D597A6243594C4C75366D3245554347744B6C7461342F6E632B4E2F784A346B3178342B66564D2B6359763045737479447978615A2B2F77415A4E6C424931744E4448446578764739764C464C475A444B475233707332304B6A63612B6A5865666E396E74384E35517235645965566F42613330453374524357796D3432794F354171705461327A695341575056702B2F326533775A52342F6B4C41333176346B4E39476B685A31437A5843526F646A4D76423237315345336570304D76703450332B7A322B444C74504C33427957346C5449322F694E4D59566A4E7A74725130334269673677656B55376549476E372F5A3766426C6374764B76427A597934766A6E4D66444A6247354457623366307A47324C4475446141776B32315430366676396E743847533535566D764F4E71335257327654542B5A793638735A625468534235466377792B6D6142763639456459556965647065546D47414247576B6D53323768546370796C77775A54316A6A727064496B5A706351546C4E71715458703146557A61794A336475337371426F6A345179673158676653474666336451636D4755394E44385930483367796464443859304833674F656F6664476761764C5974427A5A62794D724D504175316F67337456725752527748773673473134644439674F66536F33623446374B2B325261777046383535503777576C54304A66552B504A334F756D7A4A4E784761746365737A54343231794B796C516A33595937436C61374E76373764337548334E5256544E33583659794B54574F506774415545613264694732634354756F7733566F654A506F31424A61387253534C7575623243334E4B2B476F615A7830634473376C667874427A633872756968726539686E2F42594E4531665233716A3564465359584A5359745874376A43324E36524A346E69333852646C4E556F41775046614965372B4554364E45635832566A624669786A787468456148646552526E3267316B442B73335251446277366964426238757A546D753150354F3539326B31594E6F773166734435675035534433794C57465A2F7743642F7744332B7A375576612F2B537564644C70475370687879724A444A2B6E487534797151725A2B794257366E386263476F50584B6B636654724B754C715041766B4C524D49626772746C39733866674F6B374E6E5874325542336666563671614B6E7435676A474E2B6E30644A2B344E427A6454497361787233614367576848443439455357647879366C6E4B4D7448637A584B6A2F6B6F34583252314F376476593170783239412F77424F69707236546B49343655324B58363554756D415346544142762B6B44314F366E682B715231394F677265586E3755327635713539326B31596A614D4D5038414D2F77445067393869316857656564726633697465794F372B7372725853374D6C486C717774373634755575464C777851463971747449597569626765774D65476F6F374659346533746E61315155494F365370636B727770754E6576564538484B4F6176556D7573505A5435464C5462375762614E7057586457685A5642626A744E4F476D4449666463765A6872654C4954326B6B4F506E4F32336E6341427A3368774664772F69323652316167726D78747A43545054616C647A48674251304A726F422B6473597253473061453057635034677153616F77703868314658764C333971626638414D335075306D7245625268782F6C2F7A337A345066497459566E486E5764334D634148556C33395A5857756C325A685035616E614C494D6C53504769644B447232306B7038657A555566754C7949524E47414172413948626F4B384762796B6865306775707261336E4B2B3152515350474843567075436C6477465453756774706E736C4169576373306B6C6B6C44426175785A45366543676D673964756A306E51584C6134747055496456334E55734B634B6B6B6E6870674C334F736943397462565477676833454144675A5475342F696854714B37387666326E68506F68757664354E5749326A442F2F414A2B7A782F4367393769316857626563524C637878396E74672F396A633636585A6D454A476B696B57574E746B6B62426B59644959476F4F6F6F735A52647847654155326973384136597A36523655505565726F506146764857366253386931464F6E554864314845304354524C51455672516730507072783048735678466157777672332B4948385246576A334444373166775033373941364F6E567959445938427A546D37733351737058653875344C5A706D587734785065727667553139565854764B6155322F467246374F4D33584174793169627A446338793479384B47357331753470476962664778574277536A3047346176446C4F556C685A68723249482B58764F2F444237334671436C35312B552B54544C746B72466D6B73414A584735537A42705A6E6E595658713353476E4457736F787038426B535346695A6A364E72443930615A564163526C494A566B534E3470453471366E61523866445449753239396C59435046744937674131616F654D6E3466435A42386D6D55537A5A724B4D434C6648573174576C474B7954734B656A78336B582F6430554A754C4C4B33633754584A65655A75444F37626A5164412B447330513134766D667A4474376131747261355068327470505978686B615174446355486636647A784B6F574A6A36696967346134337034573577312F71694F4C734F664C7838516B74724A65525957316B73735A46345378424970463230643147352B727034363378347A6A625A756C725A7366794C6E59664A584B59646F2F316A63724736523036316E535138507864556248662B78657A74375A7338436E6533307038756757302B7A336564767375377239585155722F374C7550744873746576316441457550735971642F732F78553046582F414153722F49664A6F4C3170396A6452346673396533626F4744482F41476363505A765A613958713642687450304A51657A65423262647567766433623162666B30482F32513D3D, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('4', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('5', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('6', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('7', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('8', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 0x2A6E6D2A2F396A2F34414151536B5A4A52674142416741415A41426B4141442F374141525248566A61336B414151414541414141504141412F2B3441446B466B62324A6C414754414141414141662F624149514142675145424155454267554642676B474251594A437767474267674C44416F4B43776F4B4442414D4441774D44417751444134504541384F44424D54464251544578776247787363487838664878386648783866487745484277634E44413059454241594768555246526F66487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838664878386648783866487838662F3841414551674168414247417745524141495241514D5241662F45414B4941414149444151454241414141414141414141414141415547417751484167454141514542415145424151414141414141414141414141414141514944424155514141494241774943426751484351774C415141414141454341784545425141534951597851574569457764524D6853306359476863694F3146354643596F4A6A6378556C4E724653306A4E44684A536B4669596E4B4D485234614B444A4851316C6155494F424542415141424241454442414D414141414141414141414145524D55454341794652595A484245775155384F45532F396F4144414D42414149524178454150774275353738782B614D546B31564C783353356B76436B616B784C476C76657932794B4E68466537454B6B3965742B496862587A6735707278755A422F785A5034576D5A364C6849766D2F7A4F7841467A4A556B41665379394A2F4730795946707564764D474759525353305A33534B4D69346C4B764A49575646566C4A4271593234394862706D4745583976756679626342366D364F323270637964397848346851643731777039553866756A544D4D46334F2B65664E4F4D743936792B4E4B7A3749674C696259314F6B676739464E4D7841412F2F41456A7A71656D4A663654632F77414C567944504A2F6E6C7A726D382F426A743474566B6A6D6B4D717A54536B654443306737736A46545572546A704D556178596561755675664C4C4A353871426B4C4578784B314F4264356B6833552B4636367875724C764E39397558737531736E3961334F7456494559336C744C7577677569306C5A6C3355464B644A486F374E5A56592F736D67346870666B2F774257677657664B4975456B64386C4A424E336C43534F31585562545464364F3865424F6738752B536A62774E635235524A33526C41534E3238516B393271315563464858364E4D6A4F6559384A4E64354A676A53474744364E4F6A702B2F505236644D67582F4147586E5545392F674B39482B7A5449492B5642727A74612F774454337675736D747A564B3244427368386B2B59314237776E74796636644672473667766E49314D6E6A2F6E35583631754E61756951417843584679747662525342476454336E5971696851575A6D4972774371547746665278316C566E4A51515731766254323254572F452B3453434B4F346A45544B66564C544967593049504455464B306A764C32376A744C64367A536B686438676A515542596C6E6368564155456B6B366F693539744C2F414A5778596D6D756B6C6E6E3377786D4677364C4D4B64304D47334D56423347716A737270675A6A674D58665A6A494C5A5133456B6664334F34447976786459315649314F35336553525655564854556B4145366F367A754D756354664C4237596271463933687A4C756A4E597057686B5234797A625753534E67654A48515153446F477A796F616E5046723277586F2F716B757454564B31666C2B76325138303866356532393968316A6451767A6E616D5478337A3872396133477431495672433561474F435651724E48526C567875576F39495054724370627A4A7A5843716A4C464645684C4C4642476B53626A774C4549425530464B6E51515765567573666552587471797063516B6D4E6D524A4647355370716A686C5955593949314D344372356938375A6E6D4F3969747236654F614B7864354B78775177316E6D432B497A474645334769714F506271354D46617A7662697A6E38614172754B6C485352466B6A6447395A4852777973703942486230366F39764C3634764A306B6D3244596F6A69696952596F3430424A436F69414B6F715365306B6B3864413865565837635766356D38397A6D317161705772387676384134506330742B5774766659645933554838366D706C7365505132562B74726A57376F6B4C6E4C74764665584D46744B437974464B775866346457534E6E5562747230717939536B6E6F484857465775594D6262324E6E424D69474E355A5A45436D566E71696F72416C486A69644456753064566167365741703555692F586D61624A3231735A34735A595831784C4B592F45686A595773686A38536F4B674D77707831352F7741692B50662B6E62706E6E2B656F46356B5A376D446D48796A35657A4F637874766A4A726E4D585073615774714C534B5333396D6A496C55443177373775397248564D646E6A547A746A30644F323534652F6A366B506B2F4334624B746C6630704C4C474C4F7961347452465042626C35677741566E7541557054587377386A766D72423454473265466E78736B7A793330557A336B63317862584F786F335655437461674B415153654F6D4164387178546E69792F4D586E756332745455725663424449504A6A6D636B6344506241482B66516A574E3142504F34307A4F5038416E5A5836327564627145574F5147425165497030617856526D52525861415067314254752B652B5A634E6258324A772B536C7372504A52624D7248455150465167674B53525564316A576C4F42316D384A6457707A734273787A6C7A4E6E4D5A6A63626C4D6C4C65593745522B446A6264794E6B4B414251463267566F6F4171654E4F47727836354C6D484C6E6144454B656B4468784664625A656F46335641484569704767304879722F6269302F4D5876756332724E55624C68616659547A43333561412F31324C57464B486E6B66313359664F796E3174633636374D6B376C2B664652354F7A664C727678716B2B3072736154687462623345654A6D47366C514847724F764B69766D446D2B554C305739316855564A6B332B324E48614E5A4B554371454777797971783362754B714F4641613676326A4C4F4D54644A466E7253397557436F6B36797973774C4B414431716F4A4948594E6276534C6E4E392F593548497733466D49646F6845622B7A7049696A617A6256597A6653534D716B4465355A694B5650445364496E3541792B4477334D4C587562746F37717A4E70635178704C6152583670504B6C49705462544D6B62374734385470656B58504D584C3870357A4B525A4C6C2B33577843787732307470466152574D626C454A656351516C6B516C6A51393437757A6278665A463379734E4F6437552F6B4C33334F625843616A614D4B6A6659507A424855622F46675873723762454E59556D656562667232793747796E3174633636624A4764713330612F42723648543135347967646C5A5356574564666562344230613763656C59733450483871584F50755030746679324E2B476462554B6A504777614965457A625561675757752F6A78586F303564664B587846655A58466373323967736D4F7937583134435045684D4478436832385157464F4865303439664B337A41453850572F7444304A3368384F70657277484879742F62533250354339397A6D3138614D746F776A7439696E4D585A63322F763857734B5350504E7631375A396A355436327564644C7045685A73635669704D4E6233556B717463534D597A6243594C4C75366D3245554347744B6C7461342F6E632B4E2F784A346B3178342B66564D2B6359763045737479447978615A2B2F77415A4E6C424931744E4448446578764739764C464C475A444B475233707332304B6A63612B6A5865666E396E74384E35517235645965566F42613330453374524357796D3432794F354171705461327A695341575056702B2F326533775A52342F6B4C41333176346B4E39476B685A31437A5843526F646A4D76423237315345336570304D76703450332B7A322B444C74504C33427957346C5449322F694E4D59566A4E7A74725130334269673677656B55376549476E372F5A3766426C6374764B76427A597934766A6E4D66444A6247354457623366307A47324C4475446141776B32315430366676396E743847533535566D764F4E71335257327654542B5A793638735A625468534235466377792B6D6142763639456459556965647065546D47414247576B6D53323768546370796C77775A54316A6A727064496B5A706351546C4E71715458703146557A61794A336475337371426F6A345179673158676653474666336451636D4755394E44385930483367796464443859304833674F656F6664476761764C5974427A5A62794D724D504175316F67337456725752527748773673473134644439674F66536F33623446374B2B325261777046383535503777576C54304A66552B504A334F756D7A4A4E784761746365737A54343231794B796C516A33595937436C61374E76373764337548334E5256544E33583659794B54574F506774415545613264694732634354756F7733566F654A506F31424A61387253534C7575623243334E4B2B476F615A7830634473376C667874427A633872756968726539686E2F42594E4531665233716A3564465359584A5359745874376A43324E36524A346E69333852646C4E556F41775046614965372B4554364E45635832566A624669786A787468456148646552526E3267316B442B73335251446277366964426238757A546D753150354F3539326B31594E6F773166734435675035534433794C57465A2F7743642F7744332B7A375576612F2B537564644C70475370687879724A444A2B6E487534797151725A2B794257366E386263476F50584B6B636654724B754C715041766B4C524D49626772746C39733866674F6B374E6E5874325542336666563671614B6E7435676A474E2B6E30644A2B344E427A6454497361787233614367576848443439455357647879366C6E4B4D7448637A584B6A2F6B6F34583252314F376476593170783239412F77424F69707236546B49343655324B58363554756D415346544142762B6B44314F366E682B715231394F677265586E3755327635713539326B31596A614D4D5038414D2F77445067393869316857656564726633697465794F372B7372725853374D6C486C717774373634755575464C777851463971747449597569626765774D65476F6F374659346533746E61315155494F365370636B727770754E6576564538484B4F6176556D7573505A5435464C5462375762614E7057586457685A5642626A744E4F476D4449666463765A6872654C4954326B6B4F506E4F32336E6341427A3368774664772F69323652316167726D78747A43545054616C647A48674251304A726F422B6473597253473061453057635034677153616F77703868314658764C333971626638414D335075306D7245625268782F6C2F7A337A345066497459566E486E5764334D634148556C33395A5857756C325A685035616E614C494D6C53504769644B447232306B7038657A555566754C7949524E47414172413948626F4B384762796B6865306775707261336E4B2B3152515350474843567075436C6477465453756774706E736C4169576373306B6C6B6C44426175785A45366543676D673964756A306E51584C6134747055496456334E55734B634B6B6B6E6870674C334F736943397462565477676833454144675A5475342F696854714B37387666326E68506F68757664354E5749326A442F2F414A2B7A782F4367393769316857626563524C637878396E74672F396A633636585A6D454A476B696B57574E746B6B62426B59644959476F4F6F6F735A52647847654155326973384136597A36523655505565726F506146764857366253386931464F6E554864314845304354524C51455672516730507072783048735678466157777672332B4948385246576A334444373166775033373941364F6E567959445938427A546D37733351737058653875344C5A706D587734785065727667553139565854764B6155322F467246374F4D33584174793169627A446338793479384B47357331753470476962664778574277536A3047346176446C4F556C685A68723249482B58764F2F444237334671436C35312B552B54544C746B72466D6B73414A584735537A42705A6E6E595658713353476E4457736F787038426B535346695A6A364E72443930615A564163526C494A566B534E3470453471366E61523866445449753239396C59435046744937674131616F654D6E3466435A42386D6D55537A5A724B4D434C6648573174576C474B7954734B656A78336B582F6430554A754C4C4B33633754584A65655A75444F37626A5164412B447330513134766D667A4474376131747261355068327470505978686B615174446355486636647A784B6F574A6A36696967346134337034573577312F71694F4C734F664C7838516B74724A65525957316B73735A46345378424970463230643147352B727034363378347A6A625A756C725A7366794C6E59664A584B59646F2F316A63724736523036316E535138507864556248662B78657A74375A7338436E6533307038756757302B7A336564767375377239585155722F374C7550744873746576316441457550735971642F732F78553046582F414153722F49664A6F4C3170396A6452346673396533626F4744482F41476363505A765A613958713642687450304A51657A65423262647567766433623162666B30482F32513D3D, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('9', '1', '6', '2', '7', 'Sony - E-Series Walkman 8GB* MP3 Player - Black', '<p>This Walkman MP3 player features 8GB* of memory, so you can store your favorite movies and tunes. The large 2\" color QVGA screen allows you to easily navigate through functions.</p><p>Measures just 0.4\" thin and weighs just 1.9 oz.; up to 30 hours music playback; 2\" color QVGA LCD display; Windows Media Player music management software; USB 2.0 connectivity; PlaysForSure compatible.</p>', 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, '80.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>8GB* internal flash memory</strong><br />For storing songs and movies.</li><li><strong>Ultracompact design</strong><br />Measures just 0.4\" thin and weighs only 1.9 ounces for portability to the gym, to work or when traveling.</li><li><strong>Supported formats</strong><br />Include MP3, WAV, AAC, WMA (DRM), L-PCM, H.264/AVC, MP4 and WMV (DRM) so you can take your media on the go.</li><li><strong>2\" color QVGA LCD screen</strong><br />Allows you to easily navigate through features.</li><li><strong>Built-in FM tuner</strong><br />For listening to your favorite radio stations on the go.</li><li><strong>High-speed USB 2.0 interface</strong><br />For blazing-fast transfer speeds.</li><li><strong>Clear Audio technologies</strong><br />Deliver improved sound performance.</li><li><strong>Built-in timer</strong><br />Helps you keep track of the time.</li><li><strong>Rechargeable lithium-ion battery</strong><br />Provides up to 30 hours of music playback.</li><li><strong>Windows Media Player</strong><br />Music-management software included.</li><li><strong>PlaysForSure compatible</strong><br />For reliable playback.</li><li><strong>PC compatible</strong><br />For multifunctional use.</li><li><span class=\"Legal\">*Formatted capacity may vary.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">90 days</div></li><li><div class=\"label\">Product Height</div><div class=\"data\">0.4\"</div></li><li class=\"banded\"><div class=\"label\">Product Width</div><div class=\"data\">1.75</div></li><li><div class=\"label\">Product Weight</div><div class=\"data\">1.9 oz.</div></li><li class=\"banded\"><div class=\"label\">Product Depth</div><div class=\"data\">3.5</div></li><li><div class=\"label\">Storage Type</div><div class=\"data\">Flash memory</div></li><li class=\"banded\"><div class=\"label\">Built-In Storage Capacity</div><div class=\"data\">8GB (formatted capacity may vary)</div></li><li><div class=\"label\">Included Removable Memory</div><div class=\"data\">None</div></li><li class=\"banded\"><div class=\"label\">Removable Memory Type</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Format Upgradable</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Computer Compatibility</div><div class=\"data\">PC</div></li><li><div class=\"label\">Music-Management Software</div><div class=\"data\">Windows Media Player</div></li><li class=\"banded\"><div class=\"label\">Music Service Compatibility</div><div class=\"data\">None</div></li><li><div class=\"label\">Digital Audio Formats</div><div class=\"data\">MP3, WAV, AAC, WMA (DRM), L-PCM, MP4</div></li><li class=\"banded\"><div class=\"label\">PlaysForSure Compatibility</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Battery Size</div><div class=\"data\">Rechargeable lithium-ion (included)</div></li><li class=\"banded\"><div class=\"label\">Battery Quantity</div><div class=\"data\">1</div></li><li><div class=\"label\">Battery Life</div><div class=\"data\">Up to 30 hours music playback</div></li><li class=\"banded\"><div class=\"label\">Available Expansion Slots</div><div class=\"data\">None</div></li><li><div class=\"label\">Connection Transfer Rate</div><div class=\"data\">USB 2.0</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">FM</div></li><li><div class=\"label\">Headphone Type</div><div class=\"data\">Earbud</div></li><li class=\"banded\"><div class=\"label\">FM tuner</div><div class=\"data\">Yes</div></li><li><div class=\"label\">System Requirements</div><div class=\"data\">PC with Microsoft Windows</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">Color Category</div><div class=\"data\">Black</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony E-Series Walkman 8GB* MP3 Player</li><li class=\"property included-item\">1 pair ear bud headphones</li><li class=\"property included-item\">Rechargeable lithium-ion battery</li><li class=\"property included-item\">USB to WM-port cable</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('10', '2', '6', '2', '2', 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', '<p>Plays CD, CD-R/RW and MP3 formats; AM/FM tuner with 30 presets; 3-way bass-reflex speakers</p><p>This mini shelf system features two 3-way bass-reflex speakers for rich audio you can rock out to. The built-in iPod dock allows you to listen to your favorite tunes and the AM/FM tuner with 30 station presets makes it easy to find stations at the touch of a button.</p>', 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, '200.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>Mini shelf system</strong><br />With single-disc CD player, iPod dock and AM/FM radio.</li><li><strong>CD, CD-R, CD-RW and MP3 playback formats</strong><br />For listening to your music.</li><li><strong>Built-in Apple iPod dock</strong><br />Lets you connect your iPod to the shelf system to listen to your favorite tunes in lush stereo sound. Charges your iPod while you listen to music.</li><li><strong>360W (180W x 2), 10% THD power output</strong><br />For sound you can enjoy.</li><li><strong>AM/FM tuner with 30 presets (10 AM, 20 FM)</strong><br />To set your favorite channels for one-touch recall.</li><li><strong>3-way bass-reflex speakers</strong><br />Deliver a lush soundscape.</li><li><strong>Audio input</strong><br />For connecting an MP3 player or PC.</li><li><strong>Infrared remote</strong><br />With full iPod menu for easy control over the shelf system.</li><li><span class=\"Legal\">Apple, the Apple logo and iTunes are trademarks of Apple Computer, Inc., registered in the U.S. and other countries. iPod is a trademark of Apple Computer, Inc.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">1 year limited</div></li><li><div class=\"label\">Shelf System Type</div><div class=\"data\">Bookshelf</div></li><li class=\"banded\"><div class=\"label\">Sound Type</div><div class=\"data\">Stereo</div></li><li><div class=\"label\">Total System Power</div><div class=\"data\">360W</div></li><li class=\"banded\"><div class=\"label\">Speaker Quantity</div><div class=\"data\">2</div></li><li><div class=\"label\">Main Speaker Type</div><div class=\"data\">3-way bass reflex</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Watts per Channel</div><div class=\"data\">180W x 2</div></li><li><div class=\"label\">Total Harmonic Distortion</div><div class=\"data\">10%</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">AM/FM</div></li><li><div class=\"label\">Station Presets</div><div class=\"data\">30 (10 AM, 20 FM)</div></li><li class=\"banded\"><div class=\"label\">Remote Control</div><div class=\"data\">Infrared</div></li><li><div class=\"label\">Karaoke Feature</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Track Programming</div><div class=\"data\">No</div></li><li><div class=\"label\">Direct Track Access</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">CD-R/RW Compatible</div><div class=\"data\">Yes</div></li><li><div class=\"label\">CD-R/RW Recorder</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">MP3 Playback Capability</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Main Unit Height</div><div class=\"data\">12\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Width</div><div class=\"data\">7-9/10\"</div></li><li><div class=\"label\">Main Unit Depth</div><div class=\"data\">15-3/8\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Weight</div><div class=\"data\">12.1 lbs.</div></li><li><div class=\"label\">Main Speaker Dimensions</div><div class=\"data\">12\"H x 8-3/4\"W x 8-1/2\"D</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Weight</div><div class=\"data\">6.2 lbs. each</div></li><li><div class=\"label\">Disc Capacity</div><div class=\"data\">1</div></li><li class=\"banded\"><div class=\"label\">Playback Formats</div><div class=\"data\">CD, CD-R, CD-RW, MP3</div></li><li><div class=\"label\">Progressive Scan</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Dolby Digital Decoder</div><div class=\"data\">No</div></li><li><div class=\"label\">Component Video Outputs</div><div class=\"data\">0</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">HD Radio Compatible</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">iPod Connection</div><div class=\"data\">Yes</div></li><li><div class=\"label\">iPod Dock</div><div class=\"data\">Yes</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony 360W Mini Shelf System with Built-In Apple&reg; iPod&reg; Dock</li><li class=\"property included-item\">Infrared remote</li><li class=\"property included-item\">FM antenna</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('11', '2', '6', '2', '2', 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', '<p>Plays CD, CD-R/RW and MP3 formats; AM/FM tuner with 30 presets; 3-way bass-reflex speakers</p><p>This mini shelf system features two 3-way bass-reflex speakers for rich audio you can rock out to. The built-in iPod dock allows you to listen to your favorite tunes and the AM/FM tuner with 30 station presets makes it easy to find stations at the touch of a button.</p>', 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, '200.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>Mini shelf system</strong><br />With single-disc CD player, iPod dock and AM/FM radio.</li><li><strong>CD, CD-R, CD-RW and MP3 playback formats</strong><br />For listening to your music.</li><li><strong>Built-in Apple iPod dock</strong><br />Lets you connect your iPod to the shelf system to listen to your favorite tunes in lush stereo sound. Charges your iPod while you listen to music.</li><li><strong>360W (180W x 2), 10% THD power output</strong><br />For sound you can enjoy.</li><li><strong>AM/FM tuner with 30 presets (10 AM, 20 FM)</strong><br />To set your favorite channels for one-touch recall.</li><li><strong>3-way bass-reflex speakers</strong><br />Deliver a lush soundscape.</li><li><strong>Audio input</strong><br />For connecting an MP3 player or PC.</li><li><strong>Infrared remote</strong><br />With full iPod menu for easy control over the shelf system.</li><li><span class=\"Legal\">Apple, the Apple logo and iTunes are trademarks of Apple Computer, Inc., registered in the U.S. and other countries. iPod is a trademark of Apple Computer, Inc.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">1 year limited</div></li><li><div class=\"label\">Shelf System Type</div><div class=\"data\">Bookshelf</div></li><li class=\"banded\"><div class=\"label\">Sound Type</div><div class=\"data\">Stereo</div></li><li><div class=\"label\">Total System Power</div><div class=\"data\">360W</div></li><li class=\"banded\"><div class=\"label\">Speaker Quantity</div><div class=\"data\">2</div></li><li><div class=\"label\">Main Speaker Type</div><div class=\"data\">3-way bass reflex</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Watts per Channel</div><div class=\"data\">180W x 2</div></li><li><div class=\"label\">Total Harmonic Distortion</div><div class=\"data\">10%</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">AM/FM</div></li><li><div class=\"label\">Station Presets</div><div class=\"data\">30 (10 AM, 20 FM)</div></li><li class=\"banded\"><div class=\"label\">Remote Control</div><div class=\"data\">Infrared</div></li><li><div class=\"label\">Karaoke Feature</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Track Programming</div><div class=\"data\">No</div></li><li><div class=\"label\">Direct Track Access</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">CD-R/RW Compatible</div><div class=\"data\">Yes</div></li><li><div class=\"label\">CD-R/RW Recorder</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">MP3 Playback Capability</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Main Unit Height</div><div class=\"data\">12\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Width</div><div class=\"data\">7-9/10\"</div></li><li><div class=\"label\">Main Unit Depth</div><div class=\"data\">15-3/8\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Weight</div><div class=\"data\">12.1 lbs.</div></li><li><div class=\"label\">Main Speaker Dimensions</div><div class=\"data\">12\"H x 8-3/4\"W x 8-1/2\"D</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Weight</div><div class=\"data\">6.2 lbs. each</div></li><li><div class=\"label\">Disc Capacity</div><div class=\"data\">1</div></li><li class=\"banded\"><div class=\"label\">Playback Formats</div><div class=\"data\">CD, CD-R, CD-RW, MP3</div></li><li><div class=\"label\">Progressive Scan</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Dolby Digital Decoder</div><div class=\"data\">No</div></li><li><div class=\"label\">Component Video Outputs</div><div class=\"data\">0</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">HD Radio Compatible</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">iPod Connection</div><div class=\"data\">Yes</div></li><li><div class=\"label\">iPod Dock</div><div class=\"data\">Yes</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony 360W Mini Shelf System with Built-In Apple iPod Dock</li><li class=\"property included-item\">Infrared remote</li><li class=\"property included-item\">FM antenna</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('12', '2', '6', '2', '2', 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', '<p>Plays CD, CD-R/RW and MP3 formats; AM/FM tuner with 30 presets; 3-way bass-reflex speakers</p><p>This mini shelf system features two 3-way bass-reflex speakers for rich audio you can rock out to. The built-in iPod dock allows you to listen to your favorite tunes and the AM/FM tuner with 30 station presets makes it easy to find stations at the touch of a button.</p>', 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, '200.00', 'Y', '10', 'Y', '<h2>Product Features</h2><ul><li><strong>Mini shelf system</strong><br />With single-disc CD player, iPod dock and AM/FM radio.</li><li><strong>CD, CD-R, CD-RW and MP3 playback formats</strong><br />For listening to your music.</li><li><strong>Built-in Apple iPod dock</strong><br />Lets you connect your iPod to the shelf system to listen to your favorite tunes in lush stereo sound. Charges your iPod while you listen to music.</li><li><strong>360W (180W x 2), 10% THD power output</strong><br />For sound you can enjoy.</li><li><strong>AM/FM tuner with 30 presets (10 AM, 20 FM)</strong><br />To set your favorite channels for one-touch recall.</li><li><strong>3-way bass-reflex speakers</strong><br />Deliver a lush soundscape.</li><li><strong>Audio input</strong><br />For connecting an MP3 player or PC.</li><li><strong>Infrared remote</strong><br />With full iPod menu for easy control over the shelf system.</li><li><span class=\"Legal\">Apple, the Apple logo and iTunes are trademarks of Apple Computer, Inc., registered in the U.S. and other countries. iPod is a trademark of Apple Computer, Inc.</span></li></ul>', '<ul><li><div class=\"label\">Warranty Terms - Parts</div><div class=\"data\">1 year</div></li><li class=\"banded\"><div class=\"label\">Warranty Terms - Labor</div><div class=\"data\">1 year limited</div></li><li><div class=\"label\">Shelf System Type</div><div class=\"data\">Bookshelf</div></li><li class=\"banded\"><div class=\"label\">Sound Type</div><div class=\"data\">Stereo</div></li><li><div class=\"label\">Total System Power</div><div class=\"data\">360W</div></li><li class=\"banded\"><div class=\"label\">Speaker Quantity</div><div class=\"data\">2</div></li><li><div class=\"label\">Main Speaker Type</div><div class=\"data\">3-way bass reflex</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Watts per Channel</div><div class=\"data\">180W x 2</div></li><li><div class=\"label\">Total Harmonic Distortion</div><div class=\"data\">10%</div></li><li class=\"banded\"><div class=\"label\">Tuner Type</div><div class=\"data\">AM/FM</div></li><li><div class=\"label\">Station Presets</div><div class=\"data\">30 (10 AM, 20 FM)</div></li><li class=\"banded\"><div class=\"label\">Remote Control</div><div class=\"data\">Infrared</div></li><li><div class=\"label\">Karaoke Feature</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Track Programming</div><div class=\"data\">No</div></li><li><div class=\"label\">Direct Track Access</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">CD-R/RW Compatible</div><div class=\"data\">Yes</div></li><li><div class=\"label\">CD-R/RW Recorder</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">MP3 Playback Capability</div><div class=\"data\">Yes</div></li><li><div class=\"label\">Main Unit Height</div><div class=\"data\">12\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Width</div><div class=\"data\">7-9/10\"</div></li><li><div class=\"label\">Main Unit Depth</div><div class=\"data\">15-3/8\"</div></li><li class=\"banded\"><div class=\"label\">Main Unit Weight</div><div class=\"data\">12.1 lbs.</div></li><li><div class=\"label\">Main Speaker Dimensions</div><div class=\"data\">12\"H x 8-3/4\"W x 8-1/2\"D</div></li><li class=\"banded\"><div class=\"label\">Main Speaker Weight</div><div class=\"data\">6.2 lbs. each</div></li><li><div class=\"label\">Disc Capacity</div><div class=\"data\">1</div></li><li class=\"banded\"><div class=\"label\">Playback Formats</div><div class=\"data\">CD, CD-R, CD-RW, MP3</div></li><li><div class=\"label\">Progressive Scan</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">Dolby Digital Decoder</div><div class=\"data\">No</div></li><li><div class=\"label\">Component Video Outputs</div><div class=\"data\">0</div></li><li class=\"banded\"><div class=\"label\">Bluetooth-Enabled</div><div class=\"data\">No</div></li><li><div class=\"label\">HD Radio Compatible</div><div class=\"data\">No</div></li><li class=\"banded\"><div class=\"label\">iPod Connection</div><div class=\"data\">Yes</div></li><li><div class=\"label\">iPod Dock</div><div class=\"data\">Yes</div></li></ul>', '<div id=\"boxcontents\"><h2>What\'s Included</h2><ul class=\"p-v\"><li class=\"property included-item\">Sony 360W Mini Shelf System with Built-In Apple iPod Dock</li><li class=\"property included-item\">Infrared remote</li><li class=\"property included-item\">FM antenna</li><li class=\"property included-item\">Owner\'s manual</li></ul></div>');
INSERT INTO `products` VALUES ('13', '2', '6', '2', '2', 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', '<p>Plays CD, CD-R/RW and MP3 formats; AM/FM tuner with 30presets; 3-way bass-reflex speakers</p> <p>This mini shelf system features two3-way bass-reflex speakers for rich audio you can rock out to. The built-in iPoddock allows you to listen to your favorite tunes and the AM/FM tuner with 30station presets makes it easy to find stations at the touch of a button.</p>', 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, '200.00', 'Y', '10', 'Y', '<h2>Product Features</h2> <ul> <li><strong>Mini shelfsystem</strong><br />With single-disc CD player, iPod dock and AM/FM radio.</li><li><strong>CD, CD-R, CD-RW and MP3 playback formats</strong><br />For listeningto your music.</li> <li><strong>Built-in Apple iPod dock</strong><br />Lets youconnect your iPod to the shelf system to listen to your favorite tunes in lushstereo sound. Charges your iPod while you listen to music.</li> <li><strong>360W(180W x 2), 10% THD power output</strong><br />For sound you can enjoy.</li><li><strong>AM/FM tuner with 30 presets (10 AM, 20 FM)</strong><br />To set yourfavorite channels for one-touch recall.</li> <li><strong>3-way bass-reflexspeakers</strong><br />Deliver a lush soundscape.</li> <li><strong>Audioinput</strong><br />For connecting an MP3 player or PC.</li><li><strong>Infrared remote</strong><br />With full iPod menu for easy controlover the shelf system.</li> <li><span class=\"Legal\">Apple, the Apple logo andiTunes are trademarks of Apple Computer, Inc., registered in the U.S. and othercountries. iPod is a trademark of Apple Computer, Inc.</span></li> </ul>', '<ul> <li> <div class=\"label\">Warranty Terms - Parts</div> <div class=\"data\">1year</div> </li> <li class=\"banded\"> <div class=\"label\">Warranty Terms -Labor</div> <div class=\"data\">1 year limited</div> </li> <li> <divclass=\"label\">Shelf System Type</div> <div class=\"data\">Bookshelf</div> </li><li class=\"banded\"> <div class=\"label\">Sound Type</div> <divclass=\"data\">Stereo</div> </li> <li> <div class=\"label\">TotalSystem Power</div> <div class=\"data\">360W</div> </li> <li class=\"banded\"><div class=\"label\">Speaker Quantity</div> <div class=\"data\">2</div> </li> <li><div class=\"label\">Main Speaker Type</div> <div class=\"data\">3-way bassreflex</div> </li> <li class=\"banded\"> <div class=\"label\">Main Speaker Watts perChannel</div> <div class=\"data\">180W x 2</div> </li> <li> <div class=\"label\">TotalHarmonic Distortion</div> <div class=\"data\">10%</div> </li> <liclass=\"banded\"> <div class=\"label\">TunerType</div> <div class=\"data\">AM/FM</div> </li> <li> <div class=\"label\">StationPresets</div> <div class=\"data\">30 (10 AM, 20 FM)</div> </li> <liclass=\"banded\"> <div class=\"label\">RemoteControl</div> <div class=\"data\">Infrared</div> </li> <li> <divclass=\"label\">Karaoke Feature</div> <div class=\"data\">No</div> </li> <liclass=\"banded\"> <div class=\"label\">Track Programming</div> <divclass=\"data\">No</div> </li> <li> <div class=\"label\">Direct Track Access</div><div class=\"data\">No</div> </li> <li class=\"banded\"> <div class=\"label\">CD-R/RWCompatible</div> <div class=\"data\">Yes</div> </li> <li> <divclass=\"label\">CD-R/RW Recorder</div> <div class=\"data\">No</div> </li> <liclass=\"banded\"> <div class=\"label\">MP3 Playback Capability</div> <divclass=\"data\">Yes</div> </li> <li> <div class=\"label\">Main Unit Height</div> <divclass=\"data\">12\"</div> </li> <li class=\"banded\"> <div class=\"label\">Main UnitWidth</div> <div class=\"data\">7-9/10\"</div> </li> <li> <div class=\"label\">MainUnit Depth</div> <div class=\"data\">15-3/8\"</div> </li> <li class=\"banded\"> <divclass=\"label\">Main Unit Weight</div> <div class=\"data\">12.1 lbs.</div> </li><li> <div class=\"label\">Main Speaker Dimensions</div> <div class=\"data\">12\"H x8-3/4\"W x 8-1/2\"D</div> </li> <li class=\"banded\"> <div class=\"label\">MainSpeaker Weight</div> <div class=\"data\">6.2 lbs. each</div> </li> <li> <divclass=\"label\">DiscCapacity</div> <div class=\"data\">1</div> </li> <li class=\"banded\"> <divclass=\"label\">PlaybackFormats</div> <div class=\"data\">CD, CD-R, CD-RW, MP3</div> </li> <li> <divclass=\"label\">ProgressiveScan</div> <div class=\"data\">No</div> </li> <li class=\"banded\"> <divclass=\"label\">DolbyDigital Decoder</div> <div class=\"data\">No</div> </li> <li> <divclass=\"label\">ComponentVideo Outputs</div> <div class=\"data\">0</div> </li> <li class=\"banded\"> <divclass=\"label\">Bluetooth-Enabled</div> <div class=\"data\">No</div> </li> <li> <divclass=\"label\">HD Radio Compatible</div> <div class=\"data\">No</div> </li> <liclass=\"banded\"> <div class=\"label\">iPod Connection</div> <divclass=\"data\">Yes</div> </li> <li> <div class=\"label\">iPod Dock</div> <divclass=\"data\">Yes</div> </li> </ul>', '<div id=\"boxcontents\"> <h2>What\'sIncluded</h2> <ul class=\"p-v\"> <li class=\"property included-item\">Sony 360W MiniShelf System with Built-In Apple iPod Dock</li> <li class=\"propertyincluded-item\">Infrared remote</li> <li class=\"property included-item\">FMantenna</li> <li class=\"property included-item\">Owner\'s manual</li> </ul></div>');
INSERT INTO `products` VALUES ('14', '2', '6', '2', '2', 'Sony - 360W Mini Shelf System with Built-In Apple iPod Dock', '<p>Plays CD, CD-R/RW and MP3 formats; AM/FM tuner with 30presets; 3-way bass-reflex speakers</p> <p>This mini shelf system features two3-way bass-reflex speakers for rich audio you can rock out to. The built-in iPoddock allows you to listen to your favorite tunes and the AM/FM tuner with 30station presets makes it easy to find stations at the touch of a button.</p>', 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