<?php

function scCsrfGetToken($sTokenName)
{
    if (!isset($_SESSION['scriptcase']['csrf_token'][$sTokenName]))
    {
        $_SESSION['scriptcase']['csrf_token'][$sTokenName] = scCsrfGenerateToken();
    }
    return $_SESSION['scriptcase']['csrf_token'][$sTokenName];
}

function scCsrfGenerateToken()
{
    $aSources = array(
        'abcdefghijklmnopqrstuvwxyz',
        'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
        '1234567890',
    );
    $sRandom       = '';
    $aSourcesSizes = array();
    $iSourceSize   = count($aSources) - 1;
    for ($i = 0; $i <= $iSourceSize; $i++)
    {
        $aSourcesSizes[$i] = strlen($aSources[$i]) - 1;
    }
    for ($i = 0; $i < 64; $i++)
    {
        $iSource  = scCsrfRandom(0, $iSourceSize);
        $sRandom .= substr($aSources[$iSource], scCsrfRandom(0, $aSourcesSizes[$iSource]), 1);
    }
    return $sRandom;
}

function scCsrfRandom($iMin, $iMax)
{
    return mt_rand($iMin, $iMax);
}

?>