/*
Navicat MySQL Data Transfer

Source Server         : MYSQL
Source Server Version : 50505
Source Host           : 127.0.0.1:3306
Source Database       : sc_fluxocaixa

Target Server Type    : MYSQL
Target Server Version : 50699
File Encoding         : 65001

Date: 2019-07-01 16:28:08
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for tbl_agencias
-- ----------------------------
CREATE TABLE `tbl_agencias` (
`agencod`  int(11) NOT NULL AUTO_INCREMENT ,
`bancod`  int(11) NULL DEFAULT NULL ,
`agennome`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`agennumeroagencia`  varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`agencod`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of tbl_agencias
-- ----------------------------
BEGIN;
INSERT INTO `tbl_agencias` VALUES ('1', '1', 'Moema', '6543'), ('2', '2', 'Vereador José Diniz', '765'), ('3', '3', 'Av. Piraporinha', '9847');
COMMIT;

-- ----------------------------
-- Table structure for tbl_bancos
-- ----------------------------
CREATE TABLE `tbl_bancos` (
`bancod`  int(11) NOT NULL AUTO_INCREMENT ,
`bannome`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`bannumerobanco`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`banlogo`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`banseparador`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`bancarteira`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`bancarteirades`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`bancod`),
UNIQUE INDEX `XPKtblbanco` (`bancod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of tbl_bancos
-- ----------------------------
BEGIN;
INSERT INTO `tbl_bancos` VALUES ('1', 'Banco Itaú S. A.', '341', 'logoitau.jpg', 'separador.JPG', '', ''), ('2', 'Caixa Econômica Federal', '104', 'logocaixa.jpg', 'separador.JPG', '', ''), ('3', 'HSBC Bank Brasil S.A. - Banco Múltiplo', '399', 'logohsbc.jpg', 'separador.JPG', '', '');
COMMIT;

-- ----------------------------
-- Table structure for tbl_composicao_plano
-- ----------------------------
CREATE TABLE `tbl_composicao_plano` (
`plancod`  int(11) NOT NULL ,
`plancoddest`  int(11) NOT NULL ,
PRIMARY KEY (`plancod`, `plancoddest`),
UNIQUE INDEX `XPKtblcomposicaoplano` (`plancod`, `plancoddest`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_composicao_plano
-- ----------------------------
BEGIN;
INSERT INTO `tbl_composicao_plano` VALUES ('1', '2'), ('1', '6'), ('1', '8'), ('5', '6'), ('5', '7'), ('5', '8'), ('9', '6');
COMMIT;

-- ----------------------------
-- Table structure for tbl_configuracoes
-- ----------------------------
CREATE TABLE `tbl_configuracoes` (
`cod_configuracao`  int(11) NOT NULL AUTO_INCREMENT ,
`tempo_sessao`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`cod_configuracao`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=2

;

-- ----------------------------
-- Records of tbl_configuracoes
-- ----------------------------
BEGIN;
INSERT INTO `tbl_configuracoes` VALUES ('1', '10');
COMMIT;

-- ----------------------------
-- Table structure for tbl_contas_correntes
-- ----------------------------
CREATE TABLE `tbl_contas_correntes` (
`bancod`  int(11) NOT NULL ,
`agencod`  int(11) NOT NULL ,
`contnumero`  varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`bancod`, `agencod`, `contnumero`),
UNIQUE INDEX `XPKtblcontacorrente` (`bancod`, `agencod`, `contnumero`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_contas_correntes
-- ----------------------------
BEGIN;
INSERT INTO `tbl_contas_correntes` VALUES ('1', '1', '57687678'), ('2', '2', '32456879'), ('2', '2', '65579878'), ('2', '2', '76987809'), ('3', '3', '15152398'), ('3', '3', '69289279'), ('3', '3', '86929269');
COMMIT;

-- ----------------------------
-- Table structure for tbl_empresas
-- ----------------------------
CREATE TABLE `tbl_empresas` (
`empcod`  int(11) NOT NULL AUTO_INCREMENT ,
`empcidade`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`estadouf`  char(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`emprazaosocial`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empnatureza`  char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empcpfcnpj`  varchar(14) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empendereco`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empcep`  varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empnumero`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empcomplemento`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empbairro`  varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empddd`  char(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`emptelefone`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`emptipo`  char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`empemail`  varchar(70) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`emplogo`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' ,
`empinscestadual`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`empcod`),
UNIQUE INDEX `XPKtblempresa` (`empcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=3

;

-- ----------------------------
-- Records of tbl_empresas
-- ----------------------------
BEGIN;
INSERT INTO `tbl_empresas` VALUES ('1', 'São Paulo', 'SP', 'Empresa Pessoa Física', 'F', '12345678909', 'Avenida  Paulista', '01310000', '12345', 'Fundos', 'Bela Vista', '11', '11111111', 'T', 'teste@teste.com.br', 'logo.JPG', 'ISENTO'), ('2', 'São Paulo', 'SP', 'Empresa Pessoa Jurídica', 'J', '', 'Avenida  dos Bandeirantes', '04553902', '2200', '', 'Vila Olímpia', '21', '21212121', 'F', 'teste@teste.com.br', 'logo.JPG', '');
COMMIT;

-- ----------------------------
-- Table structure for tbl_estados
-- ----------------------------
CREATE TABLE `tbl_estados` (
`estadouf`  char(2) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`estadonome`  varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`estadouf`),
UNIQUE INDEX `XPKtblestado` (`estadouf`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_estados
-- ----------------------------
BEGIN;
INSERT INTO `tbl_estados` VALUES ('AC', 'Acre'), ('AL', 'Alagoas'), ('AM', 'Amazonas'), ('AP', 'Amapá'), ('BA', 'Bahia'), ('CE', 'Ceará'), ('ES', 'Espírito Santo'), ('GO', 'Goiás'), ('MA', 'Maranhão'), ('MG', 'Minas Gerais'), ('MS', 'Mato Grosso Do Sul'), ('MT', 'Mato Grosso'), ('PA', 'Pará'), ('PB', 'Paraíba'), ('PE', 'Pernambuco'), ('PI', 'Piauí'), ('PR', 'Paraná'), ('RJ', 'Rio De Janeiro'), ('RN', 'Rio Grande Do Norte'), ('RO', 'Rondônia'), ('RS', 'Rio Grande Do Sul'), ('SC', 'Santa Catarina'), ('SE', 'Sergipe'), ('SP', 'São Paulo'), ('TO', 'Tocantins');
COMMIT;

-- ----------------------------
-- Table structure for tbl_evento
-- ----------------------------
CREATE TABLE `tbl_evento` (
`evento_id`  int(10) NOT NULL AUTO_INCREMENT ,
`evento_titulo`  tinytext CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`evento_datainicio`  date NULL DEFAULT NULL ,
`evento_horainicio`  time NULL DEFAULT NULL ,
`evento_datafinal`  date NULL DEFAULT NULL ,
`evento_horafinal`  time NULL DEFAULT NULL ,
`evento_recorrencia`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_periodo`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_fatcod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_fatserie`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_orgcod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_pago`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`evento_reccod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`evento_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=39

;

-- ----------------------------
-- Records of tbl_evento
-- ----------------------------
BEGIN;
INSERT INTO `tbl_evento` VALUES ('5', 'Fatura nº:1 / Parcela nº: 1 de 4 / Valor: R$10000,00', '2012-11-28', null, '2012-11-28', null, 'N', 'D', '1', '1', '2', 'S', '13'), ('6', 'Fatura nº:1 / Parcela nº: 2 de 4 / Valor: R$10000,00', '2012-12-28', null, '2012-12-28', null, 'N', 'D', '1', '1', '2', 'S', '14'), ('7', 'Fatura nº:1 / Parcela nº: 3 de 4 / Valor: R$10000,00', '2013-01-27', null, '2013-01-27', null, 'N', 'D', '1', '1', '2', null, '15'), ('8', 'Fatura nº:1 / Parcela nº: 4 de 4 / Valor: R$10000,00', '2013-02-26', null, '2013-02-26', null, 'N', 'D', '1', '1', '2', null, '16'), ('9', 'Fatura nº:2 / Parcela nº: 1 de 2 / Valor: R$5000,00', '2012-11-28', null, '2012-11-28', null, 'N', 'D', '2', '1', '4', 'S', '17'), ('10', 'Fatura nº:2 / Parcela nº: 2 de 2 / Valor: R$5000,00', '2012-12-28', null, '2012-12-28', null, 'N', 'D', '2', '1', '4', null, '18'), ('21', 'Fatura nº:3 / Parcela nº: 1 de 10 / Valor: R$376,50', '2012-11-30', null, '2012-11-30', null, 'N', 'D', '3', '1', '2', 'S', '29'), ('22', 'Fatura nº:3 / Parcela nº: 2 de 10 / Valor: R$376,50', '2012-12-30', null, '2012-12-30', null, 'N', 'D', '3', '1', '2', null, '30'), ('23', 'Fatura nº:3 / Parcela nº: 3 de 10 / Valor: R$376,50', '2013-01-29', null, '2013-01-29', null, 'N', 'D', '3', '1', '2', null, '31'), ('24', 'Fatura nº:3 / Parcela nº: 4 de 10 / Valor: R$376,50', '2013-02-28', null, '2013-02-28', null, 'N', 'D', '3', '1', '2', null, '32'), ('25', 'Fatura nº:3 / Parcela nº: 5 de 10 / Valor: R$376,50', '2013-03-30', null, '2013-03-30', null, 'N', 'D', '3', '1', '2', null, '33'), ('26', 'Fatura nº:3 / Parcela nº: 6 de 10 / Valor: R$376,50', '2013-04-29', null, '2013-04-29', null, 'N', 'D', '3', '1', '2', null, '34'), ('27', 'Fatura nº:3 / Parcela nº: 7 de 10 / Valor: R$376,50', '2013-05-29', null, '2013-05-29', null, 'N', 'D', '3', '1', '2', null, '35'), ('28', 'Fatura nº:3 / Parcela nº: 8 de 10 / Valor: R$376,50', '2013-06-28', null, '2013-06-28', null, 'N', 'D', '3', '1', '2', null, '36'), ('29', 'Fatura nº:3 / Parcela nº: 9 de 10 / Valor: R$376,50', '2013-07-28', null, '2013-07-28', null, 'N', 'D', '3', '1', '2', 'S', '37'), ('30', 'Fatura nº:3 / Parcela nº: 10 de 10 / Valor: R$376,50', '2013-08-27', null, '2013-08-27', null, 'N', 'D', '3', '1', '2', 'N', '38'), ('35', 'Fatura nº:4 / Parcela nº: 1 de 4 / Valor: R$603,00', '2013-08-22', null, '2013-08-22', null, 'N', 'D', '4', '1', '2', null, '43'), ('36', 'Fatura nº:4 / Parcela nº: 2 de 4 / Valor: R$603,00', '2013-09-21', null, '2013-09-21', null, 'N', 'D', '4', '1', '2', null, '44'), ('37', 'Fatura nº:4 / Parcela nº: 3 de 4 / Valor: R$603,00', '2013-10-21', null, '2013-10-21', null, 'N', 'D', '4', '1', '2', null, '45'), ('38', 'Fatura nº:4 / Parcela nº: 4 de 4 / Valor: R$603,00', '2013-11-20', null, '2013-11-20', null, 'N', 'D', '4', '1', '2', null, '46');
COMMIT;

-- ----------------------------
-- Table structure for tbl_evento_pag
-- ----------------------------
CREATE TABLE `tbl_evento_pag` (
`eventopag_id`  int(10) NOT NULL AUTO_INCREMENT ,
`eventopag_titulo`  tinytext CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`eventopag_datainicio`  date NULL DEFAULT NULL ,
`eventopag_horainicio`  time NULL DEFAULT NULL ,
`eventopag_datafinal`  date NULL DEFAULT NULL ,
`eventopag_horafinal`  time NULL DEFAULT NULL ,
`eventopag_recorrencia`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`eventopag_periodo`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`eventopag_pagcod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`eventopag_orgcod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`eventopag_empcod`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`eventopag_pago`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`eventopag_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tbl_evento_pag
-- ----------------------------
BEGIN;
INSERT INTO `tbl_evento_pag` VALUES ('1', 'Pagamento cód.:1 / Data de Vencimento: 31-10-2012 / Valor: R$2026,00', '2012-10-31', null, '2012-10-31', null, 'N', 'D', '1', '2', '2', 'S'), ('2', 'Pagamento cód.:2 / Data de Lançamento: 31-10-2012 / Data de Vencimento: 12-11-2012 / Valor: R$20042,00', '2012-11-12', null, '2012-11-12', null, 'N', 'D', '2', '2', '2', 'S'), ('3', 'Pagamento cód.:3 / Data de Lançamento: 23-07-2013 / Data de Vencimento: 02-08-2013 / Valor: R$323,34', '2013-08-02', null, '2013-08-02', null, 'N', 'D', '3', '2', '1', null), ('4', 'Pagamento cód.:4 / Data de Lançamento: 23-07-2013 / Data de Vencimento: 06-09-2013 / Valor: R$1234,45', '2013-09-06', null, '2013-09-06', null, 'N', 'D', '4', '1', '2', null);
COMMIT;

-- ----------------------------
-- Table structure for tbl_faturamento
-- ----------------------------
CREATE TABLE `tbl_faturamento` (
`fatcod`  int(11) NOT NULL AUTO_INCREMENT ,
`fatserie`  int(11) NOT NULL DEFAULT 0 ,
`plancod`  int(11) NULL DEFAULT NULL ,
`orgcod`  int(11) NOT NULL DEFAULT 0 ,
`empcod`  int(11) NULL DEFAULT NULL ,
`portcod`  int(11) NULL DEFAULT NULL ,
`fatdtlancamento`  datetime NULL DEFAULT NULL ,
`fatvalor`  float NULL DEFAULT 0 ,
`fataliquotaimposto`  float NULL DEFAULT NULL ,
`fatvalorimposto`  float NULL DEFAULT 0 ,
`fatnumeroparcelas`  int(11) NULL DEFAULT NULL ,
`boletobanco`  int(11) NULL DEFAULT NULL ,
`boletoagencia`  int(11) NULL DEFAULT NULL ,
`boletoconta`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`fatcod`),
UNIQUE INDEX `XPKtblfaturamento` (`fatcod`, `fatserie`, `orgcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tbl_faturamento
-- ----------------------------
BEGIN;
INSERT INTO `tbl_faturamento` VALUES ('1', '1', '6', '2', '1', '1', '2012-10-29 13:18:04', '40000', '1', '400', '4', null, null, null), ('2', '1', '2', '1', '1', '1', '2012-10-29 13:47:48', '10000', '1', '100', '2', null, null, null), ('3', '1', '10', '2', '1', '1', '2012-10-31 08:30:46', '3765', '1.2', '45.18', '10', null, null, null), ('4', '1', '12', '2', '1', '2', '2013-07-23 16:34:33', '2412', '0.002', '0.04', '4', null, null, null);
COMMIT;

-- ----------------------------
-- Table structure for tbl_faturamento_x_itens
-- ----------------------------
CREATE TABLE `tbl_faturamento_x_itens` (
`fatseq`  int(11) NOT NULL AUTO_INCREMENT ,
`fatcod`  int(11) NOT NULL ,
`fatserie`  int(11) NOT NULL ,
`orgcod`  int(11) NOT NULL ,
`fatvalorunitario`  float NULL DEFAULT NULL ,
`prodcod`  int(11) NULL DEFAULT NULL ,
`fatqtde`  float NULL DEFAULT NULL ,
`fatvalortotal`  float NULL DEFAULT NULL ,
PRIMARY KEY (`fatseq`, `fatcod`, `fatserie`, `orgcod`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=9

;

-- ----------------------------
-- Records of tbl_faturamento_x_itens
-- ----------------------------
BEGIN;
INSERT INTO `tbl_faturamento_x_itens` VALUES ('3', '1', '1', '2', '20', '6', '2000', '40000'), ('4', '2', '1', '1', '100', '6', '100', '10000'), ('5', '3', '1', '2', '21', '3', '65', '1365'), ('6', '3', '1', '2', '200', '4', '12', '2400'), ('7', '4', '1', '2', '456', '4', '2', '912'), ('8', '4', '1', '2', '500', '3', '3', '1500');
COMMIT;

-- ----------------------------
-- Table structure for tbl_instrucao_boleto
-- ----------------------------
CREATE TABLE `tbl_instrucao_boleto` (
`msg_id`  int(11) NOT NULL AUTO_INCREMENT ,
`msg_instrucao`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`msg_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tbl_instrucao_boleto
-- ----------------------------
BEGIN;
INSERT INTO `tbl_instrucao_boleto` VALUES ('1', null), ('2', null), ('3', null), ('4', null);
COMMIT;

-- ----------------------------
-- Table structure for tbl_organizacoes
-- ----------------------------
CREATE TABLE `tbl_organizacoes` (
`orgcod`  int(11) NOT NULL AUTO_INCREMENT ,
`orgnome`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgcpfcnpj`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgnatureza`  varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orginscestadual`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgendereco`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgcep`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgcidade`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgestado`  varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgrazaosocial`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orglogo`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgbairro`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`orgcod`),
UNIQUE INDEX `XPKtblorganizacao` (`orgcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tbl_organizacoes
-- ----------------------------
BEGIN;
INSERT INTO `tbl_organizacoes` VALUES ('1', 'Número 1', '07153627000121', 'Prestação de Serviços', 'ISENTO', 'Rua  Antônio José de Almeida', '04720060', 'São Paulo', 'SP', 'Organização Número Hum', 'logo.JPG', 'Granja Julieta'), ('2', 'NETMAKE', '07153627000121', 'Prestação de Serviços', 'ISENTO', 'R. Dr. Oscavo de Paula e Souza, 92', '', 'São Paulo', 'SP', 'NETMAKE', 'sclogo.jpg', 'Campo Belo'), ('3', 'Netmake', null, null, null, null, null, null, null, null, null, null), ('4', 'Canada Veículos', null, null, null, null, null, null, null, null, null, null);
COMMIT;

-- ----------------------------
-- Table structure for tbl_pagamentos
-- ----------------------------
CREATE TABLE `tbl_pagamentos` (
`pagcod`  int(11) NOT NULL AUTO_INCREMENT ,
`bancod`  int(11) NULL DEFAULT NULL ,
`orgcod`  int(11) NOT NULL DEFAULT 0 ,
`empcod`  int(11) NULL DEFAULT NULL ,
`agencod`  int(11) NULL DEFAULT NULL ,
`contnumero`  varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`plancod`  int(11) NULL DEFAULT NULL ,
`pagdtlancamento`  datetime NULL DEFAULT NULL ,
`pagdtvencimento`  datetime NULL DEFAULT NULL ,
`pagdtpagamento`  datetime NULL DEFAULT NULL ,
`pagvalorprincipal`  float NULL DEFAULT NULL ,
`pagvalorjuros`  float NULL DEFAULT NULL ,
`pagvalormora`  float NULL DEFAULT NULL ,
`pagvalortotal`  float NULL DEFAULT NULL ,
PRIMARY KEY (`pagcod`),
UNIQUE INDEX `XPKtblpagamento` (`pagcod`, `orgcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tbl_pagamentos
-- ----------------------------
BEGIN;
INSERT INTO `tbl_pagamentos` VALUES ('1', '1', '2', '2', '1', '57687678', '5', '2012-10-29 13:17:11', '2012-10-31 00:00:00', '2012-10-29 14:30:07', '2000', '24', '2', '2026'), ('2', '2', '2', '2', '2', '32456879', '5', '2012-10-31 08:29:37', '2012-11-12 00:00:00', '2012-10-31 09:48:07', '20000', '21', '21', '20042'), ('3', '1', '2', '1', '1', '57687678', '5', '2013-07-23 16:31:09', '2013-08-02 00:00:00', null, '321.34', '2', '0', '323.34'), ('4', '3', '1', '2', '3', '69289279', '8', '2013-07-23 16:32:32', '2013-09-06 00:00:00', null, '1234.45', '0', '0', '1234.45');
COMMIT;

-- ----------------------------
-- Table structure for tbl_planos_contas
-- ----------------------------
CREATE TABLE `tbl_planos_contas` (
`plancod`  int(11) NOT NULL AUTO_INCREMENT ,
`plandescricao`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`plantipo`  char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`plantotalizadora`  char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`plancod`),
UNIQUE INDEX `XPKtblplano` (`plancod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=15

;

-- ----------------------------
-- Records of tbl_planos_contas
-- ----------------------------
BEGIN;
INSERT INTO `tbl_planos_contas` VALUES ('1', 'CLIENTES', 'C', 'S'), ('2', 'Recebíveis', 'C', 'N'), ('5', 'BANCOS', 'D', 'S'), ('6', 'Brasil', 'C', 'N'), ('7', 'Bradesco', 'C', 'N'), ('8', 'NOSSA CAIXA', 'D', 'N'), ('9', 'TESTE', 'D', 'S'), ('10', 'TESTE DE CRÉDITO', 'C', 'N'), ('11', 'BANCO DO BRASIL', 'C', 'N'), ('12', 'BANCO ITAÚ', 'C', 'N'), ('13', 'CAIXA ECONÔMICA', 'C', 'N'), ('14', 'PLANO DE CREDITO', 'C', 'N');
COMMIT;

-- ----------------------------
-- Table structure for tbl_portadores
-- ----------------------------
CREATE TABLE `tbl_portadores` (
`portcod`  int(11) NOT NULL AUTO_INCREMENT ,
`portnome`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`portimpressao`  char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`portcod`),
UNIQUE INDEX `XPKtblportador` (`portcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=6

;

-- ----------------------------
-- Records of tbl_portadores
-- ----------------------------
BEGIN;
INSERT INTO `tbl_portadores` VALUES ('1', 'Boleto Bancário', 'S'), ('2', 'Cartão Crédito', 'N'), ('5', 'Cartão de Débito', 'N');
COMMIT;

-- ----------------------------
-- Table structure for tbl_produtos
-- ----------------------------
CREATE TABLE `tbl_produtos` (
`prodcod`  int(11) NOT NULL AUTO_INCREMENT ,
`proddesc`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`prodcod`),
UNIQUE INDEX `XPKtblprodutos` (`prodcod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=8

;

-- ----------------------------
-- Records of tbl_produtos
-- ----------------------------
BEGIN;
INSERT INTO `tbl_produtos` VALUES ('1', 'Desenvolvimento de Sites'), ('3', 'Consultoria Delphi'), ('4', 'Consultoria VB'), ('5', 'Suporte Rede'), ('6', 'Consultoria Visual'), ('7', 'Sistema de BI');
COMMIT;

-- ----------------------------
-- Table structure for tbl_recebimento_x_parcelas
-- ----------------------------
CREATE TABLE `tbl_recebimento_x_parcelas` (
`reccod`  int(11) NOT NULL AUTO_INCREMENT ,
`recparcela`  varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`fatcod`  varchar(6) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`fatserie`  char(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`orgcod`  int(11) NULL DEFAULT NULL ,
`bancod`  int(11) NULL DEFAULT NULL ,
`agencod`  int(11) NULL DEFAULT NULL ,
`contnumero`  varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`recdtlancamento`  datetime NULL DEFAULT NULL ,
`recdtvencimento`  datetime NULL DEFAULT NULL ,
`recdtrecebimento`  datetime NULL DEFAULT NULL ,
`recvalorprincipal`  float NULL DEFAULT NULL ,
`recvalorjuros`  float NULL DEFAULT NULL ,
`recvalormora`  float NULL DEFAULT NULL ,
`recvalortotal`  float NULL DEFAULT NULL ,
PRIMARY KEY (`reccod`),
UNIQUE INDEX `XPKtblrecebimentoxparcela` (`reccod`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=47

;

-- ----------------------------
-- Records of tbl_recebimento_x_parcelas
-- ----------------------------
BEGIN;
INSERT INTO `tbl_recebimento_x_parcelas` VALUES ('13', '1', '1', '1', '2', '2', '2', '65579878', '2012-10-29 00:00:00', '2012-11-28 00:00:00', '2012-10-29 14:32:29', '10000', '100', '12', '10112'), ('14', '2', '1', '1', '2', '1', '1', '57687678', '2012-10-29 00:00:00', '2012-12-28 00:00:00', '2012-10-29 14:33:33', '10000', null, null, '10000'), ('15', '3', '1', '1', '2', null, null, null, '2012-10-29 14:25:14', '2013-01-27 00:00:00', null, '10000', null, null, '10000'), ('16', '4', '1', '1', '2', null, null, null, '2012-10-29 14:25:14', '2013-02-26 00:00:00', null, '10000', null, null, '10000'), ('17', '1', '2', '1', '4', '1', '1', '57687678', '2012-10-29 00:00:00', '2012-11-28 00:00:00', '2012-10-31 09:45:24', '5000', null, null, '5000'), ('18', '2', '2', '1', '4', null, null, null, '2012-10-29 14:48:01', '2012-12-28 00:00:00', null, '5000', null, null, '5000'), ('29', '1', '3', '1', '2', '3', '3', '69289279', '2012-10-31 00:00:00', '2012-11-30 00:00:00', '2012-10-31 09:45:50', '376.5', '12', '1.2', '389.7'), ('30', '2', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2012-12-30 00:00:00', null, '376.5', null, null, '376.5'), ('31', '3', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-01-29 00:00:00', null, '376.5', null, null, '376.5'), ('32', '4', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-02-28 00:00:00', null, '376.5', null, null, '376.5'), ('33', '5', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-03-30 00:00:00', null, '376.5', null, null, '376.5'), ('34', '6', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-04-29 00:00:00', null, '376.5', null, null, '376.5'), ('35', '7', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-05-29 00:00:00', null, '376.5', null, null, '376.5'), ('36', '8', '3', '1', '2', null, null, null, '2012-10-31 09:31:24', '2013-06-28 00:00:00', null, '376.5', null, null, '376.5'), ('37', '9', '3', '1', '2', '2', '2', '32456879', '2012-10-31 00:00:00', '2013-07-28 00:00:00', '2013-07-23 16:03:23', '376.5', null, null, '376.5'), ('38', '10', '3', '1', '2', '2', '2', '32456879', '2012-10-31 00:00:00', '2013-08-27 00:00:00', null, '376.5', null, null, '376.5'), ('43', '1', '4', '1', '2', '1', '1', '57687678', '2013-07-23 00:00:00', '2013-08-22 00:00:00', null, '603', null, null, '603'), ('44', '2', '4', '1', '2', '2', '2', '65579878', '2013-07-23 00:00:00', '2013-09-21 00:00:00', null, '603', null, null, '603'), ('45', '3', '4', '1', '2', '1', '1', '57687678', '2013-07-23 00:00:00', '2013-10-21 00:00:00', null, '603', null, null, '603'), ('46', '4', '4', '1', '2', '3', '3', '15152398', '2013-07-23 00:00:00', '2013-11-20 00:00:00', null, '603', null, null, '603');
COMMIT;

-- ----------------------------
-- Table structure for tbl_sec_apps
-- ----------------------------
CREATE TABLE `tbl_sec_apps` (
`app_name`  varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`app_type`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`description`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`app_name`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_sec_apps
-- ----------------------------
BEGIN;
INSERT INTO `tbl_sec_apps` VALUES ('aba_relacoes_bancarias', 'aba', 'Aba de Relações Bancárias'), ('blank_boleto_php', 'blank', 'Blank Boleto'), ('calendar_tbl_evento', 'calendar', 'Agenda de Contas a Receber'), ('calendar_tbl_evento_pag', 'calendar', 'Agenda de Contas a Receber'), ('ctr_default', 'contr', 'Controle Flash'), ('form_tbl_agencias', 'form', 'Cadastro de Agências'), ('form_tbl_bancos', 'form', 'Cadastro de Bancos'), ('form_tbl_contas_correntes', 'form', 'Cadastro de Contas Correntes'), ('form_tbl_empresas', 'form', 'Cadastro de Empresas'), ('form_tbl_estados', 'form', 'Cadastro de Estados'), ('form_tbl_faturamento_md', 'form', 'Cadastro de Contas a Receber'), ('form_tbl_faturamento_x_itens_md', 'form', 'Cadastro de Itens de Fatura'), ('form_tbl_organizacoes', 'form', 'Cadastro de Organizações'), ('form_tbl_pagamentos', 'form', 'Cadastro de Contas a Pagar'), ('form_tbl_planos_contas', 'form', 'Cadastro de Planos de Contas'), ('form_tbl_portadores', 'form', 'Cadastro de Portadores'), ('form_tbl_produtos', 'form', 'Cadastro de Produtos'), ('form_tbl_recebimento_x_parcelas', 'form', 'Gerador de Boleto'), ('grid_boletos_gerados', 'cons', 'Boletos gerados'), ('grid_contas_pagar', 'cons', 'Contas a Pagar'), ('grid_contas_pagar_detalhe', 'cons', 'Detalhe de contas a pagar'), ('grid_contas_receber', 'cons', 'Contas a Receber'), ('grid_fluxo_caixa', 'cons', 'Fluxo de Caixa'), ('grid_fluxo_caixa_detalhe', 'cons', 'Detalhe de fluxo de caixa'), ('grid_tbl_agencias', 'cons', 'Consulta de Agências'), ('grid_tbl_bancos', 'cons', 'Consulta de Bancos'), ('grid_tbl_contas_correntes', 'cons', 'Consulta de Contas Correntes'), ('grid_tbl_empresas', 'cons', 'Consulta de Empresas'), ('grid_tbl_estados', 'cons', 'Consulta de Estados'), ('grid_tbl_faturamento', 'cons', 'Consulta de Faturamento'), ('grid_tbl_faturamento_x_itens', 'cons', 'Itens de Fatura'), ('grid_tbl_organizacoes', 'cons', 'Consulta de Organizações'), ('grid_tbl_pagamentos', 'cons', 'Consulta de Contas a Pagar'), ('grid_tbl_planos_contas', 'cons', 'Consulta de Planos de Contas'), ('grid_tbl_portadores', 'cons', 'Consulta de Portadores'), ('grid_tbl_produtos', 'cons', 'Consulta de Produtos'), ('grid_tbl_recebimento_x_parcelas', 'cons', 'Consulta de Parcelas Recebidas'), ('grid_tbl_recebimento_x_parcelas_detalhe', 'cons', 'Detalhe de parcelas'), ('menu', 'menu', 'Menu'), ('sec_change_pswd', 'contr', 'Mudar a senha'), ('sec_form_add_users', 'form', 'Adicionar usuários'), ('sec_form_edit_users', 'form', 'Editar Usuários'), ('sec_form_sec_apps', 'form', 'Cadastro de Aplicações'), ('sec_form_sec_groups', 'form', 'Cadastro de Grupos'), ('sec_form_sec_groups_apps', 'form', 'Gerenciamento de Grupos/Aplicações'), ('sec_grid_sec_apps', 'cons', 'Consulta de Aplicações'), ('sec_grid_sec_groups', 'cons', 'Consulta de Grupos'), ('sec_grid_sec_users', 'cons', 'Consulta de Usuários'), ('sec_Login', 'contr', 'Login de Usuário'), ('sec_retrieve_pswd', 'contr', 'Recuperar Senha'), ('sec_search_sec_groups', 'filter', 'Pesquisa de Grupos'), ('sec_sync_apps', 'contr', 'Ressincronizar aplicações');
COMMIT;

-- ----------------------------
-- Table structure for tbl_sec_groups
-- ----------------------------
CREATE TABLE `tbl_sec_groups` (
`group_id`  int(11) NOT NULL AUTO_INCREMENT ,
`description`  varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`group_id`),
UNIQUE INDEX `description` (`description`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=2

;

-- ----------------------------
-- Records of tbl_sec_groups
-- ----------------------------
BEGIN;
INSERT INTO `tbl_sec_groups` VALUES ('1', 'Administrador');
COMMIT;

-- ----------------------------
-- Table structure for tbl_sec_groups_apps
-- ----------------------------
CREATE TABLE `tbl_sec_groups_apps` (
`group_id`  int(11) NOT NULL ,
`app_name`  varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`priv_access`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_insert`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_delete`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_update`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_export`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_print`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`group_id`, `app_name`),
FOREIGN KEY (`group_id`) REFERENCES `tbl_sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
FOREIGN KEY (`app_name`) REFERENCES `tbl_sec_apps` (`app_name`) ON DELETE CASCADE ON UPDATE RESTRICT,
INDEX `tbl_sec_groups_apps_ibfk_2` (`app_name`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_sec_groups_apps
-- ----------------------------
BEGIN;
INSERT INTO `tbl_sec_groups_apps` VALUES ('1', 'aba_relacoes_bancarias', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'blank_boleto_php', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'calendar_tbl_evento', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'calendar_tbl_evento_pag', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'ctr_default', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'form_tbl_agencias', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_bancos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_contas_correntes', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_empresas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_estados', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_faturamento_md', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_faturamento_x_itens_md', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_organizacoes', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_pagamentos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_planos_contas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_portadores', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_produtos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'form_tbl_recebimento_x_parcelas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'grid_boletos_gerados', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_contas_pagar', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_contas_pagar_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_contas_receber', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_fluxo_caixa', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_fluxo_caixa_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_agencias', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_bancos', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_contas_correntes', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_empresas', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_estados', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_faturamento', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_faturamento_x_itens', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_organizacoes', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_pagamentos', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_planos_contas', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_portadores', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_produtos', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_recebimento_x_parcelas', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'grid_tbl_recebimento_x_parcelas_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'menu', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'sec_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'sec_form_add_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'sec_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'sec_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'sec_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'sec_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N'), ('1', 'sec_grid_sec_apps', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'sec_grid_sec_groups', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'sec_grid_sec_users', 'Y', 'N', 'N', 'N', 'Y', 'Y'), ('1', 'sec_Login', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'sec_retrieve_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'sec_search_sec_groups', 'Y', 'N', 'N', 'N', 'N', 'N'), ('1', 'sec_sync_apps', 'Y', 'N', 'N', 'N', 'N', 'N');
COMMIT;

-- ----------------------------
-- Table structure for tbl_sec_users
-- ----------------------------
CREATE TABLE `tbl_sec_users` (
`login`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`pswd`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`name`  varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email`  varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`usr_active`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`activation_code`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_admin`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`login`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_sec_users
-- ----------------------------
BEGIN;
INSERT INTO `tbl_sec_users` VALUES ('ADMIN', '21232f297a57a5a743894a0e4a801fc3', 'Administrador', 'admin@admin.com', 'Y', 'aDP9$wA!RvNMKsi$znAKO9rNDg2BM6qr', 'Y');
COMMIT;

-- ----------------------------
-- Table structure for tbl_sec_users_groups
-- ----------------------------
CREATE TABLE `tbl_sec_users_groups` (
`login`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`group_id`  int(11) NOT NULL ,
PRIMARY KEY (`login`, `group_id`),
FOREIGN KEY (`login`) REFERENCES `tbl_sec_users` (`login`) ON DELETE CASCADE ON UPDATE RESTRICT,
FOREIGN KEY (`group_id`) REFERENCES `tbl_sec_groups` (`group_id`) ON DELETE CASCADE ON UPDATE RESTRICT,
INDEX `tbl_sec_users_groups_ibfk_2` (`group_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_sec_users_groups
-- ----------------------------
BEGIN;
INSERT INTO `tbl_sec_users_groups` VALUES ('ADMIN', '1');
COMMIT;

-- ----------------------------
-- Table structure for tbl_usuario_x_organizacoes
-- ----------------------------
CREATE TABLE `tbl_usuario_x_organizacoes` (
`orgcod`  int(11) NOT NULL DEFAULT 0 ,
`login`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' ,
PRIMARY KEY (`orgcod`, `login`),
UNIQUE INDEX `XPKtblusuarioxorganizacao` (`orgcod`, `login`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tbl_usuario_x_organizacoes
-- ----------------------------
BEGIN;
INSERT INTO `tbl_usuario_x_organizacoes` VALUES ('1', 'ADMIN'), ('2', 'ADMIN'), ('3', 'ADMIN'), ('4', 'ADMIN');
COMMIT;

-- ----------------------------
-- Auto increment value for tbl_agencias
-- ----------------------------
ALTER TABLE `tbl_agencias` AUTO_INCREMENT=4;

-- ----------------------------
-- Auto increment value for tbl_bancos
-- ----------------------------
ALTER TABLE `tbl_bancos` AUTO_INCREMENT=4;

-- ----------------------------
-- Auto increment value for tbl_configuracoes
-- ----------------------------
ALTER TABLE `tbl_configuracoes` AUTO_INCREMENT=2;

-- ----------------------------
-- Auto increment value for tbl_empresas
-- ----------------------------
ALTER TABLE `tbl_empresas` AUTO_INCREMENT=3;

-- ----------------------------
-- Auto increment value for tbl_evento
-- ----------------------------
ALTER TABLE `tbl_evento` AUTO_INCREMENT=39;

-- ----------------------------
-- Auto increment value for tbl_evento_pag
-- ----------------------------
ALTER TABLE `tbl_evento_pag` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tbl_faturamento
-- ----------------------------
ALTER TABLE `tbl_faturamento` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tbl_faturamento_x_itens
-- ----------------------------
ALTER TABLE `tbl_faturamento_x_itens` AUTO_INCREMENT=9;

-- ----------------------------
-- Auto increment value for tbl_instrucao_boleto
-- ----------------------------
ALTER TABLE `tbl_instrucao_boleto` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tbl_organizacoes
-- ----------------------------
ALTER TABLE `tbl_organizacoes` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tbl_pagamentos
-- ----------------------------
ALTER TABLE `tbl_pagamentos` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tbl_planos_contas
-- ----------------------------
ALTER TABLE `tbl_planos_contas` AUTO_INCREMENT=15;

-- ----------------------------
-- Auto increment value for tbl_portadores
-- ----------------------------
ALTER TABLE `tbl_portadores` AUTO_INCREMENT=6;

-- ----------------------------
-- Auto increment value for tbl_produtos
-- ----------------------------
ALTER TABLE `tbl_produtos` AUTO_INCREMENT=8;

-- ----------------------------
-- Auto increment value for tbl_recebimento_x_parcelas
-- ----------------------------
ALTER TABLE `tbl_recebimento_x_parcelas` AUTO_INCREMENT=47;

-- ----------------------------
-- Auto increment value for tbl_sec_groups
-- ----------------------------
ALTER TABLE `tbl_sec_groups` AUTO_INCREMENT=2;
