-- ----------------------------
-- Table structure for "tb_authors"
-- ----------------------------
DROP TABLE "tb_authors";
CREATE TABLE "tb_authors" (
"fld_username"  VARCHAR(50) NOT NULL,
"fld_fullname"  VARCHAR(250) NOT NULL,
"fld_password"  VARCHAR(100) NOT NULL,
"fld_email"  VARCHAR(150) NOT NULL,
"fld_role_id"  INTEGER(11) NOT NULL,
"fld_status_id"  INTEGER(11) NOT NULL,
"fld_active"  VARCHAR,
"fld_activation_code"  VARCHAR,
"fld_priv_admin"  VARCHAR,
PRIMARY KEY ("fld_username")
);

-- ----------------------------
-- Records of tb_authors
-- ----------------------------
INSERT INTO "tb_authors" VALUES ('admin', 'Administrator', 'admin', 'admin@scriptcase.net', 5, 1, null, null, null);
INSERT INTO "tb_authors" VALUES ('hellen', 'Hellen Moore', 'hellen', 'hellen@scriptcase.net', 2, 1, null, null, null);
INSERT INTO "tb_authors" VALUES ('matthew', 'Matthew Hendrix', 'matthew', 'matthew@scriptcase.net', 4, 1, null, null, null);
INSERT INTO "tb_authors" VALUES ('paul', 'Paul Simon', 'paul', 'paul@scriptcase.net', 2, 1, null, null, null);
INSERT INTO "tb_authors" VALUES ('stewart', 'Sid Stewart ', 'stewart', 'stewart@scriptcase.net', 4, 1, null, null, null);
INSERT INTO "tb_authors" VALUES ('viewer', 'Viewer User', 'viewer', null, 1, 1, null, null, null);

-- ----------------------------
-- Table structure for "tb_categories"
-- ----------------------------
DROP TABLE "tb_categories";
CREATE TABLE "tb_categories" (
"fld_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"fld_description"  VARCHAR(100) NOT NULL
);

-- ----------------------------
-- Records of tb_categories
-- ----------------------------
INSERT INTO "tb_categories" VALUES (1, 'Call Center');
INSERT INTO "tb_categories" VALUES (2, 'Financial');
INSERT INTO "tb_categories" VALUES (3, 'Marketing');
INSERT INTO "tb_categories" VALUES (4, 'Presentations');
INSERT INTO "tb_categories" VALUES (5, 'Website Design');
INSERT INTO "tb_categories" VALUES (6, 'Website Technical');

-- ----------------------------
-- Table structure for "tb_documents"
-- ----------------------------
DROP TABLE "tb_documents";
CREATE TABLE "tb_documents" (
"fld_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"fld_title"  VARCHAR(150) NOT NULL,
"fld_username"  VARCHAR(50) NOT NULL,
"fld_date"  DATE NOT NULL,
"fld_doc_type_id"  INTEGER NOT NULL,
"fld_keywords"  VARCHAR(250),
"fld_category_id"  INTEGER NOT NULL
);

-- ----------------------------
-- Records of tb_documents
-- ----------------------------
INSERT INTO "tb_documents" VALUES (1, 'End Stats', 'admin', '2014-01-10 10:00:00:000', 8, 'call center volume users supported', 1);
INSERT INTO "tb_documents" VALUES (2, 'Technical Requirements', 'admin', '2014-02-03 10:00:00', 5, 'website preview user cases timeline requirements', 6);
INSERT INTO "tb_documents" VALUES (3, 'Concept 1', 'stewart', '2014-02-10 10:00:00', 1, 'concept website design graphics draft', 5);
INSERT INTO "tb_documents" VALUES (4, 'Incentive Plan', 'hellen', '2014-02-10 10:00:00', 10, 'incentive plan customers switch marketing strategy phone vs online', 3);
INSERT INTO "tb_documents" VALUES (5, 'Cost per User Analysis', 'paul', '2014-02-10 10:00:00', 3, 'customer cost online analysis', 2);
INSERT INTO "tb_documents" VALUES (6, 'Concept 2', 'admin', '2014-02-24 16:41:36', 1, 'concept design website draft graphics', 5);
INSERT INTO "tb_documents" VALUES (7, 'Costs before and after implementation', 'admin', '2014-03-11 10:51:07', 3, 'cost analysis budget financial data', 2);
INSERT INTO "tb_documents" VALUES (8, 'Security Issues and Requirements', 'paul', '2014-02-17 10:53:10', 6, null, 6);
INSERT INTO "tb_documents" VALUES (9, 'Final Proposal Slides', 'matthew', '2014-03-25 10:00:00', 2, 'final website version management presentation powerpoint', 4);
INSERT INTO "tb_documents" VALUES (10, 'Website Launch Email', 'stewart', '2014-03-25 10:00:00', 4, 'email marketing new launch', 3);

-- ----------------------------
-- Table structure for "tb_documents_active"
-- ----------------------------
DROP TABLE "tb_documents_active";
CREATE TABLE "tb_documents_active" (
"fld_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"fld_document_id"  INTEGER NOT NULL,
"fld_file"  BLOB,
"fld_filename"  VARCHAR(150) NOT NULL,
"fld_filesize"  VARCHAR(45),
"fld_date"  DATE NOT NULL,
"fld_username"  VARCHAR(50) NOT NULL
);

-- ----------------------------
-- Records of tb_documents_active
-- ----------------------------
INSERT INTO "tb_documents_active" VALUES (1, 1, X'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', 'WebsiteFinal.ppt', null, '2014-03-10 15:00:00', 'admin');
INSERT INTO "tb_documents_active" VALUES (2, 1, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074940000006010000E1000200B004C10002000000E20000005C007000140000426F73746F6E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00B30500000000060053686565743185000E00EA0600000000060053686565743285000E00F1070000000006005368656574338C00040001000100C1010800C101000060690100FC001D0001000000010000001200004461746120776F756C642062652068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0749400000060100000B0214000000000000000000010000006F060000A90600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00031000040000000100100010000404EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A20700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000040404000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0749400000060100000B021000000000000000000000000000A90800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000808AC025B3BBC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C0000000000000460000000000000000000000000000000000000000FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000', 'Call Center.xls', null, '2014-03-10 15:01:49', 'admin');
INSERT INTO "tb_documents_active" VALUES (10, 10, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Content.doc', null, '2014-03-13 11:42:16', 'paul');
INSERT INTO "tb_documents_active" VALUES (11, 3, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF000000000000100000000000040000160400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001600000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC000000000000009F030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000001E03000002000000200300000000000020030000000000002003000000000000200300000000000020030000000000002003000024000000550400002002000075060000B4000000440300001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA0000000000000044030000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA0000000000000059030000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA000000000000001E0300000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA000000000000001E030000000000002A010000F40100002A0100000000000000000000000000001E03000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001E03000000000000FA00000000000000EE0000000C0000000098DE8DB3BBC101BC0000001A000000D600000000000000100100000A0000001E0300000000000000000000000000001E030000000000006F030000300000009F030000000000001E0300000000000029070000000000001A0100001000000029070000000000001E030000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E7420776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000160400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000010004000016040000FD00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000404000101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E00740000000000000000000000000000000000160000000500000C00000000FFFFFFFF0000000018000000980000000030000000000000008000000080000400001604000003000000000400001604000004000000000400001604000005000000000000001100000015000000180000000700040007000000000018000000040000000000150000001800000004000700FFFF06000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000300043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E0074002E0064006F006300FF40018000001500000015000000D09E64004800480015000000000000000800000000000000021000000000000000160000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D00200006801000000008DB262A68DB262A6000000000200000000000300000012000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000320073741E000000130000004D6963726F736F667420576F726420392E3000704000000000000000000000004000000000264C6AB3BBC1014000000000264C6AB3BBC101030000000100000003000000030000000300000012000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001600000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C0000000000000460000000000000000000000000098DE8DB3BBC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000098DE8DB3BBC1010098DE8DB3BBC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Content.doc', null, '2014-03-14 09:26:37', 'admin');
INSERT INTO "tb_documents_active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administrator.png', null, '2014-03-14 16:41:36', 'admin');
INSERT INTO "tb_documents_active" VALUES (21, 4, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Incentive.doc', null, '2014-03-25 10:23:25', 'admin');
INSERT INTO "tb_documents_active" VALUES (22, 1, X'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', 'Call Center 2013 stats.xls', null, '2014-03-25 10:26:28', 'admin');
INSERT INTO "tb_documents_active" VALUES (23, 3, X'3C68746D6C20786D6C6E733A6F3D2275726E3A736368656D61732D6D6963726F736F66742D636F6D3A6F66666963653A6F6666696365220D0A786D6C6E733A773D2275726E3A736368656D61732D6D6963726F736F66742D636F6D3A6F66666963653A776F7264220D0A786D6C6E733D22687474703A2F2F7777772E77332E6F72672F54522F5245432D68746D6C3430223E0D0A0D0A3C686561643E0D0A3C6D65746120687474702D65717569763D436F6E74656E742D5479706520636F6E74656E743D22746578742F68746D6C3B20636861727365743D77696E646F77732D31323532223E0D0A3C6D657461206E616D653D50726F67496420636F6E74656E743D576F72642E446F63756D656E743E0D0A3C6D657461206E616D653D47656E657261746F7220636F6E74656E743D224D6963726F736F667420576F72642039223E0D0A3C6D657461206E616D653D4F726967696E61746F7220636F6E74656E743D224D6963726F736F667420576F72642039223E0D0A3C6C696E6B2072656C3D46696C652D4C69737420687265663D222E2F4D61726B6574696E67456D61696C5F66696C65732F66696C656C6973742E786D6C223E0D0A3C7469746C653E436F6E74656E74206F75746C696E6520776F756C6420676F20686572653C2F7469746C653E0D0A3C212D2D5B696620677465206D736F20395D3E3C786D6C3E0D0A203C6F3A446F63756D656E7450726F706572746965733E0D0A20203C6F3A417574686F723E426F73746F6E2053797374656D732047726F75703C2F6F3A417574686F723E0D0A20203C6F3A4C617374417574686F723E426F73746F6E2053797374656D732047726F75703C2F6F3A4C617374417574686F723E0D0A20203C6F3A5265766973696F6E3E323C2F6F3A5265766973696F6E3E0D0A20203C6F3A546F74616C54696D653E313C2F6F3A546F74616C54696D653E0D0A20203C6F3A437265617465643E323030322D30322D32325431353A31343A30305A3C2F6F3A437265617465643E0D0A20203C6F3A4C61737453617665643E323030322D30322D32325431353A31343A30305A3C2F6F3A4C61737453617665643E0D0A20203C6F3A50616765733E313C2F6F3A50616765733E0D0A20203C6F3A576F7264733E343C2F6F3A576F7264733E0D0A20203C6F3A436861726163746572733E32343C2F6F3A436861726163746572733E0D0A20203C6F3A436F6D70616E793E496E747569743C2F6F3A436F6D70616E793E0D0A20203C6F3A4C696E65733E313C2F6F3A4C696E65733E0D0A20203C6F3A506172616772617068733E313C2F6F3A506172616772617068733E0D0A20203C6F3A43686172616374657273576974685370616365733E32393C2F6F3A43686172616374657273576974685370616365733E0D0A20203C6F3A56657273696F6E3E392E323732303C2F6F3A56657273696F6E3E0D0A203C2F6F3A446F63756D656E7450726F706572746965733E0D0A3C2F786D6C3E3C215B656E6469665D2D2D3E0D0A3C7374796C653E0D0A3C212D2D0D0A202F2A205374796C6520446566696E6974696F6E73202A2F0D0A702E4D736F4E6F726D616C2C206C692E4D736F4E6F726D616C2C206469762E4D736F4E6F726D616C0D0A097B6D736F2D7374796C652D706172656E743A22223B0D0A096D617267696E3A30696E3B0D0A096D617267696E2D626F74746F6D3A2E3030303170743B0D0A096D736F2D706167696E6174696F6E3A7769646F772D6F727068616E3B0D0A09666F6E742D73697A653A31322E3070743B0D0A09666F6E742D66616D696C793A2254696D6573204E657720526F6D616E223B0D0A096D736F2D666172656173742D666F6E742D66616D696C793A2254696D6573204E657720526F6D616E223B7D0D0A40706167652053656374696F6E310D0A097B73697A653A382E35696E2031312E30696E3B0D0A096D617267696E3A312E30696E20312E3235696E20312E30696E20312E3235696E3B0D0A096D736F2D6865616465722D6D617267696E3A2E35696E3B0D0A096D736F2D666F6F7465722D6D617267696E3A2E35696E3B0D0A096D736F2D70617065722D736F757263653A303B7D0D0A6469762E53656374696F6E310D0A097B706167653A53656374696F6E313B7D0D0A2D2D3E0D0A3C2F7374796C653E0D0A3C2F686561643E0D0A0D0A3C626F6479206C616E673D454E2D5553207374796C653D277461622D696E74657276616C3A2E35696E273E0D0A0D0A3C64697620636C6173733D53656374696F6E313E0D0A0D0A3C7020636C6173733D4D736F4E6F726D616C3E436F6E74656E7420776F756C6420676F20686572653C2F703E0D0A0D0A3C2F6469763E0D0A0D0A3C2F626F64793E0D0A0D0A3C2F68746D6C3E0D0A', 'Concept1.htm', null, '2014-03-25 10:36:24', 'admin');
INSERT INTO "tb_documents_active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oncept2.htm', null, '2014-03-25 10:37:14', 'admin');
INSERT INTO "tb_documents_active" VALUES (25, 6, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Content outline.doc', null, '2014-03-25 10:37:14', 'admin');
INSERT INTO "tb_documents_active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arketingEmail.htm', null, '2014-03-25 10:41:12', 'admin');
INSERT INTO "tb_documents_active" VALUES (27, 10, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000001B00000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF1E000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A000000FEFFFFFFFEFFFFFF1D000000FEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF020000002008020000000000C00000000000004600000000000000000000000070DDDE073048CF011C000000C00200000000000057006F0072006B0062006F006F006B000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001200020104000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000200000009310000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000E000000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000040000000C010000000000000908100000060500AB1FCD07C900010006040000E1000200B004C10002000000E20000005C0070000500005669746F72202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002001000190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001E00680101003800BC020000000200020701430061006D00620072006900610031001E002C0101003800BC020000000200020701430061006C00690062007200690031001E00040101003800BC020000000200020701430061006C00690062007200690031001E00DC0001003800BC020000000200020701430061006C00690062007200690031001E00DC000000110090010000000200020701430061006C00690062007200690031001E00DC000000140090010000000200020701430061006C00690062007200690031001E00DC0000003C0090010000000200020701430061006C00690062007200690031001E00DC0000003E0090010000000200020701430061006C00690062007200690031001E00DC0001003F00BC020000000200020701430061006C00690062007200690031001E00DC0001003400BC020000000200020701430061006C00690062007200690031001E00DC000000340090010000000200020701430061006C00690062007200690031001E00DC0001000900BC020000000200020701430061006C00690062007200690031001E00DC0000000A0090010000000200020701430061006C00690062007200690031001A00C8000000FF7F9001000000000002050141007200690061006C0031001E00DC000200170090010000000200020701430061006C00690062007200690031001E00DC0001000800BC020000000200020701430061006C00690062007200690031001E00DC000000090090010000000200020701430061006C00690062007200690031001E00DC000000080090010000000200020701430061006C0069006200720069001E041E000500190000225224225C20232C2323303B5C2D225224225C20232C2323301E04230006001E0000225224225C20232C2323303B5B5265645D5C2D225224225C20232C2323301E04240007001F0000225224225C20232C2323302E30303B5C2D225224225C20232C2323302E30301E0429000800240000225224225C20232C2323302E30303B5B5265645D5C2D225224225C20232C2323302E30301E043E002A003900005F2D225224225C202A20232C2323305F2D3B5C2D225224225C202A20232C2323305F2D3B5F2D225224225C202A20222D225F2D3B5F2D405F2D1E042C0029002700005F2D2A20232C2323305F2D3B5C2D2A20232C2323305F2D3B5F2D2A20222D225F2D3B5F2D405F2D1E0446002C004100005F2D225224225C202A20232C2323302E30305F2D3B5C2D225224225C202A20232C2323302E30305F2D3B5F2D225224225C202A20222D223F3F5F2D3B5F2D405F2D1E0434002B002F00005F2D2A20232C2323302E30305F2D3B5C2D2A20232C2323302E30305F2D3B5F2D2A20222D223F3F5F2D3B5F2D405F2D1E041C00A400170000222422232C2323305F293B5C28222422232C2323305C291E042100A5001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E042200A6001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E042700A700220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E043700A8003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E00A9002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F00AA003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E043600AB003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140016000000F5FF200000B400000000000000049F20E000140016000000F5FF200000B40000000000000004AD20E000140016000000F5FF200000B40000000000000004AA20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B400000000000000049B20E000140016000000F5FF200000B40000000000000004AF20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B400000000000000049D20E000140016000000F5FF200000B400000000000000048B20E000140016000000F5FF200000B40000000000000004AE20E000140016000000F5FF200000B40000000000000004AC20E000140016000000F5FF200000B40000000000000004B320E000140015000000F5FF200000B400000000000000049E20E000140015000000F5FF200000B400000000000000049D20E000140015000000F5FF200000B400000000000000048B20E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B420E000140009000000F5FF200000B40000000000000004AA20E00014000E000000F5FF200000941111970B970B00049620E000140010000000F5FF200000946666BF1FBF1F0004B720E00014000F000000F5FF200000D400600000001A0000C020E000140015000000F5FF200000B40000000000000004BE20E000140015000000F5FF200000B400000000000000048A20E000140015000000F5FF200000B40000000000000004B920E000140015000000F5FF200000B40000000000000004A420E000140015000000F5FF200000B40000000000000004B120E000140015000000F5FF200000B40000000000000004B520E00014000C000000F5FF200000941111970B970B0004AF20E00014000A000000F5FF200000B40000000000000004AD20E00014000100AA00F5FF200000F80000000000000000C020E00014000100A800F5FF200000F80000000000000000C020E00014000B000000F5FF200000B40000000000000004AB20E000140012000000F5FF2000009C1111160B160B00049A20E000140001000900F5FF200000F80000000000000000C020E00014000D000000F5FF200000941111BF1FBF1F00049620E00014000100AB00F5FF200000F80000000000000000C020E00014000100A900F5FF200000F80000000000000000C020E000140011000000F5FF200000F40000000000000000C020E000140013000000F5FF200000F40000000000000000C020E000140005000000F5FF200000F40000000000000000C020E000140006000000F5FF200000D400500000001F0000C020E000140007000000F5FF200000D400500000000B0000C020E000140008000000F5FF200000D400200000000F0000C020E000140008000000F5FF200000F40000000000000000C020E000140014000000F5FF200000D4006100003E1F0000C0207C0814007C080000000000000000000000003E005D372EC07D082D007D080000000000000000000000003800000002000D001400030000000300000030305C293B5F282A0E000500017D0841007D080000000000000000000000003900000003000D001400030000000300000030305C293B5F282A0E000500020800140003000000040000003B5F28405F292D3B7D0841007D080000000000000000000000003A00000003000D001400030000000300000030305C293B5F282A0E00050002080014000300FF3F040000003B5F28405F292D3B7D0841007D080000000000000000000000003B00000003000D001400030000000300000030305C293B5F282A0E000500020800140003003233040000003B5F28405F292D3B7D082D007D080000000000000000000000003C00000002000D001400030000000300000030305C293B5F282A0E000500027D0841007D080000000000000000000000002200000003000D00140002000000006100FF30305C293B5F282A0E000500020400140002000000C6EFCEFF3B5F28405F292D3B7D0841007D080000000000000000000000002D00000003000D001400020000009C0006FF30305C293B5F282A0E000500020400140002000000FFC7CEFF3B5F28405F292D3B7D0841007D080000000000000000000000003000000003000D001400020000009C6500FF30305C293B5F282A0E000500020400140002000000FFEB9CFF3B5F28405F292D3B7D0891007D080000000000000000000000002C00000007000D001400020000003F3F76FF30305C293B5F282A0E000500020400140002000000FFCC99FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0891007D080000000000000000000000003300000007000D001400020000003F3F3FFF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D0891007D080000000000000000000000002300000007000D00140002000000FA7D00FF30305C293B5F282A0E000500020400140002000000F2F2F2FF3B5F28405F292D3B07001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0841007D080000000000000000000000002500000003000D00140002000000FA7D00FF30305C293B5F282A0E000500020800140002000000FF8001FF3B5F28405F292D3B7D0891007D080000000000000000000000002400000007000D001400030000000000000030305C293B5F282A0E000500020400140002000000A5A5A5FF3B5F28405F292D3B07001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D082D007D080000000000000000000000003600000002000D00140002000000FF0000FF30305C293B5F282A0E000500027D0878007D080000000000000000000000003100000005000400140002000000FFFFCCFF30305C293B5F282A0700140002000000B2B2B2FF00A5A5A5FF3B5F280800140002000000B2B2B2FF003F3F3FFF2020200900140002000000B2B2B2FF003F3F3FFF2020200A00140002000000B2B2B2FF003F3F3FFF0000007D082D007D080000000000000000000000003700000002000D001400020000007F7F7FFF30305C293B5F282A0E000500027D0855007D080000000000000000000000003D00000004000D001400030000000100000030305C293B5F282A0E000500020700140003000000040000003B5F28080014000208001400030000000400000020202009001400027D0841007D080000000000000000000000002600000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000040000003B5F2808001400027D0841007D080000000000000000000000001000000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566040000003B5F2808001400027D0841007D080000000000000000000000001600000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C040000003B5F2808001400027D0841007D080000000000000000000000001C00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233040000003B5F2808001400027D0841007D080000000000000000000000002700000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000050000003B5F2808001400027D0841007D080000000000000000000000001100000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566050000003B5F2808001400027D0841007D080000000000000000000000001700000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C050000003B5F2808001400027D0841007D080000000000000000000000001D00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233050000003B5F2808001400027D0841007D080000000000000000000000002800000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000060000003B5F2808001400027D0841007D080000000000000000000000001200000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566060000003B5F2808001400027D0841007D080000000000000000000000001800000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C060000003B5F2808001400027D0841007D080000000000000000000000001E00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233060000003B5F2808001400027D0841007D080000000000000000000000002900000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000070000003B5F2808001400027D0841007D080000000000000000000000001300000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566070000003B5F2808001400027D0841007D080000000000000000000000001900000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C070000003B5F2808001400027D0841007D080000000000000000000000001F00000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233070000003B5F2808001400027D0841007D080000000000000000000000002A00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000080000003B5F2808001400027D0841007D080000000000000000000000001400000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566080000003B5F2808001400027D0841007D080000000000000000000000001A00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C080000003B5F2808001400027D0841007D080000000000000000000000002000000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233080000003B5F2808001400027D0841007D080000000000000000000000002B00000003000D001400030000000000000030305C293B5F282A0E000500020400140003000000090000003B5F2808001400027D0841007D080000000000000000000000001500000003000D001400030000000100000030305C293B5F282A0E000500020400140003006566090000003B5F2808001400027D0841007D080000000000000000000000001B00000003000D001400030000000100000030305C293B5F282A0E00050002040014000300CC4C090000003B5F2808001400027D0841007D080000000000000000000000002100000003000D001400030000000000000030305C293B5F282A0E000500020400140003003233090000003B5F2808001400029302120010000D0000323025202D20CA6E666173653192084D0092080000000000000000000001041EFF0D0032003000250020002D002000CA006E00660061007300650031000000030001000C0007046566DBE5F1FF05000C0007010000000000FF25000500029302120011000D0000323025202D20CA6E666173653292084D00920800000000000000000000010422FF0D0032003000250020002D002000CA006E00660061007300650032000000030001000C0007056566F2DDDCFF05000C0007010000000000FF25000500029302120012000D0000323025202D20CA6E666173653392084D00920800000000000000000000010426FF0D0032003000250020002D002000CA006E00660061007300650033000000030001000C0007066566EAF1DDFF05000C0007010000000000FF25000500029302120013000D0000323025202D20CA6E666173653492084D0092080000000000000000000001042AFF0D0032003000250020002D002000CA006E00660061007300650034000000030001000C0007076566E5E0ECFF05000C0007010000000000FF25000500029302120014000D0000323025202D20CA6E666173653592084D0092080000000000000000000001042EFF0D0032003000250020002D002000CA006E00660061007300650035000000030001000C0007086566DBEEF3FF05000C0007010000000000FF25000500029302120015000D0000323025202D20CA6E666173653692084D00920800000000000000000000010432FF0D0032003000250020002D002000CA006E00660061007300650036000000030001000C0007096566FDE9D9FF05000C0007010000000000FF25000500029302120016000D0000343025202D20CA6E666173653192084D0092080000000000000000000001041FFF0D0034003000250020002D002000CA006E00660061007300650031000000030001000C000704CC4CB8CCE4FF05000C0007010000000000FF25000500029302120017000D0000343025202D20CA6E666173653292084D00920800000000000000000000010423FF0D0034003000250020002D002000CA006E00660061007300650032000000030001000C000705CC4CE6B9B8FF05000C0007010000000000FF25000500029302120018000D0000343025202D20CA6E666173653392084D00920800000000000000000000010427FF0D0034003000250020002D002000CA006E00660061007300650033000000030001000C000706CC4CD7E4BCFF05000C0007010000000000FF25000500029302120019000D0000343025202D20CA6E666173653492084D0092080000000000000000000001042BFF0D0034003000250020002D002000CA006E00660061007300650034000000030001000C000707CC4CCCC0DAFF05000C0007010000000000FF2500050002930212001A000D0000343025202D20CA6E666173653592084D0092080000000000000000000001042FFF0D0034003000250020002D002000CA006E00660061007300650035000000030001000C000708CC4CB6DDE8FF05000C0007010000000000FF2500050002930212001B000D0000343025202D20CA6E666173653692084D00920800000000000000000000010433FF0D0034003000250020002D002000CA006E00660061007300650036000000030001000C000709CC4CFCD5B4FF05000C0007010000000000FF2500050002930212001C000D0000363025202D20CA6E666173653192084D00920800000000000000000000010420FF0D0036003000250020002D002000CA006E00660061007300650031000000030001000C000704323395B3D7FF05000C0007000000FFFFFFFF2500050002930212001D000D0000363025202D20CA6E666173653292084D00920800000000000000000000010424FF0D0036003000250020002D002000CA006E00660061007300650032000000030001000C0007053233D99795FF05000C0007000000FFFFFFFF2500050002930212001E000D0000363025202D20CA6E666173653392084D00920800000000000000000000010428FF0D0036003000250020002D002000CA006E00660061007300650033000000030001000C0007063233C2D69AFF05000C0007000000FFFFFFFF2500050002930212001F000D0000363025202D20CA6E666173653492084D0092080000000000000000000001042CFF0D0036003000250020002D002000CA006E00660061007300650034000000030001000C0007073233B2A1C7FF05000C0007000000FFFFFFFF25000500029302120020000D0000363025202D20CA6E666173653592084D00920800000000000000000000010430FF0D0036003000250020002D002000CA006E00660061007300650035000000030001000C000708323393CDDDFF05000C0007000000FFFFFFFF25000500029302120021000D0000363025202D20CA6E666173653692084D00920800000000000000000000010434FF0D0036003000250020002D002000CA006E00660061007300650036000000030001000C0007093233FAC090FF05000C0007000000FFFFFFFF2500050002930208002200030000426F6D9208390092080000000000000000000001011AFF030042006F006D000000030001000C0005FF0000C6EFCEFF05000C0005FF0000006100FF250005000293020C00230007000043E16C63756C6F92087900920800000000000000000000010216FF07004300E1006C00630075006C006F000000070001000C0005FF0000F2F2F2FF05000C0005FF0000FA7D00FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093021A00240015000043E96C756C61206465205665726966696361E7E36F92089500920800000000000000000000010217FF15004300E9006C0075006C006100200064006500200056006500720069006600690063006100E700E3006F000000070001000C0005FF0000A5A5A5FF05000C0007000000FFFFFFFF250005000206000E0005FF00003F3F3FFF060007000E0005FF00003F3F3FFF060008000E0005FF00003F3F3FFF060009000E0005FF00003F3F3FFF060093021500250010000043E96C756C612056696E63756C61646192085500920800000000000000000000010218FF10004300E9006C0075006C0061002000560069006E00630075006C006100640061000000030005000C0005FF0000FA7D00FF250005000207000E0005FF0000FF8001FF060093020C002600070000CA6E66617365319208410092080000000000000000000001041DFF0700CA006E00660061007300650031000000030001000C00070400004F81BDFF05000C0007000000FFFFFFFF250005000293020C002700070000CA6E666173653292084100920800000000000000000000010421FF0700CA006E00660061007300650032000000030001000C0007050000C0504DFF05000C0007000000FFFFFFFF250005000293020C002800070000CA6E666173653392084100920800000000000000000000010425FF0700CA006E00660061007300650033000000030001000C00070600009BBB59FF05000C0007000000FFFFFFFF250005000293020C002900070000CA6E666173653492084100920800000000000000000000010429FF0700CA006E00660061007300650034000000030001000C00070700008064A2FF05000C0007000000FFFFFFFF250005000293020C002A00070000CA6E66617365359208410092080000000000000000000001042DFF0700CA006E00660061007300650035000000030001000C00070800004BACC6FF05000C0007000000FFFFFFFF250005000293020C002B00070000CA6E666173653692084100920800000000000000000000010431FF0700CA006E00660061007300650036000000030001000C0007090000F79646FF05000C0007000000FFFFFFFF250005000293020C002C00070000456E747261646192087900920800000000000000000000010214FF070045006E00740072006100640061000000070001000C0005FF0000FFCC99FF05000C0005FF00003F3F76FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093020E002D00090000496E636F727265746F9208450092080000000000000000000001011BFF090049006E0063006F0072007200650074006F000000030001000C0005FF0000FFC7CEFF05000C0005FF00009C0006FF2500050002930204002E8004FF92082000920800000000000000000000010504FF05004D006F0065006400610000000000930204002F8007FF92082800920800000000000000000000010507FF09004D006F0065006400610020005B0030005D000000000093020B0030000600004E657574726192083F0092080000000000000000000001011CFF06004E00650075007400720061000000030001000C0005FF0000FFEB9CFF05000C0005FF00009C6500FF250005000293020400008000FF92082200920800000000000000000000010100FF06004E006F0072006D0061006C00000000009302090031000400004E6F74619208620092080000000000000000000001020AFF04004E006F00740061000000050001000C0005FF0000FFFFCCFF06000E0005FF0000B2B2B2FF010007000E0005FF0000B2B2B2FF010008000E0005FF0000B2B2B2FF010009000E0005FF0000B2B2B2FF010093020400328005FF92082C00920800000000000000000000010505FF0B0050006F007200630065006E0074006100670065006D000000000093020A0033000500005361ED646192087500920800000000000000000000010215FF050053006100ED00640061000000070001000C0005FF0000F2F2F2FF05000C0005FF00003F3F3FFF250005000206000E0005FF00003F3F3FFF010007000E0005FF00003F3F3FFF010008000E0005FF00003F3F3FFF010009000E0005FF00003F3F3FFF010093020400348003FF92084000920800000000000000000000010503FF150053006500700061007200610064006F00720020006400650020006D0069006C00680061007200650073000000000093020400358006FF92084800920800000000000000000000010506FF190053006500700061007200610064006F00720020006400650020006D0069006C006800610072006500730020005B0030005D00000000009302130036000E0000546578746F20646520417669736F9208430092080000000000000000000001020BFF0E0054006500780074006F00200064006500200041007600690073006F000000020005000C0005FF0000FF0000FF2500050002930216003700110000546578746F204578706C6963617469766F92084900920800000000000000000000010235FF110054006500780074006F0020004500780070006C006900630061007400690076006F000000020005000C0005FF00007F7F7FFF250005000293020B00380006000054ED74756C6F9208330092080000000000000000000001030FFF06005400ED00740075006C006F000000020005000C00070300001F497DFF250005000193020D00390008000054ED74756C6F203192084500920800000000000000000000010310FF08005400ED00740075006C006F00200031000000030005000C00070300001F497DFF250005000207000E00070400004F81BDFF050093020D003A0008000054ED74756C6F203292084500920800000000000000000000010311FF08005400ED00740075006C006F00200032000000030005000C00070300001F497DFF250005000207000E000704FF3FA8C0DEFF050093020D003B0008000054ED74756C6F203392084500920800000000000000000000010312FF08005400ED00740075006C006F00200033000000030005000C00070300001F497DFF250005000207000E000704323395B3D7FF020093020D003C0008000054ED74756C6F203492083700920800000000000000000000010313FF08005400ED00740075006C006F00200034000000020005000C00070300001F497DFF250005000293020A003D00050000546F74616C92084D00920800000000000000000000010319FF050054006F00740061006C000000040005000C0007010000000000FF250005000206000E00070400004F81BDFF010007000E00070400004F81BDFF06008E0858008E080000000000000000000090000000110011005400610062006C0065005300740079006C0065004D0065006400690075006D0039005000690076006F0074005300740079006C0065004C0069006700680074003100360060010200000085000E00292C00000000060053686565743185000E00E92D00000000060053686565743285000E00792F0000000006005368656574339A0818009A0800000000000000000000010000000000000004000000A3081000A30800000000000000000000000000008C00040037003700C1010800C10100001DEB0100FC001E000100000001000000130000437573746F6D657273204C6973742068657265FF000A000800AB2B00000C00000063081600630800000000000000000000160000000000000002009608100096080000000000000000000042E501009B0810009B0800000000000000000000010000008C0810008C0800000000000000000000000000000A0000000908100000061000AB1FCD07C9000100060400000B0214000000000000000000010000003F2D0000792D00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF00010001000100040042E50100000000000000E03F000000000000E03F74009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030100000000000100010001000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B021000000000000000000000000000FB2E00000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A0000000908100000061000AB1FCD07C9000100060400000B0210000000000000000000000000008B3000000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000260008005B34AEC96432E93F270008005B34AEC96432E93F280008008A1D3CFCFD7EEF3F290008008A1D3CFCFD7EEF3FA10022000000FF000100010001000400020001FF000000000000E03F000000000000E03F00009C0826009C0800000000000000000000000000000000000000000000000000000400000000000000000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000EF00060000003700000067081700670800000000000000000000020001FFFFFFFF034400000A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000200000003000000FEFFFFFF05000000060000000700000008000000FEFFFFFF0A000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFF0000060102000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000B00000000700000001000000400000000400000048000000080000006800000012000000780000000C000000900000000D0000009C00000013000000A800000002000000E40400001E00000018000000426F73746F6E2053797374656D732047726F7570000000001E000000080000005669746F720000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC1014000000000FF96073048CF0103000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF000006010200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000008000000496E7475697400000300000000000C000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000A000000506C616E696C68617300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100FEFF030A0000FFFFFFFF2008020000000000C00000000000004628000000506C616E696C686120646F204D6963726F736F6674204F666669636520457863656C203230303300060000004269666638000E000000457863656C2E53686565742E3800F439B2710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010043006F006D0070004F0062006A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000200FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000900000074000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Customers_List.xls', null, '2014-03-25 10:42:24', 'admin');
INSERT INTO "tb_documents_active" VALUES (28, 5, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF090006000000000000000000000001000000190000000000000000100000FEFFFFFF00000000FEFFFFFF0000000018000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0908100000060500AF18CD074140000006010000E1000200B004C10002000000E20000005C0070000500005669746F726E2053797374656D732047726F7570202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D0106000100020003009C0002000E00190002000000120002000000130002000000AF0102000000BC01020000003D00120078005A001F3B5424380000000000010058024000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C001E041C000500170000222422232C2323305F293B5C28222422232C2323305C291E04210006001C0000222422232C2323305F293B5B5265645D5C28222422232C2323305C291E04220007001D0000222422232C2323302E30305F293B5C28222422232C2323302E30305C291E0427000800220000222422232C2323302E30305F293B5B5265645D5C28222422232C2323302E30305C291E0437002A003200005F282224222A20232C2323305F293B5F282224222A205C28232C2323305C293B5F282224222A20222D225F293B5F28405F291E042E0029002900005F282A20232C2323305F293B5F282A205C28232C2323305C293B5F282A20222D225F293B5F28405F291E043F002C003A00005F282224222A20232C2323302E30305F293B5F282224222A205C28232C2323302E30305C293B5F282224222A20222D223F3F5F293B5F28405F291E0436002B003100005F282A20232C2323302E30305F293B5F282A205C28232C2323302E30305C293B5F282A20222D223F3F5F293B5F28405F29E000140000000000F5FF200000000000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140001000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140002000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E000140000000000F5FF200000F40000000000000000C020E0001400000000000100200000000000000000000000C020E000140001002B00F5FF200000F80000000000000000C020E000140001002900F5FF200000F80000000000000000C020E000140001002C00F5FF200000F80000000000000000C020E000140001002A00F5FF200000F80000000000000000C020E000140001000900F5FF200000F80000000000000000C02093020400108003FF93020400118006FF93020400128004FF93020400138007FF93020400008000FF93020400148005FF60010200000085000E00BC0500000000060053686565743185000E00F30600000000060053686565743285000E00FA070000000006005368656574338C00040001000100C1010800C101000060690100FC00260001000000010000001B0000436F737420416E616C7973697320776F756C6420676F2068657265FF000A0008008C0500000C0000000A0000000908100000061000AF18CD0741400000060100000B02140000000000000000000100000078060000B20600000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E00000000000100000000000100000008021000000000000100FF000000000000010F00FD000A00000000000F0000000000D70006002200000000003E021200B606000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000AB0700000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A0000000908100000061000AF18CD0741400000060100000B021000000000000000000000000000B20800000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C1041400000015000000830002000000840002000000A10022000000FF00010001000100040000000000000000000000E03F000000000000E03F000055000200080000020E0000000000000000000000000000003E021200B600000000004000000000000000000000001D000F00030000000000000100000000000000EF0006000000370000000A000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C00000000700000001000000400000000400000048000000080000006800000012000000880000000C000000A00000000D000000AC00000013000000B800000002000000E40400001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E00000015000000426F73746F6E2053797374656D732047726F7570000000001E000000100000004D6963726F736F667420457863656C0040000000007F24B93EBAC10140000000000040E53EBAC101030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000DC0000000900000001000000500000000F0000005800000017000000680000000B000000700000001000000078000000130000008000000016000000880000000D000000900000000C000000B900000002000000E40400001E00000007000000496E74756974006803000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000030000000700000053686565743100070000005368656574320007000000536865657433000C100000020000001E0000000B000000576F726B73686565747300030000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C000000000000046000000000000000000000000F02EDAEF2F48CF01FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000080000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000', 'Customer.xls', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO "tb_documents_active" VALUES (29, 5, X'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', 'Customer_costs_presentation.ppt', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO "tb_documents_active" VALUES (30, 5, X'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', 'costs_chart.png', null, '2014-03-25 10:47:30', 'admin');
INSERT INTO "tb_documents_active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ebsite Implementation Cost Analysis.xls', null, '2014-03-25 10:51:07', 'admin');
INSERT INTO "tb_documents_active" VALUES (32, 7, X'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', 'comparative_chart.png', null, '2014-03-25 10:51:07', 'admin');
INSERT INTO "tb_documents_active" VALUES (33, 8, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Security.doc', null, '2014-03-25 10:53:10', 'admin');
INSERT INTO "tb_documents_active" VALUES (34, 8, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Status Report.doc', null, '2014-03-25 10:53:10', 'admin');
INSERT INTO "tb_documents_active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oncept3.htm', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO "tb_documents_active" VALUES (36, 2, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Timeline.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO "tb_documents_active" VALUES (37, 2, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'user_cases.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO "tb_documents_active" VALUES (38, 2, X'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', 'WebsiteFinal.ppt', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO "tb_documents_active" VALUES (39, 2, X'D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000002100000000000000001000002300000001000000FEFFFFFF0000000020000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFECA5C100372009040000F012BF0000000000001000000000000400001E0400000E00626A626A5516551600000000000000000000000000000000000009041600220C0000377C0000377C00001E00000000000000000000000000000000000000000000000000000000000000FFFF0F000000000000000000FFFF0F000000000000000000FFFF0F00000000000000000000000000000000006C0000000000A800000000000000A8000000A800000000000000A800000000000000A800000000000000A800000000000000A8000000140000000000000000000000BC00000000000000D600000000000000D600000000000000D600000000000000D60000000C000000E20000000C000000BC0000000000000013030000B6000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000FA000000000000009202000002000000940200000000000094020000000000009402000000000000940200000000000094020000000000009402000024000000C903000020020000E9050000B4000000B80200001500000000000000000000000000000000000000A800000000000000FA0000000000000000000000000000000000000000000000FA00000000000000FA00000000000000FA00000000000000FA00000000000000B8020000000000002A01000000000000A800000000000000A800000000000000FA000000000000000000000000000000FA00000000000000CD020000160000002A010000000000002A010000000000002A01000000000000FA00000016000000A800000000000000FA00000000000000A800000000000000FA00000000000000920200000000000000000000000000002A01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FA0000000000000092020000000000002A010000680100002A0100000000000000000000000000009202000000000000A800000000000000A80000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009202000000000000FA00000000000000EE0000000C00000040B657414DBAC101BC0000001A000000D600000000000000100100000A000000920200000000000000000000000000009202000000000000E302000030000000130300000000000092020000000000009D060000000000001A010000100000009D0600000000000092020000000000002A01000000000000BC00000000000000BC00000000000000A800000000000000A800000000000000A800000000000000A8000000000000000200D9000000436F6E74656E74206F75746C696E6520776F756C6420676F20686572650D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400001E040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000400001E040000FD0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000400001E040000FE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020101012000319068011FB0D02F20B0E03D21B0080722B008072390A0052490A00525B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000F000A00010069000F000300000000000000000038000040F1FF020038000C0006004E006F0072006D0061006C000000020000001800434A18005F480104614A18006D48090473480904744809040000000000000000000000000000000000003C004140F2FFA1003C000C001600440065006600610075006C0074002000500061007200610067007200610070006800200046006F006E007400000000000000000000000000000000001E0000000500000C00000400FFFFFFFF00000000200000009A0000000030000000000000008000000080000400001E04000003000000000400001E04000004000000000400001E0400000500000000000000190000001D0000002000000007000400070000000000200000000400000000001D0000002000000004000700FFFF04000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070004D0043003A005C00570049004E0044004F00570053005C004100700070006C00690063006100740069006F006E00200044006100740061005C004D006900630072006F0073006F00660074005C0057006F00720064005C004100750074006F005200650063006F0076006500720079002000730061007600650020006F006600200044006F00630075006D0065006E00740031002E00610073006400140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000380043003A005C00570049004E0044004F00570053005C004400650073006B0074006F0070005C0048006F00700065005700490050005C0051007500690063006B0062006100730065005C0043006F006E00740065006E00740020006F00750074006C0069006E0065002E0064006F006300FF40018001001D0000001D0000005C8E6400010001001D0000000000000000000000000000000210000000000000001E0000005000000800400000FFFF01000000070055006E006B006E006F0077006E00FFFF0100080000000000000000000000FFFF010000000000FFFF00000200FFFF00000000FFFF00000200FFFF000000000300000047169001000002020603050405020304873A0000000000000000000000000000FF00000000000000540069006D006500730020004E0065007700200052006F006D0061006E00000035169001020005050102010706020507000000000000001000000000000000000000008000000000530079006D0062006F006C000000332690010000020B0604020202020204873A0000000000000000000000000000FF0000000000000041007200690061006C00000022000400F108881800F0D002000068010000000068A36266DDA36266000000000100690000000400000018000000010001000000040003100100000000000000000000000100010000000100000000000000590200F010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000807A005B400B4008181723000001000190064000000190000001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000032831100F010000800000000000000000000000000000000000000000000000000000000000000FFFF12000000000000001D0043006F006E00740065006E00740020006F00750074006C0069006E006500200077006F0075006C006400200067006F0020006800650072006500000000000000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F0075007000140042006F00730074006F006E002000530079007300740065006D0073002000470072006F00750070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A02000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000A4010000110000000100000090000000020000009800000003000000C000000004000000CC00000005000000EC00000006000000F800000007000000040100000800000018010000090000003801000012000000440100000A000000600100000C0000006C0100000D000000780100000E000000840100000F0000008C0100001000000094010000130000009C01000002000000E40400001E0000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265004D691E00000001000000006F6E741E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000001000000006F73741E00000001000000006F73741E0000000B0000004E6F726D616C2E646F7400651E00000015000000426F73746F6E2053797374656D732047726F75700020676F1E00000002000000310073741E000000130000004D6963726F736F667420576F726420392E3000704000000000B617AB0E0000004000000000405E003EBAC10140000000000E833A4DBAC101030000000100000003000000040000000300000018000000030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000040A0200000000000000000000000000000000000100000002D5CDD59C2E1B10939708002B2CF9AE30000000080100000C00000001000000680000000F0000007000000005000000800000000600000088000000110000009000000017000000980000000B000000A000000010000000A800000013000000B000000016000000B80000000D000000C00000000C000000EA00000002000000E40400001E00000007000000496E74756974000003000000010000000300000001000000030000001D00000003000000A00A09000B000000000000000B000000000000000B000000000000000B000000000000001E100000010000001E000000436F6E74656E74206F75746C696E6520776F756C6420676F2068657265000C100000020000001E000000060000005469746C650003000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000020000000300000004000000050000000600000007000000FEFFFFFF090000000A0000000B0000000C0000000D0000000E0000000F000000FEFFFFFF11000000120000001300000014000000150000001600000017000000FEFFFFFF190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFFFDFFFFFF22000000FEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF030000000609020000000000C00000000000004600000000000000000000000040B657414DBAC10124000000800000000000000031005400610062006C006500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000008000000001000000000000057006F007200640044006F00630075006D0065006E007400000000000000000000000000000000000000000000000000000000000000000000000000000000001A00020105000000FFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010200000004000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000180000000010000000000000010043006F006D0070004F0062006A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000006000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000006A000000000000004F0062006A0065006300740050006F006F006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000100FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000040B657414DBAC10140B657414DBAC1010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0100FEFF030A0000FFFFFFFF0609020000000000C000000000000046180000004D6963726F736F667420576F726420446F63756D656E74000A0000004D53576F7264446F630010000000576F72642E446F63756D656E742E3800F439B27100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 'Requirements_analysis.doc', null, '2014-03-25 10:58:27', 'admin');
INSERT INTO "tb_documents_active" VALUES (40, 9, X'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', 'WebsiteFinal.ppt', null, '2014-03-25 11:00:14', 'admin');
INSERT INTO "tb_documents_active" VALUES (41, 1, '*nm*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