SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `appointments`
-- ----------------------------
CREATE TABLE `appointments` (
  `appointments_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `price` decimal(6,2) DEFAULT NULL,
  `additional_charges` decimal(6,2) DEFAULT NULL,
  `discount` decimal(6,2) DEFAULT NULL,
  `total_price` decimal(6,2) DEFAULT NULL,
  `appointment_start_date` date DEFAULT NULL,
  `appointment_start_time` time DEFAULT NULL,
  `appointment_end_date` date DEFAULT NULL,
  `appointment_end_time` time DEFAULT NULL,
  `current_status_id` int(11) DEFAULT NULL,
  `appointment_recurrent` varchar(1) DEFAULT NULL,
  `appointment_period` varchar(1) DEFAULT NULL,
  `appointment_rating` int(11) DEFAULT NULL,
  PRIMARY KEY (`appointments_id`),
  KEY `fk_appointments_staff1_idx` (`staff_id`),
  KEY `fk_appointments_customers1_idx` (`customers_id`),
  KEY `fk_appointments_appointment_status1_idx` (`current_status_id`),
  CONSTRAINT `fk_appointments_appointment_status1` FOREIGN KEY (`current_status_id`) REFERENCES `appointment_status` (`appointment_status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_appointments_customers1` FOREIGN KEY (`customers_id`) REFERENCES `customers` (`customers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_appointments_staff1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`staff_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointments
-- ----------------------------
INSERT INTO `appointments` VALUES ('1', '2', '3', '250.00', '0.00', '20.00', '230.00', '2015-09-29', '11:00:00', '2015-09-29', '14:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('2', '2', '2', '100.00', '0.00', '0.00', '100.00', '2015-09-23', '11:00:00', '2015-09-23', '13:00:00', '5', '', '', '4');
INSERT INTO `appointments` VALUES ('3', '2', '1', '100.00', '0.00', '0.00', '100.00', '2015-09-24', '10:00:00', '2015-09-24', '12:00:00', '3', '', '', null);
INSERT INTO `appointments` VALUES ('4', '1', '1', '250.00', '0.00', '0.00', '250.00', '2015-09-29', '08:00:00', '2015-09-29', '10:30:00', '5', '', '', '4');
INSERT INTO `appointments` VALUES ('5', '3', '2', '50.00', '0.00', '0.00', '200.00', '2015-09-23', '13:00:00', '2015-09-23', '14:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('11', '3', '1', '150.00', '0.00', '0.00', '150.00', '2015-09-30', '08:00:00', '2015-09-30', '10:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('13', '2', '3', '200.00', '0.00', '0.00', '150.00', '2015-09-25', '08:00:00', '2015-09-25', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('14', '1', '2', '100.00', '10.00', '0.00', '110.00', '2015-09-25', '10:00:00', '2015-09-25', '12:00:00', '4', '', '', null);
INSERT INTO `appointments` VALUES ('15', '3', '1', '150.00', '0.00', '0.00', '150.00', '2015-09-28', '08:00:00', '2015-09-28', '11:00:00', '5', '', '', '5');
INSERT INTO `appointments` VALUES ('16', '1', '1', '150.00', '10.00', '0.00', '160.00', '2015-09-28', '09:00:00', '2015-09-28', '11:00:00', '5', '', '', '5');
INSERT INTO `appointments` VALUES ('17', '2', '1', '100.00', '0.00', '0.00', '100.00', '2015-10-01', '10:00:00', '2015-10-01', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('18', '1', '3', '50.00', '20.00', '0.00', '70.00', '2015-10-01', '14:00:00', '2015-10-01', '15:00:00', '5', '', '', null);
INSERT INTO `appointments` VALUES ('19', '2', '2', '100.00', '0.00', '0.00', '100.00', '2015-10-02', '08:00:00', '2015-10-02', '09:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('20', '2', '1', '200.00', '0.00', '0.00', '200.00', '2015-10-05', '09:00:00', '2015-10-05', '11:00:00', '5', '', '', null);
INSERT INTO `appointments` VALUES ('21', '1', '1', '150.00', '0.00', '0.00', '150.00', '2015-10-02', '14:00:00', '2015-10-02', '15:30:00', '3', '', '', null);
INSERT INTO `appointments` VALUES ('22', '3', '1', '150.00', '0.00', '0.00', '150.00', '2015-10-02', '14:20:00', '2015-10-02', '16:50:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('24', '2', '1', '0.00', '0.00', '0.00', '250.00', '2015-10-08', '14:30:00', '2015-10-08', '14:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('25', '3', '2', '0.00', '0.00', '0.00', '250.00', '2015-10-05', '14:45:00', '2015-10-05', '14:45:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('26', '3', '2', '0.00', '0.00', '0.00', '100.00', '2015-10-07', '14:00:00', '2015-10-07', '14:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('27', '1', '3', '150.00', '0.00', '0.00', '150.00', '2015-12-03', '10:00:00', '2015-12-03', '11:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('28', '1', '3', '90.00', '0.00', '0.00', '150.00', '2015-10-05', '10:35:00', '2015-10-05', '13:05:00', '5', '', '', null);
INSERT INTO `appointments` VALUES ('29', '0', '2', '60.00', '0.00', '0.00', '100.00', '2015-10-14', '04:00:00', '2015-10-14', '05:40:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('30', '4', '5', '90.00', '0.00', '0.00', '150.00', '2015-10-12', '11:00:00', '2015-10-12', '13:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('31', '2', '5', '180.00', '0.00', '0.00', '300.00', '2015-10-23', '11:05:00', '2015-10-23', '16:05:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('32', '2', '1', '50.00', '0.00', '0.00', '50.00', '2015-11-16', '09:00:00', '2015-11-16', '09:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('33', '4', '1', '50.00', '0.00', '0.00', '50.00', '2015-11-17', '11:00:00', '2015-11-17', '11:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('34', '3', '1', '50.00', '0.00', '0.00', '50.00', '2015-11-16', '12:00:00', '2015-11-16', '12:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('35', '0', '1', '50.00', '0.00', '0.00', '50.00', '2015-11-23', '10:00:00', '2015-11-23', '12:00:00', '3', '', '', null);
INSERT INTO `appointments` VALUES ('36', '0', '1', '50.00', '0.00', '0.00', '50.00', '2015-11-24', '10:00:00', '2015-11-24', '11:00:00', '3', '', '', null);
INSERT INTO `appointments` VALUES ('37', '2', '1', '150.00', '0.00', '0.00', '150.00', '2015-11-13', '10:00:00', '2015-11-13', '11:30:00', '5', '', '', null);
INSERT INTO `appointments` VALUES ('38', '0', '1', '60.00', '0.00', '0.00', '100.00', '2015-11-13', '15:30:00', '2015-11-13', '17:10:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('39', '3', '1', '200.00', '0.00', '0.00', '200.00', '2015-11-23', '11:00:00', '2015-11-23', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('40', '1', '1', '200.00', '0.00', '0.00', '200.00', '2015-11-23', '12:00:00', '2015-11-23', '14:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('41', '3', '1', '120.00', '0.00', '0.00', '200.00', '2015-11-13', '10:00:00', '2015-11-13', '13:20:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('42', '1', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-23', '14:00:00', '2015-11-23', '15:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('43', '1', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-13', '11:00:00', '2015-11-13', '12:00:00', '5', '', '', null);
INSERT INTO `appointments` VALUES ('44', '0', '3', '100.00', '0.00', '0.00', '100.00', '2015-11-23', '16:00:00', '2015-11-23', '17:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('45', '1', '3', '200.00', '0.00', '0.00', '200.00', '2015-11-13', '12:00:00', '2015-11-13', '14:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('46', '3', '2', '200.00', '0.00', '0.00', '200.00', '2015-11-13', '15:00:00', '2015-11-13', '17:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('47', '1', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-14', '11:00:00', '2015-11-14', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('48', '0', '3', '100.00', '0.00', '0.00', '100.00', '2015-11-14', '15:00:00', '2015-11-14', '16:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('49', '2', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-23', '17:00:00', '2015-11-23', '18:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('50', '0', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-24', '14:00:00', '2015-11-24', '15:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('51', '1', '1', '100.00', '0.00', '0.00', '100.00', '2015-11-24', '08:00:00', '2015-11-24', '09:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('52', '2', '1', '400.00', '0.00', '0.00', '400.00', '2015-11-21', '09:00:00', '2015-11-21', '11:00:00', '2', '', '', '0');
INSERT INTO `appointments` VALUES ('53', '3', '1', '200.00', '0.00', '0.00', '200.00', '2015-12-04', '11:00:00', '2015-12-04', '13:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('54', '3', '3', '100.00', '0.00', '0.00', '100.00', '2015-12-07', '10:00:00', '2015-12-07', '11:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('55', '2', '3', '400.00', '0.00', '0.00', '400.00', '2015-12-02', '08:00:00', '2015-12-02', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('56', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-01-04', '08:00:00', '2016-01-04', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('57', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-01-19', '08:00:00', '2016-01-19', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('58', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-02-09', '08:00:00', '2016-02-09', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('59', '2', '1', '150.00', '0.00', '0.00', '150.00', '2015-12-31', '08:00:00', '2015-12-31', '09:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('60', '1', '1', '100.00', '0.00', '0.00', '100.00', '2015-12-30', '08:00:00', '2015-12-30', '09:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('61', '0', '1', '250.00', '0.00', '0.00', '250.00', '2016-02-16', '08:00:00', '2016-02-16', '10:30:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('62', '0', '1', '50.00', '0.00', '0.00', '50.00', '2016-03-21', '08:00:00', '2016-03-21', '08:30:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('63', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-04-04', '08:00:00', '2016-04-04', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('64', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-05-02', '08:00:00', '2016-05-02', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('65', '0', '1', '150.00', '0.00', '0.00', '150.00', '2016-06-06', '08:00:00', '2016-06-06', '09:30:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('66', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-07-06', '08:00:00', '2016-07-06', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('67', '0', '1', '100.00', '0.00', '0.00', '100.00', '2016-08-01', '08:00:00', '2016-08-01', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('68', '0', '2', '50.00', '0.00', '0.00', '50.00', '2016-01-07', '08:00:00', '2016-01-07', '08:30:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('69', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-01-22', '08:00:00', '2016-01-22', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('70', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-02-10', '08:00:00', '2016-02-10', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('71', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-03-21', '08:00:00', '2016-03-21', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('72', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-04-14', '08:00:00', '2016-04-14', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('73', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-05-18', '08:00:00', '2016-05-18', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('74', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-06-10', '08:00:00', '2016-06-10', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('75', '0', '2', '300.00', '0.00', '0.00', '300.00', '2016-07-08', '08:00:00', '2016-07-08', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('76', '1', '2', '300.00', '0.00', '0.00', '300.00', '2016-08-26', '08:00:00', '2016-08-26', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('77', '2', '2', '300.00', '0.00', '0.00', '300.00', '2015-12-30', '08:00:00', '2015-12-30', '12:00:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('78', '3', '3', '50.00', '0.00', '0.00', '50.00', '2015-12-30', '10:30:00', '2015-12-30', '11:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('79', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-01-13', '08:00:00', '2016-01-13', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('80', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-02-17', '08:00:00', '2016-02-17', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('81', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-02-10', '08:00:00', '2016-02-10', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('82', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-03-09', '08:00:00', '2016-03-09', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('83', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-04-05', '08:00:00', '2016-04-05', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('84', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-05-24', '08:00:00', '2016-05-24', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('85', '0', '3', '300.00', '0.00', '0.00', '300.00', '2016-06-21', '08:00:00', '2016-06-21', '12:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('86', '0', '3', '350.00', '0.00', '0.00', '350.00', '2016-07-07', '08:00:00', '2016-07-07', '13:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('87', '0', '3', '600.00', '0.00', '0.00', '600.00', '2016-07-20', '08:00:00', '2016-07-20', '15:30:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('88', '0', '3', '550.00', '0.00', '0.00', '550.00', '2016-08-23', '08:00:00', '2016-08-23', '15:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('89', '1', '5', '50.00', '0.00', '0.00', '50.00', '2016-05-12', '10:00:00', '2016-05-12', '01:00:00', '2', '', '', '0');
INSERT INTO `appointments` VALUES ('90', '0', '1', '50.00', '0.00', '0.00', '50.00', '2016-01-07', '08:00:00', '2016-01-07', '09:00:00', '1', '', '', null);
INSERT INTO `appointments` VALUES ('91', '1', '5', '0.00', '0.00', '0.00', '0.00', '2016-02-03', '00:00:00', '2016-02-03', '00:00:00', '1', '', '', '0');
INSERT INTO `appointments` VALUES ('92', '2', '2', '350.00', '0.00', '0.00', '350.00', '2016-04-19', '08:00:00', '2016-04-19', '12:30:00', '2', '', '', null);
INSERT INTO `appointments` VALUES ('93', '1', '3', '150.00', '0.00', '0.00', '150.00', '2016-03-16', '10:00:00', '2016-03-16', '12:00:00', '2', '', '', '0');
INSERT INTO `appointments` VALUES ('94', '1', '3', '100.00', '0.00', '0.00', '100.00', '2016-02-26', '14:00:00', '2016-02-26', '15:00:00', '2', '', '', '0');

-- ----------------------------
-- Table structure for `appointments_history`
-- ----------------------------
CREATE TABLE `appointments_history` (
  `appointments_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `appointments_history_date` datetime DEFAULT NULL,
  `appointments_history_descr` text,
  `appointments_id` int(11) NOT NULL,
  `appointment_status_id` int(11) DEFAULT NULL,
  `sec_users_login` varchar(32) NOT NULL,
  PRIMARY KEY (`appointments_history_id`),
  KEY `fk_appointments_history_appointments1_idx` (`appointments_id`),
  KEY `fk_appointments_history_appointment_status1_idx` (`appointment_status_id`),
  KEY `fk_appointments_history_sec_users1_idx` (`sec_users_login`),
  CONSTRAINT `fk_appointments_history_appointments1` FOREIGN KEY (`appointments_id`) REFERENCES `appointments` (`appointments_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_appointments_history_appointment_status1` FOREIGN KEY (`appointment_status_id`) REFERENCES `appointment_status` (`appointment_status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_appointments_history_sec_users1` FOREIGN KEY (`sec_users_login`) REFERENCES `sec_users` (`login`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointments_history
-- ----------------------------
INSERT INTO `appointments_history` VALUES ('3', '2015-09-25 10:06:23', 'New appointment: 2015-09-28 09:00:00', '16', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('4', '2015-09-25 11:47:55', 'New appointment: 2015-09-22 08:00:00', '4', '3', 'admin');
INSERT INTO `appointments_history` VALUES ('5', '2015-09-25 11:51:39', 'New appointment: 2015-09-22 10:00:00', '1', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('6', '2015-09-28 09:09:38', 'New appointment: 2015-09-23 08:00:00', '11', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('7', '2015-10-01 09:57:50', 'New appointment: 2015-09-28 09:00:00', '20', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('15', '2015-09-25 10:41:55', 'Appointment Updated! <br/>Status changed: 2 -> 4.', '16', '4', 'abraham');
INSERT INTO `appointments_history` VALUES ('16', '2015-09-25 10:42:28', 'Appointment Updated! <br/>Status changed: 4 -> 5. Price changed: 160.00 -> 180.00.', '16', '5', 'abraham');
INSERT INTO `appointments_history` VALUES ('19', '2015-10-02 11:43:50', 'Appointment Updated! <br/>Status: Scheduled <br/>Date: 2015-09-24 - 14:00:00 <br/>Price: 50.00<br/>User: Luke<br/>Staff: Isaac', '18', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('20', '2015-10-02 11:44:24', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-09-24 - 14:00:00<br/>Price: 50.00<br/>User: Luke<br/>Staff: Abraham', '18', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('21', '2015-10-02 11:56:59', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-09-25 - 14:00:00<br/>Price: <br/>User: Matheus<br/>Staff: Abraham', '21', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('22', '2015-10-02 12:01:27', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-09-25 - 14:00:00<br/>Price: 200.00<br/>User: Matheus<br/>Staff: Abraham', '21', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('23', '2015-10-02 12:01:37', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-09-25 - 14:00:00<br/>Price: 150.00<br/>User: Matheus<br/>Staff: Abraham', '21', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('24', '2015-09-28 09:54:56', 'Appointment Updated! <br/>Price changed: 180.00 -> 160.00.', '16', '5', 'abraham');
INSERT INTO `appointments_history` VALUES ('25', '2015-09-28 11:30:26', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-09-29 - 10:00:00<br/>Price: 230.00<br/>User: Luke<br/>Staff: Abraham', '1', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('26', '2015-09-29 16:19:01', 'Appointment Updated! <br/>Status changed: Awaiting Confirmation -> Canceled', '21', '3', 'abraham');
INSERT INTO `appointments_history` VALUES ('27', '2015-09-29 16:21:11', 'Appointment Updated! <br/>Status changed: Canceled -> Checked In', '4', '4', 'abraham');
INSERT INTO `appointments_history` VALUES ('28', '2015-09-30 09:40:48', 'Appointment Updated! <br/>Status changed: Awaiting Confirmation -> Checked In', '14', '4', 'abraham');
INSERT INTO `appointments_history` VALUES ('29', '2015-09-30 09:41:49', 'Appointment Updated! <br/>Status changed: Check in -> Concluded', '4', '5', 'abraham');
INSERT INTO `appointments_history` VALUES ('30', '2015-09-30 10:11:40', 'Appointment Updated! <br/>Status changed: Scheduled -> Reschedule', '1', '1', 'abraham');
INSERT INTO `appointments_history` VALUES ('31', '2015-10-01 14:28:07', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-02 - 14:20:00<br/>Price: 150.00<br/>User: Matheus<br/>Staff: None', '22', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('32', '2015-10-01 14:37:17', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-08 - 14:30:00<br/>Price: 250.00<br/>User: Matheus<br/>Staff: None', '24', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('33', '2015-10-01 14:47:21', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-05 - 14:45:00<br/>Price: 250.00<br/>User: Mark<br/>Staff: None', '25', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('34', '2015-10-01 14:53:46', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-07 - 14:00:00<br/>Price: 100.00<br/>User: Mark<br/>Staff: None', '26', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('36', '2015-10-01 16:14:44', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-02 - 15:15:00<br/>Price: 150.00<br/>User: Luke<br/>Staff: None', '27', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('37', '2015-10-01 16:37:49', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-05 - 10:35:00<br/>Price: 150.00<br/>User: Luke<br/>Staff: None', '28', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('38', '2015-10-02 08:47:27', 'Appointment Updated! <br />Price changed: 50.00 -> 70.00.', '18', '2', 'abraham');
INSERT INTO `appointments_history` VALUES ('39', '2015-10-02 08:47:42', 'Appointment Updated! <br/>Status changed: Scheduled -> Checked In', '18', '4', 'abraham');
INSERT INTO `appointments_history` VALUES ('40', '2015-10-02 09:43:49', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-09-30 - 08:00:00<br/>Price: 150.00<br/>User: Matheus<br/>Staff: Jacob', '11', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('41', '2015-10-02 09:44:12', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-09-29 - 10:00:00<br/>Price: 230.00<br/>User: Luke<br/>Staff: Isaac', '1', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('42', '2015-10-02 09:44:21', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-09-29 - 10:00:00<br/>Price: 230.00<br/>User: Luke<br/>Staff: Isaac', '1', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('43', '2015-10-02 09:47:12', 'Appointment Updated! <br/>Status: Concluded<br/>Date: 2015-09-29 - 08:00:00<br/>Price: 250.00<br/>User: Matheus<br/>Staff: Abraham', '4', '5', 'admin');
INSERT INTO `appointments_history` VALUES ('44', '2015-10-02 09:48:00', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-02 - 14:20:00<br/>Price: 150.00<br/>User: Matheus<br/>Staff: Jacob', '22', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('45', '2015-10-02 09:48:39', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-02 - 08:00:00<br/>Price: 100.00<br/>User: Mark<br/>Staff: Isaac', '19', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('46', '2015-10-02 09:48:50', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-02 - 08:00:00<br/>Price: 100.00<br/>User: Mark<br/>Staff: Isaac', '19', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('47', '2015-10-02 09:59:10', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-09-23 - 13:00:00<br/>Price: 200.00<br/>User: Mark<br/>Staff: Jacob', '5', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('49', '2015-10-05 09:19:03', 'Appointment Rated! <br />Rating: 5.', '16', '5', 'matheus');
INSERT INTO `appointments_history` VALUES ('50', '2015-10-05 09:19:17', 'Appointment Rated! <br />Rating: 4.', '4', '5', 'matheus');
INSERT INTO `appointments_history` VALUES ('51', '2015-10-05 09:25:51', 'Appointment Rated! <br />Rating: 4.', '2', '5', 'mark');
INSERT INTO `appointments_history` VALUES ('52', '2015-10-05 09:26:27', 'Appointment Rated! <br />Rating: 5.', '15', '5', 'matheus');
INSERT INTO `appointments_history` VALUES ('53', '2015-10-06 15:45:10', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-05 - 09:00:00<br/>Price: 200.00<br/>User: Matheus<br/>Staff: Isaac', '20', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('54', '2015-10-06 15:45:22', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-05 - 10:35:00<br/>Price: 150.00<br/>User: Luke<br/>Staff: Abraham', '28', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('55', '2015-10-06 15:45:33', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-05 - 14:45:00<br/>Price: 250.00<br/>User: Mark<br/>Staff: Jacob', '25', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('56', '2015-10-06 15:48:39', 'Appointment Updated! <br/>Status changed: Scheduled -> Checked In', '28', '4', 'abraham');
INSERT INTO `appointments_history` VALUES ('57', '2015-10-06 15:49:40', 'Appointment Updated! <br/>Status changed: Check in -> Concluded', '28', '5', 'abraham');
INSERT INTO `appointments_history` VALUES ('58', '2015-10-06 15:52:25', 'Appointment Updated! <br/>Status changed: Scheduled -> Checked In', '20', '4', 'isaac');
INSERT INTO `appointments_history` VALUES ('59', '2015-10-06 15:52:30', 'Appointment Updated! <br/>Status changed: Check in -> Concluded', '20', '5', 'isaac');
INSERT INTO `appointments_history` VALUES ('60', '2015-10-08 16:55:21', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-07 - 14:00:00<br/>Price: 100.00<br/>User: Mark<br/>Staff: Jacob', '26', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('61', '2015-10-08 17:02:08', 'Appointment Updated! <br/>Status changed: Check in -> Concluded', '18', '5', 'abraham');
INSERT INTO `appointments_history` VALUES ('62', '2015-10-08 17:05:15', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-10-14 - 04:00:00<br/>Price: 100.00<br/>User: Mark<br/>Staff: None', '29', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('64', '2015-10-09 11:12:34', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-12 - 11:00:00<br/>Price: 150.00<br/>User: Caio Vinícius<br/>Staff: Carlos Lacerda', '30', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('66', '2015-11-12 15:54:23', 'Agendamento Atualizado! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-16 - 09:00:00<br/>Valor Total: 50.00<br/>Cliente: Matheus<br/>Técnico: Isaac', '32', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('67', '2015-11-12 15:55:10', 'Agendamento Atualizado! <br/>Status: Scheduled<br/>Data: 2015-10-02 - 15:15:00<br/>Valor Total: 150.00<br/>Cliente: Luke<br/>Técnico: None', '27', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('68', '2015-11-12 15:56:28', 'Agendamento Atualizado! <br/>Status: Scheduled<br/>Data: 2015-10-02 - 15:15:00<br/>Valor Total: 150.00<br/>Cliente: Luke<br/>Técnico: Abraham', '27', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('70', '2015-11-12 16:02:39', 'Agendamento Atualizado! <br/>Status: Scheduled<br/>Data: null - null<br/>Valor Total: 100.00<br/>Cliente: Matheus<br/>Técnico: Jacob', '33', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('71', '2015-11-12 16:07:04', 'Agendamento Atualizado! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-16 - 12:00:00<br/>Valor Total: 50.00<br/>Cliente: Matheus<br/>Técnico: Jacob', '34', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('72', '2015-11-12 16:08:36', 'Appointment Updated! <br/>Status changed: Awaiting Confirmation -> Canceled', '36', '3', 'matheus');
INSERT INTO `appointments_history` VALUES ('73', '2015-11-12 16:37:33', 'Appointment Updated! <br/>Status changed: Awaiting Confirmation -> Canceled', '35', '3', 'matheus');
INSERT INTO `appointments_history` VALUES ('74', '2015-11-12 17:21:17', 'Novo Agendamento! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-13 - 15:30:00<br/>Valor Total: 100.00<br/>Cliente: Matheus<br/>Técnico: None', '38', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('75', '2015-11-12 17:43:39', 'Novo Agendamento! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-13 - 10:00:00<br/>Valor Total: 200.00<br/>Cliente: Matheus<br/>Técnico: None', '41', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('76', '2015-11-12 17:45:07', 'Novo Agendamento! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-13 - 00:00:00<br/>Valor Total: 100.00<br/>Cliente: Matheus<br/>Técnico: None', '42', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('77', '2015-11-12 17:47:51', 'Novo Agendamento! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-13 - 00:00:00<br/>Valor Total: 100.00<br/>Cliente: Matheus<br/>Técnico: None', '43', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('78', '2015-11-12 18:01:04', 'Novo Agendamento! <br/>Status: Awaiting Confirmation<br/>Data: 2015-11-13 - 10:00:00<br/>Valor Total: 200.00<br/>Cliente: Mark<br/>Técnico: None', '46', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('79', '2015-11-13 10:57:19', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-14 - 10:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '47', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('80', '2015-11-13 11:02:35', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-13 - 10:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: Isaac', '37', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('81', '2015-11-13 11:03:09', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 00:00:00<br/>Total Price: 200.00<br/>Customer: Matheus<br/>Staff: Jacob', '39', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('82', '2015-11-13 11:05:38', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-14 - 15:00:00<br/>Total Price: 100.00<br/>Customer: Luke<br/>Staff: None', '48', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('83', '2015-11-13 11:14:39', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-13 - 12:00:00<br/>Total Price: 200.00<br/>Customer: Luke<br/>Staff: Abraham', '45', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('84', '2015-11-13 11:15:39', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 11:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '43', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('85', '2015-11-13 12:18:36', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 10:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: Isaac', '37', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('86', '2015-11-13 12:19:12', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 12:00:00<br/>Total Price: 200.00<br/>Customer: Luke<br/>Staff: Abraham', '45', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('87', '2015-11-16 12:47:41', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-17 - null<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '49', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('88', '2015-11-16 17:49:44', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-17 - 11:00:00<br/>Total Price: 50.00<br/>Customer: Matheus<br/>Staff: Jacob', '33', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('89', '2015-11-16 17:50:26', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-17 - 11:00:00<br/>Total Price: 50.00<br/>Customer: Matheus<br/>Staff: Carlos Lacerda', '33', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('90', '2015-11-19 12:29:46', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-16 - 09:00:00<br/>Total Price: 50.00<br/>Customer: Matheus<br/>Staff: Isaac', '32', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('91', '2015-11-19 12:30:29', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-16 - 12:00:00<br/>Total Price: 50.00<br/>Customer: Matheus<br/>Staff: Jacob', '34', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('92', '2015-11-24 12:44:07', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-08 - 14:30:00<br/>Total Price: 250.00<br/>Customer: Matheus<br/>Staff: None', '24', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('93', '2015-11-24 12:45:11', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-08 - 14:30:00<br/>Total Price: 250.00<br/>Customer: Matheus<br/>Staff: Isaac', '24', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('94', '2015-11-24 12:47:10', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-24 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '51', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('95', '2015-11-26 10:03:35', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-14 - 11:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '47', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('96', '2015-11-26 10:04:16', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-21 - 09:00:00<br/>Total Price: 400.00<br/>Customer: Matheus<br/>Staff: Isaac', '52', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('97', '2015-11-26 10:08:00', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-23 - 12:00:00<br/>Total Price: 200.00<br/>Customer: Matheus<br/>Staff: Abraham', '40', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('98', '2015-11-26 10:08:38', 'Appointment Updated! <br/>Status: Awaiting Confirmation<br/>Date: 2015-11-23 - 14:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '42', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('99', '2015-11-26 12:36:12', 'New Appointment! <br/>Status: Scheduled<br/>Date: 2015-12-25 - 09:00:00<br/>Total Price: 150.00<br/>Customer: Luke<br/>Staff: Abraham', '27', '2', 'matheus');
INSERT INTO `appointments_history` VALUES ('100', '2015-12-01 10:03:55', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-03 - 10:00:00<br/>Total Price: 150.00<br/>Customer: Luke<br/>Staff: Abraham', '27', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('101', '2015-12-01 10:05:03', 'Appointment Updated! <br/>Status: Check in<br/>Date: 2015-11-13 - 11:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '43', '4', 'admin');
INSERT INTO `appointments_history` VALUES ('102', '2015-12-01 10:05:23', 'Appointment Updated! <br/>Status: Concluded<br/>Date: 2015-11-13 - 11:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '43', '5', 'admin');
INSERT INTO `appointments_history` VALUES ('103', '2015-12-01 10:05:53', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 10:00:00<br/>Total Price: 200.00<br/>Customer: Matheus<br/>Staff: Jacob', '41', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('104', '2015-12-01 10:06:48', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-13 - 15:00:00<br/>Total Price: 200.00<br/>Customer: Mark<br/>Staff: Jacob', '46', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('105', '2015-12-01 10:07:08', 'Appointment Updated! <br/>Status: Concluded<br/>Date: 2015-11-13 - 10:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: Isaac', '37', '5', 'admin');
INSERT INTO `appointments_history` VALUES ('106', '2015-12-01 10:07:59', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-23 - 14:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '42', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('108', '2015-12-01 10:33:42', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-04 - 11:00:00<br/>Total Price: 200.00<br/>Customer: Matheus<br/>Staff: Jacob', '53', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('109', '2015-12-01 12:31:29', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-02 - 10:00:00<br/>Total Price: 100.00<br/>Customer: Luke<br/>Staff: None', '54', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('110', '2015-12-01 12:32:10', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-02 - 08:00:00<br/>Total Price: 400.00<br/>Customer: Luke<br/>Staff: None', '55', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('111', '2015-12-01 12:33:07', 'Agendamento Atualizado! <br/>Status: Scheduled<br/>Data: 2015-12-02 - 08:00:00<br/>Valor Total: 400.00<br/>Cliente: Luke<br/>Técnico: Isaac', '55', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('112', '2015-12-01 12:33:59', 'Agendamento Atualizado! <br/>Status: Scheduled<br/>Data: 2015-12-07 - 10:00:00<br/>Valor Total: 100.00<br/>Cliente: Luke<br/>Técnico: Jacob', '54', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('113', '2015-12-29 12:09:07', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-01-04 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '56', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('114', '2015-12-29 12:09:51', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-01-19 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '57', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('115', '2015-12-29 12:10:23', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-09 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '58', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('116', '2015-12-29 12:11:01', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-31 - 08:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: None', '59', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('117', '2015-12-29 12:12:00', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-30 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '60', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('118', '2015-12-29 12:12:48', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-16 - 08:00:00<br/>Total Price: 250.00<br/>Customer: Matheus<br/>Staff: None', '61', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('119', '2015-12-29 12:13:19', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-03-21 - 08:00:00<br/>Total Price: 50.00<br/>Customer: Matheus<br/>Staff: None', '62', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('120', '2015-12-29 12:13:59', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-04-04 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '63', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('121', '2015-12-29 12:14:44', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-05-02 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '64', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('122', '2015-12-29 12:15:23', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-06-06 - 08:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: None', '65', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('123', '2015-12-29 12:15:51', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-07-06 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '66', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('124', '2015-12-29 12:16:30', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-08-01 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: None', '67', '1', 'matheus');
INSERT INTO `appointments_history` VALUES ('125', '2015-12-29 12:18:07', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-01-07 - 08:00:00<br/>Total Price: 50.00<br/>Customer: Mark<br/>Staff: None', '68', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('126', '2015-12-29 12:20:14', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-01-22 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '69', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('127', '2015-12-29 12:20:39', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-10 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '70', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('128', '2015-12-29 12:37:40', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-03-21 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '71', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('129', '2015-12-29 12:38:13', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-04-14 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '72', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('130', '2015-12-29 12:48:37', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-05-18 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '73', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('131', '2015-12-29 12:49:22', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-06-10 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '74', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('132', '2015-12-29 12:50:03', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-07-08 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '75', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('133', '2015-12-29 12:50:31', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-08-26 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '76', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('134', '2015-12-29 12:54:53', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-30 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: None', '77', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('135', '2015-12-29 12:58:27', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2015-12-30 - 10:30:00<br/>Total Price: 50.00<br/>Customer: Luke<br/>Staff: None', '78', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('136', '2015-12-29 12:58:54', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-01-13 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '79', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('137', '2015-12-29 12:59:23', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-17 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '80', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('138', '2015-12-29 13:00:06', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-10 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '81', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('139', '2015-12-29 13:00:32', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-03-09 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '82', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('140', '2015-12-29 13:01:35', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-04-05 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '83', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('141', '2015-12-29 13:02:07', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-05-24 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '84', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('142', '2015-12-29 13:02:51', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-06-21 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Luke<br/>Staff: None', '85', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('143', '2015-12-29 13:03:00', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-06-21 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Luke<br/>Staff: None', '85', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('144', '2015-12-29 13:03:43', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-07-07 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Luke<br/>Staff: None', '86', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('145', '2015-12-29 13:04:44', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-07-20 - 08:00:00<br/>Total Price: 600.00<br/>Customer: Luke<br/>Staff: None', '87', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('146', '2015-12-29 14:20:30', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2016-08-26 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: Abraham', '76', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('147', '2015-12-29 14:37:44', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-08-23 - 08:00:00<br/>Total Price: 550.00<br/>Customer: Luke<br/>Staff: None', '88', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('148', '2015-12-29 15:09:07', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-30 - 08:00:00<br/>Total Price: 300.00<br/>Customer: Mark<br/>Staff: Isaac', '77', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('149', '2015-12-29 15:28:56', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-10-23 - 11:05:00<br/>Total Price: 300.00<br/>Customer: Kyle<br/>Staff: Isaac', '31', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('150', '2015-12-29 15:30:07', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-11-23 - 17:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Isaac', '49', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('151', '2015-12-29 15:34:15', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-31 - 08:00:00<br/>Total Price: 150.00<br/>Customer: Matheus<br/>Staff: Isaac', '59', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('152', '2015-12-29 15:41:35', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-30 - 08:00:00<br/>Total Price: 100.00<br/>Customer: Matheus<br/>Staff: Abraham', '60', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('153', '2015-12-29 15:41:47', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2015-12-30 - 10:30:00<br/>Total Price: 50.00<br/>Customer: Luke<br/>Staff: Jacob', '78', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('154', '2015-12-29 15:57:03', 'New Appointment! <br/>Status: Scheduled<br/>Date: 2016-05-12 - 00:00:00<br/>Total Price: <br/>Customer: Kyle<br/>Staff: Abraham', '89', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('155', '2015-12-29 15:58:47', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2016-05-12 - 10:00:00<br/>Total Price: 50.00<br/>Customer: Kyle<br/>Staff: Abraham', '89', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('156', '2016-01-21 10:38:19', 'Appointment Updated! <br/>Status changed: Scheduled -> Reschedule', '55', '1', 'luke');
INSERT INTO `appointments_history` VALUES ('157', '2016-02-03 11:00:08', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-03 - 00:00:00<br/>Total Price: <br/>Customer: Kyle<br/>Staff: Abraham', '91', '1', 'admin');
INSERT INTO `appointments_history` VALUES ('158', '2016-02-15 14:55:34', 'New Appointment! <br/>Status: Awaiting Confirmation<br/>Date: 2016-02-16 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Mark<br/>Staff: None', '92', '1', 'mark');
INSERT INTO `appointments_history` VALUES ('159', '2016-02-15 15:00:00', 'Appointment Updated! <br/>Status: Scheduled<br/>Date: 2016-04-19 - 08:00:00<br/>Total Price: 350.00<br/>Customer: Mark<br/>Staff: Isaac', '92', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('160', '2016-02-15 15:00:37', 'New Appointment! <br/>Status: Scheduled<br/>Date: 2016-03-16 - 10:00:00<br/>Total Price: <br/>Customer: Luke<br/>Staff: Abraham', '93', '2', 'admin');
INSERT INTO `appointments_history` VALUES ('161', '2016-02-15 15:02:09', 'New Appointment! <br/>Status: Scheduled<br/>Date: 2016-02-26 - 14:00:00<br/>Total Price: <br/>Customer: Luke<br/>Staff: Abraham', '94', '2', 'admin');

-- ----------------------------
-- Table structure for `appointments_type`
-- ----------------------------
CREATE TABLE `appointments_type` (
  `appointments_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(45) DEFAULT NULL,
  `duration_displayed` int(11) DEFAULT NULL,
  `duration_type` varchar(1) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `price` decimal(6,2) DEFAULT NULL,
  `activated` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`appointments_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointments_type
-- ----------------------------
INSERT INTO `appointments_type` VALUES ('1', 'Format HD', '1', 'h', '60', '100.00', 'Y');
INSERT INTO `appointments_type` VALUES ('2', 'Change power supply', '60', 'm', '60', '100.00', 'Y');
INSERT INTO `appointments_type` VALUES ('3', 'Install Antivirus', '30', 'm', '30', '50.00', 'Y');
INSERT INTO `appointments_type` VALUES ('4', 'Install Office', '30', 'm', '30', '50.00', 'Y');
INSERT INTO `appointments_type` VALUES ('5', 'Install OS', '1', 'h', '60', '100.00', 'Y');
INSERT INTO `appointments_type` VALUES ('6', 'Server Maintenance', '4', 'h', '240', '300.00', 'Y');
INSERT INTO `appointments_type` VALUES ('7', 'Files Backup', '60', 'm', '60', '50.00', 'Y');

-- ----------------------------
-- Table structure for `appointments_weekdays`
-- ----------------------------
CREATE TABLE `appointments_weekdays` (
  `id_weekday` int(11) NOT NULL AUTO_INCREMENT,
  `weekday_descr` varchar(20) NOT NULL,
  PRIMARY KEY (`id_weekday`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointments_weekdays
-- ----------------------------
INSERT INTO `appointments_weekdays` VALUES ('1', 'Sunday');
INSERT INTO `appointments_weekdays` VALUES ('2', 'Monday');
INSERT INTO `appointments_weekdays` VALUES ('3', 'Tuesday');
INSERT INTO `appointments_weekdays` VALUES ('4', 'Wednesday');
INSERT INTO `appointments_weekdays` VALUES ('5', 'Thursday');
INSERT INTO `appointments_weekdays` VALUES ('6', 'Friday');
INSERT INTO `appointments_weekdays` VALUES ('7', 'Saturday');

-- ----------------------------
-- Table structure for `appointments_worktime`
-- ----------------------------
CREATE TABLE `appointments_worktime` (
  `id_worktime` int(11) NOT NULL AUTO_INCREMENT,
  `worktime_time` time NOT NULL,
  PRIMARY KEY (`id_worktime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointments_worktime
-- ----------------------------
INSERT INTO `appointments_worktime` VALUES ('1', '08:00:00');
INSERT INTO `appointments_worktime` VALUES ('2', '08:30:00');
INSERT INTO `appointments_worktime` VALUES ('3', '09:00:00');
INSERT INTO `appointments_worktime` VALUES ('4', '09:30:00');
INSERT INTO `appointments_worktime` VALUES ('5', '10:00:00');
INSERT INTO `appointments_worktime` VALUES ('6', '10:30:00');
INSERT INTO `appointments_worktime` VALUES ('7', '11:00:00');
INSERT INTO `appointments_worktime` VALUES ('8', '11:30:00');
INSERT INTO `appointments_worktime` VALUES ('9', '12:00:00');
INSERT INTO `appointments_worktime` VALUES ('10', '12:30:00');
INSERT INTO `appointments_worktime` VALUES ('11', '13:00:00');
INSERT INTO `appointments_worktime` VALUES ('12', '13:30:00');
INSERT INTO `appointments_worktime` VALUES ('13', '14:00:00');
INSERT INTO `appointments_worktime` VALUES ('14', '14:30:00');
INSERT INTO `appointments_worktime` VALUES ('15', '15:00:00');
INSERT INTO `appointments_worktime` VALUES ('16', '15:30:00');
INSERT INTO `appointments_worktime` VALUES ('17', '16:00:00');
INSERT INTO `appointments_worktime` VALUES ('18', '16:30:00');
INSERT INTO `appointments_worktime` VALUES ('19', '17:00:00');
INSERT INTO `appointments_worktime` VALUES ('20', '17:30:00');

-- ----------------------------
-- Table structure for `appointment_details`
-- ----------------------------
CREATE TABLE `appointment_details` (
  `appointment_details_id` int(11) NOT NULL AUTO_INCREMENT,
  `appointments_type_id` int(11) NOT NULL,
  `appointments_id` int(11) NOT NULL,
  PRIMARY KEY (`appointment_details_id`),
  KEY `fk_appointment_details_appointments_type1_idx` (`appointments_type_id`),
  KEY `fk_appointment_details_appointments1_idx` (`appointments_id`),
  CONSTRAINT `fk_appointment_details_appointments1` FOREIGN KEY (`appointments_id`) REFERENCES `appointments` (`appointments_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_appointment_details_appointments_type1` FOREIGN KEY (`appointments_type_id`) REFERENCES `appointments_type` (`appointments_type_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointment_details
-- ----------------------------
INSERT INTO `appointment_details` VALUES ('1', '2', '1');
INSERT INTO `appointment_details` VALUES ('2', '1', '1');
INSERT INTO `appointment_details` VALUES ('3', '3', '1');
INSERT INTO `appointment_details` VALUES ('10', '3', '2');
INSERT INTO `appointment_details` VALUES ('11', '4', '2');
INSERT INTO `appointment_details` VALUES ('12', '1', '3');
INSERT INTO `appointment_details` VALUES ('13', '2', '4');
INSERT INTO `appointment_details` VALUES ('14', '1', '4');
INSERT INTO `appointment_details` VALUES ('15', '3', '4');
INSERT INTO `appointment_details` VALUES ('17', '2', '5');
INSERT INTO `appointment_details` VALUES ('18', '2', '11');
INSERT INTO `appointment_details` VALUES ('19', '4', '11');
INSERT INTO `appointment_details` VALUES ('23', '2', '13');
INSERT INTO `appointment_details` VALUES ('24', '1', '13');
INSERT INTO `appointment_details` VALUES ('25', '4', '13');
INSERT INTO `appointment_details` VALUES ('30', '4', '14');
INSERT INTO `appointment_details` VALUES ('33', '2', '14');
INSERT INTO `appointment_details` VALUES ('38', '1', '15');
INSERT INTO `appointment_details` VALUES ('39', '4', '15');
INSERT INTO `appointment_details` VALUES ('41', '4', '16');
INSERT INTO `appointment_details` VALUES ('43', '2', '16');
INSERT INTO `appointment_details` VALUES ('44', '3', '17');
INSERT INTO `appointment_details` VALUES ('45', '4', '17');
INSERT INTO `appointment_details` VALUES ('46', '4', '18');
INSERT INTO `appointment_details` VALUES ('47', '1', '19');
INSERT INTO `appointment_details` VALUES ('48', '2', '20');
INSERT INTO `appointment_details` VALUES ('49', '3', '20');
INSERT INTO `appointment_details` VALUES ('50', '4', '20');
INSERT INTO `appointment_details` VALUES ('51', '5', '21');
INSERT INTO `appointment_details` VALUES ('53', '3', '21');
INSERT INTO `appointment_details` VALUES ('54', '2', '22');
INSERT INTO `appointment_details` VALUES ('55', '3', '22');
INSERT INTO `appointment_details` VALUES ('59', '1', '24');
INSERT INTO `appointment_details` VALUES ('60', '2', '24');
INSERT INTO `appointment_details` VALUES ('61', '3', '24');
INSERT INTO `appointment_details` VALUES ('62', '1', '25');
INSERT INTO `appointment_details` VALUES ('63', '2', '25');
INSERT INTO `appointment_details` VALUES ('64', '3', '25');
INSERT INTO `appointment_details` VALUES ('65', '2', '26');
INSERT INTO `appointment_details` VALUES ('66', '1', '27');
INSERT INTO `appointment_details` VALUES ('67', '3', '27');
INSERT INTO `appointment_details` VALUES ('68', '3', '28');
INSERT INTO `appointment_details` VALUES ('69', '5', '28');
INSERT INTO `appointment_details` VALUES ('70', '5', '29');
INSERT INTO `appointment_details` VALUES ('71', '2', '30');
INSERT INTO `appointment_details` VALUES ('72', '3', '30');
INSERT INTO `appointment_details` VALUES ('73', '2', '31');
INSERT INTO `appointment_details` VALUES ('74', '3', '31');
INSERT INTO `appointment_details` VALUES ('75', '4', '31');
INSERT INTO `appointment_details` VALUES ('76', '5', '31');
INSERT INTO `appointment_details` VALUES ('77', '4', '32');
INSERT INTO `appointment_details` VALUES ('78', '3', '33');
INSERT INTO `appointment_details` VALUES ('79', '3', '34');
INSERT INTO `appointment_details` VALUES ('80', '3', '35');
INSERT INTO `appointment_details` VALUES ('81', '3', '36');
INSERT INTO `appointment_details` VALUES ('82', '1', '37');
INSERT INTO `appointment_details` VALUES ('84', '3', '37');
INSERT INTO `appointment_details` VALUES ('85', '1', '38');
INSERT INTO `appointment_details` VALUES ('86', '2', '39');
INSERT INTO `appointment_details` VALUES ('87', '3', '39');
INSERT INTO `appointment_details` VALUES ('88', '3', '39');
INSERT INTO `appointment_details` VALUES ('89', '1', '40');
INSERT INTO `appointment_details` VALUES ('91', '2', '40');
INSERT INTO `appointment_details` VALUES ('92', '1', '41');
INSERT INTO `appointment_details` VALUES ('93', '2', '41');
INSERT INTO `appointment_details` VALUES ('94', '1', '42');
INSERT INTO `appointment_details` VALUES ('95', '1', '43');
INSERT INTO `appointment_details` VALUES ('96', '3', '44');
INSERT INTO `appointment_details` VALUES ('97', '4', '44');
INSERT INTO `appointment_details` VALUES ('98', '1', '45');
INSERT INTO `appointment_details` VALUES ('99', '2', '45');
INSERT INTO `appointment_details` VALUES ('100', '1', '46');
INSERT INTO `appointment_details` VALUES ('101', '2', '46');
INSERT INTO `appointment_details` VALUES ('102', '2', '47');
INSERT INTO `appointment_details` VALUES ('103', '2', '48');
INSERT INTO `appointment_details` VALUES ('104', '2', '49');
INSERT INTO `appointment_details` VALUES ('105', '1', '50');
INSERT INTO `appointment_details` VALUES ('106', '2', '51');
INSERT INTO `appointment_details` VALUES ('107', '1', '52');
INSERT INTO `appointment_details` VALUES ('108', '2', '52');
INSERT INTO `appointment_details` VALUES ('109', '3', '52');
INSERT INTO `appointment_details` VALUES ('110', '4', '52');
INSERT INTO `appointment_details` VALUES ('111', '5', '52');
INSERT INTO `appointment_details` VALUES ('112', '3', '53');
INSERT INTO `appointment_details` VALUES ('113', '4', '53');
INSERT INTO `appointment_details` VALUES ('114', '5', '53');
INSERT INTO `appointment_details` VALUES ('115', '1', '54');
INSERT INTO `appointment_details` VALUES ('116', '1', '55');
INSERT INTO `appointment_details` VALUES ('117', '2', '55');
INSERT INTO `appointment_details` VALUES ('118', '3', '55');
INSERT INTO `appointment_details` VALUES ('119', '4', '55');
INSERT INTO `appointment_details` VALUES ('120', '5', '55');
INSERT INTO `appointment_details` VALUES ('121', '1', '56');
INSERT INTO `appointment_details` VALUES ('122', '2', '57');
INSERT INTO `appointment_details` VALUES ('123', '3', '58');
INSERT INTO `appointment_details` VALUES ('124', '4', '58');
INSERT INTO `appointment_details` VALUES ('125', '2', '59');
INSERT INTO `appointment_details` VALUES ('126', '3', '59');
INSERT INTO `appointment_details` VALUES ('127', '5', '60');
INSERT INTO `appointment_details` VALUES ('128', '1', '61');
INSERT INTO `appointment_details` VALUES ('129', '2', '61');
INSERT INTO `appointment_details` VALUES ('130', '4', '61');
INSERT INTO `appointment_details` VALUES ('131', '4', '62');
INSERT INTO `appointment_details` VALUES ('132', '1', '63');
INSERT INTO `appointment_details` VALUES ('133', '1', '64');
INSERT INTO `appointment_details` VALUES ('134', '1', '65');
INSERT INTO `appointment_details` VALUES ('135', '3', '65');
INSERT INTO `appointment_details` VALUES ('136', '1', '66');
INSERT INTO `appointment_details` VALUES ('137', '5', '67');
INSERT INTO `appointment_details` VALUES ('138', '3', '68');
INSERT INTO `appointment_details` VALUES ('139', '6', '69');
INSERT INTO `appointment_details` VALUES ('140', '6', '70');
INSERT INTO `appointment_details` VALUES ('141', '6', '71');
INSERT INTO `appointment_details` VALUES ('142', '6', '72');
INSERT INTO `appointment_details` VALUES ('143', '6', '73');
INSERT INTO `appointment_details` VALUES ('144', '6', '74');
INSERT INTO `appointment_details` VALUES ('145', '6', '75');
INSERT INTO `appointment_details` VALUES ('146', '6', '76');
INSERT INTO `appointment_details` VALUES ('147', '6', '77');
INSERT INTO `appointment_details` VALUES ('148', '7', '78');
INSERT INTO `appointment_details` VALUES ('149', '6', '79');
INSERT INTO `appointment_details` VALUES ('150', '7', '79');
INSERT INTO `appointment_details` VALUES ('151', '6', '80');
INSERT INTO `appointment_details` VALUES ('152', '7', '80');
INSERT INTO `appointment_details` VALUES ('153', '6', '81');
INSERT INTO `appointment_details` VALUES ('154', '7', '81');
INSERT INTO `appointment_details` VALUES ('155', '6', '82');
INSERT INTO `appointment_details` VALUES ('156', '7', '82');
INSERT INTO `appointment_details` VALUES ('157', '6', '83');
INSERT INTO `appointment_details` VALUES ('158', '7', '83');
INSERT INTO `appointment_details` VALUES ('159', '6', '84');
INSERT INTO `appointment_details` VALUES ('160', '7', '84');
INSERT INTO `appointment_details` VALUES ('161', '6', '85');
INSERT INTO `appointment_details` VALUES ('162', '6', '86');
INSERT INTO `appointment_details` VALUES ('163', '7', '86');
INSERT INTO `appointment_details` VALUES ('164', '1', '87');
INSERT INTO `appointment_details` VALUES ('165', '3', '87');
INSERT INTO `appointment_details` VALUES ('166', '5', '87');
INSERT INTO `appointment_details` VALUES ('167', '6', '87');
INSERT INTO `appointment_details` VALUES ('168', '7', '87');
INSERT INTO `appointment_details` VALUES ('169', '1', '88');
INSERT INTO `appointment_details` VALUES ('170', '5', '88');
INSERT INTO `appointment_details` VALUES ('171', '6', '88');
INSERT INTO `appointment_details` VALUES ('172', '7', '88');
INSERT INTO `appointment_details` VALUES ('173', '7', '89');
INSERT INTO `appointment_details` VALUES ('174', '7', '90');
INSERT INTO `appointment_details` VALUES ('175', '3', '92');
INSERT INTO `appointment_details` VALUES ('176', '6', '92');
INSERT INTO `appointment_details` VALUES ('177', '2', '93');
INSERT INTO `appointment_details` VALUES ('178', '7', '93');
INSERT INTO `appointment_details` VALUES ('179', '3', '94');
INSERT INTO `appointment_details` VALUES ('180', '4', '94');

-- ----------------------------
-- Table structure for `appointment_status`
-- ----------------------------
CREATE TABLE `appointment_status` (
  `appointment_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_status_descr` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`appointment_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appointment_status
-- ----------------------------
INSERT INTO `appointment_status` VALUES ('1', 'Awaiting Confirmation');
INSERT INTO `appointment_status` VALUES ('2', 'Scheduled');
INSERT INTO `appointment_status` VALUES ('3', 'Canceled');
INSERT INTO `appointment_status` VALUES ('4', 'Check in');
INSERT INTO `appointment_status` VALUES ('5', 'Concluded');

-- ----------------------------
-- Table structure for `city`
-- ----------------------------
CREATE TABLE `city` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` char(35) NOT NULL DEFAULT '',
  `CountryCode` char(3) NOT NULL DEFAULT '',
  `District` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `CountryCode` (`CountryCode`),
  CONSTRAINT `city_ibfk_1` FOREIGN KEY (`CountryCode`) REFERENCES `country` (`Code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of city
-- ----------------------------
INSERT INTO `city` VALUES ('1', 'Kabul', 'AFG', 'Kabol');
INSERT INTO `city` VALUES ('2', 'Qandahar', 'AFG', 'Qandahar');
INSERT INTO `city` VALUES ('3', 'Herat', 'AFG', 'Herat');
INSERT INTO `city` VALUES ('4', 'Mazar-e-Sharif', 'AFG', 'Balkh');
INSERT INTO `city` VALUES ('5', 'Amsterdam', 'NLD', 'Noord-Holland');
INSERT INTO `city` VALUES ('6', 'Rotterdam', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('7', 'Haag', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('8', 'Utrecht', 'NLD', 'Utrecht');
INSERT INTO `city` VALUES ('9', 'Eindhoven', 'NLD', 'Noord-Brabant');
INSERT INTO `city` VALUES ('10', 'Tilburg', 'NLD', 'Noord-Brabant');
INSERT INTO `city` VALUES ('11', 'Groningen', 'NLD', 'Groningen');
INSERT INTO `city` VALUES ('12', 'Breda', 'NLD', 'Noord-Brabant');
INSERT INTO `city` VALUES ('13', 'Apeldoorn', 'NLD', 'Gelderland');
INSERT INTO `city` VALUES ('14', 'Nijmegen', 'NLD', 'Gelderland');
INSERT INTO `city` VALUES ('15', 'Enschede', 'NLD', 'Overijssel');
INSERT INTO `city` VALUES ('16', 'Haarlem', 'NLD', 'Noord-Holland');
INSERT INTO `city` VALUES ('17', 'Almere', 'NLD', 'Flevoland');
INSERT INTO `city` VALUES ('18', 'Arnhem', 'NLD', 'Gelderland');
INSERT INTO `city` VALUES ('19', 'Zaanstad', 'NLD', 'Noord-Holland');
INSERT INTO `city` VALUES ('20', '´s-Hertogenbosch', 'NLD', 'Noord-Brabant');
INSERT INTO `city` VALUES ('21', 'Amersfoort', 'NLD', 'Utrecht');
INSERT INTO `city` VALUES ('22', 'Maastricht', 'NLD', 'Limburg');
INSERT INTO `city` VALUES ('23', 'Dordrecht', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('24', 'Leiden', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('25', 'Haarlemmermeer', 'NLD', 'Noord-Holland');
INSERT INTO `city` VALUES ('26', 'Zoetermeer', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('27', 'Emmen', 'NLD', 'Drenthe');
INSERT INTO `city` VALUES ('28', 'Zwolle', 'NLD', 'Overijssel');
INSERT INTO `city` VALUES ('29', 'Ede', 'NLD', 'Gelderland');
INSERT INTO `city` VALUES ('30', 'Delft', 'NLD', 'Zuid-Holland');
INSERT INTO `city` VALUES ('31', 'Heerlen', 'NLD', 'Limburg');
INSERT INTO `city` VALUES ('32', 'Alkmaar', 'NLD', 'Noord-Holland');
INSERT INTO `city` VALUES ('33', 'Willemstad', 'ANT', 'Curaçao');
INSERT INTO `city` VALUES ('34', 'Tirana', 'ALB', 'Tirana');
INSERT INTO `city` VALUES ('35', 'Alger', 'DZA', 'Alger');
INSERT INTO `city` VALUES ('36', 'Oran', 'DZA', 'Oran');
INSERT INTO `city` VALUES ('37', 'Constantine', 'DZA', 'Constantine');
INSERT INTO `city` VALUES ('38', 'Annaba', 'DZA', 'Annaba');
INSERT INTO `city` VALUES ('39', 'Batna', 'DZA', 'Batna');
INSERT INTO `city` VALUES ('40', 'Sétif', 'DZA', 'Sétif');
INSERT INTO `city` VALUES ('41', 'Sidi Bel Abbès', 'DZA', 'Sidi Bel Abbès');
INSERT INTO `city` VALUES ('42', 'Skikda', 'DZA', 'Skikda');
INSERT INTO `city` VALUES ('43', 'Biskra', 'DZA', 'Biskra');
INSERT INTO `city` VALUES ('44', 'Blida (el-Boulaida)', 'DZA', 'Blida');
INSERT INTO `city` VALUES ('45', 'Béjaïa', 'DZA', 'Béjaïa');
INSERT INTO `city` VALUES ('46', 'Mostaganem', 'DZA', 'Mostaganem');
INSERT INTO `city` VALUES ('47', 'Tébessa', 'DZA', 'Tébessa');
INSERT INTO `city` VALUES ('48', 'Tlemcen (Tilimsen)', 'DZA', 'Tlemcen');
INSERT INTO `city` VALUES ('49', 'Béchar', 'DZA', 'Béchar');
INSERT INTO `city` VALUES ('50', 'Tiaret', 'DZA', 'Tiaret');
INSERT INTO `city` VALUES ('51', 'Ech-Chleff (el-Asnam)', 'DZA', 'Chlef');
INSERT INTO `city` VALUES ('52', 'Ghardaïa', 'DZA', 'Ghardaïa');
INSERT INTO `city` VALUES ('53', 'Tafuna', 'ASM', 'Tutuila');
INSERT INTO `city` VALUES ('54', 'Fagatogo', 'ASM', 'Tutuila');
INSERT INTO `city` VALUES ('55', 'Andorra la Vella', 'AND', 'Andorra la Vella');
INSERT INTO `city` VALUES ('56', 'Luanda', 'AGO', 'Luanda');
INSERT INTO `city` VALUES ('57', 'Huambo', 'AGO', 'Huambo');
INSERT INTO `city` VALUES ('58', 'Lobito', 'AGO', 'Benguela');
INSERT INTO `city` VALUES ('59', 'Benguela', 'AGO', 'Benguela');
INSERT INTO `city` VALUES ('60', 'Namibe', 'AGO', 'Namibe');
INSERT INTO `city` VALUES ('61', 'South Hill', 'AIA', '–');
INSERT INTO `city` VALUES ('62', 'The Valley', 'AIA', '–');
INSERT INTO `city` VALUES ('63', 'Saint John´s', 'ATG', 'St John');
INSERT INTO `city` VALUES ('64', 'Dubai', 'ARE', 'Dubai');
INSERT INTO `city` VALUES ('65', 'Abu Dhabi', 'ARE', 'Abu Dhabi');
INSERT INTO `city` VALUES ('66', 'Sharja', 'ARE', 'Sharja');
INSERT INTO `city` VALUES ('67', 'al-Ayn', 'ARE', 'Abu Dhabi');
INSERT INTO `city` VALUES ('68', 'Ajman', 'ARE', 'Ajman');
INSERT INTO `city` VALUES ('69', 'Buenos Aires', 'ARG', 'Distrito Federal');
INSERT INTO `city` VALUES ('70', 'La Matanza', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('71', 'Córdoba', 'ARG', 'Córdoba');
INSERT INTO `city` VALUES ('72', 'Rosario', 'ARG', 'Santa Fé');
INSERT INTO `city` VALUES ('73', 'Lomas de Zamora', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('74', 'Quilmes', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('75', 'Almirante Brown', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('76', 'La Plata', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('77', 'Mar del Plata', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('78', 'San Miguel de Tucumán', 'ARG', 'Tucumán');
INSERT INTO `city` VALUES ('79', 'Lanús', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('80', 'Merlo', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('81', 'General San Martín', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('82', 'Salta', 'ARG', 'Salta');
INSERT INTO `city` VALUES ('83', 'Moreno', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('84', 'Santa Fé', 'ARG', 'Santa Fé');
INSERT INTO `city` VALUES ('85', 'Avellaneda', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('86', 'Tres de Febrero', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('87', 'Morón', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('88', 'Florencio Varela', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('89', 'San Isidro', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('90', 'Tigre', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('91', 'Malvinas Argentinas', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('92', 'Vicente López', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('93', 'Berazategui', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('94', 'Corrientes', 'ARG', 'Corrientes');
INSERT INTO `city` VALUES ('95', 'San Miguel', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('96', 'Bahía Blanca', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('97', 'Esteban Echeverría', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('98', 'Resistencia', 'ARG', 'Chaco');
INSERT INTO `city` VALUES ('99', 'José C. Paz', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('100', 'Paraná', 'ARG', 'Entre Rios');
INSERT INTO `city` VALUES ('101', 'Godoy Cruz', 'ARG', 'Mendoza');
INSERT INTO `city` VALUES ('102', 'Posadas', 'ARG', 'Misiones');
INSERT INTO `city` VALUES ('103', 'Guaymallén', 'ARG', 'Mendoza');
INSERT INTO `city` VALUES ('104', 'Santiago del Estero', 'ARG', 'Santiago del Estero');
INSERT INTO `city` VALUES ('105', 'San Salvador de Jujuy', 'ARG', 'Jujuy');
INSERT INTO `city` VALUES ('106', 'Hurlingham', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('107', 'Neuquén', 'ARG', 'Neuquén');
INSERT INTO `city` VALUES ('108', 'Ituzaingó', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('109', 'San Fernando', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('110', 'Formosa', 'ARG', 'Formosa');
INSERT INTO `city` VALUES ('111', 'Las Heras', 'ARG', 'Mendoza');
INSERT INTO `city` VALUES ('112', 'La Rioja', 'ARG', 'La Rioja');
INSERT INTO `city` VALUES ('113', 'San Fernando del Valle de Cata', 'ARG', 'Catamarca');
INSERT INTO `city` VALUES ('114', 'Río Cuarto', 'ARG', 'Córdoba');
INSERT INTO `city` VALUES ('115', 'Comodoro Rivadavia', 'ARG', 'Chubut');
INSERT INTO `city` VALUES ('116', 'Mendoza', 'ARG', 'Mendoza');
INSERT INTO `city` VALUES ('117', 'San Nicolás de los Arroyos', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('118', 'San Juan', 'ARG', 'San Juan');
INSERT INTO `city` VALUES ('119', 'Escobar', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('120', 'Concordia', 'ARG', 'Entre Rios');
INSERT INTO `city` VALUES ('121', 'Pilar', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('122', 'San Luis', 'ARG', 'San Luis');
INSERT INTO `city` VALUES ('123', 'Ezeiza', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('124', 'San Rafael', 'ARG', 'Mendoza');
INSERT INTO `city` VALUES ('125', 'Tandil', 'ARG', 'Buenos Aires');
INSERT INTO `city` VALUES ('126', 'Yerevan', 'ARM', 'Yerevan');
INSERT INTO `city` VALUES ('127', 'Gjumri', 'ARM', 'Širak');
INSERT INTO `city` VALUES ('128', 'Vanadzor', 'ARM', 'Lori');
INSERT INTO `city` VALUES ('129', 'Oranjestad', 'ABW', '–');
INSERT INTO `city` VALUES ('130', 'Sydney', 'AUS', 'New South Wales');
INSERT INTO `city` VALUES ('131', 'Melbourne', 'AUS', 'Victoria');
INSERT INTO `city` VALUES ('132', 'Brisbane', 'AUS', 'Queensland');
INSERT INTO `city` VALUES ('133', 'Perth', 'AUS', 'West Australia');
INSERT INTO `city` VALUES ('134', 'Adelaide', 'AUS', 'South Australia');
INSERT INTO `city` VALUES ('135', 'Canberra', 'AUS', 'Capital Region');
INSERT INTO `city` VALUES ('136', 'Gold Coast', 'AUS', 'Queensland');
INSERT INTO `city` VALUES ('137', 'Newcastle', 'AUS', 'New South Wales');
INSERT INTO `city` VALUES ('138', 'Central Coast', 'AUS', 'New South Wales');
INSERT INTO `city` VALUES ('139', 'Wollongong', 'AUS', 'New South Wales');
INSERT INTO `city` VALUES ('140', 'Hobart', 'AUS', 'Tasmania');
INSERT INTO `city` VALUES ('141', 'Geelong', 'AUS', 'Victoria');
INSERT INTO `city` VALUES ('142', 'Townsville', 'AUS', 'Queensland');
INSERT INTO `city` VALUES ('143', 'Cairns', 'AUS', 'Queensland');
INSERT INTO `city` VALUES ('144', 'Baku', 'AZE', 'Baki');
INSERT INTO `city` VALUES ('145', 'Gäncä', 'AZE', 'Gäncä');
INSERT INTO `city` VALUES ('146', 'Sumqayit', 'AZE', 'Sumqayit');
INSERT INTO `city` VALUES ('147', 'Mingäçevir', 'AZE', 'Mingäçevir');
INSERT INTO `city` VALUES ('148', 'Nassau', 'BHS', 'New Providence');
INSERT INTO `city` VALUES ('149', 'al-Manama', 'BHR', 'al-Manama');
INSERT INTO `city` VALUES ('150', 'Dhaka', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('151', 'Chittagong', 'BGD', 'Chittagong');
INSERT INTO `city` VALUES ('152', 'Khulna', 'BGD', 'Khulna');
INSERT INTO `city` VALUES ('153', 'Rajshahi', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('154', 'Narayanganj', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('155', 'Rangpur', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('156', 'Mymensingh', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('157', 'Barisal', 'BGD', 'Barisal');
INSERT INTO `city` VALUES ('158', 'Tungi', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('159', 'Jessore', 'BGD', 'Khulna');
INSERT INTO `city` VALUES ('160', 'Comilla', 'BGD', 'Chittagong');
INSERT INTO `city` VALUES ('161', 'Nawabganj', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('162', 'Dinajpur', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('163', 'Bogra', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('164', 'Sylhet', 'BGD', 'Sylhet');
INSERT INTO `city` VALUES ('165', 'Brahmanbaria', 'BGD', 'Chittagong');
INSERT INTO `city` VALUES ('166', 'Tangail', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('167', 'Jamalpur', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('168', 'Pabna', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('169', 'Naogaon', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('170', 'Sirajganj', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('171', 'Narsinghdi', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('172', 'Saidpur', 'BGD', 'Rajshahi');
INSERT INTO `city` VALUES ('173', 'Gazipur', 'BGD', 'Dhaka');
INSERT INTO `city` VALUES ('174', 'Bridgetown', 'BRB', 'St Michael');
INSERT INTO `city` VALUES ('175', 'Antwerpen', 'BEL', 'Antwerpen');
INSERT INTO `city` VALUES ('176', 'Gent', 'BEL', 'East Flanderi');
INSERT INTO `city` VALUES ('177', 'Charleroi', 'BEL', 'Hainaut');
INSERT INTO `city` VALUES ('178', 'Liège', 'BEL', 'Liège');
INSERT INTO `city` VALUES ('179', 'Bruxelles [Brussel]', 'BEL', 'Bryssel');
INSERT INTO `city` VALUES ('180', 'Brugge', 'BEL', 'West Flanderi');
INSERT INTO `city` VALUES ('181', 'Schaerbeek', 'BEL', 'Bryssel');
INSERT INTO `city` VALUES ('182', 'Namur', 'BEL', 'Namur');
INSERT INTO `city` VALUES ('183', 'Mons', 'BEL', 'Hainaut');
INSERT INTO `city` VALUES ('184', 'Belize City', 'BLZ', 'Belize City');
INSERT INTO `city` VALUES ('185', 'Belmopan', 'BLZ', 'Cayo');
INSERT INTO `city` VALUES ('186', 'Cotonou', 'BEN', 'Atlantique');
INSERT INTO `city` VALUES ('187', 'Porto-Novo', 'BEN', 'Ouémé');
INSERT INTO `city` VALUES ('188', 'Djougou', 'BEN', 'Atacora');
INSERT INTO `city` VALUES ('189', 'Parakou', 'BEN', 'Borgou');
INSERT INTO `city` VALUES ('190', 'Saint George', 'BMU', 'Saint George´s');
INSERT INTO `city` VALUES ('191', 'Hamilton', 'BMU', 'Hamilton');
INSERT INTO `city` VALUES ('192', 'Thimphu', 'BTN', 'Thimphu');
INSERT INTO `city` VALUES ('193', 'Santa Cruz de la Sierra', 'BOL', 'Santa Cruz');
INSERT INTO `city` VALUES ('194', 'La Paz', 'BOL', 'La Paz');
INSERT INTO `city` VALUES ('195', 'El Alto', 'BOL', 'La Paz');
INSERT INTO `city` VALUES ('196', 'Cochabamba', 'BOL', 'Cochabamba');
INSERT INTO `city` VALUES ('197', 'Oruro', 'BOL', 'Oruro');
INSERT INTO `city` VALUES ('198', 'Sucre', 'BOL', 'Chuquisaca');
INSERT INTO `city` VALUES ('199', 'Potosí', 'BOL', 'Potosí');
INSERT INTO `city` VALUES ('200', 'Tarija', 'BOL', 'Tarija');
INSERT INTO `city` VALUES ('201', 'Sarajevo', 'BIH', 'Federaatio');
INSERT INTO `city` VALUES ('202', 'Banja Luka', 'BIH', 'Republika Srpska');
INSERT INTO `city` VALUES ('203', 'Zenica', 'BIH', 'Federaatio');
INSERT INTO `city` VALUES ('204', 'Gaborone', 'BWA', 'Gaborone');
INSERT INTO `city` VALUES ('205', 'Francistown', 'BWA', 'Francistown');
INSERT INTO `city` VALUES ('206', 'São Paulo', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('207', 'Rio de Janeiro', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('208', 'Salvador', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('209', 'Belo Horizonte', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('210', 'Fortaleza', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('211', 'Brasília', 'BRA', 'Distrito Federal');
INSERT INTO `city` VALUES ('212', 'Curitiba', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('213', 'Recife', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('214', 'Porto Alegre', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('215', 'Manaus', 'BRA', 'Amazonas');
INSERT INTO `city` VALUES ('216', 'Belém', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('217', 'Guarulhos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('218', 'Goiânia', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('219', 'Campinas', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('220', 'São Gonçalo', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('221', 'Nova Iguaçu', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('222', 'São Luís', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('223', 'Maceió', 'BRA', 'Alagoas');
INSERT INTO `city` VALUES ('224', 'Duque de Caxias', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('225', 'São Bernardo do Campo', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('226', 'Teresina', 'BRA', 'Piauí');
INSERT INTO `city` VALUES ('227', 'Natal', 'BRA', 'Rio Grande do Norte');
INSERT INTO `city` VALUES ('228', 'Osasco', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('229', 'Campo Grande', 'BRA', 'Mato Grosso do Sul');
INSERT INTO `city` VALUES ('230', 'Santo André', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('231', 'João Pessoa', 'BRA', 'Paraíba');
INSERT INTO `city` VALUES ('232', 'Jaboatão dos Guararapes', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('233', 'Contagem', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('234', 'São José dos Campos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('235', 'Uberlândia', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('236', 'Feira de Santana', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('237', 'Ribeirão Preto', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('238', 'Sorocaba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('239', 'Niterói', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('240', 'Cuiabá', 'BRA', 'Mato Grosso');
INSERT INTO `city` VALUES ('241', 'Juiz de Fora', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('242', 'Aracaju', 'BRA', 'Sergipe');
INSERT INTO `city` VALUES ('243', 'São João de Meriti', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('244', 'Londrina', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('245', 'Joinville', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('246', 'Belford Roxo', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('247', 'Santos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('248', 'Ananindeua', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('249', 'Campos dos Goytacazes', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('250', 'Mauá', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('251', 'Carapicuíba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('252', 'Olinda', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('253', 'Campina Grande', 'BRA', 'Paraíba');
INSERT INTO `city` VALUES ('254', 'São José do Rio Preto', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('255', 'Caxias do Sul', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('256', 'Moji das Cruzes', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('257', 'Diadema', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('258', 'Aparecida de Goiânia', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('259', 'Piracicaba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('260', 'Cariacica', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('261', 'Vila Velha', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('262', 'Pelotas', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('263', 'Bauru', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('264', 'Porto Velho', 'BRA', 'Rondônia');
INSERT INTO `city` VALUES ('265', 'Serra', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('266', 'Betim', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('267', 'Jundíaí', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('268', 'Canoas', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('269', 'Franca', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('270', 'São Vicente', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('271', 'Maringá', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('272', 'Montes Claros', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('273', 'Anápolis', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('274', 'Florianópolis', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('275', 'Petrópolis', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('276', 'Itaquaquecetuba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('277', 'Vitória', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('278', 'Ponta Grossa', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('279', 'Rio Branco', 'BRA', 'Acre');
INSERT INTO `city` VALUES ('280', 'Foz do Iguaçu', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('281', 'Macapá', 'BRA', 'Amapá');
INSERT INTO `city` VALUES ('282', 'Ilhéus', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('283', 'Vitória da Conquista', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('284', 'Uberaba', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('285', 'Paulista', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('286', 'Limeira', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('287', 'Blumenau', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('288', 'Caruaru', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('289', 'Santarém', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('290', 'Volta Redonda', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('291', 'Novo Hamburgo', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('292', 'Caucaia', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('293', 'Santa Maria', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('294', 'Cascavel', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('295', 'Guarujá', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('296', 'Ribeirão das Neves', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('297', 'Governador Valadares', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('298', 'Taubaté', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('299', 'Imperatriz', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('300', 'Gravataí', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('301', 'Embu', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('302', 'Mossoró', 'BRA', 'Rio Grande do Norte');
INSERT INTO `city` VALUES ('303', 'Várzea Grande', 'BRA', 'Mato Grosso');
INSERT INTO `city` VALUES ('304', 'Petrolina', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('305', 'Barueri', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('306', 'Viamão', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('307', 'Ipatinga', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('308', 'Juazeiro', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('309', 'Juazeiro do Norte', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('310', 'Taboão da Serra', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('311', 'São José dos Pinhais', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('312', 'Magé', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('313', 'Suzano', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('314', 'São Leopoldo', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('315', 'Marília', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('316', 'São Carlos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('317', 'Sumaré', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('318', 'Presidente Prudente', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('319', 'Divinópolis', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('320', 'Sete Lagoas', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('321', 'Rio Grande', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('322', 'Itabuna', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('323', 'Jequié', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('324', 'Arapiraca', 'BRA', 'Alagoas');
INSERT INTO `city` VALUES ('325', 'Colombo', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('326', 'Americana', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('327', 'Alvorada', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('328', 'Araraquara', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('329', 'Itaboraí', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('330', 'Santa Bárbara d´Oeste', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('331', 'Nova Friburgo', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('332', 'Jacareí', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('333', 'Araçatuba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('334', 'Barra Mansa', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('335', 'Praia Grande', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('336', 'Marabá', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('337', 'Criciúma', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('338', 'Boa Vista', 'BRA', 'Roraima');
INSERT INTO `city` VALUES ('339', 'Passo Fundo', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('340', 'Dourados', 'BRA', 'Mato Grosso do Sul');
INSERT INTO `city` VALUES ('341', 'Santa Luzia', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('342', 'Rio Claro', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('343', 'Maracanaú', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('344', 'Guarapuava', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('345', 'Rondonópolis', 'BRA', 'Mato Grosso');
INSERT INTO `city` VALUES ('346', 'São José', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('347', 'Cachoeiro de Itapemirim', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('348', 'Nilópolis', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('349', 'Itapevi', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('350', 'Cabo de Santo Agostinho', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('351', 'Camaçari', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('352', 'Sobral', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('353', 'Itajaí', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('354', 'Chapecó', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('355', 'Cotia', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('356', 'Lages', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('357', 'Ferraz de Vasconcelos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('358', 'Indaiatuba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('359', 'Hortolândia', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('360', 'Caxias', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('361', 'São Caetano do Sul', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('362', 'Itu', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('363', 'Nossa Senhora do Socorro', 'BRA', 'Sergipe');
INSERT INTO `city` VALUES ('364', 'Parnaíba', 'BRA', 'Piauí');
INSERT INTO `city` VALUES ('365', 'Poços de Caldas', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('366', 'Teresópolis', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('367', 'Barreiras', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('368', 'Castanhal', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('369', 'Alagoinhas', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('370', 'Itapecerica da Serra', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('371', 'Uruguaiana', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('372', 'Paranaguá', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('373', 'Ibirité', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('374', 'Timon', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('375', 'Luziânia', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('376', 'Macaé', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('377', 'Teófilo Otoni', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('378', 'Moji-Guaçu', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('379', 'Palmas', 'BRA', 'Tocantins');
INSERT INTO `city` VALUES ('380', 'Pindamonhangaba', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('381', 'Francisco Morato', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('382', 'Bagé', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('383', 'Sapucaia do Sul', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('384', 'Cabo Frio', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('385', 'Itapetininga', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('386', 'Patos de Minas', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('387', 'Camaragibe', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('388', 'Bragança Paulista', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('389', 'Queimados', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('390', 'Araguaína', 'BRA', 'Tocantins');
INSERT INTO `city` VALUES ('391', 'Garanhuns', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('392', 'Vitória de Santo Antão', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('393', 'Santa Rita', 'BRA', 'Paraíba');
INSERT INTO `city` VALUES ('394', 'Barbacena', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('395', 'Abaetetuba', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('396', 'Jaú', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('397', 'Lauro de Freitas', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('398', 'Franco da Rocha', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('399', 'Teixeira de Freitas', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('400', 'Varginha', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('401', 'Ribeirão Pires', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('402', 'Sabará', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('403', 'Catanduva', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('404', 'Rio Verde', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('405', 'Botucatu', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('406', 'Colatina', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('407', 'Santa Cruz do Sul', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('408', 'Linhares', 'BRA', 'Espírito Santo');
INSERT INTO `city` VALUES ('409', 'Apucarana', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('410', 'Barretos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('411', 'Guaratinguetá', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('412', 'Cachoeirinha', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('413', 'Codó', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('414', 'Jaraguá do Sul', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('415', 'Cubatão', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('416', 'Itabira', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('417', 'Itaituba', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('418', 'Araras', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('419', 'Resende', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('420', 'Atibaia', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('421', 'Pouso Alegre', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('422', 'Toledo', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('423', 'Crato', 'BRA', 'Ceará');
INSERT INTO `city` VALUES ('424', 'Passos', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('425', 'Araguari', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('426', 'São José de Ribamar', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('427', 'Pinhais', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('428', 'Sertãozinho', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('429', 'Conselheiro Lafaiete', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('430', 'Paulo Afonso', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('431', 'Angra dos Reis', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('432', 'Eunápolis', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('433', 'Salto', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('434', 'Ourinhos', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('435', 'Parnamirim', 'BRA', 'Rio Grande do Norte');
INSERT INTO `city` VALUES ('436', 'Jacobina', 'BRA', 'Bahia');
INSERT INTO `city` VALUES ('437', 'Coronel Fabriciano', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('438', 'Birigui', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('439', 'Tatuí', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('440', 'Ji-Paraná', 'BRA', 'Rondônia');
INSERT INTO `city` VALUES ('441', 'Bacabal', 'BRA', 'Maranhão');
INSERT INTO `city` VALUES ('442', 'Cametá', 'BRA', 'Pará');
INSERT INTO `city` VALUES ('443', 'Guaíba', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('444', 'São Lourenço da Mata', 'BRA', 'Pernambuco');
INSERT INTO `city` VALUES ('445', 'Santana do Livramento', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('446', 'Votorantim', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('447', 'Campo Largo', 'BRA', 'Paraná');
INSERT INTO `city` VALUES ('448', 'Patos', 'BRA', 'Paraíba');
INSERT INTO `city` VALUES ('449', 'Ituiutaba', 'BRA', 'Minas Gerais');
INSERT INTO `city` VALUES ('450', 'Corumbá', 'BRA', 'Mato Grosso do Sul');
INSERT INTO `city` VALUES ('451', 'Palhoça', 'BRA', 'Santa Catarina');
INSERT INTO `city` VALUES ('452', 'Barra do Piraí', 'BRA', 'Rio de Janeiro');
INSERT INTO `city` VALUES ('453', 'Bento Gonçalves', 'BRA', 'Rio Grande do Sul');
INSERT INTO `city` VALUES ('454', 'Poá', 'BRA', 'São Paulo');
INSERT INTO `city` VALUES ('455', 'Águas Lindas de Goiás', 'BRA', 'Goiás');
INSERT INTO `city` VALUES ('456', 'London', 'GBR', 'England');
INSERT INTO `city` VALUES ('457', 'Birmingham', 'GBR', 'England');
INSERT INTO `city` VALUES ('458', 'Glasgow', 'GBR', 'Scotland');
INSERT INTO `city` VALUES ('459', 'Liverpool', 'GBR', 'England');
INSERT INTO `city` VALUES ('460', 'Edinburgh', 'GBR', 'Scotland');
INSERT INTO `city` VALUES ('461', 'Sheffield', 'GBR', 'England');
INSERT INTO `city` VALUES ('462', 'Manchester', 'GBR', 'England');
INSERT INTO `city` VALUES ('463', 'Leeds', 'GBR', 'England');
INSERT INTO `city` VALUES ('464', 'Bristol', 'GBR', 'England');
INSERT INTO `city` VALUES ('465', 'Cardiff', 'GBR', 'Wales');
INSERT INTO `city` VALUES ('466', 'Coventry', 'GBR', 'England');
INSERT INTO `city` VALUES ('467', 'Leicester', 'GBR', 'England');
INSERT INTO `city` VALUES ('468', 'Bradford', 'GBR', 'England');
INSERT INTO `city` VALUES ('469', 'Belfast', 'GBR', 'North Ireland');
INSERT INTO `city` VALUES ('470', 'Nottingham', 'GBR', 'England');
INSERT INTO `city` VALUES ('471', 'Kingston upon Hull', 'GBR', 'England');
INSERT INTO `city` VALUES ('472', 'Plymouth', 'GBR', 'England');
INSERT INTO `city` VALUES ('473', 'Stoke-on-Trent', 'GBR', 'England');
INSERT INTO `city` VALUES ('474', 'Wolverhampton', 'GBR', 'England');
INSERT INTO `city` VALUES ('475', 'Derby', 'GBR', 'England');
INSERT INTO `city` VALUES ('476', 'Swansea', 'GBR', 'Wales');
INSERT INTO `city` VALUES ('477', 'Southampton', 'GBR', 'England');
INSERT INTO `city` VALUES ('478', 'Aberdeen', 'GBR', 'Scotland');
INSERT INTO `city` VALUES ('479', 'Northampton', 'GBR', 'England');
INSERT INTO `city` VALUES ('480', 'Dudley', 'GBR', 'England');
INSERT INTO `city` VALUES ('481', 'Portsmouth', 'GBR', 'England');
INSERT INTO `city` VALUES ('482', 'Newcastle upon Tyne', 'GBR', 'England');
INSERT INTO `city` VALUES ('483', 'Sunderland', 'GBR', 'England');
INSERT INTO `city` VALUES ('484', 'Luton', 'GBR', 'England');
INSERT INTO `city` VALUES ('485', 'Swindon', 'GBR', 'England');
INSERT INTO `city` VALUES ('486', 'Southend-on-Sea', 'GBR', 'England');
INSERT INTO `city` VALUES ('487', 'Walsall', 'GBR', 'England');
INSERT INTO `city` VALUES ('488', 'Bournemouth', 'GBR', 'England');
INSERT INTO `city` VALUES ('489', 'Peterborough', 'GBR', 'England');
INSERT INTO `city` VALUES ('490', 'Brighton', 'GBR', 'England');
INSERT INTO `city` VALUES ('491', 'Blackpool', 'GBR', 'England');
INSERT INTO `city` VALUES ('492', 'Dundee', 'GBR', 'Scotland');
INSERT INTO `city` VALUES ('493', 'West Bromwich', 'GBR', 'England');
INSERT INTO `city` VALUES ('494', 'Reading', 'GBR', 'England');
INSERT INTO `city` VALUES ('495', 'Oldbury/Smethwick (Warley)', 'GBR', 'England');
INSERT INTO `city` VALUES ('496', 'Middlesbrough', 'GBR', 'England');
INSERT INTO `city` VALUES ('497', 'Huddersfield', 'GBR', 'England');
INSERT INTO `city` VALUES ('498', 'Oxford', 'GBR', 'England');
INSERT INTO `city` VALUES ('499', 'Poole', 'GBR', 'England');
INSERT INTO `city` VALUES ('500', 'Bolton', 'GBR', 'England');
INSERT INTO `city` VALUES ('501', 'Blackburn', 'GBR', 'England');
INSERT INTO `city` VALUES ('502', 'Newport', 'GBR', 'Wales');
INSERT INTO `city` VALUES ('503', 'Preston', 'GBR', 'England');
INSERT INTO `city` VALUES ('504', 'Stockport', 'GBR', 'England');
INSERT INTO `city` VALUES ('505', 'Norwich', 'GBR', 'England');
INSERT INTO `city` VALUES ('506', 'Rotherham', 'GBR', 'England');
INSERT INTO `city` VALUES ('507', 'Cambridge', 'GBR', 'England');
INSERT INTO `city` VALUES ('508', 'Watford', 'GBR', 'England');
INSERT INTO `city` VALUES ('509', 'Ipswich', 'GBR', 'England');
INSERT INTO `city` VALUES ('510', 'Slough', 'GBR', 'England');
INSERT INTO `city` VALUES ('511', 'Exeter', 'GBR', 'England');
INSERT INTO `city` VALUES ('512', 'Cheltenham', 'GBR', 'England');
INSERT INTO `city` VALUES ('513', 'Gloucester', 'GBR', 'England');
INSERT INTO `city` VALUES ('514', 'Saint Helens', 'GBR', 'England');
INSERT INTO `city` VALUES ('515', 'Sutton Coldfield', 'GBR', 'England');
INSERT INTO `city` VALUES ('516', 'York', 'GBR', 'England');
INSERT INTO `city` VALUES ('517', 'Oldham', 'GBR', 'England');
INSERT INTO `city` VALUES ('518', 'Basildon', 'GBR', 'England');
INSERT INTO `city` VALUES ('519', 'Worthing', 'GBR', 'England');
INSERT INTO `city` VALUES ('520', 'Chelmsford', 'GBR', 'England');
INSERT INTO `city` VALUES ('521', 'Colchester', 'GBR', 'England');
INSERT INTO `city` VALUES ('522', 'Crawley', 'GBR', 'England');
INSERT INTO `city` VALUES ('523', 'Gillingham', 'GBR', 'England');
INSERT INTO `city` VALUES ('524', 'Solihull', 'GBR', 'England');
INSERT INTO `city` VALUES ('525', 'Rochdale', 'GBR', 'England');
INSERT INTO `city` VALUES ('526', 'Birkenhead', 'GBR', 'England');
INSERT INTO `city` VALUES ('527', 'Worcester', 'GBR', 'England');
INSERT INTO `city` VALUES ('528', 'Hartlepool', 'GBR', 'England');
INSERT INTO `city` VALUES ('529', 'Halifax', 'GBR', 'England');
INSERT INTO `city` VALUES ('530', 'Woking/Byfleet', 'GBR', 'England');
INSERT INTO `city` VALUES ('531', 'Southport', 'GBR', 'England');
INSERT INTO `city` VALUES ('532', 'Maidstone', 'GBR', 'England');
INSERT INTO `city` VALUES ('533', 'Eastbourne', 'GBR', 'England');
INSERT INTO `city` VALUES ('534', 'Grimsby', 'GBR', 'England');
INSERT INTO `city` VALUES ('535', 'Saint Helier', 'GBR', 'Jersey');
INSERT INTO `city` VALUES ('536', 'Douglas', 'GBR', '–');
INSERT INTO `city` VALUES ('537', 'Road Town', 'VGB', 'Tortola');
INSERT INTO `city` VALUES ('538', 'Bandar Seri Begawan', 'BRN', 'Brunei and Muara');
INSERT INTO `city` VALUES ('539', 'Sofija', 'BGR', 'Grad Sofija');
INSERT INTO `city` VALUES ('540', 'Plovdiv', 'BGR', 'Plovdiv');
INSERT INTO `city` VALUES ('541', 'Varna', 'BGR', 'Varna');
INSERT INTO `city` VALUES ('542', 'Burgas', 'BGR', 'Burgas');
INSERT INTO `city` VALUES ('543', 'Ruse', 'BGR', 'Ruse');
INSERT INTO `city` VALUES ('544', 'Stara Zagora', 'BGR', 'Haskovo');
INSERT INTO `city` VALUES ('545', 'Pleven', 'BGR', 'Lovec');
INSERT INTO `city` VALUES ('546', 'Sliven', 'BGR', 'Burgas');
INSERT INTO `city` VALUES ('547', 'Dobric', 'BGR', 'Varna');
INSERT INTO `city` VALUES ('548', 'Šumen', 'BGR', 'Varna');
INSERT INTO `city` VALUES ('549', 'Ouagadougou', 'BFA', 'Kadiogo');
INSERT INTO `city` VALUES ('550', 'Bobo-Dioulasso', 'BFA', 'Houet');
INSERT INTO `city` VALUES ('551', 'Koudougou', 'BFA', 'Boulkiemdé');
INSERT INTO `city` VALUES ('552', 'Bujumbura', 'BDI', 'Bujumbura');
INSERT INTO `city` VALUES ('553', 'George Town', 'CYM', 'Grand Cayman');
INSERT INTO `city` VALUES ('554', 'Santiago de Chile', 'CHL', 'Santiago');
INSERT INTO `city` VALUES ('555', 'Puente Alto', 'CHL', 'Santiago');
INSERT INTO `city` VALUES ('556', 'Viña del Mar', 'CHL', 'Valparaíso');
INSERT INTO `city` VALUES ('557', 'Valparaíso', 'CHL', 'Valparaíso');
INSERT INTO `city` VALUES ('558', 'Talcahuano', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('559', 'Antofagasta', 'CHL', 'Antofagasta');
INSERT INTO `city` VALUES ('560', 'San Bernardo', 'CHL', 'Santiago');
INSERT INTO `city` VALUES ('561', 'Temuco', 'CHL', 'La Araucanía');
INSERT INTO `city` VALUES ('562', 'Concepción', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('563', 'Rancagua', 'CHL', 'O´Higgins');
INSERT INTO `city` VALUES ('564', 'Arica', 'CHL', 'Tarapacá');
INSERT INTO `city` VALUES ('565', 'Talca', 'CHL', 'Maule');
INSERT INTO `city` VALUES ('566', 'Chillán', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('567', 'Iquique', 'CHL', 'Tarapacá');
INSERT INTO `city` VALUES ('568', 'Los Angeles', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('569', 'Puerto Montt', 'CHL', 'Los Lagos');
INSERT INTO `city` VALUES ('570', 'Coquimbo', 'CHL', 'Coquimbo');
INSERT INTO `city` VALUES ('571', 'Osorno', 'CHL', 'Los Lagos');
INSERT INTO `city` VALUES ('572', 'La Serena', 'CHL', 'Coquimbo');
INSERT INTO `city` VALUES ('573', 'Calama', 'CHL', 'Antofagasta');
INSERT INTO `city` VALUES ('574', 'Valdivia', 'CHL', 'Los Lagos');
INSERT INTO `city` VALUES ('575', 'Punta Arenas', 'CHL', 'Magallanes');
INSERT INTO `city` VALUES ('576', 'Copiapó', 'CHL', 'Atacama');
INSERT INTO `city` VALUES ('577', 'Quilpué', 'CHL', 'Valparaíso');
INSERT INTO `city` VALUES ('578', 'Curicó', 'CHL', 'Maule');
INSERT INTO `city` VALUES ('579', 'Ovalle', 'CHL', 'Coquimbo');
INSERT INTO `city` VALUES ('580', 'Coronel', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('581', 'San Pedro de la Paz', 'CHL', 'Bíobío');
INSERT INTO `city` VALUES ('582', 'Melipilla', 'CHL', 'Santiago');
INSERT INTO `city` VALUES ('583', 'Avarua', 'COK', 'Rarotonga');
INSERT INTO `city` VALUES ('584', 'San José', 'CRI', 'San José');
INSERT INTO `city` VALUES ('585', 'Djibouti', 'DJI', 'Djibouti');
INSERT INTO `city` VALUES ('586', 'Roseau', 'DMA', 'St George');
INSERT INTO `city` VALUES ('587', 'Santo Domingo de Guzmán', 'DOM', 'Distrito Nacional');
INSERT INTO `city` VALUES ('588', 'Santiago de los Caballeros', 'DOM', 'Santiago');
INSERT INTO `city` VALUES ('589', 'La Romana', 'DOM', 'La Romana');
INSERT INTO `city` VALUES ('590', 'San Pedro de Macorís', 'DOM', 'San Pedro de Macorís');
INSERT INTO `city` VALUES ('591', 'San Francisco de Macorís', 'DOM', 'Duarte');
INSERT INTO `city` VALUES ('592', 'San Felipe de Puerto Plata', 'DOM', 'Puerto Plata');
INSERT INTO `city` VALUES ('593', 'Guayaquil', 'ECU', 'Guayas');
INSERT INTO `city` VALUES ('594', 'Quito', 'ECU', 'Pichincha');
INSERT INTO `city` VALUES ('595', 'Cuenca', 'ECU', 'Azuay');
INSERT INTO `city` VALUES ('596', 'Machala', 'ECU', 'El Oro');
INSERT INTO `city` VALUES ('597', 'Santo Domingo de los Colorados', 'ECU', 'Pichincha');
INSERT INTO `city` VALUES ('598', 'Portoviejo', 'ECU', 'Manabí');
INSERT INTO `city` VALUES ('599', 'Ambato', 'ECU', 'Tungurahua');
INSERT INTO `city` VALUES ('600', 'Manta', 'ECU', 'Manabí');
INSERT INTO `city` VALUES ('601', 'Duran [Eloy Alfaro]', 'ECU', 'Guayas');
INSERT INTO `city` VALUES ('602', 'Ibarra', 'ECU', 'Imbabura');
INSERT INTO `city` VALUES ('603', 'Quevedo', 'ECU', 'Los Ríos');
INSERT INTO `city` VALUES ('604', 'Milagro', 'ECU', 'Guayas');
INSERT INTO `city` VALUES ('605', 'Loja', 'ECU', 'Loja');
INSERT INTO `city` VALUES ('606', 'Ríobamba', 'ECU', 'Chimborazo');
INSERT INTO `city` VALUES ('607', 'Esmeraldas', 'ECU', 'Esmeraldas');
INSERT INTO `city` VALUES ('608', 'Cairo', 'EGY', 'Kairo');
INSERT INTO `city` VALUES ('609', 'Alexandria', 'EGY', 'Aleksandria');
INSERT INTO `city` VALUES ('610', 'Giza', 'EGY', 'Giza');
INSERT INTO `city` VALUES ('611', 'Shubra al-Khayma', 'EGY', 'al-Qalyubiya');
INSERT INTO `city` VALUES ('612', 'Port Said', 'EGY', 'Port Said');
INSERT INTO `city` VALUES ('613', 'Suez', 'EGY', 'Suez');
INSERT INTO `city` VALUES ('614', 'al-Mahallat al-Kubra', 'EGY', 'al-Gharbiya');
INSERT INTO `city` VALUES ('615', 'Tanta', 'EGY', 'al-Gharbiya');
INSERT INTO `city` VALUES ('616', 'al-Mansura', 'EGY', 'al-Daqahliya');
INSERT INTO `city` VALUES ('617', 'Luxor', 'EGY', 'Luxor');
INSERT INTO `city` VALUES ('618', 'Asyut', 'EGY', 'Asyut');
INSERT INTO `city` VALUES ('619', 'Bahtim', 'EGY', 'al-Qalyubiya');
INSERT INTO `city` VALUES ('620', 'Zagazig', 'EGY', 'al-Sharqiya');
INSERT INTO `city` VALUES ('621', 'al-Faiyum', 'EGY', 'al-Faiyum');
INSERT INTO `city` VALUES ('622', 'Ismailia', 'EGY', 'Ismailia');
INSERT INTO `city` VALUES ('623', 'Kafr al-Dawwar', 'EGY', 'al-Buhayra');
INSERT INTO `city` VALUES ('624', 'Assuan', 'EGY', 'Assuan');
INSERT INTO `city` VALUES ('625', 'Damanhur', 'EGY', 'al-Buhayra');
INSERT INTO `city` VALUES ('626', 'al-Minya', 'EGY', 'al-Minya');
INSERT INTO `city` VALUES ('627', 'Bani Suwayf', 'EGY', 'Bani Suwayf');
INSERT INTO `city` VALUES ('628', 'Qina', 'EGY', 'Qina');
INSERT INTO `city` VALUES ('629', 'Sawhaj', 'EGY', 'Sawhaj');
INSERT INTO `city` VALUES ('630', 'Shibin al-Kawm', 'EGY', 'al-Minufiya');
INSERT INTO `city` VALUES ('631', 'Bulaq al-Dakrur', 'EGY', 'Giza');
INSERT INTO `city` VALUES ('632', 'Banha', 'EGY', 'al-Qalyubiya');
INSERT INTO `city` VALUES ('633', 'Warraq al-Arab', 'EGY', 'Giza');
INSERT INTO `city` VALUES ('634', 'Kafr al-Shaykh', 'EGY', 'Kafr al-Shaykh');
INSERT INTO `city` VALUES ('635', 'Mallawi', 'EGY', 'al-Minya');
INSERT INTO `city` VALUES ('636', 'Bilbays', 'EGY', 'al-Sharqiya');
INSERT INTO `city` VALUES ('637', 'Mit Ghamr', 'EGY', 'al-Daqahliya');
INSERT INTO `city` VALUES ('638', 'al-Arish', 'EGY', 'Shamal Sina');
INSERT INTO `city` VALUES ('639', 'Talkha', 'EGY', 'al-Daqahliya');
INSERT INTO `city` VALUES ('640', 'Qalyub', 'EGY', 'al-Qalyubiya');
INSERT INTO `city` VALUES ('641', 'Jirja', 'EGY', 'Sawhaj');
INSERT INTO `city` VALUES ('642', 'Idfu', 'EGY', 'Qina');
INSERT INTO `city` VALUES ('643', 'al-Hawamidiya', 'EGY', 'Giza');
INSERT INTO `city` VALUES ('644', 'Disuq', 'EGY', 'Kafr al-Shaykh');
INSERT INTO `city` VALUES ('645', 'San Salvador', 'SLV', 'San Salvador');
INSERT INTO `city` VALUES ('646', 'Santa Ana', 'SLV', 'Santa Ana');
INSERT INTO `city` VALUES ('647', 'Mejicanos', 'SLV', 'San Salvador');
INSERT INTO `city` VALUES ('648', 'Soyapango', 'SLV', 'San Salvador');
INSERT INTO `city` VALUES ('649', 'San Miguel', 'SLV', 'San Miguel');
INSERT INTO `city` VALUES ('650', 'Nueva San Salvador', 'SLV', 'La Libertad');
INSERT INTO `city` VALUES ('651', 'Apopa', 'SLV', 'San Salvador');
INSERT INTO `city` VALUES ('652', 'Asmara', 'ERI', 'Maekel');
INSERT INTO `city` VALUES ('653', 'Madrid', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('654', 'Barcelona', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('655', 'Valencia', 'ESP', 'Valencia');
INSERT INTO `city` VALUES ('656', 'Sevilla', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('657', 'Zaragoza', 'ESP', 'Aragonia');
INSERT INTO `city` VALUES ('658', 'Málaga', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('659', 'Bilbao', 'ESP', 'Baskimaa');
INSERT INTO `city` VALUES ('660', 'Las Palmas de Gran Canaria', 'ESP', 'Canary Islands');
INSERT INTO `city` VALUES ('661', 'Murcia', 'ESP', 'Murcia');
INSERT INTO `city` VALUES ('662', 'Palma de Mallorca', 'ESP', 'Balears');
INSERT INTO `city` VALUES ('663', 'Valladolid', 'ESP', 'Castilla and León');
INSERT INTO `city` VALUES ('664', 'Córdoba', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('665', 'Vigo', 'ESP', 'Galicia');
INSERT INTO `city` VALUES ('666', 'Alicante [Alacant]', 'ESP', 'Valencia');
INSERT INTO `city` VALUES ('667', 'Gijón', 'ESP', 'Asturia');
INSERT INTO `city` VALUES ('668', 'L´Hospitalet de Llobregat', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('669', 'Granada', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('670', 'A Coruña (La Coruña)', 'ESP', 'Galicia');
INSERT INTO `city` VALUES ('671', 'Vitoria-Gasteiz', 'ESP', 'Baskimaa');
INSERT INTO `city` VALUES ('672', 'Santa Cruz de Tenerife', 'ESP', 'Canary Islands');
INSERT INTO `city` VALUES ('673', 'Badalona', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('674', 'Oviedo', 'ESP', 'Asturia');
INSERT INTO `city` VALUES ('675', 'Móstoles', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('676', 'Elche [Elx]', 'ESP', 'Valencia');
INSERT INTO `city` VALUES ('677', 'Sabadell', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('678', 'Santander', 'ESP', 'Cantabria');
INSERT INTO `city` VALUES ('679', 'Jerez de la Frontera', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('680', 'Pamplona [Iruña]', 'ESP', 'Navarra');
INSERT INTO `city` VALUES ('681', 'Donostia-San Sebastián', 'ESP', 'Baskimaa');
INSERT INTO `city` VALUES ('682', 'Cartagena', 'ESP', 'Murcia');
INSERT INTO `city` VALUES ('683', 'Leganés', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('684', 'Fuenlabrada', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('685', 'Almería', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('686', 'Terrassa', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('687', 'Alcalá de Henares', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('688', 'Burgos', 'ESP', 'Castilla and León');
INSERT INTO `city` VALUES ('689', 'Salamanca', 'ESP', 'Castilla and León');
INSERT INTO `city` VALUES ('690', 'Albacete', 'ESP', 'Kastilia-La Mancha');
INSERT INTO `city` VALUES ('691', 'Getafe', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('692', 'Cádiz', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('693', 'Alcorcón', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('694', 'Huelva', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('695', 'León', 'ESP', 'Castilla and León');
INSERT INTO `city` VALUES ('696', 'Castellón de la Plana [Castell', 'ESP', 'Valencia');
INSERT INTO `city` VALUES ('697', 'Badajoz', 'ESP', 'Extremadura');
INSERT INTO `city` VALUES ('698', '[San Cristóbal de] la Laguna', 'ESP', 'Canary Islands');
INSERT INTO `city` VALUES ('699', 'Logroño', 'ESP', 'La Rioja');
INSERT INTO `city` VALUES ('700', 'Santa Coloma de Gramenet', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('701', 'Tarragona', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('702', 'Lleida (Lérida)', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('703', 'Jaén', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('704', 'Ourense (Orense)', 'ESP', 'Galicia');
INSERT INTO `city` VALUES ('705', 'Mataró', 'ESP', 'Katalonia');
INSERT INTO `city` VALUES ('706', 'Algeciras', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('707', 'Marbella', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('708', 'Barakaldo', 'ESP', 'Baskimaa');
INSERT INTO `city` VALUES ('709', 'Dos Hermanas', 'ESP', 'Andalusia');
INSERT INTO `city` VALUES ('710', 'Santiago de Compostela', 'ESP', 'Galicia');
INSERT INTO `city` VALUES ('711', 'Torrejón de Ardoz', 'ESP', 'Madrid');
INSERT INTO `city` VALUES ('712', 'Cape Town', 'ZAF', 'Western Cape');
INSERT INTO `city` VALUES ('713', 'Soweto', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('714', 'Johannesburg', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('715', 'Port Elizabeth', 'ZAF', 'Eastern Cape');
INSERT INTO `city` VALUES ('716', 'Pretoria', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('717', 'Inanda', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('718', 'Durban', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('719', 'Vanderbijlpark', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('720', 'Kempton Park', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('721', 'Alberton', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('722', 'Pinetown', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('723', 'Pietermaritzburg', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('724', 'Benoni', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('725', 'Randburg', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('726', 'Umlazi', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('727', 'Bloemfontein', 'ZAF', 'Free State');
INSERT INTO `city` VALUES ('728', 'Vereeniging', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('729', 'Wonderboom', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('730', 'Roodepoort', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('731', 'Boksburg', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('732', 'Klerksdorp', 'ZAF', 'North West');
INSERT INTO `city` VALUES ('733', 'Soshanguve', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('734', 'Newcastle', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('735', 'East London', 'ZAF', 'Eastern Cape');
INSERT INTO `city` VALUES ('736', 'Welkom', 'ZAF', 'Free State');
INSERT INTO `city` VALUES ('737', 'Kimberley', 'ZAF', 'Northern Cape');
INSERT INTO `city` VALUES ('738', 'Uitenhage', 'ZAF', 'Eastern Cape');
INSERT INTO `city` VALUES ('739', 'Chatsworth', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('740', 'Mdantsane', 'ZAF', 'Eastern Cape');
INSERT INTO `city` VALUES ('741', 'Krugersdorp', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('742', 'Botshabelo', 'ZAF', 'Free State');
INSERT INTO `city` VALUES ('743', 'Brakpan', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('744', 'Witbank', 'ZAF', 'Mpumalanga');
INSERT INTO `city` VALUES ('745', 'Oberholzer', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('746', 'Germiston', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('747', 'Springs', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('748', 'Westonaria', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('749', 'Randfontein', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('750', 'Paarl', 'ZAF', 'Western Cape');
INSERT INTO `city` VALUES ('751', 'Potchefstroom', 'ZAF', 'North West');
INSERT INTO `city` VALUES ('752', 'Rustenburg', 'ZAF', 'North West');
INSERT INTO `city` VALUES ('753', 'Nigel', 'ZAF', 'Gauteng');
INSERT INTO `city` VALUES ('754', 'George', 'ZAF', 'Western Cape');
INSERT INTO `city` VALUES ('755', 'Ladysmith', 'ZAF', 'KwaZulu-Natal');
INSERT INTO `city` VALUES ('756', 'Addis Abeba', 'ETH', 'Addis Abeba');
INSERT INTO `city` VALUES ('757', 'Dire Dawa', 'ETH', 'Dire Dawa');
INSERT INTO `city` VALUES ('758', 'Nazret', 'ETH', 'Oromia');
INSERT INTO `city` VALUES ('759', 'Gonder', 'ETH', 'Amhara');
INSERT INTO `city` VALUES ('760', 'Dese', 'ETH', 'Amhara');
INSERT INTO `city` VALUES ('761', 'Mekele', 'ETH', 'Tigray');
INSERT INTO `city` VALUES ('762', 'Bahir Dar', 'ETH', 'Amhara');
INSERT INTO `city` VALUES ('763', 'Stanley', 'FLK', 'East Falkland');
INSERT INTO `city` VALUES ('764', 'Suva', 'FJI', 'Central');
INSERT INTO `city` VALUES ('765', 'Quezon', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('766', 'Manila', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('767', 'Kalookan', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('768', 'Davao', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('769', 'Cebu', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('770', 'Zamboanga', 'PHL', 'Western Mindanao');
INSERT INTO `city` VALUES ('771', 'Pasig', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('772', 'Valenzuela', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('773', 'Las Piñas', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('774', 'Antipolo', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('775', 'Taguig', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('776', 'Cagayan de Oro', 'PHL', 'Northern Mindanao');
INSERT INTO `city` VALUES ('777', 'Parañaque', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('778', 'Makati', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('779', 'Bacolod', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('780', 'General Santos', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('781', 'Marikina', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('782', 'Dasmariñas', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('783', 'Muntinlupa', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('784', 'Iloilo', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('785', 'Pasay', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('786', 'Malabon', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('787', 'San José del Monte', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('788', 'Bacoor', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('789', 'Iligan', 'PHL', 'Central Mindanao');
INSERT INTO `city` VALUES ('790', 'Calamba', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('791', 'Mandaluyong', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('792', 'Butuan', 'PHL', 'Caraga');
INSERT INTO `city` VALUES ('793', 'Angeles', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('794', 'Tarlac', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('795', 'Mandaue', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('796', 'Baguio', 'PHL', 'CAR');
INSERT INTO `city` VALUES ('797', 'Batangas', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('798', 'Cainta', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('799', 'San Pedro', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('800', 'Navotas', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('801', 'Cabanatuan', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('802', 'San Fernando', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('803', 'Lipa', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('804', 'Lapu-Lapu', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('805', 'San Pablo', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('806', 'Biñan', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('807', 'Taytay', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('808', 'Lucena', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('809', 'Imus', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('810', 'Olongapo', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('811', 'Binangonan', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('812', 'Santa Rosa', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('813', 'Tagum', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('814', 'Tacloban', 'PHL', 'Eastern Visayas');
INSERT INTO `city` VALUES ('815', 'Malolos', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('816', 'Mabalacat', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('817', 'Cotabato', 'PHL', 'Central Mindanao');
INSERT INTO `city` VALUES ('818', 'Meycauayan', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('819', 'Puerto Princesa', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('820', 'Legazpi', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('821', 'Silang', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('822', 'Ormoc', 'PHL', 'Eastern Visayas');
INSERT INTO `city` VALUES ('823', 'San Carlos', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('824', 'Kabankalan', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('825', 'Talisay', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('826', 'Valencia', 'PHL', 'Northern Mindanao');
INSERT INTO `city` VALUES ('827', 'Calbayog', 'PHL', 'Eastern Visayas');
INSERT INTO `city` VALUES ('828', 'Santa Maria', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('829', 'Pagadian', 'PHL', 'Western Mindanao');
INSERT INTO `city` VALUES ('830', 'Cadiz', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('831', 'Bago', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('832', 'Toledo', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('833', 'Naga', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('834', 'San Mateo', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('835', 'Panabo', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('836', 'Koronadal', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('837', 'Marawi', 'PHL', 'Central Mindanao');
INSERT INTO `city` VALUES ('838', 'Dagupan', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('839', 'Sagay', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('840', 'Roxas', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('841', 'Lubao', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('842', 'Digos', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('843', 'San Miguel', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('844', 'Malaybalay', 'PHL', 'Northern Mindanao');
INSERT INTO `city` VALUES ('845', 'Tuguegarao', 'PHL', 'Cagayan Valley');
INSERT INTO `city` VALUES ('846', 'Ilagan', 'PHL', 'Cagayan Valley');
INSERT INTO `city` VALUES ('847', 'Baliuag', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('848', 'Surigao', 'PHL', 'Caraga');
INSERT INTO `city` VALUES ('849', 'San Carlos', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('850', 'San Juan del Monte', 'PHL', 'National Capital Reg');
INSERT INTO `city` VALUES ('851', 'Tanauan', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('852', 'Concepcion', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('853', 'Rodriguez (Montalban)', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('854', 'Sariaya', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('855', 'Malasiqui', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('856', 'General Mariano Alvarez', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('857', 'Urdaneta', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('858', 'Hagonoy', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('859', 'San Jose', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('860', 'Polomolok', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('861', 'Santiago', 'PHL', 'Cagayan Valley');
INSERT INTO `city` VALUES ('862', 'Tanza', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('863', 'Ozamis', 'PHL', 'Northern Mindanao');
INSERT INTO `city` VALUES ('864', 'Mexico', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('865', 'San Jose', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('866', 'Silay', 'PHL', 'Western Visayas');
INSERT INTO `city` VALUES ('867', 'General Trias', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('868', 'Tabaco', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('869', 'Cabuyao', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('870', 'Calapan', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('871', 'Mati', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('872', 'Midsayap', 'PHL', 'Central Mindanao');
INSERT INTO `city` VALUES ('873', 'Cauayan', 'PHL', 'Cagayan Valley');
INSERT INTO `city` VALUES ('874', 'Gingoog', 'PHL', 'Northern Mindanao');
INSERT INTO `city` VALUES ('875', 'Dumaguete', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('876', 'San Fernando', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('877', 'Arayat', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('878', 'Bayawan (Tulong)', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('879', 'Kidapawan', 'PHL', 'Central Mindanao');
INSERT INTO `city` VALUES ('880', 'Daraga (Locsin)', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('881', 'Marilao', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('882', 'Malita', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('883', 'Dipolog', 'PHL', 'Western Mindanao');
INSERT INTO `city` VALUES ('884', 'Cavite', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('885', 'Danao', 'PHL', 'Central Visayas');
INSERT INTO `city` VALUES ('886', 'Bislig', 'PHL', 'Caraga');
INSERT INTO `city` VALUES ('887', 'Talavera', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('888', 'Guagua', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('889', 'Bayambang', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('890', 'Nasugbu', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('891', 'Baybay', 'PHL', 'Eastern Visayas');
INSERT INTO `city` VALUES ('892', 'Capas', 'PHL', 'Central Luzon');
INSERT INTO `city` VALUES ('893', 'Sultan Kudarat', 'PHL', 'ARMM');
INSERT INTO `city` VALUES ('894', 'Laoag', 'PHL', 'Ilocos');
INSERT INTO `city` VALUES ('895', 'Bayugan', 'PHL', 'Caraga');
INSERT INTO `city` VALUES ('896', 'Malungon', 'PHL', 'Southern Mindanao');
INSERT INTO `city` VALUES ('897', 'Santa Cruz', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('898', 'Sorsogon', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('899', 'Candelaria', 'PHL', 'Southern Tagalog');
INSERT INTO `city` VALUES ('900', 'Ligao', 'PHL', 'Bicol');
INSERT INTO `city` VALUES ('901', 'Tórshavn', 'FRO', 'Streymoyar');
INSERT INTO `city` VALUES ('902', 'Libreville', 'GAB', 'Estuaire');
INSERT INTO `city` VALUES ('903', 'Serekunda', 'GMB', 'Kombo St Mary');
INSERT INTO `city` VALUES ('904', 'Banjul', 'GMB', 'Banjul');
INSERT INTO `city` VALUES ('905', 'Tbilisi', 'GEO', 'Tbilisi');
INSERT INTO `city` VALUES ('906', 'Kutaisi', 'GEO', 'Imereti');
INSERT INTO `city` VALUES ('907', 'Rustavi', 'GEO', 'Kvemo Kartli');
INSERT INTO `city` VALUES ('908', 'Batumi', 'GEO', 'Adzaria [Atšara]');
INSERT INTO `city` VALUES ('909', 'Sohumi', 'GEO', 'Abhasia [Aphazeti]');
INSERT INTO `city` VALUES ('910', 'Accra', 'GHA', 'Greater Accra');
INSERT INTO `city` VALUES ('911', 'Kumasi', 'GHA', 'Ashanti');
INSERT INTO `city` VALUES ('912', 'Tamale', 'GHA', 'Northern');
INSERT INTO `city` VALUES ('913', 'Tema', 'GHA', 'Greater Accra');
INSERT INTO `city` VALUES ('914', 'Sekondi-Takoradi', 'GHA', 'Western');
INSERT INTO `city` VALUES ('915', 'Gibraltar', 'GIB', '–');
INSERT INTO `city` VALUES ('916', 'Saint George´s', 'GRD', 'St George');
INSERT INTO `city` VALUES ('917', 'Nuuk', 'GRL', 'Kitaa');
INSERT INTO `city` VALUES ('918', 'Les Abymes', 'GLP', 'Grande-Terre');
INSERT INTO `city` VALUES ('919', 'Basse-Terre', 'GLP', 'Basse-Terre');
INSERT INTO `city` VALUES ('920', 'Tamuning', 'GUM', '–');
INSERT INTO `city` VALUES ('921', 'Agaña', 'GUM', '–');
INSERT INTO `city` VALUES ('922', 'Ciudad de Guatemala', 'GTM', 'Guatemala');
INSERT INTO `city` VALUES ('923', 'Mixco', 'GTM', 'Guatemala');
INSERT INTO `city` VALUES ('924', 'Villa Nueva', 'GTM', 'Guatemala');
INSERT INTO `city` VALUES ('925', 'Quetzaltenango', 'GTM', 'Quetzaltenango');
INSERT INTO `city` VALUES ('926', 'Conakry', 'GIN', 'Conakry');
INSERT INTO `city` VALUES ('927', 'Bissau', 'GNB', 'Bissau');
INSERT INTO `city` VALUES ('928', 'Georgetown', 'GUY', 'Georgetown');
INSERT INTO `city` VALUES ('929', 'Port-au-Prince', 'HTI', 'Ouest');
INSERT INTO `city` VALUES ('930', 'Carrefour', 'HTI', 'Ouest');
INSERT INTO `city` VALUES ('931', 'Delmas', 'HTI', 'Ouest');
INSERT INTO `city` VALUES ('932', 'Le-Cap-Haïtien', 'HTI', 'Nord');
INSERT INTO `city` VALUES ('933', 'Tegucigalpa', 'HND', 'Distrito Central');
INSERT INTO `city` VALUES ('934', 'San Pedro Sula', 'HND', 'Cortés');
INSERT INTO `city` VALUES ('935', 'La Ceiba', 'HND', 'Atlántida');
INSERT INTO `city` VALUES ('936', 'Kowloon and New Kowloon', 'HKG', 'Kowloon and New Kowl');
INSERT INTO `city` VALUES ('937', 'Victoria', 'HKG', 'Hongkong');
INSERT INTO `city` VALUES ('938', 'Longyearbyen', 'SJM', 'Länsimaa');
INSERT INTO `city` VALUES ('939', 'Jakarta', 'IDN', 'Jakarta Raya');
INSERT INTO `city` VALUES ('940', 'Surabaya', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('941', 'Bandung', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('942', 'Medan', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('943', 'Palembang', 'IDN', 'Sumatera Selatan');
INSERT INTO `city` VALUES ('944', 'Tangerang', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('945', 'Semarang', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('946', 'Ujung Pandang', 'IDN', 'Sulawesi Selatan');
INSERT INTO `city` VALUES ('947', 'Malang', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('948', 'Bandar Lampung', 'IDN', 'Lampung');
INSERT INTO `city` VALUES ('949', 'Bekasi', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('950', 'Padang', 'IDN', 'Sumatera Barat');
INSERT INTO `city` VALUES ('951', 'Surakarta', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('952', 'Banjarmasin', 'IDN', 'Kalimantan Selatan');
INSERT INTO `city` VALUES ('953', 'Pekan Baru', 'IDN', 'Riau');
INSERT INTO `city` VALUES ('954', 'Denpasar', 'IDN', 'Bali');
INSERT INTO `city` VALUES ('955', 'Yogyakarta', 'IDN', 'Yogyakarta');
INSERT INTO `city` VALUES ('956', 'Pontianak', 'IDN', 'Kalimantan Barat');
INSERT INTO `city` VALUES ('957', 'Samarinda', 'IDN', 'Kalimantan Timur');
INSERT INTO `city` VALUES ('958', 'Jambi', 'IDN', 'Jambi');
INSERT INTO `city` VALUES ('959', 'Depok', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('960', 'Cimahi', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('961', 'Balikpapan', 'IDN', 'Kalimantan Timur');
INSERT INTO `city` VALUES ('962', 'Manado', 'IDN', 'Sulawesi Utara');
INSERT INTO `city` VALUES ('963', 'Mataram', 'IDN', 'Nusa Tenggara Barat');
INSERT INTO `city` VALUES ('964', 'Pekalongan', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('965', 'Tegal', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('966', 'Bogor', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('967', 'Ciputat', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('968', 'Pondokgede', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('969', 'Cirebon', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('970', 'Kediri', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('971', 'Ambon', 'IDN', 'Molukit');
INSERT INTO `city` VALUES ('972', 'Jember', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('973', 'Cilacap', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('974', 'Cimanggis', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('975', 'Pematang Siantar', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('976', 'Purwokerto', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('977', 'Ciomas', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('978', 'Tasikmalaya', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('979', 'Madiun', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('980', 'Bengkulu', 'IDN', 'Bengkulu');
INSERT INTO `city` VALUES ('981', 'Karawang', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('982', 'Banda Aceh', 'IDN', 'Aceh');
INSERT INTO `city` VALUES ('983', 'Palu', 'IDN', 'Sulawesi Tengah');
INSERT INTO `city` VALUES ('984', 'Pasuruan', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('985', 'Kupang', 'IDN', 'Nusa Tenggara Timur');
INSERT INTO `city` VALUES ('986', 'Tebing Tinggi', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('987', 'Percut Sei Tuan', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('988', 'Binjai', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('989', 'Sukabumi', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('990', 'Waru', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('991', 'Pangkal Pinang', 'IDN', 'Sumatera Selatan');
INSERT INTO `city` VALUES ('992', 'Magelang', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('993', 'Blitar', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('994', 'Serang', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('995', 'Probolinggo', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('996', 'Cilegon', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('997', 'Cianjur', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('998', 'Ciparay', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('999', 'Lhokseumawe', 'IDN', 'Aceh');
INSERT INTO `city` VALUES ('1000', 'Taman', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('1001', 'Depok', 'IDN', 'Yogyakarta');
INSERT INTO `city` VALUES ('1002', 'Citeureup', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1003', 'Pemalang', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('1004', 'Klaten', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('1005', 'Salatiga', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('1006', 'Cibinong', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1007', 'Palangka Raya', 'IDN', 'Kalimantan Tengah');
INSERT INTO `city` VALUES ('1008', 'Mojokerto', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('1009', 'Purwakarta', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1010', 'Garut', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1011', 'Kudus', 'IDN', 'Central Java');
INSERT INTO `city` VALUES ('1012', 'Kendari', 'IDN', 'Sulawesi Tenggara');
INSERT INTO `city` VALUES ('1013', 'Jaya Pura', 'IDN', 'West Irian');
INSERT INTO `city` VALUES ('1014', 'Gorontalo', 'IDN', 'Sulawesi Utara');
INSERT INTO `city` VALUES ('1015', 'Majalaya', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1016', 'Pondok Aren', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1017', 'Jombang', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('1018', 'Sunggal', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('1019', 'Batam', 'IDN', 'Riau');
INSERT INTO `city` VALUES ('1020', 'Padang Sidempuan', 'IDN', 'Sumatera Utara');
INSERT INTO `city` VALUES ('1021', 'Sawangan', 'IDN', 'West Java');
INSERT INTO `city` VALUES ('1022', 'Banyuwangi', 'IDN', 'East Java');
INSERT INTO `city` VALUES ('1023', 'Tanjung Pinang', 'IDN', 'Riau');
INSERT INTO `city` VALUES ('1024', 'Mumbai (Bombay)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1025', 'Delhi', 'IND', 'Delhi');
INSERT INTO `city` VALUES ('1026', 'Calcutta [Kolkata]', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1027', 'Chennai (Madras)', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1028', 'Hyderabad', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1029', 'Ahmedabad', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1030', 'Bangalore', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1031', 'Kanpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1032', 'Nagpur', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1033', 'Lucknow', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1034', 'Pune', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1035', 'Surat', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1036', 'Jaipur', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1037', 'Indore', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1038', 'Bhopal', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1039', 'Ludhiana', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1040', 'Vadodara (Baroda)', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1041', 'Kalyan', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1042', 'Madurai', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1043', 'Haora (Howrah)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1044', 'Varanasi (Benares)', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1045', 'Patna', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1046', 'Srinagar', 'IND', 'Jammu and Kashmir');
INSERT INTO `city` VALUES ('1047', 'Agra', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1048', 'Coimbatore', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1049', 'Thane (Thana)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1050', 'Allahabad', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1051', 'Meerut', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1052', 'Vishakhapatnam', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1053', 'Jabalpur', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1054', 'Amritsar', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1055', 'Faridabad', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1056', 'Vijayawada', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1057', 'Gwalior', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1058', 'Jodhpur', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1059', 'Nashik (Nasik)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1060', 'Hubli-Dharwad', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1061', 'Solapur (Sholapur)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1062', 'Ranchi', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1063', 'Bareilly', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1064', 'Guwahati (Gauhati)', 'IND', 'Assam');
INSERT INTO `city` VALUES ('1065', 'Shambajinagar (Aurangabad)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1066', 'Cochin (Kochi)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1067', 'Rajkot', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1068', 'Kota', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1069', 'Thiruvananthapuram (Trivandrum', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1070', 'Pimpri-Chinchwad', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1071', 'Jalandhar (Jullundur)', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1072', 'Gorakhpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1073', 'Chandigarh', 'IND', 'Chandigarh');
INSERT INTO `city` VALUES ('1074', 'Mysore', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1075', 'Aligarh', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1076', 'Guntur', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1077', 'Jamshedpur', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1078', 'Ghaziabad', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1079', 'Warangal', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1080', 'Raipur', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1081', 'Moradabad', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1082', 'Durgapur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1083', 'Amravati', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1084', 'Calicut (Kozhikode)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1085', 'Bikaner', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1086', 'Bhubaneswar', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1087', 'Kolhapur', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1088', 'Kataka (Cuttack)', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1089', 'Ajmer', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1090', 'Bhavnagar', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1091', 'Tiruchirapalli', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1092', 'Bhilai', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1093', 'Bhiwandi', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1094', 'Saharanpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1095', 'Ulhasnagar', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1096', 'Salem', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1097', 'Ujjain', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1098', 'Malegaon', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1099', 'Jamnagar', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1100', 'Bokaro Steel City', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1101', 'Akola', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1102', 'Belgaum', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1103', 'Rajahmundry', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1104', 'Nellore', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1105', 'Udaipur', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1106', 'New Bombay', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1107', 'Bhatpara', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1108', 'Gulbarga', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1109', 'New Delhi', 'IND', 'Delhi');
INSERT INTO `city` VALUES ('1110', 'Jhansi', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1111', 'Gaya', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1112', 'Kakinada', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1113', 'Dhule (Dhulia)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1114', 'Panihati', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1115', 'Nanded (Nander)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1116', 'Mangalore', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1117', 'Dehra Dun', 'IND', 'Uttaranchal');
INSERT INTO `city` VALUES ('1118', 'Kamarhati', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1119', 'Davangere', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1120', 'Asansol', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1121', 'Bhagalpur', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1122', 'Bellary', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1123', 'Barddhaman (Burdwan)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1124', 'Rampur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1125', 'Jalgaon', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1126', 'Muzaffarpur', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1127', 'Nizamabad', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1128', 'Muzaffarnagar', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1129', 'Patiala', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1130', 'Shahjahanpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1131', 'Kurnool', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1132', 'Tiruppur (Tirupper)', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1133', 'Rohtak', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1134', 'South Dum Dum', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1135', 'Mathura', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1136', 'Chandrapur', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1137', 'Barahanagar (Baranagar)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1138', 'Darbhanga', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1139', 'Siliguri (Shiliguri)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1140', 'Raurkela', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1141', 'Ambattur', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1142', 'Panipat', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1143', 'Firozabad', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1144', 'Ichalkaranji', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1145', 'Jammu', 'IND', 'Jammu and Kashmir');
INSERT INTO `city` VALUES ('1146', 'Ramagundam', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1147', 'Eluru', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1148', 'Brahmapur', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1149', 'Alwar', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1150', 'Pondicherry', 'IND', 'Pondicherry');
INSERT INTO `city` VALUES ('1151', 'Thanjavur', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1152', 'Bihar Sharif', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1153', 'Tuticorin', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1154', 'Imphal', 'IND', 'Manipur');
INSERT INTO `city` VALUES ('1155', 'Latur', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1156', 'Sagar', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1157', 'Farrukhabad-cum-Fatehgarh', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1158', 'Sangli', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1159', 'Parbhani', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1160', 'Nagar Coil', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1161', 'Bijapur', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1162', 'Kukatpalle', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1163', 'Bally', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1164', 'Bhilwara', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1165', 'Ratlam', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1166', 'Avadi', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1167', 'Dindigul', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1168', 'Ahmadnagar', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1169', 'Bilaspur', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1170', 'Shimoga', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1171', 'Kharagpur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1172', 'Mira Bhayandar', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1173', 'Vellore', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1174', 'Jalna', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1175', 'Burnpur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1176', 'Anantapur', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1177', 'Allappuzha (Alleppey)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1178', 'Tirupati', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1179', 'Karnal', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1180', 'Burhanpur', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1181', 'Hisar (Hissar)', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1182', 'Tiruvottiyur', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1183', 'Mirzapur-cum-Vindhyachal', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1184', 'Secunderabad', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1185', 'Nadiad', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1186', 'Dewas', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1187', 'Murwara (Katni)', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1188', 'Ganganagar', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1189', 'Vizianagaram', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1190', 'Erode', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1191', 'Machilipatnam (Masulipatam)', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1192', 'Bhatinda (Bathinda)', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1193', 'Raichur', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1194', 'Agartala', 'IND', 'Tripura');
INSERT INTO `city` VALUES ('1195', 'Arrah (Ara)', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1196', 'Satna', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1197', 'Lalbahadur Nagar', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1198', 'Aizawl', 'IND', 'Mizoram');
INSERT INTO `city` VALUES ('1199', 'Uluberia', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1200', 'Katihar', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1201', 'Cuddalore', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1202', 'Hugli-Chinsurah', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1203', 'Dhanbad', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1204', 'Raiganj', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1205', 'Sambhal', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1206', 'Durg', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1207', 'Munger (Monghyr)', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1208', 'Kanchipuram', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1209', 'North Dum Dum', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1210', 'Karimnagar', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1211', 'Bharatpur', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1212', 'Sikar', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1213', 'Hardwar (Haridwar)', 'IND', 'Uttaranchal');
INSERT INTO `city` VALUES ('1214', 'Dabgram', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1215', 'Morena', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1216', 'Noida', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1217', 'Hapur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1218', 'Bhusawal', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1219', 'Khandwa', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1220', 'Yamuna Nagar', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1221', 'Sonipat (Sonepat)', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1222', 'Tenali', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1223', 'Raurkela Civil Township', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1224', 'Kollam (Quilon)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1225', 'Kumbakonam', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1226', 'Ingraj Bazar (English Bazar)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1227', 'Timkur', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1228', 'Amroha', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1229', 'Serampore', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1230', 'Chapra', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1231', 'Pali', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1232', 'Maunath Bhanjan', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1233', 'Adoni', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1234', 'Jaunpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1235', 'Tirunelveli', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1236', 'Bahraich', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1237', 'Gadag Betigeri', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1238', 'Proddatur', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1239', 'Chittoor', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1240', 'Barrackpur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1241', 'Bharuch (Broach)', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1242', 'Naihati', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1243', 'Shillong', 'IND', 'Meghalaya');
INSERT INTO `city` VALUES ('1244', 'Sambalpur', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1245', 'Junagadh', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1246', 'Rae Bareli', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1247', 'Rewa', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1248', 'Gurgaon', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1249', 'Khammam', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1250', 'Bulandshahr', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1251', 'Navsari', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1252', 'Malkajgiri', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1253', 'Midnapore (Medinipur)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1254', 'Miraj', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1255', 'Raj Nandgaon', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1256', 'Alandur', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1257', 'Puri', 'IND', 'Orissa');
INSERT INTO `city` VALUES ('1258', 'Navadwip', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1259', 'Sirsa', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1260', 'Korba', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1261', 'Faizabad', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1262', 'Etawah', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1263', 'Pathankot', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1264', 'Gandhinagar', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1265', 'Palghat (Palakkad)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1266', 'Veraval', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1267', 'Hoshiarpur', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1268', 'Ambala', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1269', 'Sitapur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1270', 'Bhiwani', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1271', 'Cuddapah', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1272', 'Bhimavaram', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1273', 'Krishnanagar', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1274', 'Chandannagar', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1275', 'Mandya', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1276', 'Dibrugarh', 'IND', 'Assam');
INSERT INTO `city` VALUES ('1277', 'Nandyal', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1278', 'Balurghat', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1279', 'Neyveli', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1280', 'Fatehpur', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1281', 'Mahbubnagar', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1282', 'Budaun', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1283', 'Porbandar', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1284', 'Silchar', 'IND', 'Assam');
INSERT INTO `city` VALUES ('1285', 'Berhampore (Baharampur)', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1286', 'Purnea (Purnia)', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1287', 'Bankura', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1288', 'Rajapalaiyam', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1289', 'Titagarh', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1290', 'Halisahar', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1291', 'Hathras', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1292', 'Bhir (Bid)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1293', 'Pallavaram', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1294', 'Anand', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1295', 'Mango', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1296', 'Santipur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1297', 'Bhind', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1298', 'Gondiya', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1299', 'Tiruvannamalai', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1300', 'Yeotmal (Yavatmal)', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1301', 'Kulti-Barakar', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1302', 'Moga', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1303', 'Shivapuri', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1304', 'Bidar', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1305', 'Guntakal', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1306', 'Unnao', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1307', 'Barasat', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1308', 'Tambaram', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1309', 'Abohar', 'IND', 'Punjab');
INSERT INTO `city` VALUES ('1310', 'Pilibhit', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1311', 'Valparai', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1312', 'Gonda', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1313', 'Surendranagar', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1314', 'Qutubullapur', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1315', 'Beawar', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1316', 'Hindupur', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1317', 'Gandhidham', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1318', 'Haldwani-cum-Kathgodam', 'IND', 'Uttaranchal');
INSERT INTO `city` VALUES ('1319', 'Tellicherry (Thalassery)', 'IND', 'Kerala');
INSERT INTO `city` VALUES ('1320', 'Wardha', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1321', 'Rishra', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1322', 'Bhuj', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1323', 'Modinagar', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1324', 'Gudivada', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1325', 'Basirhat', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1326', 'Uttarpara-Kotrung', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1327', 'Ongole', 'IND', 'Andhra Pradesh');
INSERT INTO `city` VALUES ('1328', 'North Barrackpur', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1329', 'Guna', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1330', 'Haldia', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1331', 'Habra', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1332', 'Kanchrapara', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1333', 'Tonk', 'IND', 'Rajasthan');
INSERT INTO `city` VALUES ('1334', 'Champdani', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1335', 'Orai', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1336', 'Pudukkottai', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1337', 'Sasaram', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1338', 'Hazaribag', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1339', 'Palayankottai', 'IND', 'Tamil Nadu');
INSERT INTO `city` VALUES ('1340', 'Banda', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1341', 'Godhra', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1342', 'Hospet', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1343', 'Ashoknagar-Kalyangarh', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1344', 'Achalpur', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1345', 'Patan', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1346', 'Mandasor', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1347', 'Damoh', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1348', 'Satara', 'IND', 'Maharashtra');
INSERT INTO `city` VALUES ('1349', 'Meerut Cantonment', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1350', 'Dehri', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1351', 'Delhi Cantonment', 'IND', 'Delhi');
INSERT INTO `city` VALUES ('1352', 'Chhindwara', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1353', 'Bansberia', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1354', 'Nagaon', 'IND', 'Assam');
INSERT INTO `city` VALUES ('1355', 'Kanpur Cantonment', 'IND', 'Uttar Pradesh');
INSERT INTO `city` VALUES ('1356', 'Vidisha', 'IND', 'Madhya Pradesh');
INSERT INTO `city` VALUES ('1357', 'Bettiah', 'IND', 'Bihar');
INSERT INTO `city` VALUES ('1358', 'Purulia', 'IND', 'Jharkhand');
INSERT INTO `city` VALUES ('1359', 'Hassan', 'IND', 'Karnataka');
INSERT INTO `city` VALUES ('1360', 'Ambala Sadar', 'IND', 'Haryana');
INSERT INTO `city` VALUES ('1361', 'Baidyabati', 'IND', 'West Bengali');
INSERT INTO `city` VALUES ('1362', 'Morvi', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1363', 'Raigarh', 'IND', 'Chhatisgarh');
INSERT INTO `city` VALUES ('1364', 'Vejalpur', 'IND', 'Gujarat');
INSERT INTO `city` VALUES ('1365', 'Baghdad', 'IRQ', 'Baghdad');
INSERT INTO `city` VALUES ('1366', 'Mosul', 'IRQ', 'Ninawa');
INSERT INTO `city` VALUES ('1367', 'Irbil', 'IRQ', 'Irbil');
INSERT INTO `city` VALUES ('1368', 'Kirkuk', 'IRQ', 'al-Tamim');
INSERT INTO `city` VALUES ('1369', 'Basra', 'IRQ', 'Basra');
INSERT INTO `city` VALUES ('1370', 'al-Sulaymaniya', 'IRQ', 'al-Sulaymaniya');
INSERT INTO `city` VALUES ('1371', 'al-Najaf', 'IRQ', 'al-Najaf');
INSERT INTO `city` VALUES ('1372', 'Karbala', 'IRQ', 'Karbala');
INSERT INTO `city` VALUES ('1373', 'al-Hilla', 'IRQ', 'Babil');
INSERT INTO `city` VALUES ('1374', 'al-Nasiriya', 'IRQ', 'DhiQar');
INSERT INTO `city` VALUES ('1375', 'al-Amara', 'IRQ', 'Maysan');
INSERT INTO `city` VALUES ('1376', 'al-Diwaniya', 'IRQ', 'al-Qadisiya');
INSERT INTO `city` VALUES ('1377', 'al-Ramadi', 'IRQ', 'al-Anbar');
INSERT INTO `city` VALUES ('1378', 'al-Kut', 'IRQ', 'Wasit');
INSERT INTO `city` VALUES ('1379', 'Baquba', 'IRQ', 'Diyala');
INSERT INTO `city` VALUES ('1380', 'Teheran', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1381', 'Mashhad', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1382', 'Esfahan', 'IRN', 'Esfahan');
INSERT INTO `city` VALUES ('1383', 'Tabriz', 'IRN', 'East Azerbaidzan');
INSERT INTO `city` VALUES ('1384', 'Shiraz', 'IRN', 'Fars');
INSERT INTO `city` VALUES ('1385', 'Karaj', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1386', 'Ahvaz', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1387', 'Qom', 'IRN', 'Qom');
INSERT INTO `city` VALUES ('1388', 'Kermanshah', 'IRN', 'Kermanshah');
INSERT INTO `city` VALUES ('1389', 'Urmia', 'IRN', 'West Azerbaidzan');
INSERT INTO `city` VALUES ('1390', 'Zahedan', 'IRN', 'Sistan va Baluchesta');
INSERT INTO `city` VALUES ('1391', 'Rasht', 'IRN', 'Gilan');
INSERT INTO `city` VALUES ('1392', 'Hamadan', 'IRN', 'Hamadan');
INSERT INTO `city` VALUES ('1393', 'Kerman', 'IRN', 'Kerman');
INSERT INTO `city` VALUES ('1394', 'Arak', 'IRN', 'Markazi');
INSERT INTO `city` VALUES ('1395', 'Ardebil', 'IRN', 'Ardebil');
INSERT INTO `city` VALUES ('1396', 'Yazd', 'IRN', 'Yazd');
INSERT INTO `city` VALUES ('1397', 'Qazvin', 'IRN', 'Qazvin');
INSERT INTO `city` VALUES ('1398', 'Zanjan', 'IRN', 'Zanjan');
INSERT INTO `city` VALUES ('1399', 'Sanandaj', 'IRN', 'Kordestan');
INSERT INTO `city` VALUES ('1400', 'Bandar-e-Abbas', 'IRN', 'Hormozgan');
INSERT INTO `city` VALUES ('1401', 'Khorramabad', 'IRN', 'Lorestan');
INSERT INTO `city` VALUES ('1402', 'Eslamshahr', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1403', 'Borujerd', 'IRN', 'Lorestan');
INSERT INTO `city` VALUES ('1404', 'Abadan', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1405', 'Dezful', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1406', 'Kashan', 'IRN', 'Esfahan');
INSERT INTO `city` VALUES ('1407', 'Sari', 'IRN', 'Mazandaran');
INSERT INTO `city` VALUES ('1408', 'Gorgan', 'IRN', 'Golestan');
INSERT INTO `city` VALUES ('1409', 'Najafabad', 'IRN', 'Esfahan');
INSERT INTO `city` VALUES ('1410', 'Sabzevar', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1411', 'Khomeynishahr', 'IRN', 'Esfahan');
INSERT INTO `city` VALUES ('1412', 'Amol', 'IRN', 'Mazandaran');
INSERT INTO `city` VALUES ('1413', 'Neyshabur', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1414', 'Babol', 'IRN', 'Mazandaran');
INSERT INTO `city` VALUES ('1415', 'Khoy', 'IRN', 'West Azerbaidzan');
INSERT INTO `city` VALUES ('1416', 'Malayer', 'IRN', 'Hamadan');
INSERT INTO `city` VALUES ('1417', 'Bushehr', 'IRN', 'Bushehr');
INSERT INTO `city` VALUES ('1418', 'Qaemshahr', 'IRN', 'Mazandaran');
INSERT INTO `city` VALUES ('1419', 'Qarchak', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1420', 'Qods', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1421', 'Sirjan', 'IRN', 'Kerman');
INSERT INTO `city` VALUES ('1422', 'Bojnurd', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1423', 'Maragheh', 'IRN', 'East Azerbaidzan');
INSERT INTO `city` VALUES ('1424', 'Birjand', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1425', 'Ilam', 'IRN', 'Ilam');
INSERT INTO `city` VALUES ('1426', 'Bukan', 'IRN', 'West Azerbaidzan');
INSERT INTO `city` VALUES ('1427', 'Masjed-e-Soleyman', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1428', 'Saqqez', 'IRN', 'Kordestan');
INSERT INTO `city` VALUES ('1429', 'Gonbad-e Qabus', 'IRN', 'Mazandaran');
INSERT INTO `city` VALUES ('1430', 'Saveh', 'IRN', 'Qom');
INSERT INTO `city` VALUES ('1431', 'Mahabad', 'IRN', 'West Azerbaidzan');
INSERT INTO `city` VALUES ('1432', 'Varamin', 'IRN', 'Teheran');
INSERT INTO `city` VALUES ('1433', 'Andimeshk', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1434', 'Khorramshahr', 'IRN', 'Khuzestan');
INSERT INTO `city` VALUES ('1435', 'Shahrud', 'IRN', 'Semnan');
INSERT INTO `city` VALUES ('1436', 'Marv Dasht', 'IRN', 'Fars');
INSERT INTO `city` VALUES ('1437', 'Zabol', 'IRN', 'Sistan va Baluchesta');
INSERT INTO `city` VALUES ('1438', 'Shahr-e Kord', 'IRN', 'Chaharmahal va Bakht');
INSERT INTO `city` VALUES ('1439', 'Bandar-e Anzali', 'IRN', 'Gilan');
INSERT INTO `city` VALUES ('1440', 'Rafsanjan', 'IRN', 'Kerman');
INSERT INTO `city` VALUES ('1441', 'Marand', 'IRN', 'East Azerbaidzan');
INSERT INTO `city` VALUES ('1442', 'Torbat-e Heydariyeh', 'IRN', 'Khorasan');
INSERT INTO `city` VALUES ('1443', 'Jahrom', 'IRN', 'Fars');
INSERT INTO `city` VALUES ('1444', 'Semnan', 'IRN', 'Semnan');
INSERT INTO `city` VALUES ('1445', 'Miandoab', 'IRN', 'West Azerbaidzan');
INSERT INTO `city` VALUES ('1446', 'Qomsheh', 'IRN', 'Esfahan');
INSERT INTO `city` VALUES ('1447', 'Dublin', 'IRL', 'Leinster');
INSERT INTO `city` VALUES ('1448', 'Cork', 'IRL', 'Munster');
INSERT INTO `city` VALUES ('1449', 'Reykjavík', 'ISL', 'Höfuðborgarsvæði');
INSERT INTO `city` VALUES ('1450', 'Jerusalem', 'ISR', 'Jerusalem');
INSERT INTO `city` VALUES ('1451', 'Tel Aviv-Jaffa', 'ISR', 'Tel Aviv');
INSERT INTO `city` VALUES ('1452', 'Haifa', 'ISR', 'Haifa');
INSERT INTO `city` VALUES ('1453', 'Rishon Le Ziyyon', 'ISR', 'Ha Merkaz');
INSERT INTO `city` VALUES ('1454', 'Beerseba', 'ISR', 'Ha Darom');
INSERT INTO `city` VALUES ('1455', 'Holon', 'ISR', 'Tel Aviv');
INSERT INTO `city` VALUES ('1456', 'Petah Tiqwa', 'ISR', 'Ha Merkaz');
INSERT INTO `city` VALUES ('1457', 'Ashdod', 'ISR', 'Ha Darom');
INSERT INTO `city` VALUES ('1458', 'Netanya', 'ISR', 'Ha Merkaz');
INSERT INTO `city` VALUES ('1459', 'Bat Yam', 'ISR', 'Tel Aviv');
INSERT INTO `city` VALUES ('1460', 'Bene Beraq', 'ISR', 'Tel Aviv');
INSERT INTO `city` VALUES ('1461', 'Ramat Gan', 'ISR', 'Tel Aviv');
INSERT INTO `city` VALUES ('1462', 'Ashqelon', 'ISR', 'Ha Darom');
INSERT INTO `city` VALUES ('1463', 'Rehovot', 'ISR', 'Ha Merkaz');
INSERT INTO `city` VALUES ('1464', 'Roma', 'ITA', 'Latium');
INSERT INTO `city` VALUES ('1465', 'Milano', 'ITA', 'Lombardia');
INSERT INTO `city` VALUES ('1466', 'Napoli', 'ITA', 'Campania');
INSERT INTO `city` VALUES ('1467', 'Torino', 'ITA', 'Piemonte');
INSERT INTO `city` VALUES ('1468', 'Palermo', 'ITA', 'Sisilia');
INSERT INTO `city` VALUES ('1469', 'Genova', 'ITA', 'Liguria');
INSERT INTO `city` VALUES ('1470', 'Bologna', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1471', 'Firenze', 'ITA', 'Toscana');
INSERT INTO `city` VALUES ('1472', 'Catania', 'ITA', 'Sisilia');
INSERT INTO `city` VALUES ('1473', 'Bari', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1474', 'Venezia', 'ITA', 'Veneto');
INSERT INTO `city` VALUES ('1475', 'Messina', 'ITA', 'Sisilia');
INSERT INTO `city` VALUES ('1476', 'Verona', 'ITA', 'Veneto');
INSERT INTO `city` VALUES ('1477', 'Trieste', 'ITA', 'Friuli-Venezia Giuli');
INSERT INTO `city` VALUES ('1478', 'Padova', 'ITA', 'Veneto');
INSERT INTO `city` VALUES ('1479', 'Taranto', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1480', 'Brescia', 'ITA', 'Lombardia');
INSERT INTO `city` VALUES ('1481', 'Reggio di Calabria', 'ITA', 'Calabria');
INSERT INTO `city` VALUES ('1482', 'Modena', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1483', 'Prato', 'ITA', 'Toscana');
INSERT INTO `city` VALUES ('1484', 'Parma', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1485', 'Cagliari', 'ITA', 'Sardinia');
INSERT INTO `city` VALUES ('1486', 'Livorno', 'ITA', 'Toscana');
INSERT INTO `city` VALUES ('1487', 'Perugia', 'ITA', 'Umbria');
INSERT INTO `city` VALUES ('1488', 'Foggia', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1489', 'Reggio nell´ Emilia', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1490', 'Salerno', 'ITA', 'Campania');
INSERT INTO `city` VALUES ('1491', 'Ravenna', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1492', 'Ferrara', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1493', 'Rimini', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1494', 'Syrakusa', 'ITA', 'Sisilia');
INSERT INTO `city` VALUES ('1495', 'Sassari', 'ITA', 'Sardinia');
INSERT INTO `city` VALUES ('1496', 'Monza', 'ITA', 'Lombardia');
INSERT INTO `city` VALUES ('1497', 'Bergamo', 'ITA', 'Lombardia');
INSERT INTO `city` VALUES ('1498', 'Pescara', 'ITA', 'Abruzzit');
INSERT INTO `city` VALUES ('1499', 'Latina', 'ITA', 'Latium');
INSERT INTO `city` VALUES ('1500', 'Vicenza', 'ITA', 'Veneto');
INSERT INTO `city` VALUES ('1501', 'Terni', 'ITA', 'Umbria');
INSERT INTO `city` VALUES ('1502', 'Forlì', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1503', 'Trento', 'ITA', 'Trentino-Alto Adige');
INSERT INTO `city` VALUES ('1504', 'Novara', 'ITA', 'Piemonte');
INSERT INTO `city` VALUES ('1505', 'Piacenza', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1506', 'Ancona', 'ITA', 'Marche');
INSERT INTO `city` VALUES ('1507', 'Lecce', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1508', 'Bolzano', 'ITA', 'Trentino-Alto Adige');
INSERT INTO `city` VALUES ('1509', 'Catanzaro', 'ITA', 'Calabria');
INSERT INTO `city` VALUES ('1510', 'La Spezia', 'ITA', 'Liguria');
INSERT INTO `city` VALUES ('1511', 'Udine', 'ITA', 'Friuli-Venezia Giuli');
INSERT INTO `city` VALUES ('1512', 'Torre del Greco', 'ITA', 'Campania');
INSERT INTO `city` VALUES ('1513', 'Andria', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1514', 'Brindisi', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1515', 'Giugliano in Campania', 'ITA', 'Campania');
INSERT INTO `city` VALUES ('1516', 'Pisa', 'ITA', 'Toscana');
INSERT INTO `city` VALUES ('1517', 'Barletta', 'ITA', 'Apulia');
INSERT INTO `city` VALUES ('1518', 'Arezzo', 'ITA', 'Toscana');
INSERT INTO `city` VALUES ('1519', 'Alessandria', 'ITA', 'Piemonte');
INSERT INTO `city` VALUES ('1520', 'Cesena', 'ITA', 'Emilia-Romagna');
INSERT INTO `city` VALUES ('1521', 'Pesaro', 'ITA', 'Marche');
INSERT INTO `city` VALUES ('1522', 'Dili', 'TMP', 'Dili');
INSERT INTO `city` VALUES ('1523', 'Wien', 'AUT', 'Wien');
INSERT INTO `city` VALUES ('1524', 'Graz', 'AUT', 'Steiermark');
INSERT INTO `city` VALUES ('1525', 'Linz', 'AUT', 'North Austria');
INSERT INTO `city` VALUES ('1526', 'Salzburg', 'AUT', 'Salzburg');
INSERT INTO `city` VALUES ('1527', 'Innsbruck', 'AUT', 'Tiroli');
INSERT INTO `city` VALUES ('1528', 'Klagenfurt', 'AUT', 'Kärnten');
INSERT INTO `city` VALUES ('1529', 'Spanish Town', 'JAM', 'St. Catherine');
INSERT INTO `city` VALUES ('1530', 'Kingston', 'JAM', 'St. Andrew');
INSERT INTO `city` VALUES ('1531', 'Portmore', 'JAM', 'St. Andrew');
INSERT INTO `city` VALUES ('1532', 'Tokyo', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1533', 'Jokohama [Yokohama]', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1534', 'Osaka', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1535', 'Nagoya', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1536', 'Sapporo', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1537', 'Kioto', 'JPN', 'Kyoto');
INSERT INTO `city` VALUES ('1538', 'Kobe', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1539', 'Fukuoka', 'JPN', 'Fukuoka');
INSERT INTO `city` VALUES ('1540', 'Kawasaki', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1541', 'Hiroshima', 'JPN', 'Hiroshima');
INSERT INTO `city` VALUES ('1542', 'Kitakyushu', 'JPN', 'Fukuoka');
INSERT INTO `city` VALUES ('1543', 'Sendai', 'JPN', 'Miyagi');
INSERT INTO `city` VALUES ('1544', 'Chiba', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1545', 'Sakai', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1546', 'Kumamoto', 'JPN', 'Kumamoto');
INSERT INTO `city` VALUES ('1547', 'Okayama', 'JPN', 'Okayama');
INSERT INTO `city` VALUES ('1548', 'Sagamihara', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1549', 'Hamamatsu', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1550', 'Kagoshima', 'JPN', 'Kagoshima');
INSERT INTO `city` VALUES ('1551', 'Funabashi', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1552', 'Higashiosaka', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1553', 'Hachioji', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1554', 'Niigata', 'JPN', 'Niigata');
INSERT INTO `city` VALUES ('1555', 'Amagasaki', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1556', 'Himeji', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1557', 'Shizuoka', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1558', 'Urawa', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1559', 'Matsuyama', 'JPN', 'Ehime');
INSERT INTO `city` VALUES ('1560', 'Matsudo', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1561', 'Kanazawa', 'JPN', 'Ishikawa');
INSERT INTO `city` VALUES ('1562', 'Kawaguchi', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1563', 'Ichikawa', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1564', 'Omiya', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1565', 'Utsunomiya', 'JPN', 'Tochigi');
INSERT INTO `city` VALUES ('1566', 'Oita', 'JPN', 'Oita');
INSERT INTO `city` VALUES ('1567', 'Nagasaki', 'JPN', 'Nagasaki');
INSERT INTO `city` VALUES ('1568', 'Yokosuka', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1569', 'Kurashiki', 'JPN', 'Okayama');
INSERT INTO `city` VALUES ('1570', 'Gifu', 'JPN', 'Gifu');
INSERT INTO `city` VALUES ('1571', 'Hirakata', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1572', 'Nishinomiya', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1573', 'Toyonaka', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1574', 'Wakayama', 'JPN', 'Wakayama');
INSERT INTO `city` VALUES ('1575', 'Fukuyama', 'JPN', 'Hiroshima');
INSERT INTO `city` VALUES ('1576', 'Fujisawa', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1577', 'Asahikawa', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1578', 'Machida', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1579', 'Nara', 'JPN', 'Nara');
INSERT INTO `city` VALUES ('1580', 'Takatsuki', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1581', 'Iwaki', 'JPN', 'Fukushima');
INSERT INTO `city` VALUES ('1582', 'Nagano', 'JPN', 'Nagano');
INSERT INTO `city` VALUES ('1583', 'Toyohashi', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1584', 'Toyota', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1585', 'Suita', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1586', 'Takamatsu', 'JPN', 'Kagawa');
INSERT INTO `city` VALUES ('1587', 'Koriyama', 'JPN', 'Fukushima');
INSERT INTO `city` VALUES ('1588', 'Okazaki', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1589', 'Kawagoe', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1590', 'Tokorozawa', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1591', 'Toyama', 'JPN', 'Toyama');
INSERT INTO `city` VALUES ('1592', 'Kochi', 'JPN', 'Kochi');
INSERT INTO `city` VALUES ('1593', 'Kashiwa', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1594', 'Akita', 'JPN', 'Akita');
INSERT INTO `city` VALUES ('1595', 'Miyazaki', 'JPN', 'Miyazaki');
INSERT INTO `city` VALUES ('1596', 'Koshigaya', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1597', 'Naha', 'JPN', 'Okinawa');
INSERT INTO `city` VALUES ('1598', 'Aomori', 'JPN', 'Aomori');
INSERT INTO `city` VALUES ('1599', 'Hakodate', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1600', 'Akashi', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1601', 'Yokkaichi', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1602', 'Fukushima', 'JPN', 'Fukushima');
INSERT INTO `city` VALUES ('1603', 'Morioka', 'JPN', 'Iwate');
INSERT INTO `city` VALUES ('1604', 'Maebashi', 'JPN', 'Gumma');
INSERT INTO `city` VALUES ('1605', 'Kasugai', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1606', 'Otsu', 'JPN', 'Shiga');
INSERT INTO `city` VALUES ('1607', 'Ichihara', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1608', 'Yao', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1609', 'Ichinomiya', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1610', 'Tokushima', 'JPN', 'Tokushima');
INSERT INTO `city` VALUES ('1611', 'Kakogawa', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1612', 'Ibaraki', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1613', 'Neyagawa', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1614', 'Shimonoseki', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1615', 'Yamagata', 'JPN', 'Yamagata');
INSERT INTO `city` VALUES ('1616', 'Fukui', 'JPN', 'Fukui');
INSERT INTO `city` VALUES ('1617', 'Hiratsuka', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1618', 'Mito', 'JPN', 'Ibaragi');
INSERT INTO `city` VALUES ('1619', 'Sasebo', 'JPN', 'Nagasaki');
INSERT INTO `city` VALUES ('1620', 'Hachinohe', 'JPN', 'Aomori');
INSERT INTO `city` VALUES ('1621', 'Takasaki', 'JPN', 'Gumma');
INSERT INTO `city` VALUES ('1622', 'Shimizu', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1623', 'Kurume', 'JPN', 'Fukuoka');
INSERT INTO `city` VALUES ('1624', 'Fuji', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1625', 'Soka', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1626', 'Fuchu', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1627', 'Chigasaki', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1628', 'Atsugi', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1629', 'Numazu', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1630', 'Ageo', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1631', 'Yamato', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1632', 'Matsumoto', 'JPN', 'Nagano');
INSERT INTO `city` VALUES ('1633', 'Kure', 'JPN', 'Hiroshima');
INSERT INTO `city` VALUES ('1634', 'Takarazuka', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1635', 'Kasukabe', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1636', 'Chofu', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1637', 'Odawara', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1638', 'Kofu', 'JPN', 'Yamanashi');
INSERT INTO `city` VALUES ('1639', 'Kushiro', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1640', 'Kishiwada', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1641', 'Hitachi', 'JPN', 'Ibaragi');
INSERT INTO `city` VALUES ('1642', 'Nagaoka', 'JPN', 'Niigata');
INSERT INTO `city` VALUES ('1643', 'Itami', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1644', 'Uji', 'JPN', 'Kyoto');
INSERT INTO `city` VALUES ('1645', 'Suzuka', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1646', 'Hirosaki', 'JPN', 'Aomori');
INSERT INTO `city` VALUES ('1647', 'Ube', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1648', 'Kodaira', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1649', 'Takaoka', 'JPN', 'Toyama');
INSERT INTO `city` VALUES ('1650', 'Obihiro', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1651', 'Tomakomai', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1652', 'Saga', 'JPN', 'Saga');
INSERT INTO `city` VALUES ('1653', 'Sakura', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1654', 'Kamakura', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1655', 'Mitaka', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1656', 'Izumi', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1657', 'Hino', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1658', 'Hadano', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1659', 'Ashikaga', 'JPN', 'Tochigi');
INSERT INTO `city` VALUES ('1660', 'Tsu', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1661', 'Sayama', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1662', 'Yachiyo', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1663', 'Tsukuba', 'JPN', 'Ibaragi');
INSERT INTO `city` VALUES ('1664', 'Tachikawa', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1665', 'Kumagaya', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1666', 'Moriguchi', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1667', 'Otaru', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1668', 'Anjo', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1669', 'Narashino', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1670', 'Oyama', 'JPN', 'Tochigi');
INSERT INTO `city` VALUES ('1671', 'Ogaki', 'JPN', 'Gifu');
INSERT INTO `city` VALUES ('1672', 'Matsue', 'JPN', 'Shimane');
INSERT INTO `city` VALUES ('1673', 'Kawanishi', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1674', 'Hitachinaka', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1675', 'Niiza', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1676', 'Nagareyama', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1677', 'Tottori', 'JPN', 'Tottori');
INSERT INTO `city` VALUES ('1678', 'Tama', 'JPN', 'Ibaragi');
INSERT INTO `city` VALUES ('1679', 'Iruma', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1680', 'Ota', 'JPN', 'Gumma');
INSERT INTO `city` VALUES ('1681', 'Omuta', 'JPN', 'Fukuoka');
INSERT INTO `city` VALUES ('1682', 'Komaki', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1683', 'Ome', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1684', 'Kadoma', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1685', 'Yamaguchi', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1686', 'Higashimurayama', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1687', 'Yonago', 'JPN', 'Tottori');
INSERT INTO `city` VALUES ('1688', 'Matsubara', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1689', 'Musashino', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1690', 'Tsuchiura', 'JPN', 'Ibaragi');
INSERT INTO `city` VALUES ('1691', 'Joetsu', 'JPN', 'Niigata');
INSERT INTO `city` VALUES ('1692', 'Miyakonojo', 'JPN', 'Miyazaki');
INSERT INTO `city` VALUES ('1693', 'Misato', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1694', 'Kakamigahara', 'JPN', 'Gifu');
INSERT INTO `city` VALUES ('1695', 'Daito', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1696', 'Seto', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1697', 'Kariya', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1698', 'Urayasu', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1699', 'Beppu', 'JPN', 'Oita');
INSERT INTO `city` VALUES ('1700', 'Niihama', 'JPN', 'Ehime');
INSERT INTO `city` VALUES ('1701', 'Minoo', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1702', 'Fujieda', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1703', 'Abiko', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1704', 'Nobeoka', 'JPN', 'Miyazaki');
INSERT INTO `city` VALUES ('1705', 'Tondabayashi', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1706', 'Ueda', 'JPN', 'Nagano');
INSERT INTO `city` VALUES ('1707', 'Kashihara', 'JPN', 'Nara');
INSERT INTO `city` VALUES ('1708', 'Matsusaka', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1709', 'Isesaki', 'JPN', 'Gumma');
INSERT INTO `city` VALUES ('1710', 'Zama', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1711', 'Kisarazu', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1712', 'Noda', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1713', 'Ishinomaki', 'JPN', 'Miyagi');
INSERT INTO `city` VALUES ('1714', 'Fujinomiya', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1715', 'Kawachinagano', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1716', 'Imabari', 'JPN', 'Ehime');
INSERT INTO `city` VALUES ('1717', 'Aizuwakamatsu', 'JPN', 'Fukushima');
INSERT INTO `city` VALUES ('1718', 'Higashihiroshima', 'JPN', 'Hiroshima');
INSERT INTO `city` VALUES ('1719', 'Habikino', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1720', 'Ebetsu', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1721', 'Hofu', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1722', 'Kiryu', 'JPN', 'Gumma');
INSERT INTO `city` VALUES ('1723', 'Okinawa', 'JPN', 'Okinawa');
INSERT INTO `city` VALUES ('1724', 'Yaizu', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1725', 'Toyokawa', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1726', 'Ebina', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1727', 'Asaka', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1728', 'Higashikurume', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1729', 'Ikoma', 'JPN', 'Nara');
INSERT INTO `city` VALUES ('1730', 'Kitami', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1731', 'Koganei', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1732', 'Iwatsuki', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1733', 'Mishima', 'JPN', 'Shizuoka');
INSERT INTO `city` VALUES ('1734', 'Handa', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1735', 'Muroran', 'JPN', 'Hokkaido');
INSERT INTO `city` VALUES ('1736', 'Komatsu', 'JPN', 'Ishikawa');
INSERT INTO `city` VALUES ('1737', 'Yatsushiro', 'JPN', 'Kumamoto');
INSERT INTO `city` VALUES ('1738', 'Iida', 'JPN', 'Nagano');
INSERT INTO `city` VALUES ('1739', 'Tokuyama', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1740', 'Kokubunji', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1741', 'Akishima', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1742', 'Iwakuni', 'JPN', 'Yamaguchi');
INSERT INTO `city` VALUES ('1743', 'Kusatsu', 'JPN', 'Shiga');
INSERT INTO `city` VALUES ('1744', 'Kuwana', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1745', 'Sanda', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1746', 'Hikone', 'JPN', 'Shiga');
INSERT INTO `city` VALUES ('1747', 'Toda', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1748', 'Tajimi', 'JPN', 'Gifu');
INSERT INTO `city` VALUES ('1749', 'Ikeda', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1750', 'Fukaya', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1751', 'Ise', 'JPN', 'Mie');
INSERT INTO `city` VALUES ('1752', 'Sakata', 'JPN', 'Yamagata');
INSERT INTO `city` VALUES ('1753', 'Kasuga', 'JPN', 'Fukuoka');
INSERT INTO `city` VALUES ('1754', 'Kamagaya', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1755', 'Tsuruoka', 'JPN', 'Yamagata');
INSERT INTO `city` VALUES ('1756', 'Hoya', 'JPN', 'Tokyo-to');
INSERT INTO `city` VALUES ('1757', 'Nishio', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1758', 'Tokai', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1759', 'Inazawa', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1760', 'Sakado', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1761', 'Isehara', 'JPN', 'Kanagawa');
INSERT INTO `city` VALUES ('1762', 'Takasago', 'JPN', 'Hyogo');
INSERT INTO `city` VALUES ('1763', 'Fujimi', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1764', 'Urasoe', 'JPN', 'Okinawa');
INSERT INTO `city` VALUES ('1765', 'Yonezawa', 'JPN', 'Yamagata');
INSERT INTO `city` VALUES ('1766', 'Konan', 'JPN', 'Aichi');
INSERT INTO `city` VALUES ('1767', 'Yamatokoriyama', 'JPN', 'Nara');
INSERT INTO `city` VALUES ('1768', 'Maizuru', 'JPN', 'Kyoto');
INSERT INTO `city` VALUES ('1769', 'Onomichi', 'JPN', 'Hiroshima');
INSERT INTO `city` VALUES ('1770', 'Higashimatsuyama', 'JPN', 'Saitama');
INSERT INTO `city` VALUES ('1771', 'Kimitsu', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1772', 'Isahaya', 'JPN', 'Nagasaki');
INSERT INTO `city` VALUES ('1773', 'Kanuma', 'JPN', 'Tochigi');
INSERT INTO `city` VALUES ('1774', 'Izumisano', 'JPN', 'Osaka');
INSERT INTO `city` VALUES ('1775', 'Kameoka', 'JPN', 'Kyoto');
INSERT INTO `city` VALUES ('1776', 'Mobara', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1777', 'Narita', 'JPN', 'Chiba');
INSERT INTO `city` VALUES ('1778', 'Kashiwazaki', 'JPN', 'Niigata');
INSERT INTO `city` VALUES ('1779', 'Tsuyama', 'JPN', 'Okayama');
INSERT INTO `city` VALUES ('1780', 'Sanaa', 'YEM', 'Sanaa');
INSERT INTO `city` VALUES ('1781', 'Aden', 'YEM', 'Aden');
INSERT INTO `city` VALUES ('1782', 'Taizz', 'YEM', 'Taizz');
INSERT INTO `city` VALUES ('1783', 'Hodeida', 'YEM', 'Hodeida');
INSERT INTO `city` VALUES ('1784', 'al-Mukalla', 'YEM', 'Hadramawt');
INSERT INTO `city` VALUES ('1785', 'Ibb', 'YEM', 'Ibb');
INSERT INTO `city` VALUES ('1786', 'Amman', 'JOR', 'Amman');
INSERT INTO `city` VALUES ('1787', 'al-Zarqa', 'JOR', 'al-Zarqa');
INSERT INTO `city` VALUES ('1788', 'Irbid', 'JOR', 'Irbid');
INSERT INTO `city` VALUES ('1789', 'al-Rusayfa', 'JOR', 'al-Zarqa');
INSERT INTO `city` VALUES ('1790', 'Wadi al-Sir', 'JOR', 'Amman');
INSERT INTO `city` VALUES ('1791', 'Flying Fish Cove', 'CXR', '–');
INSERT INTO `city` VALUES ('1792', 'Beograd', 'YUG', 'Central Serbia');
INSERT INTO `city` VALUES ('1793', 'Novi Sad', 'YUG', 'Vojvodina');
INSERT INTO `city` VALUES ('1794', 'Niš', 'YUG', 'Central Serbia');
INSERT INTO `city` VALUES ('1795', 'Priština', 'YUG', 'Kosovo and Metohija');
INSERT INTO `city` VALUES ('1796', 'Kragujevac', 'YUG', 'Central Serbia');
INSERT INTO `city` VALUES ('1797', 'Podgorica', 'YUG', 'Montenegro');
INSERT INTO `city` VALUES ('1798', 'Subotica', 'YUG', 'Vojvodina');
INSERT INTO `city` VALUES ('1799', 'Prizren', 'YUG', 'Kosovo and Metohija');
INSERT INTO `city` VALUES ('1800', 'Phnom Penh', 'KHM', 'Phnom Penh');
INSERT INTO `city` VALUES ('1801', 'Battambang', 'KHM', 'Battambang');
INSERT INTO `city` VALUES ('1802', 'Siem Reap', 'KHM', 'Siem Reap');
INSERT INTO `city` VALUES ('1803', 'Douala', 'CMR', 'Littoral');
INSERT INTO `city` VALUES ('1804', 'Yaoundé', 'CMR', 'Centre');
INSERT INTO `city` VALUES ('1805', 'Garoua', 'CMR', 'Nord');
INSERT INTO `city` VALUES ('1806', 'Maroua', 'CMR', 'Extrême-Nord');
INSERT INTO `city` VALUES ('1807', 'Bamenda', 'CMR', 'Nord-Ouest');
INSERT INTO `city` VALUES ('1808', 'Bafoussam', 'CMR', 'Ouest');
INSERT INTO `city` VALUES ('1809', 'Nkongsamba', 'CMR', 'Littoral');
INSERT INTO `city` VALUES ('1810', 'Montréal', 'CAN', 'Québec');
INSERT INTO `city` VALUES ('1811', 'Calgary', 'CAN', 'Alberta');
INSERT INTO `city` VALUES ('1812', 'Toronto', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1813', 'North York', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1814', 'Winnipeg', 'CAN', 'Manitoba');
INSERT INTO `city` VALUES ('1815', 'Edmonton', 'CAN', 'Alberta');
INSERT INTO `city` VALUES ('1816', 'Mississauga', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1817', 'Scarborough', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1818', 'Vancouver', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1819', 'Etobicoke', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1820', 'London', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1821', 'Hamilton', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1822', 'Ottawa', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1823', 'Laval', 'CAN', 'Québec');
INSERT INTO `city` VALUES ('1824', 'Surrey', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1825', 'Brampton', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1826', 'Windsor', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1827', 'Saskatoon', 'CAN', 'Saskatchewan');
INSERT INTO `city` VALUES ('1828', 'Kitchener', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1829', 'Markham', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1830', 'Regina', 'CAN', 'Saskatchewan');
INSERT INTO `city` VALUES ('1831', 'Burnaby', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1832', 'Québec', 'CAN', 'Québec');
INSERT INTO `city` VALUES ('1833', 'York', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1834', 'Richmond', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1835', 'Vaughan', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1836', 'Burlington', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1837', 'Oshawa', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1838', 'Oakville', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1839', 'Saint Catharines', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1840', 'Longueuil', 'CAN', 'Québec');
INSERT INTO `city` VALUES ('1841', 'Richmond Hill', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1842', 'Thunder Bay', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1843', 'Nepean', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1844', 'Cape Breton', 'CAN', 'Nova Scotia');
INSERT INTO `city` VALUES ('1845', 'East York', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1846', 'Halifax', 'CAN', 'Nova Scotia');
INSERT INTO `city` VALUES ('1847', 'Cambridge', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1848', 'Gloucester', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1849', 'Abbotsford', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1850', 'Guelph', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1851', 'Saint John´s', 'CAN', 'Newfoundland');
INSERT INTO `city` VALUES ('1852', 'Coquitlam', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1853', 'Saanich', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1854', 'Gatineau', 'CAN', 'Québec');
INSERT INTO `city` VALUES ('1855', 'Delta', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1856', 'Sudbury', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1857', 'Kelowna', 'CAN', 'British Colombia');
INSERT INTO `city` VALUES ('1858', 'Barrie', 'CAN', 'Ontario');
INSERT INTO `city` VALUES ('1859', 'Praia', 'CPV', 'São Tiago');
INSERT INTO `city` VALUES ('1860', 'Almaty', 'KAZ', 'Almaty Qalasy');
INSERT INTO `city` VALUES ('1861', 'Qaraghandy', 'KAZ', 'Qaraghandy');
INSERT INTO `city` VALUES ('1862', 'Shymkent', 'KAZ', 'South Kazakstan');
INSERT INTO `city` VALUES ('1863', 'Taraz', 'KAZ', 'Taraz');
INSERT INTO `city` VALUES ('1864', 'Astana', 'KAZ', 'Astana');
INSERT INTO `city` VALUES ('1865', 'Öskemen', 'KAZ', 'East Kazakstan');
INSERT INTO `city` VALUES ('1866', 'Pavlodar', 'KAZ', 'Pavlodar');
INSERT INTO `city` VALUES ('1867', 'Semey', 'KAZ', 'East Kazakstan');
INSERT INTO `city` VALUES ('1868', 'Aqtöbe', 'KAZ', 'Aqtöbe');
INSERT INTO `city` VALUES ('1869', 'Qostanay', 'KAZ', 'Qostanay');
INSERT INTO `city` VALUES ('1870', 'Petropavl', 'KAZ', 'North Kazakstan');
INSERT INTO `city` VALUES ('1871', 'Oral', 'KAZ', 'West Kazakstan');
INSERT INTO `city` VALUES ('1872', 'Temirtau', 'KAZ', 'Qaraghandy');
INSERT INTO `city` VALUES ('1873', 'Qyzylorda', 'KAZ', 'Qyzylorda');
INSERT INTO `city` VALUES ('1874', 'Aqtau', 'KAZ', 'Mangghystau');
INSERT INTO `city` VALUES ('1875', 'Atyrau', 'KAZ', 'Atyrau');
INSERT INTO `city` VALUES ('1876', 'Ekibastuz', 'KAZ', 'Pavlodar');
INSERT INTO `city` VALUES ('1877', 'Kökshetau', 'KAZ', 'North Kazakstan');
INSERT INTO `city` VALUES ('1878', 'Rudnyy', 'KAZ', 'Qostanay');
INSERT INTO `city` VALUES ('1879', 'Taldyqorghan', 'KAZ', 'Almaty');
INSERT INTO `city` VALUES ('1880', 'Zhezqazghan', 'KAZ', 'Qaraghandy');
INSERT INTO `city` VALUES ('1881', 'Nairobi', 'KEN', 'Nairobi');
INSERT INTO `city` VALUES ('1882', 'Mombasa', 'KEN', 'Coast');
INSERT INTO `city` VALUES ('1883', 'Kisumu', 'KEN', 'Nyanza');
INSERT INTO `city` VALUES ('1884', 'Nakuru', 'KEN', 'Rift Valley');
INSERT INTO `city` VALUES ('1885', 'Machakos', 'KEN', 'Eastern');
INSERT INTO `city` VALUES ('1886', 'Eldoret', 'KEN', 'Rift Valley');
INSERT INTO `city` VALUES ('1887', 'Meru', 'KEN', 'Eastern');
INSERT INTO `city` VALUES ('1888', 'Nyeri', 'KEN', 'Central');
INSERT INTO `city` VALUES ('1889', 'Bangui', 'CAF', 'Bangui');
INSERT INTO `city` VALUES ('1890', 'Shanghai', 'CHN', 'Shanghai');
INSERT INTO `city` VALUES ('1891', 'Peking', 'CHN', 'Peking');
INSERT INTO `city` VALUES ('1892', 'Chongqing', 'CHN', 'Chongqing');
INSERT INTO `city` VALUES ('1893', 'Tianjin', 'CHN', 'Tianjin');
INSERT INTO `city` VALUES ('1894', 'Wuhan', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('1895', 'Harbin', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1896', 'Shenyang', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1897', 'Kanton [Guangzhou]', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('1898', 'Chengdu', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('1899', 'Nanking [Nanjing]', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1900', 'Changchun', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('1901', 'Xi´an', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('1902', 'Dalian', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1903', 'Qingdao', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1904', 'Jinan', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1905', 'Hangzhou', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('1906', 'Zhengzhou', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1907', 'Shijiazhuang', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1908', 'Taiyuan', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('1909', 'Kunming', 'CHN', 'Yunnan');
INSERT INTO `city` VALUES ('1910', 'Changsha', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('1911', 'Nanchang', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('1912', 'Fuzhou', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('1913', 'Lanzhou', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('1914', 'Guiyang', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('1915', 'Ningbo', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('1916', 'Hefei', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('1917', 'Urumtši [Ürümqi]', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('1918', 'Anshan', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1919', 'Fushun', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1920', 'Nanning', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('1921', 'Zibo', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1922', 'Qiqihar', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1923', 'Jilin', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('1924', 'Tangshan', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1925', 'Baotou', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('1926', 'Shenzhen', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('1927', 'Hohhot', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('1928', 'Handan', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1929', 'Wuxi', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1930', 'Xuzhou', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1931', 'Datong', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('1932', 'Yichun', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1933', 'Benxi', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1934', 'Luoyang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1935', 'Suzhou', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1936', 'Xining', 'CHN', 'Qinghai');
INSERT INTO `city` VALUES ('1937', 'Huainan', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('1938', 'Jixi', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1939', 'Daqing', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1940', 'Fuxin', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1941', 'Amoy [Xiamen]', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('1942', 'Liuzhou', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('1943', 'Shantou', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('1944', 'Jinzhou', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1945', 'Mudanjiang', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1946', 'Yinchuan', 'CHN', 'Ningxia');
INSERT INTO `city` VALUES ('1947', 'Changzhou', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1948', 'Zhangjiakou', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1949', 'Dandong', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1950', 'Hegang', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1951', 'Kaifeng', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1952', 'Jiamusi', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1953', 'Liaoyang', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1954', 'Hengyang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('1955', 'Baoding', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1956', 'Hunjiang', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('1957', 'Xinxiang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1958', 'Huangshi', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('1959', 'Haikou', 'CHN', 'Hainan');
INSERT INTO `city` VALUES ('1960', 'Yantai', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1961', 'Bengbu', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('1962', 'Xiangtan', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('1963', 'Weifang', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1964', 'Wuhu', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('1965', 'Pingxiang', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('1966', 'Yingkou', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1967', 'Anyang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1968', 'Panzhihua', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('1969', 'Pingdingshan', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1970', 'Xiangfan', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('1971', 'Zhuzhou', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('1972', 'Jiaozuo', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('1973', 'Wenzhou', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('1974', 'Zhangjiang', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('1975', 'Zigong', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('1976', 'Shuangyashan', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('1977', 'Zaozhuang', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1978', 'Yakeshi', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('1979', 'Yichang', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('1980', 'Zhenjiang', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1981', 'Huaibei', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('1982', 'Qinhuangdao', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('1983', 'Guilin', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('1984', 'Liupanshui', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('1985', 'Panjin', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1986', 'Yangquan', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('1987', 'Jinxi', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('1988', 'Liaoyuan', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('1989', 'Lianyungang', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1990', 'Xianyang', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('1991', 'Tai´an', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1992', 'Chifeng', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('1993', 'Shaoguan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('1994', 'Nantong', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('1995', 'Leshan', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('1996', 'Baoji', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('1997', 'Linyi', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('1998', 'Tonghua', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('1999', 'Siping', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2000', 'Changzhi', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2001', 'Tengzhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2002', 'Chaozhou', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2003', 'Yangzhou', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2004', 'Dongwan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2005', 'Ma´anshan', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2006', 'Foshan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2007', 'Yueyang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2008', 'Xingtai', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2009', 'Changde', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2010', 'Shihezi', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2011', 'Yancheng', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2012', 'Jiujiang', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2013', 'Dongying', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2014', 'Shashi', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2015', 'Xintai', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2016', 'Jingdezhen', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2017', 'Tongchuan', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('2018', 'Zhongshan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2019', 'Shiyan', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2020', 'Tieli', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2021', 'Jining', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2022', 'Wuhai', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2023', 'Mianyang', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2024', 'Luzhou', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2025', 'Zunyi', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('2026', 'Shizuishan', 'CHN', 'Ningxia');
INSERT INTO `city` VALUES ('2027', 'Neijiang', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2028', 'Tongliao', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2029', 'Tieling', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2030', 'Wafangdian', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2031', 'Anqing', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2032', 'Shaoyang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2033', 'Laiwu', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2034', 'Chengde', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2035', 'Tianshui', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2036', 'Nanyang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2037', 'Cangzhou', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2038', 'Yibin', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2039', 'Huaiyin', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2040', 'Dunhua', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2041', 'Yanji', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2042', 'Jiangmen', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2043', 'Tongling', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2044', 'Suihua', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2045', 'Gongziling', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2046', 'Xiantao', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2047', 'Chaoyang', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2048', 'Ganzhou', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2049', 'Huzhou', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2050', 'Baicheng', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2051', 'Shangzi', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2052', 'Yangjiang', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2053', 'Qitaihe', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2054', 'Gejiu', 'CHN', 'Yunnan');
INSERT INTO `city` VALUES ('2055', 'Jiangyin', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2056', 'Hebi', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2057', 'Jiaxing', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2058', 'Wuzhou', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2059', 'Meihekou', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2060', 'Xuchang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2061', 'Liaocheng', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2062', 'Haicheng', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2063', 'Qianjiang', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2064', 'Baiyin', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2065', 'Bei´an', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2066', 'Yixing', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2067', 'Laizhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2068', 'Qaramay', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2069', 'Acheng', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2070', 'Dezhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2071', 'Nanping', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2072', 'Zhaoqing', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2073', 'Beipiao', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2074', 'Fengcheng', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2075', 'Fuyu', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2076', 'Xinyang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2077', 'Dongtai', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2078', 'Yuci', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2079', 'Honghu', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2080', 'Ezhou', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2081', 'Heze', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2082', 'Daxian', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2083', 'Linfen', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2084', 'Tianmen', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2085', 'Yiyang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2086', 'Quanzhou', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2087', 'Rizhao', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2088', 'Deyang', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2089', 'Guangyuan', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2090', 'Changshu', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2091', 'Zhangzhou', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2092', 'Hailar', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2093', 'Nanchong', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2094', 'Jiutai', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2095', 'Zhaodong', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2096', 'Shaoxing', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2097', 'Fuyang', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2098', 'Maoming', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2099', 'Qujing', 'CHN', 'Yunnan');
INSERT INTO `city` VALUES ('2100', 'Ghulja', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2101', 'Jiaohe', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2102', 'Puyang', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2103', 'Huadian', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2104', 'Jiangyou', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2105', 'Qashqar', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2106', 'Anshun', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('2107', 'Fuling', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2108', 'Xinyu', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2109', 'Hanzhong', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('2110', 'Danyang', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2111', 'Chenzhou', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2112', 'Xiaogan', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2113', 'Shangqiu', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2114', 'Zhuhai', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2115', 'Qingyuan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2116', 'Aqsu', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2117', 'Jining', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2118', 'Xiaoshan', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2119', 'Zaoyang', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2120', 'Xinghua', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2121', 'Hami', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2122', 'Huizhou', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2123', 'Jinmen', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2124', 'Sanming', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2125', 'Ulanhot', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2126', 'Korla', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2127', 'Wanxian', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2128', 'Rui´an', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2129', 'Zhoushan', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2130', 'Liangcheng', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2131', 'Jiaozhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2132', 'Taizhou', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2133', 'Suzhou', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2134', 'Yichun', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2135', 'Taonan', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2136', 'Pingdu', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2137', 'Ji´an', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2138', 'Longkou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2139', 'Langfang', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2140', 'Zhoukou', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2141', 'Suining', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2142', 'Yulin', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2143', 'Jinhua', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2144', 'Liu´an', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2145', 'Shuangcheng', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2146', 'Suizhou', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2147', 'Ankang', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('2148', 'Weinan', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('2149', 'Longjing', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2150', 'Da´an', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2151', 'Lengshuijiang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2152', 'Laiyang', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2153', 'Xianning', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2154', 'Dali', 'CHN', 'Yunnan');
INSERT INTO `city` VALUES ('2155', 'Anda', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2156', 'Jincheng', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2157', 'Longyan', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2158', 'Xichang', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2159', 'Wendeng', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2160', 'Hailun', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2161', 'Binzhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2162', 'Linhe', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2163', 'Wuwei', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2164', 'Duyun', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('2165', 'Mishan', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2166', 'Shangrao', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2167', 'Changji', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2168', 'Meixian', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2169', 'Yushu', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2170', 'Tiefa', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2171', 'Huai´an', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2172', 'Leiyang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2173', 'Zalantun', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2174', 'Weihai', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2175', 'Loudi', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2176', 'Qingzhou', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2177', 'Qidong', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2178', 'Huaihua', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2179', 'Luohe', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2180', 'Chuzhou', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2181', 'Kaiyuan', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2182', 'Linqing', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2183', 'Chaohu', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2184', 'Laohekou', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2185', 'Dujiangyan', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2186', 'Zhumadian', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2187', 'Linchuan', 'CHN', 'Jiangxi');
INSERT INTO `city` VALUES ('2188', 'Jiaonan', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2189', 'Sanmenxia', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2190', 'Heyuan', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2191', 'Manzhouli', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2192', 'Lhasa', 'CHN', 'Tibet');
INSERT INTO `city` VALUES ('2193', 'Lianyuan', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2194', 'Kuytun', 'CHN', 'Xinxiang');
INSERT INTO `city` VALUES ('2195', 'Puqi', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2196', 'Hongjiang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2197', 'Qinzhou', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2198', 'Renqiu', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2199', 'Yuyao', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2200', 'Guigang', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2201', 'Kaili', 'CHN', 'Guizhou');
INSERT INTO `city` VALUES ('2202', 'Yan´an', 'CHN', 'Shaanxi');
INSERT INTO `city` VALUES ('2203', 'Beihai', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2204', 'Xuangzhou', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2205', 'Quzhou', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2206', 'Yong´an', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2207', 'Zixing', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2208', 'Liyang', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2209', 'Yizheng', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2210', 'Yumen', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2211', 'Liling', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2212', 'Yuncheng', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2213', 'Shanwei', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2214', 'Cixi', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2215', 'Yuanjiang', 'CHN', 'Hunan');
INSERT INTO `city` VALUES ('2216', 'Bozhou', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2217', 'Jinchang', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2218', 'Fu´an', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2219', 'Suqian', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2220', 'Shishou', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2221', 'Hengshui', 'CHN', 'Hebei');
INSERT INTO `city` VALUES ('2222', 'Danjiangkou', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2223', 'Fujin', 'CHN', 'Heilongjiang');
INSERT INTO `city` VALUES ('2224', 'Sanya', 'CHN', 'Hainan');
INSERT INTO `city` VALUES ('2225', 'Guangshui', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2226', 'Huangshan', 'CHN', 'Anhui');
INSERT INTO `city` VALUES ('2227', 'Xingcheng', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2228', 'Zhucheng', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2229', 'Kunshan', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2230', 'Haining', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2231', 'Pingliang', 'CHN', 'Gansu');
INSERT INTO `city` VALUES ('2232', 'Fuqing', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2233', 'Xinzhou', 'CHN', 'Shanxi');
INSERT INTO `city` VALUES ('2234', 'Jieyang', 'CHN', 'Guangdong');
INSERT INTO `city` VALUES ('2235', 'Zhangjiagang', 'CHN', 'Jiangsu');
INSERT INTO `city` VALUES ('2236', 'Tong Xian', 'CHN', 'Peking');
INSERT INTO `city` VALUES ('2237', 'Ya´an', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2238', 'Jinzhou', 'CHN', 'Liaoning');
INSERT INTO `city` VALUES ('2239', 'Emeishan', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2240', 'Enshi', 'CHN', 'Hubei');
INSERT INTO `city` VALUES ('2241', 'Bose', 'CHN', 'Guangxi');
INSERT INTO `city` VALUES ('2242', 'Yuzhou', 'CHN', 'Henan');
INSERT INTO `city` VALUES ('2243', 'Kaiyuan', 'CHN', 'Yunnan');
INSERT INTO `city` VALUES ('2244', 'Tumen', 'CHN', 'Jilin');
INSERT INTO `city` VALUES ('2245', 'Putian', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2246', 'Linhai', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2247', 'Xilin Hot', 'CHN', 'Inner Mongolia');
INSERT INTO `city` VALUES ('2248', 'Shaowu', 'CHN', 'Fujian');
INSERT INTO `city` VALUES ('2249', 'Junan', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2250', 'Huaying', 'CHN', 'Sichuan');
INSERT INTO `city` VALUES ('2251', 'Pingyi', 'CHN', 'Shandong');
INSERT INTO `city` VALUES ('2252', 'Huangyan', 'CHN', 'Zhejiang');
INSERT INTO `city` VALUES ('2253', 'Bishkek', 'KGZ', 'Bishkek shaary');
INSERT INTO `city` VALUES ('2254', 'Osh', 'KGZ', 'Osh');
INSERT INTO `city` VALUES ('2255', 'Bikenibeu', 'KIR', 'South Tarawa');
INSERT INTO `city` VALUES ('2256', 'Bairiki', 'KIR', 'South Tarawa');
INSERT INTO `city` VALUES ('2257', 'Santafé de Bogotá', 'COL', 'Santafé de Bogotá');
INSERT INTO `city` VALUES ('2258', 'Cali', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2259', 'Medellín', 'COL', 'Antioquia');
INSERT INTO `city` VALUES ('2260', 'Barranquilla', 'COL', 'Atlántico');
INSERT INTO `city` VALUES ('2261', 'Cartagena', 'COL', 'Bolívar');
INSERT INTO `city` VALUES ('2262', 'Cúcuta', 'COL', 'Norte de Santander');
INSERT INTO `city` VALUES ('2263', 'Bucaramanga', 'COL', 'Santander');
INSERT INTO `city` VALUES ('2264', 'Ibagué', 'COL', 'Tolima');
INSERT INTO `city` VALUES ('2265', 'Pereira', 'COL', 'Risaralda');
INSERT INTO `city` VALUES ('2266', 'Santa Marta', 'COL', 'Magdalena');
INSERT INTO `city` VALUES ('2267', 'Manizales', 'COL', 'Caldas');
INSERT INTO `city` VALUES ('2268', 'Bello', 'COL', 'Antioquia');
INSERT INTO `city` VALUES ('2269', 'Pasto', 'COL', 'Nariño');
INSERT INTO `city` VALUES ('2270', 'Neiva', 'COL', 'Huila');
INSERT INTO `city` VALUES ('2271', 'Soledad', 'COL', 'Atlántico');
INSERT INTO `city` VALUES ('2272', 'Armenia', 'COL', 'Quindío');
INSERT INTO `city` VALUES ('2273', 'Villavicencio', 'COL', 'Meta');
INSERT INTO `city` VALUES ('2274', 'Soacha', 'COL', 'Cundinamarca');
INSERT INTO `city` VALUES ('2275', 'Valledupar', 'COL', 'Cesar');
INSERT INTO `city` VALUES ('2276', 'Montería', 'COL', 'Córdoba');
INSERT INTO `city` VALUES ('2277', 'Itagüí', 'COL', 'Antioquia');
INSERT INTO `city` VALUES ('2278', 'Palmira', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2279', 'Buenaventura', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2280', 'Floridablanca', 'COL', 'Santander');
INSERT INTO `city` VALUES ('2281', 'Sincelejo', 'COL', 'Sucre');
INSERT INTO `city` VALUES ('2282', 'Popayán', 'COL', 'Cauca');
INSERT INTO `city` VALUES ('2283', 'Barrancabermeja', 'COL', 'Santander');
INSERT INTO `city` VALUES ('2284', 'Dos Quebradas', 'COL', 'Risaralda');
INSERT INTO `city` VALUES ('2285', 'Tuluá', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2286', 'Envigado', 'COL', 'Antioquia');
INSERT INTO `city` VALUES ('2287', 'Cartago', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2288', 'Girardot', 'COL', 'Cundinamarca');
INSERT INTO `city` VALUES ('2289', 'Buga', 'COL', 'Valle');
INSERT INTO `city` VALUES ('2290', 'Tunja', 'COL', 'Boyacá');
INSERT INTO `city` VALUES ('2291', 'Florencia', 'COL', 'Caquetá');
INSERT INTO `city` VALUES ('2292', 'Maicao', 'COL', 'La Guajira');
INSERT INTO `city` VALUES ('2293', 'Sogamoso', 'COL', 'Boyacá');
INSERT INTO `city` VALUES ('2294', 'Giron', 'COL', 'Santander');
INSERT INTO `city` VALUES ('2295', 'Moroni', 'COM', 'Njazidja');
INSERT INTO `city` VALUES ('2296', 'Brazzaville', 'COG', 'Brazzaville');
INSERT INTO `city` VALUES ('2297', 'Pointe-Noire', 'COG', 'Kouilou');
INSERT INTO `city` VALUES ('2298', 'Kinshasa', 'COD', 'Kinshasa');
INSERT INTO `city` VALUES ('2299', 'Lubumbashi', 'COD', 'Shaba');
INSERT INTO `city` VALUES ('2300', 'Mbuji-Mayi', 'COD', 'East Kasai');
INSERT INTO `city` VALUES ('2301', 'Kolwezi', 'COD', 'Shaba');
INSERT INTO `city` VALUES ('2302', 'Kisangani', 'COD', 'Haute-Zaïre');
INSERT INTO `city` VALUES ('2303', 'Kananga', 'COD', 'West Kasai');
INSERT INTO `city` VALUES ('2304', 'Likasi', 'COD', 'Shaba');
INSERT INTO `city` VALUES ('2305', 'Bukavu', 'COD', 'South Kivu');
INSERT INTO `city` VALUES ('2306', 'Kikwit', 'COD', 'Bandundu');
INSERT INTO `city` VALUES ('2307', 'Tshikapa', 'COD', 'West Kasai');
INSERT INTO `city` VALUES ('2308', 'Matadi', 'COD', 'Bas-Zaïre');
INSERT INTO `city` VALUES ('2309', 'Mbandaka', 'COD', 'Equateur');
INSERT INTO `city` VALUES ('2310', 'Mwene-Ditu', 'COD', 'East Kasai');
INSERT INTO `city` VALUES ('2311', 'Boma', 'COD', 'Bas-Zaïre');
INSERT INTO `city` VALUES ('2312', 'Uvira', 'COD', 'South Kivu');
INSERT INTO `city` VALUES ('2313', 'Butembo', 'COD', 'North Kivu');
INSERT INTO `city` VALUES ('2314', 'Goma', 'COD', 'North Kivu');
INSERT INTO `city` VALUES ('2315', 'Kalemie', 'COD', 'Shaba');
INSERT INTO `city` VALUES ('2316', 'Bantam', 'CCK', 'Home Island');
INSERT INTO `city` VALUES ('2317', 'West Island', 'CCK', 'West Island');
INSERT INTO `city` VALUES ('2318', 'Pyongyang', 'PRK', 'Pyongyang-si');
INSERT INTO `city` VALUES ('2319', 'Hamhung', 'PRK', 'Hamgyong N');
INSERT INTO `city` VALUES ('2320', 'Chongjin', 'PRK', 'Hamgyong P');
INSERT INTO `city` VALUES ('2321', 'Nampo', 'PRK', 'Nampo-si');
INSERT INTO `city` VALUES ('2322', 'Sinuiju', 'PRK', 'Pyongan P');
INSERT INTO `city` VALUES ('2323', 'Wonsan', 'PRK', 'Kangwon');
INSERT INTO `city` VALUES ('2324', 'Phyongsong', 'PRK', 'Pyongan N');
INSERT INTO `city` VALUES ('2325', 'Sariwon', 'PRK', 'Hwanghae P');
INSERT INTO `city` VALUES ('2326', 'Haeju', 'PRK', 'Hwanghae N');
INSERT INTO `city` VALUES ('2327', 'Kanggye', 'PRK', 'Chagang');
INSERT INTO `city` VALUES ('2328', 'Kimchaek', 'PRK', 'Hamgyong P');
INSERT INTO `city` VALUES ('2329', 'Hyesan', 'PRK', 'Yanggang');
INSERT INTO `city` VALUES ('2330', 'Kaesong', 'PRK', 'Kaesong-si');
INSERT INTO `city` VALUES ('2331', 'Seoul', 'KOR', 'Seoul');
INSERT INTO `city` VALUES ('2332', 'Pusan', 'KOR', 'Pusan');
INSERT INTO `city` VALUES ('2333', 'Inchon', 'KOR', 'Inchon');
INSERT INTO `city` VALUES ('2334', 'Taegu', 'KOR', 'Taegu');
INSERT INTO `city` VALUES ('2335', 'Taejon', 'KOR', 'Taejon');
INSERT INTO `city` VALUES ('2336', 'Kwangju', 'KOR', 'Kwangju');
INSERT INTO `city` VALUES ('2337', 'Ulsan', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2338', 'Songnam', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2339', 'Puchon', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2340', 'Suwon', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2341', 'Anyang', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2342', 'Chonju', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2343', 'Chongju', 'KOR', 'Chungchongbuk');
INSERT INTO `city` VALUES ('2344', 'Koyang', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2345', 'Ansan', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2346', 'Pohang', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2347', 'Chang-won', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2348', 'Masan', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2349', 'Kwangmyong', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2350', 'Chonan', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2351', 'Chinju', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2352', 'Iksan', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2353', 'Pyongtaek', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2354', 'Kumi', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2355', 'Uijongbu', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2356', 'Kyongju', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2357', 'Kunsan', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2358', 'Cheju', 'KOR', 'Cheju');
INSERT INTO `city` VALUES ('2359', 'Kimhae', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2360', 'Sunchon', 'KOR', 'Chollanam');
INSERT INTO `city` VALUES ('2361', 'Mokpo', 'KOR', 'Chollanam');
INSERT INTO `city` VALUES ('2362', 'Yong-in', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2363', 'Wonju', 'KOR', 'Kang-won');
INSERT INTO `city` VALUES ('2364', 'Kunpo', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2365', 'Chunchon', 'KOR', 'Kang-won');
INSERT INTO `city` VALUES ('2366', 'Namyangju', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2367', 'Kangnung', 'KOR', 'Kang-won');
INSERT INTO `city` VALUES ('2368', 'Chungju', 'KOR', 'Chungchongbuk');
INSERT INTO `city` VALUES ('2369', 'Andong', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2370', 'Yosu', 'KOR', 'Chollanam');
INSERT INTO `city` VALUES ('2371', 'Kyongsan', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2372', 'Paju', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2373', 'Yangsan', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2374', 'Ichon', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2375', 'Asan', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2376', 'Koje', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2377', 'Kimchon', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2378', 'Nonsan', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2379', 'Kuri', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2380', 'Chong-up', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2381', 'Chechon', 'KOR', 'Chungchongbuk');
INSERT INTO `city` VALUES ('2382', 'Sosan', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2383', 'Shihung', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2384', 'Tong-yong', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2385', 'Kongju', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2386', 'Yongju', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2387', 'Chinhae', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2388', 'Sangju', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2389', 'Poryong', 'KOR', 'Chungchongnam');
INSERT INTO `city` VALUES ('2390', 'Kwang-yang', 'KOR', 'Chollanam');
INSERT INTO `city` VALUES ('2391', 'Miryang', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2392', 'Hanam', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2393', 'Kimje', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2394', 'Yongchon', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2395', 'Sachon', 'KOR', 'Kyongsangnam');
INSERT INTO `city` VALUES ('2396', 'Uiwang', 'KOR', 'Kyonggi');
INSERT INTO `city` VALUES ('2397', 'Naju', 'KOR', 'Chollanam');
INSERT INTO `city` VALUES ('2398', 'Namwon', 'KOR', 'Chollabuk');
INSERT INTO `city` VALUES ('2399', 'Tonghae', 'KOR', 'Kang-won');
INSERT INTO `city` VALUES ('2400', 'Mun-gyong', 'KOR', 'Kyongsangbuk');
INSERT INTO `city` VALUES ('2401', 'Athenai', 'GRC', 'Attika');
INSERT INTO `city` VALUES ('2402', 'Thessaloniki', 'GRC', 'Central Macedonia');
INSERT INTO `city` VALUES ('2403', 'Pireus', 'GRC', 'Attika');
INSERT INTO `city` VALUES ('2404', 'Patras', 'GRC', 'West Greece');
INSERT INTO `city` VALUES ('2405', 'Peristerion', 'GRC', 'Attika');
INSERT INTO `city` VALUES ('2406', 'Herakleion', 'GRC', 'Crete');
INSERT INTO `city` VALUES ('2407', 'Kallithea', 'GRC', 'Attika');
INSERT INTO `city` VALUES ('2408', 'Larisa', 'GRC', 'Thessalia');
INSERT INTO `city` VALUES ('2409', 'Zagreb', 'HRV', 'Grad Zagreb');
INSERT INTO `city` VALUES ('2410', 'Split', 'HRV', 'Split-Dalmatia');
INSERT INTO `city` VALUES ('2411', 'Rijeka', 'HRV', 'Primorje-Gorski Kota');
INSERT INTO `city` VALUES ('2412', 'Osijek', 'HRV', 'Osijek-Baranja');
INSERT INTO `city` VALUES ('2413', 'La Habana', 'CUB', 'La Habana');
INSERT INTO `city` VALUES ('2414', 'Santiago de Cuba', 'CUB', 'Santiago de Cuba');
INSERT INTO `city` VALUES ('2415', 'Camagüey', 'CUB', 'Camagüey');
INSERT INTO `city` VALUES ('2416', 'Holguín', 'CUB', 'Holguín');
INSERT INTO `city` VALUES ('2417', 'Santa Clara', 'CUB', 'Villa Clara');
INSERT INTO `city` VALUES ('2418', 'Guantánamo', 'CUB', 'Guantánamo');
INSERT INTO `city` VALUES ('2419', 'Pinar del Río', 'CUB', 'Pinar del Río');
INSERT INTO `city` VALUES ('2420', 'Bayamo', 'CUB', 'Granma');
INSERT INTO `city` VALUES ('2421', 'Cienfuegos', 'CUB', 'Cienfuegos');
INSERT INTO `city` VALUES ('2422', 'Victoria de las Tunas', 'CUB', 'Las Tunas');
INSERT INTO `city` VALUES ('2423', 'Matanzas', 'CUB', 'Matanzas');
INSERT INTO `city` VALUES ('2424', 'Manzanillo', 'CUB', 'Granma');
INSERT INTO `city` VALUES ('2425', 'Sancti-Spíritus', 'CUB', 'Sancti-Spíritus');
INSERT INTO `city` VALUES ('2426', 'Ciego de Ávila', 'CUB', 'Ciego de Ávila');
INSERT INTO `city` VALUES ('2427', 'al-Salimiya', 'KWT', 'Hawalli');
INSERT INTO `city` VALUES ('2428', 'Jalib al-Shuyukh', 'KWT', 'Hawalli');
INSERT INTO `city` VALUES ('2429', 'Kuwait', 'KWT', 'al-Asima');
INSERT INTO `city` VALUES ('2430', 'Nicosia', 'CYP', 'Nicosia');
INSERT INTO `city` VALUES ('2431', 'Limassol', 'CYP', 'Limassol');
INSERT INTO `city` VALUES ('2432', 'Vientiane', 'LAO', 'Viangchan');
INSERT INTO `city` VALUES ('2433', 'Savannakhet', 'LAO', 'Savannakhet');
INSERT INTO `city` VALUES ('2434', 'Riga', 'LVA', 'Riika');
INSERT INTO `city` VALUES ('2435', 'Daugavpils', 'LVA', 'Daugavpils');
INSERT INTO `city` VALUES ('2436', 'Liepaja', 'LVA', 'Liepaja');
INSERT INTO `city` VALUES ('2437', 'Maseru', 'LSO', 'Maseru');
INSERT INTO `city` VALUES ('2438', 'Beirut', 'LBN', 'Beirut');
INSERT INTO `city` VALUES ('2439', 'Tripoli', 'LBN', 'al-Shamal');
INSERT INTO `city` VALUES ('2440', 'Monrovia', 'LBR', 'Montserrado');
INSERT INTO `city` VALUES ('2441', 'Tripoli', 'LBY', 'Tripoli');
INSERT INTO `city` VALUES ('2442', 'Bengasi', 'LBY', 'Bengasi');
INSERT INTO `city` VALUES ('2443', 'Misrata', 'LBY', 'Misrata');
INSERT INTO `city` VALUES ('2444', 'al-Zawiya', 'LBY', 'al-Zawiya');
INSERT INTO `city` VALUES ('2445', 'Schaan', 'LIE', 'Schaan');
INSERT INTO `city` VALUES ('2446', 'Vaduz', 'LIE', 'Vaduz');
INSERT INTO `city` VALUES ('2447', 'Vilnius', 'LTU', 'Vilna');
INSERT INTO `city` VALUES ('2448', 'Kaunas', 'LTU', 'Kaunas');
INSERT INTO `city` VALUES ('2449', 'Klaipeda', 'LTU', 'Klaipeda');
INSERT INTO `city` VALUES ('2450', 'Šiauliai', 'LTU', 'Šiauliai');
INSERT INTO `city` VALUES ('2451', 'Panevezys', 'LTU', 'Panevezys');
INSERT INTO `city` VALUES ('2452', 'Luxembourg [Luxemburg/Lëtzebuerg]', 'LUX', 'Luxembourg');
INSERT INTO `city` VALUES ('2453', 'El-Aaiún', 'ESH', 'El-Aaiún');
INSERT INTO `city` VALUES ('2454', 'Macao', 'MAC', 'Macau');
INSERT INTO `city` VALUES ('2455', 'Antananarivo', 'MDG', 'Antananarivo');
INSERT INTO `city` VALUES ('2456', 'Toamasina', 'MDG', 'Toamasina');
INSERT INTO `city` VALUES ('2457', 'Antsirabé', 'MDG', 'Antananarivo');
INSERT INTO `city` VALUES ('2458', 'Mahajanga', 'MDG', 'Mahajanga');
INSERT INTO `city` VALUES ('2459', 'Fianarantsoa', 'MDG', 'Fianarantsoa');
INSERT INTO `city` VALUES ('2460', 'Skopje', 'MKD', 'Skopje');
INSERT INTO `city` VALUES ('2461', 'Blantyre', 'MWI', 'Blantyre');
INSERT INTO `city` VALUES ('2462', 'Lilongwe', 'MWI', 'Lilongwe');
INSERT INTO `city` VALUES ('2463', 'Male', 'MDV', 'Maale');
INSERT INTO `city` VALUES ('2464', 'Kuala Lumpur', 'MYS', 'Wilayah Persekutuan');
INSERT INTO `city` VALUES ('2465', 'Ipoh', 'MYS', 'Perak');
INSERT INTO `city` VALUES ('2466', 'Johor Baharu', 'MYS', 'Johor');
INSERT INTO `city` VALUES ('2467', 'Petaling Jaya', 'MYS', 'Selangor');
INSERT INTO `city` VALUES ('2468', 'Kelang', 'MYS', 'Selangor');
INSERT INTO `city` VALUES ('2469', 'Kuala Terengganu', 'MYS', 'Terengganu');
INSERT INTO `city` VALUES ('2470', 'Pinang', 'MYS', 'Pulau Pinang');
INSERT INTO `city` VALUES ('2471', 'Kota Bharu', 'MYS', 'Kelantan');
INSERT INTO `city` VALUES ('2472', 'Kuantan', 'MYS', 'Pahang');
INSERT INTO `city` VALUES ('2473', 'Taiping', 'MYS', 'Perak');
INSERT INTO `city` VALUES ('2474', 'Seremban', 'MYS', 'Negeri Sembilan');
INSERT INTO `city` VALUES ('2475', 'Kuching', 'MYS', 'Sarawak');
INSERT INTO `city` VALUES ('2476', 'Sibu', 'MYS', 'Sarawak');
INSERT INTO `city` VALUES ('2477', 'Sandakan', 'MYS', 'Sabah');
INSERT INTO `city` VALUES ('2478', 'Alor Setar', 'MYS', 'Kedah');
INSERT INTO `city` VALUES ('2479', 'Selayang Baru', 'MYS', 'Selangor');
INSERT INTO `city` VALUES ('2480', 'Sungai Petani', 'MYS', 'Kedah');
INSERT INTO `city` VALUES ('2481', 'Shah Alam', 'MYS', 'Selangor');
INSERT INTO `city` VALUES ('2482', 'Bamako', 'MLI', 'Bamako');
INSERT INTO `city` VALUES ('2483', 'Birkirkara', 'MLT', 'Outer Harbour');
INSERT INTO `city` VALUES ('2484', 'Valletta', 'MLT', 'Inner Harbour');
INSERT INTO `city` VALUES ('2485', 'Casablanca', 'MAR', 'Casablanca');
INSERT INTO `city` VALUES ('2486', 'Rabat', 'MAR', 'Rabat-Salé-Zammour-Z');
INSERT INTO `city` VALUES ('2487', 'Marrakech', 'MAR', 'Marrakech-Tensift-Al');
INSERT INTO `city` VALUES ('2488', 'Fès', 'MAR', 'Fès-Boulemane');
INSERT INTO `city` VALUES ('2489', 'Tanger', 'MAR', 'Tanger-Tétouan');
INSERT INTO `city` VALUES ('2490', 'Salé', 'MAR', 'Rabat-Salé-Zammour-Z');
INSERT INTO `city` VALUES ('2491', 'Meknès', 'MAR', 'Meknès-Tafilalet');
INSERT INTO `city` VALUES ('2492', 'Oujda', 'MAR', 'Oriental');
INSERT INTO `city` VALUES ('2493', 'Kénitra', 'MAR', 'Gharb-Chrarda-Béni H');
INSERT INTO `city` VALUES ('2494', 'Tétouan', 'MAR', 'Tanger-Tétouan');
INSERT INTO `city` VALUES ('2495', 'Safi', 'MAR', 'Doukkala-Abda');
INSERT INTO `city` VALUES ('2496', 'Agadir', 'MAR', 'Souss Massa-Draâ');
INSERT INTO `city` VALUES ('2497', 'Mohammedia', 'MAR', 'Casablanca');
INSERT INTO `city` VALUES ('2498', 'Khouribga', 'MAR', 'Chaouia-Ouardigha');
INSERT INTO `city` VALUES ('2499', 'Beni-Mellal', 'MAR', 'Tadla-Azilal');
INSERT INTO `city` VALUES ('2500', 'Témara', 'MAR', 'Rabat-Salé-Zammour-Z');
INSERT INTO `city` VALUES ('2501', 'El Jadida', 'MAR', 'Doukkala-Abda');
INSERT INTO `city` VALUES ('2502', 'Nador', 'MAR', 'Oriental');
INSERT INTO `city` VALUES ('2503', 'Ksar el Kebir', 'MAR', 'Tanger-Tétouan');
INSERT INTO `city` VALUES ('2504', 'Settat', 'MAR', 'Chaouia-Ouardigha');
INSERT INTO `city` VALUES ('2505', 'Taza', 'MAR', 'Taza-Al Hoceima-Taou');
INSERT INTO `city` VALUES ('2506', 'El Araich', 'MAR', 'Tanger-Tétouan');
INSERT INTO `city` VALUES ('2507', 'Dalap-Uliga-Darrit', 'MHL', 'Majuro');
INSERT INTO `city` VALUES ('2508', 'Fort-de-France', 'MTQ', 'Fort-de-France');
INSERT INTO `city` VALUES ('2509', 'Nouakchott', 'MRT', 'Nouakchott');
INSERT INTO `city` VALUES ('2510', 'Nouâdhibou', 'MRT', 'Dakhlet Nouâdhibou');
INSERT INTO `city` VALUES ('2511', 'Port-Louis', 'MUS', 'Port-Louis');
INSERT INTO `city` VALUES ('2512', 'Beau Bassin-Rose Hill', 'MUS', 'Plaines Wilhelms');
INSERT INTO `city` VALUES ('2513', 'Vacoas-Phoenix', 'MUS', 'Plaines Wilhelms');
INSERT INTO `city` VALUES ('2514', 'Mamoutzou', 'MYT', 'Mamoutzou');
INSERT INTO `city` VALUES ('2515', 'Ciudad de México', 'MEX', 'Distrito Federal');
INSERT INTO `city` VALUES ('2516', 'Guadalajara', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2517', 'Ecatepec de Morelos', 'MEX', 'México');
INSERT INTO `city` VALUES ('2518', 'Puebla', 'MEX', 'Puebla');
INSERT INTO `city` VALUES ('2519', 'Nezahualcóyotl', 'MEX', 'México');
INSERT INTO `city` VALUES ('2520', 'Juárez', 'MEX', 'Chihuahua');
INSERT INTO `city` VALUES ('2521', 'Tijuana', 'MEX', 'Baja California');
INSERT INTO `city` VALUES ('2522', 'León', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2523', 'Monterrey', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2524', 'Zapopan', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2525', 'Naucalpan de Juárez', 'MEX', 'México');
INSERT INTO `city` VALUES ('2526', 'Mexicali', 'MEX', 'Baja California');
INSERT INTO `city` VALUES ('2527', 'Culiacán', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2528', 'Acapulco de Juárez', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2529', 'Tlalnepantla de Baz', 'MEX', 'México');
INSERT INTO `city` VALUES ('2530', 'Mérida', 'MEX', 'Yucatán');
INSERT INTO `city` VALUES ('2531', 'Chihuahua', 'MEX', 'Chihuahua');
INSERT INTO `city` VALUES ('2532', 'San Luis Potosí', 'MEX', 'San Luis Potosí');
INSERT INTO `city` VALUES ('2533', 'Guadalupe', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2534', 'Toluca', 'MEX', 'México');
INSERT INTO `city` VALUES ('2535', 'Aguascalientes', 'MEX', 'Aguascalientes');
INSERT INTO `city` VALUES ('2536', 'Querétaro', 'MEX', 'Querétaro de Arteaga');
INSERT INTO `city` VALUES ('2537', 'Morelia', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2538', 'Hermosillo', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2539', 'Saltillo', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2540', 'Torreón', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2541', 'Centro (Villahermosa)', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2542', 'San Nicolás de los Garza', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2543', 'Durango', 'MEX', 'Durango');
INSERT INTO `city` VALUES ('2544', 'Chimalhuacán', 'MEX', 'México');
INSERT INTO `city` VALUES ('2545', 'Tlaquepaque', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2546', 'Atizapán de Zaragoza', 'MEX', 'México');
INSERT INTO `city` VALUES ('2547', 'Veracruz', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2548', 'Cuautitlán Izcalli', 'MEX', 'México');
INSERT INTO `city` VALUES ('2549', 'Irapuato', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2550', 'Tuxtla Gutiérrez', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2551', 'Tultitlán', 'MEX', 'México');
INSERT INTO `city` VALUES ('2552', 'Reynosa', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2553', 'Benito Juárez', 'MEX', 'Quintana Roo');
INSERT INTO `city` VALUES ('2554', 'Matamoros', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2555', 'Xalapa', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2556', 'Celaya', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2557', 'Mazatlán', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2558', 'Ensenada', 'MEX', 'Baja California');
INSERT INTO `city` VALUES ('2559', 'Ahome', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2560', 'Cajeme', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2561', 'Cuernavaca', 'MEX', 'Morelos');
INSERT INTO `city` VALUES ('2562', 'Tonalá', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2563', 'Valle de Chalco Solidaridad', 'MEX', 'México');
INSERT INTO `city` VALUES ('2564', 'Nuevo Laredo', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2565', 'Tepic', 'MEX', 'Nayarit');
INSERT INTO `city` VALUES ('2566', 'Tampico', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2567', 'Ixtapaluca', 'MEX', 'México');
INSERT INTO `city` VALUES ('2568', 'Apodaca', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2569', 'Guasave', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2570', 'Gómez Palacio', 'MEX', 'Durango');
INSERT INTO `city` VALUES ('2571', 'Tapachula', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2572', 'Nicolás Romero', 'MEX', 'México');
INSERT INTO `city` VALUES ('2573', 'Coatzacoalcos', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2574', 'Uruapan', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2575', 'Victoria', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2576', 'Oaxaca de Juárez', 'MEX', 'Oaxaca');
INSERT INTO `city` VALUES ('2577', 'Coacalco de Berriozábal', 'MEX', 'México');
INSERT INTO `city` VALUES ('2578', 'Pachuca de Soto', 'MEX', 'Hidalgo');
INSERT INTO `city` VALUES ('2579', 'General Escobedo', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2580', 'Salamanca', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2581', 'Santa Catarina', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2582', 'Tehuacán', 'MEX', 'Puebla');
INSERT INTO `city` VALUES ('2583', 'Chalco', 'MEX', 'México');
INSERT INTO `city` VALUES ('2584', 'Cárdenas', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2585', 'Campeche', 'MEX', 'Campeche');
INSERT INTO `city` VALUES ('2586', 'La Paz', 'MEX', 'México');
INSERT INTO `city` VALUES ('2587', 'Othón P. Blanco (Chetumal)', 'MEX', 'Quintana Roo');
INSERT INTO `city` VALUES ('2588', 'Texcoco', 'MEX', 'México');
INSERT INTO `city` VALUES ('2589', 'La Paz', 'MEX', 'Baja California Sur');
INSERT INTO `city` VALUES ('2590', 'Metepec', 'MEX', 'México');
INSERT INTO `city` VALUES ('2591', 'Monclova', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2592', 'Huixquilucan', 'MEX', 'México');
INSERT INTO `city` VALUES ('2593', 'Chilpancingo de los Bravo', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2594', 'Puerto Vallarta', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2595', 'Fresnillo', 'MEX', 'Zacatecas');
INSERT INTO `city` VALUES ('2596', 'Ciudad Madero', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2597', 'Soledad de Graciano Sánchez', 'MEX', 'San Luis Potosí');
INSERT INTO `city` VALUES ('2598', 'San Juan del Río', 'MEX', 'Querétaro');
INSERT INTO `city` VALUES ('2599', 'San Felipe del Progreso', 'MEX', 'México');
INSERT INTO `city` VALUES ('2600', 'Córdoba', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2601', 'Tecámac', 'MEX', 'México');
INSERT INTO `city` VALUES ('2602', 'Ocosingo', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2603', 'Carmen', 'MEX', 'Campeche');
INSERT INTO `city` VALUES ('2604', 'Lázaro Cárdenas', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2605', 'Jiutepec', 'MEX', 'Morelos');
INSERT INTO `city` VALUES ('2606', 'Papantla', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2607', 'Comalcalco', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2608', 'Zamora', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2609', 'Nogales', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2610', 'Huimanguillo', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2611', 'Cuautla', 'MEX', 'Morelos');
INSERT INTO `city` VALUES ('2612', 'Minatitlán', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2613', 'Poza Rica de Hidalgo', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2614', 'Ciudad Valles', 'MEX', 'San Luis Potosí');
INSERT INTO `city` VALUES ('2615', 'Navolato', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2616', 'San Luis Río Colorado', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2617', 'Pénjamo', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2618', 'San Andrés Tuxtla', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2619', 'Guanajuato', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2620', 'Navojoa', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2621', 'Zitácuaro', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2622', 'Boca del Río', 'MEX', 'Veracruz-Llave');
INSERT INTO `city` VALUES ('2623', 'Allende', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2624', 'Silao', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2625', 'Macuspana', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2626', 'San Juan Bautista Tuxtepec', 'MEX', 'Oaxaca');
INSERT INTO `city` VALUES ('2627', 'San Cristóbal de las Casas', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2628', 'Valle de Santiago', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2629', 'Guaymas', 'MEX', 'Sonora');
INSERT INTO `city` VALUES ('2630', 'Colima', 'MEX', 'Colima');
INSERT INTO `city` VALUES ('2631', 'Dolores Hidalgo', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2632', 'Lagos de Moreno', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2633', 'Piedras Negras', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2634', 'Altamira', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2635', 'Túxpam', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2636', 'San Pedro Garza García', 'MEX', 'Nuevo León');
INSERT INTO `city` VALUES ('2637', 'Cuauhtémoc', 'MEX', 'Chihuahua');
INSERT INTO `city` VALUES ('2638', 'Manzanillo', 'MEX', 'Colima');
INSERT INTO `city` VALUES ('2639', 'Iguala de la Independencia', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2640', 'Zacatecas', 'MEX', 'Zacatecas');
INSERT INTO `city` VALUES ('2641', 'Tlajomulco de Zúñiga', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2642', 'Tulancingo de Bravo', 'MEX', 'Hidalgo');
INSERT INTO `city` VALUES ('2643', 'Zinacantepec', 'MEX', 'México');
INSERT INTO `city` VALUES ('2644', 'San Martín Texmelucan', 'MEX', 'Puebla');
INSERT INTO `city` VALUES ('2645', 'Tepatitlán de Morelos', 'MEX', 'Jalisco');
INSERT INTO `city` VALUES ('2646', 'Martínez de la Torre', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2647', 'Orizaba', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2648', 'Apatzingán', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2649', 'Atlixco', 'MEX', 'Puebla');
INSERT INTO `city` VALUES ('2650', 'Delicias', 'MEX', 'Chihuahua');
INSERT INTO `city` VALUES ('2651', 'Ixtlahuaca', 'MEX', 'México');
INSERT INTO `city` VALUES ('2652', 'El Mante', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2653', 'Lerdo', 'MEX', 'Durango');
INSERT INTO `city` VALUES ('2654', 'Almoloya de Juárez', 'MEX', 'México');
INSERT INTO `city` VALUES ('2655', 'Acámbaro', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2656', 'Acuña', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2657', 'Guadalupe', 'MEX', 'Zacatecas');
INSERT INTO `city` VALUES ('2658', 'Huejutla de Reyes', 'MEX', 'Hidalgo');
INSERT INTO `city` VALUES ('2659', 'Hidalgo', 'MEX', 'Michoacán de Ocampo');
INSERT INTO `city` VALUES ('2660', 'Los Cabos', 'MEX', 'Baja California Sur');
INSERT INTO `city` VALUES ('2661', 'Comitán de Domínguez', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2662', 'Cunduacán', 'MEX', 'Tabasco');
INSERT INTO `city` VALUES ('2663', 'Río Bravo', 'MEX', 'Tamaulipas');
INSERT INTO `city` VALUES ('2664', 'Temapache', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2665', 'Chilapa de Alvarez', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2666', 'Hidalgo del Parral', 'MEX', 'Chihuahua');
INSERT INTO `city` VALUES ('2667', 'San Francisco del Rincón', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2668', 'Taxco de Alarcón', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2669', 'Zumpango', 'MEX', 'México');
INSERT INTO `city` VALUES ('2670', 'San Pedro Cholula', 'MEX', 'Puebla');
INSERT INTO `city` VALUES ('2671', 'Lerma', 'MEX', 'México');
INSERT INTO `city` VALUES ('2672', 'Tecomán', 'MEX', 'Colima');
INSERT INTO `city` VALUES ('2673', 'Las Margaritas', 'MEX', 'Chiapas');
INSERT INTO `city` VALUES ('2674', 'Cosoleacaque', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2675', 'San Luis de la Paz', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2676', 'José Azueta', 'MEX', 'Guerrero');
INSERT INTO `city` VALUES ('2677', 'Santiago Ixcuintla', 'MEX', 'Nayarit');
INSERT INTO `city` VALUES ('2678', 'San Felipe', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2679', 'Tejupilco', 'MEX', 'México');
INSERT INTO `city` VALUES ('2680', 'Tantoyuca', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2681', 'Salvatierra', 'MEX', 'Guanajuato');
INSERT INTO `city` VALUES ('2682', 'Tultepec', 'MEX', 'México');
INSERT INTO `city` VALUES ('2683', 'Temixco', 'MEX', 'Morelos');
INSERT INTO `city` VALUES ('2684', 'Matamoros', 'MEX', 'Coahuila de Zaragoza');
INSERT INTO `city` VALUES ('2685', 'Pánuco', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2686', 'El Fuerte', 'MEX', 'Sinaloa');
INSERT INTO `city` VALUES ('2687', 'Tierra Blanca', 'MEX', 'Veracruz');
INSERT INTO `city` VALUES ('2688', 'Weno', 'FSM', 'Chuuk');
INSERT INTO `city` VALUES ('2689', 'Palikir', 'FSM', 'Pohnpei');
INSERT INTO `city` VALUES ('2690', 'Chisinau', 'MDA', 'Chisinau');
INSERT INTO `city` VALUES ('2691', 'Tiraspol', 'MDA', 'Dnjestria');
INSERT INTO `city` VALUES ('2692', 'Balti', 'MDA', 'Balti');
INSERT INTO `city` VALUES ('2693', 'Bender (Tîghina)', 'MDA', 'Bender (Tîghina)');
INSERT INTO `city` VALUES ('2694', 'Monte-Carlo', 'MCO', '–');
INSERT INTO `city` VALUES ('2695', 'Monaco-Ville', 'MCO', '–');
INSERT INTO `city` VALUES ('2696', 'Ulan Bator', 'MNG', 'Ulaanbaatar');
INSERT INTO `city` VALUES ('2697', 'Plymouth', 'MSR', 'Plymouth');
INSERT INTO `city` VALUES ('2698', 'Maputo', 'MOZ', 'Maputo');
INSERT INTO `city` VALUES ('2699', 'Matola', 'MOZ', 'Maputo');
INSERT INTO `city` VALUES ('2700', 'Beira', 'MOZ', 'Sofala');
INSERT INTO `city` VALUES ('2701', 'Nampula', 'MOZ', 'Nampula');
INSERT INTO `city` VALUES ('2702', 'Chimoio', 'MOZ', 'Manica');
INSERT INTO `city` VALUES ('2703', 'Naçala-Porto', 'MOZ', 'Nampula');
INSERT INTO `city` VALUES ('2704', 'Quelimane', 'MOZ', 'Zambézia');
INSERT INTO `city` VALUES ('2705', 'Mocuba', 'MOZ', 'Zambézia');
INSERT INTO `city` VALUES ('2706', 'Tete', 'MOZ', 'Tete');
INSERT INTO `city` VALUES ('2707', 'Xai-Xai', 'MOZ', 'Gaza');
INSERT INTO `city` VALUES ('2708', 'Gurue', 'MOZ', 'Zambézia');
INSERT INTO `city` VALUES ('2709', 'Maxixe', 'MOZ', 'Inhambane');
INSERT INTO `city` VALUES ('2710', 'Rangoon (Yangon)', 'MMR', 'Rangoon [Yangon]');
INSERT INTO `city` VALUES ('2711', 'Mandalay', 'MMR', 'Mandalay');
INSERT INTO `city` VALUES ('2712', 'Moulmein (Mawlamyine)', 'MMR', 'Mon');
INSERT INTO `city` VALUES ('2713', 'Pegu (Bago)', 'MMR', 'Pegu [Bago]');
INSERT INTO `city` VALUES ('2714', 'Bassein (Pathein)', 'MMR', 'Irrawaddy [Ayeyarwad');
INSERT INTO `city` VALUES ('2715', 'Monywa', 'MMR', 'Sagaing');
INSERT INTO `city` VALUES ('2716', 'Sittwe (Akyab)', 'MMR', 'Rakhine');
INSERT INTO `city` VALUES ('2717', 'Taunggyi (Taunggye)', 'MMR', 'Shan');
INSERT INTO `city` VALUES ('2718', 'Meikhtila', 'MMR', 'Mandalay');
INSERT INTO `city` VALUES ('2719', 'Mergui (Myeik)', 'MMR', 'Tenasserim [Tanintha');
INSERT INTO `city` VALUES ('2720', 'Lashio (Lasho)', 'MMR', 'Shan');
INSERT INTO `city` VALUES ('2721', 'Prome (Pyay)', 'MMR', 'Pegu [Bago]');
INSERT INTO `city` VALUES ('2722', 'Henzada (Hinthada)', 'MMR', 'Irrawaddy [Ayeyarwad');
INSERT INTO `city` VALUES ('2723', 'Myingyan', 'MMR', 'Mandalay');
INSERT INTO `city` VALUES ('2724', 'Tavoy (Dawei)', 'MMR', 'Tenasserim [Tanintha');
INSERT INTO `city` VALUES ('2725', 'Pagakku (Pakokku)', 'MMR', 'Magwe [Magway]');
INSERT INTO `city` VALUES ('2726', 'Windhoek', 'NAM', 'Khomas');
INSERT INTO `city` VALUES ('2727', 'Yangor', 'NRU', '–');
INSERT INTO `city` VALUES ('2728', 'Yaren', 'NRU', '–');
INSERT INTO `city` VALUES ('2729', 'Kathmandu', 'NPL', 'Central');
INSERT INTO `city` VALUES ('2730', 'Biratnagar', 'NPL', 'Eastern');
INSERT INTO `city` VALUES ('2731', 'Pokhara', 'NPL', 'Western');
INSERT INTO `city` VALUES ('2732', 'Lalitapur', 'NPL', 'Central');
INSERT INTO `city` VALUES ('2733', 'Birgunj', 'NPL', 'Central');
INSERT INTO `city` VALUES ('2734', 'Managua', 'NIC', 'Managua');
INSERT INTO `city` VALUES ('2735', 'León', 'NIC', 'León');
INSERT INTO `city` VALUES ('2736', 'Chinandega', 'NIC', 'Chinandega');
INSERT INTO `city` VALUES ('2737', 'Masaya', 'NIC', 'Masaya');
INSERT INTO `city` VALUES ('2738', 'Niamey', 'NER', 'Niamey');
INSERT INTO `city` VALUES ('2739', 'Zinder', 'NER', 'Zinder');
INSERT INTO `city` VALUES ('2740', 'Maradi', 'NER', 'Maradi');
INSERT INTO `city` VALUES ('2741', 'Lagos', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2742', 'Ibadan', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2743', 'Ogbomosho', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2744', 'Kano', 'NGA', 'Kano & Jigawa');
INSERT INTO `city` VALUES ('2745', 'Oshogbo', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2746', 'Ilorin', 'NGA', 'Kwara & Kogi');
INSERT INTO `city` VALUES ('2747', 'Abeokuta', 'NGA', 'Ogun');
INSERT INTO `city` VALUES ('2748', 'Port Harcourt', 'NGA', 'Rivers & Bayelsa');
INSERT INTO `city` VALUES ('2749', 'Zaria', 'NGA', 'Kaduna');
INSERT INTO `city` VALUES ('2750', 'Ilesha', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2751', 'Onitsha', 'NGA', 'Anambra & Enugu & Eb');
INSERT INTO `city` VALUES ('2752', 'Iwo', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2753', 'Ado-Ekiti', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2754', 'Abuja', 'NGA', 'Federal Capital Dist');
INSERT INTO `city` VALUES ('2755', 'Kaduna', 'NGA', 'Kaduna');
INSERT INTO `city` VALUES ('2756', 'Mushin', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2757', 'Maiduguri', 'NGA', 'Borno & Yobe');
INSERT INTO `city` VALUES ('2758', 'Enugu', 'NGA', 'Anambra & Enugu & Eb');
INSERT INTO `city` VALUES ('2759', 'Ede', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2760', 'Aba', 'NGA', 'Imo & Abia');
INSERT INTO `city` VALUES ('2761', 'Ife', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2762', 'Ila', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2763', 'Oyo', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2764', 'Ikerre', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2765', 'Benin City', 'NGA', 'Edo & Delta');
INSERT INTO `city` VALUES ('2766', 'Iseyin', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2767', 'Katsina', 'NGA', 'Katsina');
INSERT INTO `city` VALUES ('2768', 'Jos', 'NGA', 'Plateau & Nassarawa');
INSERT INTO `city` VALUES ('2769', 'Sokoto', 'NGA', 'Sokoto & Kebbi & Zam');
INSERT INTO `city` VALUES ('2770', 'Ilobu', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2771', 'Offa', 'NGA', 'Kwara & Kogi');
INSERT INTO `city` VALUES ('2772', 'Ikorodu', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2773', 'Ilawe-Ekiti', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2774', 'Owo', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2775', 'Ikirun', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2776', 'Shaki', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2777', 'Calabar', 'NGA', 'Cross River');
INSERT INTO `city` VALUES ('2778', 'Ondo', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2779', 'Akure', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2780', 'Gusau', 'NGA', 'Sokoto & Kebbi & Zam');
INSERT INTO `city` VALUES ('2781', 'Ijebu-Ode', 'NGA', 'Ogun');
INSERT INTO `city` VALUES ('2782', 'Effon-Alaiye', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2783', 'Kumo', 'NGA', 'Bauchi & Gombe');
INSERT INTO `city` VALUES ('2784', 'Shomolu', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2785', 'Oka-Akoko', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2786', 'Ikare', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2787', 'Sapele', 'NGA', 'Edo & Delta');
INSERT INTO `city` VALUES ('2788', 'Deba Habe', 'NGA', 'Bauchi & Gombe');
INSERT INTO `city` VALUES ('2789', 'Minna', 'NGA', 'Niger');
INSERT INTO `city` VALUES ('2790', 'Warri', 'NGA', 'Edo & Delta');
INSERT INTO `city` VALUES ('2791', 'Bida', 'NGA', 'Niger');
INSERT INTO `city` VALUES ('2792', 'Ikire', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2793', 'Makurdi', 'NGA', 'Benue');
INSERT INTO `city` VALUES ('2794', 'Lafia', 'NGA', 'Plateau & Nassarawa');
INSERT INTO `city` VALUES ('2795', 'Inisa', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2796', 'Shagamu', 'NGA', 'Ogun');
INSERT INTO `city` VALUES ('2797', 'Awka', 'NGA', 'Anambra & Enugu & Eb');
INSERT INTO `city` VALUES ('2798', 'Gombe', 'NGA', 'Bauchi & Gombe');
INSERT INTO `city` VALUES ('2799', 'Igboho', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2800', 'Ejigbo', 'NGA', 'Oyo & Osun');
INSERT INTO `city` VALUES ('2801', 'Agege', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2802', 'Ise-Ekiti', 'NGA', 'Ondo & Ekiti');
INSERT INTO `city` VALUES ('2803', 'Ugep', 'NGA', 'Cross River');
INSERT INTO `city` VALUES ('2804', 'Epe', 'NGA', 'Lagos');
INSERT INTO `city` VALUES ('2805', 'Alofi', 'NIU', '–');
INSERT INTO `city` VALUES ('2806', 'Kingston', 'NFK', '–');
INSERT INTO `city` VALUES ('2807', 'Oslo', 'NOR', 'Oslo');
INSERT INTO `city` VALUES ('2808', 'Bergen', 'NOR', 'Hordaland');
INSERT INTO `city` VALUES ('2809', 'Trondheim', 'NOR', 'Sør-Trøndelag');
INSERT INTO `city` VALUES ('2810', 'Stavanger', 'NOR', 'Rogaland');
INSERT INTO `city` VALUES ('2811', 'Bærum', 'NOR', 'Akershus');
INSERT INTO `city` VALUES ('2812', 'Abidjan', 'CIV', 'Abidjan');
INSERT INTO `city` VALUES ('2813', 'Bouaké', 'CIV', 'Bouaké');
INSERT INTO `city` VALUES ('2814', 'Yamoussoukro', 'CIV', 'Yamoussoukro');
INSERT INTO `city` VALUES ('2815', 'Daloa', 'CIV', 'Daloa');
INSERT INTO `city` VALUES ('2816', 'Korhogo', 'CIV', 'Korhogo');
INSERT INTO `city` VALUES ('2817', 'al-Sib', 'OMN', 'Masqat');
INSERT INTO `city` VALUES ('2818', 'Salala', 'OMN', 'Zufar');
INSERT INTO `city` VALUES ('2819', 'Bawshar', 'OMN', 'Masqat');
INSERT INTO `city` VALUES ('2820', 'Suhar', 'OMN', 'al-Batina');
INSERT INTO `city` VALUES ('2821', 'Masqat', 'OMN', 'Masqat');
INSERT INTO `city` VALUES ('2822', 'Karachi', 'PAK', 'Sindh');
INSERT INTO `city` VALUES ('2823', 'Lahore', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2824', 'Faisalabad', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2825', 'Rawalpindi', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2826', 'Multan', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2827', 'Hyderabad', 'PAK', 'Sindh');
INSERT INTO `city` VALUES ('2828', 'Gujranwala', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2829', 'Peshawar', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2830', 'Quetta', 'PAK', 'Baluchistan');
INSERT INTO `city` VALUES ('2831', 'Islamabad', 'PAK', 'Islamabad');
INSERT INTO `city` VALUES ('2832', 'Sargodha', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2833', 'Sialkot', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2834', 'Bahawalpur', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2835', 'Sukkur', 'PAK', 'Sindh');
INSERT INTO `city` VALUES ('2836', 'Jhang', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2837', 'Sheikhupura', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2838', 'Larkana', 'PAK', 'Sindh');
INSERT INTO `city` VALUES ('2839', 'Gujrat', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2840', 'Mardan', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2841', 'Kasur', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2842', 'Rahim Yar Khan', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2843', 'Sahiwal', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2844', 'Okara', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2845', 'Wah', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2846', 'Dera Ghazi Khan', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2847', 'Mirpur Khas', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2848', 'Nawabshah', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2849', 'Mingora', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2850', 'Chiniot', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2851', 'Kamoke', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2852', 'Mandi Burewala', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2853', 'Jhelum', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2854', 'Sadiqabad', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2855', 'Jacobabad', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2856', 'Shikarpur', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2857', 'Khanewal', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2858', 'Hafizabad', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2859', 'Kohat', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2860', 'Muzaffargarh', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2861', 'Khanpur', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2862', 'Gojra', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2863', 'Bahawalnagar', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2864', 'Muridke', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2865', 'Pak Pattan', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2866', 'Abottabad', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2867', 'Tando Adam', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2868', 'Jaranwala', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2869', 'Khairpur', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2870', 'Chishtian Mandi', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2871', 'Daska', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2872', 'Dadu', 'PAK', 'Sind');
INSERT INTO `city` VALUES ('2873', 'Mandi Bahauddin', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2874', 'Ahmadpur East', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2875', 'Kamalia', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2876', 'Khuzdar', 'PAK', 'Baluchistan');
INSERT INTO `city` VALUES ('2877', 'Vihari', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2878', 'Dera Ismail Khan', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2879', 'Wazirabad', 'PAK', 'Punjab');
INSERT INTO `city` VALUES ('2880', 'Nowshera', 'PAK', 'Nothwest Border Prov');
INSERT INTO `city` VALUES ('2881', 'Koror', 'PLW', 'Koror');
INSERT INTO `city` VALUES ('2882', 'Ciudad de Panamá', 'PAN', 'Panamá');
INSERT INTO `city` VALUES ('2883', 'San Miguelito', 'PAN', 'San Miguelito');
INSERT INTO `city` VALUES ('2884', 'Port Moresby', 'PNG', 'National Capital Dis');
INSERT INTO `city` VALUES ('2885', 'Asunción', 'PRY', 'Asunción');
INSERT INTO `city` VALUES ('2886', 'Ciudad del Este', 'PRY', 'Alto Paraná');
INSERT INTO `city` VALUES ('2887', 'San Lorenzo', 'PRY', 'Central');
INSERT INTO `city` VALUES ('2888', 'Lambaré', 'PRY', 'Central');
INSERT INTO `city` VALUES ('2889', 'Fernando de la Mora', 'PRY', 'Central');
INSERT INTO `city` VALUES ('2890', 'Lima', 'PER', 'Lima');
INSERT INTO `city` VALUES ('2891', 'Arequipa', 'PER', 'Arequipa');
INSERT INTO `city` VALUES ('2892', 'Trujillo', 'PER', 'La Libertad');
INSERT INTO `city` VALUES ('2893', 'Chiclayo', 'PER', 'Lambayeque');
INSERT INTO `city` VALUES ('2894', 'Callao', 'PER', 'Callao');
INSERT INTO `city` VALUES ('2895', 'Iquitos', 'PER', 'Loreto');
INSERT INTO `city` VALUES ('2896', 'Chimbote', 'PER', 'Ancash');
INSERT INTO `city` VALUES ('2897', 'Huancayo', 'PER', 'Junín');
INSERT INTO `city` VALUES ('2898', 'Piura', 'PER', 'Piura');
INSERT INTO `city` VALUES ('2899', 'Cusco', 'PER', 'Cusco');
INSERT INTO `city` VALUES ('2900', 'Pucallpa', 'PER', 'Ucayali');
INSERT INTO `city` VALUES ('2901', 'Tacna', 'PER', 'Tacna');
INSERT INTO `city` VALUES ('2902', 'Ica', 'PER', 'Ica');
INSERT INTO `city` VALUES ('2903', 'Sullana', 'PER', 'Piura');
INSERT INTO `city` VALUES ('2904', 'Juliaca', 'PER', 'Puno');
INSERT INTO `city` VALUES ('2905', 'Huánuco', 'PER', 'Huanuco');
INSERT INTO `city` VALUES ('2906', 'Ayacucho', 'PER', 'Ayacucho');
INSERT INTO `city` VALUES ('2907', 'Chincha Alta', 'PER', 'Ica');
INSERT INTO `city` VALUES ('2908', 'Cajamarca', 'PER', 'Cajamarca');
INSERT INTO `city` VALUES ('2909', 'Puno', 'PER', 'Puno');
INSERT INTO `city` VALUES ('2910', 'Ventanilla', 'PER', 'Callao');
INSERT INTO `city` VALUES ('2911', 'Castilla', 'PER', 'Piura');
INSERT INTO `city` VALUES ('2912', 'Adamstown', 'PCN', '–');
INSERT INTO `city` VALUES ('2913', 'Garapan', 'MNP', 'Saipan');
INSERT INTO `city` VALUES ('2914', 'Lisboa', 'PRT', 'Lisboa');
INSERT INTO `city` VALUES ('2915', 'Porto', 'PRT', 'Porto');
INSERT INTO `city` VALUES ('2916', 'Amadora', 'PRT', 'Lisboa');
INSERT INTO `city` VALUES ('2917', 'Coímbra', 'PRT', 'Coímbra');
INSERT INTO `city` VALUES ('2918', 'Braga', 'PRT', 'Braga');
INSERT INTO `city` VALUES ('2919', 'San Juan', 'PRI', 'San Juan');
INSERT INTO `city` VALUES ('2920', 'Bayamón', 'PRI', 'Bayamón');
INSERT INTO `city` VALUES ('2921', 'Ponce', 'PRI', 'Ponce');
INSERT INTO `city` VALUES ('2922', 'Carolina', 'PRI', 'Carolina');
INSERT INTO `city` VALUES ('2923', 'Caguas', 'PRI', 'Caguas');
INSERT INTO `city` VALUES ('2924', 'Arecibo', 'PRI', 'Arecibo');
INSERT INTO `city` VALUES ('2925', 'Guaynabo', 'PRI', 'Guaynabo');
INSERT INTO `city` VALUES ('2926', 'Mayagüez', 'PRI', 'Mayagüez');
INSERT INTO `city` VALUES ('2927', 'Toa Baja', 'PRI', 'Toa Baja');
INSERT INTO `city` VALUES ('2928', 'Warszawa', 'POL', 'Mazowieckie');
INSERT INTO `city` VALUES ('2929', 'Lódz', 'POL', 'Lodzkie');
INSERT INTO `city` VALUES ('2930', 'Kraków', 'POL', 'Malopolskie');
INSERT INTO `city` VALUES ('2931', 'Wroclaw', 'POL', 'Dolnoslaskie');
INSERT INTO `city` VALUES ('2932', 'Poznan', 'POL', 'Wielkopolskie');
INSERT INTO `city` VALUES ('2933', 'Gdansk', 'POL', 'Pomorskie');
INSERT INTO `city` VALUES ('2934', 'Szczecin', 'POL', 'Zachodnio-Pomorskie');
INSERT INTO `city` VALUES ('2935', 'Bydgoszcz', 'POL', 'Kujawsko-Pomorskie');
INSERT INTO `city` VALUES ('2936', 'Lublin', 'POL', 'Lubelskie');
INSERT INTO `city` VALUES ('2937', 'Katowice', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2938', 'Bialystok', 'POL', 'Podlaskie');
INSERT INTO `city` VALUES ('2939', 'Czestochowa', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2940', 'Gdynia', 'POL', 'Pomorskie');
INSERT INTO `city` VALUES ('2941', 'Sosnowiec', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2942', 'Radom', 'POL', 'Mazowieckie');
INSERT INTO `city` VALUES ('2943', 'Kielce', 'POL', 'Swietokrzyskie');
INSERT INTO `city` VALUES ('2944', 'Gliwice', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2945', 'Torun', 'POL', 'Kujawsko-Pomorskie');
INSERT INTO `city` VALUES ('2946', 'Bytom', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2947', 'Zabrze', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2948', 'Bielsko-Biala', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2949', 'Olsztyn', 'POL', 'Warminsko-Mazurskie');
INSERT INTO `city` VALUES ('2950', 'Rzeszów', 'POL', 'Podkarpackie');
INSERT INTO `city` VALUES ('2951', 'Ruda Slaska', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2952', 'Rybnik', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2953', 'Walbrzych', 'POL', 'Dolnoslaskie');
INSERT INTO `city` VALUES ('2954', 'Tychy', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2955', 'Dabrowa Górnicza', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2956', 'Plock', 'POL', 'Mazowieckie');
INSERT INTO `city` VALUES ('2957', 'Elblag', 'POL', 'Warminsko-Mazurskie');
INSERT INTO `city` VALUES ('2958', 'Opole', 'POL', 'Opolskie');
INSERT INTO `city` VALUES ('2959', 'Gorzów Wielkopolski', 'POL', 'Lubuskie');
INSERT INTO `city` VALUES ('2960', 'Wloclawek', 'POL', 'Kujawsko-Pomorskie');
INSERT INTO `city` VALUES ('2961', 'Chorzów', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2962', 'Tarnów', 'POL', 'Malopolskie');
INSERT INTO `city` VALUES ('2963', 'Zielona Góra', 'POL', 'Lubuskie');
INSERT INTO `city` VALUES ('2964', 'Koszalin', 'POL', 'Zachodnio-Pomorskie');
INSERT INTO `city` VALUES ('2965', 'Legnica', 'POL', 'Dolnoslaskie');
INSERT INTO `city` VALUES ('2966', 'Kalisz', 'POL', 'Wielkopolskie');
INSERT INTO `city` VALUES ('2967', 'Grudziadz', 'POL', 'Kujawsko-Pomorskie');
INSERT INTO `city` VALUES ('2968', 'Slupsk', 'POL', 'Pomorskie');
INSERT INTO `city` VALUES ('2969', 'Jastrzebie-Zdrój', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2970', 'Jaworzno', 'POL', 'Slaskie');
INSERT INTO `city` VALUES ('2971', 'Jelenia Góra', 'POL', 'Dolnoslaskie');
INSERT INTO `city` VALUES ('2972', 'Malabo', 'GNQ', 'Bioko');
INSERT INTO `city` VALUES ('2973', 'Doha', 'QAT', 'Doha');
INSERT INTO `city` VALUES ('2974', 'Paris', 'FRA', 'Île-de-France');
INSERT INTO `city` VALUES ('2975', 'Marseille', 'FRA', 'Provence-Alpes-Côte');
INSERT INTO `city` VALUES ('2976', 'Lyon', 'FRA', 'Rhône-Alpes');
INSERT INTO `city` VALUES ('2977', 'Toulouse', 'FRA', 'Midi-Pyrénées');
INSERT INTO `city` VALUES ('2978', 'Nice', 'FRA', 'Provence-Alpes-Côte');
INSERT INTO `city` VALUES ('2979', 'Nantes', 'FRA', 'Pays de la Loire');
INSERT INTO `city` VALUES ('2980', 'Strasbourg', 'FRA', 'Alsace');
INSERT INTO `city` VALUES ('2981', 'Montpellier', 'FRA', 'Languedoc-Roussillon');
INSERT INTO `city` VALUES ('2982', 'Bordeaux', 'FRA', 'Aquitaine');
INSERT INTO `city` VALUES ('2983', 'Rennes', 'FRA', 'Haute-Normandie');
INSERT INTO `city` VALUES ('2984', 'Le Havre', 'FRA', 'Champagne-Ardenne');
INSERT INTO `city` VALUES ('2985', 'Reims', 'FRA', 'Nord-Pas-de-Calais');
INSERT INTO `city` VALUES ('2986', 'Lille', 'FRA', 'Rhône-Alpes');
INSERT INTO `city` VALUES ('2987', 'St-Étienne', 'FRA', 'Bretagne');
INSERT INTO `city` VALUES ('2988', 'Toulon', 'FRA', 'Provence-Alpes-Côte');
INSERT INTO `city` VALUES ('2989', 'Grenoble', 'FRA', 'Rhône-Alpes');
INSERT INTO `city` VALUES ('2990', 'Angers', 'FRA', 'Pays de la Loire');
INSERT INTO `city` VALUES ('2991', 'Dijon', 'FRA', 'Bourgogne');
INSERT INTO `city` VALUES ('2992', 'Brest', 'FRA', 'Bretagne');
INSERT INTO `city` VALUES ('2993', 'Le Mans', 'FRA', 'Pays de la Loire');
INSERT INTO `city` VALUES ('2994', 'Clermont-Ferrand', 'FRA', 'Auvergne');
INSERT INTO `city` VALUES ('2995', 'Amiens', 'FRA', 'Picardie');
INSERT INTO `city` VALUES ('2996', 'Aix-en-Provence', 'FRA', 'Provence-Alpes-Côte');
INSERT INTO `city` VALUES ('2997', 'Limoges', 'FRA', 'Limousin');
INSERT INTO `city` VALUES ('2998', 'Nîmes', 'FRA', 'Languedoc-Roussillon');
INSERT INTO `city` VALUES ('2999', 'Tours', 'FRA', 'Centre');
INSERT INTO `city` VALUES ('3000', 'Villeurbanne', 'FRA', 'Rhône-Alpes');
INSERT INTO `city` VALUES ('3001', 'Metz', 'FRA', 'Lorraine');
INSERT INTO `city` VALUES ('3002', 'Besançon', 'FRA', 'Franche-Comté');
INSERT INTO `city` VALUES ('3003', 'Caen', 'FRA', 'Basse-Normandie');
INSERT INTO `city` VALUES ('3004', 'Orléans', 'FRA', 'Centre');
INSERT INTO `city` VALUES ('3005', 'Mulhouse', 'FRA', 'Alsace');
INSERT INTO `city` VALUES ('3006', 'Rouen', 'FRA', 'Haute-Normandie');
INSERT INTO `city` VALUES ('3007', 'Boulogne-Billancourt', 'FRA', 'Île-de-France');
INSERT INTO `city` VALUES ('3008', 'Perpignan', 'FRA', 'Languedoc-Roussillon');
INSERT INTO `city` VALUES ('3009', 'Nancy', 'FRA', 'Lorraine');
INSERT INTO `city` VALUES ('3010', 'Roubaix', 'FRA', 'Nord-Pas-de-Calais');
INSERT INTO `city` VALUES ('3011', 'Argenteuil', 'FRA', 'Île-de-France');
INSERT INTO `city` VALUES ('3012', 'Tourcoing', 'FRA', 'Nord-Pas-de-Calais');
INSERT INTO `city` VALUES ('3013', 'Montreuil', 'FRA', 'Île-de-France');
INSERT INTO `city` VALUES ('3014', 'Cayenne', 'GUF', 'Cayenne');
INSERT INTO `city` VALUES ('3015', 'Faaa', 'PYF', 'Tahiti');
INSERT INTO `city` VALUES ('3016', 'Papeete', 'PYF', 'Tahiti');
INSERT INTO `city` VALUES ('3017', 'Saint-Denis', 'REU', 'Saint-Denis');
INSERT INTO `city` VALUES ('3018', 'Bucuresti', 'ROM', 'Bukarest');
INSERT INTO `city` VALUES ('3019', 'Iasi', 'ROM', 'Iasi');
INSERT INTO `city` VALUES ('3020', 'Constanta', 'ROM', 'Constanta');
INSERT INTO `city` VALUES ('3021', 'Cluj-Napoca', 'ROM', 'Cluj');
INSERT INTO `city` VALUES ('3022', 'Galati', 'ROM', 'Galati');
INSERT INTO `city` VALUES ('3023', 'Timisoara', 'ROM', 'Timis');
INSERT INTO `city` VALUES ('3024', 'Brasov', 'ROM', 'Brasov');
INSERT INTO `city` VALUES ('3025', 'Craiova', 'ROM', 'Dolj');
INSERT INTO `city` VALUES ('3026', 'Ploiesti', 'ROM', 'Prahova');
INSERT INTO `city` VALUES ('3027', 'Braila', 'ROM', 'Braila');
INSERT INTO `city` VALUES ('3028', 'Oradea', 'ROM', 'Bihor');
INSERT INTO `city` VALUES ('3029', 'Bacau', 'ROM', 'Bacau');
INSERT INTO `city` VALUES ('3030', 'Pitesti', 'ROM', 'Arges');
INSERT INTO `city` VALUES ('3031', 'Arad', 'ROM', 'Arad');
INSERT INTO `city` VALUES ('3032', 'Sibiu', 'ROM', 'Sibiu');
INSERT INTO `city` VALUES ('3033', 'Târgu Mures', 'ROM', 'Mures');
INSERT INTO `city` VALUES ('3034', 'Baia Mare', 'ROM', 'Maramures');
INSERT INTO `city` VALUES ('3035', 'Buzau', 'ROM', 'Buzau');
INSERT INTO `city` VALUES ('3036', 'Satu Mare', 'ROM', 'Satu Mare');
INSERT INTO `city` VALUES ('3037', 'Botosani', 'ROM', 'Botosani');
INSERT INTO `city` VALUES ('3038', 'Piatra Neamt', 'ROM', 'Neamt');
INSERT INTO `city` VALUES ('3039', 'Râmnicu Vâlcea', 'ROM', 'Vâlcea');
INSERT INTO `city` VALUES ('3040', 'Suceava', 'ROM', 'Suceava');
INSERT INTO `city` VALUES ('3041', 'Drobeta-Turnu Severin', 'ROM', 'Mehedinti');
INSERT INTO `city` VALUES ('3042', 'Târgoviste', 'ROM', 'Dâmbovita');
INSERT INTO `city` VALUES ('3043', 'Focsani', 'ROM', 'Vrancea');
INSERT INTO `city` VALUES ('3044', 'Târgu Jiu', 'ROM', 'Gorj');
INSERT INTO `city` VALUES ('3045', 'Tulcea', 'ROM', 'Tulcea');
INSERT INTO `city` VALUES ('3046', 'Resita', 'ROM', 'Caras-Severin');
INSERT INTO `city` VALUES ('3047', 'Kigali', 'RWA', 'Kigali');
INSERT INTO `city` VALUES ('3048', 'Stockholm', 'SWE', 'Lisboa');
INSERT INTO `city` VALUES ('3049', 'Gothenburg [Göteborg]', 'SWE', 'West Götanmaan län');
INSERT INTO `city` VALUES ('3050', 'Malmö', 'SWE', 'Skåne län');
INSERT INTO `city` VALUES ('3051', 'Uppsala', 'SWE', 'Uppsala län');
INSERT INTO `city` VALUES ('3052', 'Linköping', 'SWE', 'East Götanmaan län');
INSERT INTO `city` VALUES ('3053', 'Västerås', 'SWE', 'Västmanlands län');
INSERT INTO `city` VALUES ('3054', 'Örebro', 'SWE', 'Örebros län');
INSERT INTO `city` VALUES ('3055', 'Norrköping', 'SWE', 'East Götanmaan län');
INSERT INTO `city` VALUES ('3056', 'Helsingborg', 'SWE', 'Skåne län');
INSERT INTO `city` VALUES ('3057', 'Jönköping', 'SWE', 'Jönköpings län');
INSERT INTO `city` VALUES ('3058', 'Umeå', 'SWE', 'Västerbottens län');
INSERT INTO `city` VALUES ('3059', 'Lund', 'SWE', 'Skåne län');
INSERT INTO `city` VALUES ('3060', 'Borås', 'SWE', 'West Götanmaan län');
INSERT INTO `city` VALUES ('3061', 'Sundsvall', 'SWE', 'Västernorrlands län');
INSERT INTO `city` VALUES ('3062', 'Gävle', 'SWE', 'Gävleborgs län');
INSERT INTO `city` VALUES ('3063', 'Jamestown', 'SHN', 'Saint Helena');
INSERT INTO `city` VALUES ('3064', 'Basseterre', 'KNA', 'St George Basseterre');
INSERT INTO `city` VALUES ('3065', 'Castries', 'LCA', 'Castries');
INSERT INTO `city` VALUES ('3066', 'Kingstown', 'VCT', 'St George');
INSERT INTO `city` VALUES ('3067', 'Saint-Pierre', 'SPM', 'Saint-Pierre');
INSERT INTO `city` VALUES ('3068', 'Berlin', 'DEU', 'Berliini');
INSERT INTO `city` VALUES ('3069', 'Hamburg', 'DEU', 'Hamburg');
INSERT INTO `city` VALUES ('3070', 'Munich [München]', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3071', 'Köln', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3072', 'Frankfurt am Main', 'DEU', 'Hessen');
INSERT INTO `city` VALUES ('3073', 'Essen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3074', 'Dortmund', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3075', 'Stuttgart', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3076', 'Düsseldorf', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3077', 'Bremen', 'DEU', 'Bremen');
INSERT INTO `city` VALUES ('3078', 'Duisburg', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3079', 'Hannover', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3080', 'Leipzig', 'DEU', 'Saksi');
INSERT INTO `city` VALUES ('3081', 'Nürnberg', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3082', 'Dresden', 'DEU', 'Saksi');
INSERT INTO `city` VALUES ('3083', 'Bochum', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3084', 'Wuppertal', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3085', 'Bielefeld', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3086', 'Mannheim', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3087', 'Bonn', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3088', 'Gelsenkirchen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3089', 'Karlsruhe', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3090', 'Wiesbaden', 'DEU', 'Hessen');
INSERT INTO `city` VALUES ('3091', 'Münster', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3092', 'Mönchengladbach', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3093', 'Chemnitz', 'DEU', 'Saksi');
INSERT INTO `city` VALUES ('3094', 'Augsburg', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3095', 'Halle/Saale', 'DEU', 'Anhalt Sachsen');
INSERT INTO `city` VALUES ('3096', 'Braunschweig', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3097', 'Aachen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3098', 'Krefeld', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3099', 'Magdeburg', 'DEU', 'Anhalt Sachsen');
INSERT INTO `city` VALUES ('3100', 'Kiel', 'DEU', 'Schleswig-Holstein');
INSERT INTO `city` VALUES ('3101', 'Oberhausen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3102', 'Lübeck', 'DEU', 'Schleswig-Holstein');
INSERT INTO `city` VALUES ('3103', 'Hagen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3104', 'Rostock', 'DEU', 'Mecklenburg-Vorpomme');
INSERT INTO `city` VALUES ('3105', 'Freiburg im Breisgau', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3106', 'Erfurt', 'DEU', 'Thüringen');
INSERT INTO `city` VALUES ('3107', 'Kassel', 'DEU', 'Hessen');
INSERT INTO `city` VALUES ('3108', 'Saarbrücken', 'DEU', 'Saarland');
INSERT INTO `city` VALUES ('3109', 'Mainz', 'DEU', 'Rheinland-Pfalz');
INSERT INTO `city` VALUES ('3110', 'Hamm', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3111', 'Herne', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3112', 'Mülheim an der Ruhr', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3113', 'Solingen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3114', 'Osnabrück', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3115', 'Ludwigshafen am Rhein', 'DEU', 'Rheinland-Pfalz');
INSERT INTO `city` VALUES ('3116', 'Leverkusen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3117', 'Oldenburg', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3118', 'Neuss', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3119', 'Heidelberg', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3120', 'Darmstadt', 'DEU', 'Hessen');
INSERT INTO `city` VALUES ('3121', 'Paderborn', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3122', 'Potsdam', 'DEU', 'Brandenburg');
INSERT INTO `city` VALUES ('3123', 'Würzburg', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3124', 'Regensburg', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3125', 'Recklinghausen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3126', 'Göttingen', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3127', 'Bremerhaven', 'DEU', 'Bremen');
INSERT INTO `city` VALUES ('3128', 'Wolfsburg', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3129', 'Bottrop', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3130', 'Remscheid', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3131', 'Heilbronn', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3132', 'Pforzheim', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3133', 'Offenbach am Main', 'DEU', 'Hessen');
INSERT INTO `city` VALUES ('3134', 'Ulm', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3135', 'Ingolstadt', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3136', 'Gera', 'DEU', 'Thüringen');
INSERT INTO `city` VALUES ('3137', 'Salzgitter', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3138', 'Cottbus', 'DEU', 'Brandenburg');
INSERT INTO `city` VALUES ('3139', 'Reutlingen', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3140', 'Fürth', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3141', 'Siegen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3142', 'Koblenz', 'DEU', 'Rheinland-Pfalz');
INSERT INTO `city` VALUES ('3143', 'Moers', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3144', 'Bergisch Gladbach', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3145', 'Zwickau', 'DEU', 'Saksi');
INSERT INTO `city` VALUES ('3146', 'Hildesheim', 'DEU', 'Niedersachsen');
INSERT INTO `city` VALUES ('3147', 'Witten', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3148', 'Schwerin', 'DEU', 'Mecklenburg-Vorpomme');
INSERT INTO `city` VALUES ('3149', 'Erlangen', 'DEU', 'Baijeri');
INSERT INTO `city` VALUES ('3150', 'Kaiserslautern', 'DEU', 'Rheinland-Pfalz');
INSERT INTO `city` VALUES ('3151', 'Trier', 'DEU', 'Rheinland-Pfalz');
INSERT INTO `city` VALUES ('3152', 'Jena', 'DEU', 'Thüringen');
INSERT INTO `city` VALUES ('3153', 'Iserlohn', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3154', 'Gütersloh', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3155', 'Marl', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3156', 'Lünen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3157', 'Düren', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3158', 'Ratingen', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3159', 'Velbert', 'DEU', 'Nordrhein-Westfalen');
INSERT INTO `city` VALUES ('3160', 'Esslingen am Neckar', 'DEU', 'Baden-Württemberg');
INSERT INTO `city` VALUES ('3161', 'Honiara', 'SLB', 'Honiara');
INSERT INTO `city` VALUES ('3162', 'Lusaka', 'ZMB', 'Lusaka');
INSERT INTO `city` VALUES ('3163', 'Ndola', 'ZMB', 'Copperbelt');
INSERT INTO `city` VALUES ('3164', 'Kitwe', 'ZMB', 'Copperbelt');
INSERT INTO `city` VALUES ('3165', 'Kabwe', 'ZMB', 'Central');
INSERT INTO `city` VALUES ('3166', 'Chingola', 'ZMB', 'Copperbelt');
INSERT INTO `city` VALUES ('3167', 'Mufulira', 'ZMB', 'Copperbelt');
INSERT INTO `city` VALUES ('3168', 'Luanshya', 'ZMB', 'Copperbelt');
INSERT INTO `city` VALUES ('3169', 'Apia', 'WSM', 'Upolu');
INSERT INTO `city` VALUES ('3170', 'Serravalle', 'SMR', 'Serravalle/Dogano');
INSERT INTO `city` VALUES ('3171', 'San Marino', 'SMR', 'San Marino');
INSERT INTO `city` VALUES ('3172', 'São Tomé', 'STP', 'Aqua Grande');
INSERT INTO `city` VALUES ('3173', 'Riyadh', 'SAU', 'Riyadh');
INSERT INTO `city` VALUES ('3174', 'Jedda', 'SAU', 'Mekka');
INSERT INTO `city` VALUES ('3175', 'Mekka', 'SAU', 'Mekka');
INSERT INTO `city` VALUES ('3176', 'Medina', 'SAU', 'Medina');
INSERT INTO `city` VALUES ('3177', 'al-Dammam', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3178', 'al-Taif', 'SAU', 'Mekka');
INSERT INTO `city` VALUES ('3179', 'Tabuk', 'SAU', 'Tabuk');
INSERT INTO `city` VALUES ('3180', 'Burayda', 'SAU', 'al-Qasim');
INSERT INTO `city` VALUES ('3181', 'al-Hufuf', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3182', 'al-Mubarraz', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3183', 'Khamis Mushayt', 'SAU', 'Asir');
INSERT INTO `city` VALUES ('3184', 'Hail', 'SAU', 'Hail');
INSERT INTO `city` VALUES ('3185', 'al-Kharj', 'SAU', 'Riad');
INSERT INTO `city` VALUES ('3186', 'al-Khubar', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3187', 'Jubayl', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3188', 'Hafar al-Batin', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3189', 'al-Tuqba', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3190', 'Yanbu', 'SAU', 'Medina');
INSERT INTO `city` VALUES ('3191', 'Abha', 'SAU', 'Asir');
INSERT INTO `city` VALUES ('3192', 'Ara´ar', 'SAU', 'al-Khudud al-Samaliy');
INSERT INTO `city` VALUES ('3193', 'al-Qatif', 'SAU', 'al-Sharqiya');
INSERT INTO `city` VALUES ('3194', 'al-Hawiya', 'SAU', 'Mekka');
INSERT INTO `city` VALUES ('3195', 'Unayza', 'SAU', 'Qasim');
INSERT INTO `city` VALUES ('3196', 'Najran', 'SAU', 'Najran');
INSERT INTO `city` VALUES ('3197', 'Pikine', 'SEN', 'Cap-Vert');
INSERT INTO `city` VALUES ('3198', 'Dakar', 'SEN', 'Cap-Vert');
INSERT INTO `city` VALUES ('3199', 'Thiès', 'SEN', 'Thiès');
INSERT INTO `city` VALUES ('3200', 'Kaolack', 'SEN', 'Kaolack');
INSERT INTO `city` VALUES ('3201', 'Ziguinchor', 'SEN', 'Ziguinchor');
INSERT INTO `city` VALUES ('3202', 'Rufisque', 'SEN', 'Cap-Vert');
INSERT INTO `city` VALUES ('3203', 'Saint-Louis', 'SEN', 'Saint-Louis');
INSERT INTO `city` VALUES ('3204', 'Mbour', 'SEN', 'Thiès');
INSERT INTO `city` VALUES ('3205', 'Diourbel', 'SEN', 'Diourbel');
INSERT INTO `city` VALUES ('3206', 'Victoria', 'SYC', 'Mahé');
INSERT INTO `city` VALUES ('3207', 'Freetown', 'SLE', 'Western');
INSERT INTO `city` VALUES ('3208', 'Singapore', 'SGP', '–');
INSERT INTO `city` VALUES ('3209', 'Bratislava', 'SVK', 'Bratislava');
INSERT INTO `city` VALUES ('3210', 'Košice', 'SVK', 'Východné Slovensko');
INSERT INTO `city` VALUES ('3211', 'Prešov', 'SVK', 'Východné Slovensko');
INSERT INTO `city` VALUES ('3212', 'Ljubljana', 'SVN', 'Osrednjeslovenska');
INSERT INTO `city` VALUES ('3213', 'Maribor', 'SVN', 'Podravska');
INSERT INTO `city` VALUES ('3214', 'Mogadishu', 'SOM', 'Banaadir');
INSERT INTO `city` VALUES ('3215', 'Hargeysa', 'SOM', 'Woqooyi Galbeed');
INSERT INTO `city` VALUES ('3216', 'Kismaayo', 'SOM', 'Jubbada Hoose');
INSERT INTO `city` VALUES ('3217', 'Colombo', 'LKA', 'Western');
INSERT INTO `city` VALUES ('3218', 'Dehiwala', 'LKA', 'Western');
INSERT INTO `city` VALUES ('3219', 'Moratuwa', 'LKA', 'Western');
INSERT INTO `city` VALUES ('3220', 'Jaffna', 'LKA', 'Northern');
INSERT INTO `city` VALUES ('3221', 'Kandy', 'LKA', 'Central');
INSERT INTO `city` VALUES ('3222', 'Sri Jayawardenepura Kotte', 'LKA', 'Western');
INSERT INTO `city` VALUES ('3223', 'Negombo', 'LKA', 'Western');
INSERT INTO `city` VALUES ('3224', 'Omdurman', 'SDN', 'Khartum');
INSERT INTO `city` VALUES ('3225', 'Khartum', 'SDN', 'Khartum');
INSERT INTO `city` VALUES ('3226', 'Sharq al-Nil', 'SDN', 'Khartum');
INSERT INTO `city` VALUES ('3227', 'Port Sudan', 'SDN', 'al-Bahr al-Ahmar');
INSERT INTO `city` VALUES ('3228', 'Kassala', 'SDN', 'Kassala');
INSERT INTO `city` VALUES ('3229', 'Obeid', 'SDN', 'Kurdufan al-Shamaliy');
INSERT INTO `city` VALUES ('3230', 'Nyala', 'SDN', 'Darfur al-Janubiya');
INSERT INTO `city` VALUES ('3231', 'Wad Madani', 'SDN', 'al-Jazira');
INSERT INTO `city` VALUES ('3232', 'al-Qadarif', 'SDN', 'al-Qadarif');
INSERT INTO `city` VALUES ('3233', 'Kusti', 'SDN', 'al-Bahr al-Abyad');
INSERT INTO `city` VALUES ('3234', 'al-Fashir', 'SDN', 'Darfur al-Shamaliya');
INSERT INTO `city` VALUES ('3235', 'Juba', 'SDN', 'Bahr al-Jabal');
INSERT INTO `city` VALUES ('3236', 'Helsinki [Helsingfors]', 'FIN', 'Newmaa');
INSERT INTO `city` VALUES ('3237', 'Espoo', 'FIN', 'Newmaa');
INSERT INTO `city` VALUES ('3238', 'Tampere', 'FIN', 'Pirkanmaa');
INSERT INTO `city` VALUES ('3239', 'Vantaa', 'FIN', 'Newmaa');
INSERT INTO `city` VALUES ('3240', 'Turku [Åbo]', 'FIN', 'Varsinais-Suomi');
INSERT INTO `city` VALUES ('3241', 'Oulu', 'FIN', 'Pohjois-Pohjanmaa');
INSERT INTO `city` VALUES ('3242', 'Lahti', 'FIN', 'Päijät-Häme');
INSERT INTO `city` VALUES ('3243', 'Paramaribo', 'SUR', 'Paramaribo');
INSERT INTO `city` VALUES ('3244', 'Mbabane', 'SWZ', 'Hhohho');
INSERT INTO `city` VALUES ('3245', 'Zürich', 'CHE', 'Zürich');
INSERT INTO `city` VALUES ('3246', 'Geneve', 'CHE', 'Geneve');
INSERT INTO `city` VALUES ('3247', 'Basel', 'CHE', 'Basel-Stadt');
INSERT INTO `city` VALUES ('3248', 'Bern', 'CHE', 'Bern');
INSERT INTO `city` VALUES ('3249', 'Lausanne', 'CHE', 'Vaud');
INSERT INTO `city` VALUES ('3250', 'Damascus', 'SYR', 'Damascus');
INSERT INTO `city` VALUES ('3251', 'Aleppo', 'SYR', 'Aleppo');
INSERT INTO `city` VALUES ('3252', 'Hims', 'SYR', 'Hims');
INSERT INTO `city` VALUES ('3253', 'Hama', 'SYR', 'Hama');
INSERT INTO `city` VALUES ('3254', 'Latakia', 'SYR', 'Latakia');
INSERT INTO `city` VALUES ('3255', 'al-Qamishliya', 'SYR', 'al-Hasaka');
INSERT INTO `city` VALUES ('3256', 'Dayr al-Zawr', 'SYR', 'Dayr al-Zawr');
INSERT INTO `city` VALUES ('3257', 'Jaramana', 'SYR', 'Damaskos');
INSERT INTO `city` VALUES ('3258', 'Duma', 'SYR', 'Damaskos');
INSERT INTO `city` VALUES ('3259', 'al-Raqqa', 'SYR', 'al-Raqqa');
INSERT INTO `city` VALUES ('3260', 'Idlib', 'SYR', 'Idlib');
INSERT INTO `city` VALUES ('3261', 'Dushanbe', 'TJK', 'Karotegin');
INSERT INTO `city` VALUES ('3262', 'Khujand', 'TJK', 'Khujand');
INSERT INTO `city` VALUES ('3263', 'Taipei', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3264', 'Kaohsiung', 'TWN', 'Kaohsiung');
INSERT INTO `city` VALUES ('3265', 'Taichung', 'TWN', 'Taichung');
INSERT INTO `city` VALUES ('3266', 'Tainan', 'TWN', 'Tainan');
INSERT INTO `city` VALUES ('3267', 'Panchiao', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3268', 'Chungho', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3269', 'Keelung (Chilung)', 'TWN', 'Keelung');
INSERT INTO `city` VALUES ('3270', 'Sanchung', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3271', 'Hsinchuang', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3272', 'Hsinchu', 'TWN', 'Hsinchu');
INSERT INTO `city` VALUES ('3273', 'Chungli', 'TWN', 'Taoyuan');
INSERT INTO `city` VALUES ('3274', 'Fengshan', 'TWN', 'Kaohsiung');
INSERT INTO `city` VALUES ('3275', 'Taoyuan', 'TWN', 'Taoyuan');
INSERT INTO `city` VALUES ('3276', 'Chiayi', 'TWN', 'Chiayi');
INSERT INTO `city` VALUES ('3277', 'Hsintien', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3278', 'Changhwa', 'TWN', 'Changhwa');
INSERT INTO `city` VALUES ('3279', 'Yungho', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3280', 'Tucheng', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3281', 'Pingtung', 'TWN', 'Pingtung');
INSERT INTO `city` VALUES ('3282', 'Yungkang', 'TWN', 'Tainan');
INSERT INTO `city` VALUES ('3283', 'Pingchen', 'TWN', 'Taoyuan');
INSERT INTO `city` VALUES ('3284', 'Tali', 'TWN', 'Taichung');
INSERT INTO `city` VALUES ('3285', 'Taiping', 'TWN', '');
INSERT INTO `city` VALUES ('3286', 'Pate', 'TWN', 'Taoyuan');
INSERT INTO `city` VALUES ('3287', 'Fengyuan', 'TWN', 'Taichung');
INSERT INTO `city` VALUES ('3288', 'Luchou', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3289', 'Hsichuh', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3290', 'Shulin', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3291', 'Yuanlin', 'TWN', 'Changhwa');
INSERT INTO `city` VALUES ('3292', 'Yangmei', 'TWN', 'Taoyuan');
INSERT INTO `city` VALUES ('3293', 'Taliao', 'TWN', '');
INSERT INTO `city` VALUES ('3294', 'Kueishan', 'TWN', '');
INSERT INTO `city` VALUES ('3295', 'Tanshui', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3296', 'Taitung', 'TWN', 'Taitung');
INSERT INTO `city` VALUES ('3297', 'Hualien', 'TWN', 'Hualien');
INSERT INTO `city` VALUES ('3298', 'Nantou', 'TWN', 'Nantou');
INSERT INTO `city` VALUES ('3299', 'Lungtan', 'TWN', 'Taipei');
INSERT INTO `city` VALUES ('3300', 'Touliu', 'TWN', 'Yünlin');
INSERT INTO `city` VALUES ('3301', 'Tsaotun', 'TWN', 'Nantou');
INSERT INTO `city` VALUES ('3302', 'Kangshan', 'TWN', 'Kaohsiung');
INSERT INTO `city` VALUES ('3303', 'Ilan', 'TWN', 'Ilan');
INSERT INTO `city` VALUES ('3304', 'Miaoli', 'TWN', 'Miaoli');
INSERT INTO `city` VALUES ('3305', 'Dar es Salaam', 'TZA', 'Dar es Salaam');
INSERT INTO `city` VALUES ('3306', 'Dodoma', 'TZA', 'Dodoma');
INSERT INTO `city` VALUES ('3307', 'Mwanza', 'TZA', 'Mwanza');
INSERT INTO `city` VALUES ('3308', 'Zanzibar', 'TZA', 'Zanzibar West');
INSERT INTO `city` VALUES ('3309', 'Tanga', 'TZA', 'Tanga');
INSERT INTO `city` VALUES ('3310', 'Mbeya', 'TZA', 'Mbeya');
INSERT INTO `city` VALUES ('3311', 'Morogoro', 'TZA', 'Morogoro');
INSERT INTO `city` VALUES ('3312', 'Arusha', 'TZA', 'Arusha');
INSERT INTO `city` VALUES ('3313', 'Moshi', 'TZA', 'Kilimanjaro');
INSERT INTO `city` VALUES ('3314', 'Tabora', 'TZA', 'Tabora');
INSERT INTO `city` VALUES ('3315', 'København', 'DNK', 'København');
INSERT INTO `city` VALUES ('3316', 'Århus', 'DNK', 'Århus');
INSERT INTO `city` VALUES ('3317', 'Odense', 'DNK', 'Fyn');
INSERT INTO `city` VALUES ('3318', 'Aalborg', 'DNK', 'Nordjylland');
INSERT INTO `city` VALUES ('3319', 'Frederiksberg', 'DNK', 'Frederiksberg');
INSERT INTO `city` VALUES ('3320', 'Bangkok', 'THA', 'Bangkok');
INSERT INTO `city` VALUES ('3321', 'Nonthaburi', 'THA', 'Nonthaburi');
INSERT INTO `city` VALUES ('3322', 'Nakhon Ratchasima', 'THA', 'Nakhon Ratchasima');
INSERT INTO `city` VALUES ('3323', 'Chiang Mai', 'THA', 'Chiang Mai');
INSERT INTO `city` VALUES ('3324', 'Udon Thani', 'THA', 'Udon Thani');
INSERT INTO `city` VALUES ('3325', 'Hat Yai', 'THA', 'Songkhla');
INSERT INTO `city` VALUES ('3326', 'Khon Kaen', 'THA', 'Khon Kaen');
INSERT INTO `city` VALUES ('3327', 'Pak Kret', 'THA', 'Nonthaburi');
INSERT INTO `city` VALUES ('3328', 'Nakhon Sawan', 'THA', 'Nakhon Sawan');
INSERT INTO `city` VALUES ('3329', 'Ubon Ratchathani', 'THA', 'Ubon Ratchathani');
INSERT INTO `city` VALUES ('3330', 'Songkhla', 'THA', 'Songkhla');
INSERT INTO `city` VALUES ('3331', 'Nakhon Pathom', 'THA', 'Nakhon Pathom');
INSERT INTO `city` VALUES ('3332', 'Lomé', 'TGO', 'Maritime');
INSERT INTO `city` VALUES ('3333', 'Fakaofo', 'TKL', 'Fakaofo');
INSERT INTO `city` VALUES ('3334', 'Nuku´alofa', 'TON', 'Tongatapu');
INSERT INTO `city` VALUES ('3335', 'Chaguanas', 'TTO', 'Caroni');
INSERT INTO `city` VALUES ('3336', 'Port-of-Spain', 'TTO', 'Port-of-Spain');
INSERT INTO `city` VALUES ('3337', 'N´Djaména', 'TCD', 'Chari-Baguirmi');
INSERT INTO `city` VALUES ('3338', 'Moundou', 'TCD', 'Logone Occidental');
INSERT INTO `city` VALUES ('3339', 'Praha', 'CZE', 'Hlavní mesto Praha');
INSERT INTO `city` VALUES ('3340', 'Brno', 'CZE', 'Jizní Morava');
INSERT INTO `city` VALUES ('3341', 'Ostrava', 'CZE', 'Severní Morava');
INSERT INTO `city` VALUES ('3342', 'Plzen', 'CZE', 'Zapadní Cechy');
INSERT INTO `city` VALUES ('3343', 'Olomouc', 'CZE', 'Severní Morava');
INSERT INTO `city` VALUES ('3344', 'Liberec', 'CZE', 'Severní Cechy');
INSERT INTO `city` VALUES ('3345', 'Ceské Budejovice', 'CZE', 'Jizní Cechy');
INSERT INTO `city` VALUES ('3346', 'Hradec Králové', 'CZE', 'Východní Cechy');
INSERT INTO `city` VALUES ('3347', 'Ústí nad Labem', 'CZE', 'Severní Cechy');
INSERT INTO `city` VALUES ('3348', 'Pardubice', 'CZE', 'Východní Cechy');
INSERT INTO `city` VALUES ('3349', 'Tunis', 'TUN', 'Tunis');
INSERT INTO `city` VALUES ('3350', 'Sfax', 'TUN', 'Sfax');
INSERT INTO `city` VALUES ('3351', 'Ariana', 'TUN', 'Ariana');
INSERT INTO `city` VALUES ('3352', 'Ettadhamen', 'TUN', 'Ariana');
INSERT INTO `city` VALUES ('3353', 'Sousse', 'TUN', 'Sousse');
INSERT INTO `city` VALUES ('3354', 'Kairouan', 'TUN', 'Kairouan');
INSERT INTO `city` VALUES ('3355', 'Biserta', 'TUN', 'Biserta');
INSERT INTO `city` VALUES ('3356', 'Gabès', 'TUN', 'Gabès');
INSERT INTO `city` VALUES ('3357', 'Istanbul', 'TUR', 'Istanbul');
INSERT INTO `city` VALUES ('3358', 'Ankara', 'TUR', 'Ankara');
INSERT INTO `city` VALUES ('3359', 'Izmir', 'TUR', 'Izmir');
INSERT INTO `city` VALUES ('3360', 'Adana', 'TUR', 'Adana');
INSERT INTO `city` VALUES ('3361', 'Bursa', 'TUR', 'Bursa');
INSERT INTO `city` VALUES ('3362', 'Gaziantep', 'TUR', 'Gaziantep');
INSERT INTO `city` VALUES ('3363', 'Konya', 'TUR', 'Konya');
INSERT INTO `city` VALUES ('3364', 'Mersin (Içel)', 'TUR', 'Içel');
INSERT INTO `city` VALUES ('3365', 'Antalya', 'TUR', 'Antalya');
INSERT INTO `city` VALUES ('3366', 'Diyarbakir', 'TUR', 'Diyarbakir');
INSERT INTO `city` VALUES ('3367', 'Kayseri', 'TUR', 'Kayseri');
INSERT INTO `city` VALUES ('3368', 'Eskisehir', 'TUR', 'Eskisehir');
INSERT INTO `city` VALUES ('3369', 'Sanliurfa', 'TUR', 'Sanliurfa');
INSERT INTO `city` VALUES ('3370', 'Samsun', 'TUR', 'Samsun');
INSERT INTO `city` VALUES ('3371', 'Malatya', 'TUR', 'Malatya');
INSERT INTO `city` VALUES ('3372', 'Gebze', 'TUR', 'Kocaeli');
INSERT INTO `city` VALUES ('3373', 'Denizli', 'TUR', 'Denizli');
INSERT INTO `city` VALUES ('3374', 'Sivas', 'TUR', 'Sivas');
INSERT INTO `city` VALUES ('3375', 'Erzurum', 'TUR', 'Erzurum');
INSERT INTO `city` VALUES ('3376', 'Tarsus', 'TUR', 'Adana');
INSERT INTO `city` VALUES ('3377', 'Kahramanmaras', 'TUR', 'Kahramanmaras');
INSERT INTO `city` VALUES ('3378', 'Elâzig', 'TUR', 'Elâzig');
INSERT INTO `city` VALUES ('3379', 'Van', 'TUR', 'Van');
INSERT INTO `city` VALUES ('3380', 'Sultanbeyli', 'TUR', 'Istanbul');
INSERT INTO `city` VALUES ('3381', 'Izmit (Kocaeli)', 'TUR', 'Kocaeli');
INSERT INTO `city` VALUES ('3382', 'Manisa', 'TUR', 'Manisa');
INSERT INTO `city` VALUES ('3383', 'Batman', 'TUR', 'Batman');
INSERT INTO `city` VALUES ('3384', 'Balikesir', 'TUR', 'Balikesir');
INSERT INTO `city` VALUES ('3385', 'Sakarya (Adapazari)', 'TUR', 'Sakarya');
INSERT INTO `city` VALUES ('3386', 'Iskenderun', 'TUR', 'Hatay');
INSERT INTO `city` VALUES ('3387', 'Osmaniye', 'TUR', 'Osmaniye');
INSERT INTO `city` VALUES ('3388', 'Çorum', 'TUR', 'Çorum');
INSERT INTO `city` VALUES ('3389', 'Kütahya', 'TUR', 'Kütahya');
INSERT INTO `city` VALUES ('3390', 'Hatay (Antakya)', 'TUR', 'Hatay');
INSERT INTO `city` VALUES ('3391', 'Kirikkale', 'TUR', 'Kirikkale');
INSERT INTO `city` VALUES ('3392', 'Adiyaman', 'TUR', 'Adiyaman');
INSERT INTO `city` VALUES ('3393', 'Trabzon', 'TUR', 'Trabzon');
INSERT INTO `city` VALUES ('3394', 'Ordu', 'TUR', 'Ordu');
INSERT INTO `city` VALUES ('3395', 'Aydin', 'TUR', 'Aydin');
INSERT INTO `city` VALUES ('3396', 'Usak', 'TUR', 'Usak');
INSERT INTO `city` VALUES ('3397', 'Edirne', 'TUR', 'Edirne');
INSERT INTO `city` VALUES ('3398', 'Çorlu', 'TUR', 'Tekirdag');
INSERT INTO `city` VALUES ('3399', 'Isparta', 'TUR', 'Isparta');
INSERT INTO `city` VALUES ('3400', 'Karabük', 'TUR', 'Karabük');
INSERT INTO `city` VALUES ('3401', 'Kilis', 'TUR', 'Kilis');
INSERT INTO `city` VALUES ('3402', 'Alanya', 'TUR', 'Antalya');
INSERT INTO `city` VALUES ('3403', 'Kiziltepe', 'TUR', 'Mardin');
INSERT INTO `city` VALUES ('3404', 'Zonguldak', 'TUR', 'Zonguldak');
INSERT INTO `city` VALUES ('3405', 'Siirt', 'TUR', 'Siirt');
INSERT INTO `city` VALUES ('3406', 'Viransehir', 'TUR', 'Sanliurfa');
INSERT INTO `city` VALUES ('3407', 'Tekirdag', 'TUR', 'Tekirdag');
INSERT INTO `city` VALUES ('3408', 'Karaman', 'TUR', 'Karaman');
INSERT INTO `city` VALUES ('3409', 'Afyon', 'TUR', 'Afyon');
INSERT INTO `city` VALUES ('3410', 'Aksaray', 'TUR', 'Aksaray');
INSERT INTO `city` VALUES ('3411', 'Ceyhan', 'TUR', 'Adana');
INSERT INTO `city` VALUES ('3412', 'Erzincan', 'TUR', 'Erzincan');
INSERT INTO `city` VALUES ('3413', 'Bismil', 'TUR', 'Diyarbakir');
INSERT INTO `city` VALUES ('3414', 'Nazilli', 'TUR', 'Aydin');
INSERT INTO `city` VALUES ('3415', 'Tokat', 'TUR', 'Tokat');
INSERT INTO `city` VALUES ('3416', 'Kars', 'TUR', 'Kars');
INSERT INTO `city` VALUES ('3417', 'Inegöl', 'TUR', 'Bursa');
INSERT INTO `city` VALUES ('3418', 'Bandirma', 'TUR', 'Balikesir');
INSERT INTO `city` VALUES ('3419', 'Ashgabat', 'TKM', 'Ahal');
INSERT INTO `city` VALUES ('3420', 'Chärjew', 'TKM', 'Lebap');
INSERT INTO `city` VALUES ('3421', 'Dashhowuz', 'TKM', 'Dashhowuz');
INSERT INTO `city` VALUES ('3422', 'Mary', 'TKM', 'Mary');
INSERT INTO `city` VALUES ('3423', 'Cockburn Town', 'TCA', 'Grand Turk');
INSERT INTO `city` VALUES ('3424', 'Funafuti', 'TUV', 'Funafuti');
INSERT INTO `city` VALUES ('3425', 'Kampala', 'UGA', 'Central');
INSERT INTO `city` VALUES ('3426', 'Kyiv', 'UKR', 'Kiova');
INSERT INTO `city` VALUES ('3427', 'Harkova [Harkiv]', 'UKR', 'Harkova');
INSERT INTO `city` VALUES ('3428', 'Dnipropetrovsk', 'UKR', 'Dnipropetrovsk');
INSERT INTO `city` VALUES ('3429', 'Donetsk', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3430', 'Odesa', 'UKR', 'Odesa');
INSERT INTO `city` VALUES ('3431', 'Zaporizzja', 'UKR', 'Zaporizzja');
INSERT INTO `city` VALUES ('3432', 'Lviv', 'UKR', 'Lviv');
INSERT INTO `city` VALUES ('3433', 'Kryvyi Rig', 'UKR', 'Dnipropetrovsk');
INSERT INTO `city` VALUES ('3434', 'Mykolajiv', 'UKR', 'Mykolajiv');
INSERT INTO `city` VALUES ('3435', 'Mariupol', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3436', 'Lugansk', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3437', 'Vinnytsja', 'UKR', 'Vinnytsja');
INSERT INTO `city` VALUES ('3438', 'Makijivka', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3439', 'Herson', 'UKR', 'Herson');
INSERT INTO `city` VALUES ('3440', 'Sevastopol', 'UKR', 'Krim');
INSERT INTO `city` VALUES ('3441', 'Simferopol', 'UKR', 'Krim');
INSERT INTO `city` VALUES ('3442', 'Pultava [Poltava]', 'UKR', 'Pultava');
INSERT INTO `city` VALUES ('3443', 'Tšernigiv', 'UKR', 'Tšernigiv');
INSERT INTO `city` VALUES ('3444', 'Tšerkasy', 'UKR', 'Tšerkasy');
INSERT INTO `city` VALUES ('3445', 'Gorlivka', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3446', 'Zytomyr', 'UKR', 'Zytomyr');
INSERT INTO `city` VALUES ('3447', 'Sumy', 'UKR', 'Sumy');
INSERT INTO `city` VALUES ('3448', 'Dniprodzerzynsk', 'UKR', 'Dnipropetrovsk');
INSERT INTO `city` VALUES ('3449', 'Kirovograd', 'UKR', 'Kirovograd');
INSERT INTO `city` VALUES ('3450', 'Hmelnytskyi', 'UKR', 'Hmelnytskyi');
INSERT INTO `city` VALUES ('3451', 'Tšernivtsi', 'UKR', 'Tšernivtsi');
INSERT INTO `city` VALUES ('3452', 'Rivne', 'UKR', 'Rivne');
INSERT INTO `city` VALUES ('3453', 'Krementšuk', 'UKR', 'Pultava');
INSERT INTO `city` VALUES ('3454', 'Ivano-Frankivsk', 'UKR', 'Ivano-Frankivsk');
INSERT INTO `city` VALUES ('3455', 'Ternopil', 'UKR', 'Ternopil');
INSERT INTO `city` VALUES ('3456', 'Lutsk', 'UKR', 'Volynia');
INSERT INTO `city` VALUES ('3457', 'Bila Tserkva', 'UKR', 'Kiova');
INSERT INTO `city` VALUES ('3458', 'Kramatorsk', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3459', 'Melitopol', 'UKR', 'Zaporizzja');
INSERT INTO `city` VALUES ('3460', 'Kertš', 'UKR', 'Krim');
INSERT INTO `city` VALUES ('3461', 'Nikopol', 'UKR', 'Dnipropetrovsk');
INSERT INTO `city` VALUES ('3462', 'Berdjansk', 'UKR', 'Zaporizzja');
INSERT INTO `city` VALUES ('3463', 'Pavlograd', 'UKR', 'Dnipropetrovsk');
INSERT INTO `city` VALUES ('3464', 'Sjeverodonetsk', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3465', 'Slovjansk', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3466', 'Uzgorod', 'UKR', 'Taka-Karpatia');
INSERT INTO `city` VALUES ('3467', 'Altševsk', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3468', 'Lysytšansk', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3469', 'Jevpatorija', 'UKR', 'Krim');
INSERT INTO `city` VALUES ('3470', 'Kamjanets-Podilskyi', 'UKR', 'Hmelnytskyi');
INSERT INTO `city` VALUES ('3471', 'Jenakijeve', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3472', 'Krasnyi Lutš', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3473', 'Stahanov', 'UKR', 'Lugansk');
INSERT INTO `city` VALUES ('3474', 'Oleksandrija', 'UKR', 'Kirovograd');
INSERT INTO `city` VALUES ('3475', 'Konotop', 'UKR', 'Sumy');
INSERT INTO `city` VALUES ('3476', 'Kostjantynivka', 'UKR', 'Donetsk');
INSERT INTO `city` VALUES ('3477', 'Berdytšiv', 'UKR', 'Zytomyr');
INSERT INTO `city` VALUES ('3478', 'Izmajil', 'UKR', 'Odesa');
INSERT INTO `city` VALUES ('3479', 'Šostka', 'UKR', 'Sumy');
INSERT INTO `city` VALUES ('3480', 'Uman', 'UKR', 'Tšerkasy');
INSERT INTO `city` VALUES ('3481', 'Brovary', 'UKR', 'Kiova');
INSERT INTO `city` VALUES ('3482', 'Mukatševe', 'UKR', 'Taka-Karpatia');
INSERT INTO `city` VALUES ('3483', 'Budapest', 'HUN', 'Budapest');
INSERT INTO `city` VALUES ('3484', 'Debrecen', 'HUN', 'Hajdú-Bihar');
INSERT INTO `city` VALUES ('3485', 'Miskolc', 'HUN', 'Borsod-Abaúj-Zemplén');
INSERT INTO `city` VALUES ('3486', 'Szeged', 'HUN', 'Csongrád');
INSERT INTO `city` VALUES ('3487', 'Pécs', 'HUN', 'Baranya');
INSERT INTO `city` VALUES ('3488', 'Györ', 'HUN', 'Györ-Moson-Sopron');
INSERT INTO `city` VALUES ('3489', 'Nyiregyháza', 'HUN', 'Szabolcs-Szatmár-Ber');
INSERT INTO `city` VALUES ('3490', 'Kecskemét', 'HUN', 'Bács-Kiskun');
INSERT INTO `city` VALUES ('3491', 'Székesfehérvár', 'HUN', 'Fejér');
INSERT INTO `city` VALUES ('3492', 'Montevideo', 'URY', 'Montevideo');
INSERT INTO `city` VALUES ('3493', 'Nouméa', 'NCL', '–');
INSERT INTO `city` VALUES ('3494', 'Auckland', 'NZL', 'Auckland');
INSERT INTO `city` VALUES ('3495', 'Christchurch', 'NZL', 'Canterbury');
INSERT INTO `city` VALUES ('3496', 'Manukau', 'NZL', 'Auckland');
INSERT INTO `city` VALUES ('3497', 'North Shore', 'NZL', 'Auckland');
INSERT INTO `city` VALUES ('3498', 'Waitakere', 'NZL', 'Auckland');
INSERT INTO `city` VALUES ('3499', 'Wellington', 'NZL', 'Wellington');
INSERT INTO `city` VALUES ('3500', 'Dunedin', 'NZL', 'Dunedin');
INSERT INTO `city` VALUES ('3501', 'Hamilton', 'NZL', 'Hamilton');
INSERT INTO `city` VALUES ('3502', 'Lower Hutt', 'NZL', 'Wellington');
INSERT INTO `city` VALUES ('3503', 'Toskent', 'UZB', 'Toskent Shahri');
INSERT INTO `city` VALUES ('3504', 'Namangan', 'UZB', 'Namangan');
INSERT INTO `city` VALUES ('3505', 'Samarkand', 'UZB', 'Samarkand');
INSERT INTO `city` VALUES ('3506', 'Andijon', 'UZB', 'Andijon');
INSERT INTO `city` VALUES ('3507', 'Buhoro', 'UZB', 'Buhoro');
INSERT INTO `city` VALUES ('3508', 'Karsi', 'UZB', 'Qashqadaryo');
INSERT INTO `city` VALUES ('3509', 'Nukus', 'UZB', 'Karakalpakistan');
INSERT INTO `city` VALUES ('3510', 'Kükon', 'UZB', 'Fargona');
INSERT INTO `city` VALUES ('3511', 'Fargona', 'UZB', 'Fargona');
INSERT INTO `city` VALUES ('3512', 'Circik', 'UZB', 'Toskent');
INSERT INTO `city` VALUES ('3513', 'Margilon', 'UZB', 'Fargona');
INSERT INTO `city` VALUES ('3514', 'Ürgenc', 'UZB', 'Khorazm');
INSERT INTO `city` VALUES ('3515', 'Angren', 'UZB', 'Toskent');
INSERT INTO `city` VALUES ('3516', 'Cizah', 'UZB', 'Cizah');
INSERT INTO `city` VALUES ('3517', 'Navoi', 'UZB', 'Navoi');
INSERT INTO `city` VALUES ('3518', 'Olmalik', 'UZB', 'Toskent');
INSERT INTO `city` VALUES ('3519', 'Termiz', 'UZB', 'Surkhondaryo');
INSERT INTO `city` VALUES ('3520', 'Minsk', 'BLR', 'Horad Minsk');
INSERT INTO `city` VALUES ('3521', 'Gomel', 'BLR', 'Gomel');
INSERT INTO `city` VALUES ('3522', 'Mogiljov', 'BLR', 'Mogiljov');
INSERT INTO `city` VALUES ('3523', 'Vitebsk', 'BLR', 'Vitebsk');
INSERT INTO `city` VALUES ('3524', 'Grodno', 'BLR', 'Grodno');
INSERT INTO `city` VALUES ('3525', 'Brest', 'BLR', 'Brest');
INSERT INTO `city` VALUES ('3526', 'Bobruisk', 'BLR', 'Mogiljov');
INSERT INTO `city` VALUES ('3527', 'Baranovitši', 'BLR', 'Brest');
INSERT INTO `city` VALUES ('3528', 'Borisov', 'BLR', 'Minsk');
INSERT INTO `city` VALUES ('3529', 'Pinsk', 'BLR', 'Brest');
INSERT INTO `city` VALUES ('3530', 'Orša', 'BLR', 'Vitebsk');
INSERT INTO `city` VALUES ('3531', 'Mozyr', 'BLR', 'Gomel');
INSERT INTO `city` VALUES ('3532', 'Novopolotsk', 'BLR', 'Vitebsk');
INSERT INTO `city` VALUES ('3533', 'Lida', 'BLR', 'Grodno');
INSERT INTO `city` VALUES ('3534', 'Soligorsk', 'BLR', 'Minsk');
INSERT INTO `city` VALUES ('3535', 'Molodetšno', 'BLR', 'Minsk');
INSERT INTO `city` VALUES ('3536', 'Mata-Utu', 'WLF', 'Wallis');
INSERT INTO `city` VALUES ('3537', 'Port-Vila', 'VUT', 'Shefa');
INSERT INTO `city` VALUES ('3538', 'Città del Vaticano', 'VAT', '–');
INSERT INTO `city` VALUES ('3539', 'Caracas', 'VEN', 'Distrito Federal');
INSERT INTO `city` VALUES ('3540', 'Maracaíbo', 'VEN', 'Zulia');
INSERT INTO `city` VALUES ('3541', 'Barquisimeto', 'VEN', 'Lara');
INSERT INTO `city` VALUES ('3542', 'Valencia', 'VEN', 'Carabobo');
INSERT INTO `city` VALUES ('3543', 'Ciudad Guayana', 'VEN', 'Bolívar');
INSERT INTO `city` VALUES ('3544', 'Petare', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3545', 'Maracay', 'VEN', 'Aragua');
INSERT INTO `city` VALUES ('3546', 'Barcelona', 'VEN', 'Anzoátegui');
INSERT INTO `city` VALUES ('3547', 'Maturín', 'VEN', 'Monagas');
INSERT INTO `city` VALUES ('3548', 'San Cristóbal', 'VEN', 'Táchira');
INSERT INTO `city` VALUES ('3549', 'Ciudad Bolívar', 'VEN', 'Bolívar');
INSERT INTO `city` VALUES ('3550', 'Cumaná', 'VEN', 'Sucre');
INSERT INTO `city` VALUES ('3551', 'Mérida', 'VEN', 'Mérida');
INSERT INTO `city` VALUES ('3552', 'Cabimas', 'VEN', 'Zulia');
INSERT INTO `city` VALUES ('3553', 'Barinas', 'VEN', 'Barinas');
INSERT INTO `city` VALUES ('3554', 'Turmero', 'VEN', 'Aragua');
INSERT INTO `city` VALUES ('3555', 'Baruta', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3556', 'Puerto Cabello', 'VEN', 'Carabobo');
INSERT INTO `city` VALUES ('3557', 'Santa Ana de Coro', 'VEN', 'Falcón');
INSERT INTO `city` VALUES ('3558', 'Los Teques', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3559', 'Punto Fijo', 'VEN', 'Falcón');
INSERT INTO `city` VALUES ('3560', 'Guarenas', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3561', 'Acarigua', 'VEN', 'Portuguesa');
INSERT INTO `city` VALUES ('3562', 'Puerto La Cruz', 'VEN', 'Anzoátegui');
INSERT INTO `city` VALUES ('3563', 'Ciudad Losada', 'VEN', '');
INSERT INTO `city` VALUES ('3564', 'Guacara', 'VEN', 'Carabobo');
INSERT INTO `city` VALUES ('3565', 'Valera', 'VEN', 'Trujillo');
INSERT INTO `city` VALUES ('3566', 'Guanare', 'VEN', 'Portuguesa');
INSERT INTO `city` VALUES ('3567', 'Carúpano', 'VEN', 'Sucre');
INSERT INTO `city` VALUES ('3568', 'Catia La Mar', 'VEN', 'Distrito Federal');
INSERT INTO `city` VALUES ('3569', 'El Tigre', 'VEN', 'Anzoátegui');
INSERT INTO `city` VALUES ('3570', 'Guatire', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3571', 'Calabozo', 'VEN', 'Guárico');
INSERT INTO `city` VALUES ('3572', 'Pozuelos', 'VEN', 'Anzoátegui');
INSERT INTO `city` VALUES ('3573', 'Ciudad Ojeda', 'VEN', 'Zulia');
INSERT INTO `city` VALUES ('3574', 'Ocumare del Tuy', 'VEN', 'Miranda');
INSERT INTO `city` VALUES ('3575', 'Valle de la Pascua', 'VEN', 'Guárico');
INSERT INTO `city` VALUES ('3576', 'Araure', 'VEN', 'Portuguesa');
INSERT INTO `city` VALUES ('3577', 'San Fernando de Apure', 'VEN', 'Apure');
INSERT INTO `city` VALUES ('3578', 'San Felipe', 'VEN', 'Yaracuy');
INSERT INTO `city` VALUES ('3579', 'El Limón', 'VEN', 'Aragua');
INSERT INTO `city` VALUES ('3580', 'Moscow', 'RUS', 'Moscow (City)');
INSERT INTO `city` VALUES ('3581', 'St Petersburg', 'RUS', 'Pietari');
INSERT INTO `city` VALUES ('3582', 'Novosibirsk', 'RUS', 'Novosibirsk');
INSERT INTO `city` VALUES ('3583', 'Nizni Novgorod', 'RUS', 'Nizni Novgorod');
INSERT INTO `city` VALUES ('3584', 'Jekaterinburg', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3585', 'Samara', 'RUS', 'Samara');
INSERT INTO `city` VALUES ('3586', 'Omsk', 'RUS', 'Omsk');
INSERT INTO `city` VALUES ('3587', 'Kazan', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3588', 'Ufa', 'RUS', 'Baškortostan');
INSERT INTO `city` VALUES ('3589', 'Tšeljabinsk', 'RUS', 'Tšeljabinsk');
INSERT INTO `city` VALUES ('3590', 'Rostov-na-Donu', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3591', 'Perm', 'RUS', 'Perm');
INSERT INTO `city` VALUES ('3592', 'Volgograd', 'RUS', 'Volgograd');
INSERT INTO `city` VALUES ('3593', 'Voronez', 'RUS', 'Voronez');
INSERT INTO `city` VALUES ('3594', 'Krasnojarsk', 'RUS', 'Krasnojarsk');
INSERT INTO `city` VALUES ('3595', 'Saratov', 'RUS', 'Saratov');
INSERT INTO `city` VALUES ('3596', 'Toljatti', 'RUS', 'Samara');
INSERT INTO `city` VALUES ('3597', 'Uljanovsk', 'RUS', 'Uljanovsk');
INSERT INTO `city` VALUES ('3598', 'Izevsk', 'RUS', 'Udmurtia');
INSERT INTO `city` VALUES ('3599', 'Krasnodar', 'RUS', 'Krasnodar');
INSERT INTO `city` VALUES ('3600', 'Jaroslavl', 'RUS', 'Jaroslavl');
INSERT INTO `city` VALUES ('3601', 'Habarovsk', 'RUS', 'Habarovsk');
INSERT INTO `city` VALUES ('3602', 'Vladivostok', 'RUS', 'Primorje');
INSERT INTO `city` VALUES ('3603', 'Irkutsk', 'RUS', 'Irkutsk');
INSERT INTO `city` VALUES ('3604', 'Barnaul', 'RUS', 'Altai');
INSERT INTO `city` VALUES ('3605', 'Novokuznetsk', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3606', 'Penza', 'RUS', 'Penza');
INSERT INTO `city` VALUES ('3607', 'Rjazan', 'RUS', 'Rjazan');
INSERT INTO `city` VALUES ('3608', 'Orenburg', 'RUS', 'Orenburg');
INSERT INTO `city` VALUES ('3609', 'Lipetsk', 'RUS', 'Lipetsk');
INSERT INTO `city` VALUES ('3610', 'Nabereznyje Tšelny', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3611', 'Tula', 'RUS', 'Tula');
INSERT INTO `city` VALUES ('3612', 'Tjumen', 'RUS', 'Tjumen');
INSERT INTO `city` VALUES ('3613', 'Kemerovo', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3614', 'Astrahan', 'RUS', 'Astrahan');
INSERT INTO `city` VALUES ('3615', 'Tomsk', 'RUS', 'Tomsk');
INSERT INTO `city` VALUES ('3616', 'Kirov', 'RUS', 'Kirov');
INSERT INTO `city` VALUES ('3617', 'Ivanovo', 'RUS', 'Ivanovo');
INSERT INTO `city` VALUES ('3618', 'Tšeboksary', 'RUS', 'Tšuvassia');
INSERT INTO `city` VALUES ('3619', 'Brjansk', 'RUS', 'Brjansk');
INSERT INTO `city` VALUES ('3620', 'Tver', 'RUS', 'Tver');
INSERT INTO `city` VALUES ('3621', 'Kursk', 'RUS', 'Kursk');
INSERT INTO `city` VALUES ('3622', 'Magnitogorsk', 'RUS', 'Tšeljabinsk');
INSERT INTO `city` VALUES ('3623', 'Kaliningrad', 'RUS', 'Kaliningrad');
INSERT INTO `city` VALUES ('3624', 'Nizni Tagil', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3625', 'Murmansk', 'RUS', 'Murmansk');
INSERT INTO `city` VALUES ('3626', 'Ulan-Ude', 'RUS', 'Burjatia');
INSERT INTO `city` VALUES ('3627', 'Kurgan', 'RUS', 'Kurgan');
INSERT INTO `city` VALUES ('3628', 'Arkangeli', 'RUS', 'Arkangeli');
INSERT INTO `city` VALUES ('3629', 'Sotši', 'RUS', 'Krasnodar');
INSERT INTO `city` VALUES ('3630', 'Smolensk', 'RUS', 'Smolensk');
INSERT INTO `city` VALUES ('3631', 'Orjol', 'RUS', 'Orjol');
INSERT INTO `city` VALUES ('3632', 'Stavropol', 'RUS', 'Stavropol');
INSERT INTO `city` VALUES ('3633', 'Belgorod', 'RUS', 'Belgorod');
INSERT INTO `city` VALUES ('3634', 'Kaluga', 'RUS', 'Kaluga');
INSERT INTO `city` VALUES ('3635', 'Vladimir', 'RUS', 'Vladimir');
INSERT INTO `city` VALUES ('3636', 'Mahatškala', 'RUS', 'Dagestan');
INSERT INTO `city` VALUES ('3637', 'Tšerepovets', 'RUS', 'Vologda');
INSERT INTO `city` VALUES ('3638', 'Saransk', 'RUS', 'Mordva');
INSERT INTO `city` VALUES ('3639', 'Tambov', 'RUS', 'Tambov');
INSERT INTO `city` VALUES ('3640', 'Vladikavkaz', 'RUS', 'North Ossetia-Alania');
INSERT INTO `city` VALUES ('3641', 'Tšita', 'RUS', 'Tšita');
INSERT INTO `city` VALUES ('3642', 'Vologda', 'RUS', 'Vologda');
INSERT INTO `city` VALUES ('3643', 'Veliki Novgorod', 'RUS', 'Novgorod');
INSERT INTO `city` VALUES ('3644', 'Komsomolsk-na-Amure', 'RUS', 'Habarovsk');
INSERT INTO `city` VALUES ('3645', 'Kostroma', 'RUS', 'Kostroma');
INSERT INTO `city` VALUES ('3646', 'Volzski', 'RUS', 'Volgograd');
INSERT INTO `city` VALUES ('3647', 'Taganrog', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3648', 'Petroskoi', 'RUS', 'Karjala');
INSERT INTO `city` VALUES ('3649', 'Bratsk', 'RUS', 'Irkutsk');
INSERT INTO `city` VALUES ('3650', 'Dzerzinsk', 'RUS', 'Nizni Novgorod');
INSERT INTO `city` VALUES ('3651', 'Surgut', 'RUS', 'Hanti-Mansia');
INSERT INTO `city` VALUES ('3652', 'Orsk', 'RUS', 'Orenburg');
INSERT INTO `city` VALUES ('3653', 'Sterlitamak', 'RUS', 'Baškortostan');
INSERT INTO `city` VALUES ('3654', 'Angarsk', 'RUS', 'Irkutsk');
INSERT INTO `city` VALUES ('3655', 'Joškar-Ola', 'RUS', 'Marinmaa');
INSERT INTO `city` VALUES ('3656', 'Rybinsk', 'RUS', 'Jaroslavl');
INSERT INTO `city` VALUES ('3657', 'Prokopjevsk', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3658', 'Niznevartovsk', 'RUS', 'Hanti-Mansia');
INSERT INTO `city` VALUES ('3659', 'Naltšik', 'RUS', 'Kabardi-Balkaria');
INSERT INTO `city` VALUES ('3660', 'Syktyvkar', 'RUS', 'Komi');
INSERT INTO `city` VALUES ('3661', 'Severodvinsk', 'RUS', 'Arkangeli');
INSERT INTO `city` VALUES ('3662', 'Bijsk', 'RUS', 'Altai');
INSERT INTO `city` VALUES ('3663', 'Niznekamsk', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3664', 'Blagoveštšensk', 'RUS', 'Amur');
INSERT INTO `city` VALUES ('3665', 'Šahty', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3666', 'Staryi Oskol', 'RUS', 'Belgorod');
INSERT INTO `city` VALUES ('3667', 'Zelenograd', 'RUS', 'Moscow (City)');
INSERT INTO `city` VALUES ('3668', 'Balakovo', 'RUS', 'Saratov');
INSERT INTO `city` VALUES ('3669', 'Novorossijsk', 'RUS', 'Krasnodar');
INSERT INTO `city` VALUES ('3670', 'Pihkova', 'RUS', 'Pihkova');
INSERT INTO `city` VALUES ('3671', 'Zlatoust', 'RUS', 'Tšeljabinsk');
INSERT INTO `city` VALUES ('3672', 'Jakutsk', 'RUS', 'Saha (Jakutia)');
INSERT INTO `city` VALUES ('3673', 'Podolsk', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3674', 'Petropavlovsk-Kamtšatski', 'RUS', 'Kamtšatka');
INSERT INTO `city` VALUES ('3675', 'Kamensk-Uralski', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3676', 'Engels', 'RUS', 'Saratov');
INSERT INTO `city` VALUES ('3677', 'Syzran', 'RUS', 'Samara');
INSERT INTO `city` VALUES ('3678', 'Grozny', 'RUS', 'Tšetšenia');
INSERT INTO `city` VALUES ('3679', 'Novotšerkassk', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3680', 'Berezniki', 'RUS', 'Perm');
INSERT INTO `city` VALUES ('3681', 'Juzno-Sahalinsk', 'RUS', 'Sahalin');
INSERT INTO `city` VALUES ('3682', 'Volgodonsk', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3683', 'Abakan', 'RUS', 'Hakassia');
INSERT INTO `city` VALUES ('3684', 'Maikop', 'RUS', 'Adygea');
INSERT INTO `city` VALUES ('3685', 'Miass', 'RUS', 'Tšeljabinsk');
INSERT INTO `city` VALUES ('3686', 'Armavir', 'RUS', 'Krasnodar');
INSERT INTO `city` VALUES ('3687', 'Ljubertsy', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3688', 'Rubtsovsk', 'RUS', 'Altai');
INSERT INTO `city` VALUES ('3689', 'Kovrov', 'RUS', 'Vladimir');
INSERT INTO `city` VALUES ('3690', 'Nahodka', 'RUS', 'Primorje');
INSERT INTO `city` VALUES ('3691', 'Ussurijsk', 'RUS', 'Primorje');
INSERT INTO `city` VALUES ('3692', 'Salavat', 'RUS', 'Baškortostan');
INSERT INTO `city` VALUES ('3693', 'Mytištši', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3694', 'Kolomna', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3695', 'Elektrostal', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3696', 'Murom', 'RUS', 'Vladimir');
INSERT INTO `city` VALUES ('3697', 'Kolpino', 'RUS', 'Pietari');
INSERT INTO `city` VALUES ('3698', 'Norilsk', 'RUS', 'Krasnojarsk');
INSERT INTO `city` VALUES ('3699', 'Almetjevsk', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3700', 'Novomoskovsk', 'RUS', 'Tula');
INSERT INTO `city` VALUES ('3701', 'Dimitrovgrad', 'RUS', 'Uljanovsk');
INSERT INTO `city` VALUES ('3702', 'Pervouralsk', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3703', 'Himki', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3704', 'Balašiha', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3705', 'Nevinnomyssk', 'RUS', 'Stavropol');
INSERT INTO `city` VALUES ('3706', 'Pjatigorsk', 'RUS', 'Stavropol');
INSERT INTO `city` VALUES ('3707', 'Korolev', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3708', 'Serpuhov', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3709', 'Odintsovo', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3710', 'Orehovo-Zujevo', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3711', 'Kamyšin', 'RUS', 'Volgograd');
INSERT INTO `city` VALUES ('3712', 'Novotšeboksarsk', 'RUS', 'Tšuvassia');
INSERT INTO `city` VALUES ('3713', 'Tšerkessk', 'RUS', 'Karatšai-Tšerkessia');
INSERT INTO `city` VALUES ('3714', 'Atšinsk', 'RUS', 'Krasnojarsk');
INSERT INTO `city` VALUES ('3715', 'Magadan', 'RUS', 'Magadan');
INSERT INTO `city` VALUES ('3716', 'Mitšurinsk', 'RUS', 'Tambov');
INSERT INTO `city` VALUES ('3717', 'Kislovodsk', 'RUS', 'Stavropol');
INSERT INTO `city` VALUES ('3718', 'Jelets', 'RUS', 'Lipetsk');
INSERT INTO `city` VALUES ('3719', 'Seversk', 'RUS', 'Tomsk');
INSERT INTO `city` VALUES ('3720', 'Noginsk', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3721', 'Velikije Luki', 'RUS', 'Pihkova');
INSERT INTO `city` VALUES ('3722', 'Novokuibyševsk', 'RUS', 'Samara');
INSERT INTO `city` VALUES ('3723', 'Neftekamsk', 'RUS', 'Baškortostan');
INSERT INTO `city` VALUES ('3724', 'Leninsk-Kuznetski', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3725', 'Oktjabrski', 'RUS', 'Baškortostan');
INSERT INTO `city` VALUES ('3726', 'Sergijev Posad', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3727', 'Arzamas', 'RUS', 'Nizni Novgorod');
INSERT INTO `city` VALUES ('3728', 'Kiseljovsk', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3729', 'Novotroitsk', 'RUS', 'Orenburg');
INSERT INTO `city` VALUES ('3730', 'Obninsk', 'RUS', 'Kaluga');
INSERT INTO `city` VALUES ('3731', 'Kansk', 'RUS', 'Krasnojarsk');
INSERT INTO `city` VALUES ('3732', 'Glazov', 'RUS', 'Udmurtia');
INSERT INTO `city` VALUES ('3733', 'Solikamsk', 'RUS', 'Perm');
INSERT INTO `city` VALUES ('3734', 'Sarapul', 'RUS', 'Udmurtia');
INSERT INTO `city` VALUES ('3735', 'Ust-Ilimsk', 'RUS', 'Irkutsk');
INSERT INTO `city` VALUES ('3736', 'Štšolkovo', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3737', 'Mezduretšensk', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3738', 'Usolje-Sibirskoje', 'RUS', 'Irkutsk');
INSERT INTO `city` VALUES ('3739', 'Elista', 'RUS', 'Kalmykia');
INSERT INTO `city` VALUES ('3740', 'Novošahtinsk', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3741', 'Votkinsk', 'RUS', 'Udmurtia');
INSERT INTO `city` VALUES ('3742', 'Kyzyl', 'RUS', 'Tyva');
INSERT INTO `city` VALUES ('3743', 'Serov', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3744', 'Zelenodolsk', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3745', 'Zeleznodoroznyi', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3746', 'Kinešma', 'RUS', 'Ivanovo');
INSERT INTO `city` VALUES ('3747', 'Kuznetsk', 'RUS', 'Penza');
INSERT INTO `city` VALUES ('3748', 'Uhta', 'RUS', 'Komi');
INSERT INTO `city` VALUES ('3749', 'Jessentuki', 'RUS', 'Stavropol');
INSERT INTO `city` VALUES ('3750', 'Tobolsk', 'RUS', 'Tjumen');
INSERT INTO `city` VALUES ('3751', 'Neftejugansk', 'RUS', 'Hanti-Mansia');
INSERT INTO `city` VALUES ('3752', 'Bataisk', 'RUS', 'Rostov-na-Donu');
INSERT INTO `city` VALUES ('3753', 'Nojabrsk', 'RUS', 'Yamalin Nenetsia');
INSERT INTO `city` VALUES ('3754', 'Balašov', 'RUS', 'Saratov');
INSERT INTO `city` VALUES ('3755', 'Zeleznogorsk', 'RUS', 'Kursk');
INSERT INTO `city` VALUES ('3756', 'Zukovski', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3757', 'Anzero-Sudzensk', 'RUS', 'Kemerovo');
INSERT INTO `city` VALUES ('3758', 'Bugulma', 'RUS', 'Tatarstan');
INSERT INTO `city` VALUES ('3759', 'Zeleznogorsk', 'RUS', 'Krasnojarsk');
INSERT INTO `city` VALUES ('3760', 'Novouralsk', 'RUS', 'Sverdlovsk');
INSERT INTO `city` VALUES ('3761', 'Puškin', 'RUS', 'Pietari');
INSERT INTO `city` VALUES ('3762', 'Vorkuta', 'RUS', 'Komi');
INSERT INTO `city` VALUES ('3763', 'Derbent', 'RUS', 'Dagestan');
INSERT INTO `city` VALUES ('3764', 'Kirovo-Tšepetsk', 'RUS', 'Kirov');
INSERT INTO `city` VALUES ('3765', 'Krasnogorsk', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3766', 'Klin', 'RUS', 'Moskova');
INSERT INTO `city` VALUES ('3767', 'Tšaikovski', 'RUS', 'Perm');
INSERT INTO `city` VALUES ('3768', 'Novyi Urengoi', 'RUS', 'Yamalin Nenetsia');
INSERT INTO `city` VALUES ('3769', 'Ho Chi Minh City', 'VNM', 'Ho Chi Minh City');
INSERT INTO `city` VALUES ('3770', 'Hanoi', 'VNM', 'Hanoi');
INSERT INTO `city` VALUES ('3771', 'Haiphong', 'VNM', 'Haiphong');
INSERT INTO `city` VALUES ('3772', 'Da Nang', 'VNM', 'Quang Nam-Da Nang');
INSERT INTO `city` VALUES ('3773', 'Biên Hoa', 'VNM', 'Dong Nai');
INSERT INTO `city` VALUES ('3774', 'Nha Trang', 'VNM', 'Khanh Hoa');
INSERT INTO `city` VALUES ('3775', 'Hue', 'VNM', 'Thua Thien-Hue');
INSERT INTO `city` VALUES ('3776', 'Can Tho', 'VNM', 'Can Tho');
INSERT INTO `city` VALUES ('3777', 'Cam Pha', 'VNM', 'Quang Binh');
INSERT INTO `city` VALUES ('3778', 'Nam Dinh', 'VNM', 'Nam Ha');
INSERT INTO `city` VALUES ('3779', 'Quy Nhon', 'VNM', 'Binh Dinh');
INSERT INTO `city` VALUES ('3780', 'Vung Tau', 'VNM', 'Ba Ria-Vung Tau');
INSERT INTO `city` VALUES ('3781', 'Rach Gia', 'VNM', 'Kien Giang');
INSERT INTO `city` VALUES ('3782', 'Long Xuyen', 'VNM', 'An Giang');
INSERT INTO `city` VALUES ('3783', 'Thai Nguyen', 'VNM', 'Bac Thai');
INSERT INTO `city` VALUES ('3784', 'Hong Gai', 'VNM', 'Quang Ninh');
INSERT INTO `city` VALUES ('3785', 'Phan Thiêt', 'VNM', 'Binh Thuan');
INSERT INTO `city` VALUES ('3786', 'Cam Ranh', 'VNM', 'Khanh Hoa');
INSERT INTO `city` VALUES ('3787', 'Vinh', 'VNM', 'Nghe An');
INSERT INTO `city` VALUES ('3788', 'My Tho', 'VNM', 'Tien Giang');
INSERT INTO `city` VALUES ('3789', 'Da Lat', 'VNM', 'Lam Dong');
INSERT INTO `city` VALUES ('3790', 'Buon Ma Thuot', 'VNM', 'Dac Lac');
INSERT INTO `city` VALUES ('3791', 'Tallinn', 'EST', 'Harjumaa');
INSERT INTO `city` VALUES ('3792', 'Tartu', 'EST', 'Tartumaa');
INSERT INTO `city` VALUES ('3793', 'New York', 'USA', 'New York');
INSERT INTO `city` VALUES ('3794', 'Los Angeles', 'USA', 'California');
INSERT INTO `city` VALUES ('3795', 'Chicago', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3796', 'Houston', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3797', 'Philadelphia', 'USA', 'Pennsylvania');
INSERT INTO `city` VALUES ('3798', 'Phoenix', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3799', 'San Diego', 'USA', 'California');
INSERT INTO `city` VALUES ('3800', 'Dallas', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3801', 'San Antonio', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3802', 'Detroit', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3803', 'San Jose', 'USA', 'California');
INSERT INTO `city` VALUES ('3804', 'Indianapolis', 'USA', 'Indiana');
INSERT INTO `city` VALUES ('3805', 'San Francisco', 'USA', 'California');
INSERT INTO `city` VALUES ('3806', 'Jacksonville', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3807', 'Columbus', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3808', 'Austin', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3809', 'Baltimore', 'USA', 'Maryland');
INSERT INTO `city` VALUES ('3810', 'Memphis', 'USA', 'Tennessee');
INSERT INTO `city` VALUES ('3811', 'Milwaukee', 'USA', 'Wisconsin');
INSERT INTO `city` VALUES ('3812', 'Boston', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('3813', 'Washington', 'USA', 'District of Columbia');
INSERT INTO `city` VALUES ('3814', 'Nashville-Davidson', 'USA', 'Tennessee');
INSERT INTO `city` VALUES ('3815', 'El Paso', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3816', 'Seattle', 'USA', 'Washington');
INSERT INTO `city` VALUES ('3817', 'Denver', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('3818', 'Charlotte', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3819', 'Fort Worth', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3820', 'Portland', 'USA', 'Oregon');
INSERT INTO `city` VALUES ('3821', 'Oklahoma City', 'USA', 'Oklahoma');
INSERT INTO `city` VALUES ('3822', 'Tucson', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3823', 'New Orleans', 'USA', 'Louisiana');
INSERT INTO `city` VALUES ('3824', 'Las Vegas', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('3825', 'Cleveland', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3826', 'Long Beach', 'USA', 'California');
INSERT INTO `city` VALUES ('3827', 'Albuquerque', 'USA', 'New Mexico');
INSERT INTO `city` VALUES ('3828', 'Kansas City', 'USA', 'Missouri');
INSERT INTO `city` VALUES ('3829', 'Fresno', 'USA', 'California');
INSERT INTO `city` VALUES ('3830', 'Virginia Beach', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3831', 'Atlanta', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('3832', 'Sacramento', 'USA', 'California');
INSERT INTO `city` VALUES ('3833', 'Oakland', 'USA', 'California');
INSERT INTO `city` VALUES ('3834', 'Mesa', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3835', 'Tulsa', 'USA', 'Oklahoma');
INSERT INTO `city` VALUES ('3836', 'Omaha', 'USA', 'Nebraska');
INSERT INTO `city` VALUES ('3837', 'Minneapolis', 'USA', 'Minnesota');
INSERT INTO `city` VALUES ('3838', 'Honolulu', 'USA', 'Hawaii');
INSERT INTO `city` VALUES ('3839', 'Miami', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3840', 'Colorado Springs', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('3841', 'Saint Louis', 'USA', 'Missouri');
INSERT INTO `city` VALUES ('3842', 'Wichita', 'USA', 'Kansas');
INSERT INTO `city` VALUES ('3843', 'Santa Ana', 'USA', 'California');
INSERT INTO `city` VALUES ('3844', 'Pittsburgh', 'USA', 'Pennsylvania');
INSERT INTO `city` VALUES ('3845', 'Arlington', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3846', 'Cincinnati', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3847', 'Anaheim', 'USA', 'California');
INSERT INTO `city` VALUES ('3848', 'Toledo', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3849', 'Tampa', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3850', 'Buffalo', 'USA', 'New York');
INSERT INTO `city` VALUES ('3851', 'Saint Paul', 'USA', 'Minnesota');
INSERT INTO `city` VALUES ('3852', 'Corpus Christi', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3853', 'Aurora', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('3854', 'Raleigh', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3855', 'Newark', 'USA', 'New Jersey');
INSERT INTO `city` VALUES ('3856', 'Lexington-Fayette', 'USA', 'Kentucky');
INSERT INTO `city` VALUES ('3857', 'Anchorage', 'USA', 'Alaska');
INSERT INTO `city` VALUES ('3858', 'Louisville', 'USA', 'Kentucky');
INSERT INTO `city` VALUES ('3859', 'Riverside', 'USA', 'California');
INSERT INTO `city` VALUES ('3860', 'Saint Petersburg', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3861', 'Bakersfield', 'USA', 'California');
INSERT INTO `city` VALUES ('3862', 'Stockton', 'USA', 'California');
INSERT INTO `city` VALUES ('3863', 'Birmingham', 'USA', 'Alabama');
INSERT INTO `city` VALUES ('3864', 'Jersey City', 'USA', 'New Jersey');
INSERT INTO `city` VALUES ('3865', 'Norfolk', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3866', 'Baton Rouge', 'USA', 'Louisiana');
INSERT INTO `city` VALUES ('3867', 'Hialeah', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3868', 'Lincoln', 'USA', 'Nebraska');
INSERT INTO `city` VALUES ('3869', 'Greensboro', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3870', 'Plano', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3871', 'Rochester', 'USA', 'New York');
INSERT INTO `city` VALUES ('3872', 'Glendale', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3873', 'Akron', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3874', 'Garland', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3875', 'Madison', 'USA', 'Wisconsin');
INSERT INTO `city` VALUES ('3876', 'Fort Wayne', 'USA', 'Indiana');
INSERT INTO `city` VALUES ('3877', 'Fremont', 'USA', 'California');
INSERT INTO `city` VALUES ('3878', 'Scottsdale', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3879', 'Montgomery', 'USA', 'Alabama');
INSERT INTO `city` VALUES ('3880', 'Shreveport', 'USA', 'Louisiana');
INSERT INTO `city` VALUES ('3881', 'Augusta-Richmond County', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('3882', 'Lubbock', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3883', 'Chesapeake', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3884', 'Mobile', 'USA', 'Alabama');
INSERT INTO `city` VALUES ('3885', 'Des Moines', 'USA', 'Iowa');
INSERT INTO `city` VALUES ('3886', 'Grand Rapids', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3887', 'Richmond', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3888', 'Yonkers', 'USA', 'New York');
INSERT INTO `city` VALUES ('3889', 'Spokane', 'USA', 'Washington');
INSERT INTO `city` VALUES ('3890', 'Glendale', 'USA', 'California');
INSERT INTO `city` VALUES ('3891', 'Tacoma', 'USA', 'Washington');
INSERT INTO `city` VALUES ('3892', 'Irving', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3893', 'Huntington Beach', 'USA', 'California');
INSERT INTO `city` VALUES ('3894', 'Modesto', 'USA', 'California');
INSERT INTO `city` VALUES ('3895', 'Durham', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3896', 'Columbus', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('3897', 'Orlando', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3898', 'Boise City', 'USA', 'Idaho');
INSERT INTO `city` VALUES ('3899', 'Winston-Salem', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3900', 'San Bernardino', 'USA', 'California');
INSERT INTO `city` VALUES ('3901', 'Jackson', 'USA', 'Mississippi');
INSERT INTO `city` VALUES ('3902', 'Little Rock', 'USA', 'Arkansas');
INSERT INTO `city` VALUES ('3903', 'Salt Lake City', 'USA', 'Utah');
INSERT INTO `city` VALUES ('3904', 'Reno', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('3905', 'Newport News', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3906', 'Chandler', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3907', 'Laredo', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3908', 'Henderson', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('3909', 'Arlington', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3910', 'Knoxville', 'USA', 'Tennessee');
INSERT INTO `city` VALUES ('3911', 'Amarillo', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3912', 'Providence', 'USA', 'Rhode Island');
INSERT INTO `city` VALUES ('3913', 'Chula Vista', 'USA', 'California');
INSERT INTO `city` VALUES ('3914', 'Worcester', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('3915', 'Oxnard', 'USA', 'California');
INSERT INTO `city` VALUES ('3916', 'Dayton', 'USA', 'Ohio');
INSERT INTO `city` VALUES ('3917', 'Garden Grove', 'USA', 'California');
INSERT INTO `city` VALUES ('3918', 'Oceanside', 'USA', 'California');
INSERT INTO `city` VALUES ('3919', 'Tempe', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('3920', 'Huntsville', 'USA', 'Alabama');
INSERT INTO `city` VALUES ('3921', 'Ontario', 'USA', 'California');
INSERT INTO `city` VALUES ('3922', 'Chattanooga', 'USA', 'Tennessee');
INSERT INTO `city` VALUES ('3923', 'Fort Lauderdale', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3924', 'Springfield', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('3925', 'Springfield', 'USA', 'Missouri');
INSERT INTO `city` VALUES ('3926', 'Santa Clarita', 'USA', 'California');
INSERT INTO `city` VALUES ('3927', 'Salinas', 'USA', 'California');
INSERT INTO `city` VALUES ('3928', 'Tallahassee', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3929', 'Rockford', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3930', 'Pomona', 'USA', 'California');
INSERT INTO `city` VALUES ('3931', 'Metairie', 'USA', 'Louisiana');
INSERT INTO `city` VALUES ('3932', 'Paterson', 'USA', 'New Jersey');
INSERT INTO `city` VALUES ('3933', 'Overland Park', 'USA', 'Kansas');
INSERT INTO `city` VALUES ('3934', 'Santa Rosa', 'USA', 'California');
INSERT INTO `city` VALUES ('3935', 'Syracuse', 'USA', 'New York');
INSERT INTO `city` VALUES ('3936', 'Kansas City', 'USA', 'Kansas');
INSERT INTO `city` VALUES ('3937', 'Hampton', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3938', 'Lakewood', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('3939', 'Vancouver', 'USA', 'Washington');
INSERT INTO `city` VALUES ('3940', 'Irvine', 'USA', 'California');
INSERT INTO `city` VALUES ('3941', 'Aurora', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3942', 'Moreno Valley', 'USA', 'California');
INSERT INTO `city` VALUES ('3943', 'Pasadena', 'USA', 'California');
INSERT INTO `city` VALUES ('3944', 'Hayward', 'USA', 'California');
INSERT INTO `city` VALUES ('3945', 'Brownsville', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3946', 'Bridgeport', 'USA', 'Connecticut');
INSERT INTO `city` VALUES ('3947', 'Hollywood', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3948', 'Warren', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3949', 'Torrance', 'USA', 'California');
INSERT INTO `city` VALUES ('3950', 'Eugene', 'USA', 'Oregon');
INSERT INTO `city` VALUES ('3951', 'Pembroke Pines', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3952', 'Salem', 'USA', 'Oregon');
INSERT INTO `city` VALUES ('3953', 'Pasadena', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3954', 'Escondido', 'USA', 'California');
INSERT INTO `city` VALUES ('3955', 'Sunnyvale', 'USA', 'California');
INSERT INTO `city` VALUES ('3956', 'Savannah', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('3957', 'Fontana', 'USA', 'California');
INSERT INTO `city` VALUES ('3958', 'Orange', 'USA', 'California');
INSERT INTO `city` VALUES ('3959', 'Naperville', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3960', 'Alexandria', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('3961', 'Rancho Cucamonga', 'USA', 'California');
INSERT INTO `city` VALUES ('3962', 'Grand Prairie', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3963', 'East Los Angeles', 'USA', 'California');
INSERT INTO `city` VALUES ('3964', 'Fullerton', 'USA', 'California');
INSERT INTO `city` VALUES ('3965', 'Corona', 'USA', 'California');
INSERT INTO `city` VALUES ('3966', 'Flint', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3967', 'Paradise', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('3968', 'Mesquite', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3969', 'Sterling Heights', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3970', 'Sioux Falls', 'USA', 'South Dakota');
INSERT INTO `city` VALUES ('3971', 'New Haven', 'USA', 'Connecticut');
INSERT INTO `city` VALUES ('3972', 'Topeka', 'USA', 'Kansas');
INSERT INTO `city` VALUES ('3973', 'Concord', 'USA', 'California');
INSERT INTO `city` VALUES ('3974', 'Evansville', 'USA', 'Indiana');
INSERT INTO `city` VALUES ('3975', 'Hartford', 'USA', 'Connecticut');
INSERT INTO `city` VALUES ('3976', 'Fayetteville', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('3977', 'Cedar Rapids', 'USA', 'Iowa');
INSERT INTO `city` VALUES ('3978', 'Elizabeth', 'USA', 'New Jersey');
INSERT INTO `city` VALUES ('3979', 'Lansing', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3980', 'Lancaster', 'USA', 'California');
INSERT INTO `city` VALUES ('3981', 'Fort Collins', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('3982', 'Coral Springs', 'USA', 'Florida');
INSERT INTO `city` VALUES ('3983', 'Stamford', 'USA', 'Connecticut');
INSERT INTO `city` VALUES ('3984', 'Thousand Oaks', 'USA', 'California');
INSERT INTO `city` VALUES ('3985', 'Vallejo', 'USA', 'California');
INSERT INTO `city` VALUES ('3986', 'Palmdale', 'USA', 'California');
INSERT INTO `city` VALUES ('3987', 'Columbia', 'USA', 'South Carolina');
INSERT INTO `city` VALUES ('3988', 'El Monte', 'USA', 'California');
INSERT INTO `city` VALUES ('3989', 'Abilene', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3990', 'North Las Vegas', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('3991', 'Ann Arbor', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('3992', 'Beaumont', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3993', 'Waco', 'USA', 'Texas');
INSERT INTO `city` VALUES ('3994', 'Macon', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('3995', 'Independence', 'USA', 'Missouri');
INSERT INTO `city` VALUES ('3996', 'Peoria', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3997', 'Inglewood', 'USA', 'California');
INSERT INTO `city` VALUES ('3998', 'Springfield', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('3999', 'Simi Valley', 'USA', 'California');
INSERT INTO `city` VALUES ('4000', 'Lafayette', 'USA', 'Louisiana');
INSERT INTO `city` VALUES ('4001', 'Gilbert', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('4002', 'Carrollton', 'USA', 'Texas');
INSERT INTO `city` VALUES ('4003', 'Bellevue', 'USA', 'Washington');
INSERT INTO `city` VALUES ('4004', 'West Valley City', 'USA', 'Utah');
INSERT INTO `city` VALUES ('4005', 'Clarksville', 'USA', 'Tennessee');
INSERT INTO `city` VALUES ('4006', 'Costa Mesa', 'USA', 'California');
INSERT INTO `city` VALUES ('4007', 'Peoria', 'USA', 'Arizona');
INSERT INTO `city` VALUES ('4008', 'South Bend', 'USA', 'Indiana');
INSERT INTO `city` VALUES ('4009', 'Downey', 'USA', 'California');
INSERT INTO `city` VALUES ('4010', 'Waterbury', 'USA', 'Connecticut');
INSERT INTO `city` VALUES ('4011', 'Manchester', 'USA', 'New Hampshire');
INSERT INTO `city` VALUES ('4012', 'Allentown', 'USA', 'Pennsylvania');
INSERT INTO `city` VALUES ('4013', 'McAllen', 'USA', 'Texas');
INSERT INTO `city` VALUES ('4014', 'Joliet', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('4015', 'Lowell', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('4016', 'Provo', 'USA', 'Utah');
INSERT INTO `city` VALUES ('4017', 'West Covina', 'USA', 'California');
INSERT INTO `city` VALUES ('4018', 'Wichita Falls', 'USA', 'Texas');
INSERT INTO `city` VALUES ('4019', 'Erie', 'USA', 'Pennsylvania');
INSERT INTO `city` VALUES ('4020', 'Daly City', 'USA', 'California');
INSERT INTO `city` VALUES ('4021', 'Citrus Heights', 'USA', 'California');
INSERT INTO `city` VALUES ('4022', 'Norwalk', 'USA', 'California');
INSERT INTO `city` VALUES ('4023', 'Gary', 'USA', 'Indiana');
INSERT INTO `city` VALUES ('4024', 'Berkeley', 'USA', 'California');
INSERT INTO `city` VALUES ('4025', 'Santa Clara', 'USA', 'California');
INSERT INTO `city` VALUES ('4026', 'Green Bay', 'USA', 'Wisconsin');
INSERT INTO `city` VALUES ('4027', 'Cape Coral', 'USA', 'Florida');
INSERT INTO `city` VALUES ('4028', 'Arvada', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('4029', 'Pueblo', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('4030', 'Sandy', 'USA', 'Utah');
INSERT INTO `city` VALUES ('4031', 'Athens-Clarke County', 'USA', 'Georgia');
INSERT INTO `city` VALUES ('4032', 'Cambridge', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('4033', 'Westminster', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('4034', 'San Buenaventura', 'USA', 'California');
INSERT INTO `city` VALUES ('4035', 'Portsmouth', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('4036', 'Livonia', 'USA', 'Michigan');
INSERT INTO `city` VALUES ('4037', 'Burbank', 'USA', 'California');
INSERT INTO `city` VALUES ('4038', 'Clearwater', 'USA', 'Florida');
INSERT INTO `city` VALUES ('4039', 'Midland', 'USA', 'Texas');
INSERT INTO `city` VALUES ('4040', 'Davenport', 'USA', 'Iowa');
INSERT INTO `city` VALUES ('4041', 'Mission Viejo', 'USA', 'California');
INSERT INTO `city` VALUES ('4042', 'Miami Beach', 'USA', 'Florida');
INSERT INTO `city` VALUES ('4043', 'Sunrise Manor', 'USA', 'Nevada');
INSERT INTO `city` VALUES ('4044', 'New Bedford', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('4045', 'El Cajon', 'USA', 'California');
INSERT INTO `city` VALUES ('4046', 'Norman', 'USA', 'Oklahoma');
INSERT INTO `city` VALUES ('4047', 'Richmond', 'USA', 'California');
INSERT INTO `city` VALUES ('4048', 'Albany', 'USA', 'New York');
INSERT INTO `city` VALUES ('4049', 'Brockton', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('4050', 'Roanoke', 'USA', 'Virginia');
INSERT INTO `city` VALUES ('4051', 'Billings', 'USA', 'Montana');
INSERT INTO `city` VALUES ('4052', 'Compton', 'USA', 'California');
INSERT INTO `city` VALUES ('4053', 'Gainesville', 'USA', 'Florida');
INSERT INTO `city` VALUES ('4054', 'Fairfield', 'USA', 'California');
INSERT INTO `city` VALUES ('4055', 'Arden-Arcade', 'USA', 'California');
INSERT INTO `city` VALUES ('4056', 'San Mateo', 'USA', 'California');
INSERT INTO `city` VALUES ('4057', 'Visalia', 'USA', 'California');
INSERT INTO `city` VALUES ('4058', 'Boulder', 'USA', 'Colorado');
INSERT INTO `city` VALUES ('4059', 'Cary', 'USA', 'North Carolina');
INSERT INTO `city` VALUES ('4060', 'Santa Monica', 'USA', 'California');
INSERT INTO `city` VALUES ('4061', 'Fall River', 'USA', 'Massachusetts');
INSERT INTO `city` VALUES ('4062', 'Kenosha', 'USA', 'Wisconsin');
INSERT INTO `city` VALUES ('4063', 'Elgin', 'USA', 'Illinois');
INSERT INTO `city` VALUES ('4064', 'Odessa', 'USA', 'Texas');
INSERT INTO `city` VALUES ('4065', 'Carson', 'USA', 'California');
INSERT INTO `city` VALUES ('4066', 'Charleston', 'USA', 'South Carolina');
INSERT INTO `city` VALUES ('4067', 'Charlotte Amalie', 'VIR', 'St Thomas');
INSERT INTO `city` VALUES ('4068', 'Harare', 'ZWE', 'Harare');
INSERT INTO `city` VALUES ('4069', 'Bulawayo', 'ZWE', 'Bulawayo');
INSERT INTO `city` VALUES ('4070', 'Chitungwiza', 'ZWE', 'Harare');
INSERT INTO `city` VALUES ('4071', 'Mount Darwin', 'ZWE', 'Harare');
INSERT INTO `city` VALUES ('4072', 'Mutare', 'ZWE', 'Manicaland');
INSERT INTO `city` VALUES ('4073', 'Gweru', 'ZWE', 'Midlands');
INSERT INTO `city` VALUES ('4074', 'Gaza', 'PSE', 'Gaza');
INSERT INTO `city` VALUES ('4075', 'Khan Yunis', 'PSE', 'Khan Yunis');
INSERT INTO `city` VALUES ('4076', 'Hebron', 'PSE', 'Hebron');
INSERT INTO `city` VALUES ('4077', 'Jabaliya', 'PSE', 'North Gaza');
INSERT INTO `city` VALUES ('4078', 'Nablus', 'PSE', 'Nablus');
INSERT INTO `city` VALUES ('4079', 'Rafah', 'PSE', 'Rafah');

-- ----------------------------
-- Table structure for `country`
-- ----------------------------
CREATE TABLE `country` (
  `Code` char(3) NOT NULL DEFAULT '',
  `Name` char(52) NOT NULL DEFAULT '',
  `Continent` enum('Asia','Europe','North America','Africa','Oceania','Antarctica','South America') NOT NULL DEFAULT 'Asia',
  `Region` char(26) NOT NULL DEFAULT '',
  `Code2` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`Code`),
  UNIQUE KEY `Code2` (`Code2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of country
-- ----------------------------
INSERT INTO `country` VALUES ('ABW', 'Aruba', 'North America', 'Caribbean', 'AW');
INSERT INTO `country` VALUES ('AFG', 'Afghanistan', 'Asia', 'Southern and Central Asia', 'AF');
INSERT INTO `country` VALUES ('AGO', 'Angola', 'Africa', 'Central Africa', 'AO');
INSERT INTO `country` VALUES ('AIA', 'Anguilla', 'North America', 'Caribbean', 'AI');
INSERT INTO `country` VALUES ('ALB', 'Albania', 'Europe', 'Southern Europe', 'AL');
INSERT INTO `country` VALUES ('AND', 'Andorra', 'Europe', 'Southern Europe', 'AD');
INSERT INTO `country` VALUES ('ANT', 'Netherlands Antilles', 'North America', 'Caribbean', 'AN');
INSERT INTO `country` VALUES ('ARE', 'United Arab Emirates', 'Asia', 'Middle East', 'AE');
INSERT INTO `country` VALUES ('ARG', 'Argentina', 'South America', 'South America', 'AR');
INSERT INTO `country` VALUES ('ARM', 'Armenia', 'Asia', 'Middle East', 'AM');
INSERT INTO `country` VALUES ('ASM', 'American Samoa', 'Oceania', 'Polynesia', 'AS');
INSERT INTO `country` VALUES ('ATA', 'Antarctica', 'Antarctica', 'Antarctica', 'AQ');
INSERT INTO `country` VALUES ('ATF', 'French Southern territories', 'Antarctica', 'Antarctica', 'TF');
INSERT INTO `country` VALUES ('ATG', 'Antigua and Barbuda', 'North America', 'Caribbean', 'AG');
INSERT INTO `country` VALUES ('AUS', 'Australia', 'Oceania', 'Australia and New Zealand', 'AU');
INSERT INTO `country` VALUES ('AUT', 'Austria', 'Europe', 'Western Europe', 'AT');
INSERT INTO `country` VALUES ('AZE', 'Azerbaijan', 'Asia', 'Middle East', 'AZ');
INSERT INTO `country` VALUES ('BDI', 'Burundi', 'Africa', 'Eastern Africa', 'BI');
INSERT INTO `country` VALUES ('BEL', 'Belgium', 'Europe', 'Western Europe', 'BE');
INSERT INTO `country` VALUES ('BEN', 'Benin', 'Africa', 'Western Africa', 'BJ');
INSERT INTO `country` VALUES ('BFA', 'Burkina Faso', 'Africa', 'Western Africa', 'BF');
INSERT INTO `country` VALUES ('BGD', 'Bangladesh', 'Asia', 'Southern and Central Asia', 'BD');
INSERT INTO `country` VALUES ('BGR', 'Bulgaria', 'Europe', 'Eastern Europe', 'BG');
INSERT INTO `country` VALUES ('BHR', 'Bahrain', 'Asia', 'Middle East', 'BH');
INSERT INTO `country` VALUES ('BHS', 'Bahamas', 'North America', 'Caribbean', 'BS');
INSERT INTO `country` VALUES ('BIH', 'Bosnia and Herzegovina', 'Europe', 'Southern Europe', 'BA');
INSERT INTO `country` VALUES ('BLR', 'Belarus', 'Europe', 'Eastern Europe', 'BY');
INSERT INTO `country` VALUES ('BLZ', 'Belize', 'North America', 'Central America', 'BZ');
INSERT INTO `country` VALUES ('BMU', 'Bermuda', 'North America', 'North America', 'BM');
INSERT INTO `country` VALUES ('BOL', 'Bolivia', 'South America', 'South America', 'BO');
INSERT INTO `country` VALUES ('BRA', 'Brazil', 'South America', 'South America', 'BR');
INSERT INTO `country` VALUES ('BRB', 'Barbados', 'North America', 'Caribbean', 'BB');
INSERT INTO `country` VALUES ('BRN', 'Brunei', 'Asia', 'Southeast Asia', 'BN');
INSERT INTO `country` VALUES ('BTN', 'Bhutan', 'Asia', 'Southern and Central Asia', 'BT');
INSERT INTO `country` VALUES ('BVT', 'Bouvet Island', 'Antarctica', 'Antarctica', 'BV');
INSERT INTO `country` VALUES ('BWA', 'Botswana', 'Africa', 'Southern Africa', 'BW');
INSERT INTO `country` VALUES ('CAF', 'Central African Republic', 'Africa', 'Central Africa', 'CF');
INSERT INTO `country` VALUES ('CAN', 'Canada', 'North America', 'North America', 'CA');
INSERT INTO `country` VALUES ('CCK', 'Cocos (Keeling) Islands', 'Oceania', 'Australia and New Zealand', 'CC');
INSERT INTO `country` VALUES ('CHE', 'Switzerland', 'Europe', 'Western Europe', 'CH');
INSERT INTO `country` VALUES ('CHL', 'Chile', 'South America', 'South America', 'CL');
INSERT INTO `country` VALUES ('CHN', 'China', 'Asia', 'Eastern Asia', 'CN');
INSERT INTO `country` VALUES ('CIV', 'Côte d’Ivoire', 'Africa', 'Western Africa', 'CI');
INSERT INTO `country` VALUES ('CMR', 'Cameroon', 'Africa', 'Central Africa', 'CM');
INSERT INTO `country` VALUES ('COD', 'Congo, The Democratic Republic of the', 'Africa', 'Central Africa', 'CD');
INSERT INTO `country` VALUES ('COG', 'Congo', 'Africa', 'Central Africa', 'CG');
INSERT INTO `country` VALUES ('COK', 'Cook Islands', 'Oceania', 'Polynesia', 'CK');
INSERT INTO `country` VALUES ('COL', 'Colombia', 'South America', 'South America', 'CO');
INSERT INTO `country` VALUES ('COM', 'Comoros', 'Africa', 'Eastern Africa', 'KM');
INSERT INTO `country` VALUES ('CPV', 'Cape Verde', 'Africa', 'Western Africa', 'CV');
INSERT INTO `country` VALUES ('CRI', 'Costa Rica', 'North America', 'Central America', 'CR');
INSERT INTO `country` VALUES ('CUB', 'Cuba', 'North America', 'Caribbean', 'CU');
INSERT INTO `country` VALUES ('CXR', 'Christmas Island', 'Oceania', 'Australia and New Zealand', 'CX');
INSERT INTO `country` VALUES ('CYM', 'Cayman Islands', 'North America', 'Caribbean', 'KY');
INSERT INTO `country` VALUES ('CYP', 'Cyprus', 'Asia', 'Middle East', 'CY');
INSERT INTO `country` VALUES ('CZE', 'Czech Republic', 'Europe', 'Eastern Europe', 'CZ');
INSERT INTO `country` VALUES ('DEU', 'Germany', 'Europe', 'Western Europe', 'DE');
INSERT INTO `country` VALUES ('DJI', 'Djibouti', 'Africa', 'Eastern Africa', 'DJ');
INSERT INTO `country` VALUES ('DMA', 'Dominica', 'North America', 'Caribbean', 'DM');
INSERT INTO `country` VALUES ('DNK', 'Denmark', 'Europe', 'Nordic Countries', 'DK');
INSERT INTO `country` VALUES ('DOM', 'Dominican Republic', 'North America', 'Caribbean', 'DO');
INSERT INTO `country` VALUES ('DZA', 'Algeria', 'Africa', 'Northern Africa', 'DZ');
INSERT INTO `country` VALUES ('ECU', 'Ecuador', 'South America', 'South America', 'EC');
INSERT INTO `country` VALUES ('EGY', 'Egypt', 'Africa', 'Northern Africa', 'EG');
INSERT INTO `country` VALUES ('ERI', 'Eritrea', 'Africa', 'Eastern Africa', 'ER');
INSERT INTO `country` VALUES ('ESH', 'Western Sahara', 'Africa', 'Northern Africa', 'EH');
INSERT INTO `country` VALUES ('ESP', 'Spain', 'Europe', 'Southern Europe', 'ES');
INSERT INTO `country` VALUES ('EST', 'Estonia', 'Europe', 'Baltic Countries', 'EE');
INSERT INTO `country` VALUES ('ETH', 'Ethiopia', 'Africa', 'Eastern Africa', 'ET');
INSERT INTO `country` VALUES ('FIN', 'Finland', 'Europe', 'Nordic Countries', 'FI');
INSERT INTO `country` VALUES ('FJI', 'Fiji Islands', 'Oceania', 'Melanesia', 'FJ');
INSERT INTO `country` VALUES ('FLK', 'Falkland Islands', 'South America', 'South America', 'FK');
INSERT INTO `country` VALUES ('FRA', 'France', 'Europe', 'Western Europe', 'FR');
INSERT INTO `country` VALUES ('FRO', 'Faroe Islands', 'Europe', 'Nordic Countries', 'FO');
INSERT INTO `country` VALUES ('FSM', 'Micronesia, Federated States of', 'Oceania', 'Micronesia', 'FM');
INSERT INTO `country` VALUES ('GAB', 'Gabon', 'Africa', 'Central Africa', 'GA');
INSERT INTO `country` VALUES ('GBR', 'United Kingdom', 'Europe', 'British Islands', 'GB');
INSERT INTO `country` VALUES ('GEO', 'Georgia', 'Asia', 'Middle East', 'GE');
INSERT INTO `country` VALUES ('GHA', 'Ghana', 'Africa', 'Western Africa', 'GH');
INSERT INTO `country` VALUES ('GIB', 'Gibraltar', 'Europe', 'Southern Europe', 'GI');
INSERT INTO `country` VALUES ('GIN', 'Guinea', 'Africa', 'Western Africa', 'GN');
INSERT INTO `country` VALUES ('GLP', 'Guadeloupe', 'North America', 'Caribbean', 'GP');
INSERT INTO `country` VALUES ('GMB', 'Gambia', 'Africa', 'Western Africa', 'GM');
INSERT INTO `country` VALUES ('GNB', 'Guinea-Bissau', 'Africa', 'Western Africa', 'GW');
INSERT INTO `country` VALUES ('GNQ', 'Equatorial Guinea', 'Africa', 'Central Africa', 'GQ');
INSERT INTO `country` VALUES ('GRC', 'Greece', 'Europe', 'Southern Europe', 'GR');
INSERT INTO `country` VALUES ('GRD', 'Grenada', 'North America', 'Caribbean', 'GD');
INSERT INTO `country` VALUES ('GRL', 'Greenland', 'North America', 'North America', 'GL');
INSERT INTO `country` VALUES ('GTM', 'Guatemala', 'North America', 'Central America', 'GT');
INSERT INTO `country` VALUES ('GUF', 'French Guiana', 'South America', 'South America', 'GF');
INSERT INTO `country` VALUES ('GUM', 'Guam', 'Oceania', 'Micronesia', 'GU');
INSERT INTO `country` VALUES ('GUY', 'Guyana', 'South America', 'South America', 'GY');
INSERT INTO `country` VALUES ('HKG', 'Hong Kong', 'Asia', 'Eastern Asia', 'HK');
INSERT INTO `country` VALUES ('HMD', 'Heard Island and McDonald Islands', 'Antarctica', 'Antarctica', 'HM');
INSERT INTO `country` VALUES ('HND', 'Honduras', 'North America', 'Central America', 'HN');
INSERT INTO `country` VALUES ('HRV', 'Croatia', 'Europe', 'Southern Europe', 'HR');
INSERT INTO `country` VALUES ('HTI', 'Haiti', 'North America', 'Caribbean', 'HT');
INSERT INTO `country` VALUES ('HUN', 'Hungary', 'Europe', 'Eastern Europe', 'HU');
INSERT INTO `country` VALUES ('IDN', 'Indonesia', 'Asia', 'Southeast Asia', 'ID');
INSERT INTO `country` VALUES ('IND', 'India', 'Asia', 'Southern and Central Asia', 'IN');
INSERT INTO `country` VALUES ('IOT', 'British Indian Ocean Territory', 'Africa', 'Eastern Africa', 'IO');
INSERT INTO `country` VALUES ('IRL', 'Ireland', 'Europe', 'British Islands', 'IE');
INSERT INTO `country` VALUES ('IRN', 'Iran', 'Asia', 'Southern and Central Asia', 'IR');
INSERT INTO `country` VALUES ('IRQ', 'Iraq', 'Asia', 'Middle East', 'IQ');
INSERT INTO `country` VALUES ('ISL', 'Iceland', 'Europe', 'Nordic Countries', 'IS');
INSERT INTO `country` VALUES ('ISR', 'Israel', 'Asia', 'Middle East', 'IL');
INSERT INTO `country` VALUES ('ITA', 'Italy', 'Europe', 'Southern Europe', 'IT');
INSERT INTO `country` VALUES ('JAM', 'Jamaica', 'North America', 'Caribbean', 'JM');
INSERT INTO `country` VALUES ('JOR', 'Jordan', 'Asia', 'Middle East', 'JO');
INSERT INTO `country` VALUES ('JPN', 'Japan', 'Asia', 'Eastern Asia', 'JP');
INSERT INTO `country` VALUES ('KAZ', 'Kazakstan', 'Asia', 'Southern and Central Asia', 'KZ');
INSERT INTO `country` VALUES ('KEN', 'Kenya', 'Africa', 'Eastern Africa', 'KE');
INSERT INTO `country` VALUES ('KGZ', 'Kyrgyzstan', 'Asia', 'Southern and Central Asia', 'KG');
INSERT INTO `country` VALUES ('KHM', 'Cambodia', 'Asia', 'Southeast Asia', 'KH');
INSERT INTO `country` VALUES ('KIR', 'Kiribati', 'Oceania', 'Micronesia', 'KI');
INSERT INTO `country` VALUES ('KNA', 'Saint Kitts and Nevis', 'North America', 'Caribbean', 'KN');
INSERT INTO `country` VALUES ('KOR', 'South Korea', 'Asia', 'Eastern Asia', 'KR');
INSERT INTO `country` VALUES ('KWT', 'Kuwait', 'Asia', 'Middle East', 'KW');
INSERT INTO `country` VALUES ('LAO', 'Laos', 'Asia', 'Southeast Asia', 'LA');
INSERT INTO `country` VALUES ('LBN', 'Lebanon', 'Asia', 'Middle East', 'LB');
INSERT INTO `country` VALUES ('LBR', 'Liberia', 'Africa', 'Western Africa', 'LR');
INSERT INTO `country` VALUES ('LBY', 'Libyan Arab Jamahiriya', 'Africa', 'Northern Africa', 'LY');
INSERT INTO `country` VALUES ('LCA', 'Saint Lucia', 'North America', 'Caribbean', 'LC');
INSERT INTO `country` VALUES ('LIE', 'Liechtenstein', 'Europe', 'Western Europe', 'LI');
INSERT INTO `country` VALUES ('LKA', 'Sri Lanka', 'Asia', 'Southern and Central Asia', 'LK');
INSERT INTO `country` VALUES ('LSO', 'Lesotho', 'Africa', 'Southern Africa', 'LS');
INSERT INTO `country` VALUES ('LTU', 'Lithuania', 'Europe', 'Baltic Countries', 'LT');
INSERT INTO `country` VALUES ('LUX', 'Luxembourg', 'Europe', 'Western Europe', 'LU');
INSERT INTO `country` VALUES ('LVA', 'Latvia', 'Europe', 'Baltic Countries', 'LV');
INSERT INTO `country` VALUES ('MAC', 'Macao', 'Asia', 'Eastern Asia', 'MO');
INSERT INTO `country` VALUES ('MAR', 'Morocco', 'Africa', 'Northern Africa', 'MA');
INSERT INTO `country` VALUES ('MCO', 'Monaco', 'Europe', 'Western Europe', 'MC');
INSERT INTO `country` VALUES ('MDA', 'Moldova', 'Europe', 'Eastern Europe', 'MD');
INSERT INTO `country` VALUES ('MDG', 'Madagascar', 'Africa', 'Eastern Africa', 'MG');
INSERT INTO `country` VALUES ('MDV', 'Maldives', 'Asia', 'Southern and Central Asia', 'MV');
INSERT INTO `country` VALUES ('MEX', 'Mexico', 'North America', 'Central America', 'MX');
INSERT INTO `country` VALUES ('MHL', 'Marshall Islands', 'Oceania', 'Micronesia', 'MH');
INSERT INTO `country` VALUES ('MKD', 'Macedonia', 'Europe', 'Southern Europe', 'MK');
INSERT INTO `country` VALUES ('MLI', 'Mali', 'Africa', 'Western Africa', 'ML');
INSERT INTO `country` VALUES ('MLT', 'Malta', 'Europe', 'Southern Europe', 'MT');
INSERT INTO `country` VALUES ('MMR', 'Myanmar', 'Asia', 'Southeast Asia', 'MM');
INSERT INTO `country` VALUES ('MNG', 'Mongolia', 'Asia', 'Eastern Asia', 'MN');
INSERT INTO `country` VALUES ('MNP', 'Northern Mariana Islands', 'Oceania', 'Micronesia', 'MP');
INSERT INTO `country` VALUES ('MOZ', 'Mozambique', 'Africa', 'Eastern Africa', 'MZ');
INSERT INTO `country` VALUES ('MRT', 'Mauritania', 'Africa', 'Western Africa', 'MR');
INSERT INTO `country` VALUES ('MSR', 'Montserrat', 'North America', 'Caribbean', 'MS');
INSERT INTO `country` VALUES ('MTQ', 'Martinique', 'North America', 'Caribbean', 'MQ');
INSERT INTO `country` VALUES ('MUS', 'Mauritius', 'Africa', 'Eastern Africa', 'MU');
INSERT INTO `country` VALUES ('MWI', 'Malawi', 'Africa', 'Eastern Africa', 'MW');
INSERT INTO `country` VALUES ('MYS', 'Malaysia', 'Asia', 'Southeast Asia', 'MY');
INSERT INTO `country` VALUES ('MYT', 'Mayotte', 'Africa', 'Eastern Africa', 'YT');
INSERT INTO `country` VALUES ('NAM', 'Namibia', 'Africa', 'Southern Africa', 'NA');
INSERT INTO `country` VALUES ('NCL', 'New Caledonia', 'Oceania', 'Melanesia', 'NC');
INSERT INTO `country` VALUES ('NER', 'Niger', 'Africa', 'Western Africa', 'NE');
INSERT INTO `country` VALUES ('NFK', 'Norfolk Island', 'Oceania', 'Australia and New Zealand', 'NF');
INSERT INTO `country` VALUES ('NGA', 'Nigeria', 'Africa', 'Western Africa', 'NG');
INSERT INTO `country` VALUES ('NIC', 'Nicaragua', 'North America', 'Central America', 'NI');
INSERT INTO `country` VALUES ('NIU', 'Niue', 'Oceania', 'Polynesia', 'NU');
INSERT INTO `country` VALUES ('NLD', 'Netherlands', 'Europe', 'Western Europe', 'NL');
INSERT INTO `country` VALUES ('NOR', 'Norway', 'Europe', 'Nordic Countries', 'NO');
INSERT INTO `country` VALUES ('NPL', 'Nepal', 'Asia', 'Southern and Central Asia', 'NP');
INSERT INTO `country` VALUES ('NRU', 'Nauru', 'Oceania', 'Micronesia', 'NR');
INSERT INTO `country` VALUES ('NZL', 'New Zealand', 'Oceania', 'Australia and New Zealand', 'NZ');
INSERT INTO `country` VALUES ('OMN', 'Oman', 'Asia', 'Middle East', 'OM');
INSERT INTO `country` VALUES ('PAK', 'Pakistan', 'Asia', 'Southern and Central Asia', 'PK');
INSERT INTO `country` VALUES ('PAN', 'Panama', 'North America', 'Central America', 'PA');
INSERT INTO `country` VALUES ('PCN', 'Pitcairn', 'Oceania', 'Polynesia', 'PN');
INSERT INTO `country` VALUES ('PER', 'Peru', 'South America', 'South America', 'PE');
INSERT INTO `country` VALUES ('PHL', 'Philippines', 'Asia', 'Southeast Asia', 'PH');
INSERT INTO `country` VALUES ('PLW', 'Palau', 'Oceania', 'Micronesia', 'PW');
INSERT INTO `country` VALUES ('PNG', 'Papua New Guinea', 'Oceania', 'Melanesia', 'PG');
INSERT INTO `country` VALUES ('POL', 'Poland', 'Europe', 'Eastern Europe', 'PL');
INSERT INTO `country` VALUES ('PRI', 'Puerto Rico', 'North America', 'Caribbean', 'PR');
INSERT INTO `country` VALUES ('PRK', 'North Korea', 'Asia', 'Eastern Asia', 'KP');
INSERT INTO `country` VALUES ('PRT', 'Portugal', 'Europe', 'Southern Europe', 'PT');
INSERT INTO `country` VALUES ('PRY', 'Paraguay', 'South America', 'South America', 'PY');
INSERT INTO `country` VALUES ('PSE', 'Palestine', 'Asia', 'Middle East', 'PS');
INSERT INTO `country` VALUES ('PYF', 'French Polynesia', 'Oceania', 'Polynesia', 'PF');
INSERT INTO `country` VALUES ('QAT', 'Qatar', 'Asia', 'Middle East', 'QA');
INSERT INTO `country` VALUES ('REU', 'Réunion', 'Africa', 'Eastern Africa', 'RE');
INSERT INTO `country` VALUES ('ROM', 'Romania', 'Europe', 'Eastern Europe', 'RO');
INSERT INTO `country` VALUES ('RUS', 'Russian Federation', 'Europe', 'Eastern Europe', 'RU');
INSERT INTO `country` VALUES ('RWA', 'Rwanda', 'Africa', 'Eastern Africa', 'RW');
INSERT INTO `country` VALUES ('SAU', 'Saudi Arabia', 'Asia', 'Middle East', 'SA');
INSERT INTO `country` VALUES ('SDN', 'Sudan', 'Africa', 'Northern Africa', 'SD');
INSERT INTO `country` VALUES ('SEN', 'Senegal', 'Africa', 'Western Africa', 'SN');
INSERT INTO `country` VALUES ('SGP', 'Singapore', 'Asia', 'Southeast Asia', 'SG');
INSERT INTO `country` VALUES ('SGS', 'South Georgia and the South Sandwich Islands', 'Antarctica', 'Antarctica', 'GS');
INSERT INTO `country` VALUES ('SHN', 'Saint Helena', 'Africa', 'Western Africa', 'SH');
INSERT INTO `country` VALUES ('SJM', 'Svalbard and Jan Mayen', 'Europe', 'Nordic Countries', 'SJ');
INSERT INTO `country` VALUES ('SLB', 'Solomon Islands', 'Oceania', 'Melanesia', 'SB');
INSERT INTO `country` VALUES ('SLE', 'Sierra Leone', 'Africa', 'Western Africa', 'SL');
INSERT INTO `country` VALUES ('SLV', 'El Salvador', 'North America', 'Central America', 'SV');
INSERT INTO `country` VALUES ('SMR', 'San Marino', 'Europe', 'Southern Europe', 'SM');
INSERT INTO `country` VALUES ('SOM', 'Somalia', 'Africa', 'Eastern Africa', 'SO');
INSERT INTO `country` VALUES ('SPM', 'Saint Pierre and Miquelon', 'North America', 'North America', 'PM');
INSERT INTO `country` VALUES ('STP', 'Sao Tome and Principe', 'Africa', 'Central Africa', 'ST');
INSERT INTO `country` VALUES ('SUR', 'Suriname', 'South America', 'South America', 'SR');
INSERT INTO `country` VALUES ('SVK', 'Slovakia', 'Europe', 'Eastern Europe', 'SK');
INSERT INTO `country` VALUES ('SVN', 'Slovenia', 'Europe', 'Southern Europe', 'SI');
INSERT INTO `country` VALUES ('SWE', 'Sweden', 'Europe', 'Nordic Countries', 'SE');
INSERT INTO `country` VALUES ('SWZ', 'Swaziland', 'Africa', 'Southern Africa', 'SZ');
INSERT INTO `country` VALUES ('SYC', 'Seychelles', 'Africa', 'Eastern Africa', 'SC');
INSERT INTO `country` VALUES ('SYR', 'Syria', 'Asia', 'Middle East', 'SY');
INSERT INTO `country` VALUES ('TCA', 'Turks and Caicos Islands', 'North America', 'Caribbean', 'TC');
INSERT INTO `country` VALUES ('TCD', 'Chad', 'Africa', 'Central Africa', 'TD');
INSERT INTO `country` VALUES ('TGO', 'Togo', 'Africa', 'Western Africa', 'TG');
INSERT INTO `country` VALUES ('THA', 'Thailand', 'Asia', 'Southeast Asia', 'TH');
INSERT INTO `country` VALUES ('TJK', 'Tajikistan', 'Asia', 'Southern and Central Asia', 'TJ');
INSERT INTO `country` VALUES ('TKL', 'Tokelau', 'Oceania', 'Polynesia', 'TK');
INSERT INTO `country` VALUES ('TKM', 'Turkmenistan', 'Asia', 'Southern and Central Asia', 'TM');
INSERT INTO `country` VALUES ('TMP', 'East Timor', 'Asia', 'Southeast Asia', 'TP');
INSERT INTO `country` VALUES ('TON', 'Tonga', 'Oceania', 'Polynesia', 'TO');
INSERT INTO `country` VALUES ('TTO', 'Trinidad and Tobago', 'North America', 'Caribbean', 'TT');
INSERT INTO `country` VALUES ('TUN', 'Tunisia', 'Africa', 'Northern Africa', 'TN');
INSERT INTO `country` VALUES ('TUR', 'Turkey', 'Asia', 'Middle East', 'TR');
INSERT INTO `country` VALUES ('TUV', 'Tuvalu', 'Oceania', 'Polynesia', 'TV');
INSERT INTO `country` VALUES ('TWN', 'Taiwan', 'Asia', 'Eastern Asia', 'TW');
INSERT INTO `country` VALUES ('TZA', 'Tanzania', 'Africa', 'Eastern Africa', 'TZ');
INSERT INTO `country` VALUES ('UGA', 'Uganda', 'Africa', 'Eastern Africa', 'UG');
INSERT INTO `country` VALUES ('UKR', 'Ukraine', 'Europe', 'Eastern Europe', 'UA');
INSERT INTO `country` VALUES ('UMI', 'United States Minor Outlying Islands', 'Oceania', 'Micronesia/Caribbean', 'UM');
INSERT INTO `country` VALUES ('URY', 'Uruguay', 'South America', 'South America', 'UY');
INSERT INTO `country` VALUES ('USA', 'United States', 'North America', 'North America', 'US');
INSERT INTO `country` VALUES ('UZB', 'Uzbekistan', 'Asia', 'Southern and Central Asia', 'UZ');
INSERT INTO `country` VALUES ('VAT', 'Holy See (Vatican City State)', 'Europe', 'Southern Europe', 'VA');
INSERT INTO `country` VALUES ('VCT', 'Saint Vincent and the Grenadines', 'North America', 'Caribbean', 'VC');
INSERT INTO `country` VALUES ('VEN', 'Venezuela', 'South America', 'South America', 'VE');
INSERT INTO `country` VALUES ('VGB', 'Virgin Islands, British', 'North America', 'Caribbean', 'VG');
INSERT INTO `country` VALUES ('VIR', 'Virgin Islands, U.S.', 'North America', 'Caribbean', 'VI');
INSERT INTO `country` VALUES ('VNM', 'Vietnam', 'Asia', 'Southeast Asia', 'VN');
INSERT INTO `country` VALUES ('VUT', 'Vanuatu', 'Oceania', 'Melanesia', 'VU');
INSERT INTO `country` VALUES ('WLF', 'Wallis and Futuna', 'Oceania', 'Polynesia', 'WF');
INSERT INTO `country` VALUES ('WSM', 'Samoa', 'Oceania', 'Polynesia', 'WS');
INSERT INTO `country` VALUES ('YEM', 'Yemen', 'Asia', 'Middle East', 'YE');
INSERT INTO `country` VALUES ('YUG', 'Yugoslavia', 'Europe', 'Southern Europe', 'YU');
INSERT INTO `country` VALUES ('ZAF', 'South Africa', 'Africa', 'Southern Africa', 'ZA');
INSERT INTO `country` VALUES ('ZMB', 'Zambia', 'Africa', 'Eastern Africa', 'ZM');
INSERT INTO `country` VALUES ('ZWE', 'Zimbabwe', 'Africa', 'Eastern Africa', 'ZW');

-- ----------------------------
-- Table structure for `customers`
-- ----------------------------
CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_name` varchar(100) DEFAULT NULL,
  `customers_email` varchar(60) DEFAULT NULL,
  `customers_phone` varchar(20) DEFAULT NULL,
  `customers_address` varchar(150) DEFAULT NULL,
  `customers_city` varchar(60) DEFAULT NULL,
  `customers_state` varchar(45) DEFAULT NULL,
  `customers_country` varchar(45) DEFAULT NULL,
  `customers_zip` varchar(45) DEFAULT NULL,
  `sec_users_login` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`customers_id`),
  KEY `fk_customers_sec_users1_idx` (`sec_users_login`),
  CONSTRAINT `fk_customers_sec_users1` FOREIGN KEY (`sec_users_login`) REFERENCES `sec_users` (`login`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of customers
-- ----------------------------
INSERT INTO `customers` VALUES ('1', 'Matheus', 'matheus@scriptcase.net', '', 'Av. Presidente Kennedy 1001', 'Olinda', 'Pernambuco', 'BRA', '53230630', 'matheus');
INSERT INTO `customers` VALUES ('2', 'Mark', 'mark@scriptcase.net', '8888888888888888', '620 East John Street', 'Chicago', 'Illinois', 'USA', '60106', 'mark');
INSERT INTO `customers` VALUES ('3', 'Luke', 'luke@scriptcase.net', '123456789', 'Central Avenue Jazz Park', 'Los Angeles', 'California', 'USA', '90011', 'luke');
INSERT INTO `customers` VALUES ('5', 'Kyle', 'kyle@scriptcase.net', '', '', 'Recife', 'Pernambuco', 'BRA', '', 'kyle');

-- ----------------------------
-- Table structure for `emails_x_appointments_type`
-- ----------------------------
CREATE TABLE `emails_x_appointments_type` (
  `email_templates_id` int(11) NOT NULL,
  `appointments_type_id` int(11) NOT NULL,
  `events_id` int(11) NOT NULL,
  PRIMARY KEY (`email_templates_id`,`appointments_type_id`),
  KEY `fk_email_templates_has_appointments_type_appointments_type1_idx` (`appointments_type_id`),
  KEY `fk_email_templates_has_appointments_type_email_templates1_idx` (`email_templates_id`),
  KEY `fk_emails_x_appointments_type_events1_idx` (`events_id`),
  CONSTRAINT `fk_emails_x_appointments_type_events1` FOREIGN KEY (`events_id`) REFERENCES `events` (`events_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_email_templates_has_appointments_type_appointments_type1` FOREIGN KEY (`appointments_type_id`) REFERENCES `appointments_type` (`appointments_type_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_email_templates_has_appointments_type_email_templates1` FOREIGN KEY (`email_templates_id`) REFERENCES `email_templates` (`email_templates_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of emails_x_appointments_type
-- ----------------------------

-- ----------------------------
-- Table structure for `email_templates`
-- ----------------------------
CREATE TABLE `email_templates` (
  `email_templates_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_subject` varchar(45) DEFAULT NULL,
  `email_body` text,
  PRIMARY KEY (`email_templates_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of email_templates
-- ----------------------------

-- ----------------------------
-- Table structure for `events`
-- ----------------------------
CREATE TABLE `events` (
  `events_id` int(11) NOT NULL AUTO_INCREMENT,
  `events_description` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of events
-- ----------------------------

-- ----------------------------
-- Table structure for `sec_apps`
-- ----------------------------
CREATE TABLE `sec_apps` (
  `app_name` varchar(128) NOT NULL,
  `app_type` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`app_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sec_apps
-- ----------------------------
INSERT INTO `sec_apps` VALUES ('appointment_billing', 'cons', null);
INSERT INTO `sec_apps` VALUES ('appointment_invoice', 'pdf', null);
INSERT INTO `sec_apps` VALUES ('app_change_pswd', '', null);
INSERT INTO `sec_apps` VALUES ('app_form_add_users', 'form', null);
INSERT INTO `sec_apps` VALUES ('app_form_edit_users', 'form', null);
INSERT INTO `sec_apps` VALUES ('app_form_sec_apps', 'form', null);
INSERT INTO `sec_apps` VALUES ('app_form_sec_groups', 'form', null);
INSERT INTO `sec_apps` VALUES ('app_form_sec_groups_apps', 'form', null);
INSERT INTO `sec_apps` VALUES ('app_grid_sec_apps', 'cons', null);
INSERT INTO `sec_apps` VALUES ('app_grid_sec_groups', 'cons', null);
INSERT INTO `sec_apps` VALUES ('app_grid_sec_users', 'cons', null);
INSERT INTO `sec_apps` VALUES ('app_Login', '', null);
INSERT INTO `sec_apps` VALUES ('app_retrieve_pswd', '', null);
INSERT INTO `sec_apps` VALUES ('app_search_sec_groups', '', null);
INSERT INTO `sec_apps` VALUES ('app_sync_apps', '', null);
INSERT INTO `sec_apps` VALUES ('calendar_appointments', 'calendar', null);
INSERT INTO `sec_apps` VALUES ('calendar_appointments_staff', 'calendar', null);
INSERT INTO `sec_apps` VALUES ('chart_appointments_avg_rating', '', null);
INSERT INTO `sec_apps` VALUES ('chart_appointments_count', '', null);
INSERT INTO `sec_apps` VALUES ('dashboard_adm', '', null);
INSERT INTO `sec_apps` VALUES ('form_appointments', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointments_rating', 'form', '');
INSERT INTO `sec_apps` VALUES ('form_appointments_type', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointments_weekdays', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointments_worktime', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointment_details', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointment_details_inline', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointment_status', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_appointment_status_inline', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_customers', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_request_appointments', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_staff', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_staff_worktime', 'form', null);
INSERT INTO `sec_apps` VALUES ('form_unavailable_dates', 'form', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_adm', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_adm_dashboard', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_customer', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_history', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_staff', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_type', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointments_weekdays', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_appointment_details', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_count_new_appointments', '', null);
INSERT INTO `sec_apps` VALUES ('grid_customers', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_customers_address', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_general_dashboard_adm', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_staff', 'cons', null);
INSERT INTO `sec_apps` VALUES ('grid_unavailable_dates', 'cons', null);
INSERT INTO `sec_apps` VALUES ('home', '', null);
INSERT INTO `sec_apps` VALUES ('json', '', null);
INSERT INTO `sec_apps` VALUES ('menu', '', null);
INSERT INTO `sec_apps` VALUES ('my_calendar', '', null);
INSERT INTO `sec_apps` VALUES ('new_request_catalog', '', null);
INSERT INTO `sec_apps` VALUES ('tabs_appointments', '', null);

-- ----------------------------
-- Table structure for `sec_groups`
-- ----------------------------
CREATE TABLE `sec_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sec_groups
-- ----------------------------
INSERT INTO `sec_groups` VALUES ('1', 'Administrator');
INSERT INTO `sec_groups` VALUES ('3', 'Customer');
INSERT INTO `sec_groups` VALUES ('2', 'Staff');

-- ----------------------------
-- Table structure for `sec_groups_apps`
-- ----------------------------
CREATE TABLE `sec_groups_apps` (
  `group_id` int(11) NOT NULL,
  `app_name` varchar(128) NOT NULL,
  `priv_access` varchar(1) DEFAULT NULL,
  `priv_insert` varchar(1) DEFAULT NULL,
  `priv_delete` varchar(1) DEFAULT NULL,
  `priv_update` varchar(1) DEFAULT NULL,
  `priv_export` varchar(1) DEFAULT NULL,
  `priv_print` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`group_id`,`app_name`),
  KEY `sec_groups_apps_ibfk_2` (`app_name`),
  CONSTRAINT `sec_groups_apps_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `sec_groups_apps_ibfk_2` FOREIGN KEY (`app_name`) REFERENCES `sec_apps` (`app_name`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sec_groups_apps
-- ----------------------------
INSERT INTO `sec_groups_apps` VALUES ('1', 'appointment_billing', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'appointment_invoice', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_change_pswd', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_form_add_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_grid_sec_apps', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_grid_sec_groups', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_grid_sec_users', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_Login', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_retrieve_pswd', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_search_sec_groups', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'app_sync_apps', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'calendar_appointments', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'calendar_appointments_staff', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'chart_appointments_avg_rating', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'chart_appointments_count', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'dashboard_adm', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointments', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointments_rating', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointments_type', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointments_weekdays', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointments_worktime', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointment_details', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointment_details_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointment_status', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_appointment_status_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_customers', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_request_appointments', '', 'Y', 'Y', 'Y', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_staff', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_staff_worktime', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'form_unavailable_dates', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_adm', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_adm_dashboard', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_customer', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_history', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_staff', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_type', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointments_weekdays', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_appointment_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_count_new_appointments', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_customers', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_customers_address', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_general_dashboard_adm', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_staff', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'grid_unavailable_dates', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('1', 'home', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'json', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'menu', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'my_calendar', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'new_request_catalog', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('1', 'tabs_appointments', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'appointment_billing', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('2', 'appointment_invoice', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_change_pswd', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_form_add_users', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_form_edit_users', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_form_sec_apps', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_form_sec_groups', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_form_sec_groups_apps', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_grid_sec_apps', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_grid_sec_groups', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_grid_sec_users', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_Login', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_retrieve_pswd', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_search_sec_groups', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'app_sync_apps', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'calendar_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'calendar_appointments_staff', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'chart_appointments_avg_rating', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'chart_appointments_count', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'dashboard_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointments_rating', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointments_type', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointments_weekdays', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointments_worktime', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointment_details', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointment_details_inline', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointment_status', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_appointment_status_inline', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_customers', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_request_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_staff', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_staff_worktime', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'form_unavailable_dates', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_adm_dashboard', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_customer', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_history', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_staff', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_type', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointments_weekdays', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_appointment_details', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_count_new_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_customers', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_customers_address', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_general_dashboard_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_staff', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'grid_unavailable_dates', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'home', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'json', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'menu', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('2', 'my_calendar', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'new_request_catalog', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('2', 'tabs_appointments', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'appointment_billing', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('3', 'appointment_invoice', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_change_pswd', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_form_add_users', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_form_edit_users', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_form_sec_apps', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_form_sec_groups', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_form_sec_groups_apps', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_grid_sec_apps', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_grid_sec_groups', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_grid_sec_users', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_Login', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_retrieve_pswd', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_search_sec_groups', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'app_sync_apps', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'calendar_appointments', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'calendar_appointments_staff', '', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'chart_appointments_avg_rating', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'chart_appointments_count', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'dashboard_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointments_rating', 'Y', '', '', 'Y', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointments_type', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointments_weekdays', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointments_worktime', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointment_details', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointment_details_inline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointment_status', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_appointment_status_inline', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_customers', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_request_appointments', 'Y', '', '', 'Y', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_staff', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_staff_worktime', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'form_unavailable_dates', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_adm_dashboard', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_customer', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_history', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_staff', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_type', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointments_weekdays', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_appointment_details', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_count_new_appointments', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_customers', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_customers_address', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_general_dashboard_adm', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_staff', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'grid_unavailable_dates', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'home', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'json', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'menu', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'my_calendar', null, null, null, null, null, null);
INSERT INTO `sec_groups_apps` VALUES ('3', 'new_request_catalog', 'Y', '', '', '', '', '');
INSERT INTO `sec_groups_apps` VALUES ('3', 'tabs_appointments', 'Y', '', '', '', '', '');

-- ----------------------------
-- Table structure for `sec_users`
-- ----------------------------
CREATE TABLE `sec_users` (
  `login` varchar(32) NOT NULL,
  `pswd` varchar(32) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `email` varchar(64) DEFAULT NULL,
  `is_active` varchar(1) DEFAULT NULL,
  `activation_code` varchar(32) DEFAULT NULL,
  `priv_admin` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO `sec_users` VALUES ('abraham', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);
INSERT INTO `sec_users` VALUES ('admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Admin', 'admin@admin.com', 'Y', null, 'Y');
INSERT INTO `sec_users` VALUES ('carlos', '81dc9bdb52d04dc20036dbd8313ed055', null, null, 'Y', null, null);
INSERT INTO `sec_users` VALUES ('isaac', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);
INSERT INTO `sec_users` VALUES ('jacob', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);
INSERT INTO `sec_users` VALUES ('kyle', '81dc9bdb52d04dc20036dbd8313ed055', null, null, 'Y', null, null);
INSERT INTO `sec_users` VALUES ('luke', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);
INSERT INTO `sec_users` VALUES ('mark', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);
INSERT INTO `sec_users` VALUES ('matheus', '81dc9bdb52d04dc20036dbd8313ed055', '', '', 'Y', null, null);

-- ----------------------------
-- Table structure for `sec_users_groups`
-- ----------------------------
CREATE TABLE `sec_users_groups` (
  `login` varchar(32) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`login`,`group_id`),
  KEY `sec_users_groups_ibfk_2` (`group_id`),
  CONSTRAINT `sec_users_groups_ibfk_1` FOREIGN KEY (`login`) REFERENCES `sec_users` (`login`) ON DELETE CASCADE,
  CONSTRAINT `sec_users_groups_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `sec_groups` (`group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sec_users_groups
-- ----------------------------
INSERT INTO `sec_users_groups` VALUES ('abraham', '2');
INSERT INTO `sec_users_groups` VALUES ('admin', '1');
INSERT INTO `sec_users_groups` VALUES ('carlos', '2');
INSERT INTO `sec_users_groups` VALUES ('isaac', '2');
INSERT INTO `sec_users_groups` VALUES ('jacob', '2');
INSERT INTO `sec_users_groups` VALUES ('kyle', '3');
INSERT INTO `sec_users_groups` VALUES ('luke', '3');
INSERT INTO `sec_users_groups` VALUES ('mark', '3');
INSERT INTO `sec_users_groups` VALUES ('matheus', '3');

-- ----------------------------
-- Table structure for `staff`
-- ----------------------------
CREATE TABLE `staff` (
  `staff_id` int(11) NOT NULL,
  `staff_name` varchar(100) DEFAULT NULL,
  `staff_email` varchar(60) DEFAULT NULL,
  `staff_phone` varchar(20) DEFAULT NULL,
  `sec_users_login` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`staff_id`),
  KEY `fk_staff_sec_users1_idx` (`sec_users_login`),
  CONSTRAINT `fk_staff_sec_users1` FOREIGN KEY (`sec_users_login`) REFERENCES `sec_users` (`login`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of staff
-- ----------------------------
INSERT INTO `staff` VALUES ('0', 'None', 'administrator@scriptcase.net', null, 'admin');
INSERT INTO `staff` VALUES ('1', 'Abraham', 'abraham@scriptcase.net', '', 'abraham');
INSERT INTO `staff` VALUES ('2', 'Isaac', 'isaac@scriptcase.net', '', 'isaac');
INSERT INTO `staff` VALUES ('3', 'Jacob', 'jacob@scriptcase.net', '1234509876', 'jacob');
INSERT INTO `staff` VALUES ('4', 'Carlos', 'carlos@scriptcase.net', '', 'carlos');

ALTER TABLE `staff` AUTO_INCREMENT=5;

-- ----------------------------
-- Table structure for `staff_unavailable`
-- ----------------------------
CREATE TABLE `staff_unavailable` (
  `staff_id` int(11) NOT NULL,
  `unavailable_dates_id` int(11) NOT NULL,
  PRIMARY KEY (`staff_id`,`unavailable_dates_id`),
  KEY `fk_unavailable_date` (`unavailable_dates_id`),
  CONSTRAINT `fk_staff` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`staff_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_unavailable_date` FOREIGN KEY (`unavailable_dates_id`) REFERENCES `unavailable_dates` (`unavailable_dates_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of staff_unavailable
-- ----------------------------

-- ----------------------------
-- Table structure for `staff_worktime`
-- ----------------------------
CREATE TABLE `staff_worktime` (
  `staff_worktime_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `week_day` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  PRIMARY KEY (`staff_worktime_id`),
  KEY `fk_staff_worktime_staff1_idx` (`staff_id`),
  CONSTRAINT `fk_staff_worktime_staff1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`staff_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of staff_worktime
-- ----------------------------
INSERT INTO `staff_worktime` VALUES ('1', '1', '2', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('2', '1', '3', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('3', '1', '4', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('4', '1', '5', '08:00:00', '16:00:00');
INSERT INTO `staff_worktime` VALUES ('5', '1', '6', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('6', '2', '2', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('7', '2', '3', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('8', '2', '4', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('9', '2', '5', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('10', '2', '6', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('11', '3', '2', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('12', '3', '3', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('13', '3', '4', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('14', '3', '5', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('15', '3', '6', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('57', '4', '2', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('58', '4', '3', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('62', '4', '4', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('63', '4', '5', '08:00:00', '18:00:00');
INSERT INTO `staff_worktime` VALUES ('64', '4', '6', '08:00:00', '18:00:00');

-- ----------------------------
-- Table structure for `unavailable_dates`
-- ----------------------------
CREATE TABLE `unavailable_dates` (
  `unavailable_dates_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `yearly` varchar(1) DEFAULT NULL,
  `individual` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`unavailable_dates_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of unavailable_dates
-- ----------------------------
INSERT INTO `unavailable_dates` VALUES ('1', 'Christmas', '2015-12-25', '00:00:00', '2015-12-25', '23:59:59', 'Y', 'N');
INSERT INTO `unavailable_dates` VALUES ('2', 'Halloween', '2015-11-02', '00:00:00', '2015-11-02', '23:59:59', 'Y', 'N');
INSERT INTO `unavailable_dates` VALUES ('3', 'Holliday', '2015-12-08', '00:00:00', '2015-12-08', '23:59:59', 'N', 'N');

-- ----------------------------
-- Table structure for `weekdays_x_worktime`
-- ----------------------------
CREATE TABLE `weekdays_x_worktime` (
  `id_weekday` int(11) NOT NULL,
  `id_worktime` int(11) NOT NULL,
  PRIMARY KEY (`id_weekday`,`id_worktime`),
  KEY `fk_worktime` (`id_worktime`),
  CONSTRAINT `fk_weekday` FOREIGN KEY (`id_weekday`) REFERENCES `appointments_weekdays` (`id_weekday`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_worktime` FOREIGN KEY (`id_worktime`) REFERENCES `appointments_worktime` (`id_worktime`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of weekdays_x_worktime
-- ----------------------------
INSERT INTO `weekdays_x_worktime` VALUES ('2', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '8');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '9');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '10');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '11');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '12');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '13');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '14');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '15');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '16');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '17');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '18');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '19');
INSERT INTO `weekdays_x_worktime` VALUES ('2', '20');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '8');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '9');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '10');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '11');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '12');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '13');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '14');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '15');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '16');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '17');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '18');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '19');
INSERT INTO `weekdays_x_worktime` VALUES ('3', '20');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '8');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '9');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '10');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '11');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '12');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '13');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '14');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '15');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '16');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '17');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '18');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '19');
INSERT INTO `weekdays_x_worktime` VALUES ('4', '20');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '8');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '9');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '10');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '11');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '12');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '13');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '14');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '15');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '16');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '17');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '18');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '19');
INSERT INTO `weekdays_x_worktime` VALUES ('5', '20');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '8');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '9');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '10');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '11');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '12');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '13');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '14');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '15');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '16');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '17');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '18');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '19');
INSERT INTO `weekdays_x_worktime` VALUES ('6', '20');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '1');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '2');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '3');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '4');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '5');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '6');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '7');
INSERT INTO `weekdays_x_worktime` VALUES ('7', '8');

-- ----------------------------
-- View structure for `adm_dashboard`
-- ----------------------------
CREATE VIEW `adm_dashboard` AS select `s`.`staff_name` AS `staff`,(select count(`appointments`.`appointments_id`) from `appointments` where (`appointments`.`staff_id` = `a`.`staff_id`)) AS `total_appointments`,(select count(`appointments`.`appointments_id`) from `appointments` where ((`appointments`.`staff_id` = `a`.`staff_id`) and (`appointments`.`current_status_id` = 5))) AS `concluded`,(select count(`appointments`.`appointments_id`) from `appointments` where ((`appointments`.`staff_id` = `a`.`staff_id`) and (`appointments`.`current_status_id` = 3))) AS `canceled`,(select avg(`appointments`.`appointment_rating`) from `appointments` where ((`appointments`.`staff_id` = `a`.`staff_id`) and (`appointments`.`current_status_id` = 5) and (`appointments`.`appointment_rating` is not null))) AS `avg_rating`,sum(`at`.`duration`) AS `total_hours`,(select sum(`appointments`.`total_price`) from `appointments` where ((`appointments`.`staff_id` = `a`.`staff_id`) and (`appointments`.`current_status_id` = 5))) AS `total_price` from (((`appointments` `a` join `staff` `s` on((`a`.`staff_id` = `s`.`staff_id`))) join `appointment_details` `ad` on((`a`.`appointments_id` = `ad`.`appointments_id`))) join `appointments_type` `at` on((`ad`.`appointments_type_id` = `at`.`appointments_type_id`))) where (`a`.`current_status_id` = 5) group by `a`.`staff_id`,`s`.`staff_name` order by `s`.`staff_name` ;
