<?php

    #   Chaging schemas settings
    #   File path: devel/conf/scriptcase/schema/schema.php
    #   Author: John L. Santos

    $path = scandir(__DIR__);

    $restrict_file      = array(".", "..", "index.html", "schema.php", "telematica_suricato.ini");
    $specific_version   = array("Sc3", "Sc4", "Sc5", "Sc6", "Sc7", "Sc8");
    $specific_theme     = array("Sweet Amour", "Sweet Blue", "Sweet Coral", "Sweet Golden Sand", "Sweet Hollyhock", "Midnight");

    foreach($path as $schema) {
        if (!in_array($schema, $restrict_file)) {

            # Schema version
            $version = substr($schema, 0, 3);

            $content    = file_get_contents($schema);
            $un         = unserialize($content);

            # Specific versions
            //BEGIN
            if (in_array($version, $specific_version)) {
                # Eg.:
                # $un["schema"]["css_grid_label_background_color"]  = "";
                # <Apply here>

            }
            //END

            # Specific themes
            //BEGIN
            if (in_array($un["schema"]["css_schema_info_name"], $specific_theme)) {
                # Eg.:
                # $un["schema"]["css_grid_label_background_color"]  = "";
                # <Apply here>

            }
            //END

            //BEGIN
            # General themes
            # Eg.:
            # $un["schema"]["css_grid_label_background_color"]  = "";
            # <Apply here>
            $un["schema"]["css_quicksearchdiv_moldura_background_color"]                    = $un["schema"]["css_grid_moldura_background_color"];
            $un["schema"]["css_quicksearchdiv_moldura_background_image"]                    = $un["schema"]["css_grid_moldura_background_image"];
            $un["schema"]["css_quicksearchdiv_moldura_background_position"]                 = $un["schema"]["css_grid_moldura_background_position"];
            $un["schema"]["css_quicksearchdiv_moldura_background_repeat"]                   = $un["schema"]["css_grid_moldura_background_repeat"];
            $un["schema"]["css_quicksearchdiv_moldura_opacity"]                             = "100";
            $un["schema"]["css_quicksearchdiv_moldura_border_color"]                        = $un["schema"]["css_grid_moldura_border_color"];
            $un["schema"]["css_quicksearchdiv_moldura_border_style"]                        = $un["schema"]["css_grid_moldura_border_style"];
            $un["schema"]["css_quicksearchdiv_moldura_border_width"]                        = $un["schema"]["css_grid_moldura_border_width"];
            $un["schema"]["css_quicksearchdiv_moldura_border_collapse"]                     = $un["schema"]["css_grid_moldura_border_collapse"];
            $un["schema"]["css_quicksearchdiv_moldura_padding"]                             = "10px";
            $un["schema"]["css_quicksearchdiv_moldura_margin"]                              = "0px 0px 0px -10px";
            $un["schema"]["css_quicksearchdiv_moldura_radius"]                              = $un["schema"]["css_grid_moldura_radius"];
            $un["schema"]["css_quicksearchdiv_moldura_box_shadow"]                          = "0 6px 12px rgba(0, 0, 0, 0.175)";
            $un["schema"]["css_quicksearchdiv_moldura_width"]                               = "250px";
            $un["schema"]["css_quicksearchdiv_moldura_min_width"]                           = "";
            $un["schema"]["css_quicksearchdiv_moldura_max_width"]                           = "";

            $un["schema"]["css_quicksearchdiv_label_background_color"]                      = $un["schema"]["css_grid_moldura_background_color"];
            $un["schema"]["css_quicksearchdiv_label_background_image"]                      = $un["schema"]["css_grid_moldura_background_image"];
            $un["schema"]["css_quicksearchdiv_label_background_position"]                   = $un["schema"]["css_grid_moldura_background_position"];
            $un["schema"]["css_quicksearchdiv_label_background_repeat"]                     = $un["schema"]["css_grid_moldura_background_repeat"];
            $un["schema"]["css_quicksearchdiv_label_opacity"]                               = "100";
            $un["schema"]["css_quicksearchdiv_label_border_color"]                          = $un["schema"]["css_grid_moldura_border_color"];
            $un["schema"]["css_quicksearchdiv_label_border_style"]                          = "none";
            $un["schema"]["css_quicksearchdiv_label_border_width"]                          = $un["schema"]["css_grid_moldura_border_width"];
            $un["schema"]["css_quicksearchdiv_label_color"]                                 = $un["schema"]["css_grid_label_link_color"];
            $un["schema"]["css_quicksearchdiv_label_font"]                                  = $un["schema"]["css_grid_label_font"];
            $un["schema"]["css_quicksearchdiv_label_font_size"]                             = $un["schema"]["css_grid_label_font_size"];
            $un["schema"]["css_quicksearchdiv_label_text_shadow"]                           = $un["schema"]["css_grid_label_text_shadow"];
            $un["schema"]["css_quicksearchdiv_label_font_weight"]                           = $un["schema"]["css_grid_label_font_weight"];
            $un["schema"]["css_quicksearchdiv_label_padding"]                               = "0";
            $un["schema"]["css_quicksearchdiv_label_spacing"]                               = $un["schema"]["css_grid_label_spacing"];
            $un["schema"]["css_quicksearchdiv_label_text_decoration"]                       = $un["schema"]["css_grid_label_text_decoration"];
            $un["schema"]["css_quicksearchdiv_label_vertical_align"]                        = $un["schema"]["css_grid_label_vertical_align"];
            $un["schema"]["css_quicksearchdiv_label_margin"]                                = "8px 0 0 0";
            $un["schema"]["css_quicksearchdiv_label_text_transform"]                        = "";
            $un["schema"]["css_quicksearchdiv_label_letter_spacing"]                        = "";
            $un["schema"]["css_quicksearchdiv_label_text_align"]                            = "left";
            $un["schema"]["css_quicksearchdiv_label_text_alignrtl"]                         = "right";

            $un["schema"]["css_quicksearchdiv_result_background_color"]                     = $un["schema"]["css_form_campo_impar_simples_background_color"];
            $un["schema"]["css_quicksearchdiv_result_background_image"]                     = $un["schema"]["css_form_campo_impar_simples_background_image"];
            $un["schema"]["css_quicksearchdiv_result_background_position"]                  = $un["schema"]["css_form_campo_impar_simples_background_position"];
            $un["schema"]["css_quicksearchdiv_result_background_repeat"]                    = $un["schema"]["css_form_campo_impar_simples_background_repeat"];
            $un["schema"]["css_quicksearchdiv_result_opacity"]                              = "100";
            $un["schema"]["css_quicksearchdiv_result_border_color"]                         = $un["schema"]["css_form_campo_impar_simples_border_color"];
            $un["schema"]["css_quicksearchdiv_result_border_style"]                         = $un["schema"]["css_form_campo_impar_simples_border_style"];
            $un["schema"]["css_quicksearchdiv_result_border_width"]                         = "1px";
            $un["schema"]["css_quicksearchdiv_result_padding"]                              = "5px";
            $un["schema"]["css_quicksearchdiv_result_spacing"]                              = "";
            $un["schema"]["css_quicksearchdiv_result_vertical_align"]                       = $un["schema"]["css_form_campo_impar_simples_vertical_align"];
            $un["schema"]["css_quicksearchdiv_result_margin"]                               = "";
            $un["schema"]["css_quicksearchdiv_result_color"]                                = $un["schema"]["css_form_campo_impar_simples_color"];
            $un["schema"]["css_quicksearchdiv_result_font"]                                 = $un["schema"]["css_form_campo_impar_simples_font"];
            $un["schema"]["css_quicksearchdiv_result_font_size"]                            = $un["schema"]["css_form_campo_impar_simples_font_size"];
            $un["schema"]["css_quicksearchdiv_result_text_shadow"]                          = $un["schema"]["css_form_campo_impar_simples_text_shadow"];
            $un["schema"]["css_quicksearchdiv_result_font_weight"]                          = $un["schema"]["css_form_campo_impar_simples_font_weight"];
            $un["schema"]["css_quicksearchdiv_result_text_decoration"]                      = $un["schema"]["css_form_campo_impar_simples_text_decoration"];
            $un["schema"]["css_quicksearchdiv_result_text_transform"]                       = "";
            $un["schema"]["css_quicksearchdiv_result_letter_spacing"]                       = "";
            $un["schema"]["css_quicksearchdiv_result_text_align"]                           = "left";
            $un["schema"]["css_quicksearchdiv_result_text_alignrtl"]                        = "right";

            $un["schema"]["css_quicksearchdiv_resulttag_background_color"]                  = "";
            $un["schema"]["css_quicksearchdiv_resulttag_background_image"]                  = "";
            $un["schema"]["css_quicksearchdiv_resulttag_background_position"]               = "";
            $un["schema"]["css_quicksearchdiv_resulttag_background_repeat"]                 = "";
            $un["schema"]["css_quicksearchdiv_resulttag_opacity"]                           = "100";
            $un["schema"]["css_quicksearchdiv_resulttag_border_color"]                      = "";
            $un["schema"]["css_quicksearchdiv_resulttag_border_style"]                      = "";
            $un["schema"]["css_quicksearchdiv_resulttag_border_width"]                      = "";
            $un["schema"]["css_quicksearchdiv_resulttag_padding"]                           = "";
            $un["schema"]["css_quicksearchdiv_resulttag_spacing"]                           = "";
            $un["schema"]["css_quicksearchdiv_resulttag_vertical_align"]                    = "";
            $un["schema"]["css_quicksearchdiv_resulttag_margin"]                            = "";
            $un["schema"]["css_quicksearchdiv_resulttag_color"]                             = "";
            $un["schema"]["css_quicksearchdiv_resulttag_font"]                              = "";
            $un["schema"]["css_quicksearchdiv_resulttag_font_size"]                         = "";
            $un["schema"]["css_quicksearchdiv_resulttag_text_shadow"]                       = "";
            $un["schema"]["css_quicksearchdiv_resulttag_font_weight"]                       = "";
            $un["schema"]["css_quicksearchdiv_resulttag_text_decoration"]                   = "";
            $un["schema"]["css_quicksearchdiv_resulttag_radius"]                            = "";
            $un["schema"]["css_quicksearchdiv_resulttag_text_align"]                        = "left";
            $un["schema"]["css_quicksearchdiv_resulttag_text_alignrtl"]                     = "right";

            $un["schema"]["css_quicksearchdiv_dropdown_background_color"]                   = $un["schema"]["css_form_objeto_impar_simples_background_color"];
            $un["schema"]["css_quicksearchdiv_dropdown_background_image"]                   = "";
            $un["schema"]["css_quicksearchdiv_dropdown_background_position"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdown_background_repeat"]                  = "";
            $un["schema"]["css_quicksearchdiv_dropdown_opacity"]                            = "100";
            $un["schema"]["css_quicksearchdiv_dropdown_border_color"]                       = $un["schema"]["css_form_objeto_impar_simples_color"];
            $un["schema"]["css_quicksearchdiv_dropdown_border_style"]                       = "";
            $un["schema"]["css_quicksearchdiv_dropdown_border_width"]                       = "";
            $un["schema"]["css_quicksearchdiv_dropdown_border_collapse"]                    = "";
            $un["schema"]["css_quicksearchdiv_dropdown_padding"]                            = "";
            $un["schema"]["css_quicksearchdiv_dropdown_margin"]                             = "";
            $un["schema"]["css_quicksearchdiv_dropdown_radius"]                             = "";
            $un["schema"]["css_quicksearchdiv_dropdown_box_shadow"]                         = "";
            $un["schema"]["css_quicksearchdiv_dropdown_width"]                              = "";
            $un["schema"]["css_quicksearchdiv_dropdown_min_width"]                          = "";
            $un["schema"]["css_quicksearchdiv_dropdown_max_width"]                          = "";

            $un["schema"]["css_quicksearchdiv_dropdownitem_background_color"]               = $un["schema"]["css_form_objeto_impar_simples_background_color"];
            $un["schema"]["css_quicksearchdiv_dropdownitem_background_image"]               = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_background_position"]            = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_background_repeat"]              = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_opacity"]                        = "100";
            $un["schema"]["css_quicksearchdiv_dropdownitem_border_color"]                   = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_border_style"]                   = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_border_width"]                   = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_color"]                          = $un["schema"]["css_form_objeto_impar_simples_color"];
            $un["schema"]["css_quicksearchdiv_dropdownitem_font"]                           = $un["schema"]["css_grid_label_font"];
            $un["schema"]["css_quicksearchdiv_dropdownitem_font_size"]                      = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_text_shadow"]                    = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_font_weight"]                    = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_padding"]                        = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_spacing"]                        = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_text_decoration"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_vertical_align"]                 = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_margin"]                         = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_text_transform"]                 = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_letter_spacing"]                 = "";
            $un["schema"]["css_quicksearchdiv_dropdownitem_text_align"]                     = "left";
            $un["schema"]["css_quicksearchdiv_dropdownitem_text_alignrtl"]                  = "right";

            $un["schema"]["css_quicksearchdiv_dropdownitemover_background_color"]           = "#5897fb";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_background_image"]           = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_background_position"]        = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_background_repeat"]          = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_opacity"]                    = "100";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_border_color"]               = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_border_style"]               = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_border_width"]               = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_color"]                      = "#ffffff";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_font"]                       = $un["schema"]["css_grid_label_font"];
            $un["schema"]["css_quicksearchdiv_dropdownitemover_font_size"]                  = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_text_shadow"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_font_weight"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_padding"]                    = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_spacing"]                    = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_text_decoration"]            = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_vertical_align"]             = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_margin"]                     = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_text_transform"]             = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_letter_spacing"]             = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_text_align"]                 = "left";
            $un["schema"]["css_quicksearchdiv_dropdownitemover_text_alignrtl"]              = "right";

            $un["schema"]["css_quicksearchdiv_dropdownitemselected_background_color"]       = "#ddd";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_background_image"]       = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_background_position"]    = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_background_repeat"]      = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_opacity"]                = "100";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_border_color"]           = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_border_style"]           = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_border_width"]           = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_color"]                  = "#888686";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_font"]                   = $un["schema"]["css_grid_label_font"];
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_font_size"]              = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_text_shadow"]            = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_font_weight"]            = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_padding"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_spacing"]                = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_text_decoration"]        = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_vertical_align"]         = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_margin"]                 = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_text_transform"]         = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_letter_spacing"]         = "";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_text_align"]             = "left";
            $un["schema"]["css_quicksearchdiv_dropdownitemselected_text_alignrtl"]          = "right";

            $un["schema"]["css_quicksearchdiv_toolbar_background_color"]                    = "";
            $un["schema"]["css_quicksearchdiv_toolbar_background_image"]                    = "";
            $un["schema"]["css_quicksearchdiv_toolbar_background_position"]                 = "";
            $un["schema"]["css_quicksearchdiv_toolbar_background_repeat"]                   = "";
            $un["schema"]["css_quicksearchdiv_toolbar_opacity"]                             = "100";
            $un["schema"]["css_quicksearchdiv_toolbar_color"]                               = "";
            $un["schema"]["css_quicksearchdiv_toolbar_font"]                                = $un["schema"]["css_grid_label_font"];
            $un["schema"]["css_quicksearchdiv_toolbar_font_size"]                           = "";
            $un["schema"]["css_quicksearchdiv_toolbar_text_shadow"]                         = "";
            $un["schema"]["css_quicksearchdiv_toolbar_font_weight"]                         = "";
            $un["schema"]["css_quicksearchdiv_toolbar_text_decoration"]                     = "";
            $un["schema"]["css_quicksearchdiv_toolbar_border_color"]                        = "";
            $un["schema"]["css_quicksearchdiv_toolbar_border_style"]                        = "";
            $un["schema"]["css_quicksearchdiv_toolbar_border_width"]                        = "";
            $un["schema"]["css_quicksearchdiv_toolbar_radius"]                              = "";
            $un["schema"]["css_quicksearchdiv_toolbar_padding"]                             = "8px 0";
            $un["schema"]["css_quicksearchdiv_toolbar_margin"]                              = "";
            $un["schema"]["css_quicksearchdiv_toolbar_text_align"]                          = "right";

            $un["schema"]["css_grid_toolbarinput_opacity"]                                  = "100";

            $un["schema"]["css_filter_objeto_impar_border_color"]                           = $un["schema"]["css_filter_toolbarinput_border_color"];
            $un["schema"]["css_filter_objeto_par_border_color"]                             = $un["schema"]["css_filter_toolbarinput_border_color"];

            if (isset($un["schema"]["css_form_table_margin"]) && $un["schema"]["css_form_table_margin"] == "20px auto") {
                $un["schema"]["css_form_table_margin"]                                      = "10px auto";
            }

            //END

            // BEGIN
            # Checks whether the theme has a light or dark background
            $color  = $un["schema"]["css_grid_pagina_background_color"];
            $color  = ($color != "" && strlen($color) >= "5") ? $color : "#FFFFFF";

            $r      = hexdec(substr($color,1,2));
            $g      = hexdec(substr($color,3,2));
            $b      = hexdec(substr($color,5,2));
            $calc   = ($r * 299 + $g * 587 + $b * 114) / 1000;


            if ($calc > 128) {
                # $un["schema"]["css_toast_table_background_color"]   = "#38485F"; //Dark

            } else {
                # $un["schema"]["css_toast_table_background_color"]   = "#FFFFFF"; //Light

            }
            // END

            # Apply changes
            //BEGIN
            $new = serialize($un);
            file_put_contents($schema, $new);

            if ($new != $content) {
                echo "Schema " . $un["schema"]["css_schema_info_name"] . " changed successfully!<br />";
            } else {
                echo "No changes to schema " . $un["schema"]["css_schema_info_name"] . ".<br />";
            }
            //END
        }
    }
?>